/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    public static int getWeek(Date date) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(date);
        return c.get(3);
    }

    public static int getDayOfYear(Date date) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.setTime(date);
        return c.get(6);
    }

    public static int getFirstDayOfWeek(int year, int week) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(year, 1, 1, 0, 0, 0);
        c.set(3, week);
        c.set(7, 2);
        int dayOfYear = c.get(6);
        if (c.get(1) < year) {
            Calendar x = Calendar.getInstance(Locale.US);
            x.set(c.get(1), 11, 31, 0, 0, 0);
            dayOfYear -= x.get(6);
        } else if (c.get(1) > year) {
            Calendar x = Calendar.getInstance(Locale.US);
            x.set(year, 11, 31, 0, 0, 0);
            dayOfYear += x.get(6);
        }
        return dayOfYear;
    }

    public static Date getDate(int year, int dayOfYear) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(year, 1, 1, 0, 0, 0);
        c.set(6, dayOfYear);
        return c.getTime();
    }

    public static Date getDate(int day, int month, int year) {
        return DateUtils.calendarFor(day, month, year).getTime();
    }

    public static Date getStartDate(int year, int week) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(year, 1, 1, 0, 0, 0);
        c.set(3, week);
        c.set(7, 1);
        c.add(6, 1);
        return c.getTime();
    }

    public static Date getEndDate(int year, int week) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(year, 1, 1, 0, 0, 0);
        c.set(3, week);
        c.set(7, 7);
        c.add(6, 1);
        return c.getTime();
    }

    public static Date getStartDate(int year, int week, int offset) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(year, 1, 1, 0, 0, 0);
        c.set(3, week);
        c.set(7, 1);
        c.add(6, 1 + offset);
        return c.getTime();
    }

    public static Date getEndDate(int year, int week, int offset) {
        Calendar c = Calendar.getInstance(Locale.US);
        c.set(year, 1, 1, 0, 0, 0);
        c.set(3, week);
        c.set(7, 7);
        c.add(6, 1 + offset);
        return c.getTime();
    }

    public static int getEndMonth(Date sessionEnd, int year, int excessDays) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(sessionEnd);
        cal.add(5, excessDays);
        int m = cal.get(2);
        if (cal.get(1) != year) {
            m += 12 * (cal.get(1) - year);
        }
        return m;
    }

    public static int getStartMonth(Date sessionBegin, int year, int excessDays) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(sessionBegin);
        cal.add(5, -excessDays);
        int m = cal.get(2);
        if (cal.get(1) != year) {
            m -= 12 * (year - cal.get(1));
        }
        return m;
    }

    public static int getNrDaysOfMonth(int month, int year) {
        Calendar cal = DateUtils.calendarForFirstDayOf(month, year);
        return cal.getActualMaximum(5);
    }

    private static Calendar calendarForFirstDayOf(int month, int year) {
        return DateUtils.calendarFor(1, month, year);
    }

    public static int calculateActualYear(int month, int year) {
        return year + (month < 0 ? month / 12 - 1 : (month >= 12 ? month / 12 : 0));
    }

    private static Calendar calendarFor(int day, int month, int year) {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.set(DateUtils.calculateActualYear(month, year), month < 0 ? 12 + month % 12 : month % 12, day, 0, 0, 0);
        cal.set(14, 0);
        return cal;
    }

    public static int getDayOfYear(int day, int month, int year) {
        int idx;
        block4: {
            int actualYear;
            Calendar cal = DateUtils.calendarFor(day, month, year);
            idx = cal.get(6);
            if (month >= 0 && month < 12) break block4;
            if (month < 0) {
                for (actualYear = DateUtils.calculateActualYear(month, year); actualYear < year; ++actualYear) {
                    cal.set(actualYear, 11, 31);
                    idx += -1 * cal.get(6);
                }
            } else {
                while (actualYear > year) {
                    cal.set(--actualYear, 11, 31);
                    idx += cal.get(6);
                }
            }
        }
        return idx - 1;
    }
}

