/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.hibernate.Transaction;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.CurriculumProjectionRule;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeCurriculaFromLastlikeDemands {
    protected static Logger sLog = Logger.getLogger(MakeCurriculaFromLastlikeDemands.class);
    private Long iSessionId = null;
    private float iShareLimit = 0.0f;
    private int iEnrlLimit = 1;
    private float iTotalShareLimit = 0.03f;

    public MakeCurriculaFromLastlikeDemands(Long sessionId, float totalShareLimit, float shareLimit, int enrlLimit) {
        this.iSessionId = sessionId;
        this.iTotalShareLimit = totalShareLimit;
        this.iShareLimit = shareLimit;
        this.iEnrlLimit = enrlLimit;
    }

    public MakeCurriculaFromLastlikeDemands(Long sessionId) {
        this(sessionId, ApplicationProperty.CurriculumLastLikeDemandsTotalShareLimit.floatValue().floatValue(), ApplicationProperty.CurriculumLastLikeDemandsShareLimit.floatValue().floatValue(), ApplicationProperty.CurriculumLastLikeDemandsEnrollmentLimit.intValue());
    }

    public Hashtable<AcademicArea, Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>>> loadLastLikeCurricula(org.hibernate.Session hibSession) {
        Hashtable<AcademicArea, Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>>> curricula = new Hashtable<AcademicArea, Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>>>();
        List demands = hibSession.createQuery("select a2, f2, m2, c, d.student.uniqueId from LastLikeCourseDemand d inner join d.student.areaClasfMajors acm, CourseOffering c,AcademicArea a2, AcademicClassification f2, PosMajor m2 where a2.session.uniqueId=:sessionId and a2.academicAreaAbbreviation=acm.academicArea.academicAreaAbbreviation and f2.session.uniqueId=:sessionId and f2.code=acm.academicClassification.code and m2.session.uniqueId=:sessionId and m2.code=acm.major.code and d.subjectArea.session.uniqueId=:sessionId and c.subjectArea=d.subjectArea and ((d.coursePermId=null and c.courseNbr=d.courseNbr) or  (d.coursePermId!=null and d.coursePermId=c.permId))").setLong("sessionId", this.iSessionId.longValue()).setFetchSize(1000).list();
        sLog.info((Object)("Processing " + demands.size() + " demands..."));
        for (Object[] o : demands) {
            Set<Long> students;
            Hashtable<CourseOffering, Set<Long>> courses;
            Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>> clasf;
            AcademicArea a = (AcademicArea)o[0];
            AcademicClassification f = (AcademicClassification)o[1];
            PosMajor m = (PosMajor)o[2];
            CourseOffering c = (CourseOffering)o[3];
            Long s = (Long)o[4];
            Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>> curacad = curricula.get(a);
            if (curacad == null) {
                curacad = new Hashtable();
                curricula.put(a, curacad);
            }
            if ((clasf = curacad.get(m)) == null) {
                clasf = new Hashtable();
                curacad.put(m, clasf);
            }
            if ((courses = clasf.get(f)) == null) {
                courses = new Hashtable();
                clasf.put(f, courses);
            }
            if ((students = courses.get(c)) == null) {
                students = new HashSet<Long>();
                courses.put(c, students);
            }
            students.add(s);
        }
        return curricula;
    }

    public Hashtable<AcademicArea, Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>>> loadRealCurricula(org.hibernate.Session hibSession) {
        Hashtable<AcademicArea, Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>>> curricula = new Hashtable<AcademicArea, Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>>>();
        List demands = hibSession.createQuery("select distinct a, c, s.uniqueId from CourseRequest r inner join r.courseDemand.student s inner join s.areaClasfMajors a inner join r.courseOffering c where s.session.uniqueId=:sessionId").setLong("sessionId", this.iSessionId.longValue()).setFetchSize(1000).list();
        sLog.info((Object)("Processing " + demands.size() + " demands..."));
        for (Object[] o : demands) {
            Set<Long> students;
            Hashtable<CourseOffering, Set<Long>> courses;
            Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>> clasf;
            StudentAreaClassificationMajor a = (StudentAreaClassificationMajor)o[0];
            CourseOffering c = (CourseOffering)o[1];
            Long s = (Long)o[2];
            Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>> curacad = curricula.get(a.getAcademicArea());
            if (curacad == null) {
                curacad = new Hashtable();
                curricula.put(a.getAcademicArea(), curacad);
            }
            if ((clasf = curacad.get(a.getMajor())) == null) {
                clasf = new Hashtable();
                curacad.put(a.getMajor(), clasf);
            }
            if ((courses = clasf.get(a.getAcademicClassification())) == null) {
                courses = new Hashtable();
                clasf.put(a.getAcademicClassification(), courses);
            }
            if ((students = courses.get(c)) == null) {
                students = new HashSet<Long>();
                courses.put(c, students);
            }
            students.add(s);
        }
        return curricula;
    }

    private void sortCourses(Set<CurriculumCourse> courses) {
        int ord = 0;
        for (CurriculumCourse c : new TreeSet<CurriculumCourse>(courses)) {
            c.setOrd(ord++);
        }
    }

    private void sortClassifications(Set<CurriculumClassification> classf) {
        int ord = 0;
        for (CurriculumClassification c : new TreeSet<CurriculumClassification>(classf)) {
            c.setOrd(ord++);
        }
    }

    private Hashtable<String, Hashtable<String, Float>> getRules(org.hibernate.Session hibSession, Long acadAreaId) {
        Hashtable<String, Hashtable<String, Float>> clasf2major2proj = new Hashtable<String, Hashtable<String, Float>>();
        for (CurriculumProjectionRule rule : hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.uniqueId=:acadAreaId").setLong("acadAreaId", acadAreaId.longValue()).setCacheable(true).list()) {
            String majorCode = rule.getMajor() == null ? "" : rule.getMajor().getCode();
            String clasfCode = rule.getAcademicClassification().getCode();
            Float projection = rule.getProjection();
            Hashtable<String, Float> major2proj = clasf2major2proj.get(clasfCode);
            if (major2proj == null) {
                major2proj = new Hashtable();
                clasf2major2proj.put(clasfCode, major2proj);
            }
            major2proj.put(majorCode, projection);
        }
        return clasf2major2proj;
    }

    public float getProjection(Hashtable<String, Hashtable<String, Float>> clasf2major2proj, String majorCode, String clasfCode) {
        if (clasf2major2proj == null || clasf2major2proj.isEmpty()) {
            return 1.0f;
        }
        Hashtable<String, Float> major2proj = clasf2major2proj.get(clasfCode);
        if (major2proj == null) {
            return 1.0f;
        }
        Float projection = major2proj.get(majorCode);
        if (projection == null) {
            projection = major2proj.get("");
        }
        return projection == null ? 1.0f : projection.floatValue();
    }

    public void update(org.hibernate.Session hibSession, boolean lastLike) {
        sLog.info((Object)"Deleting existing curricula...");
        Iterator i = hibSession.createQuery("select c from Curriculum c where c.department.session=:sessionId").setLong("sessionId", this.iSessionId.longValue()).list().iterator();
        while (i.hasNext()) {
            hibSession.delete(i.next());
        }
        hibSession.flush();
        sLog.info((Object)("Loading " + (lastLike ? "last-like" : "current") + " student enrollments..."));
        Hashtable<AcademicArea, Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>>> curricula = lastLike ? this.loadLastLikeCurricula(hibSession) : this.loadRealCurricula(hibSession);
        sLog.info((Object)"Creating curricula...");
        for (Map.Entry<AcademicArea, Hashtable<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>>> e1 : curricula.entrySet()) {
            Hashtable<String, Hashtable<String, Float>> rules = this.getRules(hibSession, e1.getKey().getUniqueId());
            for (Map.Entry<PosMajor, Hashtable<AcademicClassification, Hashtable<CourseOffering, Set<Long>>>> e2 : e1.getValue().entrySet()) {
                boolean bl;
                if (!e1.getKey().getPosMajors().contains(e2.getKey())) {
                    sLog.warn((Object)("Academic area " + e1.getKey().getAcademicAreaAbbreviation() + " - " + Constants.curriculaToInitialCase(e1.getKey().getTitle()) + " does not contain major " + e2.getKey().getCode() + " - " + Constants.curriculaToInitialCase(e2.getKey().getName())));
                    continue;
                }
                sLog.info((Object)("Creating curriculum " + e1.getKey().getAcademicAreaAbbreviation() + " (" + e1.getKey().getTitle() + ") - " + e2.getKey().getCode() + " (" + e2.getKey().getName() + ")"));
                Hashtable<Department, Integer> deptCounter = new Hashtable<Department, Integer>();
                Curriculum curriculum = new Curriculum();
                curriculum.setAcademicArea(e1.getKey());
                curriculum.setAbbv(e1.getKey().getAcademicAreaAbbreviation() + "/" + e2.getKey().getCode());
                curriculum.setName(Constants.curriculaToInitialCase(e1.getKey().getTitle() == null ? e1.getKey().getTitle() : e1.getKey().getTitle()) + " / " + Constants.curriculaToInitialCase(e2.getKey().getName()));
                if (curriculum.getName().length() > 60) {
                    curriculum.setName(curriculum.getName().substring(0, 60));
                }
                curriculum.setMultipleMajors(false);
                curriculum.setClassifications(new HashSet<CurriculumClassification>());
                curriculum.setMajors(new HashSet<PosMajor>());
                curriculum.getMajors().add(e2.getKey());
                Hashtable courseStudents = new Hashtable();
                HashSet studentsThisCurricula = new HashSet();
                for (Map.Entry<AcademicClassification, Hashtable<CourseOffering, Set<Long>>> e3 : e2.getValue().entrySet()) {
                    for (Map.Entry<CourseOffering, Set<Long>> e4 : e3.getValue().entrySet()) {
                        studentsThisCurricula.addAll(e4.getValue());
                        HashSet studentsThisCourse = (HashSet)courseStudents.get(e4.getKey());
                        if (studentsThisCourse == null) {
                            studentsThisCourse = new HashSet();
                            courseStudents.put(e4.getKey(), studentsThisCourse);
                        }
                        studentsThisCourse.addAll(e4.getValue());
                    }
                }
                for (Map.Entry<AcademicClassification, Hashtable<CourseOffering, Set<Long>>> e3 : e2.getValue().entrySet()) {
                    HashSet<Long> studentsThisCurriculaClassification = new HashSet<Long>();
                    for (Set<Long> students : e3.getValue().values()) {
                        studentsThisCurriculaClassification.addAll(students);
                    }
                    sLog.info((Object)("  " + e3.getKey().getCode() + " (" + e3.getKey().getName() + ") -- " + studentsThisCurriculaClassification.size() + " students"));
                    int projNrStudents = Math.round(this.getProjection(rules, e2.getKey().getCode(), e3.getKey().getCode()) * (float)studentsThisCurriculaClassification.size());
                    if (projNrStudents <= 0) continue;
                    CurriculumClassification clasf2 = new CurriculumClassification();
                    clasf2.setCurriculum(curriculum);
                    curriculum.getClassifications().add(clasf2);
                    clasf2.setAcademicClassification(e3.getKey());
                    clasf2.setName(e3.getKey().getCode());
                    clasf2.setCourses(new HashSet<CurriculumCourse>());
                    clasf2.setNrStudents(projNrStudents);
                    for (Map.Entry<CourseOffering, Set<Long>> e4 : e3.getValue().entrySet()) {
                        float totalShare;
                        float share = (float)e4.getValue().size() / (float)studentsThisCurriculaClassification.size();
                        if (share < this.iShareLimit && e4.getValue().size() < this.iEnrlLimit || (totalShare = (float)((Set)courseStudents.get(e4.getKey())).size() / (float)studentsThisCurricula.size()) < this.iTotalShareLimit) continue;
                        CurriculumCourse course = new CurriculumCourse();
                        course.setClassification(clasf2);
                        clasf2.getCourses().add(course);
                        course.setCourse(e4.getKey());
                        course.setPercShare(Float.valueOf(share));
                        Integer cx = (Integer)deptCounter.get(course.getCourse().getDepartment());
                        deptCounter.put(course.getCourse().getDepartment(), new Integer(((Set)courseStudents.get(e4.getKey())).size() + (cx == null ? 0 : cx)));
                    }
                }
                this.sortClassifications(curriculum.getClassifications());
                ArrayList<CurriculumCourseGroup> createdGroups = new ArrayList<CurriculumCourseGroup>();
                Hashtable<CourseOffering, Group[]> course2group = new Hashtable<CourseOffering, Group[]>();
                int id = 0;
                int totalStudents = 0;
                for (CurriculumClassification curriculumClassification : curriculum.getClassifications()) {
                    this.sortCourses(curriculumClassification.getCourses());
                    totalStudents += curriculumClassification.getNrStudents().intValue();
                    for (CurriculumCourse course : curriculumClassification.getCourses()) {
                        Group[] g = (Group[])course2group.get(course.getCourse());
                        if (g == null) {
                            g = new Group[]{new Group(id++, 0, course, new HashSet<Long>()), new Group(id++, 1, course, new HashSet<Long>())};
                            course2group.put(course.getCourse(), g);
                            continue;
                        }
                        g[0].getCourses().add(course);
                        g[1].getCourses().add(course);
                    }
                }
                ArrayList<Group> groups = new ArrayList<Group>();
                for (Group[] g : course2group.values()) {
                    CourseOffering course = g[0].getFistCourseOffering();
                    Set students = (Set)courseStudents.get(course);
                    double share = 100.0f * (float)students.size() / (float)totalStudents;
                    if (students.size() <= 5 || !(share >= 5.0)) continue;
                    g[0].getStudents().addAll(students);
                    groups.add(g[0]);
                    g[1].getStudents().addAll(students);
                    groups.add(g[1]);
                }
                do {
                    boolean bl2 = false;
                    Group b1 = null;
                    Object b2 = null;
                    double best = 0.0;
                    for (Group g1 : groups) {
                        for (Group group : groups) {
                            double share;
                            if (g1.getId() <= group.getId() || !((share = g1.share(group)) > best)) continue;
                            b1 = g1;
                            b2 = group;
                            best = share;
                        }
                    }
                    if (best >= 0.9) {
                        sLog.info((Object)("  -- merge " + new DecimalFormat("0.00").format(100.0 * best) + " " + b1 + " w " + b2));
                        b1.mergeWith((Group)b2);
                        groups.remove(b2);
                        sLog.info((Object)("     result: " + b1));
                        bl = true;
                        continue;
                    }
                    sLog.info((Object)("  -- best NOT merge " + new DecimalFormat("0.00").format(100.0 * best) + " " + b1 + " w " + b2));
                } while (bl);
                Hashtable<String, Integer> names = new Hashtable<String, Integer>();
                for (Group g : groups) {
                    if (g.countCourseOfferings() <= 1) continue;
                    sLog.info((Object)("  -- " + g));
                    CurriculumCourseGroup gr = new CurriculumCourseGroup();
                    String clasf4 = g.getLeadingClassificationName();
                    Integer cnt = (Integer)names.get((g.isSameStudents() ? "R" : "O") + " " + clasf4);
                    if (cnt == null) {
                        cnt = 1;
                    } else {
                        Iterator<CurriculumCourse> iterator = cnt;
                        Integer n = cnt = Integer.valueOf(cnt + 1);
                    }
                    gr.setName((g.isSameStudents() ? "R" : "O") + " " + clasf4 + " " + cnt);
                    names.put((g.isSameStudents() ? "R" : "O") + " " + clasf4, cnt);
                    gr.setType(g.getType());
                    gr.setCurriculum(curriculum);
                    createdGroups.add(gr);
                    for (CurriculumCourse curriculumCourse : g.getCourses()) {
                        if (curriculumCourse.getGroups() == null) {
                            curriculumCourse.setGroups(new HashSet<CurriculumCourseGroup>());
                        }
                        curriculumCourse.getGroups().add(gr);
                    }
                }
                Department dept = null;
                int best = 0;
                for (Map.Entry e3 : deptCounter.entrySet()) {
                    if (dept != null && best >= (Integer)e3.getValue()) continue;
                    dept = (Department)e3.getKey();
                    best = (Integer)e3.getValue();
                }
                curriculum.setDepartment(dept);
                if (dept == null) continue;
                hibSession.saveOrUpdate((Object)curriculum);
                for (CurriculumCourseGroup g : createdGroups) {
                    hibSession.saveOrUpdate((Object)g);
                }
            }
        }
        hibSession.flush();
        sLog.info((Object)"All done.");
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            props.setProperty("log4j.rootLogger", "DEBUG, A1");
            props.setProperty("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
            props.setProperty("log4j.appender.A1.layout", "org.apache.log4j.PatternLayout");
            props.setProperty("log4j.appender.A1.layout.ConversionPattern", "%-5p %c{2}: %m%n");
            props.setProperty("log4j.logger.org.hibernate", "INFO");
            props.setProperty("log4j.logger.org.hibernate.cfg", "WARN");
            props.setProperty("log4j.logger.org.hibernate.cache.EhCacheProvider", "ERROR");
            props.setProperty("log4j.logger.org.unitime.commons.hibernate", "INFO");
            props.setProperty("log4j.logger.net", "INFO");
            PropertyConfigurator.configure((Properties)props);
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            org.hibernate.Session hibSession = new _RootDAO().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2010"), ApplicationProperties.getProperty("term", "Spring"));
                if (session == null) {
                    sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                    System.exit(0);
                } else {
                    sLog.info((Object)("Session: " + session));
                }
                new MakeCurriculaFromLastlikeDemands(session.getUniqueId()).update(hibSession, "last-like".equals(ApplicationProperties.getProperty("tmtbl.curriculum.lldemands.students", "last-like")));
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Group {
        private int iId = 0;
        private int iType = 0;
        private List<CurriculumCourse> iCourses = new ArrayList<CurriculumCourse>();
        private Set<Long> iStudents = new HashSet<Long>();
        private double iShare = 1.0;

        public Group(int id, int type, CurriculumCourse course, Set<Long> students) {
            this.iId = id;
            this.iType = type;
            this.iStudents.addAll(students);
            this.iCourses.add(course);
        }

        public CourseOffering getFistCourseOffering() {
            return this.iCourses.get(0).getCourse();
        }

        protected HashSet<CourseOffering> courses() {
            HashSet<CourseOffering> courses = new HashSet<CourseOffering>();
            for (CurriculumCourse c : this.iCourses) {
                courses.add(c.getCourse());
            }
            return courses;
        }

        public int countCourseOfferings() {
            HashSet<CourseOffering> courses = new HashSet<CourseOffering>();
            for (CurriculumCourse c : this.iCourses) {
                courses.add(c.getCourse());
            }
            return courses.size();
        }

        protected Hashtable<String, int[]> getClassifications() {
            Hashtable<String, int[]> cnt = new Hashtable<String, int[]>();
            for (CurriculumCourse c : this.iCourses) {
                int[] other = cnt.get(c.getClassification().getName());
                cnt.put(c.getClassification().getName(), new int[]{Math.round(c.getPercShare().floatValue() * (float)c.getClassification().getNrStudents().intValue()) + (other == null ? 0 : other[0]), c.getClassification().getNrStudents() + (other == null ? 0 : other[1])});
            }
            return cnt;
        }

        public CurriculumClassification getClassification(String name) {
            for (CurriculumCourse c : this.iCourses) {
                if (!c.getClassification().getName().equals(name)) continue;
                return c.getClassification();
            }
            return null;
        }

        public String getLeadingClassificationName() {
            Hashtable<String, int[]> cnt = this.getClassifications();
            String best = null;
            int bestValue = 0;
            for (Map.Entry<String, int[]> e : cnt.entrySet()) {
                if (e.getValue()[0] <= bestValue) continue;
                bestValue = e.getValue()[0];
                best = e.getKey();
            }
            return best;
        }

        public float classificationShare(Group g) {
            float s1;
            Hashtable<String, int[]> a = this.getClassifications();
            Hashtable<String, int[]> b = g.getClassifications();
            int total1 = 0;
            int total2 = 0;
            int share = 0;
            for (Map.Entry<String, int[]> e : a.entrySet()) {
                s1 = (float)e.getValue()[0] / (float)e.getValue()[1];
                int[] c = b.get(e.getKey());
                float s2 = c == null ? 0.0f : (float)c[0] / (float)c[1];
                int x1 = Math.round(s1 * (float)this.getClassification(e.getKey()).getNrStudents().intValue());
                int x2 = Math.round(s2 * (float)this.getClassification(e.getKey()).getNrStudents().intValue());
                share += Math.min(x1, x2);
                total1 += x1;
            }
            for (Map.Entry<String, int[]> e : b.entrySet()) {
                s1 = (float)e.getValue()[0] / (float)e.getValue()[1];
                int x1 = Math.round(s1 * (float)g.getClassification(e.getKey()).getNrStudents().intValue());
                total2 += x1;
            }
            return (float)share / (float)Math.min(total1, total2);
        }

        public List<CurriculumCourse> getCourses() {
            return this.iCourses;
        }

        public int getId() {
            return this.iId;
        }

        public int getType() {
            return this.iType;
        }

        public Set<Long> getStudents() {
            return this.iStudents;
        }

        public boolean isSameStudents() {
            return this.iType == 1;
        }

        public double getShare() {
            return this.iShare;
        }

        public double share(Group g) {
            if (g.getType() != this.getType()) {
                return 0.0;
            }
            if ((double)this.classificationShare(g) < 0.66) {
                return 0.0;
            }
            int minStudents = Math.min(this.getStudents().size(), g.getStudents().size());
            int maxStudents = Math.max(this.getStudents().size(), g.getStudents().size());
            int shareStudents = 0;
            for (Long s : this.getStudents()) {
                if (!g.getStudents().contains(s)) continue;
                ++shareStudents;
            }
            double share = (double)shareStudents / (double)(this.isSameStudents() ? maxStudents : minStudents);
            return this.isSameStudents() ? share : 1.0 - share;
        }

        public void mergeWith(Group g) {
            int minStudents = Math.min(this.getStudents().size(), g.getStudents().size());
            int maxStudents = Math.max(this.getStudents().size(), g.getStudents().size());
            int shareStudents = 0;
            for (Long s : this.getStudents()) {
                if (!g.getStudents().contains(s)) continue;
                ++shareStudents;
            }
            double share = (double)shareStudents / (double)(this.isSameStudents() ? maxStudents : minStudents);
            if (!this.isSameStudents()) {
                share = 1.0 - share;
            }
            this.iStudents.addAll(g.getStudents());
            this.iCourses.addAll(g.getCourses());
            this.iShare *= share * g.getShare();
        }

        public String toString() {
            String courses = "";
            for (CourseOffering c : this.courses()) {
                if (!courses.isEmpty()) {
                    courses = courses + " + ";
                }
                courses = courses + c.getCourseName();
            }
            return (this.isSameStudents() ? "Req" : "Opt") + "{" + new DecimalFormat("0.0").format(100.0 * this.iShare) + "/" + this.iStudents.size() + " " + courses + "}";
        }
    }

    public static class AcademicAreaMajor {
        private AcademicArea iArea = null;
        private PosMajor iMajor = null;

        AcademicAreaMajor(AcademicArea area, PosMajor major) {
            this.iArea = area;
            this.iMajor = major;
        }

        public AcademicArea getArea() {
            return this.iArea;
        }

        public PosMajor getMajor() {
            return this.iMajor;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AcademicAreaMajor)) {
                return false;
            }
            AcademicAreaMajor a = (AcademicAreaMajor)o;
            return a.getMajor().equals(this.getMajor()) && a.getArea().equals(this.getArea());
        }

        public int hashCode() {
            return this.getArea().hashCode() ^ this.getMajor().hashCode();
        }
    }
}

