/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.cpsolver.ifs.util.DataProperties;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.Receiver;
import org.jgroups.SuspectedException;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.jgroups.blocks.mux.MuxUpHandler;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.commons.jgroups.UniTimeChannelLookup;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ApplicationConfig;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.jgroups.AbstractSolverServer;
import org.unitime.timetable.solver.jgroups.CourseSolverContainerRemote;
import org.unitime.timetable.solver.jgroups.ExaminationSolverContainerRemote;
import org.unitime.timetable.solver.jgroups.InstructorSchedulingContainerRemote;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingContainerRemote;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingGenericUpdater;
import org.unitime.timetable.solver.jgroups.RemoteRoomAvailability;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.StudentSolverContainerRemote;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.spring.SpringApplicationContextHolder;
import org.unitime.timetable.util.queue.QueueProcessor;
import org.unitime.timetable.util.queue.RemoteQueueProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverServerImplementation
extends AbstractSolverServer
implements MessageListener,
MembershipListener,
Receiver {
    private static Log sLog = LogFactory.getLog(SolverServerImplementation.class);
    private static SolverServerImplementation sInstance = null;
    public static final RequestOptions sFirstResponse = new RequestOptions(ResponseMode.GET_FIRST, (long)ApplicationProperty.SolverClusterTimeout.intValue().intValue()).setFlags(new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    public static final RequestOptions sAllResponses = new RequestOptions(ResponseMode.GET_ALL, (long)ApplicationProperty.SolverClusterTimeout.intValue().intValue()).setFlags(new Message.Flag[]{Message.Flag.DONT_BUNDLE, Message.Flag.OOB});
    private JChannel iChannel;
    private RpcDispatcher iDispatcher;
    private CourseSolverContainerRemote iCourseSolverContainer;
    private ExaminationSolverContainerRemote iExamSolverContainer;
    private StudentSolverContainerRemote iStudentSolverContainer;
    private InstructorSchedulingContainerRemote iInstructorSchedulingContainer;
    private OnlineStudentSchedulingContainerRemote iOnlineStudentSchedulingContainer;
    private RemoteRoomAvailability iRemoteRoomAvailability;
    private OnlineStudentSchedulingGenericUpdater iUpdater;
    private RemoteQueueProcessor iRemoteQueueProcessor;
    protected boolean iLocal = false;

    public SolverServerImplementation(boolean local, JChannel channel) {
        this.iLocal = local;
        this.iChannel = channel;
        this.iChannel.setUpHandler((UpHandler)new MuxUpHandler());
        this.iDispatcher = new MuxRpcDispatcher(0, (Channel)channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.iCourseSolverContainer = new CourseSolverContainerRemote(channel, 1, local);
        this.iExamSolverContainer = new ExaminationSolverContainerRemote(channel, 2);
        this.iStudentSolverContainer = new StudentSolverContainerRemote(channel, 3);
        this.iInstructorSchedulingContainer = new InstructorSchedulingContainerRemote(channel, 6);
        this.iOnlineStudentSchedulingContainer = new OnlineStudentSchedulingContainerRemote(channel, 5);
        this.iRemoteRoomAvailability = new RemoteRoomAvailability(channel, 4);
        this.iUpdater = new OnlineStudentSchedulingGenericUpdater(this.iDispatcher, this.iOnlineStudentSchedulingContainer);
        this.iRemoteQueueProcessor = new RemoteQueueProcessor(channel, 7);
    }

    public JChannel getChannel() {
        return this.iChannel;
    }

    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    @Override
    public void start() {
        this.iCourseSolverContainer.start();
        this.iExamSolverContainer.start();
        this.iStudentSolverContainer.start();
        this.iInstructorSchedulingContainer.start();
        this.iOnlineStudentSchedulingContainer.start();
        this.iUpdater.start();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.iCourseSolverContainer.stop();
        this.iExamSolverContainer.stop();
        this.iStudentSolverContainer.stop();
        this.iInstructorSchedulingContainer.stop();
        this.iOnlineStudentSchedulingContainer.stop();
        this.iUpdater.stopUpdating();
    }

    @Override
    public boolean isLocal() {
        return this.iLocal;
    }

    @Override
    public Address getAddress() {
        return this.iChannel.getAddress();
    }

    @Override
    public Address getLocalAddress() {
        if (this.isLocal()) {
            return this.getAddress();
        }
        try {
            RspList ret = this.iDispatcher.callRemoteMethods(null, "isLocal", new Object[0], new Class[0], sAllResponses);
            for (Rsp local : ret) {
                if (!Boolean.TRUE.equals(local.getValue())) continue;
                return local.getSender();
            }
            return null;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to retrieve local address: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isLocalCoordinator() {
        if (!this.isLocal()) {
            return false;
        }
        try {
            int myIndex = this.iChannel.getView().getMembers().indexOf(this.iChannel.getAddress());
            RspList ret = this.iDispatcher.callRemoteMethods(null, "isLocal", new Object[0], new Class[0], sAllResponses);
            for (Rsp local : ret) {
                int idx;
                if (!Boolean.TRUE.equals(local.getValue()) || (idx = this.iChannel.getView().getMembers().indexOf(local.getSender())) >= myIndex) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to retrieve local address: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public String getHost() {
        return this.iChannel.getAddressAsString();
    }

    @Override
    public int getUsage() {
        int ret = super.getUsage();
        ret += this.iCourseSolverContainer.getUsage();
        ret += this.iExamSolverContainer.getUsage();
        ret += this.iStudentSolverContainer.getUsage();
        ret += this.iInstructorSchedulingContainer.getUsage();
        return ret += this.iOnlineStudentSchedulingContainer.getUsage();
    }

    @Override
    public List<SolverServer> getServers(boolean onlyAvailable) {
        ArrayList<SolverServer> servers = new ArrayList<SolverServer>();
        if (!onlyAvailable || this.isActive()) {
            servers.add(this);
        }
        for (Address address : this.iChannel.getView().getMembers()) {
            if (address.equals(this.iChannel.getAddress())) continue;
            SolverServer server = this.crateServerProxy(address);
            if (onlyAvailable && !server.isAvailable()) continue;
            servers.add(server);
        }
        return servers;
    }

    @Override
    public SolverServer crateServerProxy(Address address) {
        ServerInvocationHandler handler = new ServerInvocationHandler(address);
        SolverServer px = (SolverServer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverServer.class}, (InvocationHandler)handler);
        return px;
    }

    @Override
    public SolverContainer<SolverProxy> getCourseSolverContainer() {
        return this.iCourseSolverContainer;
    }

    public SolverContainer<SolverProxy> createCourseSolverContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, this.iCourseSolverContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, handler);
        return px;
    }

    @Override
    public SolverContainer<ExamSolverProxy> getExamSolverContainer() {
        return this.iExamSolverContainer;
    }

    public SolverContainer<ExamSolverProxy> createExamSolverContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, this.iExamSolverContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, handler);
        return px;
    }

    @Override
    public SolverContainer<InstructorSchedulingProxy> getInstructorSchedulingContainer() {
        return this.iInstructorSchedulingContainer;
    }

    public SolverContainer<InstructorSchedulingProxy> createInstructorSchedulingContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, this.iInstructorSchedulingContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, handler);
        return px;
    }

    @Override
    public SolverContainer<StudentSolverProxy> getStudentSolverContainer() {
        return this.iStudentSolverContainer;
    }

    public SolverContainer<StudentSolverProxy> createStudentSolverContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, this.iStudentSolverContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, handler);
        return px;
    }

    @Override
    public SolverContainer<OnlineSectioningServer> getOnlineStudentSchedulingContainer() {
        return this.iOnlineStudentSchedulingContainer;
    }

    public SolverContainer<OnlineSectioningServer> createOnlineStudentSchedulingContainerProxy(Address address) {
        ContainerInvocationHandler handler = new ContainerInvocationHandler(this, address, this.iOnlineStudentSchedulingContainer);
        SolverContainer px = (SolverContainer)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{SolverContainer.class}, handler);
        return px;
    }

    @Override
    public RoomAvailabilityInterface getRoomAvailability() {
        if (this.isLocal()) {
            return super.getRoomAvailability();
        }
        Address local = this.getLocalAddress();
        if (local != null) {
            return (RoomAvailabilityInterface)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{RoomAvailabilityInterface.class}, (InvocationHandler)new RoomAvailabilityInvocationHandler(local, this.iRemoteRoomAvailability));
        }
        return null;
    }

    public void refreshCourseSolutionLocal(Long ... solutionIds) {
        if (this.isLocal()) {
            super.refreshCourseSolution(solutionIds);
        }
    }

    @Override
    public void refreshCourseSolution(Long ... solutionIds) {
        try {
            this.iDispatcher.callRemoteMethods(null, "refreshCourseSolutionLocal", new Object[]{solutionIds}, new Class[]{Long[].class}, sAllResponses);
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to refresh solution: " + e.getMessage()), (Throwable)e);
        }
    }

    public void refreshExamSolutionLocal(Long sessionId, Long examTypeId) {
        if (this.isLocal()) {
            super.refreshExamSolution(sessionId, examTypeId);
        }
    }

    @Override
    public void refreshExamSolution(Long sessionId, Long examTypeId) {
        try {
            this.iDispatcher.callRemoteMethods(null, "refreshExamSolutionLocal", new Object[]{sessionId, examTypeId}, new Class[]{Long.class, Long.class}, sAllResponses);
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to refresh solution: " + e.getMessage()), (Throwable)e);
        }
    }

    public void refreshInstructorSolutionLocal(Collection<Long> solverGroupIds) {
        if (this.isLocal()) {
            super.refreshInstructorSolution(solverGroupIds);
        }
    }

    @Override
    public void refreshInstructorSolution(Collection<Long> solverGroupIds) {
        try {
            this.iDispatcher.callRemoteMethods(null, "refreshInstructorSolutionLocal", new Object[]{solverGroupIds}, new Class[]{Collection.class}, sAllResponses);
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to refresh solution: " + e.getMessage()), (Throwable)e);
        }
    }

    public void viewAccepted(View view) {
        sLog.info((Object)("viewAccepted(" + view + ")"));
        if (view instanceof MergeView) {
            this.reset();
        }
    }

    public void suspect(Address suspected_mbr) {
        sLog.warn((Object)("suspect(" + suspected_mbr + ")"));
    }

    public void block() {
        sLog.info((Object)"block");
    }

    public void unblock() {
        sLog.info((Object)"unblock");
    }

    public void receive(Message msg) {
        sLog.info((Object)("receive(" + msg + ", " + msg.getObject() + ")"));
    }

    public void getState(OutputStream output) throws Exception {
    }

    public void setState(InputStream input) throws Exception {
    }

    @Override
    public void shutdown() {
        this.iActive = false;
        new ShutdownThread().start();
    }

    public static SolverServer getInstance() {
        if (sInstance == null && SpringApplicationContextHolder.isInitialized()) {
            return ((SolverServerService)SpringApplicationContextHolder.getBean("solverServerService")).getLocalServer();
        }
        return sInstance;
    }

    private static void configureLogging(Properties properties) {
        PropertyConfigurator.configure((Properties)properties);
        Logger log = Logger.getRootLogger();
        log.info((Object)"-----------------------------------------------------------------------");
        log.info((Object)"UniTime Log File");
        log.info((Object)"");
        log.info((Object)("Created: " + new Date()));
        log.info((Object)"");
        log.info((Object)"System info:");
        log.info((Object)("System:      " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch")));
        log.info((Object)("CPU:         " + System.getProperty("sun.cpu.isalist") + " endian:" + System.getProperty("sun.cpu.endian") + " encoding:" + System.getProperty("sun.io.unicode.encoding")));
        log.info((Object)("Java:        " + System.getProperty("java.vendor") + ", " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version", System.getProperty("java.version"))));
        log.info((Object)("User:        " + System.getProperty("user.name")));
        log.info((Object)("Timezone:    " + System.getProperty("user.timezone")));
        log.info((Object)("Working dir: " + System.getProperty("user.dir")));
        log.info((Object)("Classpath:   " + System.getProperty("java.class.path")));
        log.info((Object)("Memory:      " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB"));
        log.info((Object)("Cores:       " + Runtime.getRuntime().availableProcessors()));
        log.info((Object)"");
    }

    public static void main(String[] args) {
        try {
            if (ApplicationProperty.DataDir.value() == null) {
                ApplicationProperties.getDefaultProperties().setProperty(ApplicationProperty.DataDir.key(), ApplicationProperties.getProperty("tmtbl.solver.home", "."));
            }
            if (System.getProperty("catalina.base") == null) {
                ApplicationProperties.getDefaultProperties().setProperty("catalina.base", ApplicationProperty.DataDir.value());
            }
            SolverServerImplementation.configureLogging(ApplicationProperties.getDefaultProperties());
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            ApplicationConfig.configureLogging();
            final JChannel channel = (JChannel)new UniTimeChannelLookup().getJGroupsChannel(null);
            sInstance = new SolverServerImplementation(false, channel);
            channel.connect("UniTime:rpc");
            channel.getState(null, 0L);
            sInstance.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        sInstance.iActive = false;
                        sLog.info((Object)"Server is going down...");
                        sInstance.stop();
                        sLog.info((Object)"Disconnecting from the channel...");
                        channel.disconnect();
                        sLog.info((Object)"Closing the channel...");
                        channel.close();
                        sLog.info((Object)"Closing hibernate...");
                        HibernateUtil.closeHibernate();
                        sLog.info((Object)"This is the end.");
                    }
                    catch (Exception e) {
                        sLog.error((Object)("Failed to stop the server: " + e.getMessage()), (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to start the server: " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean isCoordinator() {
        return this.iUpdater != null && this.iUpdater.isCoordinator();
    }

    @Override
    public synchronized void reset() {
        sLog.info((Object)this.iOnlineStudentSchedulingContainer.getLockService().printLocks());
        for (String session : this.iOnlineStudentSchedulingContainer.getSolvers()) {
            OnlineSectioningServer server = this.iOnlineStudentSchedulingContainer.getSolver(session);
            if (server == null || !server.isMaster()) continue;
            sLog.info((Object)("Marking " + server.getAcademicSession() + " for reload"));
            server.setProperty("ReadyToServe", Boolean.FALSE);
            server.setProperty("ReloadIsNeeded", Boolean.TRUE);
            sLog.info((Object)("Releasing master lock for " + server.getAcademicSession() + " ..."));
            server.releaseMasterLockIfHeld();
        }
    }

    @Override
    public void setApplicationProperty(Long sessionId, String key, String value) {
        Properties properties;
        sLog.info((Object)("Set " + key + " to " + value + (sessionId == null ? "" : " (for session " + sessionId + ")")));
        Properties properties2 = properties = sessionId == null ? ApplicationProperties.getConfigProperties() : ApplicationProperties.getSessionProperties(sessionId);
        if (properties == null) {
            return;
        }
        if (value == null) {
            properties.remove(key);
        } else {
            properties.setProperty(key, value);
        }
    }

    @Override
    public void setLoggingLevel(String name, Integer level) {
        Logger logger;
        sLog.info((Object)("Set logging level for " + (name == null ? "root" : name) + " to " + (level == null ? "null" : Level.toLevel((int)level))));
        Logger logger2 = logger = name == null ? Logger.getRootLogger() : Logger.getLogger((String)name);
        if (level == null) {
            logger.setLevel(null);
        } else {
            logger.setLevel(Level.toLevel((int)level));
        }
    }

    @Override
    public QueueProcessor getQueueProcessor() {
        Address local = this.getLocalAddress();
        if (local != null) {
            return (QueueProcessor)Proxy.newProxyInstance(SolverServerImplementation.class.getClassLoader(), new Class[]{QueueProcessor.class}, (InvocationHandler)new QueueProcessorInvocationHandler(local, this.iRemoteQueueProcessor));
        }
        return super.getQueueProcessor();
    }

    public static class QueueProcessorInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private RemoteQueueProcessor iProcessor;

        private QueueProcessorInvocationHandler(Address address, RemoteQueueProcessor processor) {
            this.iAddress = address;
            this.iProcessor = processor;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.iProcessor.dispatch(this.iAddress, method, args);
        }
    }

    private class ShutdownThread
    extends Thread {
        ShutdownThread() {
            this.setName("SolverServer:Shutdown");
        }

        public void run() {
            try {
                try {
                    ShutdownThread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sLog.info((Object)"Server is going down...");
                SolverServerImplementation.this.stop();
                sLog.info((Object)"Disconnecting from the channel...");
                SolverServerImplementation.this.getChannel().disconnect();
                sLog.info((Object)"This is the end.");
                System.exit(0);
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to stop the server: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContainerInvocationHandler<T extends RemoteSolverContainer>
    implements InvocationHandler {
        private Address iAddress;
        private T iContainer;
        final /* synthetic */ SolverServerImplementation this$0;

        private ContainerInvocationHandler(Address address, T container) {
            this.this$0 = this$0;
            this.iAddress = address;
            this.iContainer = container;
        }

        public Object createSolver(String user, DataProperties config) throws Throwable {
            this.iContainer.getDispatcher().callRemoteMethod(this.iAddress, "createRemoteSolver", new Object[]{user, config, this.this$0.iChannel.getAddress()}, new Class[]{String.class, DataProperties.class, Address.class}, sFirstResponse);
            return this.iContainer.createProxy(this.iAddress, user);
        }

        public Address getAddress() {
            return this.iAddress;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public Object getSolver(String user) throws Exception {
            Boolean ret = (Boolean)this.iContainer.getDispatcher().callRemoteMethod(this.iAddress, "hasSolver", new Object[]{user}, new Class[]{String.class}, sFirstResponse);
            if (ret.booleanValue()) {
                return this.iContainer.createProxy(this.iAddress, user);
            }
            return null;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return this.iContainer.getDispatcher().callRemoteMethod(this.iAddress, method.getName(), args, (Class[])method.getParameterTypes(), sFirstResponse);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ServerInvocationHandler
    implements InvocationHandler {
        private Address iAddress;

        public ServerInvocationHandler(Address address) {
            this.iAddress = address;
        }

        public SolverContainer<SolverProxy> getCourseSolverContainer() {
            return SolverServerImplementation.this.createCourseSolverContainerProxy(this.iAddress);
        }

        public SolverContainer<ExamSolverProxy> getExamSolverContainer() {
            return SolverServerImplementation.this.createExamSolverContainerProxy(this.iAddress);
        }

        public SolverContainer<StudentSolverProxy> getStudentSolverContainer() {
            return SolverServerImplementation.this.createStudentSolverContainerProxy(this.iAddress);
        }

        public SolverContainer<InstructorSchedulingProxy> getInstructorSchedulingContainer() {
            return SolverServerImplementation.this.createInstructorSchedulingContainerProxy(this.iAddress);
        }

        public SolverContainer<OnlineSectioningServer> getOnlineStudentSchedulingContainer() {
            return SolverServerImplementation.this.createOnlineStudentSchedulingContainerProxy(this.iAddress);
        }

        public Address getAddress() {
            return this.iAddress;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public boolean isActive() throws Exception {
            try {
                Boolean active = (Boolean)SolverServerImplementation.this.iDispatcher.callRemoteMethod(this.iAddress, "isActive", new Object[0], new Class[0], sFirstResponse);
                return active;
            }
            catch (SuspectedException e) {
                return false;
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return SolverServerImplementation.this.iDispatcher.callRemoteMethod(this.iAddress, method.getName(), args, (Class[])method.getParameterTypes(), sFirstResponse);
            }
        }
    }

    public static class RoomAvailabilityInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private RemoteRoomAvailability iAvailability;

        private RoomAvailabilityInvocationHandler(Address address, RemoteRoomAvailability availability) {
            this.iAddress = address;
            this.iAvailability = availability;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.iAvailability.dispatch(this.iAddress, method, args);
        }
    }
}

