/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningQueueDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.updates.CheckAllOfferingsAction;
import org.unitime.timetable.onlinesectioning.updates.ClassAssignmentChanged;
import org.unitime.timetable.onlinesectioning.updates.ExpireReservationsAction;
import org.unitime.timetable.onlinesectioning.updates.PersistExpectedSpacesAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllStudents;
import org.unitime.timetable.onlinesectioning.updates.ReloadOfferingAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingContainer;
import org.unitime.timetable.solver.jgroups.OnlineStudentSchedulingContainerRemote;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;

public class OnlineStudentSchedulingUpdater
extends Thread {
    private Logger iLog;
    private long iSleepTimeInSeconds = 5L;
    private boolean iRun = true;
    private OnlineStudentSchedulingContainer iContainer = null;
    private AcademicSessionInfo iSession = null;
    private Date iLastTimeStamp = null;

    public OnlineStudentSchedulingUpdater(OnlineStudentSchedulingContainer container, AcademicSessionInfo session, Date lastTimeStamp) {
        this.iContainer = container;
        this.iSession = session;
        this.iLastTimeStamp = lastTimeStamp;
        this.setDaemon(true);
        this.setName("Updater[" + this.getAcademicSession().toCompactString() + "]");
        this.iSleepTimeInSeconds = ApplicationProperty.OnlineSchedulingQueueUpdateInterval.intValue().intValue();
        this.iLog = Logger.getLogger((String)(OnlineStudentSchedulingUpdater.class + ".updater[" + this.getAcademicSession().toCompactString() + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.iLog.info((Object)(this.getAcademicSession() + " updater started."));
                if (this.getAcademicSession() != null) {
                    ApplicationProperties.setSessionId(this.getAcademicSession().getUniqueId());
                }
                while (this.iRun) {
                    Object var4_5;
                    block15: {
                        block16: {
                            try {
                                OnlineStudentSchedulingUpdater.sleep(this.iSleepTimeInSeconds * 1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!this.iRun) break;
                            try {
                                OnlineSectioningServer server = this.iContainer.getInstance(this.getAcademicSession().getUniqueId());
                                if (server == null) break block15;
                                if (server.isMaster()) {
                                    this.checkForUpdates(server);
                                    if (!this.iRun) {
                                        var4_5 = null;
                                        break block16;
                                    }
                                    this.checkForExpiredReservations(server);
                                    this.persistExpectedSpaces(server);
                                    break block15;
                                }
                                if (ApplicationProperty.OnlineSchedulingServerReplicated.isTrue()) break block15;
                                try {
                                    this.iContainer.unload(this.getAcademicSession().getUniqueId(), false);
                                }
                                catch (Exception e) {
                                    this.iLog.error((Object)("Failed to unload server: " + e.getMessage()), (Throwable)e);
                                }
                                break block15;
                            }
                            catch (Throwable throwable) {
                                var4_5 = null;
                                _RootDAO.closeCurrentThreadSessions();
                                throw throwable;
                            }
                        }
                        _RootDAO.closeCurrentThreadSessions();
                        break;
                    }
                    var4_5 = null;
                    _RootDAO.closeCurrentThreadSessions();
                }
                this.iLog.info((Object)((this.getAcademicSession() == null ? "Generic" : this.getAcademicSession().toString()) + " updater stopped."));
            }
            catch (Exception e) {
                this.iLog.error((Object)((this.getAcademicSession() == null ? "Generic" : this.getAcademicSession().toString()) + " updater failed, " + e.getMessage()), (Throwable)e);
                Object var6_8 = null;
                ApplicationProperties.setSessionId(null);
                return;
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            ApplicationProperties.setSessionId(null);
            throw throwable;
        }
        ApplicationProperties.setSessionId(null);
    }

    public AcademicSessionInfo getAcademicSession() {
        return this.iSession;
    }

    public OnlineSectioningServer getServer() {
        if (this.getAcademicSession() == null) {
            return null;
        }
        return this.iContainer.getInstance(this.getAcademicSession().getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdates(OnlineSectioningServer server) {
        try {
            org.hibernate.Session hibSession = StudentSectioningQueueDAO.getInstance().createNewSession();
            try {
                this.iLastTimeStamp = server.getProperty("Updater.LastTimeStamp", this.iLastTimeStamp);
                for (StudentSectioningQueue q : StudentSectioningQueue.getItems(hibSession, this.getAcademicSession().getUniqueId(), this.iLastTimeStamp)) {
                    try {
                        this.processChange(server, q);
                    }
                    catch (Exception e) {
                        this.iLog.error((Object)("Update failed: " + e.getMessage()), (Throwable)e);
                    }
                    if (!this.iRun) break;
                    this.iLastTimeStamp = q.getTimeStamp();
                    server.setProperty("Updater.LastTimeStamp", this.iLastTimeStamp);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            {
            }
        }
        catch (Exception e) {
            this.iLog.error((Object)("Unable to check for updates: " + e.getMessage()), (Throwable)e);
        }
    }

    public void checkForExpiredReservations(OnlineSectioningServer server) {
        long ts = System.currentTimeMillis();
        Long lastReservationCheck = server.getProperty("Updater.LastReservationCheck", null);
        if (lastReservationCheck != null && ts - lastReservationCheck < 3600000L) {
            return;
        }
        if (Calendar.getInstance().get(11) == 0) {
            server.setProperty("Updater.LastReservationCheck", ts);
            try {
                server.execute(server.createAction(ExpireReservationsAction.class), this.user());
            }
            catch (Exception e) {
                this.iLog.error((Object)("Expire reservations failed: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected OnlineSectioningLog.Entity user() {
        return OnlineSectioningLog.Entity.newBuilder().setExternalId(StudentClassEnrollment.SystemChange.SYSTEM.name()).setName(StudentClassEnrollment.SystemChange.SYSTEM.getName()).setType(OnlineSectioningLog.Entity.EntityType.OTHER).build();
    }

    public void persistExpectedSpaces(OnlineSectioningServer server) {
        try {
            List<Long> offeringIds = server.getOfferingsToPersistExpectedSpaces(2000L * this.iSleepTimeInSeconds);
            if (!offeringIds.isEmpty()) {
                server.execute(server.createAction(PersistExpectedSpacesAction.class).forOfferings(offeringIds), this.user(), new OnlineSectioningServer.ServerCallback<Boolean>(){

                    @Override
                    public void onSuccess(Boolean result) {
                    }

                    @Override
                    public void onFailure(Throwable exception) {
                        OnlineStudentSchedulingUpdater.this.iLog.error((Object)("Failed to persist expected spaces: " + exception.getMessage()), exception);
                    }
                });
            }
        }
        catch (Exception e) {
            this.iLog.error((Object)("Failed to persist expected spaces: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void processChange(OnlineSectioningServer server, StudentSectioningQueue q) {
        switch (StudentSectioningQueue.Type.values()[q.getType()]) {
            case SESSION_RELOAD: {
                this.iLog.info((Object)("Reloading " + server.getAcademicSession()));
                server.execute(server.createAction(ReloadAllData.class), q.getUser());
                if (!server.getAcademicSession().isSectioningEnabled()) break;
                server.execute(server.createAction(CheckAllOfferingsAction.class), q.getUser());
                break;
            }
            case SESSION_STATUS_CHANGE: {
                Session session = (Session)SessionDAO.getInstance().get(this.iSession.getUniqueId());
                if (session == null || !session.getStatusType().canSectionAssistStudents() && !session.getStatusType().canOnlineSectionStudents()) {
                    if (this.iContainer instanceof OnlineStudentSchedulingContainerRemote) {
                        try {
                            ((OnlineStudentSchedulingContainerRemote)this.iContainer).getDispatcher().callRemoteMethods(null, "unload", new Object[]{session.getUniqueId(), false}, new Class[]{Long.class, Boolean.TYPE}, SolverServerImplementation.sAllResponses);
                        }
                        catch (Exception e) {
                            this.iLog.error((Object)("Failed to unload server: " + e.getMessage()), (Throwable)e);
                        }
                        break;
                    }
                    this.iContainer.unload(this.getAcademicSession().getUniqueId(), false);
                    break;
                }
                this.iLog.info((Object)("Session status changed for " + session.getLabel()));
                if (server.getAcademicSession().isSectioningEnabled() && !session.getStatusType().canOnlineSectionStudents()) {
                    server.releaseAllOfferingLocks();
                }
                this.getAcademicSession().update(session);
                server.setProperty("AcademicSession", this.getAcademicSession());
                break;
            }
            case STUDENT_ENROLLMENT_CHANGE: {
                List<Long> studentIds = q.getIds();
                if (studentIds == null || studentIds.isEmpty()) {
                    this.iLog.info((Object)("All students changed for " + server.getAcademicSession()));
                    server.execute(server.createAction(ReloadAllStudents.class), q.getUser());
                    break;
                }
                server.execute(server.createAction(ReloadStudent.class).forStudents(studentIds), q.getUser());
                break;
            }
            case CLASS_ASSIGNMENT_CHANGE: {
                server.execute(server.createAction(ClassAssignmentChanged.class).forClasses(q.getIds()), q.getUser());
                break;
            }
            case OFFERING_CHANGE: {
                server.execute(server.createAction(ReloadOfferingAction.class).forOfferings(q.getIds()), q.getUser());
                break;
            }
            default: {
                this.iLog.error((Object)("Student sectioning queue type " + (Object)((Object)StudentSectioningQueue.Type.values()[q.getType()]) + " not known."));
            }
        }
    }

    public void stopUpdating(boolean interrupt) {
        this.iRun = false;
        if (interrupt) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

