/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam.ui;

import java.io.Serializable;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.ifs.util.DistanceMetric;
import org.hibernate.Session;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.solver.exam.ui.ExamInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamRoomInfo
implements Serializable,
Comparable<ExamRoomInfo> {
    private static final long serialVersionUID = -5882156641099610154L;
    private Long iId = null;
    private String iName = null;
    private int iPreference = 0;
    private int iCapacity;
    private int iExamCapacity = 0;
    private Double iX = null;
    private Double iY = null;
    private transient Location iLocation = null;
    private static transient DistanceMetric sDistanceMetric = null;

    public ExamRoomInfo(ExamRoom room, int preference) {
        this.iId = room.getId();
        this.iName = room.getName();
        this.iCapacity = room.getSize();
        this.iExamCapacity = room.getAltSize();
        this.iPreference = preference;
        this.iX = room.getCoordX();
        this.iY = room.getCoordY();
    }

    public ExamRoomInfo(Location location, int preference) {
        this.iLocation = location;
        this.iId = location.getUniqueId();
        this.iName = location.getLabel();
        this.iCapacity = location.getCapacity();
        this.iExamCapacity = location.getExamCapacity() == null ? location.getCapacity() / 2 : location.getExamCapacity();
        this.iPreference = preference;
        this.iX = location.getCoordinateX();
        this.iY = location.getCoordinateY();
    }

    public Long getLocationId() {
        return this.iId;
    }

    public String getName() {
        return this.iName;
    }

    public int getPreference() {
        return this.iPreference;
    }

    public void setPreference(int preference) {
        this.iPreference = preference;
    }

    public int getCapacity() {
        return this.iCapacity;
    }

    public int getExamCapacity() {
        return this.iExamCapacity;
    }

    public int getCapacity(ExamInfo exam) {
        return exam.getSeatingType() == 1 ? this.getExamCapacity() : this.getCapacity();
    }

    public Location getLocation() {
        if (this.iLocation == null) {
            this.iLocation = (Location)new LocationDAO().get(this.getLocationId());
        }
        return this.iLocation;
    }

    public Location getLocation(Session hibSession) {
        return (Location)new LocationDAO().get(this.getLocationId(), hibSession);
    }

    public String toString() {
        return "<span style='color:" + PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(this.getPreference())) + ";' onmouseover=\"showGwtRoomHint(this, '" + this.getLocationId() + "', '" + PreferenceLevel.int2string(this.getPreference()) + "');\" onmouseout=\"hideGwtRoomHint();\">" + this.getName() + "</span>";
    }

    public String getNameWithHint(boolean pref) {
        return "<span" + (pref ? " style='color:" + PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(this.getPreference())) + ";'" : "") + " onmouseover=\"showGwtRoomHint(this, '" + this.getLocationId() + "', '" + PreferenceLevel.int2string(this.getPreference()) + "');\" onmouseout=\"hideGwtRoomHint();\">" + this.getName() + "</span>";
    }

    @Override
    public int compareTo(ExamRoomInfo room) {
        int cmp = -Double.compare(this.getCapacity(), room.getCapacity());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(room.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getLocationId().compareTo(room.getLocationId());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamRoomInfo)) {
            return false;
        }
        return this.getLocationId().equals(((ExamRoomInfo)o).getLocationId());
    }

    public int hashCode() {
        return this.getLocationId().hashCode();
    }

    public Double getCoordX() {
        return this.iX;
    }

    public Double getCoordY() {
        return this.iY;
    }

    public double getDistance(ExamRoomInfo other) {
        if (sDistanceMetric == null) {
            sDistanceMetric = new DistanceMetric(DistanceMetric.Ellipsoid.valueOf((String)ApplicationProperty.DistanceEllipsoid.value()));
        }
        return sDistanceMetric.getDistanceInMeters(this.getLocationId(), this.getCoordX(), this.getCoordY(), other.getLocationId(), other.getCoordX(), other.getCoordY());
    }
}

