/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.exam.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamProposedChange
implements Serializable,
Comparable<ExamProposedChange> {
    private static final long serialVersionUID = -5497603865422857068L;
    private Vector<ExamAssignmentInfo> iAssignments = null;
    private Vector<ExamAssignment> iConflicts = null;
    private Hashtable<Long, ExamAssignment> iInitials = null;
    private Long iSelectedExamId = null;
    private double iValue = 0.0;
    private int iNrAssigned = 0;

    public ExamProposedChange() {
        this.iAssignments = new Vector();
        this.iConflicts = new Vector();
        this.iInitials = new Hashtable();
    }

    public ExamProposedChange(ExamModel model, Assignment<Exam, ExamPlacement> assignment, Hashtable<Exam, ExamPlacement> initialAssignment, Hashtable<Exam, ExamAssignment> initialInfo, Collection<ExamPlacement> conflicts, Vector<Exam> resolvedExams) {
        ExamPlacement initial;
        ExamPlacement current;
        this.iValue = model.getTotalValue(assignment);
        this.iNrAssigned = model.nrAssignedVariables(assignment);
        if (conflicts != null) {
            this.iConflicts = new Vector();
            for (ExamPlacement conflict : conflicts) {
                this.iConflicts.add(initialInfo.get((Exam)conflict.variable()));
            }
        }
        this.iAssignments = new Vector();
        this.iInitials = new Hashtable();
        for (Exam exam : resolvedExams) {
            current = (ExamPlacement)assignment.getValue((Variable)exam);
            initial = initialAssignment.get(exam);
            if (initial == null) {
                this.iAssignments.add(new ExamAssignmentInfo(exam, current, assignment));
                continue;
            }
            if (initial.equals((Object)current)) continue;
            this.iAssignments.add(new ExamAssignmentInfo(exam, current, assignment));
            this.iInitials.put(exam.getId(), initialInfo.get(exam));
        }
        for (Exam exam : model.assignedVariables(assignment)) {
            if (resolvedExams.contains(exam)) continue;
            current = (ExamPlacement)assignment.getValue((Variable)exam);
            initial = initialAssignment.get(exam);
            if (initial == null) {
                this.iAssignments.add(new ExamAssignmentInfo(exam, current, assignment));
                continue;
            }
            if (initial.equals((Object)current)) continue;
            this.iAssignments.add(new ExamAssignmentInfo(exam, current, assignment));
            this.iInitials.put(exam.getId(), initialInfo.get(exam));
        }
    }

    public void addChange(ExamAssignmentInfo change, ExamAssignment initial) {
        for (ExamAssignment examAssignment : this.iAssignments) {
            if (!examAssignment.getExamId().equals(change.getExamId())) continue;
            this.iAssignments.remove(examAssignment);
            this.iInitials.remove(examAssignment.getExamId());
            break;
        }
        for (ExamAssignment examAssignment : this.iAssignments) {
            if (!examAssignment.getExamId().equals(change.getExamId())) continue;
            this.iConflicts.remove(examAssignment);
            break;
        }
        if (change.getPeriodId() != null) {
            this.iAssignments.add(change);
            if (initial != null && initial.getPeriodId() != null) {
                this.iInitials.put(initial.getExamId(), initial);
            }
        } else {
            this.iConflicts.add(initial);
        }
    }

    public boolean isEmpty() {
        return this.iConflicts.isEmpty() && this.iAssignments.isEmpty();
    }

    public boolean isBetter(ExamModel model, Assignment<Exam, ExamPlacement> assignment) {
        if (this.iNrAssigned > model.nrAssignedVariables(assignment)) {
            return true;
        }
        return this.iNrAssigned == model.nrAssignedVariables(assignment) && this.iValue < model.getTotalValue(assignment);
    }

    public Collection<ExamAssignment> getConflicts() {
        return this.iConflicts;
    }

    public Collection<ExamAssignmentInfo> getAssignments() {
        return this.iAssignments;
    }

    public Hashtable<Long, ExamAssignment> getAssignmentTable() {
        Hashtable<Long, ExamAssignment> table = new Hashtable<Long, ExamAssignment>();
        try {
            for (ExamAssignment examAssignment : this.iConflicts) {
                table.put(examAssignment.getExamId(), new ExamAssignment(examAssignment.getExam(), (ExamPeriod)null, null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ExamAssignment examAssignment : this.iAssignments) {
            table.put(examAssignment.getExamId(), examAssignment);
        }
        return table;
    }

    public ExamAssignment getInitial(ExamAssignment current) {
        return this.iInitials.get(current.getExamId());
    }

    public ExamAssignmentInfo getCurrent(ExamInfo exam) {
        return this.getCurrent(exam.getExamId());
    }

    public ExamAssignmentInfo getCurrent(Long examId) {
        for (ExamAssignmentInfo assignment : this.iAssignments) {
            if (!assignment.getExamId().equals(examId)) continue;
            return assignment;
        }
        return null;
    }

    public ExamAssignment getConflict(ExamInfo exam) {
        return this.getConflict(exam.getExamId());
    }

    public ExamAssignment getConflict(Long examId) {
        for (ExamAssignment conflict : this.iConflicts) {
            if (!conflict.getExamId().equals(examId)) continue;
            return conflict;
        }
        return null;
    }

    public ExamAssignment getInitial(Long currentId) {
        return this.iInitials.get(currentId);
    }

    public int getNrAssigned() {
        return this.iAssignments.size();
    }

    public int getNrUnassigned() {
        return this.iConflicts.size();
    }

    public double getValue() {
        double value = 0.0;
        for (ExamAssignment examAssignment : this.iConflicts) {
            value -= examAssignment.getPlacementValue();
        }
        for (ExamAssignment examAssignment : this.iAssignments) {
            value += examAssignment.getPlacementValue();
        }
        for (ExamAssignment examAssignment : this.iInitials.values()) {
            value -= examAssignment.getPlacementValue();
        }
        return value;
    }

    @Override
    public int compareTo(ExamProposedChange change) {
        int cmp = Double.compare(this.getNrUnassigned(), change.getNrUnassigned());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getValue(), change.getValue());
    }

    public void setSelected(Long examId) {
        this.iSelectedExamId = examId;
    }

    public String getHtmlTable() {
        String ret = "<table border='0' cellspacing='0' cellpadding='3' width='100%'>";
        ret = ret + "<tr>";
        ret = ret + "<td><i>Examination</i></td>";
        ret = ret + "<td><i>Period Change</i></td>";
        ret = ret + "<td><i>Room Change</i></td>";
        ret = ret + "<td><i>Direct</i></td>";
        ret = ret + "<td><i>&gt;2 A Day</i></td>";
        ret = ret + "<td><i>BTB</i></td>";
        ret = ret + "</tr>";
        for (ExamAssignment examAssignment : this.iAssignments) {
            ExamAssignment initial = this.iInitials.get(examAssignment.getExamId());
            String bgColor = examAssignment.getExamId().equals(this.iSelectedExamId) ? "rgb(168,187,225)" : null;
            ret = ret + "<tr " + (bgColor == null ? "" : "style=\"background-color:" + bgColor + ";\" ") + "onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';this.style.cursor='hand';this.style.cursor='pointer';\" onmouseout=\"this.style.backgroundColor='" + (bgColor == null ? "transparent" : bgColor) + "';\" onclick=\"document.location='examInfo.do?examId=" + examAssignment.getExamId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">";
            ret = ret + "<td nowrap>";
            ret = ret + "<img src='images/action_delete.png' border='0' onclick=\"document.location='examInfo.do?delete=" + examAssignment.getExamId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';event.cancelBubble=true;\">&nbsp;";
            ret = ret + examAssignment.getExamNameHtml();
            ret = ret + "</td><td nowrap>";
            if (initial != null && !initial.getPeriodId().equals(examAssignment.getPeriodId())) {
                ret = ret + initial.getPeriodAbbreviationWithPref() + " &rarr; ";
            }
            if (initial == null) {
                ret = ret + "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font> &rarr; ";
            }
            ret = ret + examAssignment.getPeriodAbbreviationWithPref();
            ret = ret + "</td><td nowrap>";
            if (initial != null && !initial.getRoomIds().equals(examAssignment.getRoomIds())) {
                ret = ret + initial.getRoomsNameWithPref(", ") + " &rarr; ";
            }
            if (initial == null) {
                ret = ret + "<font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font> &rarr; ";
            }
            ret = ret + examAssignment.getRoomsNameWithPref(", ");
            if (examAssignment.getNrRooms() == 0 && examAssignment.getMaxRooms() > 0) {
                ret = examAssignment.getExamId().equals(this.iSelectedExamId) ? ret + "<i>Select below ...</i>" : ret + "<i><font color='red'>Not selected ...</font></i>";
            }
            ret = ret + "</td><td nowrap>";
            ret = ret + ClassAssignmentDetails.dispNumberShort(false, initial == null ? 0 : initial.getPlacementNrDirectConflicts(), examAssignment.getPlacementNrDirectConflicts());
            ret = ret + "</td><td nowrap>";
            ret = ret + ClassAssignmentDetails.dispNumberShort(false, initial == null ? 0 : initial.getPlacementNrMoreThanTwoADayConflicts(), examAssignment.getPlacementNrMoreThanTwoADayConflicts());
            ret = ret + "</td><td nowrap>";
            ret = ret + ClassAssignmentDetails.dispNumberShort(false, initial == null ? 0 : initial.getPlacementNrBackToBackConflicts(), examAssignment.getPlacementNrBackToBackConflicts());
            if (examAssignment.getPlacementNrDistanceBackToBackConflicts() > 0) {
                ret = ret + " (d:" + ClassAssignmentDetails.dispNumberShort(false, initial == null ? 0 : initial.getPlacementNrDistanceBackToBackConflicts(), examAssignment.getPlacementNrDistanceBackToBackConflicts()) + ")";
            }
            ret = ret + "</td></tr>";
        }
        for (ExamAssignment examAssignment : this.iConflicts) {
            String bgColor = examAssignment.getExamId().equals(this.iSelectedExamId) ? "rgb(168,187,225)" : null;
            ret = ret + "<tr " + (bgColor == null ? "" : "style=\"background-color:" + bgColor + ";\" ") + "onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';this.style.cursor='hand';this.style.cursor='pointer';\" onmouseout=\"this.style.backgroundColor='" + (bgColor == null ? "transparent" : bgColor) + "';\" onclick=\"document.location='examInfo.do?examId=" + examAssignment.getExamId() + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">";
            ret = ret + "<td nowrap>";
            ret = ret + examAssignment.getExamNameHtml();
            ret = ret + "</td><td nowrap>";
            ret = ret + examAssignment.getPeriodAbbreviationWithPref() + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font></td>";
            ret = ret + "</td><td nowrap>";
            ret = ret + examAssignment.getRoomsNameWithPref(", ") + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>";
            ret = ret + "</td><td nowrap>";
            ret = ret + ClassAssignmentDetails.dispNumberShort(true, examAssignment.getPlacementNrDirectConflicts(), 0);
            ret = ret + "</td><td nowrap>";
            ret = ret + ClassAssignmentDetails.dispNumberShort(true, examAssignment.getPlacementNrMoreThanTwoADayConflicts(), 0);
            ret = ret + "</td><td nowrap>";
            ret = ret + ClassAssignmentDetails.dispNumberShort(true, examAssignment.getPlacementNrBackToBackConflicts(), 0);
            if (examAssignment.getPlacementNrDistanceBackToBackConflicts() > 0) {
                ret = ret + " (d:" + ClassAssignmentDetails.dispNumberShort(true, examAssignment.getPlacementNrDistanceBackToBackConflicts(), 0) + ")";
            }
            ret = ret + "</td></tr>";
        }
        ret = ret + "</table>";
        return ret;
    }

    public String getHtmlLine(int index) {
        String ret = "<tr onmouseover=\"this.style.backgroundColor='rgb(223,231,242)';this.style.cursor='hand';this.style.cursor='pointer';\" onmouseout=\"this.style.backgroundColor='transparent';\" onclick=\"document.location='examInfo.do?suggestion=" + index + "&op=Select&noCacheTS=" + new Date().getTime() + "';\">";
        String name = "";
        String period = "";
        String room = "";
        String dc = "";
        String btb = "";
        String m2d = "";
        for (ExamAssignment examAssignment : this.iAssignments) {
            ExamAssignment initial = this.iInitials.get(examAssignment.getExamId());
            if (name.length() > 0) {
                name = name + "<br>";
                period = period + "<br>";
                room = room + "<br>";
                dc = dc + "<br>";
                m2d = m2d + "<br>";
                btb = btb + "<br>";
            }
            name = name + examAssignment.getExamNameHtml();
            if (initial != null && !initial.getPeriodId().equals(examAssignment.getPeriodId())) {
                period = period + initial.getPeriodAbbreviationWithPref() + " &rarr; ";
            }
            period = period + examAssignment.getPeriodAbbreviationWithPref();
            if (initial != null && !initial.getRoomIds().equals(examAssignment.getRoomIds())) {
                room = room + initial.getRoomsNameWithPref(", ") + " &rarr; ";
            }
            room = room + examAssignment.getRoomsNameWithPref(", ");
            dc = dc + ClassAssignmentDetails.dispNumberShort(false, initial == null ? 0 : initial.getPlacementNrDirectConflicts(), examAssignment.getPlacementNrDirectConflicts());
            m2d = m2d + ClassAssignmentDetails.dispNumberShort(false, initial == null ? 0 : initial.getPlacementNrMoreThanTwoADayConflicts(), examAssignment.getPlacementNrMoreThanTwoADayConflicts());
            btb = btb + ClassAssignmentDetails.dispNumberShort(false, initial == null ? 0 : initial.getPlacementNrBackToBackConflicts(), examAssignment.getPlacementNrBackToBackConflicts());
            if (examAssignment.getPlacementNrDistanceBackToBackConflicts() <= 0) continue;
            btb = btb + " (d:" + ClassAssignmentDetails.dispNumberShort(false, initial == null ? 0 : initial.getPlacementNrDistanceBackToBackConflicts(), examAssignment.getPlacementNrDistanceBackToBackConflicts()) + ")";
        }
        for (ExamAssignment examAssignment : this.iConflicts) {
            if (name.length() > 0) {
                name = name + "<br>";
                period = period + "<br>";
                room = room + "<br>";
                dc = dc + "<br>";
                m2d = m2d + "<br>";
                btb = btb + "<br>";
            }
            name = name + examAssignment.getExamNameHtml();
            period = period + examAssignment.getPeriodAbbreviationWithPref() + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font></td>";
            room = room + examAssignment.getRoomsNameWithPref(", ") + " &rarr; <font color='" + PreferenceLevel.prolog2color("P") + "'><i>not-assigned</i></font>";
            dc = dc + ClassAssignmentDetails.dispNumberShort(true, examAssignment.getPlacementNrDirectConflicts(), 0);
            m2d = m2d + ClassAssignmentDetails.dispNumberShort(true, examAssignment.getPlacementNrMoreThanTwoADayConflicts(), 0);
            btb = btb + ClassAssignmentDetails.dispNumberShort(true, examAssignment.getPlacementNrBackToBackConflicts(), 0);
            if (examAssignment.getPlacementNrDistanceBackToBackConflicts() <= 0) continue;
            btb = btb + " (d:" + ClassAssignmentDetails.dispNumberShort(true, examAssignment.getPlacementNrDistanceBackToBackConflicts(), 0) + ")";
        }
        ret = ret + "<td align='right' width='1%' nowrap>" + ClassAssignmentDetails.dispNumber(Math.round(this.getValue())) + "</td><td nowrap>";
        ret = ret + name;
        ret = ret + "</td><td nowrap>";
        ret = ret + period;
        ret = ret + "</td><td nowrap>";
        ret = ret + room;
        ret = ret + "</td><td nowrap>";
        ret = ret + dc;
        ret = ret + "</td><td nowrap>";
        ret = ret + m2d;
        ret = ret + "</td><td nowrap>";
        ret = ret + btb;
        ret = ret + "</td></tr>";
        return ret;
    }

    public String toString(String delim) {
        String ret = "";
        for (ExamAssignment examAssignment : this.iConflicts) {
            if (ret.length() > 0) {
                ret = ret + delim;
            }
            ret = ret + examAssignment.getExamName() + " " + examAssignment.getPeriodName() + " " + examAssignment.getRoomsName(", ") + " -> Not Assigned";
        }
        for (ExamAssignment examAssignment : this.iAssignments) {
            if (ret.length() > 0) {
                ret = ret + delim;
            }
            ExamAssignment initial = this.iInitials.get(examAssignment.getExamId());
            ret = ret + examAssignment.getExamName() + " " + (initial == null ? "Not Assigned" : initial.getPeriodName() + " " + initial.getRoomsName(", ")) + " -> " + examAssignment.getPeriodName() + " " + examAssignment.getRoomsName(", ");
        }
        return ret;
    }

    public String toString() {
        return this.toString("\n");
    }

    public boolean isUnassigned(Long examId) {
        for (ExamAssignment conflict : this.getConflicts()) {
            if (!examId.equals(conflict.getExamId())) continue;
            return true;
        }
        return false;
    }
}

