/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import java.io.Serializable;
import java.util.Map;
import org.cpsolver.coursett.criteria.StudentCommittedConflict;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.criteria.StudentDistanceConflict;
import org.cpsolver.coursett.criteria.StudentHardConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.solution.Solution;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.CPSolverMessages;
import org.unitime.timetable.util.NameFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iInstructorNameFormat = NameFormat.SHORT.reference();
    private transient Map<String, String> iCourseObjectives = null;
    private double iBaseStudentConflicts;
    private double iBaseStudentConflictsCommitted;
    private double iBaseStudentConflictsDistance;
    private double iBaseStudentConflictsHard;

    public String getInstructorNameFormat() {
        return this.iInstructorNameFormat;
    }

    public void setInstructorNameFormat(String format) {
        this.iInstructorNameFormat = format;
    }

    public Map<String, String> courseObjectives() {
        if (this.iCourseObjectives == null) {
            this.iCourseObjectives = Localization.create(CPSolverMessages.class).courseObjectives();
        }
        return this.iCourseObjectives;
    }

    public void setBaseStudentConflicts(Solution<Lecture, Placement> solution) {
        Model model = solution.getModel();
        Assignment assignment = solution.getAssignment();
        Criterion sc = model.getCriterion(StudentConflict.class);
        Criterion shc = model.getCriterion(StudentHardConflict.class);
        Criterion sdc = model.getCriterion(StudentDistanceConflict.class);
        Criterion scc = model.getCriterion(StudentCommittedConflict.class);
        this.iBaseStudentConflicts = (scc == null ? 0.0 : scc.getValue(assignment)) + (sc == null ? 0.0 : sc.getValue(assignment));
        this.iBaseStudentConflictsCommitted = scc == null ? 0.0 : scc.getValue(assignment);
        this.iBaseStudentConflictsDistance = sdc == null ? 0.0 : sdc.getValue(assignment);
        this.iBaseStudentConflictsHard = shc == null ? 0.0 : shc.getValue(assignment);
    }

    public double getBaseStudentConflicts() {
        return this.iBaseStudentConflicts;
    }

    public double getBaseStudentConflictsCommitted() {
        return this.iBaseStudentConflictsCommitted;
    }

    public double getBaseStudentConflictsDistance() {
        return this.iBaseStudentConflictsDistance;
    }

    public double getBaseStudentConflictsHard() {
        return this.iBaseStudentConflictsHard;
    }
}

