/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.solver.SolverPageBackend;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=CourseTimetablingSolverInterface.ConflictStatisticsFilterRequest.class)
public class ConflictStatisticsFilterBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.ConflictStatisticsFilterRequest, CourseTimetablingSolverInterface.ConflictStatisticsFilterResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    @Override
    public CourseTimetablingSolverInterface.ConflictStatisticsFilterResponse execute(CourseTimetablingSolverInterface.ConflictStatisticsFilterRequest request, SessionContext context) {
        context.checkPermission(Right.ConflictStatistics);
        CourseTimetablingSolverInterface.ConflictStatisticsFilterResponse response = new CourseTimetablingSolverInterface.ConflictStatisticsFilterResponse();
        FilterInterface.FilterParameterInterface mode = new FilterInterface.FilterParameterInterface();
        mode.setName("mode");
        mode.setType("list");
        mode.setMultiSelect(false);
        mode.addOption("0", MESSAGES.modeCBSVariables());
        mode.addOption("1", MESSAGES.modeCBSConstraints());
        mode.setDefaultValue(context.getUser().getProperty("Cbs.type", "0"));
        mode.setLabel(MESSAGES.propConflictStatisticsMode());
        response.addParameter(mode);
        FilterInterface.FilterParameterInterface limit = new FilterInterface.FilterParameterInterface();
        limit.setName("limit");
        limit.setType("double");
        limit.setDefaultValue(context.getUser().getProperty("Cbs.limit", "25.0"));
        limit.setLabel(MESSAGES.propConflictStatisticsLimit());
        limit.setSuffix(CONSTANTS.percentageSign());
        response.addParameter(limit);
        SuggestionsInterface.SuggestionProperties properties = new SuggestionsInterface.SuggestionProperties();
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(false)) {
            properties.addPreference(new SuggestionsInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2color(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), Constants.preference2preferenceLevel((String)pref.getPrefProlog())));
        }
        properties.setSolver(this.courseTimetablingSolverService.getSolver() != null);
        response.setSuggestionProperties(properties);
        properties.setFirstDay(ApplicationProperty.TimePatternFirstDayOfWeek.intValue());
        SolverPageBackend.fillSolverWarnings(context, this.courseTimetablingSolverService.getSolver(), SolverInterface.SolverType.COURSE, response);
        return response;
    }
}

