/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.solver;

import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CourseTimetablingSolverInterface;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=CourseTimetablingSolverInterface.AssignedClassesFilterRequest.class)
public class AssignedClassesFilterBackend
implements GwtRpcImplementation<CourseTimetablingSolverInterface.AssignedClassesFilterRequest, CourseTimetablingSolverInterface.AssignedClassesFilterResponse> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public CourseTimetablingSolverInterface.AssignedClassesFilterResponse execute(CourseTimetablingSolverInterface.AssignedClassesFilterRequest request, SessionContext context) {
        context.checkPermission(Right.AssignedClasses);
        CourseTimetablingSolverInterface.AssignedClassesFilterResponse response = new CourseTimetablingSolverInterface.AssignedClassesFilterResponse();
        FilterInterface.FilterParameterInterface simplifiedMode = new FilterInterface.FilterParameterInterface();
        simplifiedMode.setName("simpleMode");
        simplifiedMode.setType("boolean");
        simplifiedMode.setLabel(MESSAGES.propCourseTimetablingSolverSimplifiedMode());
        simplifiedMode.setDefaultValue(context.getUser().getProperty("SuggestionsModel.simpleMode", "0"));
        response.addParameter(simplifiedMode);
        FilterInterface.FilterParameterInterface subjectArea = new FilterInterface.FilterParameterInterface();
        subjectArea.setName("subjectArea");
        subjectArea.setType("list");
        subjectArea.setMultiSelect(true);
        subjectArea.setCollapsible(false);
        subjectArea.setLabel(MESSAGES.propSubjectArea());
        subjectArea.addOption(Constants.ALL_OPTION_VALUE, MESSAGES.itemAllSubjectAreas());
        for (SubjectArea subject : SubjectArea.getUserSubjectAreas(context.getUser())) {
            subjectArea.addOption(subject.getUniqueId().toString(), subject.getSubjectAreaAbbreviation());
        }
        subjectArea.setDefaultValue((String)context.getAttribute(SessionAttribute.OfferingsSubjectArea));
        response.addParameter(subjectArea);
        for (PreferenceLevel pref : PreferenceLevel.getPreferenceLevelList(true)) {
            response.addPreference(new RoomInterface.PreferenceInterface(pref.getUniqueId(), PreferenceLevel.prolog2bgColor(pref.getPrefProlog()), pref.getPrefProlog(), pref.getPrefName(), pref.getAbbreviation(), false));
        }
        return response;
    }
}

