/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.pointintimedata;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.PointInTimeDataReportsInterface;
import org.unitime.timetable.reports.pointintimedata.BasePointInTimeDataReports;
import org.unitime.timetable.security.SessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=PointInTimeDataReportsInterface.PITDParametersRpcRequest.class)
public class PITDParametersBackend
implements GwtRpcImplementation<PointInTimeDataReportsInterface.PITDParametersRpcRequest, PointInTimeDataReportsInterface.PITDParametersInterface> {
    protected static GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    @Autowired
    private SessionContext sessionContext;

    @Override
    @PreAuthorize(value="checkPermission('PointInTimeDataReports')")
    public PointInTimeDataReportsInterface.PITDParametersInterface execute(PointInTimeDataReportsInterface.PITDParametersRpcRequest request, SessionContext context) {
        PointInTimeDataReportsInterface.PITDParametersInterface ret = new PointInTimeDataReportsInterface.PITDParametersInterface();
        for (BasePointInTimeDataReports.Parameter p : BasePointInTimeDataReports.Parameter.values()) {
            if (!p.allowSingleSelection() && !p.allowMultiSelection()) continue;
            PointInTimeDataReportsInterface.Parameter parameter = new PointInTimeDataReportsInterface.Parameter();
            parameter.setMultiSelect(p.allowMultiSelection());
            parameter.setName(this.getLocalizedText(p));
            parameter.setType(p.name());
            parameter.setTextField(p.isTextField());
            parameter.setDefaultTextValue(p.defaultValue(this.sessionContext.getUser()));
            Map<Long, String> values = p.values(this.sessionContext.getUser());
            if (p.isTextField()) {
                ret.addParameter(parameter);
            }
            if (values == null || values.isEmpty()) continue;
            for (Map.Entry<Long, String> e : values.entrySet()) {
                PointInTimeDataReportsInterface.IdValue v = new PointInTimeDataReportsInterface.IdValue();
                v.setText(e.getValue());
                v.setValue(e.getKey().toString());
                parameter.values().add(v);
            }
            Collections.sort(parameter.values());
            ret.addParameter(parameter);
        }
        ret.setEditable(false);
        return ret;
    }

    private String getLocalizedText(BasePointInTimeDataReports.Parameter parameter) {
        switch (parameter) {
            case PITD: {
                return MESSAGES.optionPointInTimeData();
            }
            case PITD2: {
                return MESSAGES.optionPointInTimeDataComparison();
            }
            case BUILDING: {
                return MESSAGES.optionBuilding();
            }
            case BUILDINGS: {
                return MESSAGES.optionBuildings();
            }
            case DEPARTMENT: {
                return MESSAGES.optionDepartment();
            }
            case DEPARTMENTS: {
                return MESSAGES.optionDepartments();
            }
            case ROOM: {
                return MESSAGES.optionRoom();
            }
            case ROOMS: {
                return MESSAGES.optionRooms();
            }
            case SESSION: {
                return MESSAGES.optionAcademicSession();
            }
            case SUBJECT: {
                return MESSAGES.optionSubjectArea();
            }
            case SUBJECTS: {
                return MESSAGES.optionSubjectAreas();
            }
            case MINUTES_IN_REPORTING_HOUR: {
                return MESSAGES.optionMinutesInReportingHour();
            }
            case WEEKS_IN_REPORTING_TERM: {
                return MESSAGES.optionWeeksInReportingTerm();
            }
            case MINIMUM_LOCATION_CAPACITY: {
                return MESSAGES.optionMinimumLocationCapacity();
            }
            case MAXIMUM_LOCATION_CAPACITY: {
                return MESSAGES.optionMaximumLocationCapacity();
            }
            case DistributionType: {
                return MESSAGES.optionDistributionType();
            }
            case DistributionTypes: {
                return MESSAGES.optionDistributionTypes();
            }
            case DemandOfferingType: {
                return MESSAGES.optionDemandOfferingType();
            }
            case DemandOfferingTypes: {
                return MESSAGES.optionDemandOfferingTypes();
            }
            case OfferingConsentType: {
                return MESSAGES.optionOfferingConsentType();
            }
            case OfferingConsentTypes: {
                return MESSAGES.optionOfferingConsentTypes();
            }
            case CourseCreditFormat: {
                return MESSAGES.optionCourseCreditFormat();
            }
            case CourseCreditFormats: {
                return MESSAGES.optionCourseCreditFormats();
            }
            case CourseCreditType: {
                return MESSAGES.optionCourseCreditType();
            }
            case CourseCreditTypes: {
                return MESSAGES.optionCourseCreditTypes();
            }
            case CourseCreditUnitType: {
                return MESSAGES.optionCourseCreditUnitType();
            }
            case CourseCreditUnitTypes: {
                return MESSAGES.optionCourseCreditUnitTypes();
            }
            case PositionType: {
                return MESSAGES.optionPositionType();
            }
            case PositionTypes: {
                return MESSAGES.optionPositionTypes();
            }
            case DepartmentStatusType: {
                return MESSAGES.optionDepartmentStatusType();
            }
            case DepartmentStatusTypes: {
                return MESSAGES.optionDepartmentStatusTypes();
            }
            case RoomType: {
                return MESSAGES.optionRoomType();
            }
            case RoomTypes: {
                return MESSAGES.optionRoomTypes();
            }
            case StudentSectioningStatus: {
                return MESSAGES.optionStudentSectioningStatus();
            }
            case StudentSectioningStatuses: {
                return MESSAGES.optionStudentSectioningStatuses();
            }
            case ExamType: {
                return MESSAGES.optionExamType();
            }
            case ExamTypes: {
                return MESSAGES.optionExamTypes();
            }
            case RoomFeatureType: {
                return MESSAGES.optionRoomFeatureType();
            }
            case RoomFeatureTypes: {
                return MESSAGES.optionRoomFeatureTypes();
            }
            case CourseType: {
                return MESSAGES.optionCourseType();
            }
            case CourseTypes: {
                return MESSAGES.optionCourseTypes();
            }
        }
        return parameter.text();
    }
}

