/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.PersonInterface;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.interfaces.ExternalUidTranslation;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.EventContactDAO;
import org.unitime.timetable.model.dao.StaffDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.spring.SpringApplicationContextHolder;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=PersonInterface.LookupRequest.class)
public class PeopleLookupBackend
implements GwtRpcImplementation<PersonInterface.LookupRequest, GwtRpcResponseList<PersonInterface>>,
ExternalUidLookup {
    private static Logger sLog = Logger.getLogger(PeopleLookupBackend.class);
    private ExternalUidTranslation iTranslation;
    private LdapTemplate iLdapTemplate;
    private SearchControls iSearchControls;
    @Autowired
    private ApplicationContext applicationContext;

    public PeopleLookupBackend() {
        if (ApplicationProperty.ExternalUserIdTranslation.value() != null) {
            try {
                this.iTranslation = (ExternalUidTranslation)Class.forName(ApplicationProperty.ExternalUserIdTranslation.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to instantiate external uid translation class, " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected Long getAcademicSessionId(SessionContext context) {
        if (context == null) {
            return null;
        }
        UserContext user = context.getUser();
        if (user == null) {
            throw new GwtRpcException("not authenticated");
        }
        if (user.getCurrentAuthority() == null) {
            throw new GwtRpcException("insufficient rights");
        }
        Long sessionId = user.getCurrentAcademicSessionId();
        if (sessionId == null) {
            throw new GwtRpcException("academic session not selected");
        }
        return sessionId;
    }

    @Override
    public GwtRpcResponseList<PersonInterface> execute(PersonInterface.LookupRequest request, SessionContext context) {
        try {
            if (context != null) {
                context.checkPermission(Right.HasRole);
            }
            SearchContext cx = new SearchContext();
            cx.setSessionId(this.getAcademicSessionId(context));
            cx.setLimit(ApplicationProperty.PeopleLookupLimit.intValue());
            cx.setQuery(request.getQuery().trim().toLowerCase());
            if (cx.getQueryTokens().isEmpty()) {
                return new GwtRpcResponseList<PersonInterface>();
            }
            if (context != null) {
                cx.setAdmin(context.hasPermission(Right.IsAdmin));
            }
            boolean displayWithoutId = true;
            String[] sources = null;
            if (request.hasOptions()) {
                for (String option : request.getOptions().split(",")) {
                    if ((option = option.trim()).equals("mustHaveExternalId")) {
                        displayWithoutId = false;
                        continue;
                    }
                    if (option.equals("allowNoExternalId")) {
                        displayWithoutId = true;
                        continue;
                    }
                    if (option.startsWith("mustHaveExternalId=")) {
                        displayWithoutId = !"true".equalsIgnoreCase(option.substring("mustHaveExternalId=".length()));
                        continue;
                    }
                    if (option.startsWith("maxResults=")) {
                        cx.setLimit(Integer.parseInt(option.substring("maxResults=".length())));
                        continue;
                    }
                    if (option.startsWith("session=")) {
                        cx.setSessionId(Long.valueOf(option.substring("session=".length())));
                        continue;
                    }
                    if (!option.startsWith("source=")) continue;
                    sources = option.substring("source=".length()).split(":");
                }
            }
            if (sources == null) {
                if (context == null || context.hasPermission(Right.CanLookupLdap)) {
                    this.findPeopleFromLdap(cx);
                }
                if (context == null || context.hasPermission(Right.CanLookupStudents)) {
                    this.findPeopleFromStudents(cx);
                }
                if (context == null || context.hasPermission(Right.CanLookupInstructors)) {
                    this.findPeopleFromInstructors(cx);
                }
                if (context == null || context.hasPermission(Right.CanLookupStaff)) {
                    this.findPeopleFromStaff(cx);
                }
                if (context == null || context.hasPermission(Right.CanLookupManagers)) {
                    this.findPeopleFromTimetableManagers(cx);
                }
                if (context == null || context.hasPermission(Right.CanLookupEventContacts)) {
                    this.findPeopleFromEventContact(cx);
                }
            } else {
                for (String source : sources) {
                    if ("ldap".equals(source) && (context == null || context.hasPermission(Right.CanLookupLdap))) {
                        this.findPeopleFromLdap(cx);
                    }
                    if ("students".equals(source) && (context == null || context.hasPermission(Right.CanLookupStudents))) {
                        this.findPeopleFromStudents(cx);
                    }
                    if ("staff".equals(source) && (context == null || context.hasPermission(Right.CanLookupStaff))) {
                        this.findPeopleFromInstructors(cx);
                    }
                    if ("managers".equals(source) && (context == null || context.hasPermission(Right.CanLookupManagers))) {
                        this.findPeopleFromStaff(cx);
                    }
                    if ("events".equals(source) && (context == null || context.hasPermission(Right.CanLookupEventContacts))) {
                        this.findPeopleFromTimetableManagers(cx);
                    }
                    if (!"instructors".equals(source) || context != null && !context.hasPermission(Right.CanLookupInstructors)) continue;
                    this.findPeopleFromEventContact(cx);
                }
            }
            GwtRpcResponseList<PersonInterface> people = cx.response(displayWithoutId);
            NameFormat nameFormat = NameFormat.fromReference(context != null ? context.getUser().getProperty(UserProperty.NameFormat) : NameFormat.LAST_FIRST_MIDDLE.reference());
            for (final PersonInterface person : people) {
                person.setFormattedName(nameFormat.format(new NameInterface(){

                    public String getMiddleName() {
                        return person.getMiddleName();
                    }

                    public String getLastName() {
                        return person.getLastName();
                    }

                    public String getFirstName() {
                        return person.getFirstName();
                    }

                    public String getAcademicTitle() {
                        return person.getAcademicTitle();
                    }
                }));
            }
            return people;
        }
        catch (GwtRpcException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)("Lookup failed: " + e.getMessage()), (Throwable)e);
            throw new GwtRpcException("Lookup failed: " + e.getMessage());
        }
    }

    protected String translate(String uid, ExternalUidTranslation.Source source) {
        if (this.iTranslation == null || uid == null || source.equals((Object)ExternalUidTranslation.Source.User)) {
            return uid;
        }
        if (uid.trim().isEmpty()) {
            return null;
        }
        return this.iTranslation.translate(uid, source, ExternalUidTranslation.Source.User);
    }

    protected void findPeopleFromStaff(SearchContext context) throws Exception {
        String q = "select s from Staff s where ";
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            if (idx > 0) {
                q = q + " and ";
            }
            q = q + "(lower(s.firstName) like :t" + idx + " || '%' or lower(s.firstName) like '% ' || :t" + idx + " || '%' or lower(s.middleName) like :t" + idx + " || '%' or lower(s.middleName) like '% ' || :t" + idx + " || '%' or lower(s.lastName) like :t" + idx + " || '%' or lower(s.lastName) like '% ' || :t" + idx + " || '%' or lower(s.email) like :t" + idx + " || '%')";
        }
        q = q + " order by s.lastName, s.firstName, s.middleName";
        Query hq = StaffDAO.getInstance().getSession().createQuery(q);
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            hq.setString("t" + idx, context.getQueryTokens().get(idx));
        }
        if (context.getLimit() > 0) {
            hq.setMaxResults(context.getLimit());
        }
        for (Staff staff : hq.setCacheable(true).list()) {
            context.addPerson(new PersonInterface(this.translate(staff.getExternalUniqueId(), ExternalUidTranslation.Source.Staff), staff.getFirstName(), staff.getMiddleName(), staff.getLastName(), staff.getAcademicTitle(), staff.getEmail(), null, staff.getDept(), staff.getPositionType() == null ? null : staff.getPositionType().getLabel(), "Staff"));
        }
    }

    protected void findPeopleFromEventContact(SearchContext context) throws Exception {
        String q = "select s from EventContact s where ";
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            if (idx > 0) {
                q = q + " and ";
            }
            q = q + "(lower(s.firstName) like :t" + idx + " || '%' or lower(s.firstName) like '% ' || :t" + idx + " || '%' or lower(s.middleName) like :t" + idx + " || '%' or lower(s.middleName) like '% ' || :t" + idx + " || '%' or lower(s.lastName) like :t" + idx + " || '%' or lower(s.lastName) like '% ' || :t" + idx + " || '%' or lower(s.emailAddress) like :t" + idx + " || '%')";
        }
        q = q + " order by s.lastName, s.firstName, s.middleName";
        Query hq = EventContactDAO.getInstance().getSession().createQuery(q);
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            hq.setString("t" + idx, context.getQueryTokens().get(idx));
        }
        if (context.getLimit() > 0) {
            hq.setMaxResults(context.getLimit());
        }
        for (EventContact contact : hq.setCacheable(true).list()) {
            context.addPerson(new PersonInterface(this.translate(contact.getExternalUniqueId(), ExternalUidTranslation.Source.User), contact.getFirstName(), contact.getMiddleName(), contact.getLastName(), contact.getAcademicTitle(), contact.getEmailAddress(), contact.getPhone(), null, null, "Event Contacts"));
        }
    }

    protected void findPeopleFromInstructors(SearchContext context) throws Exception {
        String q = "select s from DepartmentalInstructor s where s.department.session.uniqueId = :sessionId";
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            q = q + " and (lower(s.firstName) like :t" + idx + " || '%' or lower(s.firstName) like '% ' || :t" + idx + " || '%' or lower(s.middleName) like :t" + idx + " || '%' or lower(s.middleName) like '% ' || :t" + idx + " || '%' or lower(s.lastName) like :t" + idx + " || '%' or lower(s.lastName) like '% ' || :t" + idx + " || '%' or lower(s.email) like :t" + idx + " || '%')";
        }
        q = q + " order by s.lastName, s.firstName, s.middleName";
        Query hq = DepartmentalInstructorDAO.getInstance().getSession().createQuery(q);
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            hq.setString("t" + idx, context.getQueryTokens().get(idx));
        }
        hq.setLong("sessionId", context.getSessionId().longValue());
        if (context.getLimit() > 0) {
            hq.setMaxResults(context.getLimit());
        }
        for (DepartmentalInstructor instructor : hq.setCacheable(true).list()) {
            context.addPerson(new PersonInterface(this.translate(instructor.getExternalUniqueId(), ExternalUidTranslation.Source.Staff), Constants.toInitialCase(instructor.getFirstName()), Constants.toInitialCase(instructor.getMiddleName()), Constants.toInitialCase(instructor.getLastName()), instructor.getAcademicTitle(), instructor.getEmail(), null, instructor.getDepartment().getName(), instructor.getPositionType() == null ? null : instructor.getPositionType().getLabel(), "Instructors"));
        }
    }

    protected void findPeopleFromStudents(SearchContext context) throws Exception {
        String q = "select s from Student s where s.session.uniqueId = :sessionId";
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            q = q + " and (lower(s.firstName) like :t" + idx + " || '%' or lower(s.firstName) like '% ' || :t" + idx + " || '%' or lower(s.middleName) like :t" + idx + " || '%' or lower(s.middleName) like '% ' || :t" + idx + " || '%' or lower(s.lastName) like :t" + idx + " || '%' or lower(s.lastName) like '% ' || :t" + idx + " || '%' or lower(s.email) like :t" + idx + " || '%'" + (context.isAdmin() ? "or s.externalUniqueId = :i" + idx : "") + ")";
        }
        q = q + " order by s.lastName, s.firstName, s.middleName";
        Query hq = StudentDAO.getInstance().getSession().createQuery(q);
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            hq.setString("t" + idx, context.getQueryTokens().get(idx));
            if (!context.isAdmin()) continue;
            if (ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue()) {
                hq.setString("i" + idx, context.getQueryTokens().get(idx).replaceFirst("^0+(?!$)", ""));
                continue;
            }
            hq.setString("i" + idx, context.getQueryTokens().get(idx));
        }
        hq.setLong("sessionId", context.getSessionId().longValue());
        if (context.getLimit() > 0) {
            hq.setMaxResults(context.getLimit());
        }
        for (Student student : hq.setCacheable(true).list()) {
            context.addPerson(new PersonInterface(this.translate(student.getExternalUniqueId(), ExternalUidTranslation.Source.Student), student.getFirstName(), student.getMiddleName(), student.getLastName(), student.getAcademicTitle(), student.getEmail(), null, null, "Student", "Students"));
        }
    }

    protected void findPeopleFromTimetableManagers(SearchContext context) throws Exception {
        String q = "select s from TimetableManager s where ";
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            if (idx > 0) {
                q = q + " and ";
            }
            q = q + "(lower(s.firstName) like :t" + idx + " || '%' or lower(s.firstName) like '% ' || :t" + idx + " || '%' or lower(s.middleName) like :t" + idx + " || '%' or lower(s.middleName) like '% ' || :t" + idx + " || '%' or lower(s.lastName) like :t" + idx + " || '%' or lower(s.lastName) like '% ' || :t" + idx + " || '%' or lower(s.emailAddress) like :t" + idx + " || '%')";
        }
        q = q + " order by s.lastName, s.firstName, s.middleName";
        Query hq = TimetableManagerDAO.getInstance().getSession().createQuery(q);
        for (int idx = 0; idx < context.getQueryTokens().size(); ++idx) {
            hq.setString("t" + idx, context.getQueryTokens().get(idx));
        }
        if (context.getLimit() > 0) {
            hq.setMaxResults(context.getLimit());
        }
        for (TimetableManager manager : hq.setCacheable(true).list()) {
            context.addPerson(new PersonInterface(this.translate(manager.getExternalUniqueId(), ExternalUidTranslation.Source.User), manager.getFirstName(), manager.getMiddleName(), manager.getLastName(), manager.getAcademicTitle(), manager.getEmailAddress(), null, null, manager.getPrimaryRole() == null ? null : manager.getPrimaryRole().getAbbv(), "Timetable Managers"));
        }
    }

    protected LdapTemplate getLdapTemplate() {
        if (this.iLdapTemplate == null) {
            try {
                this.iLdapTemplate = this.applicationContext != null ? (LdapTemplate)this.applicationContext.getBean("ldapPeopleLookupTemplate", LdapTemplate.class) : (LdapTemplate)SpringApplicationContextHolder.getBean("ldapPeopleLookupTemplate");
                if (this.iLdapTemplate != null) {
                    return this.iLdapTemplate;
                }
            }
            catch (BeansException beansException) {
                // empty catch block
            }
            String url = ApplicationProperty.PeopleLookupLdapUrl.value();
            if (url == null) {
                return null;
            }
            sLog.warn((Object)"Failed to locate bean ldapPeopleLookupTemplate, creating the template manually.");
            LdapContextSource source = new LdapContextSource();
            source.setUrl(url);
            source.setBase(ApplicationProperty.PeopleLookupLdapBase.value());
            String user = ApplicationProperty.PeopleLookupLdapUser.value();
            if (user != null) {
                source.setUserDn(user);
                String password = ApplicationProperty.PeopleLookupLdapPassword.value();
                if (password != null) {
                    source.setPassword(password);
                }
            } else {
                source.setAnonymousReadOnly(true);
            }
            try {
                source.afterPropertiesSet();
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to initialze LDAP context source: " + e.getMessage()), (Throwable)e);
            }
            this.iLdapTemplate = new LdapTemplate((ContextSource)source);
        }
        return this.iLdapTemplate;
    }

    protected SearchControls getSearchControls() {
        if (this.iSearchControls == null) {
            this.iSearchControls = new SearchControls();
            this.iSearchControls.setCountLimit(ApplicationProperty.PeopleLookupLdapLimit.intValue().intValue());
        }
        return this.iSearchControls;
    }

    protected void findPeopleFromLdap(final SearchContext context) throws Exception {
        try {
            if (this.getLdapTemplate() == null) {
                return;
            }
            String filter = "";
            for (String token : context.getQueryTokens()) {
                String t = token.replace('_', '*').replace('%', '*');
                if (filter.length() == 0) {
                    filter = ApplicationProperty.PeopleLookupLdapQuery.value().replaceAll("%", t);
                    continue;
                }
                filter = "(&" + filter + ApplicationProperty.PeopleLookupLdapQuery.value().replaceAll("%", t) + ")";
            }
            this.getLdapTemplate().search("", filter, this.getSearchControls(), new AttributesMapper(){

                protected String getAttribute(Attributes attrs, String name) {
                    if (attrs == null) {
                        return null;
                    }
                    if (name == null || name.isEmpty()) {
                        return null;
                    }
                    StringTokenizer stk = new StringTokenizer(name, ",");
                    while (stk.hasMoreTokens()) {
                        Attribute a = attrs.get(stk.nextToken());
                        try {
                            if (a == null || a.get() == null) continue;
                            return a.get().toString();
                        }
                        catch (NamingException namingException) {
                        }
                    }
                    return null;
                }

                public Object mapFromAttributes(Attributes a) throws NamingException {
                    PersonInterface person = new PersonInterface(PeopleLookupBackend.this.translate(this.getAttribute(a, "uid"), ExternalUidTranslation.Source.LDAP), Constants.toInitialCase(this.getAttribute(a, "givenName")), Constants.toInitialCase(this.getAttribute(a, "cn")), Constants.toInitialCase(this.getAttribute(a, "sn")), this.getAttribute(a, ApplicationProperty.PeopleLookupLdapAcademicTitleAttribute.value()), this.getAttribute(a, ApplicationProperty.PeopleLookupLdapEmailAttribute.value()), this.getAttribute(a, ApplicationProperty.PeopleLookupLdapPhoneAttribute.value()), Constants.toInitialCase(this.getAttribute(a, ApplicationProperty.PeopleLookupLdapDepartmentAttribute.value())), Constants.toInitialCase(this.getAttribute(a, ApplicationProperty.PeopleLookupLdapPositionAttribute.value())), "Directory");
                    context.addPerson(person);
                    return person;
                }
            });
        }
        catch (Exception e) {
            sLog.warn((Object)e.getMessage());
        }
    }

    @Override
    public ExternalUidLookup.UserInfo doLookup(String uid) throws Exception {
        try {
            if (uid == null || uid.isEmpty()) {
                return null;
            }
            if (this.getLdapTemplate() == null) {
                return null;
            }
            if (this.iTranslation != null) {
                uid = this.iTranslation.translate(uid, ExternalUidTranslation.Source.User, ExternalUidTranslation.Source.LDAP);
            }
            return (ExternalUidLookup.UserInfo)this.getLdapTemplate().lookup("uid=" + uid, new AttributesMapper(){

                protected String getAttribute(Attributes attrs, String name) {
                    if (attrs == null) {
                        return null;
                    }
                    if (name == null || name.isEmpty()) {
                        return null;
                    }
                    StringTokenizer stk = new StringTokenizer(name, ",");
                    while (stk.hasMoreTokens()) {
                        Attribute a = attrs.get(stk.nextToken());
                        try {
                            if (a == null || a.get() == null) continue;
                            return a.get().toString();
                        }
                        catch (NamingException namingException) {
                        }
                    }
                    return null;
                }

                public Object mapFromAttributes(Attributes a) throws NamingException {
                    ExternalUidLookup.UserInfo info = new ExternalUidLookup.UserInfo();
                    info.setUserName(this.getAttribute(a, "uid"));
                    if (PeopleLookupBackend.this.iTranslation == null) {
                        info.setExternalId(info.getUserName());
                    } else {
                        info.setExternalId(PeopleLookupBackend.this.iTranslation.translate(info.getUserName(), ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User));
                    }
                    info.setFirstName(Constants.toInitialCase(this.getAttribute(a, "givenName")));
                    info.setName(Constants.toInitialCase(this.getAttribute(a, "cn")));
                    info.setLastName(Constants.toInitialCase(this.getAttribute(a, "sn")));
                    info.setEmail(this.getAttribute(a, ApplicationProperty.PeopleLookupLdapEmailAttribute.value()));
                    info.setPhone(this.getAttribute(a, ApplicationProperty.PeopleLookupLdapPhoneAttribute.value()));
                    info.setAcademicTitle(this.getAttribute(a, ApplicationProperty.PeopleLookupLdapAcademicTitleAttribute.value()));
                    if (info.getName() != null) {
                        String middle = info.getName();
                        if (info.getFirstName() != null && middle.indexOf(info.getFirstName()) >= 0) {
                            middle = middle.replaceAll(info.getFirstName() + " ?", "");
                        }
                        if (info.getLastName() != null && middle.indexOf(info.getLastName()) >= 0) {
                            middle = middle.replaceAll(" ?" + info.getLastName(), "");
                        }
                        info.setMiddleName(middle);
                    }
                    return info;
                }
            });
        }
        catch (Exception e) {
            sLog.warn((Object)("Failed to lookup a person: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SearchContext {
        private Hashtable<String, PersonInterface> iPeople = new Hashtable();
        private TreeSet<PersonInterface> iPeopleWithoutId = new TreeSet();
        private int iLimit = -1;
        private Long iSessionId = null;
        private String iQuery = null;
        private List<String> iTokens = null;
        private boolean iAdmin = false;

        SearchContext() {
        }

        public void setLimit(int limit) {
            this.iLimit = limit;
        }

        public int getLimit() {
            return this.iLimit;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setAdmin(boolean admin) {
            this.iAdmin = admin;
        }

        public boolean isAdmin() {
            return this.iAdmin;
        }

        public void setQuery(String query) {
            this.iQuery = query;
            if (this.iTokens == null) {
                this.iTokens = new ArrayList<String>();
            } else {
                this.iTokens.clear();
            }
            StringTokenizer stk = new StringTokenizer(query, " ,");
            while (stk.hasMoreTokens()) {
                String t = stk.nextToken();
                this.iTokens.add(t.toLowerCase());
            }
        }

        public String getQuery() {
            return this.iQuery;
        }

        public List<String> getQueryTokens() {
            return this.iTokens;
        }

        public void addPerson(PersonInterface person) {
            if (person.getId() == null || person.getId().isEmpty() || "null".equals(person.getId())) {
                this.iPeopleWithoutId.add(person);
            } else {
                PersonInterface old = this.iPeople.get(person.getId());
                if (old == null) {
                    this.iPeople.put(person.getId(), person);
                } else {
                    old.merge(person);
                }
            }
        }

        public GwtRpcResponseList<PersonInterface> response(boolean displayWithoutId) {
            GwtRpcResponseList<PersonInterface> ret = new GwtRpcResponseList<PersonInterface>(this.iPeople.values());
            Collections.sort(ret);
            if (displayWithoutId) {
                ret.addAll(this.iPeopleWithoutId);
            }
            if (this.getLimit() > 0 && ret.size() > this.getLimit()) {
                return new GwtRpcResponseList<PersonInterface>(ret.subList(0, this.getLimit()));
            }
            return ret;
        }
    }
}

