/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.instructor;

import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.instructor.InstructorSchedulingBackendHelper;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=InstructorInterface.TeachingAssignmentsDetailRequest.class)
public class TeachingAssignmentsDetailBackend
extends InstructorSchedulingBackendHelper
implements GwtRpcImplementation<InstructorInterface.TeachingAssignmentsDetailRequest, InstructorInterface.InstructorInfo> {
    @Autowired
    SolverService<InstructorSchedulingProxy> instructorSchedulingSolverService;

    @Override
    public InstructorInterface.InstructorInfo execute(InstructorInterface.TeachingAssignmentsDetailRequest request, SessionContext context) {
        context.checkPermission(Right.InstructorScheduling);
        InstructorSchedulingProxy solver = this.instructorSchedulingSolverService.getSolver();
        if (solver != null) {
            return solver.getInstructorInfo(request.getInstructorId());
        }
        DepartmentalInstructor instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(request.getInstructorId());
        if (instructor == null) {
            return null;
        }
        InstructorSchedulingBackendHelper.Context cx = new InstructorSchedulingBackendHelper.Context(context, solver);
        return this.getInstructorInfo(instructor, cx);
    }
}

