/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.text.ParseException;
import java.util.Date;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.EventDateMappingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;
import org.unitime.timetable.util.Formats;

@Service(value="gwtAdminTable[type=dateMapping]")
public class EventDateMappings
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageEventDateMapping(), MESSAGES.pageEventDateMappings());
    }

    @PreAuthorize(value="checkPermission('EventDateMappings')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldClassDate(), SimpleEditInterface.FieldType.date, 100, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldEventDate(), SimpleEditInterface.FieldType.date, 100, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldNote(), SimpleEditInterface.FieldType.text, 300, 1000, new SimpleEditInterface.Flag[0]));
        data.setSortBy(0, 1);
        data.setSessionId(context.getUser().getCurrentAcademicSessionId());
        data.setSessionName(((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId())).getLabel());
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        for (EventDateMapping mapping : EventDateMapping.findAll(context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(mapping.getUniqueId());
            r.setField(0, dateFormat.format(mapping.getClassDate()));
            r.setField(1, dateFormat.format(mapping.getEventDate()));
            r.setField(2, mapping.getNote());
        }
        data.setEditable(context.hasPermission(Right.EventDateMappingEdit));
        return data;
    }

    @PreAuthorize(value="checkPermission('EventDateMappingEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (EventDateMapping mapping : EventDateMapping.findAll(context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(mapping.getUniqueId());
            if (r == null) {
                this.delete(mapping, context, hibSession);
                continue;
            }
            this.update(mapping, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @PreAuthorize(value="checkPermission('EventDateMappingEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        try {
            Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
            EventDateMapping mapping = new EventDateMapping();
            mapping.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId()));
            mapping.setClassDate(dateFormat.parse(record.getField(0)));
            mapping.setEventDate(dateFormat.parse(record.getField(1)));
            mapping.setNote(record.getField(2));
            record.setUniqueId((Long)hibSession.save((Object)mapping));
            ChangeLog.addChange(hibSession, context, mapping, dateFormat.format(mapping.getClassDate()) + " &rarr; " + dateFormat.format(mapping.getEventDate()), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
        }
        catch (ParseException e) {
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    protected void update(EventDateMapping mapping, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        try {
            if (mapping == null) {
                return;
            }
            Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
            if (ToolBox.equals((Object)dateFormat.format(mapping.getClassDate()), (Object)record.getField(0)) && ToolBox.equals((Object)dateFormat.format(mapping.getEventDate()), (Object)record.getField(1)) && ToolBox.equals((Object)mapping.getNote(), (Object)record.getField(2))) {
                return;
            }
            mapping.setClassDate(dateFormat.parse(record.getField(0)));
            mapping.setEventDate(dateFormat.parse(record.getField(1)));
            mapping.setNote(record.getField(2));
            hibSession.saveOrUpdate((Object)mapping);
            ChangeLog.addChange(hibSession, context, mapping, dateFormat.format(mapping.getClassDate()) + " &rarr; " + dateFormat.format(mapping.getEventDate()), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
        }
        catch (ParseException e) {
            throw new GwtRpcException(e.getMessage(), e);
        }
    }

    @PreAuthorize(value="checkPermission('EventDateMappingEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((EventDateMapping)EventDateMappingDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(EventDateMapping mapping, SessionContext context, org.hibernate.Session hibSession) {
        if (mapping == null) {
            return;
        }
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        ChangeLog.addChange(hibSession, context, mapping, dateFormat.format(mapping.getClassDate()) + " &rarr; " + dateFormat.format(mapping.getEventDate()), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)mapping);
    }

    @PreAuthorize(value="checkPermission('EventDateMappingEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((EventDateMapping)EventDateMappingDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

