/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server;

import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.timetable.gwt.client.TimeHint;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamPeriodDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.webutil.RequiredTimeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=TimeHint.TimeHintRequest.class)
public class TimeHintBackend
implements GwtRpcImplementation<TimeHint.TimeHintRequest, TimeHint.TimeHintResponse> {
    @Override
    public TimeHint.TimeHintResponse execute(TimeHint.TimeHintRequest request, SessionContext context) {
        String[] params = request.getParameter().split(",");
        if (params.length == 2) {
            Long examId = Long.valueOf(params[0]);
            Long periodId = Long.valueOf(params[1]);
            Exam exam = (Exam)ExamDAO.getInstance().get(examId);
            ExamPeriod period = (ExamPeriod)ExamPeriodDAO.getInstance().get(periodId);
            if (exam.getExamType().getType() == 1) {
                MidtermPeriodPreferenceModel mpp = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType(), period);
                mpp.load(exam);
                return new TimeHint.TimeHintResponse("<div style='max-width: 200px;'>" + mpp.toString(true) + "</div>");
            }
            PeriodPreferenceModel px = new PeriodPreferenceModel(exam.getSession(), period, exam.getExamType().getUniqueId());
            px.load(exam);
            RequiredTimeTable m = new RequiredTimeTable(px);
            return new TimeHint.TimeHintResponse("$wnd." + m.print(false, false).replace(");\n</script>", "").replace("<script language=\"javascript\">\ndocument.write(", "").replace("\n", " "));
        }
        if (params.length == 3) {
            Long classId = Long.valueOf(params[0]);
            int days = Integer.parseInt(params[1]);
            int slot = Integer.parseInt(params[2]);
            Class_ clazz = (Class_)Class_DAO.getInstance().get(classId);
            for (TimePref p : clazz.effectivePreferences(TimePref.class)) {
                if (p.getTimePattern().getType() == 5) continue;
                boolean match = false;
                for (TimePatternDays d : p.getTimePattern().getDays()) {
                    if (d.getDayCode() != days) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                match = false;
                for (TimePatternTime t : p.getTimePattern().getTimes()) {
                    if (t.getStartSlot() != slot) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
                RequiredTimeTable m = p.getRequiredTimeTable(new TimeLocation(days, slot, 0, 0, 0.0, null, null, null, 0));
                return new TimeHint.TimeHintResponse("$wnd." + m.print(false, false).replace(");\n</script>", "").replace("<script language=\"javascript\">\ndocument.write(", "").replace("\n", " "));
            }
        }
        throw new GwtRpcException("No matching time preference found.");
    }
}

