/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.pointintimedata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.hibernate.Session;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PitClassInstructor;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.reports.pointintimedata.BasePointInTimeDataReports;
import org.unitime.timetable.reports.pointintimedata.WSCHByDepartment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllWSCHForDepartmentByInstructorPosition
extends WSCHByDepartment {
    private ArrayList<Long> iDepartmentIds;

    public AllWSCHForDepartmentByInstructorPosition() {
        this.getParameters().add(BasePointInTimeDataReports.Parameter.DEPARTMENTS);
    }

    @Override
    protected void intializeHeader() {
        ArrayList<String> hdr = new ArrayList<String>();
        hdr.add(MSG.columnDepartmentCode());
        hdr.add(MSG.columnDepartmentAbbreviation());
        hdr.add(MSG.columnDepartmentName());
        hdr.add(MSG.columnPosition());
        hdr.add(MSG.columnOrganizedWeeklyClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyClassHours());
        hdr.add(MSG.columnWeeklyClassHours());
        hdr.add(MSG.columnOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnNotOrganizedWeeklyStudentClassHours());
        hdr.add(MSG.columnWeeklyStudentClassHours());
        this.setHeader(hdr);
    }

    @Override
    protected void parseParameters() {
        super.parseParameters();
        if (this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENTS).size() >= 1) {
            this.setDepartmentIds(this.getParameterValues().get((Object)BasePointInTimeDataReports.Parameter.DEPARTMENTS));
        }
    }

    @Override
    public String reportName() {
        return MSG.deptWSCHReportAllHoursForDepartmentByPosition();
    }

    @Override
    public String reportDescription() {
        return MSG.deptWSCBReportAllHoursForDepartmentByPositionNote();
    }

    @Override
    protected float weeklyClassHours(PitClass pitClass) {
        return pitClass.getAllWeeklyClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
    }

    @Override
    protected float weeklyStudentClassHours(PitClass pitClass) {
        return pitClass.getAllWeeklyStudentClassHours(this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
    }

    @Override
    public void createWeeklyStudentContactHoursByDepartmentReportFor(PointInTimeData pointInTimeData, Session hibSession) {
        HashSet<Long> processedClasses = new HashSet<Long>();
        for (Long deptId : this.getDepartmentIds()) {
            Department d = (Department)hibSession.createQuery("from Department d where d.uniqueId = :id").setLong("id", deptId.longValue()).setCacheable(true).uniqueResult();
            HashMap<PositionType, PositionHours> positionClassHours = new HashMap<PositionType, PositionHours>();
            for (Long pioUid : this.findAllPitInstructionalOfferingUniqueIdsForDepartment(pointInTimeData, deptId, hibSession)) {
                for (PitClass pc : this.findAllPitClassesForPitInstructionalOfferingId(pointInTimeData, pioUid, hibSession)) {
                    if (processedClasses.contains(pc.getUniqueId())) continue;
                    processedClasses.add(pc.getUniqueId());
                    if (pc.getPitClassInstructors() == null || pc.getPitClassInstructors().isEmpty()) {
                        PositionHours ph = (PositionHours)positionClassHours.get(null);
                        if (ph == null) {
                            ph = new PositionHours(null, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                            positionClassHours.put(null, ph);
                        }
                        ph.addClassHours(null, pc);
                        continue;
                    }
                    int numInstructors = 0;
                    for (PitClassInstructor pci : pc.getPitClassInstructors()) {
                        PositionHours ph = (PositionHours)positionClassHours.get(pci.getPitDepartmentalInstructor().getPositionType());
                        if (ph == null) {
                            ph = new PositionHours(pci.getPitDepartmentalInstructor().getPositionType(), this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                            positionClassHours.put(pci.getPitDepartmentalInstructor().getPositionType(), ph);
                        }
                        if (!ph.addClassHours(pci, pc)) continue;
                        ++numInstructors;
                    }
                    if (numInstructors != 0) continue;
                    PositionHours ph = (PositionHours)positionClassHours.get(null);
                    if (ph == null) {
                        ph = new PositionHours(null, this.getStandardMinutesInReportingHour(), this.getStandardWeeksInReportingTerm());
                        positionClassHours.put(null, ph);
                    }
                    ph.addClassHours(null, pc);
                }
            }
            for (PositionType pt : positionClassHours.keySet()) {
                PositionHours ph = (PositionHours)positionClassHours.get(pt);
                ArrayList<String> row = new ArrayList<String>();
                row.add(d.getDeptCode());
                row.add(d.getAbbreviation());
                row.add(d.getName());
                row.add(pt == null ? MSG.labelUnknown() : pt.getLabel());
                row.add(Float.toString(ph.getOrganizedWeeklyClassHours()));
                row.add(Float.toString(ph.getNotOrganizedWeeklyClassHours()));
                row.add(Float.toString(ph.getWeeklyClassHours()));
                row.add(Float.toString(ph.getOrganizedWeeklyStudentClassHours()));
                row.add(Float.toString(ph.getNotOrganizedWeeklyStudentClassHours()));
                row.add(Float.toString(ph.getWeeklyStudentClassHours()));
                this.addDataRow(row);
            }
        }
    }

    public ArrayList<Long> getDepartmentIds() {
        return this.iDepartmentIds;
    }

    public void setDepartmentIds(ArrayList<Object> departmentIds) {
        this.iDepartmentIds = new ArrayList();
        for (Object o : departmentIds) {
            this.iDepartmentIds.add((Long)o);
        }
    }

    private class PositionHours {
        private float iWeeklyClassHours = 0.0f;
        private float iOrganizedWeeklyClassHours = 0.0f;
        private float iNotOrganizedWeeklyClassHours = 0.0f;
        private float iWeeklyStudentClassHours = 0.0f;
        private float iOrganizedWeeklyStudentClassHours = 0.0f;
        private float iNotOrganizedWeeklyStudentClassHours = 0.0f;
        private PositionType iPositionType;
        private Float iStandardMinutesInReportingHour;
        private Float iStandardWeeksInReportingTerm;

        public PositionType getPositionType() {
            return this.iPositionType;
        }

        public float getOrganizedWeeklyClassHours() {
            return this.iOrganizedWeeklyClassHours;
        }

        public float getNotOrganizedWeeklyClassHours() {
            return this.iNotOrganizedWeeklyClassHours;
        }

        public float getOrganizedWeeklyStudentClassHours() {
            return this.iOrganizedWeeklyStudentClassHours;
        }

        public float getNotOrganizedWeeklyStudentClassHours() {
            return this.iNotOrganizedWeeklyStudentClassHours;
        }

        public float getWeeklyClassHours() {
            return this.iWeeklyClassHours;
        }

        public float getWeeklyStudentClassHours() {
            return this.iWeeklyStudentClassHours;
        }

        public PositionHours(PositionType positionType, Float standardMinutesInReportingHour, Float standardWeeksInReportingTerm) {
            this.iPositionType = positionType;
            this.iStandardMinutesInReportingHour = standardMinutesInReportingHour;
            this.iStandardWeeksInReportingTerm = standardWeeksInReportingTerm;
        }

        public boolean addClassHours(PitClassInstructor pitClassInstructor, PitClass pitClass) {
            if (pitClassInstructor == null) {
                if (this.iPositionType == null) {
                    this.updateHours(pitClass, 100);
                    return true;
                }
                return false;
            }
            if (pitClassInstructor.getResponsibility() != null && pitClassInstructor.getResponsibility().hasOption(TeachingResponsibility.Option.auxiliary)) {
                return false;
            }
            if (pitClassInstructor.getNormalizedPercentShare() == 0) {
                return false;
            }
            if (pitClassInstructor.getPitDepartmentalInstructor().getPositionType() == null) {
                if (this.iPositionType == null) {
                    this.updateHours(pitClass, pitClassInstructor.getNormalizedPercentShare());
                    return true;
                }
                return false;
            }
            if (pitClassInstructor.getPitDepartmentalInstructor().getPositionType().equals(this.getPositionType())) {
                this.updateHours(pitClass, pitClassInstructor.getNormalizedPercentShare());
                return true;
            }
            return false;
        }

        private void updateHours(PitClass pitClass, Integer percentShare) {
            this.iWeeklyClassHours += pitClass.getAllWeeklyClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iOrganizedWeeklyClassHours += pitClass.getOrganizedWeeklyClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iNotOrganizedWeeklyClassHours += pitClass.getNotOrganizedWeeklyClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iWeeklyStudentClassHours += pitClass.getAllWeeklyStudentClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iOrganizedWeeklyStudentClassHours += pitClass.getOrganizedWeeklyStudentClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
            this.iNotOrganizedWeeklyStudentClassHours += pitClass.getNotOrganizedWeeklyStudentClassHours(this.iStandardMinutesInReportingHour, this.iStandardWeeksInReportingTerm) * ((float)percentShare.intValue() / 100.0f);
        }
    }
}

