/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictsByCourseAndStudentReport
extends PdfLegacyExamReport {
    protected static Logger sLog = Logger.getLogger(ConflictsByCourseAndStudentReport.class);
    Hashtable<Long, String> iStudentNames = new Hashtable();

    public ConflictsByCourseAndStudentReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "CONFLICTS BY COURSE AND STUDENT", session, examType, subjectAreas, exams);
        sLog.debug((Object)"  Loading students ...");
        Iterator i = new StudentDAO().getSession().createQuery("select s.uniqueId, s.externalUniqueId, s.lastName, s.firstName, s.middleName from Student s where s.session.uniqueId=:sessionId").setLong("sessionId", session.getUniqueId().longValue()).iterate();
        while (i.hasNext()) {
            Object[] o = (Object[])i.next();
            if (o[2] != null) {
                this.iStudentNames.put((Long)o[0], (String)o[2] + (o[3] == null ? "" : " " + (String)o[3]) + (o[4] == null ? "" : " " + (String)o[4]));
                continue;
            }
            if (o[1] != null) {
                this.iStudentNames.put((Long)o[0], (String)o[1]);
                continue;
            }
            this.iStudentNames.put((Long)o[0], "N/A");
        }
    }

    @Override
    public void printReport() throws DocumentException {
        sLog.debug((Object)"  Sorting sections...");
        Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>> subject2courseSections = new Hashtable<String, TreeSet<ExamInfo.ExamSectionInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null) continue;
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!this.hasSubjectArea(section)) continue;
                TreeSet<ExamInfo.ExamSectionInfo> sections = (TreeSet<ExamInfo.ExamSectionInfo>)subject2courseSections.get(section.getSubject());
                if (sections == null) {
                    sections = new TreeSet<ExamInfo.ExamSectionInfo>();
                    subject2courseSections.put(section.getSubject(), sections);
                }
                sections.add(section);
            }
        }
        sLog.debug((Object)"  Printing report...");
        String[] stringArray = new String[2];
        stringArray[0] = "Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Date    Time   Name                      Type   Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section   Time           ";
        stringArray[1] = "------- -------- " + (this.iItype ? "------ " : "") + "--------- ------- ------ ------------------------- ------ ------- -------- " + (this.iItype ? "------ " : "") + "--------- ---------------";
        this.setHeader(stringArray);
        this.printHeader();
        boolean dirtyPage = false;
        for (String subject : new TreeSet(subject2courseSections.keySet())) {
            TreeSet sections = (TreeSet)subject2courseSections.get(subject);
            if (this.iSubjectPrinted || dirtyPage) {
                this.newPage();
            }
            this.setPageName(subject);
            this.setCont(subject);
            this.iSubjectPrinted = false;
            for (ExamInfo.ExamSectionInfo section : sections) {
                ExamAssignmentInfo exam = section.getExamAssignmentInfo();
                if (exam == null || exam.getPeriod() == null) continue;
                this.iCoursePrinted = false;
                Vector<Long> students = new Vector<Long>(section.getStudentIds());
                Collections.sort(students, new Comparator<Long>(){

                    @Override
                    public int compare(Long s1, Long s2) {
                        int cmp = ConflictsByCourseAndStudentReport.this.iStudentNames.get(s1).compareTo(ConflictsByCourseAndStudentReport.this.iStudentNames.get(s2));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.compareTo(s2);
                    }
                });
                for (Long studentId : students) {
                    this.iStudentPrinted = false;
                    if (this.iDirect) {
                        for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                            if (!directConflict.getStudents().contains(studentId)) continue;
                            this.iPeriodPrinted = false;
                            if (directConflict.getOtherExam() != null) {
                                for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                                    if (!other.getStudentIds().contains(studentId)) continue;
                                    this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "DIRECT", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                                    this.iPeriodPrinted = !this.iNewPage;
                                    this.iStudentPrinted = this.iPeriodPrinted;
                                    this.iCoursePrinted = this.iPeriodPrinted;
                                    this.iSubjectPrinted = this.iPeriodPrinted;
                                }
                                continue;
                            }
                            if (directConflict.getOtherEventId() == null) continue;
                            if (directConflict.isOtherClass()) {
                                this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "CLASS", 6) + " " + this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7) + " " + this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) + " " : "") + this.lpad(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString(), 9) + " " + this.getMeetingTime(directConflict.getOtherEventTime()));
                            } else {
                                this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "EVENT", 6) + " " + this.rpad(directConflict.getOtherEventName(), this.iItype ? 33 : 26) + " " + this.getMeetingTime(directConflict.getOtherEventTime()));
                            }
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                        }
                    }
                    if (this.iM2d) {
                        for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                            if (!moreThanTwoADayConflict.getStudents().contains(studentId)) continue;
                            this.iPeriodPrinted = false;
                            for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                                for (ExamInfo.ExamSectionInfo examSectionInfo : otherExam.getSectionsIncludeCrosslistedDummies()) {
                                    if (!examSectionInfo.getStudentIds().contains(studentId)) continue;
                                    this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : ">2-DAY", 6) + " " + this.rpad(examSectionInfo.getSubject(), 7) + " " + this.rpad(examSectionInfo.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(examSectionInfo.getItype(), 6) + " " : "") + this.lpad(examSectionInfo.getSection(), 9) + " " + examSectionInfo.getExamAssignment().getTimeFixedLength());
                                    this.iPeriodPrinted = !this.iNewPage;
                                    this.iStudentPrinted = this.iPeriodPrinted;
                                    this.iCoursePrinted = this.iPeriodPrinted;
                                    this.iSubjectPrinted = this.iPeriodPrinted;
                                }
                            }
                        }
                    }
                    if (!this.iBtb) continue;
                    for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getBackToBackConflicts()) {
                        if (!backToBackConflict.getStudents().contains(studentId)) continue;
                        this.iPeriodPrinted = false;
                        for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                            if (!other.getStudentIds().contains(studentId)) continue;
                            this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14) + " " + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "BTB", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                            this.iPeriodPrinted = !this.iNewPage;
                            this.iStudentPrinted = this.iPeriodPrinted;
                            this.iCoursePrinted = this.iPeriodPrinted;
                            this.iSubjectPrinted = this.iPeriodPrinted;
                        }
                    }
                }
                boolean needReprintSubject = false;
                if (section.hasDifferentSubjectChildren()) {
                    for (ExamInfo.ExamSectionInfo child : section.getDifferentSubjectChildren()) {
                        boolean bl = false;
                        students = new Vector<Long>(child.getStudentIds());
                        Collections.sort(students, new Comparator<Long>(){

                            @Override
                            public int compare(Long s1, Long s2) {
                                int cmp = ConflictsByCourseAndStudentReport.this.iStudentNames.get(s1).compareTo(ConflictsByCourseAndStudentReport.this.iStudentNames.get(s2));
                                if (cmp != 0) {
                                    return cmp;
                                }
                                return s1.compareTo(s2);
                            }
                        });
                        for (Long studentId : students) {
                            boolean bl2;
                            this.iStudentPrinted = false;
                            if (this.iDirect) {
                                for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                                    if (!directConflict.getStudents().contains(studentId)) continue;
                                    this.iPeriodPrinted = false;
                                    if (directConflict.getOtherExam() != null) {
                                        for (ExamInfo.ExamSectionInfo other : directConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                                            if (!other.getStudentIds().contains(studentId)) continue;
                                            if (!this.iCoursePrinted) {
                                                this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14));
                                                this.iCoursePrinted = !this.iNewPage;
                                                this.iSubjectPrinted = this.iCoursePrinted;
                                            }
                                            this.println(this.rpad(bl2 ? "" : "w/" + this.rpad(child.getSubject(), 6) + this.rpad(child.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(child.getItype(), 6) + " " : "") + this.lpad(child.getSection(), 9) + " " + this.formatShortPeriodNoEndTime(exam), this.iItype ? 49 : 42) + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "DIRECT", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                                            needReprintSubject = !this.iNewPage;
                                            bl2 = needReprintSubject;
                                            this.iPeriodPrinted = needReprintSubject;
                                            this.iStudentPrinted = needReprintSubject;
                                            this.iCoursePrinted = needReprintSubject;
                                            this.iSubjectPrinted = needReprintSubject;
                                        }
                                        continue;
                                    }
                                    if (directConflict.getOtherEventId() == null) continue;
                                    if (!this.iCoursePrinted) {
                                        this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14));
                                        this.iCoursePrinted = !this.iNewPage;
                                        this.iSubjectPrinted = this.iCoursePrinted;
                                    }
                                    if (directConflict.isOtherClass()) {
                                        this.println(this.rpad(bl2 ? "" : "w/" + this.rpad(child.getSubject(), 6) + this.rpad(child.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(child.getItype(), 6) + " " : "") + this.lpad(child.getSection(), 9) + " " + this.formatShortPeriodNoEndTime(exam), this.iItype ? 49 : 42) + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "CLASS", 6) + " " + this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getSubjectAreaAbbv(), 7) + " " + this.rpad(directConflict.getOtherClass().getSchedulingSubpart().getControllingCourseOffering().getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iExternal ? directConflict.getOtherClass().getExternalUniqueId() : directConflict.getOtherClass().getSchedulingSubpart().getItypeDesc(), 6) + " " : "") + this.lpad(this.iUseClassSuffix && directConflict.getOtherClass().getClassSuffix() != null ? directConflict.getOtherClass().getClassSuffix() : directConflict.getOtherClass().getSectionNumberString(), 9) + " " + this.getMeetingTime(directConflict.getOtherEventTime()));
                                    } else {
                                        this.println(this.rpad(bl2 ? "" : "w/" + this.rpad(child.getSubject(), 6) + this.rpad(child.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(child.getItype(), 6) + " " : "") + this.lpad(child.getSection(), 9) + " " + this.formatShortPeriodNoEndTime(exam), this.iItype ? 49 : 42) + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "EVENT", 6) + " " + this.rpad(directConflict.getOtherEventName(), this.iItype ? 33 : 26) + " " + this.getMeetingTime(directConflict.getOtherEventTime()));
                                    }
                                    needReprintSubject = !this.iNewPage;
                                    bl2 = needReprintSubject;
                                    this.iPeriodPrinted = needReprintSubject;
                                    this.iStudentPrinted = needReprintSubject;
                                    this.iCoursePrinted = needReprintSubject;
                                    this.iSubjectPrinted = needReprintSubject;
                                }
                            }
                            if (this.iM2d) {
                                for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                                    if (!moreThanTwoADayConflict.getStudents().contains(studentId)) continue;
                                    this.iPeriodPrinted = false;
                                    for (ExamAssignment otherExam : moreThanTwoADayConflict.getOtherExams()) {
                                        for (ExamInfo.ExamSectionInfo other : otherExam.getSectionsIncludeCrosslistedDummies()) {
                                            if (!other.getStudentIds().contains(studentId)) continue;
                                            if (!this.iCoursePrinted) {
                                                this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14));
                                                this.iCoursePrinted = !this.iNewPage;
                                                this.iSubjectPrinted = this.iCoursePrinted;
                                            }
                                            this.println(this.rpad(bl2 ? "" : "w/" + this.rpad(child.getSubject(), 6) + this.rpad(child.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(child.getItype(), 6) + " " : "") + this.lpad(child.getSection(), 9) + " " + this.formatShortPeriodNoEndTime(exam), this.iItype ? 49 : 42) + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : ">2-DAY", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                                            needReprintSubject = !this.iNewPage;
                                            bl2 = needReprintSubject;
                                            this.iPeriodPrinted = needReprintSubject;
                                            this.iStudentPrinted = needReprintSubject;
                                            this.iCoursePrinted = needReprintSubject;
                                            this.iSubjectPrinted = needReprintSubject;
                                        }
                                    }
                                }
                            }
                            if (!this.iBtb) continue;
                            for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getBackToBackConflicts()) {
                                if (!backToBackConflict.getStudents().contains(studentId)) continue;
                                this.iPeriodPrinted = false;
                                for (ExamInfo.ExamSectionInfo other : backToBackConflict.getOtherExam().getSectionsIncludeCrosslistedDummies()) {
                                    if (!other.getStudentIds().contains(studentId)) continue;
                                    if (!this.iCoursePrinted) {
                                        this.println(this.rpad(this.iSubjectPrinted ? "" : subject, 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iCoursePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(this.iCoursePrinted ? "" : section.getSection(), 9) + " " + this.rpad(this.iCoursePrinted ? "" : this.formatShortPeriodNoEndTime(exam), 14));
                                        this.iCoursePrinted = !this.iNewPage;
                                        this.iSubjectPrinted = this.iCoursePrinted;
                                    }
                                    this.println(this.rpad(bl2 ? "" : "w/" + this.rpad(child.getSubject(), 6) + this.rpad(child.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(child.getItype(), 6) + " " : "") + this.lpad(child.getSection(), 9) + " " + this.formatShortPeriodNoEndTime(exam), this.iItype ? 49 : 42) + this.rpad(this.iStudentPrinted ? "" : this.iStudentNames.get(studentId), 25) + " " + this.rpad(this.iPeriodPrinted ? "" : "BTB", 6) + " " + this.rpad(other.getSubject(), 7) + " " + this.rpad(other.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(other.getItype(), 6) + " " : "") + this.lpad(other.getSection(), 9) + " " + other.getExamAssignment().getTimeFixedLength());
                                    needReprintSubject = !this.iNewPage;
                                    bl2 = needReprintSubject;
                                    this.iPeriodPrinted = needReprintSubject;
                                    this.iStudentPrinted = needReprintSubject;
                                    this.iCoursePrinted = needReprintSubject;
                                    this.iSubjectPrinted = needReprintSubject;
                                }
                            }
                        }
                    }
                }
                if (!needReprintSubject) continue;
                this.iSubjectPrinted = false;
                dirtyPage = true;
            }
            this.setCont(null);
        }
        if (this.iSubjectPrinted) {
            this.lastPage();
        }
    }
}

