/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.SectioningServlet;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CustomCourseRequestsValidationHolder;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.server.CheckMaster;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadAllData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CheckMaster(value=CheckMaster.Master.REQUIRED)
public class SaveStudentRequests
implements OnlineSectioningAction<CourseRequestInterface> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iStudentId;
    private CourseRequestInterface iRequest;
    private boolean iKeepEnrollments;
    private boolean iCustomValidation = false;

    public SaveStudentRequests forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public SaveStudentRequests withRequest(CourseRequestInterface request, boolean keepEnrollments) {
        this.iRequest = request;
        this.iKeepEnrollments = keepEnrollments;
        return this;
    }

    public SaveStudentRequests withCustomValidation(boolean validation) {
        this.iCustomValidation = validation;
        return this;
    }

    public SaveStudentRequests withRequest(CourseRequestInterface request) {
        return this.withRequest(request, true);
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    public boolean getKeepEnrollments() {
        return this.iKeepEnrollments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CourseRequestInterface execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        Throwable throwable2;
        CourseRequestInterface courseRequestInterface;
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), null, this.name());
        helper.beginTransaction();
        try {
            Student student = (Student)StudentDAO.getInstance().get(this.getStudentId(), helper.getHibSession());
            if (student == null) {
                throw new SectioningException(MSG.exceptionBadStudentId());
            }
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (this.getRequest().getStudentId() != null) {
                action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
            }
            if (this.iCustomValidation && CustomCourseRequestsValidationHolder.hasProvider()) {
                this.getRequest().setStudentId(this.getStudentId());
                CustomCourseRequestsValidationHolder.getProvider().submit(server, helper, this.getRequest());
            }
            SaveStudentRequests.saveRequest(server, helper, student, this.getRequest(), this.getKeepEnrollments());
            XStudent oldStudent = server.getStudent(this.getStudentId());
            XStudent newStudent = null;
            try {
                newStudent = ReloadAllData.loadStudentNoCheck(student, server, helper);
                server.update(newStudent, true);
                action.getStudentBuilder().setUniqueId(newStudent.getStudentId()).setExternalId(newStudent.getExternalId()).setName(newStudent.getName());
                for (XRequest r : newStudent.getRequests()) {
                    action.addRequest(OnlineSectioningHelper.toProto(r));
                }
            }
            catch (Exception e) {
                if (!(e instanceof RuntimeException)) throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                throw (RuntimeException)e;
            }
            server.execute(server.createAction(NotifyStudentAction.class).forStudent(this.getStudentId()).oldStudent(oldStudent), helper.getUser());
            helper.commitTransaction();
            courseRequestInterface = this.getRequest();
        }
        catch (Exception e) {
            try {
                helper.rollbackTransaction();
                if (!(e instanceof SectioningException)) throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
                throw (SectioningException)e;
            }
            catch (Throwable throwable2) {
                Object var11_13 = null;
                lock.release();
            }
        }
        Object var11_12 = null;
        lock.release();
        return courseRequestInterface;
        throw throwable2;
    }

    @Override
    public String name() {
        return "save-request";
    }

    public static CourseOffering getCourse(Session hibSession, Long sessionId, Long studentId, CourseRequestInterface.RequestedCourse rc) {
        if (rc.hasCourseId()) {
            return (CourseOffering)CourseOfferingDAO.getInstance().get(rc.getCourseId(), hibSession);
        }
        if (rc.hasCourseName()) {
            return SectioningServlet.lookupCourse(hibSession, sessionId, studentId, rc.getCourseName(), null);
        }
        return null;
    }

    private static CourseOffering getCourse(Session hibSession, long courseId) {
        return (CourseOffering)CourseOfferingDAO.getInstance().get(courseId, hibSession);
    }

    public static Map<Long, CourseRequest> saveRequest(OnlineSectioningServer server, OnlineSectioningHelper helper, Student student, CourseRequestInterface request, boolean keepEnrollments) throws SectioningException {
        CourseRequest cr;
        CourseRequestInterface.RequestedCourse rc;
        CourseRequest cr2;
        Iterator<CourseRequest> requests;
        Iterator i;
        Object cd;
        Object pref;
        XCourseId c;
        FreeTime free;
        CourseDemand adept;
        Iterator i2;
        CourseDemand cd2;
        HashMap<Long, CourseRequestInterface.RequestedCourse> rcs;
        HashMap<Long, Object> preferences;
        ArrayList<CourseOffering> courses;
        TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(student.getCourseDemands());
        int priority = 0;
        Date ts = new Date();
        HashMap<Long, CourseRequest> course2request = new HashMap<Long, CourseRequest>();
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            courses = new ArrayList<CourseOffering>();
            preferences = new HashMap<Long, Object>();
            rcs = new HashMap<Long, CourseRequestInterface.RequestedCourse>();
            for (CourseRequestInterface.RequestedCourse rc2 : r.getRequestedCourse()) {
                if (rc2.isFreeTime()) {
                    for (CourseRequestInterface.FreeTime ft : rc2.getFreeTime()) {
                        cd2 = null;
                        i2 = remaining.iterator();
                        while (i2.hasNext()) {
                            adept = (CourseDemand)i2.next();
                            if (adept.getFreeTime() == null) continue;
                            cd2 = adept;
                            i2.remove();
                            break;
                        }
                        if (cd2 == null) {
                            cd2 = new CourseDemand();
                            cd2.setTimestamp(ts);
                            cd2.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                            student.getCourseDemands().add(cd2);
                            cd2.setStudent(student);
                        }
                        cd2.setAlternative(false);
                        cd2.setPriority(priority);
                        cd2.setWaitlist(false);
                        free = cd2.getFreeTime();
                        if (free == null) {
                            free = new FreeTime();
                            cd2.setFreeTime(free);
                        }
                        free.setCategory(0);
                        free.setDayCode(DayCode.toInt(DayCode.toDayCodes(ft.getDays())));
                        free.setStartSlot(ft.getStart());
                        free.setLength(ft.getLength());
                        free.setSession(student.getSession());
                        free.setName(ft.toString());
                        helper.getHibSession().saveOrUpdate((Object)free);
                        helper.getHibSession().saveOrUpdate((Object)cd2);
                    }
                    ++priority;
                } else if (rc2.isCourse()) {
                    CourseOffering co = null;
                    if (rc2.hasCourseId()) {
                        co = SaveStudentRequests.getCourse(helper.getHibSession(), rc2.getCourseId());
                    } else {
                        c = server == null ? null : server.getCourse(rc2.getCourseName());
                        CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), student.getUniqueId(), rc2) : SaveStudentRequests.getCourse(helper.getHibSession(), c.getCourseId());
                    }
                    if (co != null) {
                        rcs.put(co.getUniqueId(), rc2);
                        courses.add(co);
                        if (server != null) {
                            pref = OnlineSectioningHelper.toPreference(server, rc2, new XCourseId(co));
                            if (pref != null) {
                                preferences.put(co.getUniqueId(), pref);
                            }
                        } else {
                            pref = OnlineSectioningHelper.toPreference(co, rc2);
                            if (pref != null) {
                                preferences.put(co.getUniqueId(), pref);
                            }
                        }
                    }
                }
                if (rc2.getStatus() != CourseRequestInterface.RequestedCourseStatus.NEW_REQUEST && rc2.getStatus() != null) continue;
                rc2.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
            }
            if (courses.isEmpty()) continue;
            cd = null;
            i = remaining.iterator();
            block4: while (i.hasNext()) {
                CourseDemand adept2 = (CourseDemand)i.next();
                if (adept2.getFreeTime() != null) continue;
                for (CourseRequest cr3 : adept2.getCourseRequests()) {
                    if (!cr3.getCourseOffering().getUniqueId().equals(((CourseOffering)courses.get(0)).getUniqueId())) continue;
                    cd = adept2;
                    i.remove();
                    break block4;
                }
            }
            if (cd == null) {
                cd = new CourseDemand();
                ((BaseCourseDemand)cd).setTimestamp(ts);
                ((BaseCourseDemand)cd).setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                ((BaseCourseDemand)cd).setCourseRequests(new HashSet<CourseRequest>());
                ((BaseCourseDemand)cd).setStudent(student);
                student.getCourseDemands().add((CourseDemand)cd);
            }
            ((BaseCourseDemand)cd).setAlternative(false);
            ((BaseCourseDemand)cd).setPriority(priority);
            ((BaseCourseDemand)cd).setWaitlist(r.isWaitList());
            requests = new TreeSet<CourseRequest>(((BaseCourseDemand)cd).getCourseRequests()).iterator();
            int order = 0;
            for (CourseOffering co : courses) {
                cr2 = null;
                if (requests.hasNext()) {
                    cr2 = requests.next();
                } else {
                    cr2 = new CourseRequest();
                    ((BaseCourseDemand)cd).getCourseRequests().add(cr2);
                    cr2.setCourseDemand((CourseDemand)cd);
                }
                cr2.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT, null);
                cr2.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.REQUEST_PREFERENCE, (OnlineSectioningLog.CourseRequestOption.Builder)preferences.get(co.getUniqueId()));
                cr2.setAllowOverlap(false);
                cr2.setCredit(0);
                cr2.setOrder(order++);
                cr2.setCourseOffering(co);
                rc = (CourseRequestInterface.RequestedCourse)rcs.get(co.getUniqueId());
                cr2.setOverrideExternalId(rc == null ? null : rc.getOverrideExternalId());
                cr2.setOverrideTimeStamp(rc == null ? null : rc.getOverrideTimeStamp());
                cr2.setCourseRequestOverrideStatus(rc == null ? null : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED == rc.getStatus() ? CourseRequest.CourseRequestOverrideStatus.APPROVED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING == rc.getStatus() ? CourseRequest.CourseRequestOverrideStatus.PENDING : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED == rc.getStatus() ? CourseRequest.CourseRequestOverrideStatus.CANCELLED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED == rc.getStatus() ? CourseRequest.CourseRequestOverrideStatus.REJECTED : null)))));
                if (rc.getStatus() == null || rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.NEW_REQUEST) {
                    rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                }
                course2request.put(co.getUniqueId(), cr2);
            }
            while (requests.hasNext()) {
                cr = requests.next();
                ((BaseCourseDemand)cd).getCourseRequests().remove(cr);
                helper.getHibSession().delete((Object)cr);
            }
            helper.getHibSession().saveOrUpdate(cd);
            ++priority;
        }
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            courses = new ArrayList();
            preferences = new HashMap();
            rcs = new HashMap();
            for (CourseRequestInterface.RequestedCourse rc2 : r.getRequestedCourse()) {
                if (rc2.isFreeTime()) {
                    for (CourseRequestInterface.FreeTime ft : rc2.getFreeTime()) {
                        cd2 = null;
                        i2 = remaining.iterator();
                        while (i2.hasNext()) {
                            adept = (CourseDemand)i2.next();
                            if (adept.getFreeTime() == null) continue;
                            cd2 = adept;
                            i2.remove();
                            break;
                        }
                        if (cd2 == null) {
                            cd2 = new CourseDemand();
                            cd2.setTimestamp(ts);
                            cd2.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                            student.getCourseDemands().add(cd2);
                            cd2.setStudent(student);
                        }
                        cd2.setAlternative(true);
                        cd2.setPriority(priority);
                        cd2.setWaitlist(false);
                        free = cd2.getFreeTime();
                        if (free == null) {
                            free = new FreeTime();
                            cd2.setFreeTime(free);
                        }
                        free.setCategory(0);
                        free.setDayCode(DayCode.toInt(DayCode.toDayCodes(ft.getDays())));
                        free.setStartSlot(ft.getStart());
                        free.setLength(ft.getLength());
                        free.setSession(student.getSession());
                        free.setName(ft.toString());
                        helper.getHibSession().saveOrUpdate((Object)free);
                        helper.getHibSession().saveOrUpdate((Object)cd2);
                    }
                    ++priority;
                } else if (rc2.isCourse()) {
                    CourseOffering co = null;
                    if (rc2.hasCourseId()) {
                        co = SaveStudentRequests.getCourse(helper.getHibSession(), rc2.getCourseId());
                    } else {
                        c = server == null ? null : server.getCourse(rc2.getCourseName());
                        CourseOffering courseOffering = co = c == null ? SaveStudentRequests.getCourse(helper.getHibSession(), request.getAcademicSessionId(), student.getUniqueId(), rc2) : SaveStudentRequests.getCourse(helper.getHibSession(), c.getCourseId());
                    }
                    if (co != null) {
                        rcs.put(co.getUniqueId(), rc2);
                        courses.add(co);
                        if (server != null) {
                            pref = OnlineSectioningHelper.toPreference(server, rc2, new XCourseId(co));
                            if (pref != null) {
                                preferences.put(co.getUniqueId(), pref);
                            }
                        } else {
                            pref = OnlineSectioningHelper.toPreference(co, rc2);
                            if (pref != null) {
                                preferences.put(co.getUniqueId(), pref);
                            }
                        }
                    }
                }
                if (rc2.getStatus() != CourseRequestInterface.RequestedCourseStatus.NEW_REQUEST && rc2.getStatus() != null) continue;
                rc2.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
            }
            if (courses.isEmpty()) continue;
            cd = null;
            i = remaining.iterator();
            block12: while (i.hasNext()) {
                CourseDemand adept3 = (CourseDemand)i.next();
                if (adept3.getFreeTime() != null) continue;
                for (CourseRequest cr3 : adept3.getCourseRequests()) {
                    if (!cr3.getCourseOffering().getUniqueId().equals(((CourseOffering)courses.get(0)).getUniqueId())) continue;
                    cd = adept3;
                    i.remove();
                    break block12;
                }
            }
            if (cd == null) {
                cd = new CourseDemand();
                ((BaseCourseDemand)cd).setTimestamp(ts);
                ((BaseCourseDemand)cd).setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                ((BaseCourseDemand)cd).setCourseRequests(new HashSet<CourseRequest>());
                ((BaseCourseDemand)cd).setStudent(student);
                student.getCourseDemands().add((CourseDemand)cd);
            }
            ((BaseCourseDemand)cd).setAlternative(true);
            ((BaseCourseDemand)cd).setPriority(priority);
            ((BaseCourseDemand)cd).setWaitlist(r.isWaitList());
            requests = new TreeSet<CourseRequest>(((BaseCourseDemand)cd).getCourseRequests()).iterator();
            int order = 0;
            for (CourseOffering co : courses) {
                cr2 = null;
                if (requests.hasNext()) {
                    cr2 = requests.next();
                } else {
                    cr2 = new CourseRequest();
                    ((BaseCourseDemand)cd).getCourseRequests().add(cr2);
                    cr2.setCourseDemand((CourseDemand)cd);
                }
                cr2.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT, null);
                cr2.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.REQUEST_PREFERENCE, (OnlineSectioningLog.CourseRequestOption.Builder)preferences.get(co.getUniqueId()));
                cr2.setAllowOverlap(false);
                cr2.setCredit(0);
                cr2.setOrder(order++);
                cr2.setCourseOffering(co);
                rc = (CourseRequestInterface.RequestedCourse)rcs.get(co.getUniqueId());
                cr2.setOverrideExternalId(rc == null ? null : rc.getOverrideExternalId());
                cr2.setOverrideTimeStamp(rc == null ? null : rc.getOverrideTimeStamp());
                cr2.setCourseRequestOverrideStatus(rc == null ? null : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED == rc.getStatus() ? CourseRequest.CourseRequestOverrideStatus.APPROVED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING == rc.getStatus() ? CourseRequest.CourseRequestOverrideStatus.PENDING : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED == rc.getStatus() ? CourseRequest.CourseRequestOverrideStatus.CANCELLED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED == rc.getStatus() ? CourseRequest.CourseRequestOverrideStatus.REJECTED : null)))));
                if (rc.getStatus() == null || rc.getStatus() == CourseRequestInterface.RequestedCourseStatus.NEW_REQUEST) {
                    rc.setStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
                }
                course2request.put(co.getUniqueId(), cr2);
            }
            while (requests.hasNext()) {
                cr = requests.next();
                ((BaseCourseDemand)cd).getCourseRequests().remove(cr);
                helper.getHibSession().delete((Object)cr);
            }
            helper.getHibSession().saveOrUpdate(cd);
            ++priority;
        }
        Iterator<StudentClassEnrollment> i3 = student.getClassEnrollments().iterator();
        while (i3.hasNext()) {
            StudentClassEnrollment enrl = i3.next();
            if (keepEnrollments) {
                CourseRequest cr4 = (CourseRequest)course2request.get(enrl.getCourseOffering().getUniqueId());
                if (cr4 == null) {
                    enrl.getClazz().getStudentEnrollments().remove(enrl);
                    helper.getHibSession().delete((Object)enrl);
                    i3.remove();
                    continue;
                }
                enrl.setCourseRequest(cr4);
                helper.getHibSession().saveOrUpdate((Object)enrl);
                continue;
            }
            enrl.getClazz().getStudentEnrollments().remove(enrl);
            helper.getHibSession().delete((Object)enrl);
            i3.remove();
        }
        if (!keepEnrollments) {
            for (CourseDemand cd3 : student.getCourseDemands()) {
                if (cd3.getCourseRequests() == null) continue;
                for (CourseRequest cr5 : cd3.getCourseRequests()) {
                    if (cr5.getClassWaitLists() == null) continue;
                    Iterator<ClassWaitList> i4 = cr5.getClassWaitLists().iterator();
                    while (i4.hasNext()) {
                        helper.getHibSession().delete((Object)i4.next());
                        i4.remove();
                    }
                }
            }
        }
        for (CourseDemand cd3 : remaining) {
            if (cd3.getFreeTime() != null) {
                helper.getHibSession().delete((Object)cd3.getFreeTime());
            }
            for (CourseRequest cr5 : cd3.getCourseRequests()) {
                helper.getHibSession().delete((Object)cr5);
            }
            student.getCourseDemands().remove(cd3);
            helper.getHibSession().delete((Object)cd3);
        }
        student.setMaxCredit(request.getMaxCredit());
        student.setOverrideExternalId(request.getMaxCreditOverrideExternalId());
        student.setOverrideTimeStamp(request.getMaxCreditOverrideTimeStamp());
        student.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED == request.getMaxCreditOverrideStatus() ? CourseRequest.CourseRequestOverrideStatus.APPROVED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING == request.getMaxCreditOverrideStatus() ? CourseRequest.CourseRequestOverrideStatus.PENDING : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED == request.getMaxCreditOverrideStatus() ? CourseRequest.CourseRequestOverrideStatus.CANCELLED : (CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED == request.getMaxCreditOverrideStatus() ? CourseRequest.CourseRequestOverrideStatus.REJECTED : null))));
        student.setOverrideMaxCredit(request.getMaxCreditOverride());
        helper.getHibSession().saveOrUpdate((Object)student);
        helper.getHibSession().flush();
        return course2request;
    }
}

