/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.test;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.OnlineSectioningTestFwk;
import org.unitime.timetable.onlinesectioning.basic.GetRequest;
import org.unitime.timetable.onlinesectioning.match.AnyCourseMatcher;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.updates.ClassAssignmentChanged;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadTest
extends OnlineSectioningTestFwk {
    @Override
    public List<OnlineSectioningTestFwk.Operation> operations() {
        Session hibSession = new _RootDAO().getSession();
        ArrayList<OnlineSectioningTestFwk.Operation> loadRequests = new ArrayList<OnlineSectioningTestFwk.Operation>();
        for (final Long studentId : hibSession.createQuery("select s.uniqueId from Student s where s.session.uniqueId = :sessionId").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list()) {
            loadRequests.add(new OnlineSectioningTestFwk.Operation(){

                public double execute(OnlineSectioningServer s) {
                    sLog.info((Object)("Reloading " + studentId + " ..."));
                    s.execute(s.createAction(ReloadStudent.class).forStudents(studentId), ReloadTest.this.user());
                    sLog.info((Object)("  -- " + studentId + " reloaded"));
                    return 1.0;
                }
            });
        }
        for (final Long offeringId : hibSession.createQuery("select io.uniqueId from InstructionalOffering io where io.session.uniqueId = :sessionId and io.notOffered = false").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list()) {
            loadRequests.add(new OnlineSectioningTestFwk.Operation(){

                public double execute(OnlineSectioningServer s) {
                    sLog.info((Object)("Locking " + offeringId + " ..."));
                    s.lockOffering(offeringId);
                    sLog.info((Object)("  -- " + offeringId + " locked"));
                    long delay = Math.round(Math.random() * 5000.0);
                    sLog.info((Object)("Sleeping for " + delay + " ms  ..."));
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    sLog.info((Object)("Unlocking " + offeringId + " ..."));
                    s.unlockOffering(offeringId);
                    sLog.info((Object)("  -- " + offeringId + " unlocked"));
                    return 1.0;
                }
            });
        }
        for (final String name : hibSession.createQuery("select co.subjectAreaAbbv || ' ' || co.courseNbr from CourseOffering co where co.instructionalOffering.session.uniqueId = :sessionId and co.instructionalOffering.notOffered = false").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list()) {
            loadRequests.add(new OnlineSectioningTestFwk.Operation(){

                public double execute(OnlineSectioningServer s) {
                    for (int i = 1; i < name.length(); ++i) {
                        sLog.info((Object)("Looking for " + name.substring(0, i) + " ..."));
                        s.findCourses(name.substring(0, i), 20, new AnyCourseMatcher());
                    }
                    return 1.0;
                }
            });
        }
        for (final Long classId : hibSession.createQuery("select c.uniqueId from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list()) {
            loadRequests.add(new OnlineSectioningTestFwk.Operation(){

                public double execute(OnlineSectioningServer s) {
                    sLog.info((Object)("Assignment changed for " + classId + " ..."));
                    s.execute(s.createAction(ClassAssignmentChanged.class).forClasses(classId), ReloadTest.this.user());
                    return 1.0;
                }
            });
        }
        for (final Long studentId : hibSession.createQuery("select s.uniqueId from Student s where s.session.uniqueId = :sessionId").setLong("sessionId", this.getServer().getAcademicSession().getUniqueId().longValue()).list()) {
            CourseRequestInterface request = this.getServer().execute(this.createAction(GetRequest.class).forStudent(studentId), this.user());
            if (request == null || request.getCourses().isEmpty()) continue;
            loadRequests.add(new OnlineSectioningTestFwk.Operation(){

                public double execute(OnlineSectioningServer s) {
                    CourseRequestInterface request = s.execute(ReloadTest.this.createAction(GetRequest.class).forStudent(studentId), ReloadTest.this.user());
                    if (request != null && !request.getCourses().isEmpty()) {
                        sLog.info((Object)("Find assignments for " + studentId + " ..."));
                        FindAssignmentAction action = s.createAction(FindAssignmentAction.class).forRequest(request).withAssignment(new ArrayList<ClassAssignmentInterface.ClassAssignment>());
                        List<ClassAssignmentInterface> ret = s.execute(action, ReloadTest.this.user());
                        return ret == null || ret.isEmpty() ? 0.0 : ret.get(0).getValue();
                    }
                    return 1.0;
                }
            });
        }
        hibSession.close();
        return loadRequests;
    }

    public static void main(String[] args) {
        new ReloadTest().test(-1, 20);
    }
}

