/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.cpsolver.studentsct.model.Course;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCredit;

@SerializeWith(value=XCourseSerializer.class)
public class XCourse
extends XCourseId {
    private static final long serialVersionUID = 1L;
    private String iSubjectArea = null;
    private String iCourseNumber = null;
    private String iDepartment = null;
    private String iConsentLabel = null;
    private String iConsentAbbv = null;
    private String iNote = null;
    private String iDetails = null;
    private int iLimit = 0;
    private int iProjected = 0;
    private Integer iWkEnroll = null;
    private Integer iWkChange = null;
    private Integer iWkDrop = null;
    private XCredit iCredit = null;
    private Long iAlternativeCourseId = null;
    private boolean iControl = false;

    public XCourse() {
    }

    public XCourse(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCourse(CourseOffering course, OnlineSectioningHelper helper) {
        this(course);
    }

    public XCourse(CourseOffering course) {
        super(course);
        this.iSubjectArea = course.getSubjectAreaAbbv().trim();
        this.iCourseNumber = course.getCourseNbr().trim();
        this.iNote = course.getScheduleBookNote();
        this.iDepartment = course.getSubjectArea().getDepartment().getDeptCode() == null ? course.getSubjectArea().getDepartment().getAbbreviation() : course.getSubjectArea().getDepartment().getDeptCode();
        boolean unlimited = false;
        this.iLimit = 0;
        for (InstrOfferingConfig config : course.getInstructionalOffering().getInstrOfferingConfigs()) {
            if (config.isUnlimitedEnrollment().booleanValue()) {
                unlimited = true;
            }
            this.iLimit += config.getLimit().intValue();
        }
        if (course.getReservation() != null) {
            this.iLimit = course.getReservation();
        }
        if (this.iLimit >= 9999) {
            unlimited = true;
        }
        if (unlimited) {
            this.iLimit = -1;
        }
        this.iProjected = course.getProjectedDemand() != null ? course.getProjectedDemand() : (course.getDemand() != null ? course.getDemand() : 0);
        this.iWkEnroll = course.getInstructionalOffering().getLastWeekToEnroll();
        this.iWkChange = course.getInstructionalOffering().getLastWeekToChange();
        this.iWkDrop = course.getInstructionalOffering().getLastWeekToDrop();
        if (course.getConsentType() != null) {
            this.iConsentLabel = course.getConsentType().getLabel();
            this.iConsentAbbv = course.getConsentType().getAbbv();
        }
        if (course.getCredit() != null) {
            this.iCredit = new XCredit(course.getCredit());
        }
        this.iAlternativeCourseId = course.getAlternativeOffering() == null ? null : course.getAlternativeOffering().getUniqueId();
        this.iControl = course.isIsControl();
    }

    public XCourse(Course course) {
        super(course);
        this.iSubjectArea = course.getSubjectArea();
        this.iCourseNumber = course.getCourseNumber();
        this.iNote = course.getNote();
        this.iLimit = course.getLimit();
        this.iProjected = course.getProjected();
        if (course.getCredit() != null) {
            this.iCredit = new XCredit(course.getCredit());
        }
        this.iControl = course.getName().equals(course.getOffering().getName());
    }

    public String getSubjectArea() {
        return this.iSubjectArea;
    }

    public String getCourseNumber() {
        return this.iCourseNumber;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public int getProjected() {
        return this.iProjected;
    }

    public Integer getLastWeekToEnroll() {
        return this.iWkEnroll;
    }

    public Integer getLastWeekToChange() {
        return this.iWkChange;
    }

    public Integer getLastWeekToDrop() {
        return this.iWkDrop;
    }

    public String getDepartment() {
        return this.iDepartment;
    }

    public String getConsentLabel() {
        return this.iConsentLabel;
    }

    public String getConsentAbbv() {
        return this.iConsentAbbv;
    }

    public String getNote() {
        return this.iNote;
    }

    public String getDetails(AcademicSessionInfo session, CourseDetailsProvider provider) throws SectioningException {
        if (this.iDetails == null && provider != null) {
            this.iDetails = provider.getDetails(session, this.getSubjectArea(), this.getCourseNumber());
        }
        return this.iDetails;
    }

    public XCredit getCreditInfo() {
        return this.iCredit;
    }

    public boolean hasCredit() {
        return this.iCredit != null;
    }

    public String getCreditAbbv() {
        return this.iCredit == null ? null : this.iCredit.getAbbreviation();
    }

    public String getCreditText() {
        return this.iCredit == null ? null : this.iCredit.getText();
    }

    public String getCredit() {
        return this.iCredit == null ? null : this.iCredit.getAbbreviation() + "|" + this.iCredit.getText();
    }

    public Float getMinCredit() {
        return this.iCredit != null ? this.iCredit.getMinCredit() : null;
    }

    public Float getMaxCredit() {
        return this.iCredit != null ? this.iCredit.getMaxCredit() : null;
    }

    public boolean hasAlternativeCourse() {
        return this.iAlternativeCourseId != null;
    }

    public Long getAlternativeCourseId() {
        return this.iAlternativeCourseId;
    }

    public boolean isControlling() {
        return this.iControl;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iSubjectArea = (String)in.readObject();
        this.iCourseNumber = (String)in.readObject();
        this.iDepartment = (String)in.readObject();
        this.iConsentLabel = (String)in.readObject();
        this.iConsentAbbv = (String)in.readObject();
        this.iNote = (String)in.readObject();
        this.iDetails = (String)in.readObject();
        this.iLimit = in.readInt();
        this.iProjected = in.readInt();
        this.iWkEnroll = in.readBoolean() ? Integer.valueOf(in.readInt()) : null;
        this.iWkChange = in.readBoolean() ? Integer.valueOf(in.readInt()) : null;
        this.iWkDrop = in.readBoolean() ? Integer.valueOf(in.readInt()) : null;
        this.iCredit = in.readBoolean() ? new XCredit(in) : null;
        this.iAlternativeCourseId = in.readBoolean() ? Long.valueOf(in.readLong()) : null;
        this.iControl = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.iSubjectArea);
        out.writeObject(this.iCourseNumber);
        out.writeObject(this.iDepartment);
        out.writeObject(this.iConsentLabel);
        out.writeObject(this.iConsentAbbv);
        out.writeObject(this.iNote);
        out.writeObject(this.iDetails);
        out.writeInt(this.iLimit);
        out.writeInt(this.iProjected);
        out.writeBoolean(this.iWkEnroll != null);
        if (this.iWkEnroll != null) {
            out.writeInt(this.iWkEnroll);
        }
        out.writeBoolean(this.iWkChange != null);
        if (this.iWkChange != null) {
            out.writeInt(this.iWkChange);
        }
        out.writeBoolean(this.iWkDrop != null);
        if (this.iWkDrop != null) {
            out.writeInt(this.iWkDrop);
        }
        out.writeBoolean(this.iCredit != null);
        if (this.iCredit != null) {
            this.iCredit.writeExternal(out);
        }
        out.writeBoolean(this.iAlternativeCourseId != null);
        if (this.iAlternativeCourseId != null) {
            out.writeLong(this.iAlternativeCourseId);
        }
        out.writeBoolean(this.iControl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XCourseSerializer
    implements Externalizer<XCourse> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, XCourse object) throws IOException {
            object.writeExternal(output);
        }

        public XCourse readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new XCourse(input);
        }
    }
}

