/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;
import org.unitime.timetable.interfaces.ExternalClassLookupInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.SpecialRegistrationProvider;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.util.DefaultExternalClassLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurdueSpecialRegistrationProvider
implements SpecialRegistrationProvider {
    private static Logger sLog = Logger.getLogger(PurdueSpecialRegistrationProvider.class);
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;
    private ExternalClassLookupInterface iExternalClassLookup;

    public PurdueSpecialRegistrationProvider() {
        String clazz;
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        try {
            clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
        try {
            clazz = ApplicationProperty.CustomizationExternalClassLookup.value();
            this.iExternalClassLookup = clazz == null || clazz.isEmpty() ? new DefaultExternalClassLookup() : (ExternalClassLookupInterface)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external class lookup, using the default one instead.", (Throwable)e);
            this.iExternalClassLookup = new DefaultExternalClassLookup();
        }
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiSiteRetrieveRegistration() {
        return ApplicationProperties.getProperty("purdue.specreg.site.retrieveRegistration", this.getSpecialRegistrationApiSite() + "/retrieveRegistration");
    }

    protected String getSpecialRegistrationApiSiteSubmitRegistration() {
        return ApplicationProperties.getProperty("purdue.specreg.site.submitRegistration", this.getSpecialRegistrationApiSite() + "/submitRegistration");
    }

    protected String getSpecialRegistrationApiSiteCheckEligibility() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkEligibility", this.getSpecialRegistrationApiSite() + "/checkEligibility");
    }

    protected String getSpecialRegistrationApiSiteGetAllRegistrations() {
        return ApplicationProperties.getProperty("purdue.specreg.site.retrieveAllRegistrations", null);
    }

    protected String getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected String getSpecialRegistrationMode() {
        return ApplicationProperties.getProperty("purdue.specreg.mode", "REG");
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getRequestorId(OnlineSectioningLog.Entity user) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        String id = user.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getRequestorType(OnlineSectioningLog.Entity user, XStudent student) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        if (user.hasType()) {
            return user.getType().name();
        }
        return user.getExternalId().equals(student.getExternalId()) ? "STUDENT" : "MANAGER";
    }

    protected List<SpecialRegistrationInterface.Change> buildChangeList(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, Collection<ClassAssignmentInterface.ClassAssignment> assignment, Collection<ClassAssignmentInterface.ErrorMessage> errors) {
        ArrayList<SpecialRegistrationInterface.Change> changes = new ArrayList<SpecialRegistrationInterface.Change>();
        HashMap<XCourse, Object> enrollments = new HashMap<XCourse, Object>();
        HashMap<Long, XOffering> offerings = new HashMap<Long, XOffering>();
        for (ClassAssignmentInterface.ClassAssignment classAssignment : assignment) {
            Object sections;
            if (classAssignment == null || classAssignment.isFreeTime() || classAssignment.getClassId() == null || classAssignment.isDummy() || classAssignment.isTeachingAssignment()) continue;
            XCourse xCourse = server.getCourse(classAssignment.getCourseId());
            if (xCourse == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(MSG.courseName(classAssignment.getSubject(), classAssignment.getClassNumber())));
            }
            XOffering offering = server.getOffering(xCourse.getOfferingId());
            if (offering == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(MSG.courseName(classAssignment.getSubject(), classAssignment.getClassNumber())));
            }
            XSection section = offering.getSection(classAssignment.getClassId());
            if (section == null) {
                throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.clazz(classAssignment.getSubject(), classAssignment.getCourseNbr(), classAssignment.getSubpart(), classAssignment.getSection())));
            }
            if (section.isCancelled()) {
                if (server.getConfig().getPropertyBoolean("Enrollment.CanKeepCancelledClass", false)) {
                    boolean contains = false;
                    for (XRequest r : student.getRequests()) {
                        Object cr;
                        if (!(r instanceof XCourseRequest) || ((XCourseRequest)(cr = (XCourseRequest)r)).getEnrollment() == null || !((XCourseRequest)cr).getEnrollment().getSectionIds().contains(section.getSectionId())) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) {
                        throw new SectioningException(MSG.exceptionEnrollCancelled(MSG.clazz(classAssignment.getSubject(), classAssignment.getCourseNbr(), classAssignment.getSubpart(), classAssignment.getSection())));
                    }
                } else {
                    throw new SectioningException(MSG.exceptionEnrollCancelled(MSG.clazz(classAssignment.getSubject(), classAssignment.getCourseNbr(), classAssignment.getSubpart(), classAssignment.getSection())));
                }
            }
            if ((sections = (List)enrollments.get(xCourse)) == null) {
                sections = new ArrayList();
                enrollments.put(xCourse, sections);
            }
            sections.add((XSection)section);
            offerings.put(xCourse.getCourseId(), offering);
        }
        HashSet<String> crns = new HashSet<String>();
        block2: for (Map.Entry entry : enrollments.entrySet()) {
            XCourse course = (XCourse)entry.getKey();
            List sections = (List)entry.getValue();
            for (XRequest r : student.getRequests()) {
                XEnrollment enrollment;
                if (!(r instanceof XCourseRequest) || (enrollment = ((XCourseRequest)r).getEnrollment()) == null || !enrollment.getCourseId().equals(course.getCourseId())) continue;
                for (XSection s : sections) {
                    if (enrollment.getSectionIds().contains(s.getSectionId())) continue;
                    SpecialRegistrationInterface.Change ch = new SpecialRegistrationInterface.Change();
                    ch.subject = course.getSubjectArea();
                    ch.courseNbr = course.getCourseNumber();
                    ch.crn = s.getExternalId(course.getCourseId());
                    ch.operation = SpecialRegistrationInterface.ChangeOperation.ADD.name();
                    if (!crns.add(ch.crn)) continue;
                    changes.add(ch);
                }
                for (Long id : enrollment.getSectionIds()) {
                    XSection s = ((XOffering)offerings.get(course.getCourseId())).getSection(id);
                    if (sections.contains(s)) continue;
                    SpecialRegistrationInterface.Change ch = new SpecialRegistrationInterface.Change();
                    ch.subject = course.getSubjectArea();
                    ch.courseNbr = course.getCourseNumber();
                    ch.crn = s.getExternalId(course.getCourseId());
                    ch.operation = SpecialRegistrationInterface.ChangeOperation.DROP.name();
                    if (!crns.add(ch.crn)) continue;
                    changes.add(ch);
                }
                continue block2;
            }
            for (XSection section : sections) {
                SpecialRegistrationInterface.Change ch = new SpecialRegistrationInterface.Change();
                ch.subject = course.getSubjectArea();
                ch.courseNbr = course.getCourseNumber();
                ch.crn = section.getExternalId(course.getCourseId());
                ch.operation = SpecialRegistrationInterface.ChangeOperation.ADD.name();
                if (!crns.add(ch.crn)) continue;
                changes.add(ch);
            }
        }
        for (XRequest xRequest : student.getRequests()) {
            XOffering offering;
            XEnrollment enrollment;
            if (!(xRequest instanceof XCourseRequest) || (enrollment = ((XCourseRequest)xRequest).getEnrollment()) == null || offerings.containsKey(enrollment.getCourseId()) || (offering = server.getOffering(enrollment.getOfferingId())) == null) continue;
            for (XSection section : offering.getSections(enrollment)) {
                XCourse course = offering.getCourse(enrollment.getCourseId());
                SpecialRegistrationInterface.Change ch = new SpecialRegistrationInterface.Change();
                ch.subject = course.getSubjectArea();
                ch.courseNbr = course.getCourseNumber();
                ch.crn = section.getExternalId(course.getCourseId());
                ch.operation = SpecialRegistrationInterface.ChangeOperation.DROP.name();
                changes.add(ch);
            }
        }
        if (errors != null) {
            HashSet<ClassAssignmentInterface.ErrorMessage> hashSet = new HashSet<ClassAssignmentInterface.ErrorMessage>();
            for (SpecialRegistrationInterface.Change ch : changes) {
                for (ClassAssignmentInterface.ErrorMessage m : errors) {
                    if (!ch.crn.equals(m.getSection()) || !hashSet.add(m)) continue;
                    if (ch.errors == null) {
                        ch.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                    }
                    SpecialRegistrationInterface.ChangeError er = new SpecialRegistrationInterface.ChangeError();
                    er.code = m.getCode();
                    er.message = m.getMessage();
                    ch.errors.add(er);
                }
            }
        }
        return changes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.SpecialRegistrationEligibilityRequest input) throws SectioningException {
        SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse specialRegistrationEligibilityResponse;
        ClientResource resource;
        block35: {
            SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse specialRegistrationEligibilityResponse2;
            block34: {
                SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse specialRegistrationEligibilityResponse3;
                block33: {
                    SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse term2;
                    block32: {
                        SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse session2;
                        block31: {
                            SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse specialRegistrationEligibilityResponse4;
                            block30: {
                                if (student == null) {
                                    return new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(false, "No student.");
                                }
                                if (!this.isSpecialRegistrationEnabled(server, helper, student)) {
                                    return new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(false, "Special registration is disabled.");
                                }
                                resource = null;
                                try {
                                    try {
                                        if (this.getSpecialRegistrationApiSiteCheckEligibility() != null) {
                                            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
                                            resource.setNext((Uniform)this.iClient);
                                            AcademicSessionInfo session2 = server.getAcademicSession();
                                            String term2 = this.getBannerTerm(session2);
                                            String campus = this.getBannerCampus(session2);
                                            resource.addQueryParameter("term", term2);
                                            resource.addQueryParameter("campus", campus);
                                            resource.addQueryParameter("studentId", this.getBannerId(student));
                                            resource.addQueryParameter("mode", this.getSpecialRegistrationMode());
                                            helper.getAction().addOptionBuilder().setKey("term").setValue(term2);
                                            helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                                            helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
                                            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                                            long t0 = System.currentTimeMillis();
                                            resource.get(MediaType.APPLICATION_JSON);
                                            helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                                            SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse.class).getObject();
                                            Gson gson = this.getGson(helper);
                                            if (helper.isDebugEnabled()) {
                                                helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
                                            }
                                            helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)eligibility));
                                            if (!SpecialRegistrationInterface.ResponseStatus.success.name().equals(eligibility.status)) {
                                                specialRegistrationEligibilityResponse4 = new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(false, eligibility.message == null || eligibility.message.isEmpty() ? "Failed to check student eligibility (" + eligibility.status + ")." : eligibility.message);
                                                Object var18_23 = null;
                                                if (resource == null) return specialRegistrationEligibilityResponse4;
                                                break block30;
                                            } else {
                                                boolean eligible = true;
                                                if (eligibility.data == null || eligibility.data.eligible == null || !eligibility.data.eligible.booleanValue()) {
                                                    eligible = false;
                                                }
                                                String message = null;
                                                if (eligibility.data != null && eligibility.data.eligibilityProblems != null) {
                                                    for (SpecialRegistrationInterface.EligibilityProblem p : eligibility.data.eligibilityProblems) {
                                                        if (message == null) {
                                                            message = p.message;
                                                            continue;
                                                        }
                                                        message = message + "\n" + p.message;
                                                    }
                                                }
                                                SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse specialRegistrationEligibilityResponse5 = new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(eligible, message);
                                                Object var18_24 = null;
                                                if (resource == null) return specialRegistrationEligibilityResponse5;
                                                if (resource.getResponse() != null) {
                                                    resource.getResponse().release();
                                                }
                                                resource.release();
                                                return specialRegistrationEligibilityResponse5;
                                            }
                                        }
                                        if (!input.hasErrors()) {
                                            session2 = new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(true, null);
                                            break block31;
                                        }
                                        HashSet<String> errors = new HashSet<String>();
                                        for (ClassAssignmentInterface.ErrorMessage m : input.getErrors()) {
                                            if (m.getCode() == null) continue;
                                            errors.add(m.getCode());
                                        }
                                        if (errors.isEmpty()) {
                                            term2 = new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(true, null);
                                            break block32;
                                        }
                                        Gson gson = this.getGson(helper);
                                        resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
                                        resource.setNext((Uniform)this.iClient);
                                        AcademicSessionInfo session3 = server.getAcademicSession();
                                        String term3 = this.getBannerTerm(session3);
                                        String campus = this.getBannerCampus(session3);
                                        resource.addQueryParameter("term", term3);
                                        resource.addQueryParameter("campus", campus);
                                        resource.addQueryParameter("studentId", this.getBannerId(student));
                                        helper.getAction().addOptionBuilder().setKey("term").setValue(term3);
                                        helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                                        helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
                                        helper.getAction().addOptionBuilder().setKey("errors").setValue(((Object)errors).toString());
                                        resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                                        long t1 = System.currentTimeMillis();
                                        resource.get(MediaType.APPLICATION_JSON);
                                        helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                                        SpecialRegistrationInterface.SpecialRegistrationStatusResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
                                        if (helper.isDebugEnabled()) {
                                            helper.debug("Response: " + gson.toJson((Object)response));
                                        }
                                        helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
                                        if (response != null && SpecialRegistrationInterface.ResponseStatus.success.name().equals(response.status) && response.data != null && response.data.overrides != null) {
                                            for (String error : errors) {
                                                if (response.data.overrides.contains(error)) continue;
                                                specialRegistrationEligibilityResponse3 = new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(false, "Missing " + error + " override.");
                                                break block33;
                                            }
                                            specialRegistrationEligibilityResponse2 = new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(true, null);
                                            break block34;
                                        }
                                        specialRegistrationEligibilityResponse = new SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse(false, response != null ? response.message : null);
                                        break block35;
                                    }
                                    catch (SectioningException e) {
                                        helper.getAction().setApiException(e.getMessage());
                                        throw e;
                                    }
                                    catch (Exception e) {
                                        helper.getAction().setApiException(e.getMessage());
                                        sLog.error((Object)e.getMessage(), (Throwable)e);
                                        throw new SectioningException(e.getMessage());
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var18_30 = null;
                                    if (resource == null) throw throwable;
                                    if (resource.getResponse() != null) {
                                        resource.getResponse().release();
                                    }
                                    resource.release();
                                    throw throwable;
                                }
                            }
                            if (resource.getResponse() != null) {
                                resource.getResponse().release();
                            }
                            resource.release();
                            return specialRegistrationEligibilityResponse4;
                        }
                        Object var18_25 = null;
                        if (resource == null) return session2;
                        if (resource.getResponse() != null) {
                            resource.getResponse().release();
                        }
                        resource.release();
                        return session2;
                    }
                    Object var18_26 = null;
                    if (resource == null) return term2;
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                    return term2;
                }
                Object var18_27 = null;
                if (resource == null) return specialRegistrationEligibilityResponse3;
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
                return specialRegistrationEligibilityResponse3;
            }
            Object var18_28 = null;
            if (resource == null) return specialRegistrationEligibilityResponse2;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            return specialRegistrationEligibilityResponse2;
        }
        Object var18_29 = null;
        if (resource == null) return specialRegistrationEligibilityResponse;
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
        return specialRegistrationEligibilityResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SpecialRegistrationInterface.SubmitSpecialRegistrationResponse submitRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.SubmitSpecialRegistrationRequest input) throws SectioningException {
        SpecialRegistrationInterface.SubmitSpecialRegistrationResponse submitSpecialRegistrationResponse;
        ClientResource resource = null;
        try {
            try {
                SpecialRegistrationInterface.SpecialRegistrationRequest request = new SpecialRegistrationInterface.SpecialRegistrationRequest();
                AcademicSessionInfo session = server.getAcademicSession();
                request.term = this.getBannerTerm(session);
                request.campus = this.getBannerCampus(session);
                request.studentId = this.getBannerId(student);
                request.changes = this.buildChangeList(server, helper, student, input.getClassAssignments(), input.getErrors());
                request.requestId = input.getRequestId();
                request.mode = this.getSpecialRegistrationMode();
                if (helper.getUser() != null) {
                    request.requestorId = this.getRequestorId(helper.getUser());
                    request.requestorRole = this.getRequestorType(helper.getUser(), student);
                }
                if (request.changes == null) throw new SectioningException("There are no changes.");
                if (request.changes.isEmpty()) {
                    throw new SectioningException("There are no changes.");
                }
                resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
                resource.setNext((Uniform)this.iClient);
                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                if (input.getRequestKey() != null && !input.getRequestKey().isEmpty()) {
                    resource.addQueryParameter("reqKey", input.getRequestKey());
                }
                Gson gson = this.getGson(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Request: " + gson.toJson((Object)request));
                }
                helper.getAction().addOptionBuilder().setKey("specreg_request").setValue(gson.toJson((Object)request));
                long t1 = System.currentTimeMillis();
                resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(request));
                helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                SpecialRegistrationInterface.SpecialRegistrationResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponse.class).getObject();
                if (helper.isDebugEnabled()) {
                    helper.debug("Response: " + gson.toJson((Object)response));
                }
                helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
                SpecialRegistrationInterface.SubmitSpecialRegistrationResponse ret = new SpecialRegistrationInterface.SubmitSpecialRegistrationResponse();
                ret.setMessage(response.message);
                ret.setSuccess(SpecialRegistrationInterface.ResponseStatus.success.name().equals(response.status));
                if (response.data != null) {
                    ret.setRequestId(response.data.requestId);
                    ret.setCanEnroll(SpecialRegistrationInterface.RequestStatus.maySubmit.name().equals(response.data.status) || SpecialRegistrationInterface.RequestStatus.approved.name().equals(response.data.status));
                    ret.setCanSubmit(SpecialRegistrationInterface.RequestStatus.mayEdit.name().equals(response.data.status) || SpecialRegistrationInterface.RequestStatus.draft.name().equals(response.data.status));
                } else {
                    ret.setCanEnroll(false);
                    ret.setCanSubmit(false);
                }
                submitSpecialRegistrationResponse = ret;
                Object var15_15 = null;
                if (resource == null) return submitSpecialRegistrationResponse;
            }
            catch (SectioningException e) {
                helper.getAction().setApiException(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                helper.getAction().setApiException(e.getMessage());
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (resource == null) throw throwable;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            throw throwable;
        }
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
        return submitSpecialRegistrationResponse;
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected CourseOffering findCourseByExternalId(Long sessionId, String externalId) {
        return this.iExternalClassLookup.findCourseByExternalId(sessionId, externalId);
    }

    protected List<Class_> findClassesByExternalId(Long sessionId, String externalId) {
        return this.iExternalClassLookup.findClassesByExternalId(sessionId, externalId);
    }

    protected boolean isDrop(XEnrollment enrollment, List<SpecialRegistrationInterface.Change> changes) {
        return false;
    }

    protected List<XRequest> getRequests(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, Map<CourseOffering, List<Class_>> adds, Map<CourseOffering, List<Class_>> drops) {
        Student dbStudent = (Student)StudentDAO.getInstance().get(student.getStudentId(), helper.getHibSession());
        ArrayList<XRequest> requests = new ArrayList<XRequest>();
        HashSet<CourseOffering> remaining = new HashSet<CourseOffering>(adds.keySet());
        for (XRequest request : student.getRequests()) {
            if (request instanceof XCourseRequest) {
                HashSet<Long> classIds;
                XCourseRequest cr = (XCourseRequest)request;
                List<Class_> add = null;
                Object drop = null;
                XCourseId courseId = null;
                Long configId = null;
                for (XCourseId course : ((XCourseRequest)request).getCourseIds()) {
                    for (Map.Entry<CourseOffering, List<Class_>> e : adds.entrySet()) {
                        if (!course.getCourseId().equals(e.getKey().getUniqueId())) continue;
                        add = e.getValue();
                        courseId = course;
                        configId = e.getValue().iterator().next().getSchedulingSubpart().getInstrOfferingConfig().getUniqueId();
                        remaining.remove(e.getKey());
                    }
                    for (Map.Entry<CourseOffering, List<Class_>> e : drops.entrySet()) {
                        if (!course.getCourseId().equals(e.getKey().getUniqueId())) continue;
                        drop = e.getValue();
                    }
                }
                if (add == null && drop == null) {
                    requests.add(request);
                    continue;
                }
                XEnrollment enrollemnt = cr.getEnrollment();
                HashSet<Long> hashSet = classIds = enrollemnt == null ? new HashSet<Long>() : new HashSet<Long>(enrollemnt.getSectionIds());
                if (enrollemnt != null) {
                    if (courseId != null) {
                        if (!enrollemnt.getCourseId().equals(courseId.getCourseId()) && drop == null) {
                            requests.add(request);
                            remaining.add((CourseOffering)CourseOfferingDAO.getInstance().get(courseId.getCourseId(), helper.getHibSession()));
                            continue;
                        }
                        if (!enrollemnt.getConfigId().equals(configId)) {
                            classIds.clear();
                        }
                    } else {
                        courseId = enrollemnt;
                        configId = enrollemnt.getConfigId();
                    }
                }
                if (add != null) {
                    for (Class_ c : add) {
                        classIds.add(c.getUniqueId());
                    }
                }
                if (drop != null) {
                    Iterator<Map.Entry<CourseOffering, List<Class_>>> iterator = drop.iterator();
                    while (iterator.hasNext()) {
                        Class_ c;
                        c = (Class_)((Object)iterator.next());
                        classIds.remove(c.getUniqueId());
                    }
                }
                if (classIds.isEmpty()) {
                    requests.add(new XCourseRequest(cr, null));
                    continue;
                }
                requests.add(new XCourseRequest(cr, new XEnrollment(dbStudent, courseId, configId, classIds)));
                continue;
            }
            requests.add(request);
        }
        for (CourseOffering course : remaining) {
            Long configId = null;
            HashSet<Long> classIds = new HashSet<Long>();
            for (Class_ clazz : adds.get(course)) {
                if (configId == null) {
                    configId = clazz.getSchedulingSubpart().getInstrOfferingConfig().getUniqueId();
                }
                classIds.add(clazz.getUniqueId());
            }
            XCourseId courseId = new XCourseId(course);
            requests.add(new XCourseRequest(dbStudent, courseId, requests.size(), new XEnrollment(dbStudent, courseId, configId, classIds)));
        }
        return requests;
    }

    protected Set<ClassAssignmentInterface.ErrorMessage> checkRequests(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, List<XRequest> xrequests, boolean allowTimeConf, boolean allowSpaceConf) {
        XOffering offering;
        XCourse course;
        TreeSet<ClassAssignmentInterface.ErrorMessage> errors = new TreeSet<ClassAssignmentInterface.ErrorMessage>();
        ArrayList<StudentEnrollmentProvider.EnrollmentRequest> requests = new ArrayList<StudentEnrollmentProvider.EnrollmentRequest>();
        Hashtable<Long, XOffering> courseId2offering = new Hashtable<Long, XOffering>();
        for (XRequest req : xrequests) {
            XCourseRequest courseReq;
            XEnrollment e;
            if (!(req instanceof XCourseRequest) || (e = (courseReq = (XCourseRequest)req).getEnrollment()) == null) continue;
            XCourse course2 = server.getCourse(e.getCourseId());
            if (course2 == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(e.getCourseName()));
            }
            StudentEnrollmentProvider.EnrollmentRequest request = new StudentEnrollmentProvider.EnrollmentRequest(course2, new ArrayList<XSection>());
            requests.add(request);
            XOffering offering2 = server.getOffering(course2.getOfferingId());
            if (offering2 == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(e.getCourseName()));
            }
            for (Long sectionId : e.getSectionIds()) {
                XSection section = offering2.getSection(sectionId);
                if (section == null) {
                    throw new SectioningException(MSG.exceptionEnrollNotAvailable(e.getCourseName() + " " + sectionId));
                }
                if (section.isCancelled()) {
                    if (server.getConfig().getPropertyBoolean("Enrollment.CanKeepCancelledClass", false)) {
                        boolean contains = false;
                        for (XRequest r : student.getRequests()) {
                            Object cr;
                            if (!(r instanceof XCourseRequest) || ((XCourseRequest)(cr = (XCourseRequest)r)).getEnrollment() == null || !((XCourseRequest)cr).getEnrollment().getSectionIds().contains(section.getSectionId())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) {
                            errors.add(new ClassAssignmentInterface.ErrorMessage(course2.getCourseName(), section.getExternalId(course2.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_CANCEL, MSG.exceptionEnrollCancelled(MSG.clazz(course2.getSubjectArea(), course2.getCourseNumber(), section.getSubpartName(), section.getName(course2.getCourseId())))));
                        }
                    } else {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course2.getCourseName(), section.getExternalId(course2.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_CANCEL, MSG.exceptionEnrollCancelled(MSG.clazz(course2.getSubjectArea(), course2.getCourseNumber(), section.getSubpartName(), section.getName(course2.getCourseId())))));
                    }
                }
                request.getSections().add(section);
                courseId2offering.put(course2.getCourseId(), offering2);
            }
        }
        block3: for (StudentEnrollmentProvider.EnrollmentRequest request : requests) {
            XCourse course3 = request.getCourse();
            List<XSection> sections = request.getSections();
            for (XRequest r : student.getRequests()) {
                XEnrollment enrollment;
                if (!(r instanceof XCourseRequest) || (enrollment = ((XCourseRequest)r).getEnrollment()) == null || !enrollment.getCourseId().equals(course3.getCourseId())) continue;
                for (XSection s : sections) {
                    if (enrollment.getSectionIds().contains(s.getSectionId()) || server.checkDeadline(course3.getCourseId(), s.getTime(), OnlineSectioningServer.Deadline.CHANGE)) continue;
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course3.getCourseName(), s.getExternalId(course3.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DEADLINE, MSG.exceptionEnrollDeadlineChange(MSG.clazz(course3.getSubjectArea(), course3.getCourseNumber(), s.getSubpartName(), s.getName(course3.getCourseId())))));
                }
                continue block3;
            }
            for (XSection section : sections) {
                if (server.checkDeadline(course3.getOfferingId(), section.getTime(), OnlineSectioningServer.Deadline.NEW)) continue;
                errors.add(new ClassAssignmentInterface.ErrorMessage(course3.getCourseName(), section.getExternalId(course3.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DEADLINE, MSG.exceptionEnrollDeadlineNew(MSG.clazz(course3.getSubjectArea(), course3.getCourseNumber(), section.getSubpartName(), section.getName(course3.getCourseId())))));
            }
        }
        for (XRequest r : student.getRequests()) {
            XOffering offering3;
            XEnrollment enrollment;
            if (!(r instanceof XCourseRequest) || (enrollment = ((XCourseRequest)r).getEnrollment()) == null || courseId2offering.containsKey(enrollment.getCourseId()) || (offering3 = server.getOffering(enrollment.getOfferingId())) == null) continue;
            for (XSection section : offering3.getSections(enrollment)) {
                if (server.checkDeadline(offering3.getOfferingId(), section.getTime(), OnlineSectioningServer.Deadline.DROP)) continue;
                errors.add(new ClassAssignmentInterface.ErrorMessage(enrollment.getCourseName(), section.getExternalId(enrollment.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_DEADLINE, MSG.exceptionEnrollDeadlineDrop(enrollment.getCourseName())));
            }
        }
        Hashtable<Long, XConfig> courseId2config = new Hashtable<Long, XConfig>();
        for (StudentEnrollmentProvider.EnrollmentRequest request : requests) {
            course = request.getCourse();
            offering = (XOffering)courseId2offering.get(course.getCourseId());
            XEnrollments enrollments = server.getEnrollments(course.getOfferingId());
            List<XSection> sections = request.getSections();
            XSubpart subpart = offering.getSubpart(sections.get(0).getSubpartId());
            XConfig config = offering.getConfig(subpart.getConfigId());
            courseId2config.put(course.getCourseId(), config);
            XReservation reservation = null;
            block10: for (XReservation xReservation : offering.getReservations()) {
                if (!xReservation.isApplicable(student, course)) continue;
                if (xReservation.getLimit() >= 0 && xReservation.getLimit() <= enrollments.countEnrollmentsForReservation(xReservation.getReservationId())) {
                    boolean contain = false;
                    for (XEnrollment e : enrollments.getEnrollmentsForReservation(xReservation.getReservationId())) {
                        if (!e.getStudentId().equals(student.getStudentId())) continue;
                        contain = true;
                        break;
                    }
                    if (!contain) continue;
                }
                if (!xReservation.getConfigsIds().isEmpty() && !xReservation.getConfigsIds().contains(config.getConfigId())) continue;
                for (XSection section2 : sections) {
                    if (xReservation.getSectionIds(section2.getSubpartId()) == null || xReservation.getSectionIds(section2.getSubpartId()).contains(section2.getSectionId())) continue;
                    continue block10;
                }
                if (reservation != null && xReservation.compareTo(reservation) >= 0) continue;
                reservation = xReservation;
            }
            if (reservation != null && reservation.canAssignOverLimit() || allowSpaceConf) continue;
            for (XSection xSection : sections) {
                boolean contain;
                if (xSection.getLimit() >= 0 && xSection.getLimit() <= enrollments.countEnrollmentsForSection(xSection.getSectionId())) {
                    contain = false;
                    for (XEnrollment e : enrollments.getEnrollmentsForSection(xSection.getSectionId())) {
                        if (!e.getStudentId().equals(student.getStudentId())) continue;
                        contain = true;
                        break;
                    }
                    if (!contain) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), xSection.getSubpartName(), xSection.getName()))));
                    }
                }
                if (reservation != null && offering.getSectionReservations(xSection.getSectionId()).contains(reservation) || offering.getUnreservedSectionSpace(xSection.getSectionId(), enrollments) > 0) continue;
                contain = false;
                for (XEnrollment e : enrollments.getEnrollmentsForSection(xSection.getSectionId())) {
                    if (!e.getStudentId().equals(student.getStudentId())) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), xSection.getSubpartName(), xSection.getName()))));
            }
            if (config.getLimit() >= 0 && config.getLimit() <= enrollments.countEnrollmentsForConfig(config.getConfigId())) {
                boolean contain = false;
                for (XEnrollment e : enrollments.getEnrollmentsForConfig(config.getConfigId())) {
                    if (!e.getStudentId().equals(student.getStudentId())) continue;
                    contain = true;
                    break;
                }
                if (!contain) {
                    for (XSection section4 : sections) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section4.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), section4.getSubpartName(), section4.getName()))));
                    }
                }
            }
            if (!(reservation != null && offering.getConfigReservations(config.getConfigId()).contains(reservation) || offering.getUnreservedConfigSpace(config.getConfigId(), enrollments) > 0)) {
                boolean contain = false;
                for (XEnrollment e : enrollments.getEnrollmentsForConfig(config.getConfigId())) {
                    if (!e.getStudentId().equals(student.getStudentId())) continue;
                    contain = true;
                    break;
                }
                if (!contain) {
                    for (XSection section5 : sections) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section5.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), section5.getSubpartName(), section5.getName()))));
                    }
                }
            }
            if (course.getLimit() < 0 || course.getLimit() > enrollments.countEnrollmentsForCourse(course.getCourseId())) continue;
            boolean contain = false;
            for (XEnrollment e : enrollments.getEnrollmentsForCourse(course.getCourseId())) {
                if (!e.getStudentId().equals(student.getStudentId())) continue;
                contain = true;
                break;
            }
            if (contain) continue;
            for (XSection section6 : sections) {
                errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section6.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_NOT_AVAILABLE, MSG.exceptionEnrollNotAvailable(MSG.clazz(course.getSubjectArea(), course.getCourseNumber(), section6.getSubpartName(), section6.getName()))));
            }
        }
        for (StudentEnrollmentProvider.EnrollmentRequest request : requests) {
            course = request.getCourse();
            offering = (XOffering)courseId2offering.get(course.getCourseId());
            List<XSection> sections = request.getSections();
            XSubpart subpart = offering.getSubpart(sections.get(0).getSubpartId());
            XConfig config = offering.getConfig(subpart.getConfigId());
            if (sections.size() < config.getSubparts().size()) {
                for (XSection section : sections) {
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentIncomplete(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
            } else if (sections.size() > config.getSubparts().size()) {
                for (XSection section : sections) {
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
            }
            for (XSection s1 : sections) {
                for (XSection xSection : sections) {
                    if (s1.getSectionId() < xSection.getSectionId() && s1.isOverlapping(offering.getDistributions(), xSection)) {
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), s1.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_TIME_CNF, MSG.exceptionEnrollmentOverlapping(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                        errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_TIME_CNF, MSG.exceptionEnrollmentOverlapping(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                    }
                    if (s1.getSectionId().equals(xSection.getSectionId()) || !s1.getSubpartId().equals(xSection.getSubpartId())) continue;
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), s1.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), xSection.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
                if (offering.getSubpart(s1.getSubpartId()).getConfigId().equals(config.getConfigId())) continue;
                errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), s1.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_STRUCTURE, MSG.exceptionEnrollmentInvalid(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
            }
            if (offering.isAllowOverlap(student, config.getConfigId(), course, sections) || allowTimeConf) continue;
            for (StudentEnrollmentProvider.EnrollmentRequest otherRequest : requests) {
                XOffering other = (XOffering)courseId2offering.get(otherRequest.getCourse().getCourseId());
                XConfig xConfig = (XConfig)courseId2config.get(otherRequest.getCourse().getCourseId());
                if (other.equals(offering) || other.isAllowOverlap(student, xConfig.getConfigId(), otherRequest.getCourse(), otherRequest.getSections())) continue;
                List<XSection> assignment = otherRequest.getSections();
                for (XSection section : sections) {
                    if (!section.isOverlapping(offering.getDistributions(), assignment)) continue;
                    errors.add(new ClassAssignmentInterface.ErrorMessage(course.getCourseName(), section.getExternalId(course.getCourseId()), ClassAssignmentInterface.ErrorMessage.UniTimeCode.UT_TIME_CNF, MSG.exceptionEnrollmentConflicting(MSG.courseName(course.getSubjectArea(), course.getCourseNumber()))));
                }
            }
        }
        return errors;
    }

    protected SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse convert(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.SpecialRegistrationRequest specialRequest) {
        HashMap<CourseOffering, List<Class_>> adds = new HashMap<CourseOffering, List<Class_>>();
        HashMap<CourseOffering, List<Class_>> drops = new HashMap<CourseOffering, List<Class_>>();
        TreeSet<CourseOffering> courses = new TreeSet<CourseOffering>();
        if (specialRequest.changes != null) {
            for (SpecialRegistrationInterface.Change change : specialRequest.changes) {
                CourseOffering course = this.findCourseByExternalId(server.getAcademicSession().getUniqueId(), change.crn);
                List<Class_> classes = this.findClassesByExternalId(server.getAcademicSession().getUniqueId(), change.crn);
                if (course == null || classes == null || classes.isEmpty()) continue;
                courses.add(course);
                ArrayList<Class_> list = (ArrayList<Class_>)(!SpecialRegistrationInterface.ChangeOperation.DROP.name().equals(change.operation) ? adds : drops).get(course);
                if (list == null) {
                    list = new ArrayList<Class_>();
                    (!SpecialRegistrationInterface.ChangeOperation.DROP.name().equals(change.operation) ? adds : drops).put(course, list);
                }
                for (Class_ clazz : classes) {
                    list.add(clazz);
                }
            }
        }
        String desc = "";
        for (CourseOffering course : courses) {
            if (!desc.isEmpty()) {
                desc = desc + ", ";
            }
            desc = desc + course.getCourseName();
            if (adds.containsKey(course)) {
                if (drops.containsKey(course)) {
                    desc = desc + " (change)";
                    continue;
                }
                desc = desc + " (add)";
                continue;
            }
            if (!drops.containsKey(course)) continue;
            desc = desc + " (drop)";
        }
        SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse retrieveSpecialRegistrationResponse = new SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse();
        List<XRequest> requests = this.getRequests(server, helper, student, adds, drops);
        Set<ClassAssignmentInterface.ErrorMessage> errors = this.checkRequests(server, helper, student, requests, false, false);
        retrieveSpecialRegistrationResponse.setClassAssignments(GetAssignment.computeAssignment(server, helper, student, requests, null, errors, true));
        retrieveSpecialRegistrationResponse.setDescription(desc);
        if (retrieveSpecialRegistrationResponse.hasClassAssignments()) {
            for (ClassAssignmentInterface.CourseAssignment course : retrieveSpecialRegistrationResponse.getClassAssignments().getCourseAssignments()) {
                if (course.isFreeTime()) continue;
                List add = null;
                for (Map.Entry e : adds.entrySet()) {
                    if (!course.getCourseId().equals(((CourseOffering)e.getKey()).getUniqueId())) continue;
                    add = (List)e.getValue();
                    break;
                }
                if (add == null) continue;
                for (ClassAssignmentInterface.ClassAssignment ca : course.getClassAssignments()) {
                    if (!ca.isSaved()) continue;
                    for (Class_ c : add) {
                        if (!c.getUniqueId().equals(ca.getClassId())) continue;
                        ca.setSaved(false);
                    }
                }
            }
        }
        retrieveSpecialRegistrationResponse.setCanEnroll(SpecialRegistrationInterface.RequestStatus.maySubmit.name().equals(specialRequest.status) || SpecialRegistrationInterface.RequestStatus.newRequest.name().equals(specialRequest.status) || SpecialRegistrationInterface.RequestStatus.approved.name().equals(specialRequest.status));
        retrieveSpecialRegistrationResponse.setCanSubmit(SpecialRegistrationInterface.RequestStatus.mayEdit.name().equals(specialRequest.status) || SpecialRegistrationInterface.RequestStatus.newRequest.name().equals(specialRequest.status) || SpecialRegistrationInterface.RequestStatus.draft.name().equals(specialRequest.status));
        retrieveSpecialRegistrationResponse.setRequestId(specialRequest.requestId);
        retrieveSpecialRegistrationResponse.setSubmitDate(specialRequest.dateCreated == null ? null : specialRequest.dateCreated.toDate());
        retrieveSpecialRegistrationResponse.setNote(specialRequest.notes);
        if (SpecialRegistrationInterface.RequestStatus.mayEdit.name().equals(specialRequest.status) || SpecialRegistrationInterface.RequestStatus.newRequest.name().equals(specialRequest.status) || SpecialRegistrationInterface.RequestStatus.draft.name().equals(specialRequest.status)) {
            retrieveSpecialRegistrationResponse.setStatus(SpecialRegistrationInterface.SpecialRegistrationStatus.Draft);
        } else if (SpecialRegistrationInterface.RequestStatus.approved.name().equals(specialRequest.status)) {
            retrieveSpecialRegistrationResponse.setStatus(SpecialRegistrationInterface.SpecialRegistrationStatus.Approved);
        } else if (SpecialRegistrationInterface.RequestStatus.cancelled.name().equals(specialRequest.status)) {
            retrieveSpecialRegistrationResponse.setStatus(SpecialRegistrationInterface.SpecialRegistrationStatus.Cancelled);
        } else if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(specialRequest.status)) {
            retrieveSpecialRegistrationResponse.setStatus(SpecialRegistrationInterface.SpecialRegistrationStatus.Rejected);
        } else {
            retrieveSpecialRegistrationResponse.setStatus(SpecialRegistrationInterface.SpecialRegistrationStatus.Pending);
        }
        return retrieveSpecialRegistrationResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse retrieveRegistration(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student, SpecialRegistrationInterface.RetrieveSpecialRegistrationRequest input) throws SectioningException {
        SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse retrieveSpecialRegistrationResponse;
        ClientResource resource;
        block17: {
            SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse retrieveSpecialRegistrationResponse2;
            block16: {
                if (student == null) {
                    return null;
                }
                resource = null;
                try {
                    try {
                        resource = new ClientResource(this.getSpecialRegistrationApiSiteRetrieveRegistration());
                        resource.setNext((Uniform)this.iClient);
                        resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                        resource.addQueryParameter("reqKey", input.getRequestKey());
                        helper.getAction().addOptionBuilder().setKey("reqKey").setValue(input.getRequestKey());
                        long t1 = System.currentTimeMillis();
                        resource.get(MediaType.APPLICATION_JSON);
                        helper.getAction().setApiGetTime(System.currentTimeMillis() - t1);
                        SpecialRegistrationInterface.SpecialRegistrationResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponse.class).getObject();
                        Gson gson = this.getGson(helper);
                        if (helper.isDebugEnabled()) {
                            helper.debug("Response: " + gson.toJson((Object)response));
                        }
                        helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
                        if (response.data != null) {
                            AcademicSessionInfo session = server.getAcademicSession();
                            String term = this.getBannerTerm(session);
                            String campus = this.getBannerCampus(session);
                            if (response.data.campus != null && !campus.equals(response.data.campus)) {
                                throw new SectioningException("Special registration request is for a different campus (" + response.data.campus + ").");
                            }
                            if (response.data.term != null && !term.equals(response.data.term)) {
                                throw new SectioningException("Special registration request is for a different term (" + response.data.term + ").");
                            }
                            if (response.data.studentId != null && !this.getBannerId(student).equals(response.data.studentId)) {
                                throw new SectioningException("Special registration request is for a different student.");
                            }
                            retrieveSpecialRegistrationResponse2 = this.convert(server, helper, student, response.data);
                            Object var15_17 = null;
                            if (resource == null) return retrieveSpecialRegistrationResponse2;
                            break block16;
                        }
                        if (!SpecialRegistrationInterface.ResponseStatus.success.name().equals(response.status) && response.message != null && !response.message.isEmpty()) {
                            throw new SectioningException(response.message);
                        }
                        SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse ret = new SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse();
                        ret.setCanSubmit(true);
                        ret.setCanEnroll(true);
                        ret.setDescription(response.message != null && !response.message.isEmpty() ? response.message : "New Special Registration");
                        retrieveSpecialRegistrationResponse = ret;
                        break block17;
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Exception e) {
                        helper.getAction().setApiException(e.getMessage());
                        sLog.error((Object)e.getMessage(), (Throwable)e);
                        throw new SectioningException(e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    if (resource == null) throw throwable;
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                    throw throwable;
                }
            }
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            return retrieveSpecialRegistrationResponse2;
        }
        Object var15_18 = null;
        if (resource == null) return retrieveSpecialRegistrationResponse;
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
        return retrieveSpecialRegistrationResponse;
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> retrieveAllRegistrations(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) throws SectioningException {
        Serializable session;
        ClientResource resource;
        block24: {
            ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> arrayList;
            block23: {
                ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> arrayList2;
                block22: {
                    if (student == null) {
                        return null;
                    }
                    if (!this.isSpecialRegistrationEnabled(server, helper, student)) {
                        return null;
                    }
                    resource = null;
                    try {
                        try {
                            if (this.getSpecialRegistrationApiSiteGetAllRegistrations() != null) {
                                resource = new ClientResource(this.getSpecialRegistrationApiSiteGetAllRegistrations());
                                resource.setNext((Uniform)this.iClient);
                                session = server.getAcademicSession();
                                String term = this.getBannerTerm((AcademicSessionInfo)session);
                                String campus = this.getBannerCampus((AcademicSessionInfo)session);
                                resource.addQueryParameter("term", term);
                                resource.addQueryParameter("campus", campus);
                                resource.addQueryParameter("studentId", this.getBannerId(student));
                                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                                helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                                helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
                                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                                long t1 = System.currentTimeMillis();
                                resource.get(MediaType.APPLICATION_JSON);
                                helper.getAction().setApiGetTime(System.currentTimeMillis() - t1);
                                SpecialRegistrationInterface.SpecialRegistrationResponseList specialRequests = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
                                Gson gson = this.getGson(helper);
                                if (helper.isDebugEnabled()) {
                                    helper.debug("Response: " + gson.toJson((Object)specialRequests));
                                }
                                helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)specialRequests));
                                if ((specialRequests.data == null || specialRequests.data.isEmpty()) && !SpecialRegistrationInterface.ResponseStatus.success.name().equals(specialRequests.status)) {
                                    String string;
                                    if (specialRequests.message != null && !specialRequests.message.isEmpty()) {
                                        string = specialRequests.message;
                                        throw new SectioningException(string);
                                    }
                                    string = "Call failed but no message was given.";
                                    throw new SectioningException(string);
                                }
                                if (specialRequests.data != null) {
                                    ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> ret = new ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>(specialRequests.data.size());
                                    for (SpecialRegistrationInterface.SpecialRegistrationRequest specialRequest : specialRequests.data) {
                                        if (specialRequest.requestId == null) continue;
                                        ret.add(this.convert(server, helper, student, specialRequest));
                                    }
                                    arrayList2 = ret;
                                    Object var16_24 = null;
                                    if (resource == null) return arrayList2;
                                    break block22;
                                }
                            } else {
                                resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
                                resource.setNext((Uniform)this.iClient);
                                session = server.getAcademicSession();
                                String term = this.getBannerTerm((AcademicSessionInfo)session);
                                String campus = this.getBannerCampus((AcademicSessionInfo)session);
                                resource.addQueryParameter("term", term);
                                resource.addQueryParameter("campus", campus);
                                resource.addQueryParameter("studentId", this.getBannerId(student));
                                helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                                helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                                helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
                                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                                long t1 = System.currentTimeMillis();
                                resource.get(MediaType.APPLICATION_JSON);
                                helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                                SpecialRegistrationInterface.SpecialRegistrationStatusResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
                                Gson gson = this.getGson(helper);
                                if (helper.isDebugEnabled()) {
                                    helper.debug("Response: " + gson.toJson((Object)response));
                                }
                                helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
                                if (response != null && SpecialRegistrationInterface.ResponseStatus.success.name().equals(response.status) && response.data != null && response.data.requests != null) {
                                    ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> ret = new ArrayList<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>(response.data.requests.size());
                                    for (SpecialRegistrationInterface.SpecialRegistrationRequest specialRequest : response.data.requests) {
                                        if (specialRequest.requestId == null) continue;
                                        ret.add(this.convert(server, helper, student, specialRequest));
                                    }
                                    arrayList = ret;
                                    break block23;
                                }
                            }
                            session = new ArrayList();
                            break block24;
                        }
                        catch (SectioningException e) {
                            helper.getAction().setApiException(e.getMessage());
                            throw e;
                        }
                        catch (Exception e) {
                            helper.getAction().setApiException(e.getMessage());
                            sLog.error((Object)e.getMessage(), (Throwable)e);
                            throw new SectioningException(e.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_27 = null;
                        if (resource == null) throw throwable;
                        if (resource.getResponse() != null) {
                            resource.getResponse().release();
                        }
                        resource.release();
                        throw throwable;
                    }
                }
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
                return arrayList2;
            }
            Object var16_25 = null;
            if (resource == null) return arrayList;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            return arrayList;
        }
        Object var16_26 = null;
        if (resource == null) return session;
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, XStudent student) throws SectioningException {
        if (student == null || !this.isSpecialRegistrationEnabled(server, helper, student)) {
            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_SPECREG, false);
            return;
        }
        ClientResource resource = null;
        try {
            block12: {
                try {
                    Gson gson = this.getGson(helper);
                    resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
                    resource.setNext((Uniform)this.iClient);
                    AcademicSessionInfo session = server.getAcademicSession();
                    String term = this.getBannerTerm(session);
                    String campus = this.getBannerCampus(session);
                    resource.addQueryParameter("term", term);
                    resource.addQueryParameter("campus", campus);
                    resource.addQueryParameter("studentId", this.getBannerId(student));
                    helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                    helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                    helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
                    resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                    long t1 = System.currentTimeMillis();
                    resource.get(MediaType.APPLICATION_JSON);
                    helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                    SpecialRegistrationInterface.SpecialRegistrationStatusResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
                    if (helper.isDebugEnabled()) {
                        helper.debug("Response: " + gson.toJson((Object)response));
                    }
                    helper.getAction().addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
                    if (response != null && SpecialRegistrationInterface.ResponseStatus.success.name().equals(response.status)) {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_SPECREG, true);
                        if (response.data != null) {
                            check.setOverrides(response.data.overrides);
                        }
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_TIME_CONF, check.hasOverride("TIME"));
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_LIMIT_CONF, check.hasOverride("CLOS"));
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.HAS_SPECREG, response.data != null && response.data.requests != null && !response.data.requests.isEmpty());
                        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_ENROLL)) {
                            check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.SR_ENABLED, true);
                        }
                        break block12;
                    }
                    check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_SPECREG, false);
                }
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    helper.getAction().setApiException(e.getMessage());
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new SectioningException(e.getMessage());
                }
            }
            Object var14_14 = null;
            if (resource == null) return;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            return;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (resource == null) throw throwable;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            throw throwable;
        }
    }

    protected boolean isSpecialRegistrationEnabled(Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status == null || status.hasOption(StudentSectioningStatus.Option.specreg);
    }

    protected boolean isSpecialRegistrationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        if (student == null) {
            return false;
        }
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.specreg);
    }
}

