/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.DistanceConflict;
import org.cpsolver.studentsct.extension.TimeOverlapsCounter;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineReservation;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;
import org.cpsolver.studentsct.online.selection.SuggestionSelection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.restlet.Client;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.resource.ClientResource;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.base.BaseInstructionalOffering;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.custom.CourseRequestsValidationProvider;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.BannerTermProvider;
import org.unitime.timetable.onlinesectioning.custom.purdue.GsonRepresentation;
import org.unitime.timetable.onlinesectioning.custom.purdue.SpecialRegistrationInterface;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XDistribution;
import org.unitime.timetable.onlinesectioning.model.XDistributionType;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XFreeTimeRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.server.DatabaseServer;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.updates.ReloadStudent;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurdueCourseRequestsValidationProvider
implements CourseRequestsValidationProvider {
    private static Logger sLog = Logger.getLogger(PurdueCourseRequestsValidationProvider.class);
    protected static final StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    protected static Formats.Format<Number> sCreditFormat = Formats.getNumberFormat("0.##");
    private Client iClient;
    private ExternalTermProvider iExternalTermProvider;

    public PurdueCourseRequestsValidationProvider() {
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        protocols.add(Protocol.HTTP);
        protocols.add(Protocol.HTTPS);
        this.iClient = new Client(protocols);
        try {
            String clazz = ApplicationProperty.CustomizationExternalTerm.value();
            this.iExternalTermProvider = clazz == null || clazz.isEmpty() ? new BannerTermProvider() : (ExternalTermProvider)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            sLog.error((Object)"Failed to create external term provider, using the default one instead.", (Throwable)e);
            this.iExternalTermProvider = new BannerTermProvider();
        }
    }

    protected String getSpecialRegistrationApiSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site");
    }

    protected String getSpecialRegistrationApiValidationSite() {
        return ApplicationProperties.getProperty("purdue.specreg.site.validation", this.getSpecialRegistrationApiSite() + "/checkRestrictionsForSTAR");
    }

    protected String getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationApiSiteSubmitRegistration() {
        return ApplicationProperties.getProperty("purdue.specreg.site.submitRegistration", this.getSpecialRegistrationApiSite() + "/submitRegistration");
    }

    protected String getSpecialRegistrationApiSiteCheckEligibility() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkEligibility", this.getSpecialRegistrationApiSite() + "/checkEligibility");
    }

    protected String getSpecialRegistrationApiSiteCheckAllSpecialRegistrationStatus() {
        return ApplicationProperties.getProperty("purdue.specreg.site.checkAllSpecialRegistrationStatus", this.getSpecialRegistrationApiSite() + "/checkAllSpecialRegistrationStatus");
    }

    protected String getSpecialRegistrationDashboardUrl() {
        return ApplicationProperties.getProperty("purdue.specreg.dashBoard");
    }

    protected String getSpecialRegistrationApiKey() {
        return ApplicationProperties.getProperty("purdue.specreg.apiKey");
    }

    protected String getSpecialRegistrationApiMode() {
        return ApplicationProperties.getProperty("purdue.specreg.mode.validation", "STAR");
    }

    protected String getBannerId(XStudent student) {
        String id = student.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getBannerId(org.unitime.timetable.model.Student student) {
        String id = student.getExternalUniqueId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getRequestorId(OnlineSectioningLog.Entity user) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        String id = user.getExternalId();
        while (id.length() < 9) {
            id = "0" + id;
        }
        return id;
    }

    protected String getRequestorType(OnlineSectioningLog.Entity user, XStudent student) {
        if (user == null || user.getExternalId() == null) {
            return null;
        }
        if (student != null) {
            return user.getExternalId().equals(student.getExternalId()) ? "STUDENT" : "MANAGER";
        }
        if (user.hasType()) {
            return user.getType().name();
        }
        return null;
    }

    protected String getBannerTerm(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalTerm(session);
    }

    protected String getBannerCampus(AcademicSessionInfo session) {
        return this.iExternalTermProvider.getExternalCampus(session);
    }

    protected String getCRN(Section section, Course course) {
        String name = section.getName(course.getId());
        if (name != null && name.indexOf(45) >= 0) {
            return name.substring(0, name.indexOf(45));
        }
        return name;
    }

    protected Enrollment firstEnrollment(CourseRequest request, Assignment<Request, Enrollment> assignment, Course course, Config config, HashSet<Section> sections, int idx) {
        if (config.getSubparts().size() == idx) {
            return new Enrollment((Request)request, request.getCourses().indexOf(course), null, config, new HashSet<Section>(sections), null);
        }
        Subpart subpart = (Subpart)config.getSubparts().get(idx);
        List sectionsThisSubpart = subpart.getSections();
        ArrayList<Section> matchingSectionsThisSubpart = new ArrayList<Section>(subpart.getSections().size());
        for (Section section : sectionsThisSubpart) {
            if (section.isCancelled() || section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections)) continue;
            matchingSectionsThisSubpart.add(section);
        }
        for (Section section : matchingSectionsThisSubpart) {
            sections.add(section);
            Enrollment e = this.firstEnrollment(request, assignment, course, config, sections, idx + 1);
            if (e != null) {
                return e;
            }
            sections.remove(section);
        }
        return null;
    }

    protected Gson getGson(OnlineSectioningHelper helper) {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new JsonSerializer<DateTime>(){

            public JsonElement serialize(DateTime src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString("yyyy-MM-dd'T'HH:mm:ss'Z'"));
            }
        }).registerTypeAdapter(DateTime.class, (Object)new JsonDeserializer<DateTime>(){

            public DateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return new DateTime((Object)json.getAsJsonPrimitive().getAsString(), DateTimeZone.UTC);
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    throw new JsonParseException(e.getMessage(), (Throwable)e);
                }
            }
        });
        if (helper.isDebugEnabled()) {
            builder.setPrettyPrinting();
        }
        return builder.create();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validate(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request, CourseRequestInterface.CheckCoursesResponse response) throws SectioningException {
        Set<Integer> conf;
        boolean bl;
        void var26_64;
        boolean validationEnabled;
        HashMap deniedOverrides;
        HashMap overrides;
        ClientResource resource;
        Integer CONF_BANNER;
        Integer CONF_UNITIME;
        Object CONF_NONE;
        XStudent original;
        block98: {
            XStudent xStudent = original = request.getStudentId() == null ? null : server.getStudent(request.getStudentId());
            if (original == null) {
                throw new SectioningException(MESSAGES.exceptionEnrollNotStudent(server.getAcademicSession().toString()));
            }
            CONF_NONE = null;
            CONF_UNITIME = new Integer(0);
            CONF_BANNER = new Integer(1);
            resource = null;
            overrides = new HashMap();
            deniedOverrides = new HashMap();
            Float maxCredit = null;
            Float maxCreditOverride = null;
            CourseRequestInterface.RequestedCourseStatus maxCreditOverrideStatus = null;
            validationEnabled = this.isValidationEnabled(server, helper, original);
            try {
                try {
                    resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
                    resource.setNext((Uniform)this.iClient);
                    AcademicSessionInfo session = server.getAcademicSession();
                    String term = this.getBannerTerm(session);
                    String campus = this.getBannerCampus(session);
                    resource.addQueryParameter("term", term);
                    resource.addQueryParameter("campus", campus);
                    resource.addQueryParameter("studentId", this.getBannerId(original));
                    resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode());
                    helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                    helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                    helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(original));
                    resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                    long t1 = System.currentTimeMillis();
                    resource.get(MediaType.APPLICATION_JSON);
                    helper.getAction().setApiGetTime(System.currentTimeMillis() - t1);
                    SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
                    Gson gson = this.getGson(helper);
                    if (helper.isDebugEnabled()) {
                        helper.debug("Status: " + gson.toJson((Object)status));
                    }
                    helper.getAction().addOptionBuilder().setKey("status_response").setValue(gson.toJson((Object)status));
                    if (status != null && status.data != null) {
                        maxCredit = status.data.maxCredit;
                    }
                    if (maxCredit == null) {
                        maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
                    }
                    Float maxCreditDenied = null;
                    if (status != null && status.data != null && status.data.requests != null) {
                        for (SpecialRegistrationInterface.SpecialRegistrationRequest specialRegistrationRequest : status.data.requests) {
                            Object problems;
                            if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(specialRegistrationRequest.status)) {
                                for (SpecialRegistrationInterface.Change change : specialRegistrationRequest.changes) {
                                    String string = change.subject + " " + change.courseNbr;
                                    problems = (TreeSet)deniedOverrides.get(string);
                                    if (problems == null) {
                                        problems = new TreeSet();
                                        deniedOverrides.put(string, problems);
                                    }
                                    if (change.errors == null) continue;
                                    for (SpecialRegistrationInterface.ChangeError err : change.errors) {
                                        if (err.code == null) continue;
                                        problems.add(err.code);
                                    }
                                }
                                if (specialRegistrationRequest.maxCredit == null || !(specialRegistrationRequest.maxCredit.floatValue() > maxCredit.floatValue()) || maxCreditDenied != null && !(maxCreditDenied.floatValue() > specialRegistrationRequest.maxCredit.floatValue())) continue;
                                maxCreditDenied = specialRegistrationRequest.maxCredit;
                                continue;
                            }
                            if (SpecialRegistrationInterface.RequestStatus.cancelled.name().equals(specialRegistrationRequest.status)) continue;
                            if (specialRegistrationRequest.changes != null) {
                                for (SpecialRegistrationInterface.Change change : specialRegistrationRequest.changes) {
                                    String string = change.subject + " " + change.courseNbr;
                                    problems = (Map)overrides.get(string);
                                    if (problems == null) {
                                        problems = new HashMap<String, CourseRequestInterface.RequestedCourseStatus>();
                                        overrides.put(string, problems);
                                    }
                                    if (change.errors == null) continue;
                                    for (SpecialRegistrationInterface.ChangeError err : change.errors) {
                                        if (err.code == null) continue;
                                        problems.put(err.code, this.status(specialRegistrationRequest.status));
                                    }
                                }
                            }
                            if (specialRegistrationRequest.maxCredit == null || maxCreditOverride != null && !(maxCreditOverride.floatValue() < specialRegistrationRequest.maxCredit.floatValue())) continue;
                            maxCreditOverride = specialRegistrationRequest.maxCredit;
                            maxCreditOverrideStatus = this.status(specialRegistrationRequest.status);
                        }
                    }
                    boolean creditError = false;
                    if (!validationEnabled && maxCredit.floatValue() < request.getCredit()) {
                        for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                            response.addError(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                        }
                        response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                        response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou must remove some course requests in order to submit your registration request.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                        creditError = true;
                    }
                    String string = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
                    if (maxCreditDenied != null && request.getCredit() >= maxCreditDenied.floatValue()) {
                        for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                            response.addError(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                        }
                        response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))).replace("{maxCreditDenied}", sCreditFormat.format(maxCreditDenied)));
                        response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditDeniedError", "Maximum of {max} credit hours exceeded.\nThe request to increase the maximum credit hours to {maxCreditDenied} has been denied.\nYou must remove some course requests in order to submit your registration request.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))).replace("{maxCreditDenied}", sCreditFormat.format(maxCreditDenied)));
                        creditError = true;
                    } else if (string != null) {
                        float f = Float.parseFloat(string);
                        if (maxCredit != null && maxCredit.floatValue() > f) {
                            f = maxCredit.floatValue();
                        }
                        if (request.getCredit() > f) {
                            for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, f)) {
                                response.addError(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(f))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                            }
                            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(Float.valueOf(f))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
                            response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou must remove some course requests in order to submit your registration request.").replace("{max}", sCreditFormat.format(Float.valueOf(f))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                            creditError = true;
                        }
                    }
                    if (!creditError && maxCredit.floatValue() < request.getCredit()) {
                        for (CourseRequestInterface.RequestedCourse requestedCourse : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                            response.addMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))), maxCreditOverride == null || maxCreditOverride.floatValue() < request.getCredit() ? CONF_BANNER : CONF_NONE);
                        }
                        response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                        response.setMaxCreditOverrideStatus(maxCreditOverrideStatus == null || maxCreditOverride.floatValue() < request.getCredit() ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : maxCreditOverrideStatus);
                    }
                }
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new SectioningException(e.getMessage());
                }
                Object var33_101 = null;
                if (resource == null) break block98;
            }
            catch (Throwable throwable) {
                Object var33_102 = null;
                if (resource != null) {
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                }
                throw throwable;
            }
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
        }
        OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
        boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
        AssignmentMap assignment = new AssignmentMap();
        Student student = new Student(request.getStudentId().longValue());
        student.setExternalId(original.getExternalId());
        student.setName(original.getName());
        student.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
        student.setAllowDisabled(original.isAllowDisabled());
        HashMap<Long, Section> classTable = new HashMap<Long, Section>();
        HashSet<XDistribution> distributions = new HashSet<XDistribution>();
        Hashtable preferredSections = new Hashtable();
        boolean hasAssignment = false;
        for (XRequest xRequest : original.getRequests()) {
            if (!(xRequest instanceof XCourseRequest) || ((XCourseRequest)xRequest).getEnrollment() == null) continue;
            hasAssignment = true;
            break;
        }
        for (CourseRequestInterface.Request request2 : request.getCourses()) {
            FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, request2, false, false, classTable, distributions, hasAssignment);
        }
        for (CourseRequestInterface.Request request3 : request.getAlternatives()) {
            FindAssignmentAction.addRequest(server, (StudentSectioningModel)model, (Assignment<Request, Enrollment>)assignment, student, original, request3, true, false, classTable, distributions, hasAssignment);
        }
        for (XRequest xRequest : original.getRequests()) {
            XCourseRequest xCourseRequest;
            XEnrollment xEnrollment;
            if (!(xRequest instanceof XCourseRequest) || (xEnrollment = (xCourseRequest = (XCourseRequest)xRequest).getEnrollment()) == null) continue;
            for (Request q : student.getRequests()) {
                Course course;
                if (!(q instanceof CourseRequest) || (course = ((CourseRequest)q).getCourse(xEnrollment.getCourseId().longValue())) == null) continue;
                Iterator sections = new HashSet<Section>();
                for (Long sectionId : xEnrollment.getSectionIds()) {
                    Section section = course.getOffering().getSection(sectionId.longValue());
                    if (section == null) continue;
                    sections.add(section);
                }
                if (sections.isEmpty()) continue;
                preferredSections.put((CourseRequest)q, sections);
            }
        }
        model.addStudent(student);
        model.setDistanceConflict(new DistanceConflict(server.getDistanceMetric(), model.getProperties()));
        model.setTimeOverlaps(new TimeOverlapsCounter(null, model.getProperties()));
        for (XDistribution xDistribution : distributions) {
            if (xDistribution.getDistributionType() != XDistributionType.LinkedSections) continue;
            ArrayList<Section> arrayList = new ArrayList<Section>();
            for (Long l : xDistribution.getSectionIds()) {
                Section x = (Section)classTable.get(l);
                if (x == null) continue;
                arrayList.add(x);
            }
            if (arrayList.size() < 2) continue;
            model.addLinkedSections(linkedClassesMustBeUsed, arrayList);
        }
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.dummyReservation", "false"))) {
            for (Request request4 : student.getRequests()) {
                if (!(request4 instanceof CourseRequest)) continue;
                CourseRequest courseRequest = (CourseRequest)request4;
                for (Course course : courseRequest.getCourses()) {
                    new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course.getOffering(), 5000, true, 1, true, true, true, true){

                        public boolean mustBeUsed() {
                            return true;
                        }
                    };
                }
            }
        }
        boolean questionTimeConflict = false;
        HashMap<Section, Course> hashMap = new HashMap<Section, Course>();
        for (Request request5 : student.getRequests()) {
            if (request5.isAlternative() || !(request5 instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)request5;
            for (Course course : courseRequest.getCourses()) {
                if (course.getOffering().getConfigs().size() != 1) continue;
                for (Subpart subpart : ((Config)course.getOffering().getConfigs().get(0)).getSubparts()) {
                    if (subpart.getSections().size() != 1) continue;
                    Section section = (Section)subpart.getSections().get(0);
                    for (Section section2 : hashMap.keySet()) {
                        if (!section.isOverlapping((SctAssignment)section2)) continue;
                        boolean confirm = (original.getRequestForCourse(course.getId()) == null || original.getRequestForCourse(((Course)hashMap.get(section2)).getId()) == null) && courseRequest.getCourses().size() == 1;
                        response.addMessage(course.getId(), course.getName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", course.getName()).replace("{other}", ((Course)hashMap.get(section2)).getName()), confirm ? CONF_UNITIME : CONF_NONE);
                        if (!confirm) continue;
                        questionTimeConflict = true;
                    }
                    if (courseRequest.getCourses().size() != 1) continue;
                    hashMap.put(section, course);
                }
            }
        }
        Object var26_61 = null;
        if (server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true)) {
            MultiCriteriaBranchAndBoundSelection multiCriteriaBranchAndBoundSelection = new MultiCriteriaBranchAndBoundSelection(server.getConfig());
        } else {
            SuggestionSelection suggestionSelection = new SuggestionSelection(server.getConfig());
        }
        var26_64.setModel(model);
        if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.fixCurrentEnrollments", "false"))) {
            var26_64.setPreferredSections(new Hashtable());
            var26_64.setRequiredSections(preferredSections);
        } else {
            var26_64.setPreferredSections(preferredSections);
            var26_64.setRequiredSections(new Hashtable());
        }
        var26_64.setRequiredFreeTimes(new HashSet());
        var26_64.setRequiredUnassinged(new HashSet());
        BranchBoundSelection.BranchBoundNeighbour branchBoundNeighbour = var26_64.select((Assignment)assignment, student);
        branchBoundNeighbour.assign((Assignment)assignment, 0L);
        SpecialRegistrationInterface.ValidationCheckRequest validationCheckRequest = new SpecialRegistrationInterface.ValidationCheckRequest();
        validationCheckRequest.studentId = this.getBannerId(original);
        validationCheckRequest.term = this.getBannerTerm(server.getAcademicSession());
        validationCheckRequest.campus = this.getBannerCampus(server.getAcademicSession());
        validationCheckRequest.schedule = new ArrayList<SpecialRegistrationInterface.Schedule>();
        validationCheckRequest.alternatives = new ArrayList<SpecialRegistrationInterface.Schedule>();
        validationCheckRequest.mode = this.getSpecialRegistrationApiMode();
        validationCheckRequest.includeReg = "N";
        HashMap<Object, XCourseId> crn2course = new HashMap<Object, XCourseId>();
        HashMap<XCourseId, String> course2banner = new HashMap<XCourseId, String>();
        for (Request r : model.variables()) {
            if (!(r instanceof CourseRequest)) continue;
            CourseRequest cr = (CourseRequest)r;
            Enrollment e = (Enrollment)assignment.getValue((Variable)cr);
            block34: for (Course course : cr.getCourses()) {
                SpecialRegistrationInterface.Schedule s = new SpecialRegistrationInterface.Schedule();
                s.subject = course.getSubjectArea();
                s.courseNbr = course.getCourseNumber();
                s.crns = new TreeSet<String>();
                XCourseId cid = new XCourseId(course);
                course2banner.put(cid, s.subject + " " + s.courseNbr);
                if (e != null && course.equals((Object)e.getCourse())) {
                    for (Section section : e.getSections()) {
                        String crn = this.getCRN(section, course);
                        crn2course.put(crn, cid);
                        s.crns.add(crn);
                    }
                    validationCheckRequest.schedule.add(s);
                    continue;
                }
                for (Enrollment x : cr.values((Assignment)assignment)) {
                    if (!course.equals((Object)x.getCourse())) continue;
                    for (Section section : x.getSections()) {
                        String crn = this.getCRN(section, course);
                        crn2course.put(crn, cid);
                        s.crns.add(crn);
                    }
                    validationCheckRequest.alternatives.add(s);
                    continue block34;
                }
                for (Config config : course.getOffering().getConfigs()) {
                    Enrollment x = this.firstEnrollment(cr, (Assignment<Request, Enrollment>)assignment, course, config, new HashSet<Section>(), 0);
                    if (x == null) continue;
                    for (Section section : x.getSections()) {
                        String crn = this.getCRN(section, course);
                        crn2course.put(crn, cid);
                        s.crns.add(crn);
                    }
                    validationCheckRequest.alternatives.add(s);
                    continue block34;
                }
            }
        }
        if (!validationCheckRequest.schedule.isEmpty() || !validationCheckRequest.alternatives.isEmpty()) {
            CourseRequestInterface.RequestedCourseStatus status;
            Set denied;
            Object course;
            SpecialRegistrationInterface.ValidationCheckResponse resp;
            block99: {
                resp = null;
                resource = null;
                try {
                    try {
                        resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
                        resource.setNext((Uniform)this.iClient);
                        resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                        Gson gson = this.getGson(helper);
                        if (helper.isDebugEnabled()) {
                            helper.debug("Request: " + gson.toJson((Object)validationCheckRequest));
                        }
                        helper.getAction().addOptionBuilder().setKey("validation_request").setValue(gson.toJson((Object)validationCheckRequest));
                        long t1 = System.currentTimeMillis();
                        resource.post(new GsonRepresentation<SpecialRegistrationInterface.ValidationCheckRequest>(validationCheckRequest));
                        helper.getAction().setApiPostTime(System.currentTimeMillis() - t1);
                        resp = new GsonRepresentation<SpecialRegistrationInterface.ValidationCheckResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.ValidationCheckResponse.class).getObject();
                        if (helper.isDebugEnabled()) {
                            helper.debug("Response: " + gson.toJson((Object)resp));
                        }
                        helper.getAction().addOptionBuilder().setKey("validation_response").setValue(gson.toJson((Object)resp));
                    }
                    catch (SectioningException e) {
                        helper.getAction().setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Exception e) {
                        helper.getAction().setApiException(e.getMessage());
                        sLog.error((Object)e.getMessage(), (Throwable)e);
                        throw new SectioningException(e.getMessage());
                    }
                    Object var46_141 = null;
                    if (resource == null) break block99;
                }
                catch (Throwable throwable) {
                    Object var46_142 = null;
                    if (resource != null) {
                        if (resource.getResponse() != null) {
                            resource.getResponse().release();
                        }
                        resource.release();
                    }
                    throw throwable;
                }
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
            if (resp == null) {
                return;
            }
            if (resp.scheduleRestrictions != null && resp.scheduleRestrictions.problems != null) {
                for (SpecialRegistrationInterface.Problem problem : resp.scheduleRestrictions.problems) {
                    if ("HOLD".equals(problem.code)) {
                        response.addError(null, null, problem.code, problem.message);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.holdError", problem.message));
                    }
                    if ("DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (XCourseId)crn2course.get(problem.crn)) == null) continue;
                    String string = (String)course2banner.get(course);
                    Map problems = string == null ? null : (Map)overrides.get(string);
                    Set set = denied = string == null ? null : (Set)deniedOverrides.get(string);
                    if (!validationEnabled) {
                        status = problems == null ? null : (CourseRequestInterface.RequestedCourseStatus)problems.get(problem.code);
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message).setStatus(status == null ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : status);
                        continue;
                    }
                    if (denied != null && denied.contains(problem.code)) {
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.deniedOverrideError", "One or more courses require registration overrides which have been denied.\nYou must remove or replace these courses in order to submit your registration request."));
                        continue;
                    }
                    status = problems == null ? null : (CourseRequestInterface.RequestedCourseStatus)problems.get(problem.code);
                    response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message, status == null ? CONF_BANNER : CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING).setStatus(status == null ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : status);
                }
            }
            if (resp.alternativesRestrictions != null && resp.alternativesRestrictions.problems != null) {
                for (SpecialRegistrationInterface.Problem problem : resp.alternativesRestrictions.problems) {
                    if ("HOLD".equals(problem.code)) {
                        response.addError(null, null, problem.code, problem.message);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.holdError", problem.message));
                    }
                    if ("DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course = (XCourseId)crn2course.get(problem.crn)) == null) continue;
                    String string = (String)course2banner.get(course);
                    Map problems = string == null ? null : (Map)overrides.get(string);
                    Set set = denied = string == null ? null : (Set)deniedOverrides.get(string);
                    if (!validationEnabled) {
                        status = problems == null ? null : (CourseRequestInterface.RequestedCourseStatus)problems.get(problem.code);
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message).setStatus(status == null ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : status);
                        continue;
                    }
                    if (denied != null && denied.contains(problem.code)) {
                        response.addError(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, "Denied " + problem.message).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED);
                        response.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.deniedOverrideError", "One or more courses require registration overrides which have been denied.\nYou must remove or replace these courses in order to submit your registration request."));
                        continue;
                    }
                    status = problems == null ? null : (CourseRequestInterface.RequestedCourseStatus)problems.get(problem.code);
                    response.addMessage(((XCourseId)course).getCourseId(), ((XCourseId)course).getCourseName(), problem.code, problem.message, status == null ? CONF_BANNER : CONF_NONE).setStatus(CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING).setStatus(status == null ? CourseRequestInterface.RequestedCourseStatus.OVERRIDE_NEEDED : status);
                }
            }
            if (response.hasMessages()) {
                for (CourseRequestInterface.CourseMessage m : response.getMessages()) {
                    if (m.getCourse() != null && m.getMessage().indexOf("this section") >= 0) {
                        m.setMessage(m.getMessage().replace("this section", m.getCourse()));
                    }
                    if (m.getCourse() == null || m.getMessage().indexOf(" (CRN ") < 0) continue;
                    m.setMessage(m.getMessage().replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " "));
                }
            }
        }
        boolean questionMinCred = false;
        String minCreditLimit = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
        float minCredit = 0.0f;
        block43: for (CourseRequestInterface.Request request6 : request.getCourses()) {
            if (!request6.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : request6.getRequestedCourse()) {
                if (!rc.hasCredit()) continue;
                minCredit += rc.getCreditMin().floatValue();
                continue block43;
            }
        }
        if (minCreditLimit != null && minCredit < Float.parseFloat(minCreditLimit)) {
            questionMinCred = true;
        }
        HashSet<Long> coursesWithNotAlt = new HashSet<Long>();
        for (XRequest r : original.getRequests()) {
            XCourseRequest cr;
            if (!(r instanceof XCourseRequest) || (cr = (XCourseRequest)r).getCourseIds().size() != 1 || cr.isAlternative()) continue;
            coursesWithNotAlt.add(cr.getCourseIds().get(0).getCourseId());
        }
        boolean bl2 = false;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            CourseRequestInterface.RequestedCourse rc;
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() != 1 || (rc = r.getRequestedCourse(0)).getCourseId() == null || rc.isReadOnly()) continue;
            response.addMessage(rc.getCourseId(), rc.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", rc.getCourseName()), !coursesWithNotAlt.contains(rc.getCourseId()) ? CONF_UNITIME : CONF_NONE);
            if (coursesWithNotAlt.contains(rc.getCourseId())) continue;
            bl = true;
        }
        if (response.getConfirms().contains(CONF_BANNER)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.bannerProblemsFound", "The following registration errors have been detected:"), CONF_BANNER, -1);
            response.addConfirmation("", CONF_BANNER, 1);
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.requestOverrides", "If you have already discussed these courses with your advisor and were advised to request\nregistration in them please select Request Overrides & Submit. If you aren\u2019t sure, click Cancel Submit and\nconsult with your advisor before coming back to your Course Request page."), CONF_BANNER, 2);
        }
        if (response.getConfirms().contains(CONF_UNITIME)) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.unitimeProblemsFound", "The following issues have been detected:"), CONF_UNITIME, -1);
            response.addConfirmation("", CONF_UNITIME, 1);
        }
        if (questionMinCred) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))), CONF_UNITIME, 2);
            response.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", minCreditLimit).replace("{credit}", sCreditFormat.format(Float.valueOf(minCredit))));
            response.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
        }
        if (bl) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.noAlternatives", (questionMinCred ? "\n" : "") + "One or more of the newly requested courses have no alternatives provided.\nYou may not be able to get a full schedule because you did not provide an alternative course."), CONF_UNITIME, 3);
        }
        if (questionTimeConflict) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.timeConflicts", (questionMinCred || bl ? "\n" : "") + "Two or more single section courses are conflicting with each other.\nYou will likely not be able to get the conflicting course, so please provide an alternative course if possible."), CONF_UNITIME, 4);
        }
        if (bl || questionMinCred || questionTimeConflict) {
            response.addConfirmation(ApplicationProperties.getProperty("purdue.specreg.messages.confirmation", "\nDo you want to proceed?"), CONF_UNITIME, 5);
        }
        if ((conf = response.getConfirms()).contains(CONF_UNITIME)) {
            response.setConfirmation(CONF_UNITIME, ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeDialogName", "Warning Confirmations"), conf.contains(CONF_BANNER) ? ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeContinueButton", "Accept & Continue") : ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButton", "Accept & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButton", "Cancel Submit"), conf.contains(CONF_BANNER) ? ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeContinueButtonTitle", "Accept the above warning(s) and continue to submit the Course Requests") : ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeYesButtonTitle", "Accept the above warning(s) and submit the Course Requests"), ApplicationProperties.getProperty("purdue.specreg.confirm.unitimeNoButtonTitle", "Go back to editing your Course Requests"));
        }
        if (conf.contains(CONF_BANNER)) {
            response.setConfirmation(CONF_BANNER, ApplicationProperties.getProperty("purdue.specreg.confirm.bannerDialogName", "Request Overrides"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerYesButton", "Request Overrides & Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerNoButton", "Cancel Submit"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerYesButtonTitle", "Request overrides for the above registration errors and submit the Course Requests"), ApplicationProperties.getProperty("purdue.specreg.confirm.bannerNoButtonTitle", "Go back to editing your Course Requests"));
        }
    }

    @Override
    public void dispose() {
        try {
            this.iClient.stop();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void submit(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected CourseRequestInterface.RequestedCourseStatus status(String status) {
        if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(status)) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED;
        }
        if (SpecialRegistrationInterface.RequestStatus.approved.name().equals(status)) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_APPROVED;
        }
        if (SpecialRegistrationInterface.RequestStatus.cancelled.name().equals(status)) {
            return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_CANCELLED;
        }
        return CourseRequestInterface.RequestedCourseStatus.OVERRIDE_PENDING;
    }

    protected List<CourseRequestInterface.RequestedCourse> getOverCreditRequests(CourseRequestInterface request, float maxCredit) {
        ArrayList<CourseRequestInterface.RequestedCourse> ret = new ArrayList<CourseRequestInterface.RequestedCourse>();
        float primary = 0.0f;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || !r.getRequestedCourse(0).hasCredit() || !((primary += r.getRequestedCourse(0).getCreditMin().floatValue()) > maxCredit)) continue;
            ret.add(r.getRequestedCourse(0));
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse() || r.getRequestedCourse().size() <= 1) continue;
            float credit = r.getRequestedCourse(0).hasCredit() ? r.getRequestedCourse(0).getCreditMin().floatValue() : 0.0f;
            for (int i = 1; i < r.getRequestedCourse().size(); ++i) {
                float alt;
                float f = alt = r.getRequestedCourse(i).hasCredit() ? r.getRequestedCourse(i).getCreditMin().floatValue() : 0.0f;
                if (!(primary - credit + alt > maxCredit)) continue;
                ret.add(r.getRequestedCourse(i));
            }
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ArrayList<Float> credits = new ArrayList<Float>();
        float total = 0.0f;
        CourseRequestInterface.RequestedCourse last = null;
        for (CourseRequestInterface.Request r : request.getCourses()) {
            if (!r.hasRequestedCourse()) continue;
            Float credit = null;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || credit != null && !(credit.floatValue() < rc.getCreditMin().floatValue()) || !(total + (credit = rc.getCreditMin()).floatValue() > maxCredit)) continue;
                ret.add(rc);
            }
            if (credit != null) {
                credits.add(credit);
                total += credit.floatValue();
            }
            last = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        Collections.sort(credits);
        float low = credits.isEmpty() ? 0.0f : ((Float)credits.get(0)).floatValue();
        CourseRequestInterface.RequestedCourse first = null;
        for (CourseRequestInterface.Request r : request.getAlternatives()) {
            if (!r.hasRequestedCourse()) continue;
            for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                if (!rc.hasCredit() || !(total + rc.getCreditMin().floatValue() - low > maxCredit)) continue;
                ret.add(rc);
                break;
            }
            if (first != null) continue;
            first = r.getRequestedCourse(0);
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        ret.add(first != null ? first : last);
        return ret;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(OnlineSectioningServer server, OnlineSectioningHelper helper, CourseRequestInterface request) throws SectioningException {
        ClientResource resource;
        block50: {
            Serializable offering;
            Iterator<IsSerializable> cr;
            HashMap<Serializable, XCourseId> singleSections;
            XStudent original;
            if (request.getStudentId() == null) {
                return;
            }
            XStudent xStudent = original = server.getStudent(request.getStudentId());
            if (original == null) {
                return;
            }
            Integer ORD_UNITIME = new Integer(0);
            Integer ORD_BANNER = new Integer(1);
            Integer ORD_CREDIT = new Integer(2);
            for (CourseRequestInterface.Request request2 : request.getCourses()) {
                CourseRequestInterface.RequestedCourse requestedCourse;
                if (!request2.hasRequestedCourse() || request2.getRequestedCourse().size() != 1 || (requestedCourse = request2.getRequestedCourse(0)).getCourseId() == null || requestedCourse.isReadOnly()) continue;
                request.addConfirmationMessage(requestedCourse.getCourseId(), requestedCourse.getCourseName(), "NO_ALT", ApplicationProperties.getProperty("purdue.specreg.messages.courseHasNoAlt", "No alternative course provided.").replace("{course}", requestedCourse.getCourseName()), ORD_UNITIME);
            }
            if (server instanceof DatabaseServer) {
                singleSections = new HashMap<Serializable, XCourseId>();
                for (XRequest xRequest : original.getRequests()) {
                    if (xRequest.isAlternative() || !(xRequest instanceof XCourseRequest)) continue;
                    cr = (XCourseRequest)xRequest;
                    for (XCourseId xCourseId : ((XCourseRequest)((Object)cr)).getCourseIds()) {
                        offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(xCourseId.getOfferingId(), helper.getHibSession());
                        if (offering == null || ((BaseInstructionalOffering)offering).getInstrOfferingConfigs().size() != 1) continue;
                        for (SchedulingSubpart schedulingSubpart : ((BaseInstructionalOffering)offering).getInstrOfferingConfigs().iterator().next().getSchedulingSubparts()) {
                            Class_ clazz;
                            if (schedulingSubpart.getClasses().size() != 1 || (clazz = schedulingSubpart.getClasses().iterator().next()).getCommittedAssignment() == null) continue;
                            TimeLocation time = clazz.getCommittedAssignment().getTimeLocation();
                            for (Class_ other : singleSections.keySet()) {
                                if (!other.getCommittedAssignment().getTimeLocation().hasIntersection(time) || clazz.isToIgnoreStudentConflictsWith(other)) continue;
                                request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", xCourseId.getCourseName()).replace("{other}", ((XCourseId)singleSections.get(other)).getCourseName()), ORD_UNITIME);
                            }
                            if (((XCourseRequest)((Object)cr)).getCourseIds().size() != 1) continue;
                            singleSections.put(clazz, xCourseId);
                        }
                    }
                }
            } else {
                singleSections = new HashMap();
                for (XRequest xRequest : original.getRequests()) {
                    if (xRequest.isAlternative() || !(xRequest instanceof XCourseRequest)) continue;
                    cr = (XCourseRequest)xRequest;
                    for (XCourseId xCourseId : ((XCourseRequest)((Object)cr)).getCourseIds()) {
                        offering = server.getOffering(xCourseId.getOfferingId());
                        if (offering == null || ((XOffering)offering).getConfigs().size() != 1) continue;
                        for (XSubpart xSubpart : ((XOffering)offering).getConfigs().get(0).getSubparts()) {
                            if (xSubpart.getSections().size() != 1) continue;
                            XSection section = xSubpart.getSections().get(0);
                            for (XSection other : singleSections.keySet()) {
                                if (!section.isOverlapping(((XOffering)offering).getDistributions(), other)) continue;
                                request.addConfirmationMessage(xCourseId.getCourseId(), xCourseId.getCourseName(), "OVERLAP", ApplicationProperties.getProperty("purdue.specreg.messages.courseOverlaps", "Conflicts with {other}.").replace("{course}", xCourseId.getCourseName()).replace("{other}", ((XCourseId)singleSections.get(other)).getCourseName()), ORD_UNITIME);
                            }
                            if (((XCourseRequest)((Object)cr)).getCourseIds().size() != 1) continue;
                            singleSections.put(section, xCourseId);
                        }
                    }
                }
            }
            HashMap<String, CourseRequestInterface.RequestedCourse> rcs = new HashMap<String, CourseRequestInterface.RequestedCourse>();
            for (CourseRequestInterface.Request request3 : request.getCourses()) {
                if (!request3.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : request3.getRequestedCourse()) {
                    if (rc.getOverrideExternalId() == null) continue;
                    rcs.put(rc.getOverrideExternalId(), rc);
                }
            }
            for (CourseRequestInterface.Request request4 : request.getAlternatives()) {
                if (!request4.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : request4.getRequestedCourse()) {
                    if (rc.getOverrideExternalId() == null) continue;
                    rcs.put(rc.getOverrideExternalId(), rc);
                }
            }
            String string = ApplicationProperties.getProperty("purdue.specreg.minCreditCheck");
            float f = 0.0f;
            block18: for (CourseRequestInterface.Request r : request.getCourses()) {
                if (!r.hasRequestedCourse()) continue;
                for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                    if (!rc.hasCredit()) continue;
                    f += rc.getCreditMin().floatValue();
                    continue block18;
                }
            }
            if (string != null && f > 0.0f && f < Float.parseFloat(string)) {
                request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.minCredit", "Less than {min} credit hours requested.").replace("{min}", string).replace("{credit}", sCreditFormat.format(Float.valueOf(f))));
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_LOW);
            }
            if (f > 0.0f && request.getMaxCreditOverrideStatus() == null) {
                request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.SAVED);
            }
            if (rcs.isEmpty() && !request.hasMaxCreditOverride()) {
                return;
            }
            resource = null;
            try {
                block49: {
                    String string2;
                    resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
                    resource.setNext((Uniform)this.iClient);
                    AcademicSessionInfo session = server.getAcademicSession();
                    String string3 = this.getBannerTerm(session);
                    String campus = this.getBannerCampus(session);
                    resource.addQueryParameter("term", string3);
                    resource.addQueryParameter("campus", campus);
                    resource.addQueryParameter("studentId", this.getBannerId(original));
                    resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode());
                    helper.getAction().addOptionBuilder().setKey("term").setValue(string3);
                    helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                    helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(original));
                    resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                    long t0 = System.currentTimeMillis();
                    resource.get(MediaType.APPLICATION_JSON);
                    helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                    SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
                    Gson gson = this.getGson(helper);
                    if (helper.isDebugEnabled()) {
                        helper.debug("Status: " + gson.toJson((Object)status));
                    }
                    helper.getAction().addOptionBuilder().setKey("status_response").setValue(gson.toJson((Object)status));
                    Float maxCredit = null;
                    if (status != null && status.data != null) {
                        maxCredit = status.data.maxCredit;
                        request.setMaxCredit(status.data.maxCredit);
                    }
                    if (maxCredit == null) {
                        maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
                    }
                    String creditNote = null;
                    if (status != null && status.data != null && status.data.requests != null) {
                        for (SpecialRegistrationInterface.SpecialRegistrationRequest specialRegistrationRequest : status.data.requests) {
                            CourseRequestInterface.RequestedCourse rc;
                            if (specialRegistrationRequest.requestId == null) continue;
                            if (specialRegistrationRequest.requestId.equals(request.getMaxCreditOverrideExternalId())) {
                                request.setMaxCreditOverrideStatus(this.status(specialRegistrationRequest.status));
                                if (specialRegistrationRequest.maxCredit != null) {
                                    request.setMaxCreditOverride(specialRegistrationRequest.maxCredit);
                                }
                                creditNote = specialRegistrationRequest.notes;
                            }
                            if ((rc = (CourseRequestInterface.RequestedCourse)rcs.get(specialRegistrationRequest.requestId)) == null) continue;
                            if (rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.ENROLLED) {
                                rc.setStatus(this.status(specialRegistrationRequest.status));
                            }
                            if (specialRegistrationRequest.changes != null && !SpecialRegistrationInterface.RequestStatus.approved.name().equals(specialRegistrationRequest.status)) {
                                for (SpecialRegistrationInterface.Change ch : specialRegistrationRequest.changes) {
                                    if (ch.errors == null) continue;
                                    for (SpecialRegistrationInterface.ChangeError er : ch.errors) {
                                        if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(specialRegistrationRequest.status)) {
                                            request.addConfirmationError(rc.getCourseId(), rc.getCourseName(), er.code, "Denied " + er.message, this.status(specialRegistrationRequest.status), ORD_BANNER);
                                            request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.deniedOverrideError", "One or more courses require registration overrides which have been denied.\nYou must remove or replace these courses in order to submit your registration request."));
                                            continue;
                                        }
                                        request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), er.code, er.message, this.status(specialRegistrationRequest.status), ORD_BANNER);
                                    }
                                }
                            }
                            rc.setStatusNote(specialRegistrationRequest.notes);
                        }
                    }
                    String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
                    if (maxCredit.floatValue() < request.getCredit()) {
                        for (CourseRequestInterface.RequestedCourse rc : this.getOverCreditRequests(request, maxCredit.floatValue())) {
                            request.addConfirmationMessage(rc.getCourseId(), rc.getCourseName(), "CREDIT", ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))), null, ORD_CREDIT);
                        }
                        request.setCreditWarning(ApplicationProperties.getProperty("purdue.specreg.messages.maxCredit", "Maximum of {max} credit hours exceeded.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                        if (request.getMaxCreditOverrideStatus() == CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED) {
                            if (!request.hasErrorMessage()) {
                                request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditDeniedError", "Maximum of {max} credit hours exceeded.\nThe request to increase the maximum credit hours to {maxCreditDenied} has been denied.\nYou must remove some course requests in order to submit your registration request.").replace("{max}", sCreditFormat.format(maxCredit)).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))).replace("{maxCreditDenied}", sCreditFormat.format(request.getMaxCreditOverride())));
                            }
                        } else if (maxCreditLimitStr != null && Float.parseFloat(maxCreditLimitStr) < request.getCredit()) {
                            float f2 = Float.parseFloat(maxCreditLimitStr);
                            request.setMaxCreditOverrideStatus(CourseRequestInterface.RequestedCourseStatus.CREDIT_HIGH);
                            if (!request.hasErrorMessage()) {
                                request.setErrorMessage(ApplicationProperties.getProperty("purdue.specreg.messages.maxCreditError", "Maximum of {max} credit hours exceeded.\nYou must remove some course requests in order to submit your registration request.").replace("{max}", sCreditFormat.format(Float.valueOf(f2))).replace("{credit}", sCreditFormat.format(Float.valueOf(request.getCredit()))));
                            }
                        }
                        if (creditNote != null && !creditNote.isEmpty()) {
                            request.setCreditNote(creditNote);
                        }
                    }
                    if ((string2 = this.getSpecialRegistrationDashboardUrl()) == null) break block49;
                    request.setSpecRegDashboardUrl(string2.replace("{term}", string3).replace("{campus}", campus).replace("{studentId}", this.getBannerId(original)));
                }
                Object var29_57 = null;
                if (resource == null) return;
            }
            catch (Throwable throwable) {
                Object var29_58 = null;
                if (resource == null) throw throwable;
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
                throw throwable;
            }
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            break block50;
            {
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new SectioningException(e.getMessage());
                }
            }
        }
        resource.release();
    }

    protected boolean isValidationEnabled(org.unitime.timetable.model.Student student) {
        if (student == null) {
            return false;
        }
        StudentSectioningStatus status = student.getEffectiveStatus();
        return status == null || status.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected boolean isValidationEnabled(OnlineSectioningServer server, OnlineSectioningHelper helper, XStudent student) {
        String status = student.getStatus();
        if (status == null) {
            status = server.getAcademicSession().getDefaultSectioningStatus();
        }
        if (status == null) {
            return true;
        }
        StudentSectioningStatus dbStatus = StudentSectioningStatus.getStatus(status, server.getAcademicSession().getUniqueId(), helper.getHibSession());
        return dbStatus != null && dbStatus.hasOption(StudentSectioningStatus.Option.reqval);
    }

    protected boolean hasPendingOverride(org.unitime.timetable.model.Student student) {
        if (student.getOverrideExternalId() != null && student.getMaxCreditOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.PENDING) {
            return true;
        }
        if (student.getMaxCredit() == null) {
            return true;
        }
        for (CourseDemand cd : student.getCourseDemands()) {
            for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOverrideExternalId() == null || cr.getCourseRequestOverrideStatus() != CourseRequest.CourseRequestOverrideStatus.PENDING) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        boolean bl;
        if (student == null) return false;
        if (!this.hasPendingOverride(student)) {
            return false;
        }
        ClientResource resource = null;
        try {
            try {
                resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckSpecialRegistrationStatus());
                resource.setNext((Uniform)this.iClient);
                AcademicSessionInfo session = server == null ? new AcademicSessionInfo(student.getSession()) : server.getAcademicSession();
                String term = this.getBannerTerm(session);
                String campus = this.getBannerCampus(session);
                resource.addQueryParameter("term", term);
                resource.addQueryParameter("campus", campus);
                resource.addQueryParameter("studentId", this.getBannerId(student));
                resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode());
                action.addOptionBuilder().setKey("term").setValue(term);
                action.addOptionBuilder().setKey("campus").setValue(campus);
                action.addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
                resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                long t0 = System.currentTimeMillis();
                resource.get(MediaType.APPLICATION_JSON);
                action.setApiGetTime(System.currentTimeMillis() - t0);
                SpecialRegistrationInterface.SpecialRegistrationStatusResponse status = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationStatusResponse.class).getObject();
                Gson gson = this.getGson(helper);
                if (helper.isDebugEnabled()) {
                    helper.debug("Status: " + gson.toJson((Object)status));
                }
                action.addOptionBuilder().setKey("status_response").setValue(gson.toJson((Object)status));
                boolean changed = false;
                for (CourseDemand cd : student.getCourseDemands()) {
                    for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                        if (cr.getOverrideExternalId() == null) continue;
                        SpecialRegistrationInterface.SpecialRegistrationRequest req = null;
                        for (SpecialRegistrationInterface.SpecialRegistrationRequest r : status.data.requests) {
                            if (!cr.getOverrideExternalId().equals(r.requestId)) continue;
                            req = r;
                            break;
                        }
                        if (req == null) {
                            if (cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.CANCELLED) continue;
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            helper.getHibSession().update((Object)cr);
                            changed = true;
                            continue;
                        }
                        Integer oldStatus = cr.getOverrideStatus();
                        if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(req.status)) {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                        } else if (SpecialRegistrationInterface.RequestStatus.approved.name().equals(req.status)) {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                        } else if (SpecialRegistrationInterface.RequestStatus.cancelled.name().equals(req.status)) {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                        } else {
                            cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                        }
                        if (oldStatus != null && oldStatus.equals(cr.getOverrideStatus())) continue;
                        helper.getHibSession().update((Object)cr);
                        changed = true;
                    }
                }
                boolean studentChanged = false;
                if (status.data.maxCredit != null && !status.data.maxCredit.equals(student.getMaxCredit())) {
                    student.setMaxCredit(status.data.maxCredit);
                    studentChanged = true;
                }
                if (student.getOverrideExternalId() != null) {
                    SpecialRegistrationInterface.SpecialRegistrationRequest req = null;
                    for (SpecialRegistrationInterface.SpecialRegistrationRequest r : status.data.requests) {
                        if (!student.getOverrideExternalId().equals(r.requestId)) continue;
                        req = r;
                        break;
                    }
                    if (req == null) {
                        student.setOverrideExternalId(null);
                        student.setOverrideMaxCredit(null);
                        student.setOverrideStatus(null);
                        student.setOverrideTimeStamp(null);
                        studentChanged = true;
                    } else {
                        Integer oldStatus = student.getOverrideStatus();
                        if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(req.status)) {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                        } else if (SpecialRegistrationInterface.RequestStatus.approved.name().equals(req.status)) {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                        } else if (SpecialRegistrationInterface.RequestStatus.cancelled.name().equals(req.status)) {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                        } else {
                            student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                        }
                        if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                            studentChanged = true;
                        }
                    }
                }
                if (studentChanged) {
                    helper.getHibSession().update((Object)student);
                }
                if (changed || studentChanged) {
                    helper.getHibSession().flush();
                }
                bl = changed || studentChanged;
                Object var22_24 = null;
                if (resource == null) return bl;
            }
            catch (SectioningException e) {
                action.setApiException(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                action.setApiException(e.getMessage() == null ? "Null" : e.getMessage());
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var22_25 = null;
            if (resource == null) throw throwable;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            throw throwable;
        }
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
        return bl;
    }

    protected boolean hasNotApprovedCourseRequestOverride(org.unitime.timetable.model.Student student) {
        for (CourseDemand cd : student.getCourseDemands()) {
            for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (cr.getOverrideExternalId() == null || cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.APPROVED) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean revalidateStudent(OnlineSectioningServer server, OnlineSectioningHelper helper, org.unitime.timetable.model.Student student, OnlineSectioningLog.Action.Builder action) throws SectioningException {
        SpecialRegistrationInterface.SpecialRegistrationResponseList response;
        SpecialRegistrationInterface.SpecialRegistrationRequest specialRegistrationRequest;
        block109: {
            float maxCreditLimit;
            Object err;
            SpecialRegistrationInterface.Change change;
            ClientResource resource;
            Object course3;
            HashMap<Object, Course> crn2course;
            SpecialRegistrationInterface.ValidationCheckResponse validation;
            XStudent original;
            block108: {
                XCourseRequest cr;
                if (this.hasPendingOverride(student)) {
                    this.updateStudent(server, helper, student, action);
                }
                if (!this.isValidationEnabled(student)) {
                    return false;
                }
                if (!this.hasNotApprovedCourseRequestOverride(student) && !"true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.forceRevalidation", "false"))) {
                    return false;
                }
                OnlineSectioningModel model = new OnlineSectioningModel(server.getConfig(), server.getOverExpectedCriterion());
                boolean linkedClassesMustBeUsed = server.getConfig().getPropertyBoolean("LinkedClasses.mustBeUsed", false);
                AssignmentMap assignment = new AssignmentMap();
                original = server.getStudent(student.getUniqueId());
                if (original == null) {
                    original = new XStudent(student, helper, server.getAcademicSession().getFreeTimePattern());
                }
                Student s = new Student(student.getUniqueId().longValue());
                s.setExternalId(original.getExternalId());
                s.setName(original.getName());
                s.setNeedShortDistances(original.hasAccomodation(server.getDistanceMetric().getShortDistanceAccommodationReference()));
                s.setAllowDisabled(original.isAllowDisabled());
                HashSet<XDistribution> distributions = new HashSet<XDistribution>();
                Hashtable<CourseRequest, Iterator<Section>> preferredSections = new Hashtable<CourseRequest, Iterator<Section>>();
                for (XRequest r : original.getRequests()) {
                    Object section;
                    action.addRequest(OnlineSectioningHelper.toProto(r));
                    if (r instanceof XFreeTimeRequest) {
                        XFreeTimeRequest ft = (XFreeTimeRequest)r;
                        new FreeTimeRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), s, new TimeLocation(ft.getTime().getDays(), ft.getTime().getSlot(), ft.getTime().getLength(), 0, 0.0, Long.valueOf(-1L), "Free Time", server.getAcademicSession().getFreeTimePattern(), 0));
                        continue;
                    }
                    cr = (XCourseRequest)r;
                    Iterator enrollment = cr.getEnrollment();
                    ArrayList<Course> courses = new ArrayList<Course>();
                    Iterator<Section> sections = new HashSet();
                    for (XCourseId xCourseId : cr.getCourseIds()) {
                        XOffering offering = server.getOffering(xCourseId.getOfferingId());
                        Course clonnedCourse = offering.toCourse(xCourseId.getCourseId(), original, server.getExpectations(xCourseId.getOfferingId()), offering.getDistributions(), server.getEnrollments(xCourseId.getOfferingId()));
                        courses.add(clonnedCourse);
                        model.addOffering(clonnedCourse.getOffering());
                        distributions.addAll(offering.getDistributions());
                        if (enrollment == null || !((XCourseId)((Object)enrollment)).getCourseId().equals(xCourseId.getCourseId())) continue;
                        for (Long sectionId : ((XEnrollment)((Object)enrollment)).getSectionIds()) {
                            section = clonnedCourse.getOffering().getSection(sectionId.longValue());
                            if (section == null) continue;
                            sections.add((Section)section);
                        }
                    }
                    CourseRequest clonnedRequest = new CourseRequest(r.getRequestId().longValue(), r.getPriority(), r.isAlternative(), s, courses, cr.isWaitlist(), cr.getTimeStamp() == null ? null : Long.valueOf(cr.getTimeStamp().getTime()));
                    if (!sections.isEmpty()) {
                        preferredSections.put(clonnedRequest, sections);
                    }
                    for (Course clonnedCourse : clonnedRequest.getCourses()) {
                        Object reservation2;
                        if (!clonnedCourse.getOffering().hasReservations() || enrollment == null || !((XCourseId)((Object)enrollment)).getCourseId().equals(clonnedCourse.getId())) continue;
                        boolean hasMustUse = false;
                        for (Object reservation2 : clonnedCourse.getOffering().getReservations()) {
                            if (!reservation2.isApplicable(s) || !reservation2.mustBeUsed() || reservation2.isExpired()) continue;
                            hasMustUse = true;
                        }
                        OnlineReservation reservation3 = null;
                        reservation3 = hasMustUse ? new OnlineReservation(XReservationType.Dummy.ordinal(), -original.getStudentId().longValue(), clonnedCourse.getOffering(), 1000, false, 1, true, true, false, true){

                            public boolean mustBeUsed() {
                                return true;
                            }
                        } : new OnlineReservation(XReservationType.Dummy.ordinal(), -original.getStudentId().longValue(), clonnedCourse.getOffering(), 1000, false, 1, true, false, false, true);
                        reservation2 = sections.iterator();
                        while (reservation2.hasNext()) {
                            section = (Section)reservation2.next();
                            reservation3.addSection((Section)section);
                        }
                        break block13;
                    }
                    cr.fillChoicesIn(clonnedRequest);
                }
                model.addStudent(s);
                model.setDistanceConflict(new DistanceConflict(server.getDistanceMetric(), model.getProperties()));
                model.setTimeOverlaps(new TimeOverlapsCounter(null, model.getProperties()));
                for (XDistribution link : distributions) {
                    if (link.getDistributionType() != XDistributionType.LinkedSections) continue;
                    ArrayList<Section> sections = new ArrayList<Section>();
                    block17: for (Long sectionId : link.getSectionIds()) {
                        for (Offering offering : model.getOfferings()) {
                            Section section = offering.getSection(sectionId.longValue());
                            if (section == null) continue;
                            sections.add(section);
                            continue block17;
                        }
                    }
                    if (sections.size() < 2) continue;
                    model.addLinkedSections(linkedClassesMustBeUsed, sections);
                }
                if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.dummyReservation", "false"))) {
                    for (XRequest r : s.getRequests()) {
                        if (!(r instanceof CourseRequest)) continue;
                        cr = (CourseRequest)r;
                        for (Course course2 : cr.getCourses()) {
                            new OnlineReservation(XReservationType.Dummy.ordinal(), -3L, course2.getOffering(), -100, true, 1, true, true, true, true){

                                public boolean mustBeUsed() {
                                    return true;
                                }
                            };
                        }
                    }
                }
                Object selection = null;
                selection = server.getConfig().getPropertyBoolean("StudentWeights.MultiCriteria", true) ? new MultiCriteriaBranchAndBoundSelection(server.getConfig()) : new SuggestionSelection(server.getConfig());
                selection.setModel(model);
                if ("true".equalsIgnoreCase(ApplicationProperties.getProperty("purdue.specreg.fixCurrentEnrollments", "false"))) {
                    selection.setPreferredSections(new Hashtable());
                    selection.setRequiredSections(preferredSections);
                } else {
                    selection.setPreferredSections(preferredSections);
                    selection.setRequiredSections(new Hashtable());
                }
                selection.setRequiredFreeTimes(new HashSet());
                selection.setRequiredUnassinged(new HashSet());
                BranchBoundSelection.BranchBoundNeighbour neighbour = selection.select((Assignment)assignment, s);
                neighbour.assign((Assignment)assignment, 0L);
                validation = null;
                crn2course = new HashMap<Object, Course>();
                SpecialRegistrationInterface.ValidationCheckRequest validationRequest = new SpecialRegistrationInterface.ValidationCheckRequest();
                validationRequest.studentId = this.getBannerId(original);
                validationRequest.term = this.getBannerTerm(server.getAcademicSession());
                validationRequest.campus = this.getBannerCampus(server.getAcademicSession());
                validationRequest.schedule = new ArrayList<SpecialRegistrationInterface.Schedule>();
                validationRequest.alternatives = new ArrayList<SpecialRegistrationInterface.Schedule>();
                validationRequest.mode = this.getSpecialRegistrationApiMode();
                validationRequest.includeReg = "N";
                for (Request r : model.variables()) {
                    if (!(r instanceof CourseRequest)) continue;
                    CourseRequest courseRequest = (CourseRequest)r;
                    Enrollment e = (Enrollment)assignment.getValue((Variable)courseRequest);
                    block22: for (Object course3 : courseRequest.getCourses()) {
                        SpecialRegistrationInterface.Schedule sch = new SpecialRegistrationInterface.Schedule();
                        sch.subject = course3.getSubjectArea();
                        sch.courseNbr = course3.getCourseNumber();
                        sch.crns = new TreeSet<String>();
                        if (e != null && course3.equals((Object)e.getCourse())) {
                            for (Section section : e.getSections()) {
                                String crn = this.getCRN(section, (Course)course3);
                                crn2course.put(crn, (Course)course3);
                                sch.crns.add(crn);
                            }
                            validationRequest.schedule.add(sch);
                            continue;
                        }
                        for (Enrollment x : courseRequest.values((Assignment)assignment)) {
                            if (!course3.equals((Object)x.getCourse())) continue;
                            for (Object section : x.getSections()) {
                                String string = this.getCRN((Section)section, (Course)course3);
                                crn2course.put(string, (Course)course3);
                                sch.crns.add(string);
                            }
                            validationRequest.alternatives.add(sch);
                            continue block22;
                        }
                        for (Config config : course3.getOffering().getConfigs()) {
                            Object section;
                            Enrollment x = this.firstEnrollment(courseRequest, (Assignment<Request, Enrollment>)assignment, (Course)course3, config, new HashSet<Section>(), 0);
                            if (x == null) continue;
                            section = x.getSections().iterator();
                            while (section.hasNext()) {
                                Section section2 = (Section)section.next();
                                String crn = this.getCRN(section2, (Course)course3);
                                crn2course.put(crn, (Course)course3);
                                sch.crns.add(crn);
                            }
                            validationRequest.alternatives.add(sch);
                            continue block22;
                        }
                    }
                }
                resource = null;
                try {
                    try {
                        resource = new ClientResource(this.getSpecialRegistrationApiValidationSite());
                        resource.setNext((Uniform)this.iClient);
                        resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                        Gson gson = this.getGson(helper);
                        if (helper.isDebugEnabled()) {
                            helper.debug("Validation Request: " + gson.toJson((Object)validationRequest));
                        }
                        action.addOptionBuilder().setKey("validation_request").setValue(gson.toJson((Object)validationRequest));
                        long l = System.currentTimeMillis();
                        resource.post(new GsonRepresentation<SpecialRegistrationInterface.ValidationCheckRequest>(validationRequest));
                        action.setApiPostTime(System.currentTimeMillis() - l);
                        validation = new GsonRepresentation<SpecialRegistrationInterface.ValidationCheckResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.ValidationCheckResponse.class).getObject();
                        if (helper.isDebugEnabled()) {
                            helper.debug("Validation Response: " + gson.toJson((Object)validation));
                        }
                        action.addOptionBuilder().setKey("validation_response").setValue(gson.toJson((Object)validation));
                    }
                    catch (SectioningException e) {
                        action.setApiException(e.getMessage());
                        throw e;
                    }
                    catch (Exception e) {
                        action.setApiException(e.getMessage());
                        sLog.error((Object)e.getMessage(), (Throwable)e);
                        throw new SectioningException(e.getMessage());
                    }
                    Object var31_65 = null;
                    if (resource == null) break block108;
                }
                catch (Throwable throwable) {
                    Object var31_66 = null;
                    if (resource == null) throw throwable;
                    if (resource.getResponse() != null) {
                        resource.getResponse().release();
                    }
                    resource.release();
                    throw throwable;
                }
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
            }
            if (validation == null) {
                return false;
            }
            Float maxCredit = student.getMaxCredit();
            if (maxCredit == null) {
                maxCredit = Float.valueOf(Float.parseFloat(ApplicationProperties.getProperty("purdue.specreg.maxCreditDefault", "18")));
            }
            specialRegistrationRequest = new SpecialRegistrationInterface.SpecialRegistrationRequest();
            specialRegistrationRequest.studentId = this.getBannerId(original);
            specialRegistrationRequest.term = this.getBannerTerm(server.getAcademicSession());
            specialRegistrationRequest.campus = this.getBannerCampus(server.getAcademicSession());
            specialRegistrationRequest.mode = this.getSpecialRegistrationApiMode();
            specialRegistrationRequest.changes = new ArrayList<SpecialRegistrationInterface.Change>();
            if (helper.getUser() != null) {
                specialRegistrationRequest.requestorId = this.getRequestorId(helper.getUser());
                specialRegistrationRequest.requestorRole = this.getRequestorType(helper.getUser(), original);
            }
            if (validation.scheduleRestrictions != null && validation.scheduleRestrictions.problems != null) {
                block28: for (SpecialRegistrationInterface.Problem problem : validation.scheduleRestrictions.problems) {
                    if ("HOLD".equals(problem.code) || "DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course3 = (Course)crn2course.get(problem.crn)) == null) continue;
                    change = null;
                    for (SpecialRegistrationInterface.Change ch : specialRegistrationRequest.changes) {
                        if (!ch.subject.equals(course3.getSubjectArea()) || !ch.courseNbr.equals(course3.getCourseNumber())) continue;
                        change = ch;
                        break;
                    }
                    if (change == null) {
                        change = new SpecialRegistrationInterface.Change();
                        change.subject = course3.getSubjectArea();
                        change.courseNbr = course3.getCourseNumber();
                        change.crn = "";
                        change.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                        change.operation = "ADD";
                        specialRegistrationRequest.changes.add(change);
                    } else {
                        for (SpecialRegistrationInterface.ChangeError err2 : change.errors) {
                            if (!problem.code.equals(err2.code)) continue;
                            continue block28;
                        }
                    }
                    err = new SpecialRegistrationInterface.ChangeError();
                    ((SpecialRegistrationInterface.ChangeError)err).code = problem.code;
                    ((SpecialRegistrationInterface.ChangeError)err).message = problem.message;
                    if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf("this section") >= 0) {
                        ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replace("this section", course3.getName());
                    }
                    if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf(" (CRN ") >= 0) {
                        ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " ");
                    }
                    change.errors.add((SpecialRegistrationInterface.ChangeError)err);
                }
            }
            if (validation.alternativesRestrictions != null && validation.alternativesRestrictions.problems != null) {
                block31: for (SpecialRegistrationInterface.Problem problem : validation.alternativesRestrictions.problems) {
                    if ("HOLD".equals(problem.code) || "DUPL".equals(problem.code) || "MAXI".equals(problem.code) || "CLOS".equals(problem.code) || "TIME".equals(problem.code) || (course3 = (Course)crn2course.get(problem.crn)) == null) continue;
                    change = null;
                    for (SpecialRegistrationInterface.Change ch : specialRegistrationRequest.changes) {
                        if (!ch.subject.equals(course3.getSubjectArea()) || !ch.courseNbr.equals(course3.getCourseNumber())) continue;
                        change = ch;
                        break;
                    }
                    if (change == null) {
                        change = new SpecialRegistrationInterface.Change();
                        change.subject = course3.getSubjectArea();
                        change.courseNbr = course3.getCourseNumber();
                        change.crn = "";
                        change.errors = new ArrayList<SpecialRegistrationInterface.ChangeError>();
                        change.operation = "ADD";
                        specialRegistrationRequest.changes.add(change);
                    } else {
                        for (SpecialRegistrationInterface.ChangeError err2 : change.errors) {
                            if (!problem.code.equals(err2.code)) continue;
                            continue block31;
                        }
                    }
                    err = new SpecialRegistrationInterface.ChangeError();
                    ((SpecialRegistrationInterface.ChangeError)err).code = problem.code;
                    ((SpecialRegistrationInterface.ChangeError)err).message = problem.message;
                    if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf("this section") >= 0) {
                        ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replace("this section", course3.getName());
                    }
                    if (((SpecialRegistrationInterface.ChangeError)err).message != null && ((SpecialRegistrationInterface.ChangeError)err).message.indexOf(" (CRN ") >= 0) {
                        ((SpecialRegistrationInterface.ChangeError)err).message = ((SpecialRegistrationInterface.ChangeError)err).message.replaceFirst(" \\(CRN [0-9][0-9][0-9][0-9][0-9]\\) ", " ");
                    }
                    change.errors.add((SpecialRegistrationInterface.ChangeError)err);
                }
            }
            ArrayList<Float> credits = new ArrayList<Float>();
            int nrCourses = 0;
            specialRegistrationRequest.courseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
            specialRegistrationRequest.alternateCourseCreditHrs = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
            for (XRequest r : original.getRequests()) {
                SpecialRegistrationInterface.CourseCredit cc = null;
                if (r instanceof XCourseRequest) {
                    XCourseRequest cr = (XCourseRequest)r;
                    Float credit = null;
                    for (XCourseId xCourseId : cr.getCourseIds()) {
                        XCourse course4 = server.getCourse(xCourseId.getCourseId());
                        if (course4 == null) continue;
                        if (cc == null) {
                            cc = new SpecialRegistrationInterface.CourseCredit();
                            cc.subject = course4.getSubjectArea();
                            cc.courseNbr = course4.getCourseNumber();
                            cc.title = course4.getTitle();
                            cc.creditHrs = Float.valueOf(course4.hasCredit() ? course4.getMinCredit().floatValue() : 0.0f);
                        } else {
                            if (cc.alternatives == null) {
                                cc.alternatives = new ArrayList<SpecialRegistrationInterface.CourseCredit>();
                            }
                            SpecialRegistrationInterface.CourseCredit acc = new SpecialRegistrationInterface.CourseCredit();
                            acc.subject = course4.getSubjectArea();
                            acc.courseNbr = course4.getCourseNumber();
                            acc.title = course4.getTitle();
                            acc.creditHrs = Float.valueOf(course4.hasCredit() ? course4.getMinCredit().floatValue() : 0.0f);
                            cc.alternatives.add(acc);
                        }
                        if (!course4.hasCredit() || credit != null && !(credit.floatValue() < course4.getMinCredit().floatValue())) continue;
                        credit = course4.getMinCredit();
                    }
                    if (credit != null) {
                        credits.add(credit);
                        if (!r.isAlternative()) {
                            ++nrCourses;
                        }
                    }
                }
                if (cc == null) continue;
                if (r.isAlternative()) {
                    specialRegistrationRequest.alternateCourseCreditHrs.add(cc);
                    continue;
                }
                specialRegistrationRequest.courseCreditHrs.add(cc);
            }
            Collections.sort(credits);
            float total = 0.0f;
            for (int i = 0; i < nrCourses; total += ((Float)credits.get(credits.size() - i - 1)).floatValue(), ++i) {
            }
            String maxCreditLimitStr = ApplicationProperties.getProperty("purdue.specreg.maxCreditCheck");
            if (maxCreditLimitStr != null && total > (maxCreditLimit = Float.parseFloat(maxCreditLimitStr))) {
                total = maxCreditLimit;
            }
            if (maxCredit.floatValue() < total) {
                specialRegistrationRequest.maxCredit = Float.valueOf(total);
            }
            response = null;
            resource = null;
            try {
                try {
                    resource = new ClientResource(this.getSpecialRegistrationApiSiteSubmitRegistration());
                    resource.setNext((Uniform)this.iClient);
                    resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                    Gson gson = this.getGson(helper);
                    if (helper.isDebugEnabled()) {
                        helper.debug("Submit Request: " + gson.toJson((Object)specialRegistrationRequest));
                    }
                    action.addOptionBuilder().setKey("specreg_request").setValue(gson.toJson((Object)specialRegistrationRequest));
                    long t1 = System.currentTimeMillis();
                    resource.post(new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationRequest>(specialRegistrationRequest));
                    action.setApiPostTime(action.getApiPostTime() + System.currentTimeMillis() - t1);
                    response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationResponseList>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationResponseList.class).getObject();
                    if (helper.isDebugEnabled()) {
                        helper.debug("Submit Response: " + gson.toJson((Object)response));
                    }
                    action.addOptionBuilder().setKey("specreg_response").setValue(gson.toJson((Object)response));
                    if (!SpecialRegistrationInterface.ResponseStatus.success.name().equals(response.status)) {
                        String string;
                        if (response.message != null && !response.message.isEmpty()) {
                            string = response.message;
                            throw new SectioningException(string);
                        }
                        string = "Failed to request overrides (" + response.status + ").";
                        throw new SectioningException(string);
                    }
                    Object var33_69 = null;
                    if (resource == null) break block109;
                }
                catch (SectioningException e) {
                    action.setApiException(e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    action.setApiException(e.getMessage());
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new SectioningException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var33_70 = null;
                if (resource == null) throw throwable;
                if (resource.getResponse() != null) {
                    resource.getResponse().release();
                }
                resource.release();
                throw throwable;
            }
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
        }
        boolean changed = false;
        for (CourseDemand cd : student.getCourseDemands()) {
            block38: for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                if (response != null && response.data != null) {
                    for (SpecialRegistrationInterface.SpecialRegistrationRequest r : response.data) {
                        if (r.changes == null) continue;
                        for (SpecialRegistrationInterface.Change ch : r.changes) {
                            if (!cr.getCourseOffering().getSubjectAreaAbbv().equals(ch.subject) || !cr.getCourseOffering().getCourseNbr().equals(ch.courseNbr)) continue;
                            Integer oldStatus = cr.getOverrideStatus();
                            if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(r.status)) {
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                            } else if (SpecialRegistrationInterface.RequestStatus.approved.name().equals(r.status)) {
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                            } else if (SpecialRegistrationInterface.RequestStatus.cancelled.name().equals(r.status)) {
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            } else {
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                            }
                            if (oldStatus == null || !oldStatus.equals(cr.getOverrideStatus())) {
                                changed = true;
                            }
                            if (cr.getOverrideExternalId() == null || !cr.getOverrideExternalId().equals(r.requestId)) {
                                changed = true;
                            }
                            cr.setOverrideExternalId(r.requestId);
                            cr.setOverrideTimeStamp(r.dateCreated == null ? null : r.dateCreated.toDate());
                            helper.getHibSession().update((Object)cr);
                            continue block38;
                        }
                    }
                }
                if (cr.getOverrideExternalId() == null && cr.getOverrideStatus() == null) continue;
                cr.setOverrideExternalId(null);
                cr.setOverrideStatus(null);
                cr.setOverrideTimeStamp(null);
                helper.getHibSession().update((Object)cr);
                changed = true;
            }
        }
        boolean studentChanged = false;
        if (specialRegistrationRequest.maxCredit != null) {
            for (SpecialRegistrationInterface.SpecialRegistrationRequest specialRegistrationRequest2 : response.data) {
                if (specialRegistrationRequest2.maxCredit == null) continue;
                Integer oldStatus = student.getOverrideStatus();
                if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(specialRegistrationRequest2.status)) {
                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                } else if (SpecialRegistrationInterface.RequestStatus.approved.name().equals(specialRegistrationRequest2.status)) {
                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                } else if (SpecialRegistrationInterface.RequestStatus.cancelled.name().equals(specialRegistrationRequest2.status)) {
                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                } else {
                    student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                }
                if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                    studentChanged = true;
                }
                if (student.getOverrideMaxCredit() == null || !student.getOverrideMaxCredit().equals(specialRegistrationRequest2.maxCredit)) {
                    studentChanged = true;
                }
                student.setOverrideMaxCredit(specialRegistrationRequest2.maxCredit);
                if (student.getOverrideExternalId() == null || !student.getOverrideExternalId().equals(specialRegistrationRequest2.requestId)) {
                    studentChanged = true;
                }
                student.setOverrideExternalId(specialRegistrationRequest2.requestId);
                student.setOverrideTimeStamp(specialRegistrationRequest2.dateCreated == null ? null : specialRegistrationRequest2.dateCreated.toDate());
                break;
            }
        } else if (student.getOverrideExternalId() != null || student.getOverrideMaxCredit() != null) {
            student.setOverrideExternalId(null);
            student.setOverrideMaxCredit(null);
            student.setOverrideStatus(null);
            student.setOverrideTimeStamp(null);
            studentChanged = true;
        }
        if (studentChanged) {
            helper.getHibSession().update((Object)student);
        }
        if (changed) {
            helper.getHibSession().flush();
        }
        if (changed || studentChanged) {
            helper.getHibSession().flush();
        }
        if (changed) return true;
        if (studentChanged) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkEligibility(OnlineSectioningServer server, OnlineSectioningHelper helper, OnlineSectioningInterface.EligibilityCheck check, org.unitime.timetable.model.Student student) throws SectioningException {
        if (student == null) return;
        if (!check.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER)) {
            return;
        }
        ClientResource resource = null;
        try {
            block14: {
                try {
                    resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckEligibility());
                    resource.setNext((Uniform)this.iClient);
                    AcademicSessionInfo session = server.getAcademicSession();
                    String term = this.getBannerTerm(session);
                    String campus = this.getBannerCampus(session);
                    resource.addQueryParameter("term", term);
                    resource.addQueryParameter("campus", campus);
                    resource.addQueryParameter("studentId", this.getBannerId(student));
                    resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode());
                    helper.getAction().addOptionBuilder().setKey("term").setValue(term);
                    helper.getAction().addOptionBuilder().setKey("campus").setValue(campus);
                    helper.getAction().addOptionBuilder().setKey("studentId").setValue(this.getBannerId(student));
                    resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
                    long t0 = System.currentTimeMillis();
                    resource.get(MediaType.APPLICATION_JSON);
                    helper.getAction().setApiGetTime(System.currentTimeMillis() - t0);
                    SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse eligibility = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse.class).getObject();
                    Gson gson = this.getGson(helper);
                    if (helper.isDebugEnabled()) {
                        helper.debug("Eligibility: " + gson.toJson((Object)eligibility));
                    }
                    helper.getAction().addOptionBuilder().setKey("response").setValue(gson.toJson((Object)eligibility));
                    if (!SpecialRegistrationInterface.ResponseStatus.success.name().equals(eligibility.status)) {
                        String string;
                        if (eligibility.message != null && !eligibility.message.isEmpty()) {
                            string = eligibility.message;
                            throw new SectioningException(string);
                        }
                        string = "Failed to check student eligibility (" + eligibility.status + ").";
                        throw new SectioningException(string);
                    }
                    if (eligibility.data == null || eligibility.data.eligible == null || !eligibility.data.eligible.booleanValue()) {
                        check.setFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.CAN_REGISTER, false);
                    }
                    if (eligibility.data == null || eligibility.data.eligibilityProblems == null) break block14;
                    String m = null;
                    for (SpecialRegistrationInterface.EligibilityProblem p : eligibility.data.eligibilityProblems) {
                        if (m == null) {
                            m = p.message;
                            continue;
                        }
                        m = m + "\n" + p.message;
                    }
                    if (m == null) break block14;
                    check.setMessage(MESSAGES.exceptionFailedEligibilityCheck(m));
                }
                catch (SectioningException e) {
                    helper.getAction().setApiException(e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    helper.getAction().setApiException(e.getMessage() == null ? "Null" : e.getMessage());
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                    throw new SectioningException(e.getMessage());
                }
            }
            Object var17_17 = null;
            if (resource == null) return;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            return;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            if (resource == null) throw throwable;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkStudentStatuses(OnlineSectioningServer server, OnlineSectioningHelper helper, Map<String, org.unitime.timetable.model.Student> id2student, List<Long> reloadIds, int batchNumber) throws SectioningException {
        ClientResource resource = null;
        try {
            resource = new ClientResource(this.getSpecialRegistrationApiSiteCheckAllSpecialRegistrationStatus());
            resource.setNext((Uniform)this.iClient);
            AcademicSessionInfo session = server == null ? null : server.getAcademicSession();
            String studentIds = null;
            ArrayList<String> ids = new ArrayList<String>();
            for (Map.Entry<String, org.unitime.timetable.model.Student> e : id2student.entrySet()) {
                if (session == null) {
                    session = new AcademicSessionInfo(e.getValue().getSession());
                }
                studentIds = studentIds == null ? e.getKey() : studentIds + "," + e.getKey();
                ids.add(e.getKey());
            }
            String term = this.getBannerTerm(session);
            String campus = this.getBannerCampus(session);
            resource.addQueryParameter("term", term);
            resource.addQueryParameter("campus", campus);
            resource.addQueryParameter("studentIds", studentIds);
            resource.addQueryParameter("mode", this.getSpecialRegistrationApiMode());
            resource.addQueryParameter("apiKey", this.getSpecialRegistrationApiKey());
            OnlineSectioningLog.Action.Builder action = helper.getAction();
            if (action != null) {
                action.addOptionBuilder().setKey("term").setValue(term);
                action.addOptionBuilder().setKey("campus").setValue(campus);
                action.addOptionBuilder().setKey("studentIds-" + batchNumber).setValue(studentIds);
            }
            long t0 = System.currentTimeMillis();
            resource.get(MediaType.APPLICATION_JSON);
            if (action != null) {
                action.setApiGetTime(action.getApiGetTime() + System.currentTimeMillis() - t0);
            }
            SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse response = new GsonRepresentation<SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse>(resource.getResponseEntity(), SpecialRegistrationInterface.SpecialRegistrationMultipleStatusResponse.class).getObject();
            Gson gson = this.getGson(helper);
            if (helper.isDebugEnabled()) {
                helper.debug("Response: " + gson.toJson((Object)response));
            }
            if (action != null) {
                action.addOptionBuilder().setKey("response-" + batchNumber).setValue(gson.toJson((Object)response));
            }
            if (!SpecialRegistrationInterface.ResponseStatus.success.name().equals(response.status)) {
                throw new SectioningException(response.message == null || response.message.isEmpty() ? "Failed to check student statuses (" + response.status + ")." : response.message);
            }
            if (response.data != null && response.data.students != null) {
                int index = 0;
                for (SpecialRegistrationInterface.SpecialRegistrationStatus status : response.data.students) {
                    String studentId = status.studentId;
                    if (studentId == null && status.requests != null) {
                        for (SpecialRegistrationInterface.SpecialRegistrationRequest req : status.requests) {
                            if (req.studentId == null) continue;
                            studentId = req.studentId;
                            break;
                        }
                    }
                    if (studentId == null) {
                        studentId = (String)ids.get(index);
                    }
                    ++index;
                    org.unitime.timetable.model.Student student = id2student.get(studentId);
                    if (student == null) continue;
                    boolean changed = false;
                    for (CourseDemand cd : student.getCourseDemands()) {
                        for (org.unitime.timetable.model.CourseRequest cr : cd.getCourseRequests()) {
                            if (cr.getOverrideExternalId() == null) continue;
                            SpecialRegistrationInterface.SpecialRegistrationRequest req = null;
                            for (SpecialRegistrationInterface.SpecialRegistrationRequest r : status.requests) {
                                if (!cr.getOverrideExternalId().equals(r.requestId)) continue;
                                req = r;
                                break;
                            }
                            if (req == null) {
                                if (cr.getCourseRequestOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.CANCELLED) continue;
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                                helper.getHibSession().update((Object)cr);
                                changed = true;
                                continue;
                            }
                            Integer oldStatus = cr.getOverrideStatus();
                            if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(req.status)) {
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                            } else if (SpecialRegistrationInterface.RequestStatus.approved.name().equals(req.status)) {
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                            } else if (SpecialRegistrationInterface.RequestStatus.cancelled.name().equals(req.status)) {
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            } else {
                                cr.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                            }
                            if (oldStatus != null && oldStatus.equals(cr.getOverrideStatus())) continue;
                            helper.getHibSession().update((Object)cr);
                            changed = true;
                        }
                    }
                    boolean studentChanged = false;
                    if (status.maxCredit != null && !status.maxCredit.equals(student.getMaxCredit())) {
                        student.setMaxCredit(status.maxCredit);
                        studentChanged = true;
                    }
                    if (student.getOverrideExternalId() != null) {
                        SpecialRegistrationInterface.SpecialRegistrationRequest req = null;
                        for (SpecialRegistrationInterface.SpecialRegistrationRequest r : status.requests) {
                            if (!student.getOverrideExternalId().equals(r.requestId)) continue;
                            req = r;
                            break;
                        }
                        if (req == null) {
                            student.setOverrideExternalId(null);
                            student.setOverrideMaxCredit(null);
                            student.setOverrideStatus(null);
                            student.setOverrideTimeStamp(null);
                            studentChanged = true;
                        } else {
                            Integer oldStatus = student.getOverrideStatus();
                            if (SpecialRegistrationInterface.RequestStatus.denied.name().equals(req.status)) {
                                student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.REJECTED);
                            } else if (SpecialRegistrationInterface.RequestStatus.approved.name().equals(req.status)) {
                                student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.APPROVED);
                            } else if (SpecialRegistrationInterface.RequestStatus.cancelled.name().equals(req.status)) {
                                student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.CANCELLED);
                            } else {
                                student.setMaxCreditOverrideStatus(CourseRequest.CourseRequestOverrideStatus.PENDING);
                            }
                            if (oldStatus == null || !oldStatus.equals(student.getOverrideStatus())) {
                                studentChanged = true;
                            }
                        }
                    }
                    if (studentChanged) {
                        helper.getHibSession().update((Object)student);
                    }
                    if (!changed && !studentChanged) continue;
                    reloadIds.add(student.getUniqueId());
                }
            }
            Object var31_33 = null;
            if (resource == null) return;
        }
        catch (Throwable throwable) {
            Object var31_34 = null;
            if (resource == null) throw throwable;
            if (resource.getResponse() != null) {
                resource.getResponse().release();
            }
            resource.release();
            throw throwable;
        }
        if (resource.getResponse() != null) {
            resource.getResponse().release();
        }
        resource.release();
        {
            return;
            catch (SectioningException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new SectioningException(e.getMessage());
            }
        }
    }

    @Override
    public Collection<Long> updateStudents(OnlineSectioningServer server, OnlineSectioningHelper helper, List<org.unitime.timetable.model.Student> students) throws SectioningException {
        HashMap<String, org.unitime.timetable.model.Student> id2student = new HashMap<String, org.unitime.timetable.model.Student>();
        ArrayList<Long> reloadIds = new ArrayList<Long>();
        int batchNumber = 1;
        for (int i = 0; i < students.size(); ++i) {
            org.unitime.timetable.model.Student student = students.get(i);
            if (student == null || !this.hasPendingOverride(student)) continue;
            String id = this.getBannerId(student);
            id2student.put(id, student);
            if (id2student.size() < 100) continue;
            this.checkStudentStatuses(server, helper, id2student, reloadIds, batchNumber++);
            id2student.clear();
        }
        if (!id2student.isEmpty()) {
            this.checkStudentStatuses(server, helper, id2student, reloadIds, batchNumber++);
        }
        if (!reloadIds.isEmpty()) {
            helper.getHibSession().flush();
        }
        if (!reloadIds.isEmpty() && server != null && !(server instanceof DatabaseServer)) {
            server.execute(server.createAction(ReloadStudent.class).forStudents(reloadIds), helper.getUser());
        }
        return reloadIds;
    }
}

