/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.custom.purdue;

import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.ExternalTermProvider;

public class BannerTermProvider
implements ExternalTermProvider {
    private Integer iCourseNumberLength = null;

    public String getExternalTerm(AcademicSessionInfo session) {
        if (session.getTerm().toLowerCase().startsWith("spr")) {
            return session.getYear() + "20";
        }
        if (session.getTerm().toLowerCase().startsWith("sum")) {
            return session.getYear() + "30";
        }
        if (session.getTerm().toLowerCase().startsWith("fal")) {
            return String.valueOf(Integer.parseInt(session.getYear()) + 1) + "10";
        }
        return session.getYear() + session.getTerm().toLowerCase();
    }

    public String getExternalCampus(AcademicSessionInfo session) {
        return session.getCampus();
    }

    public String getExternalSubject(AcademicSessionInfo session, String subjectArea, String courseNumber) {
        return subjectArea;
    }

    public String getExternalCourseNumber(AcademicSessionInfo session, String subjectArea, String courseNumber) {
        return courseNumber.length() > this.getCourseNumberLength() ? courseNumber.substring(0, this.getCourseNumberLength()) : courseNumber;
    }

    public int getCourseNumberLength() {
        if (this.iCourseNumberLength == null) {
            this.iCourseNumberLength = Integer.valueOf(ApplicationProperties.getProperty("tmtbl.banner.courseNumberLength", "5"));
        }
        return this.iCourseNumberLength;
    }
}

