/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.basic;

import java.util.ArrayList;
import java.util.Collection;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListClasses
implements OnlineSectioningAction<Collection<ClassAssignmentInterface.ClassAssignment>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private String iCourse;
    private Long iStudentId;

    public ListClasses forCourseAndStudent(String course, Long studentId) {
        this.iCourse = course;
        this.iStudentId = studentId;
        return this;
    }

    public String getCourse() {
        return this.iCourse;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    protected boolean isAllowDisabled(XEnrollments enrollments, XStudent student, XOffering offering, XCourseId course, XConfig config, XSection section) {
        if (student == null) {
            return false;
        }
        if (student.isAllowDisabled()) {
            return true;
        }
        for (XReservation reservation : offering.getReservations()) {
            if (!reservation.isAllowDisabled() || !reservation.isApplicable(student, course) || !reservation.isIncluded(offering, config.getConfigId(), section)) continue;
            return true;
        }
        for (XEnrollment enrollment : enrollments.getEnrollmentsForSection(section.getSectionId())) {
            if (!enrollment.getStudentId().equals(this.getStudentId())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClassAssignmentInterface.ClassAssignment> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<ClassAssignmentInterface.ClassAssignment> ret = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
        OnlineSectioningServer.Lock lock = server.readLock();
        try {
            XCourseId id = server.getCourse(this.getCourse());
            if (id == null) {
                throw new SectioningException(MSG.exceptionCourseDoesNotExist(this.getCourse()));
            }
            XOffering offering = server.getOffering(id.getOfferingId());
            XCourse c = offering.getCourse(id.getCourseId());
            XEnrollments enrollments = server.getEnrollments(c.getOfferingId());
            XExpectations expectations = server.getExpectations(c.getOfferingId());
            OverExpectedCriterion overExp = server.getOverExpectedCriterion();
            ClassAssignmentInterface.CourseAssignment courseAssign = new ClassAssignmentInterface.CourseAssignment();
            courseAssign.setCourseId(c.getCourseId());
            courseAssign.setCourseNbr(c.getCourseNumber());
            courseAssign.setTitle(c.getTitle());
            courseAssign.setSubject(c.getSubjectArea());
            courseAssign.setHasCrossList(offering.hasCrossList());
            XStudent student = this.getStudentId() == null ? null : server.getStudent(this.getStudentId());
            for (XConfig config : offering.getConfigs()) {
                for (XSubpart subpart : config.getSubparts()) {
                    for (XSection section : subpart.getSections()) {
                        if (!section.isEnabledForScheduling() && !this.isAllowDisabled(enrollments, student, offering, id, config, section)) continue;
                        String room = null;
                        if (section.getRooms() != null) {
                            for (XRoom rm : section.getRooms()) {
                                room = room == null ? "" : room + ", ";
                                room = room + rm.getName();
                            }
                        }
                        ClassAssignmentInterface.ClassAssignment a = courseAssign.addClassAssignment();
                        a.setClassId(section.getSectionId());
                        a.setSubpart(subpart.getName());
                        a.setSection(section.getName(c.getCourseId()));
                        a.setClassNumber(section.getName(-1L));
                        a.setCancelled(section.isCancelled());
                        a.setLimit(new int[]{enrollments.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                        if (this.getStudentId() != null) {
                            for (XEnrollment enrollment : enrollments.getEnrollmentsForSection(section.getSectionId())) {
                                if (!enrollment.getStudentId().equals(this.getStudentId())) continue;
                                a.setSaved(true);
                                break;
                            }
                        }
                        a.addNote(section.getNote());
                        a.setCredit(subpart.getCredit(c.getCourseId()));
                        if (section.getTime() != null) {
                            for (DayCode d : DayCode.toDayCodes(section.getTime().getDays())) {
                                a.addDay(d.getIndex());
                            }
                            a.setStart(section.getTime().getSlot());
                            a.setLength(section.getTime().getLength());
                            a.setBreakTime(section.getTime().getBreakTime());
                            a.setDatePattern(section.getTime().getDatePatternName());
                        }
                        if (section.getRooms() != null) {
                            for (XRoom rm : section.getRooms()) {
                                a.addRoom(rm.getUniqueId(), rm.getName());
                            }
                        }
                        for (XInstructor instructor : section.getInstructors()) {
                            a.addInstructor(instructor.getName());
                            a.addInstructoEmail(instructor.getEmail() == null ? "" : instructor.getEmail());
                        }
                        if (section.getParentId() != null) {
                            a.setParentSection(offering.getSection(section.getParentId()).getName(c.getCourseId()));
                        }
                        a.setSubpartId(subpart.getSubpartId());
                        if (a.getParentSection() == null) {
                            a.setParentSection(c.getConsentLabel());
                        }
                        a.setExpected(overExp.getExpected(section.getLimit(), expectations.getExpectedSpace(section.getSectionId()).doubleValue()));
                        ret.add(a);
                    }
                }
            }
            Object var24_23 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var24_24 = null;
            lock.release();
            throw throwable;
        }
        if (ret.isEmpty()) {
            throw new SectioningException(MSG.exceptionNoClassesForCourse(this.getCourse()));
        }
        return ret;
    }

    @Override
    public String name() {
        return "list-classes";
    }
}

