/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.model.base.BaseRoomFeatureType;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomFeatureType
extends BaseRoomFeatureType
implements Comparable<RoomFeatureType> {
    private static final long serialVersionUID = 1L;

    @Override
    public int compareTo(RoomFeatureType t) {
        int cmp = this.getLabel().compareTo(t.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(t.getUniqueId() == null ? -1L : t.getUniqueId());
    }

    public static boolean hasFeatureTypes(Long sessionId) {
        if (sessionId == null) {
            return !RoomFeatureTypeDAO.getInstance().findAll().isEmpty();
        }
        if (((Number)RoomFeatureTypeDAO.getInstance().getSession().createQuery("select count(distinct featureType) from GlobalRoomFeature where session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult()).intValue() > 0) {
            return true;
        }
        return ((Number)RoomFeatureTypeDAO.getInstance().getSession().createQuery("select count(distinct featureType) from DepartmentRoomFeature where department.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult()).intValue() > 0;
    }

    public static Set<RoomFeatureType> getRoomFeatureTypes(Long sessionId, boolean includeDepartmental) {
        TreeSet<RoomFeatureType> types = new TreeSet<RoomFeatureType>();
        types.addAll(RoomFeatureTypeDAO.getInstance().getSession().createQuery("select distinct f.featureType from GlobalRoomFeature f where f.session.uniqueId = :sessionId and f.featureType is not null").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        if (includeDepartmental) {
            types.addAll(RoomFeatureTypeDAO.getInstance().getSession().createQuery("select distinct f.featureType from DepartmentRoomFeature f where f.department.session.uniqueId = :sessionId and f.featureType is not null").setLong("sessionId", sessionId.longValue()).setCacheable(true).list());
        }
        return types;
    }

    public static boolean hasRoomFeatureWithNoType(Long sessionId, boolean includeDepartmental) {
        if (((Number)RoomFeatureTypeDAO.getInstance().getSession().createQuery("select count(f) from GlobalRoomFeature f where f.session.uniqueId = :sessionId and f.featureType is null").setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult()).intValue() > 0) {
            return true;
        }
        return includeDepartmental && ((Number)RoomFeatureTypeDAO.getInstance().getSession().createQuery("select count(f) from DepartmentRoomFeature f where f.department.session.uniqueId = :sessionId and f.featureType is null").setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult()).intValue() > 0;
    }

    public static Set<RoomFeatureType> getRoomFeatureTypes(Long sessionId, Long examTypeId) {
        TreeSet<RoomFeatureType> types = new TreeSet<RoomFeatureType>();
        types.addAll(RoomFeatureTypeDAO.getInstance().getSession().createQuery("select distinct f.featureType from GlobalRoomFeature f inner join f.rooms l, ExamType t where f.session.uniqueId = :sessionId and f.featureType is not null and t.uniqueId = :examTypeId and t in elements(l.examTypes)").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).list());
        return types;
    }

    public static boolean hasRoomFeatureWithNoType(Long sessionId, Long examTypeId) {
        return ((Number)RoomFeatureTypeDAO.getInstance().getSession().createQuery("select count(distinct f) from GlobalRoomFeature f inner join f.rooms l, ExamType t where l.session.uniqueId = :sessionId and f.featureType is null and t.uniqueId = :examTypeId and t in elements(l.examTypes)").setLong("sessionId", sessionId.longValue()).setLong("examTypeId", examTypeId.longValue()).setCacheable(true).uniqueResult()).intValue() > 0;
    }
}

