/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseCourseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseEvent
extends BaseCourseEvent {
    private static final long serialVersionUID = 1L;

    public CourseEvent() {
    }

    public CourseEvent(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public Set<Student> getStudents() {
        HashSet<Student> students = new HashSet<Student>();
        if (this.isReqAttendance() == null || !this.isReqAttendance().booleanValue()) {
            return students;
        }
        Iterator<RelatedCourseInfo> i = this.getRelatedCourses().iterator();
        while (i.hasNext()) {
            students.addAll(i.next().getStudents());
        }
        return students;
    }

    @Override
    public Set<DepartmentalInstructor> getInstructors() {
        HashSet<DepartmentalInstructor> instructors = new HashSet<DepartmentalInstructor>();
        if (this.isReqAttendance() == null || !this.isReqAttendance().booleanValue()) {
            return instructors;
        }
        Iterator<RelatedCourseInfo> i = this.getRelatedCourses().iterator();
        while (i.hasNext()) {
            instructors.addAll(i.next().getInstructors());
        }
        return instructors;
    }

    @Override
    public int getEventType() {
        return 3;
    }

    @Override
    public Collection<Long> getStudentIds() {
        HashSet<Long> studentIds = new HashSet<Long>();
        Iterator<RelatedCourseInfo> i = this.getRelatedCourses().iterator();
        while (i.hasNext()) {
            studentIds.addAll(i.next().getStudentIds());
        }
        return studentIds;
    }

    @Override
    public Collection<StudentClassEnrollment> getStudentClassEnrollments() {
        HashSet<StudentClassEnrollment> enrollments = new HashSet<StudentClassEnrollment>();
        for (RelatedCourseInfo owner : this.getRelatedCourses()) {
            enrollments.addAll(owner.getStudentClassEnrollments());
        }
        return enrollments;
    }

    @Override
    public Session getSession() {
        if (this.getRelatedCourses() == null) {
            return null;
        }
        Iterator<RelatedCourseInfo> iterator = this.getRelatedCourses().iterator();
        if (iterator.hasNext()) {
            RelatedCourseInfo rc = iterator.next();
            return rc.getCourse().getInstructionalOffering().getSession();
        }
        return null;
    }
}

