/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInterface
implements GwtRpcResponse,
Serializable {
    private static final long serialVersionUID = 1L;
    private TableHeaderIterface[] iHeader = null;
    private List<TableRowInterface> iRows = new ArrayList<TableRowInterface>();
    private String iName;
    private String iErrorMessage;
    private Boolean iShowPrefLegend;
    private String iTableId;

    public TableInterface() {
    }

    public TableInterface(String id, String name) {
        this.iTableId = id;
        this.iName = name;
    }

    public String getTableId() {
        return this.iTableId;
    }

    public void setTableId(String id) {
        this.iTableId = id;
    }

    public boolean hasName() {
        return this.iName != null && !this.iName.isEmpty();
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public boolean hasErrorMessage() {
        return this.iErrorMessage != null && !this.iErrorMessage.isEmpty();
    }

    public String getErrorMessage() {
        return this.iErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.iErrorMessage = errorMessage;
    }

    public void setShowPrefLegend(boolean showPrefLegend) {
        this.iShowPrefLegend = showPrefLegend;
    }

    public boolean isShowPrefLegend() {
        return this.iShowPrefLegend != null && this.iShowPrefLegend != false;
    }

    public boolean hasColumnDescriptions() {
        if (this.iHeader == null) {
            return false;
        }
        for (TableHeaderIterface h : this.iHeader) {
            if (!h.hasDescription()) continue;
            return true;
        }
        return false;
    }

    public void setHeader(TableHeaderIterface ... header) {
        this.iHeader = header;
    }

    public TableHeaderIterface[] getHeader() {
        return this.iHeader;
    }

    public TableHeaderIterface getHeader(int index) {
        return this.iHeader != null && index < this.iHeader.length ? this.iHeader[index] : null;
    }

    public List<TableRowInterface> getRows() {
        return this.iRows;
    }

    public void addRow(TableRowInterface row) {
        this.iRows.add(row);
    }

    public static class NaturalOrderComparator {
        static int compareRight(String a, String b) {
            int bias = 0;
            int ia = 0;
            int ib = 0;
            while (true) {
                char ca = NaturalOrderComparator.charAt(a, ia);
                char cb = NaturalOrderComparator.charAt(b, ib);
                if (!Character.isDigit(ca) && !Character.isDigit(cb)) {
                    return bias;
                }
                if (!Character.isDigit(ca)) {
                    return -1;
                }
                if (!Character.isDigit(cb)) {
                    return 1;
                }
                if (ca < cb) {
                    if (bias == 0) {
                        bias = -1;
                    }
                } else if (ca > cb) {
                    if (bias == 0) {
                        bias = 1;
                    }
                } else if (ca == '\u0000' && cb == '\u0000') {
                    return bias;
                }
                ++ia;
                ++ib;
            }
        }

        public static int compare(String a, String b) {
            int ia = 0;
            int ib = 0;
            int nza = 0;
            int nzb = 0;
            while (true) {
                int result;
                nzb = 0;
                nza = 0;
                char ca = NaturalOrderComparator.charAt(a, ia);
                char cb = NaturalOrderComparator.charAt(b, ib);
                while (Character.isSpace(ca) || ca == '0') {
                    nza = ca == '0' ? ++nza : 0;
                    ca = NaturalOrderComparator.charAt(a, ++ia);
                }
                while (Character.isSpace(cb) || cb == '0') {
                    nzb = cb == '0' ? ++nzb : 0;
                    cb = NaturalOrderComparator.charAt(b, ++ib);
                }
                if (Character.isDigit(ca) && Character.isDigit(cb) && (result = NaturalOrderComparator.compareRight(a.substring(ia), b.substring(ib))) != 0) {
                    return result;
                }
                if (ca == '\u0000' && cb == '\u0000') {
                    return nza - nzb;
                }
                if (ca < cb) {
                    return -1;
                }
                if (ca > cb) {
                    return 1;
                }
                ++ia;
                ++ib;
            }
        }

        static char charAt(String s, int i) {
            if (i >= s.length()) {
                return '\u0000';
            }
            return s.charAt(i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static class TableCellChange
    extends TableCellText {
        private static final long serialVersionUID = 1L;
        public TableCellInterface iFirst;
        public TableCellInterface iSecond;

        public TableCellChange() {
        }

        public TableCellChange(TableCellInterface first, TableCellInterface second) {
            this.iFirst = first;
            this.iSecond = second;
        }

        public TableCellInterface getFirst() {
            return this.iFirst;
        }

        public void setFirst(TableCellInterface first) {
            this.iFirst = first;
        }

        public TableCellInterface getSecond() {
            return this.iSecond;
        }

        public void setSecond(TableCellInterface second) {
            this.iSecond = second;
        }

        public String getValue() {
            if (this.getFirst() != null && this.getSecond() != null && this.getFirst().compareTo(this.getSecond()) == 0) {
                return this.getFirst().toString();
            }
            return (this.getFirst() == null ? "N/A" : this.getFirst()) + " \u2192 " + (this.getSecond() == null ? "N/A" : this.getSecond());
        }

        public String getFormattedValue() {
            if (this.getFirst() != null && this.getSecond() != null && this.getFirst().compareTo(this.getSecond()) == 0) {
                return this.getFirst().getFormattedValue();
            }
            return (this.getFirst() == null ? "N/A" : this.getFirst().getFormattedValue()) + " \u2192 " + (this.getSecond() == null ? "N/A" : this.getSecond().getFormattedValue());
        }

        public int compareTo(TableCellInterface c) {
            if (c instanceof TableCellChange) {
                TableCellChange ch = (TableCellChange)c;
                int cmp = TableCellChange.compare(this.getFirst(), ch.getFirst());
                if (cmp != 0) {
                    return cmp;
                }
                return TableCellChange.compare(this.getSecond(), ch.getSecond());
            }
            return super.compareTo(c);
        }

        private static int compare(TableCellInterface c1, TableCellInterface c2) {
            if (c1 == null) {
                return c2 == null ? 0 : -1;
            }
            if (c2 == null) {
                return 1;
            }
            return c1.compareTo(c2);
        }
    }

    public static class TableCellMultiLine
    extends TableCellMulti {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableCellMulti
    extends TableCellText {
        private static final long serialVersionUID = 1L;
        public List<TableCellInterface> iChunks = new ArrayList<TableCellInterface>();

        public TableCellMulti() {
        }

        public TableCellMulti(String value) {
            super(value);
        }

        public TableCellInterface add(TableCellInterface chunk) {
            this.iChunks.add(chunk);
            return chunk;
        }

        public TableCellInterface add(String chunk) {
            return this.add(new TableCellText(chunk));
        }

        public int getNrChunks() {
            return this.iChunks.size();
        }

        public TableCellInterface get(int index) {
            return this.iChunks.get(index);
        }

        public TableCellInterface last() {
            return this.iChunks.isEmpty() ? null : this.iChunks.get(this.iChunks.size() - 1);
        }

        public List<TableCellInterface> getChunks() {
            return this.iChunks;
        }

        @Override
        public String getValue() {
            String ret = "";
            for (TableCellInterface item : this.iChunks) {
                Object value = item.getValue();
                ret = ret + (ret == null ? "" : value.toString());
            }
            return ret;
        }

        @Override
        public String getFormattedValue() {
            String ret = "";
            for (TableCellInterface item : this.iChunks) {
                ret = ret + item.getFormattedValue();
            }
            return ret;
        }

        @Override
        public int compareTo(TableCellInterface c) {
            if (c instanceof TableCellMulti) {
                TableCellMulti m = (TableCellMulti)c;
                for (int i = 0; i < this.getNrChunks() && i < m.getNrChunks(); ++i) {
                    int cmp = this.get(i).compareTo(m.get(i));
                    if (cmp == 0) continue;
                    return cmp;
                }
            }
            return super.compareTo(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableCellItems
    extends TableCellText {
        private static final long serialVersionUID = 1L;
        public List<String[]> iItems = new ArrayList<String[]>();

        public TableCellItems() {
        }

        public TableCellItems(Collection<String> items) {
            if (items != null) {
                for (String item : items) {
                    this.add(item, null, null);
                }
            }
        }

        public void add(String name, String formatted, String color, Long id) {
            this.iItems.add(new String[]{name, formatted, color, id == null ? null : id.toString()});
        }

        public void add(String name, String color, Long id) {
            this.iItems.add(new String[]{name, null, color, id == null ? null : id.toString()});
        }

        public int getNrItems() {
            return this.iItems.size();
        }

        public String getValue(int index) {
            return this.iItems.get(index)[0];
        }

        public String getFormattedValue(int index) {
            return this.iItems.get(index)[1] == null ? this.iItems.get(index)[0] : this.iItems.get(index)[1];
        }

        public String getColor(int index) {
            return this.iItems.get(index)[2];
        }

        public String getId(int index) {
            return this.iItems.get(index)[3];
        }

        public String getValue(String separator) {
            String ret = "";
            for (String[] item : this.iItems) {
                ret = ret + (ret.isEmpty() ? "" : separator) + item[0];
            }
            return ret;
        }

        @Override
        public String getValue() {
            return this.getValue(", ");
        }

        public String getFormattedValue(String separator) {
            String ret = "";
            for (String[] item : this.iItems) {
                ret = ret + (ret.isEmpty() ? "" : separator) + (item[1] == null ? item[0] : item[1]);
            }
            return ret;
        }

        @Override
        public String getFormattedValue() {
            return this.getFormattedValue(", ");
        }
    }

    public static class TableCellRooms
    extends TableCellText {
        private static final long serialVersionUID = 1L;
        public List<String[]> iRooms = new ArrayList<String[]>();

        public void add(String name, String color, Long id, String preference) {
            this.iRooms.add(new String[]{name, color, id.toString(), preference});
        }

        public int getNrRooms() {
            return this.iRooms.size();
        }

        public String getName(int index) {
            return this.iRooms.get(index)[0];
        }

        public String getColor(int index) {
            return this.iRooms.get(index)[1];
        }

        public String getId(int index) {
            return this.iRooms.get(index)[2];
        }

        public String getPreference(int index) {
            return this.iRooms.get(index)[3];
        }

        public String getValue(String separator) {
            String ret = "";
            for (String[] room : this.iRooms) {
                ret = ret + (ret.isEmpty() ? "" : separator) + room[0];
            }
            return ret;
        }

        public String getValue() {
            return this.getValue(", ");
        }

        public String getFormattedValue() {
            return this.getValue(", ");
        }
    }

    public static class TableCellTime
    extends TableCellText {
        private static final long serialVersionUID = 1L;
        public String iId;
        public Integer iOrder;

        public TableCellTime() {
        }

        public TableCellTime(String value) {
            super(value);
        }

        public boolean hasId() {
            return this.iId != null && !this.iId.isEmpty();
        }

        public String getId() {
            return this.iId;
        }

        public TableCellTime setId(String id) {
            this.iId = id;
            return this;
        }

        public TableCellTime setOrder(Integer order) {
            this.iOrder = order;
            return this;
        }

        public int compareTo(TableCellInterface c) {
            int cmp;
            if (c instanceof TableCellTime && this.iOrder != null && ((TableCellTime)c).iOrder != null && (cmp = this.iOrder.compareTo(((TableCellTime)c).iOrder)) != 0) {
                return cmp;
            }
            return super.compareTo(c);
        }
    }

    public static class TableCellClickableClassName
    extends TableCellClassName {
        private static final long serialVersionUID = 1L;
        private Long iClassId;

        public TableCellClickableClassName() {
        }

        public TableCellClickableClassName(Long id, String value) {
            super(value);
            this.iClassId = id;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableCellClassName
    extends TableCellText {
        private static final long serialVersionUID = 1L;
        private List<String> iAlternatives = null;

        public TableCellClassName() {
        }

        public TableCellClassName(String value) {
            super(value);
        }

        public boolean hasAlternatives() {
            return this.iAlternatives != null && !this.iAlternatives.isEmpty();
        }

        public List<String> getAlternatives() {
            return this.iAlternatives;
        }

        public void addAlternative(String alternative) {
            if (this.iAlternatives == null) {
                this.iAlternatives = new ArrayList<String>();
            }
            this.iAlternatives.add(alternative);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableCellBoolean
    extends TableCellInterface<Boolean> {
        private static final long serialVersionUID = 1L;

        public TableCellBoolean() {
        }

        public TableCellBoolean(Boolean value) {
            super(value);
        }

        public String getValueNotNull() {
            return this.getValue() != null ? (((Boolean)this.getValue()).booleanValue() ? "1" : "0") : "";
        }

        @Override
        public String getFormattedValue() {
            return super.getFormattedValue() != null ? super.getFormattedValue() : this.getValueNotNull();
        }

        @Override
        public int compareTo(TableCellInterface c) {
            if (c instanceof TableCellBoolean) {
                return NaturalOrderComparator.compare(this.getValueNotNull(), ((TableCellBoolean)c).getValueNotNull());
            }
            return super.compareTo(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableCellText
    extends TableCellInterface<String> {
        private static final long serialVersionUID = 1L;

        public TableCellText() {
        }

        public TableCellText(String value) {
            super(value);
        }

        public String getValueNotNull() {
            return this.getValue() != null ? (String)this.getValue() : "";
        }

        @Override
        public String getFormattedValue() {
            return super.getFormattedValue() != null ? super.getFormattedValue() : this.getValueNotNull();
        }

        @Override
        public int compareTo(TableCellInterface c) {
            if (c instanceof TableCellText) {
                return NaturalOrderComparator.compare(this.getValueNotNull(), ((TableCellText)c).getValueNotNull());
            }
            return super.compareTo(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableCellInterface<T extends Comparable<T>>
    implements IsSerializable,
    Serializable,
    Comparable<TableCellInterface> {
        private static final long serialVersionUID = 1L;
        private String iFormattedValue;
        private String iStyleName;
        private String iColor;
        private T iValue;
        private String iTitle = null;
        private boolean iUnderline = false;

        public TableCellInterface() {
        }

        public TableCellInterface(T value) {
            this.iValue = value;
        }

        public TableCellInterface(T value, String formatted) {
            this.iValue = value;
            this.iFormattedValue = formatted;
        }

        public T getValue() {
            return this.iValue;
        }

        public TableCellInterface<T> setValue(T value) {
            this.iValue = value;
            return this;
        }

        public boolean hasValue() {
            return this.getValue() != null;
        }

        public TableCellInterface<T> setFormattedValue(String formattedValue) {
            this.iFormattedValue = formattedValue;
            return this;
        }

        public String getFormattedValue() {
            return this.iFormattedValue == null ? (this.iValue == null ? "" : this.iValue.toString()) : this.iFormattedValue;
        }

        public boolean hasStyleName() {
            return this.iStyleName != null && !this.iStyleName.isEmpty();
        }

        public TableCellInterface<T> setStyleName(String styleName) {
            this.iStyleName = styleName;
            return this;
        }

        public String getStyleName() {
            return this.iStyleName;
        }

        public boolean hasColor() {
            return this.iColor != null && !this.iColor.isEmpty();
        }

        public TableCellInterface<T> setColor(String color) {
            this.iColor = color;
            return this;
        }

        public String getColor() {
            return this.iColor;
        }

        public boolean hasTitle() {
            return this.iTitle != null && !this.iTitle.isEmpty();
        }

        public String getTitle() {
            return this.iTitle;
        }

        public TableCellInterface<T> setTitle(String title) {
            this.iTitle = title;
            return this;
        }

        public boolean isUnderlined() {
            return this.iUnderline;
        }

        public void setUnderlined(boolean underline) {
            this.iUnderline = underline;
        }

        @Override
        public int compareTo(TableCellInterface c) {
            try {
                return this.getValue() == null ? (c.getValue() == null ? 0 : -1) : (c.getValue() == null ? 1 : this.getValue().compareTo(c.getValue()));
            }
            catch (Exception e) {
                return NaturalOrderComparator.compare(this.getFormattedValue(), c.getFormattedValue());
            }
        }
    }

    public static class TableRowInterface
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private TableCellInterface[] iCells = null;
        private Long iId;
        private String iLink;
        private String iLinkName;
        private boolean iSelected = false;

        public TableRowInterface() {
        }

        public TableRowInterface(TableCellInterface ... cells) {
            this.iCells = cells;
        }

        public TableRowInterface(Long id, String link, String linkName, TableCellInterface ... cells) {
            this.iId = id;
            this.iLink = link;
            this.iLinkName = linkName;
            this.iCells = cells;
        }

        public TableRowInterface(Long id, boolean selected, TableCellInterface ... cells) {
            this.iId = id;
            this.iSelected = selected;
            this.iCells = cells;
        }

        public TableCellInterface[] getCells() {
            return this.iCells;
        }

        public void setCells(TableCellInterface ... cells) {
            this.iCells = cells;
        }

        public TableCellInterface getCell(int index) {
            return this.iCells != null && index < this.iCells.length ? this.iCells[index] : null;
        }

        public int getNrCells() {
            return this.iCells == null ? 0 : this.iCells.length;
        }

        public boolean hasLink() {
            return this.iLink != null && !this.iLink.isEmpty();
        }

        public String getLink() {
            return this.iLink;
        }

        public void setLink(String link) {
            this.iLink = link;
        }

        public String getLinkName() {
            return this.iLinkName;
        }

        public void setLinkName(String name) {
            this.iLinkName = name;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public boolean hasId() {
            return this.iId != null;
        }

        public TableRowInterface setSelected(boolean selected) {
            this.iSelected = selected;
            return this;
        }

        public boolean isSelected() {
            return this.iSelected;
        }

        public static int compare(TableCellInterface c1, TableCellInterface c2) {
            return c1 == null ? (c2 == null ? 0 : -1) : (c2 == null ? 1 : c1.compareTo(c2));
        }

        public int compareTo(TableRowInterface row, int column, boolean asc) {
            int cmp = TableRowInterface.compare(this.getCell(column), row.getCell(column));
            if (cmp != 0) {
                return asc ? cmp : -cmp;
            }
            for (int i = 0; i < Math.max(this.getNrCells(), row.getNrCells()); ++i) {
                cmp = TableRowInterface.compare(this.getCell(i), row.getCell(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    public static class TableHeaderIterface
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iName;
        private boolean iComparable = true;
        private Alignment iAlignment = Alignment.LEFT;
        private boolean iVisible = true;
        private String iDescription = null;

        public TableHeaderIterface() {
        }

        public TableHeaderIterface(String name, boolean comparable, Alignment alignment) {
            this.iName = name;
            this.iComparable = comparable;
            this.iAlignment = alignment;
        }

        public TableHeaderIterface(String name, boolean comparable) {
            this(name, comparable, Alignment.LEFT);
        }

        public TableHeaderIterface(String name) {
            this(name, true, Alignment.LEFT);
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public boolean isComparable() {
            return this.iComparable;
        }

        public TableHeaderIterface setComparable(boolean comparable) {
            this.iComparable = comparable;
            return this;
        }

        public Alignment getAlignment() {
            return this.iAlignment;
        }

        public TableHeaderIterface setAlignment(Alignment alignment) {
            this.iAlignment = alignment;
            return this;
        }

        public boolean isVisible() {
            return this.iVisible;
        }

        public TableHeaderIterface setVisible(boolean visible) {
            this.iVisible = visible;
            return this;
        }

        public boolean hasDescription() {
            return this.iDescription != null && !this.iDescription.isEmpty();
        }

        public String getDescription() {
            return this.iDescription;
        }

        public TableHeaderIterface setDescription(String description) {
            this.iDescription = description;
            return this;
        }
    }
}

