/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.instructor.InstructorAvailabilityWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorInterface
implements IsSerializable,
Comparable<InstructorInterface>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long iId;
    private String iExternalId;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iFormattedName;
    private String iOrderName;
    private DepartmentInterface iDepartment = null;
    private PositionInterface iPosition = null;
    private PreferenceInterface iTeachingPreference = null;
    private Float iMaxLoad = null;
    private List<AttributeInterface> iAttributes;

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String fname) {
        this.iFirstName = fname;
    }

    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String mname) {
        this.iMiddleName = mname;
    }

    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lname) {
        this.iLastName = lname;
    }

    public String getFormattedName() {
        return this.iFormattedName;
    }

    public void setFormattedName(String name) {
        this.iFormattedName = name;
    }

    public String getOrderName() {
        return this.iOrderName != null ? this.iOrderName : this.iFormattedName;
    }

    public void setOrderName(String name) {
        this.iOrderName = name;
    }

    public DepartmentInterface getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(DepartmentInterface department) {
        this.iDepartment = department;
    }

    public PositionInterface getPosition() {
        return this.iPosition;
    }

    public void setPosition(PositionInterface position) {
        this.iPosition = position;
    }

    public boolean hasTeachingPreference() {
        return this.iTeachingPreference != null;
    }

    public PreferenceInterface getTeachingPreference() {
        return this.iTeachingPreference;
    }

    public void setTeachingPreference(PreferenceInterface teachingPreference) {
        this.iTeachingPreference = teachingPreference;
    }

    public boolean hasMaxLoad() {
        return this.iTeachingPreference != null && !"P".equals(this.iTeachingPreference.getCode()) && this.iMaxLoad != null && this.iMaxLoad.floatValue() > 0.0f;
    }

    public Float getMaxLoad() {
        return this.iMaxLoad;
    }

    public void setMaxLoad(Float maxLoad) {
        this.iMaxLoad = maxLoad;
    }

    public boolean hasAttributes() {
        return this.iAttributes != null && !this.iAttributes.isEmpty();
    }

    public List<AttributeInterface> getAttributes() {
        return this.iAttributes;
    }

    public List<AttributeInterface> getAttributes(AttributeTypeInterface type) {
        ArrayList<AttributeInterface> ret = new ArrayList<AttributeInterface>();
        if (this.hasAttributes()) {
            for (AttributeInterface a : this.getAttributes()) {
                if (type != null && !type.equals(a.getType())) continue;
                ret.add(a);
            }
        }
        return ret;
    }

    public void addAttribute(AttributeInterface attribute) {
        if (this.iAttributes == null) {
            this.iAttributes = new ArrayList<AttributeInterface>();
        }
        this.iAttributes.add(attribute);
    }

    public boolean hasAttribute(Long attributeId) {
        if (this.iAttributes == null || attributeId == null) {
            return false;
        }
        for (AttributeInterface a : this.iAttributes) {
            if (!a.getId().equals(attributeId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(InstructorInterface instructor) {
        int cmp = this.getOrderName().compareToIgnoreCase(instructor.getOrderName());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getId() == null ? new Long(-1L) : this.getId()).compareTo(instructor.getId() == null ? -1L : instructor.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof InstructorInterface)) {
            return false;
        }
        return this.getId().equals(((InstructorInterface)object).getId());
    }

    public String toString() {
        return (this.getFormattedName() == null ? this.getLastName() + ", " + this.getFirstName() : this.getFormattedName()) + (this.getExternalId() == null ? "" : " (" + this.getExternalId() + ")");
    }

    public static class TeachingRequestsFilterRpcRequest
    extends EventInterface.FilterRpcRequest {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssignmentChangesResponse
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<AssignmentInfo> iChanges = new ArrayList<AssignmentInfo>();

        public void addChange(AssignmentInfo change) {
            this.iChanges.add(change);
        }

        public List<AssignmentInfo> getChanges() {
            return this.iChanges;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssignmentChangesRequest
    implements GwtRpcRequest<AssignmentChangesResponse>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ChangesType iType = ChangesType.INITIAL;

        public AssignmentChangesRequest() {
        }

        public AssignmentChangesRequest(ChangesType type) {
            this.iType = type;
        }

        public void setType(ChangesType type) {
            this.iType = type;
        }

        public ChangesType getType() {
            return this.iType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangesType implements IsSerializable
    {
        INITIAL,
        BEST,
        SAVED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstructorAssignmentRequest
    implements GwtRpcRequest<GwtRpcResponseNull>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<AssignmentInfo> iAssignments = new ArrayList<AssignmentInfo>();
        private Boolean iIgnoreConflicts = null;

        public void addAssignment(AssignmentInfo assignment) {
            this.iAssignments.add(assignment);
        }

        public List<AssignmentInfo> getAssignments() {
            return this.iAssignments;
        }

        public void setIgnoreConflicts(Boolean ignoreConflicts) {
            this.iIgnoreConflicts = ignoreConflicts;
        }

        public boolean isIgnoreConflicts() {
            return this.iIgnoreConflicts != null && this.iIgnoreConflicts != false;
        }

        @Override
        public String toString() {
            return this.getAssignments() == null ? "" : this.getAssignments().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComputeSuggestionsRequest
    implements GwtRpcRequest<SuggestionsResponse>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<AssignmentInfo> iAssignments = new ArrayList<AssignmentInfo>();
        private Long iSelectedRequestId;
        private int iSelectedIndex;
        private Long iSelectedInstructorId;
        private int iMaxDepth = 2;
        private int iTimeout = 5000;
        private int iMaxDomain = 20;
        private int iMaxResults = 20;
        private boolean iComputeDomain = true;
        private boolean iComputeSuggestions = true;

        public void addAssignment(AssignmentInfo assignment) {
            this.iAssignments.add(assignment);
        }

        public List<AssignmentInfo> getAssignments() {
            return this.iAssignments;
        }

        public void setMaxDept(int maxDept) {
            this.iMaxDepth = maxDept;
        }

        public int getMaxDept() {
            return this.iMaxDepth;
        }

        public void setTimeout(int timeout) {
            this.iTimeout = timeout;
        }

        public int getTimeout() {
            return this.iTimeout;
        }

        public void setMaxDomain(int maxDomain) {
            this.iMaxDomain = maxDomain;
        }

        public int getMaxDomain() {
            return this.iMaxDomain;
        }

        public void setMaxResults(int maxResults) {
            this.iMaxResults = maxResults;
        }

        public int getMaxResults() {
            return this.iMaxResults;
        }

        public Long getSelectedRequestId() {
            return this.iSelectedRequestId;
        }

        public void setSelectedRequestId(Long requestId) {
            this.iSelectedRequestId = requestId;
        }

        public Long getSelectedInstructorId() {
            return this.iSelectedInstructorId;
        }

        public void setSelectedInstructorId(Long instructorId) {
            this.iSelectedInstructorId = instructorId;
        }

        public int getSelectedIndex() {
            return this.iSelectedIndex;
        }

        public void setSelectedIndex(int idx) {
            this.iSelectedIndex = idx;
        }

        public boolean isComputeSuggestions() {
            return this.iComputeSuggestions;
        }

        public boolean isComputeDomain() {
            return this.iComputeDomain;
        }

        public void setComputeAll() {
            this.iComputeDomain = true;
            this.iComputeSuggestions = true;
        }

        public void setComputeSuggestions() {
            this.iComputeDomain = false;
            this.iComputeSuggestions = true;
        }

        public void setComputeDomain() {
            this.iComputeDomain = true;
            this.iComputeSuggestions = false;
        }

        public void setComputeDomain(boolean compute) {
            this.iComputeDomain = compute;
        }

        @Override
        public String toString() {
            return this.getMaxDept() + "," + this.getTimeout() + "," + this.getMaxResults();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SuggestionsResponse
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private SuggestionInfo iAssignment = null;
        private List<SuggestionInfo> iSuggestions = null;
        private boolean iTimeoutReached = false;
        private int iNrCombinationsConsidered = 0;
        private int iNrSolutions = 0;
        private int iDomainSize = 0;
        private List<SuggestionInfo> iDomain = null;

        public boolean hasSuggestions() {
            return this.iSuggestions != null && !this.iSuggestions.isEmpty();
        }

        public void addSuggestion(SuggestionInfo suggestion) {
            if (this.iSuggestions == null) {
                this.iSuggestions = new ArrayList<SuggestionInfo>();
            }
            this.iSuggestions.add(suggestion);
        }

        public List<SuggestionInfo> getSuggestions() {
            return this.iSuggestions;
        }

        public boolean isTimeoutReached() {
            return this.iTimeoutReached;
        }

        public void setTimeoutReached(boolean timeoutReached) {
            this.iTimeoutReached = timeoutReached;
        }

        public int getNrCombinationsConsidered() {
            return this.iNrCombinationsConsidered;
        }

        public void setNrCombinationsConsidered(int nrCombinationsConsidered) {
            this.iNrCombinationsConsidered = nrCombinationsConsidered;
        }

        public int getNrSolutions() {
            return this.iNrSolutions;
        }

        public void setNrSolutions(int nrSolutions) {
            this.iNrSolutions = nrSolutions;
        }

        public int getDomainSize() {
            return this.iDomainSize;
        }

        public void setDomainSize(int size) {
            this.iDomainSize = size;
        }

        public void addDomainValue(SuggestionInfo suggestion) {
            if (this.iDomain == null) {
                this.iDomain = new ArrayList<SuggestionInfo>();
            }
            this.iDomain.add(suggestion);
        }

        public boolean hasDomainValues() {
            return this.iDomain != null && !this.iDomain.isEmpty();
        }

        public List<SuggestionInfo> getDomainValues() {
            return this.iDomain;
        }

        public SuggestionInfo getCurrentAssignment() {
            return this.iAssignment;
        }

        public void setCurrentAssignment(SuggestionInfo assignment) {
            this.iAssignment = assignment;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SuggestionInfo
    implements IsSerializable,
    Serializable,
    Comparable<SuggestionInfo> {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private List<AssignmentInfo> iAssignments = new ArrayList<AssignmentInfo>();
        private double iValue;
        private Map<String, Double> iValues = new HashMap<String, Double>();
        private int iNrConflicts = 0;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public void addAssignment(AssignmentInfo assignment) {
            if (assignment.getInstructor() == null) {
                ++this.iNrConflicts;
            }
            this.iAssignments.add(assignment);
        }

        public List<AssignmentInfo> getAssignments() {
            return this.iAssignments;
        }

        public void setValue(String criterion, double value) {
            this.iValues.put(criterion, value);
        }

        public void addValue(String criterion, double value) {
            Double old = this.iValues.get(criterion);
            this.iValues.put(criterion, value + (old == null ? 0.0 : old));
        }

        public Map<String, Double> getValues() {
            return this.iValues;
        }

        public Double getValue(String criterion) {
            return this.iValues.get(criterion);
        }

        public boolean hasValues() {
            if (this.iValues == null || this.iValues.isEmpty()) {
                return false;
            }
            for (Double value : this.iValues.values()) {
                if (value == 0.0) continue;
                return true;
            }
            return false;
        }

        public double getValue() {
            return this.iValue;
        }

        public void setValue(double value) {
            this.iValue = value;
        }

        public int nrConflicts() {
            return this.iNrConflicts;
        }

        @Override
        public int compareTo(SuggestionInfo s) {
            int conf = this.nrConflicts() - s.nrConflicts();
            if (conf != 0) {
                return conf;
            }
            if (this.getValue() < s.getValue()) {
                return -1;
            }
            if (this.getValue() > s.getValue()) {
                return 1;
            }
            int size = this.getAssignments().size() - s.getAssignments().size();
            if (size != 0) {
                return size;
            }
            return this.getId().compareTo(s.getId());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (AssignmentInfo a : this.getAssignments()) {
                if (sb.length() > 0) {
                    sb.append("\n\t");
                }
                sb.append(a);
            }
            return "[" + sb + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssignmentInfo
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private TeachingRequestInfo iRequest;
        private int iIndex;
        private InstructorInfo iInstructor;
        private List<String> iConflicts;

        public TeachingRequestInfo getRequest() {
            return this.iRequest;
        }

        public void setRequest(TeachingRequestInfo request) {
            this.iRequest = request;
        }

        public int getIndex() {
            return this.iIndex;
        }

        public void setIndex(int index) {
            this.iIndex = index;
        }

        public InstructorInfo getInstructor() {
            return this.iInstructor;
        }

        public void setInstructor(InstructorInfo instructor) {
            this.iInstructor = instructor;
        }

        public boolean hasConflicts() {
            return this.iConflicts != null && !this.iConflicts.isEmpty();
        }

        public List<String> getConflicts() {
            return this.iConflicts;
        }

        public String getConflicts(String separator) {
            if (this.iConflicts == null || this.iConflicts.isEmpty()) {
                return null;
            }
            String ret = "";
            for (String conflict : this.iConflicts) {
                ret = ret + (ret.isEmpty() ? "" : separator) + conflict;
            }
            return ret;
        }

        public void addConflict(String conflict) {
            if (this.iConflicts == null) {
                this.iConflicts = new ArrayList<String>();
            }
            this.iConflicts.add(conflict);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (SectionInfo section : this.getRequest().getSections()) {
                if (section.isCommon()) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(section.toString());
            }
            return this.getRequest().getCourse() + " " + sb + (this.getRequest().getNrInstructors() > 1 ? "[" + this.getIndex() + "]" : "") + ": " + (this.getInstructor() == null ? "NULL" : this.getInstructor());
        }

        public int hashCode() {
            return this.getRequest().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AssignmentInfo)) {
                return false;
            }
            AssignmentInfo assignment = (AssignmentInfo)object;
            return this.getRequest().equals(assignment.getRequest()) && this.getIndex() == assignment.getIndex();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TeachingAssignmentsDetailRequest
    implements GwtRpcRequest<InstructorInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iInstructorId;

        public TeachingAssignmentsDetailRequest() {
        }

        public TeachingAssignmentsDetailRequest(Long instructorId) {
            this.iInstructorId = instructorId;
        }

        public Long getInstructorId() {
            return this.iInstructorId;
        }

        public void setInstructorId(Long instructorId) {
            this.iInstructorId = instructorId;
        }

        @Override
        public String toString() {
            return this.getInstructorId().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TeachingRequestDetailRequest
    implements GwtRpcRequest<TeachingRequestInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iRequestId;

        public TeachingRequestDetailRequest() {
        }

        public TeachingRequestDetailRequest(Long requestId) {
            this.iRequestId = requestId;
        }

        public Long getRequestId() {
            return this.iRequestId;
        }

        public void setRequestId(Long requestId) {
            this.iRequestId = requestId;
        }

        @Override
        public String toString() {
            return this.getRequestId().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TeachingRequestsPagePropertiesResponse
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<SubjectAreaInterface> iSubjecAreas = new ArrayList<SubjectAreaInterface>();
        private List<DepartmentInterface> iDepartments = new ArrayList<DepartmentInterface>();
        private List<PreferenceInterface> iPreferences = new ArrayList<PreferenceInterface>();
        private Long iLastSubjectAreaId = null;
        private Long iLastDepartmentId = null;
        private List<AttributeTypeInterface> iAttributeTypes = new ArrayList<AttributeTypeInterface>();
        private List<RoomInterface.RoomSharingDisplayMode> iModes;
        private boolean iHasSolver;
        private InstructorAvailabilityWidget.InstructorAvailabilityModel iAvailabilityModel;

        public void addSubjectArea(SubjectAreaInterface subjectArea) {
            this.iSubjecAreas.add(subjectArea);
        }

        public List<SubjectAreaInterface> getSubjectAreas() {
            return this.iSubjecAreas;
        }

        public void addDepartment(DepartmentInterface department) {
            this.iDepartments.add(department);
        }

        public List<DepartmentInterface> getDepartments() {
            return this.iDepartments;
        }

        public void addPreference(PreferenceInterface preference) {
            this.iPreferences.add(preference);
        }

        public List<PreferenceInterface> getPreferences() {
            return this.iPreferences;
        }

        public PreferenceInterface getPreference(String p) {
            for (PreferenceInterface preference : this.iPreferences) {
                if (!p.equals(preference.getCode())) continue;
                return preference;
            }
            return null;
        }

        public void setLastSubjectAreaId(Long lastSubjectAreaId) {
            this.iLastSubjectAreaId = lastSubjectAreaId;
        }

        public Long getLastSubjectAreaId() {
            return this.iLastSubjectAreaId;
        }

        public void setLastDepartmentId(Long lastDepartmentId) {
            this.iLastDepartmentId = lastDepartmentId;
        }

        public Long getLastDepartmentId() {
            return this.iLastDepartmentId;
        }

        public boolean hasAttributeTypes() {
            return this.iAttributeTypes != null && !this.iAttributeTypes.isEmpty();
        }

        public void addAttributeType(AttributeTypeInterface type) {
            this.iAttributeTypes.add(type);
        }

        public List<AttributeTypeInterface> getAttributeTypes() {
            return this.iAttributeTypes;
        }

        public AttributeTypeInterface getAttributeType(Long typeId) {
            for (AttributeTypeInterface type : this.iAttributeTypes) {
                if (!type.getId().equals(typeId)) continue;
                return type;
            }
            return null;
        }

        public void addMode(RoomInterface.RoomSharingDisplayMode mode) {
            if (this.iModes == null) {
                this.iModes = new ArrayList<RoomInterface.RoomSharingDisplayMode>();
            }
            this.iModes.add(mode);
        }

        public List<RoomInterface.RoomSharingDisplayMode> getModes() {
            return this.iModes;
        }

        public boolean hasModes() {
            return this.iModes != null && !this.iModes.isEmpty();
        }

        public boolean isHasSolver() {
            return this.iHasSolver;
        }

        public void setHasSolver(boolean hasSolver) {
            this.iHasSolver = hasSolver;
        }

        public InstructorAvailabilityWidget.InstructorAvailabilityModel getInstructorAvailabilityModel() {
            return this.iAvailabilityModel;
        }

        public void setInstructorAvailabilityModel(InstructorAvailabilityWidget.InstructorAvailabilityModel model) {
            this.iAvailabilityModel = model;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TeachingRequestsPagePropertiesRequest
    implements GwtRpcRequest<TeachingRequestsPagePropertiesResponse>,
    Serializable {
        private static final long serialVersionUID = 1L;
    }

    public static class SubjectAreaInterface
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private String iAbbv;
        private String iLabel;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getAbbreviation() {
            return this.iAbbv;
        }

        public void setAbbreviation(String abbv) {
            this.iAbbv = abbv;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof DepartmentInterface)) {
                return false;
            }
            return this.getId().equals(((DepartmentInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return this.getAbbreviation();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TeachingAssignmentsPageRequest
    implements GwtRpcRequest<GwtRpcResponseList<InstructorInfo>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private TeachingRequestsFilterRpcRequest iRequest = null;

        public TeachingAssignmentsPageRequest() {
            this.iRequest = new TeachingRequestsFilterRpcRequest();
        }

        public TeachingAssignmentsPageRequest(TeachingRequestsFilterRpcRequest request) {
            this.iRequest = request;
        }

        public TeachingRequestsFilterRpcRequest getFilter() {
            return this.iRequest;
        }

        @Override
        public String toString() {
            return this.iRequest.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TeachingRequestsPageRequest
    implements GwtRpcRequest<GwtRpcResponseList<TeachingRequestInfo>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private TeachingRequestsFilterRpcRequest iRequest = null;

        public TeachingRequestsPageRequest() {
            this.iRequest = new TeachingRequestsFilterRpcRequest();
        }

        public TeachingRequestsPageRequest(TeachingRequestsFilterRpcRequest request) {
            this.iRequest = request;
        }

        public TeachingRequestsPageRequest(Long offeringId) {
            this.iRequest = new TeachingRequestsFilterRpcRequest();
            if (offeringId != null) {
                this.iRequest.setOption("offeringId", offeringId.toString());
            }
        }

        public TeachingRequestsFilterRpcRequest getFilter() {
            return this.iRequest;
        }

        @Override
        public String toString() {
            return this.iRequest.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassInfo
    implements Comparable<ClassInfo>,
    IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iCourseId;
        private Long iClassId;
        private String iCourse;
        private String iSection;
        private String iType;
        private String iExternalId;
        private String iRoom;
        private boolean iInstructor;
        private String iTime;
        private String iDate;

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public String getSection() {
            return this.iSection;
        }

        public void setSection(String section) {
            this.iSection = section;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public String getRoom() {
            return this.iRoom;
        }

        public void setRoom(String room) {
            this.iRoom = room;
        }

        public String getTime() {
            return this.iTime;
        }

        public void setTime(String time) {
            this.iTime = time;
        }

        public String getDate() {
            return this.iDate;
        }

        public void setDate(String date) {
            this.iDate = date;
        }

        public boolean isInstructor() {
            return this.iInstructor;
        }

        public void setInstructor(boolean instructor) {
            this.iInstructor = instructor;
        }

        public int hashCode() {
            return this.getClassId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ClassInfo)) {
                return false;
            }
            return this.getClassId().equals(((ClassInfo)o).getClassId());
        }

        @Override
        public int compareTo(ClassInfo o) {
            int cmp = this.getCourse().compareTo(o.getCourse());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getSection().compareTo(o.getSection());
            if (cmp != 0) {
                return cmp;
            }
            return this.getClassId().compareTo(o.getClassId());
        }

        public String toString() {
            return this.getCourse() + " " + this.getType() + " " + this.getExternalId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TeachingRequestInfo
    implements Comparable<TeachingRequestInfo>,
    GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private CourseInfo iCourse;
        private Long iRequestId;
        private float iLoad;
        private List<SectionInfo> iSections = new ArrayList<SectionInfo>();
        private List<InstructorInfo> iInstructors;
        private List<PreferenceInfo> iInstructorPreferences = new ArrayList<PreferenceInfo>();
        private List<PreferenceInfo> iAttributePreferences = new ArrayList<PreferenceInfo>();
        private Map<String, Double> iValues = new HashMap<String, Double>();
        private int iNrInstructors = 0;
        private boolean iConflict = false;
        private boolean iMatching = true;

        public void setCourse(CourseInfo course) {
            this.iCourse = course;
        }

        public CourseInfo getCourse() {
            return this.iCourse;
        }

        public void setRequestId(Long requestId) {
            this.iRequestId = requestId;
        }

        public Long getRequestId() {
            return this.iRequestId;
        }

        public void setLoad(float load) {
            this.iLoad = load;
        }

        public float getLoad() {
            return this.iLoad;
        }

        public void addSection(SectionInfo section) {
            this.iSections.add(section);
        }

        public List<SectionInfo> getSections() {
            return this.iSections;
        }

        public void addInstructor(InstructorInfo instructor) {
            if (this.iInstructors == null) {
                this.iInstructors = new ArrayList<InstructorInfo>();
            }
            this.iInstructors.add(instructor);
        }

        public boolean hasInstructors() {
            return this.iInstructors != null && !this.iInstructors.isEmpty();
        }

        public InstructorInfo getInstructor(int index) {
            if (this.iInstructors == null || this.iInstructors.isEmpty()) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            for (int i = 0; i < this.iInstructors.size(); ++i) {
                InstructorInfo instructor = this.iInstructors.get(i);
                if (instructor.hasAssignmentIndex() && index == instructor.getAssignmentIndex()) {
                    return instructor;
                }
                if (instructor.hasAssignmentIndex() || index != i) continue;
                return instructor;
            }
            return null;
        }

        public int getNrAssignedInstructors() {
            return this.iInstructors == null ? 0 : this.iInstructors.size();
        }

        public List<InstructorInfo> getInstructors() {
            return this.iInstructors;
        }

        public InstructorInfo getInstructor(Long instructorId) {
            if (this.iInstructors == null) {
                return null;
            }
            for (InstructorInfo instructor : this.iInstructors) {
                if (!instructor.getInstructorId().equals(instructorId)) continue;
                return instructor;
            }
            return null;
        }

        public void addInstructorPreference(PreferenceInfo preference) {
            this.iInstructorPreferences.add(preference);
        }

        public List<PreferenceInfo> getInstructorPreferences() {
            return this.iInstructorPreferences;
        }

        public void addAttributePreference(PreferenceInfo preference) {
            this.iAttributePreferences.add(preference);
        }

        public List<PreferenceInfo> getAttributePreferences() {
            return this.iAttributePreferences;
        }

        public void setValue(String criterion, double value) {
            this.iValues.put(criterion, value);
        }

        public Map<String, Double> getValues() {
            return this.iValues;
        }

        public Double getValue(String criterion) {
            return this.iValues.get(criterion);
        }

        public int getNrInstructors() {
            return this.iNrInstructors;
        }

        public void setNrInstructors(int nrInstructors) {
            this.iNrInstructors = nrInstructors;
        }

        public boolean isConflict() {
            return this.iConflict;
        }

        public void setConflict(boolean conflict) {
            this.iConflict = conflict;
        }

        public boolean isMatchingFilter() {
            return this.iMatching;
        }

        public void setMatchingFilter(boolean matching) {
            this.iMatching = matching;
        }

        public int hashCode() {
            return this.iRequestId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TeachingRequestInfo)) {
                return false;
            }
            TeachingRequestInfo tr = (TeachingRequestInfo)o;
            return this.getRequestId().equals(tr.getRequestId());
        }

        @Override
        public int compareTo(TeachingRequestInfo r) {
            int cmp = this.getCourse().compareTo(r.getCourse());
            if (cmp != 0) {
                return cmp;
            }
            Iterator<SectionInfo> i1 = this.getSections().iterator();
            Iterator<SectionInfo> i2 = r.getSections().iterator();
            while (i1.hasNext() && i2.hasNext()) {
                cmp = i1.next().compareTo(i2.next());
                if (cmp == 0) continue;
                return cmp;
            }
            if (i2.hasNext()) {
                return -1;
            }
            if (i1.hasNext()) {
                return 1;
            }
            return this.getRequestId().compareTo(r.getRequestId());
        }

        public String toString() {
            return this.getCourse() + " " + this.getSections();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstructorInfo
    implements Comparable<InstructorInfo>,
    GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iInstructorId;
        private String iExternalId;
        private String iName;
        private float iAssignedLoad;
        private float iMaxLoad;
        private String iTeachingPreference;
        private List<PreferenceInfo> iTimePreferences = new ArrayList<PreferenceInfo>();
        private List<PreferenceInfo> iCoursePreferences = new ArrayList<PreferenceInfo>();
        private List<PreferenceInfo> iDistributionPreferences = new ArrayList<PreferenceInfo>();
        private Set<AttributeInterface> iAttributes = new TreeSet<AttributeInterface>();
        private Map<String, Double> iValues = new HashMap<String, Double>();
        private String iAvailability;
        private List<TeachingRequestInfo> iAssignedRequests = new ArrayList<TeachingRequestInfo>();
        private Set<ClassInfo> iEnrollments = new TreeSet<ClassInfo>();
        private int iAssignmentIndex = -1;
        private boolean iConflict = false;
        private boolean iMatching = true;

        public void setInstructorId(Long instructorId) {
            this.iInstructorId = instructorId;
        }

        public Long getInstructorId() {
            return this.iInstructorId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public boolean hasExternalId() {
            return this.iExternalId != null && !this.iExternalId.isEmpty();
        }

        public void setInstructorName(String name) {
            this.iName = name;
        }

        public String getInstructorName() {
            return this.iName;
        }

        public void setAssignedLoad(float assignedLoad) {
            this.iAssignedLoad = assignedLoad;
        }

        public float getAssignedLoad() {
            return this.iAssignedLoad;
        }

        public void setMaxLoad(float maxLoad) {
            this.iMaxLoad = maxLoad;
        }

        public float getMaxLoad() {
            return this.iMaxLoad;
        }

        public void setTeachingPreference(String teachinPreference) {
            this.iTeachingPreference = teachinPreference;
        }

        public String getTeachingPreference() {
            return this.iTeachingPreference;
        }

        public void addTimePreference(PreferenceInfo preference) {
            this.iTimePreferences.add(preference);
        }

        public List<PreferenceInfo> getTimePreferences() {
            return this.iTimePreferences;
        }

        public void addCoursePreference(PreferenceInfo preference) {
            this.iCoursePreferences.add(preference);
        }

        public List<PreferenceInfo> getCoursePreferences() {
            return this.iCoursePreferences;
        }

        public void addDistributionPreference(PreferenceInfo preference) {
            this.iDistributionPreferences.add(preference);
        }

        public List<PreferenceInfo> getDistributionPreferences() {
            return this.iDistributionPreferences;
        }

        public boolean hasAssignmentIndex() {
            return this.iAssignmentIndex >= 0;
        }

        public int getAssignmentIndex() {
            return this.iAssignmentIndex;
        }

        public void setAssignmentIndex(int index) {
            this.iAssignmentIndex = index;
        }

        public void addAttribute(AttributeInterface attribute) {
            this.iAttributes.add(attribute);
        }

        public Set<AttributeInterface> getAttributes() {
            return this.iAttributes;
        }

        public boolean hasAttribute(String attribute) {
            for (AttributeInterface a : this.iAttributes) {
                if (!attribute.equals(a.getName())) continue;
                return true;
            }
            return false;
        }

        public void setValue(String criterion, double value) {
            this.iValues.put(criterion, value);
        }

        public void addValue(String criterion, double value) {
            Double old = this.iValues.get(criterion);
            this.iValues.put(criterion, value + (old == null ? 0.0 : old));
        }

        public Map<String, Double> getValues() {
            return this.iValues;
        }

        public Double getValue(String criterion) {
            return this.iValues.get(criterion);
        }

        public void setAvailability(String availability) {
            this.iAvailability = availability;
        }

        public String getAvailability() {
            return this.iAvailability;
        }

        public boolean hetAvailability() {
            return this.iAvailability != null && !this.iAvailability.isEmpty();
        }

        public List<TeachingRequestInfo> getAssignedRequests() {
            return this.iAssignedRequests;
        }

        public void addAssignedRequest(TeachingRequestInfo request) {
            this.iAssignedRequests.add(request);
        }

        public Set<ClassInfo> getEnrollments() {
            return this.iEnrollments;
        }

        public void addEnrollment(ClassInfo enrollment) {
            this.iEnrollments.add(enrollment);
        }

        public int hashCode() {
            return this.getInstructorId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof InstructorInfo)) {
                return false;
            }
            return this.getInstructorId().equals(((InstructorInfo)o).getInstructorId());
        }

        @Override
        public int compareTo(InstructorInfo course) {
            return this.getInstructorName().compareTo(course.getInstructorName());
        }

        public boolean isConflict() {
            return this.iConflict;
        }

        public void setConflict(boolean conflict) {
            this.iConflict = conflict;
        }

        public boolean isMatchingFilter() {
            return this.iMatching;
        }

        public void setMatchingFilter(boolean matching) {
            this.iMatching = matching;
        }

        public String toString() {
            return this.getInstructorName() + (this.getExternalId() == null ? "" : " (" + this.getExternalId() + ")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreferenceInfo
    implements Comparable<PreferenceInfo>,
    IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iOwnerId;
        private String iName;
        private String iPreference;
        private String iComparable;

        public PreferenceInfo() {
        }

        public PreferenceInfo(Long id, String name, String pref) {
            this.iOwnerId = id;
            this.iName = name;
            this.iPreference = pref;
        }

        public void setOwnerId(Long ownerId) {
            this.iOwnerId = ownerId;
        }

        public Long getOwnerId() {
            return this.iOwnerId;
        }

        public void setOwnerName(String name) {
            this.iName = name;
        }

        public String getOwnerName() {
            return this.iName;
        }

        public void setPreference(String preference) {
            this.iPreference = preference;
        }

        public String getPreference() {
            return this.iPreference;
        }

        public void setComparable(String comparable) {
            this.iComparable = comparable;
        }

        public String getComparable() {
            return this.iComparable == null ? this.iName : this.iComparable;
        }

        public int hashCode() {
            return this.getOwnerId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof PreferenceInfo)) {
                return false;
            }
            return this.getOwnerId().equals(((PreferenceInfo)o).getOwnerId());
        }

        @Override
        public int compareTo(PreferenceInfo pref) {
            int cmp = this.getComparable().compareTo(pref.getComparable());
            if (cmp != 0) {
                return cmp;
            }
            return this.getPreference().compareTo(pref.getPreference());
        }

        public String toString() {
            return this.getPreference() + " " + this.getOwnerName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SectionInfo
    implements Comparable<SectionInfo>,
    IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iSectionId;
        private String iSectionName;
        private String iExternalId;
        private String iType;
        private boolean iCommon;
        private String iTime;
        private String iDate;
        private String iRoom;

        public void setSectionId(Long sectionId) {
            this.iSectionId = sectionId;
        }

        public Long getSectionId() {
            return this.iSectionId;
        }

        public void setSectionName(String sectionName) {
            this.iSectionName = sectionName;
        }

        public String getSectionName() {
            return this.iSectionName;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setSectionType(String type) {
            this.iType = type;
        }

        public String getSectionType() {
            return this.iType;
        }

        public void setCommon(boolean common) {
            this.iCommon = common;
        }

        public boolean isCommon() {
            return this.iCommon;
        }

        public void setTime(String time) {
            this.iTime = time;
        }

        public String getTime() {
            return this.iTime;
        }

        public void setDate(String date) {
            this.iDate = date;
        }

        public String getDate() {
            return this.iDate;
        }

        public void setRoom(String room) {
            this.iRoom = room;
        }

        public String getRoom() {
            return this.iRoom;
        }

        public int hashCode() {
            return this.getSectionId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof SectionInfo)) {
                return false;
            }
            return this.getSectionId().equals(((SectionInfo)o).getSectionId());
        }

        @Override
        public int compareTo(SectionInfo section) {
            int cmp = (this.getExternalId() == null ? "" : this.getExternalId()).compareTo(section.getExternalId() == null ? "" : section.getExternalId());
            if (cmp != 0) {
                return cmp;
            }
            return this.getSectionName().compareTo(section.getSectionName());
        }

        public String toString() {
            return this.getExternalId() == null ? this.getSectionName() : this.getSectionType() + " " + this.getExternalId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CourseInfo
    implements Comparable<CourseInfo>,
    IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iCourseId;
        private String iCourseName;

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseName(String courseName) {
            this.iCourseName = courseName;
        }

        public String getCourseName() {
            return this.iCourseName;
        }

        public int hashCode() {
            return this.getCourseId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CourseInfo)) {
                return false;
            }
            return this.getCourseId().equals(((CourseInfo)o).getCourseId());
        }

        @Override
        public int compareTo(CourseInfo course) {
            return this.getCourseName().compareTo(course.getCourseName());
        }

        public String toString() {
            return this.getCourseName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetLastDepartmentRequest
    implements GwtRpcRequest<GwtRpcResponseNull>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public Long iDepartmentId;

        public SetLastDepartmentRequest() {
        }

        public SetLastDepartmentRequest(Long departmentId) {
            this.setDepartmentId(departmentId);
        }

        public void setDepartmentId(Long departmentId) {
            this.iDepartmentId = departmentId;
        }

        public Long getDepartmentId() {
            return this.iDepartmentId;
        }

        @Override
        public String toString() {
            return this.iDepartmentId == null ? "" : this.iDepartmentId.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetInstructorAttributeParentsRequest
    implements GwtRpcRequest<GwtRpcResponseList<AttributeInterface>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public Long iDepartmentId;
        public Long iTypeId;
        public Long iAttributeId;

        public GetInstructorAttributeParentsRequest() {
        }

        public GetInstructorAttributeParentsRequest(Long departmentId, Long typeId, Long attributeId) {
            this.iDepartmentId = departmentId;
            this.iTypeId = typeId;
            this.iAttributeId = attributeId;
        }

        public void setDepartmentId(Long departmentId) {
            this.iDepartmentId = departmentId;
        }

        public Long getDepartmentId() {
            return this.iDepartmentId;
        }

        public void setTypeId(Long typeId) {
            this.iTypeId = typeId;
        }

        public Long getTypeId() {
            return this.iTypeId;
        }

        public void setAttributeId(Long attributeId) {
            this.iAttributeId = attributeId;
        }

        public Long getAttributeId() {
            return this.iAttributeId;
        }

        @Override
        public String toString() {
            return (this.iDepartmentId == null ? "" : this.iDepartmentId.toString()) + "," + (this.iTypeId == null ? "" : this.iTypeId.toString()) + "," + (this.iAttributeId == null ? "" : this.iAttributeId.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateInstructorAttributeRequest
    implements GwtRpcRequest<AttributeInterface>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iDeleteAttributeId = null;
        private AttributeInterface iAttribute = null;
        private List<Long> iAddInstructors = new ArrayList<Long>();
        private List<Long> iDropInstructors = new ArrayList<Long>();

        public void setDeleteAttributeId(Long attributeId) {
            this.iDeleteAttributeId = attributeId;
        }

        public boolean hasDeleteAttributeId() {
            return this.iDeleteAttributeId != null;
        }

        public Long getDeleteAttributeId() {
            return this.iDeleteAttributeId;
        }

        public boolean hasAttribute() {
            return this.iAttribute != null;
        }

        public void setAttribute(AttributeInterface attribute) {
            this.iAttribute = attribute;
        }

        public AttributeInterface getAttribute() {
            return this.iAttribute;
        }

        public void addInstructor(Long instructorId) {
            this.iAddInstructors.add(instructorId);
        }

        public List<Long> getAddInstructors() {
            return this.iAddInstructors;
        }

        public boolean hasAddInstructors() {
            return !this.iAddInstructors.isEmpty();
        }

        public void dropInstructor(Long instructorId) {
            this.iDropInstructors.add(instructorId);
        }

        public List<Long> getDropInstructors() {
            return this.iDropInstructors;
        }

        public boolean hasDropInstructors() {
            return !this.iDropInstructors.isEmpty();
        }

        @Override
        public String toString() {
            if (this.hasAttribute()) {
                return this.getAttribute().getName() + (this.getAttribute().getType() == null ? "" : " (" + this.getAttribute().getType().getAbbreviation() + ")") + (this.hasAddInstructors() ? " ADD" + this.getAddInstructors() : "") + (this.hasDropInstructors() ? " DROP" + this.getDropInstructors() : "");
            }
            return "DELETE " + this.getDeleteAttributeId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetInstructorsRequest
    implements GwtRpcRequest<GwtRpcResponseList<InstructorInterface>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public Long iDepartmentId;

        public void setDepartmentId(Long departmentId) {
            this.iDepartmentId = departmentId;
        }

        public Long getDepartmentId() {
            return this.iDepartmentId;
        }

        @Override
        public String toString() {
            return this.iDepartmentId == null ? "" : this.iDepartmentId.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GetInstructorAttributesRequest
    implements GwtRpcRequest<GwtRpcResponseList<AttributeInterface>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public Long iDepartmentId;

        public void setDepartmentId(Long departmentId) {
            this.iDepartmentId = departmentId;
        }

        public Long getDepartmentId() {
            return this.iDepartmentId;
        }

        @Override
        public String toString() {
            return this.iDepartmentId == null ? "" : this.iDepartmentId.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstructorAttributePropertiesRequest
    implements GwtRpcRequest<InstructorAttributePropertiesInterface>,
    Serializable {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstructorAttributePropertiesInterface
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private List<DepartmentInterface> iDepartments = new ArrayList<DepartmentInterface>();
        private List<AttributeTypeInterface> iAttributeTypes = new ArrayList<AttributeTypeInterface>();
        private boolean iCanAddGlobalAttribute = false;
        private Long iLastDepartmentId = null;

        public boolean hasDepartments() {
            return this.iDepartments != null && !this.iDepartments.isEmpty();
        }

        public void addDepartment(DepartmentInterface department) {
            this.iDepartments.add(department);
        }

        public List<DepartmentInterface> getDepartments() {
            return this.iDepartments;
        }

        public DepartmentInterface getDepartment(Long departmentId) {
            for (DepartmentInterface department : this.iDepartments) {
                if (!department.getId().equals(departmentId)) continue;
                return department;
            }
            return null;
        }

        public boolean hasAttributeTypes() {
            return this.iAttributeTypes != null && !this.iAttributeTypes.isEmpty();
        }

        public void addAttributeType(AttributeTypeInterface type) {
            this.iAttributeTypes.add(type);
        }

        public List<AttributeTypeInterface> getAttributeTypes() {
            return this.iAttributeTypes;
        }

        public AttributeTypeInterface getAttributeType(Long typeId) {
            for (AttributeTypeInterface type : this.iAttributeTypes) {
                if (!type.getId().equals(typeId)) continue;
                return type;
            }
            return null;
        }

        public boolean isCanAddGlobalAttribute() {
            return this.iCanAddGlobalAttribute;
        }

        public void setCanAddGlobalAttribute(boolean canAddGlobalAttribute) {
            this.iCanAddGlobalAttribute = canAddGlobalAttribute;
        }

        public Long getLastDepartmentId() {
            return this.iLastDepartmentId;
        }

        public void setLastDepartmentId(Long departmentId) {
            this.iLastDepartmentId = departmentId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributesColumn implements IsSerializable
    {
        CODE,
        NAME,
        TYPE,
        PARENT,
        INSTRUCTORS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstructorsColumn implements IsSerializable
    {
        SELECTION,
        ID,
        NAME,
        POSITION,
        TEACHING_PREF,
        MAX_LOAD,
        ATTRIBUTES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeInterface
    implements GwtRpcResponse,
    Serializable,
    Comparable<AttributeInterface> {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private Long iParentId;
        private String iCode;
        private String iName;
        private String iParentName;
        private DepartmentInterface iDepartment = null;
        private AttributeTypeInterface iType;
        private TreeSet<InstructorInterface> iInstructors = null;
        private Boolean iCanEdit = null;
        private Boolean iCanDelete = null;
        private Boolean iCanAssign = null;
        private Boolean iCanChangeType = null;

        public AttributeInterface() {
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public Long getParentId() {
            return this.iParentId;
        }

        public void setParentId(Long id) {
            this.iParentId = id;
        }

        public String getParentName() {
            return this.iParentName;
        }

        public void setParentName(String name) {
            this.iParentName = name;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public AttributeInterface(AttributeInterface attribute) {
            this.iId = attribute.iId;
            this.iCode = attribute.iCode;
            this.iName = attribute.iName;
            this.iParentId = attribute.iParentId;
            this.iParentName = attribute.iParentName;
            this.iDepartment = attribute.iDepartment;
            this.iInstructors = attribute.iInstructors == null ? null : new TreeSet<InstructorInterface>((SortedSet<InstructorInterface>)attribute.iInstructors);
            this.iCanEdit = attribute.iCanEdit;
            this.iCanDelete = attribute.iCanDelete;
            this.iCanAssign = attribute.iCanAssign;
            this.iCanChangeType = attribute.iCanChangeType;
        }

        public boolean isDepartmental() {
            return this.iDepartment != null;
        }

        public DepartmentInterface getDepartment() {
            return this.iDepartment;
        }

        public void setDepartment(DepartmentInterface department) {
            this.iDepartment = department;
        }

        public boolean hasType() {
            return this.iType != null;
        }

        public AttributeTypeInterface getType() {
            return this.iType;
        }

        public void setType(AttributeTypeInterface type) {
            this.iType = type;
        }

        public boolean hasInstructors() {
            return this.iInstructors != null && !this.iInstructors.isEmpty();
        }

        public void addInstructor(InstructorInterface instructor) {
            if (this.iInstructors == null) {
                this.iInstructors = new TreeSet();
            }
            this.iInstructors.add(instructor);
        }

        public TreeSet<InstructorInterface> getInstructors() {
            return this.iInstructors;
        }

        public InstructorInterface getInstructor(Long id) {
            if (this.iInstructors == null || id == null) {
                return null;
            }
            for (InstructorInterface instructor : this.iInstructors) {
                if (!id.equals(instructor.getId())) continue;
                return instructor;
            }
            return null;
        }

        public boolean hasInstructor(Long id) {
            if (this.iInstructors == null || id == null) {
                return false;
            }
            for (InstructorInterface instructor : this.iInstructors) {
                if (!id.equals(instructor.getId())) continue;
                return true;
            }
            return false;
        }

        public boolean canEdit() {
            return this.iCanEdit != null && this.iCanEdit != false;
        }

        public void setCanEdit(Boolean canEdit) {
            this.iCanEdit = canEdit;
        }

        public boolean canDelete() {
            return this.iCanDelete != null && this.iCanDelete != false;
        }

        public void setCanDelete(Boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean canAssign() {
            return this.iCanAssign != null && this.iCanAssign != false;
        }

        public void setCanAssign(Boolean canAssign) {
            this.iCanAssign = canAssign;
        }

        public boolean canChangeType() {
            return this.iCanChangeType != null && this.iCanChangeType != false;
        }

        public void setCanChangeType(Boolean canChangeType) {
            this.iCanChangeType = canChangeType;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof AttributeInterface)) {
                return false;
            }
            return this.getId().equals(((AttributeInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return this.getName() + (this.getType() == null ? "" : " (" + this.getType() + ")");
        }

        @Override
        public int compareTo(AttributeInterface a) {
            int cmp = (this.hasType() ? this.getType().getLabel() : "").compareTo(a.hasType() ? a.getType().getLabel() : "");
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getName().compareTo(a.getName());
            if (cmp != 0) {
                return cmp;
            }
            return (this.getId() == null ? new Long(0L) : this.getId()).compareTo(a.getId() == null ? new Long(0L) : a.getId());
        }
    }

    public static class PreferenceInterface
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String iCode;
        private String iName;
        private String iAbbv;
        private String iColor;
        private Long iId;
        private boolean iEditable;

        public PreferenceInterface() {
        }

        public PreferenceInterface(Long id, String color, String code, String name, String abbv, boolean editable) {
            this.iId = id;
            this.iColor = color;
            this.iCode = code;
            this.iName = name;
            this.iAbbv = abbv;
            this.iEditable = editable;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getAbbv() {
            return this.iAbbv;
        }

        public void setAbbv(String abbv) {
            this.iAbbv = abbv;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof PreferenceInterface)) {
                return false;
            }
            return this.getId().equals(((PreferenceInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class DepartmentInterface
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private String iAbbv;
        private String iCode;
        private String iLabel;
        private String iTitle;
        private boolean iCanAddAttribute;
        private boolean iCanSeeAttributes;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getAbbreviation() {
            return this.iAbbv;
        }

        public void setAbbreviation(String abbv) {
            this.iAbbv = abbv;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getDeptCode() {
            return this.iCode;
        }

        public void setDeptCode(String code) {
            this.iCode = code;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public String getAbbreviationOrCode() {
            return this.getAbbreviation() == null || this.getAbbreviation().isEmpty() ? this.getDeptCode() : this.getAbbreviation();
        }

        public boolean isCanSeeAttributes() {
            return this.iCanSeeAttributes;
        }

        public void setCanSeeAttributes(boolean canSeeAttributes) {
            this.iCanSeeAttributes = canSeeAttributes;
        }

        public boolean isCanAddAttribute() {
            return this.iCanAddAttribute;
        }

        public void setCanAddAttribute(boolean canAddAttribute) {
            this.iCanAddAttribute = canAddAttribute;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof DepartmentInterface)) {
                return false;
            }
            return this.getId().equals(((DepartmentInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return this.getDeptCode() + " - " + this.getLabel();
        }
    }

    public static class PositionInterface
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private String iAbbv;
        private String iLabel;
        private Integer iSortOrder;

        public PositionInterface() {
        }

        public PositionInterface(Long id, String abbv, String label) {
            this.iId = id;
            this.iAbbv = abbv;
            this.iLabel = label;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getAbbreviation() {
            return this.iAbbv;
        }

        public void setAbbreviation(String abbv) {
            this.iAbbv = abbv;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public Integer getSortOrder() {
            return this.iSortOrder;
        }

        public void setSortOrder(Integer sortOrder) {
            this.iSortOrder = sortOrder;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PositionInterface)) {
                return false;
            }
            return this.getId().equals(((PositionInterface)object).getId());
        }

        public String toString() {
            return this.getLabel();
        }
    }

    public static class AttributeTypeInterface
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Long iId;
        private String iAbbv;
        private String iLabel;
        private boolean iConjunctive = false;
        private boolean iRequired = false;

        public AttributeTypeInterface() {
        }

        public AttributeTypeInterface(Long id, String abbv, String label, boolean conjunctive, boolean required) {
            this.iId = id;
            this.iAbbv = abbv;
            this.iLabel = label;
            this.iConjunctive = conjunctive;
            this.iRequired = required;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getAbbreviation() {
            return this.iAbbv;
        }

        public void setAbbreviation(String abbv) {
            this.iAbbv = abbv;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public boolean isConjunctive() {
            return this.iConjunctive;
        }

        public void setConjunctive(boolean conjunctive) {
            this.iConjunctive = conjunctive;
        }

        public boolean isRequired() {
            return this.iRequired;
        }

        public void setRequired(boolean required) {
            this.iRequired = required;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AttributeTypeInterface)) {
                return false;
            }
            return this.getId().equals(((AttributeTypeInterface)object).getId());
        }

        public String toString() {
            return this.getLabel();
        }
    }
}

