/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.services.CurriculaService;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CurriculaException;
import org.unitime.timetable.gwt.shared.CurriculumInterface;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.CurriculumProjectionRule;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.base.BaseCurriculum;
import org.unitime.timetable.model.base.BaseCurriculumClassification;
import org.unitime.timetable.model.base.BaseCurriculumCourse;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.AcademicAreaDAO;
import org.unitime.timetable.model.dao.AcademicClassificationDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.PosMajorDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.custom.CourseDetailsProvider;
import org.unitime.timetable.onlinesectioning.custom.DefaultCourseDetailsProvider;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.curricula.CurriculumFilterBackend;
import org.unitime.timetable.test.MakeCurriculaFromLastlikeDemands;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.NameFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="curricula.gwt")
public class CurriculaServlet
implements CurriculaService {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Logger sLog = Logger.getLogger(CurriculaServlet.class);
    private static DecimalFormat sDF = new DecimalFormat("0.0");
    private CourseDetailsProvider iCourseDetailsProvider;
    @Autowired
    private SessionContext sessionContext;
    @Autowired
    Permission.PermissionDepartment permissionDepartment;

    private CourseDetailsProvider getCourseDetailsProvider() {
        if (this.iCourseDetailsProvider == null) {
            try {
                String providerClass = ApplicationProperty.CustomizationCourseDetails.value();
                if (providerClass != null) {
                    this.iCourseDetailsProvider = (CourseDetailsProvider)Class.forName(providerClass).newInstance();
                }
            }
            catch (Exception e) {
                sLog.warn((Object)("Failed to initialize course detail provider: " + e.getMessage()));
                this.iCourseDetailsProvider = new DefaultCourseDetailsProvider();
            }
        }
        return this.iCourseDetailsProvider;
    }

    protected SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public TreeSet<CurriculumInterface> findCurricula(CurriculumInterface.CurriculumFilterRpcRequest filter) throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)("findCurricula(filter='" + filter + "')"));
            Long s0 = System.currentTimeMillis();
            TreeSet<CurriculumInterface> results = new TreeSet<CurriculumInterface>();
            this.getSessionContext().setAttribute("Curricula.LastFilter", (Object)filter.toQueryString());
            boolean hasSnapshotData = this.hasSnapshotData(CurriculumDAO.getInstance().getSession(), this.getAcademicSessionId());
            for (Curriculum c : CurriculumFilterBackend.curricula(this.getSessionContext().getUser().getCurrentAcademicSessionId(), filter.getOptions(), new Query(filter.getText()), -1, null, Department.getUserDepartments(this.getSessionContext().getUser()))) {
                CurriculumInterface ci = new CurriculumInterface();
                ci.setId(c.getUniqueId());
                ci.setAbbv(c.getAbbv());
                ci.setName(c.getName());
                ci.setEditable(this.getSessionContext().hasPermission(c, Right.CurriculumEdit));
                ci.setMultipleMajors(c.isMultipleMajors());
                ci.setSessionHasSnapshotData(hasSnapshotData);
                CurriculumInterface.DepartmentInterface di = new CurriculumInterface.DepartmentInterface();
                di.setId(c.getDepartment().getUniqueId());
                di.setAbbv(c.getDepartment().getAbbreviation());
                di.setCode(c.getDepartment().getDeptCode());
                di.setName(c.getDepartment().getName());
                ci.setDepartment(di);
                CurriculumInterface.AcademicAreaInterface ai = new CurriculumInterface.AcademicAreaInterface();
                ai.setId(c.getAcademicArea().getUniqueId());
                ai.setAbbv(c.getAcademicArea().getAcademicAreaAbbreviation());
                ai.setName(Constants.curriculaToInitialCase(c.getAcademicArea().getTitle()));
                ci.setAcademicArea(ai);
                for (PosMajor major : c.getMajors()) {
                    CurriculumInterface.MajorInterface mi = new CurriculumInterface.MajorInterface();
                    mi.setId(major.getUniqueId());
                    mi.setCode(major.getCode());
                    mi.setName(Constants.curriculaToInitialCase(major.getName()));
                    ci.addMajor(mi);
                }
                results.add(ci);
            }
            sLog.debug((Object)("Found " + results.size() + " curricula (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public List<CurriculumInterface.CurriculumClassificationInterface> loadClassifications(List<Long> curriculumIds) throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)("loadClassifications(curriculumIds=" + curriculumIds + ")"));
            Long s0 = System.currentTimeMillis();
            if (curriculumIds == null || curriculumIds.isEmpty()) {
                return new ArrayList<CurriculumInterface.CurriculumClassificationInterface>();
            }
            ArrayList<CurriculumInterface.CurriculumClassificationInterface> results = new ArrayList<CurriculumInterface.CurriculumClassificationInterface>();
            TreeSet<CurriculumInterface.AcademicClassificationInterface> academicClassifications = this.loadAcademicClassifications();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            boolean hasSnapshotData = this.hasSnapshotData(hibSession, this.getAcademicSessionId());
            try {
                for (Long curriculumId : curriculumIds) {
                    CurriculumInterface.AcademicClassificationInterface aci;
                    double snapshotRule;
                    Hashtable<String, Integer> major2ll;
                    float snapshotProj;
                    float proj;
                    int lastLike;
                    CurriculumInterface.CurriculumClassificationInterface cfi;
                    Curriculum c = (Curriculum)CurriculumDAO.getInstance().get(curriculumId, hibSession);
                    if (c == null) {
                        throw new CurriculaException(MESSAGES.errorCurriculumDoesNotExist(curriculumId == null ? "null" : curriculumId.toString()));
                    }
                    Hashtable<String, HashMap<String, Float>> rules = this.getRules(hibSession, c.getAcademicArea().getUniqueId());
                    Hashtable<String, HashMap<String, Float>> snapshotRules = null;
                    if (hasSnapshotData) {
                        snapshotRules = this.getSnapshotRules(hibSession, c.getAcademicArea().getUniqueId());
                    }
                    Hashtable<Long, Integer> clasf2enrl = this.loadClasf2enrl(hibSession, c);
                    Hashtable<Long, Integer> clasf2req = this.loadClasf2req(hibSession, c);
                    Hashtable<String, Hashtable<String, Integer>> clasfMajor2ll = this.loadClasfMajor2ll(hibSession, c);
                    TreeSet<CurriculumClassification> classifications = new TreeSet<CurriculumClassification>(c.getClassifications());
                    for (CurriculumClassification curriculumClassification : classifications) {
                        cfi = new CurriculumInterface.CurriculumClassificationInterface();
                        cfi.setId(curriculumClassification.getUniqueId());
                        cfi.setName(curriculumClassification.getName());
                        cfi.setCurriculumId(c.getUniqueId());
                        lastLike = 0;
                        proj = 0.0f;
                        snapshotProj = 0.0f;
                        major2ll = clasfMajor2ll.get(curriculumClassification.getAcademicClassification().getCode());
                        if (major2ll != null) {
                            if (c.isMultipleMajors().booleanValue() && c.getMajors().size() > 1) {
                                double rule = 1.0;
                                snapshotRule = 1.0;
                                for (PosMajor m : c.getMajors()) {
                                    rule *= (double)this.getProjection(rules, m.getCode(), curriculumClassification.getAcademicClassification().getCode());
                                    if (!hasSnapshotData) continue;
                                    snapshotRule *= (double)this.getSnapshotProjection(snapshotRules, m.getCode(), curriculumClassification.getAcademicClassification().getCode());
                                }
                                for (Integer ll : major2ll.values()) {
                                    lastLike += ll.intValue();
                                }
                                proj = (float)(Math.pow(rule, 1.0 / (double)c.getMajors().size()) * (double)lastLike);
                                if (hasSnapshotData) {
                                    snapshotProj = (float)(Math.pow(snapshotRule, 1.0 / (double)c.getMajors().size()) * (double)lastLike);
                                }
                            } else {
                                for (Map.Entry<String, Integer> m2l : major2ll.entrySet()) {
                                    lastLike += m2l.getValue().intValue();
                                    proj += this.getProjection(rules, m2l.getKey(), curriculumClassification.getAcademicClassification().getCode()) * (float)m2l.getValue().intValue();
                                    if (!hasSnapshotData) continue;
                                    snapshotProj += this.getSnapshotProjection(snapshotRules, m2l.getKey(), curriculumClassification.getAcademicClassification().getCode()) * (float)m2l.getValue().intValue();
                                }
                            }
                        }
                        cfi.setLastLike(lastLike == 0 ? null : Integer.valueOf(lastLike));
                        cfi.setProjection(Math.round(proj) == 0 ? null : Integer.valueOf(Math.round(proj)));
                        cfi.setExpected(curriculumClassification.getNrStudents());
                        cfi.setSessionHasSnapshotData(hasSnapshotData);
                        if (hasSnapshotData) {
                            cfi.setSnapshotProjection(Math.round(snapshotProj) == 0 ? null : Integer.valueOf(Math.round(snapshotProj)));
                            cfi.setSnapshotExpected(curriculumClassification.getSnapshotNrStudents());
                        }
                        cfi.setEnrollment(clasf2enrl.get(curriculumClassification.getAcademicClassification().getUniqueId()));
                        cfi.setRequested(clasf2req.get(curriculumClassification.getAcademicClassification().getUniqueId()));
                        aci = new CurriculumInterface.AcademicClassificationInterface();
                        aci.setId(curriculumClassification.getAcademicClassification().getUniqueId());
                        aci.setName(curriculumClassification.getAcademicClassification().getName());
                        aci.setCode(curriculumClassification.getAcademicClassification().getCode());
                        cfi.setAcademicClassification(aci);
                        results.add(cfi);
                        academicClassifications.remove(aci);
                    }
                    if (academicClassifications.isEmpty()) continue;
                    for (CurriculumInterface.AcademicClassificationInterface academicClassificationInterface : academicClassifications) {
                        cfi = new CurriculumInterface.CurriculumClassificationInterface();
                        cfi.setName(academicClassificationInterface.getCode());
                        cfi.setCurriculumId(c.getUniqueId());
                        lastLike = 0;
                        proj = 0.0f;
                        snapshotProj = 0.0f;
                        major2ll = clasfMajor2ll.get(academicClassificationInterface.getCode());
                        if (major2ll != null) {
                            if (c.isMultipleMajors().booleanValue() && major2ll.size() > 1) {
                                double rule = 1.0;
                                snapshotRule = 1.0;
                                for (PosMajor m : c.getMajors()) {
                                    rule *= (double)this.getProjection(rules, m.getCode(), academicClassificationInterface.getCode());
                                    if (!hasSnapshotData) continue;
                                    snapshotRule *= (double)this.getSnapshotProjection(snapshotRules, m.getCode(), academicClassificationInterface.getCode());
                                }
                                for (Integer ll : major2ll.values()) {
                                    lastLike += ll.intValue();
                                }
                                proj = (float)(Math.pow(rule, 1.0 / (double)c.getMajors().size()) * (double)lastLike);
                                if (hasSnapshotData) {
                                    snapshotProj = (float)(Math.pow(snapshotRule, 1.0 / (double)c.getMajors().size()) * (double)lastLike);
                                }
                            }
                            for (Map.Entry<String, Integer> m2l : major2ll.entrySet()) {
                                lastLike += m2l.getValue().intValue();
                                proj += this.getProjection(rules, m2l.getKey(), academicClassificationInterface.getCode()) * (float)m2l.getValue().intValue();
                                if (!hasSnapshotData) continue;
                                snapshotProj += this.getSnapshotProjection(snapshotRules, m2l.getKey(), academicClassificationInterface.getCode()) * (float)m2l.getValue().intValue();
                            }
                        }
                        cfi.setLastLike(lastLike == 0 ? null : Integer.valueOf(lastLike));
                        cfi.setProjection(Math.round(proj) == 0 ? null : Integer.valueOf(Math.round(proj)));
                        cfi.setEnrollment(clasf2enrl.get(academicClassificationInterface.getId()));
                        cfi.setRequested(clasf2req.get(academicClassificationInterface.getId()));
                        cfi.setSessionHasSnapshotData(hasSnapshotData);
                        if (hasSnapshotData) {
                            cfi.setSnapshotProjection(Math.round(snapshotProj) == 0 ? null : Integer.valueOf(Math.round(snapshotProj)));
                        } else {
                            cfi.setSnapshotProjection(null);
                        }
                        aci = new CurriculumInterface.AcademicClassificationInterface();
                        aci.setId(academicClassificationInterface.getId());
                        aci.setName(academicClassificationInterface.getName());
                        aci.setCode(academicClassificationInterface.getCode());
                        cfi.setAcademicClassification(aci);
                        results.add(cfi);
                    }
                }
                Object var30_35 = null;
            }
            catch (Throwable throwable) {
                Object var30_36 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Loaded " + results.size() + " classifications (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="checkPermission(#curriculumId, 'Curriculum', 'CurriculumDetail')")
    public CurriculumInterface loadCurriculum(Long curriculumId) throws CurriculaException, PageAccessException {
        ChangeLog changeLog;
        CurriculumInterface curriculumIfc;
        Curriculum c;
        Session hibSession;
        Long s0;
        block55: {
            CurriculumInterface.CurriculumCourseInterface curCourseIfc;
            Hashtable<Long, CurriculumInterface.CurriculumCourseGroupInterface> groups;
            Hashtable<String, HashMap<String, Float>> snapshotRules;
            Hashtable<String, HashMap<String, Float>> rules;
            boolean hasSnapshotData;
            int idx;
            Hashtable<Long, Integer> classifications;
            try {
                sLog.debug((Object)("loadCurriculum(curriculumId=" + curriculumId + ")"));
                s0 = System.currentTimeMillis();
                TreeSet<CurriculumInterface.AcademicClassificationInterface> academicClassifications = this.loadAcademicClassifications();
                classifications = new Hashtable<Long, Integer>();
                idx = 0;
                for (CurriculumInterface.AcademicClassificationInterface clasf : academicClassifications) {
                    classifications.put(clasf.getId(), idx++);
                }
                hibSession = CurriculumDAO.getInstance().getSession();
                hasSnapshotData = this.hasSnapshotData(hibSession, this.getAcademicSessionId());
                try {
                    c = (Curriculum)CurriculumDAO.getInstance().get(curriculumId, hibSession);
                    if (c == null) {
                        String string;
                        if (curriculumId == null) {
                            string = "null";
                            throw new CurriculaException(MESSAGES.errorCurriculumDoesNotExist(string));
                        }
                        string = curriculumId.toString();
                        throw new CurriculaException(MESSAGES.errorCurriculumDoesNotExist(string));
                    }
                    rules = this.getRules(hibSession, c.getAcademicArea().getUniqueId());
                    snapshotRules = null;
                    if (hasSnapshotData) {
                        snapshotRules = this.getSnapshotRules(hibSession, c.getAcademicArea().getUniqueId());
                    }
                    curriculumIfc = new CurriculumInterface();
                    curriculumIfc.setId(c.getUniqueId());
                    curriculumIfc.setAbbv(c.getAbbv());
                    curriculumIfc.setName(c.getName());
                    curriculumIfc.setEditable(this.getSessionContext().hasPermission(c, Right.CurriculumEdit));
                    curriculumIfc.setMultipleMajors(c.isMultipleMajors());
                    curriculumIfc.setSessionHasSnapshotData(hasSnapshotData);
                    CurriculumInterface.DepartmentInterface deptIfc = new CurriculumInterface.DepartmentInterface();
                    deptIfc.setId(c.getDepartment().getUniqueId());
                    deptIfc.setAbbv(c.getDepartment().getAbbreviation());
                    deptIfc.setCode(c.getDepartment().getDeptCode());
                    deptIfc.setName(c.getDepartment().getName());
                    curriculumIfc.setDepartment(deptIfc);
                    CurriculumInterface.AcademicAreaInterface areaIfc = new CurriculumInterface.AcademicAreaInterface();
                    areaIfc.setId(c.getAcademicArea().getUniqueId());
                    areaIfc.setAbbv(c.getAcademicArea().getAcademicAreaAbbreviation());
                    areaIfc.setName(Constants.curriculaToInitialCase(c.getAcademicArea().getTitle()));
                    curriculumIfc.setAcademicArea(areaIfc);
                    for (PosMajor major : c.getMajors()) {
                        CurriculumInterface.MajorInterface majorIfc = new CurriculumInterface.MajorInterface();
                        majorIfc.setId(major.getUniqueId());
                        majorIfc.setCode(major.getCode());
                        majorIfc.setName(Constants.curriculaToInitialCase(major.getName()));
                        curriculumIfc.addMajor(majorIfc);
                    }
                    Hashtable<Long, Integer> clasf2enrl = this.loadClasf2enrl(hibSession, c);
                    Hashtable<Long, Integer> clasf2req = this.loadClasf2req(hibSession, c);
                    Hashtable<String, Hashtable<String, Integer>> clasfMajor2ll = this.loadClasfMajor2ll(hibSession, c);
                    for (CurriculumInterface.AcademicClassificationInterface academicClassificationInterface : academicClassifications) {
                        CurriculumInterface.CurriculumClassificationInterface clasfIfc = new CurriculumInterface.CurriculumClassificationInterface();
                        clasfIfc.setName(academicClassificationInterface.getCode());
                        clasfIfc.setCurriculumId(c.getUniqueId());
                        int lastLike = 0;
                        float proj = 0.0f;
                        float snapshotProj = 0.0f;
                        Hashtable<String, Integer> major2ll = clasfMajor2ll.get(academicClassificationInterface.getCode());
                        if (major2ll != null) {
                            if (c.isMultipleMajors().booleanValue() && c.getMajors().size() > 1) {
                                double rule = 1.0;
                                double snapshotRule = 1.0;
                                for (PosMajor posMajor : c.getMajors()) {
                                    rule *= (double)this.getProjection(rules, posMajor.getCode(), academicClassificationInterface.getCode());
                                    if (!hasSnapshotData) continue;
                                    snapshotRule *= (double)this.getSnapshotProjection(snapshotRules, posMajor.getCode(), academicClassificationInterface.getCode());
                                }
                                for (Integer n : major2ll.values()) {
                                    lastLike += n.intValue();
                                }
                                proj = (float)(Math.pow(rule, 1.0 / (double)c.getMajors().size()) * (double)lastLike);
                                if (hasSnapshotData) {
                                    snapshotProj = (float)(Math.pow(snapshotRule, 1.0 / (double)c.getMajors().size()) * (double)lastLike);
                                }
                            } else {
                                for (Map.Entry<String, Integer> entry : major2ll.entrySet()) {
                                    lastLike += entry.getValue().intValue();
                                    proj += this.getProjection(rules, entry.getKey(), academicClassificationInterface.getCode()) * (float)entry.getValue().intValue();
                                    if (!hasSnapshotData) continue;
                                    snapshotProj += this.getSnapshotProjection(snapshotRules, entry.getKey(), academicClassificationInterface.getCode()) * (float)entry.getValue().intValue();
                                }
                            }
                        }
                        clasfIfc.setLastLike(lastLike == 0 ? null : Integer.valueOf(lastLike));
                        clasfIfc.setProjection(Math.round(proj) == 0 ? null : Integer.valueOf(Math.round(proj)));
                        clasfIfc.setSessionHasSnapshotData(hasSnapshotData);
                        if (hasSnapshotData) {
                            clasfIfc.setSnapshotProjection(Math.round(snapshotProj) == 0 ? null : Integer.valueOf(Math.round(snapshotProj)));
                        } else {
                            clasfIfc.setSnapshotProjection(null);
                        }
                        clasfIfc.setEnrollment(clasf2enrl.get(academicClassificationInterface.getId()));
                        clasfIfc.setRequested(clasf2req.get(academicClassificationInterface.getId()));
                        CurriculumInterface.AcademicClassificationInterface acadClasfIfc = new CurriculumInterface.AcademicClassificationInterface();
                        acadClasfIfc.setId(academicClassificationInterface.getId());
                        acadClasfIfc.setName(academicClassificationInterface.getName());
                        acadClasfIfc.setCode(academicClassificationInterface.getCode());
                        clasfIfc.setAcademicClassification(acadClasfIfc);
                        curriculumIfc.addClassification(clasfIfc);
                    }
                    groups = new Hashtable<Long, CurriculumInterface.CurriculumCourseGroupInterface>();
                    if (c.isMultipleMajors().booleanValue() && !c.getMajors().isEmpty()) {
                        for (Curriculum x : hibSession.createQuery("select distinct x from Curriculum x, Curriculum c inner join c.majors m where c.uniqueId = :curriculumId and x.uniqueId != c.uniqueId and c.academicArea = x.academicArea and (x.majors is empty or m in elements(x.majors))").setLong("curriculumId", c.getUniqueId().longValue()).setCacheable(true).list()) {
                            if (x.getMajors().size() > 1) continue;
                            String template = x.getAcademicArea().getAcademicAreaAbbreviation();
                            String groupPrefix = x.getAcademicArea().getAcademicAreaAbbreviation() + " ";
                            for (PosMajor major : x.getMajors()) {
                                groupPrefix = major.getCode() + " ";
                                template = major.getCode();
                            }
                            for (CurriculumClassification clasf : x.getClassifications()) {
                                CurriculumInterface.CurriculumClassificationInterface clasfIfc = curriculumIfc.getClassification(clasf.getAcademicClassification().getUniqueId());
                                clasfIfc.setExpected(0);
                                if (hasSnapshotData) {
                                    clasfIfc.setSnapshotExpected(0);
                                } else {
                                    clasfIfc.setSnapshotExpected(null);
                                }
                                idx = (Integer)classifications.get(clasf.getAcademicClassification().getUniqueId());
                                for (CurriculumCourse course : clasf.getCourses()) {
                                    CurriculumInterface.CourseInterface courseIfc = curriculumIfc.getCourse(course.getCourse().getUniqueId());
                                    if (courseIfc == null) {
                                        courseIfc = new CurriculumInterface.CourseInterface();
                                        courseIfc.setId(course.getCourse().getUniqueId());
                                        courseIfc.setCourseName(course.getCourse().getCourseName());
                                        curriculumIfc.addCourse(courseIfc);
                                    }
                                    if ((curCourseIfc = courseIfc.getCurriculumCourse(idx)) == null) {
                                        curCourseIfc = new CurriculumInterface.CurriculumCourseInterface();
                                        curCourseIfc.setCourseOfferingId(course.getCourse().getUniqueId());
                                        curCourseIfc.setCourseName(course.getCourse().getCourseName());
                                        curCourseIfc.setDefaultShare(course.getPercShare());
                                        curCourseIfc.setSessionHasSnapshotData(hasSnapshotData);
                                        if (hasSnapshotData) {
                                            curCourseIfc.setDefaultSnapshotShare(course.getSnapshotPercShare());
                                        }
                                        courseIfc.setCurriculumCourse(idx, curCourseIfc);
                                        curCourseIfc.addTemplate(template);
                                    } else {
                                        if (course.getPercShare().floatValue() >= curCourseIfc.getDefaultShare().floatValue()) {
                                            curCourseIfc.setDefaultShare(course.getPercShare());
                                            curCourseIfc.addTemplate(template);
                                        }
                                        if (hasSnapshotData && course.getSnapshotPercShare().floatValue() >= curCourseIfc.getDefaultSnapshotShare().floatValue()) {
                                            curCourseIfc.setDefaultSnapshotShare(course.getSnapshotPercShare());
                                            curCourseIfc.addTemplate(template);
                                        }
                                    }
                                    for (CurriculumCourseGroup group : course.getGroups()) {
                                        CurriculumInterface.CurriculumCourseGroupInterface g = (CurriculumInterface.CurriculumCourseGroupInterface)groups.get(group.getUniqueId());
                                        if (g == null) {
                                            g = new CurriculumInterface.CurriculumCourseGroupInterface();
                                            g.setName(groupPrefix + group.getName());
                                            g.setType(group.getType());
                                            g.setEditable(false);
                                            g.setColor(group.getColor());
                                            groups.put(group.getUniqueId(), g);
                                        }
                                        courseIfc.addGroup(g);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var39_85 = null;
                    hibSession.close();
                    throw throwable;
                }
            }
            catch (PageAccessException e) {
                throw e;
            }
            catch (CurriculaException e) {
                throw e;
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
                throw new CurriculaException(e.getMessage());
            }
            for (CurriculumClassification clasf : c.getClassifications()) {
                CurriculumInterface.CurriculumClassificationInterface clasfIfc = curriculumIfc.getClassification(clasf.getAcademicClassification().getUniqueId());
                clasfIfc.setId(clasf.getUniqueId());
                clasfIfc.setExpected(clasf.getNrStudents());
                if (hasSnapshotData) {
                    clasfIfc.setSnapshotExpected(clasf.getSnapshotNrStudents());
                } else {
                    clasfIfc.setSnapshotExpected(null);
                }
                idx = (Integer)classifications.get(clasf.getAcademicClassification().getUniqueId());
                for (CurriculumCourse course : clasf.getCourses()) {
                    CurriculumInterface.CurriculumCourseInterface curCourseIfc2;
                    CurriculumInterface.CourseInterface courseIfc = curriculumIfc.getCourse(course.getCourse().getUniqueId());
                    if (courseIfc == null) {
                        courseIfc = new CurriculumInterface.CourseInterface();
                        courseIfc.setId(course.getCourse().getUniqueId());
                        courseIfc.setCourseName(course.getCourse().getCourseName());
                        curriculumIfc.addCourse(courseIfc);
                    }
                    if ((curCourseIfc2 = courseIfc.getCurriculumCourse(idx)) == null) {
                        curCourseIfc2 = new CurriculumInterface.CurriculumCourseInterface();
                        curCourseIfc2.setCourseOfferingId(course.getCourse().getUniqueId());
                        curCourseIfc2.setShare(course.getPercShare());
                        if (hasSnapshotData) {
                            curCourseIfc2.setSnapshotShare(course.getSnapshotPercShare());
                        }
                        curCourseIfc2.setCourseName(course.getCourse().getCourseName());
                        courseIfc.setCurriculumCourse(idx, curCourseIfc2);
                    }
                    curCourseIfc2.setId(course.getUniqueId());
                    curCourseIfc2.setCurriculumClassificationId(clasf.getUniqueId());
                    curCourseIfc2.setShare(course.getPercShare());
                    if (hasSnapshotData) {
                        curCourseIfc2.setSnapshotShare(course.getSnapshotPercShare());
                    }
                    for (CurriculumCourseGroup group : course.getGroups()) {
                        CurriculumInterface.CurriculumCourseGroupInterface g = (CurriculumInterface.CurriculumCourseGroupInterface)groups.get(group.getUniqueId());
                        if (g == null) {
                            g = new CurriculumInterface.CurriculumCourseGroupInterface();
                            g.setName(group.getName());
                            g.setType(group.getType());
                            g.setEditable(true);
                            g.setColor(group.getColor());
                            g.setId(group.getUniqueId());
                            groups.put(group.getUniqueId(), g);
                        }
                        courseIfc.addGroup(g);
                    }
                }
            }
            if (!curriculumIfc.hasClassifications() || !curriculumIfc.hasCourses()) break block55;
            Hashtable<Long, Hashtable<Long, Integer>> hashtable = this.loadClasfCourse2enrl(hibSession, c);
            Hashtable<Long, Hashtable<Long, Integer>> clasf2course2req = this.loadClasfCourse2req(hibSession, c);
            Hashtable<String, Hashtable<String, Hashtable<Long, Integer>>> clasfMajor2course2ll = this.loadClasfMajorCourse2ll(hibSession, c);
            for (CurriculumInterface.CurriculumClassificationInterface clasfIfc : curriculumIfc.getClassifications()) {
                idx = (Integer)classifications.get(clasfIfc.getAcademicClassification().getId());
                Hashtable<Long, Integer> course2enrl = hashtable.get(clasfIfc.getAcademicClassification().getId());
                Hashtable<Long, Integer> course2req = clasf2course2req.get(clasfIfc.getAcademicClassification().getId());
                Hashtable<String, Hashtable<Long, Integer>> hashtable2 = clasfMajor2course2ll.get(clasfIfc.getAcademicClassification().getId());
                for (CurriculumInterface.CourseInterface courseIfc : curriculumIfc.getCourses()) {
                    float courseSnapshotProj;
                    float courseProj;
                    int n;
                    block57: {
                        block56: {
                            curCourseIfc = courseIfc.getCurriculumCourse(idx);
                            if (curCourseIfc == null) continue;
                            curCourseIfc.setEnrollment(course2enrl == null ? null : course2enrl.get(courseIfc.getId()));
                            curCourseIfc.setRequested(course2req == null ? null : course2req.get(courseIfc.getId()));
                            n = 0;
                            courseProj = 0.0f;
                            courseSnapshotProj = 0.0f;
                            if (!c.isMultipleMajors().booleanValue() || c.getMajors().size() <= 2) break block56;
                            if (hashtable2 == null) break block57;
                            for (Hashtable<Long, Integer> hashtable3 : hashtable2.values()) {
                                Integer ll = hashtable3.get(courseIfc.getId());
                                if (ll == null) continue;
                                n += ll.intValue();
                            }
                            double rule = 1.0;
                            double snapshotRule = 1.0;
                            for (PosMajor m : c.getMajors()) {
                                rule *= (double)this.getProjection(rules, m.getCode(), clasfIfc.getAcademicClassification().getCode());
                                if (!hasSnapshotData) continue;
                                snapshotRule *= (double)this.getSnapshotProjection(snapshotRules, m.getCode(), clasfIfc.getAcademicClassification().getCode());
                            }
                            courseProj = (float)(Math.pow(rule, 1.0 / (double)c.getMajors().size()) * (double)n);
                            if (!hasSnapshotData) break block57;
                            courseSnapshotProj = (float)(Math.pow(snapshotRule, 1.0 / (double)c.getMajors().size()) * (double)n);
                            break block57;
                        }
                        if (hashtable2 != null) {
                            for (Map.Entry<String, Hashtable<Long, Integer>> entry : hashtable2.entrySet()) {
                                Integer ll = entry.getValue().get(courseIfc.getId());
                                if (ll == null) continue;
                                n += ll.intValue();
                                courseProj += this.getProjection(rules, entry.getKey(), clasfIfc.getAcademicClassification().getCode());
                                if (!hasSnapshotData) continue;
                                courseSnapshotProj += this.getSnapshotProjection(snapshotRules, entry.getKey(), clasfIfc.getAcademicClassification().getCode());
                            }
                        }
                    }
                    curCourseIfc.setLastLike(n == 0 ? null : Integer.valueOf(n));
                    curCourseIfc.setProjection(Math.round(courseProj) == 0 ? null : Integer.valueOf(Math.round(courseProj)));
                    curCourseIfc.setSessionHasSnapshotData(hasSnapshotData);
                    if (hasSnapshotData) {
                        curCourseIfc.setSnapshotProjection(Math.round(courseSnapshotProj) == 0 ? null : Integer.valueOf(Math.round(courseSnapshotProj)));
                        continue;
                    }
                    curCourseIfc.setSnapshotProjection(null);
                }
            }
        }
        if ((changeLog = ChangeLog.findLastChange(c)) != null) {
            curriculumIfc.setLastChange(changeLog.getShortLabel());
        }
        sLog.debug((Object)("Loaded 1 curriculum (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
        CurriculumInterface curriculumInterface = curriculumIfc;
        Object var39_84 = null;
        hibSession.close();
        return curriculumInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public CurriculumInterface loadTemplate(Long acadAreaId, List<Long> majors) throws CurriculaException, PageAccessException {
        try {
            CurriculumInterface curriculumInterface;
            sLog.debug((Object)("loadTemplate(acadAreaId=" + acadAreaId + ", majors= " + majors + ")"));
            Long s0 = System.currentTimeMillis();
            TreeSet<CurriculumInterface.AcademicClassificationInterface> academicClassifications = this.loadAcademicClassifications();
            Hashtable<Long, Integer> classifications = new Hashtable<Long, Integer>();
            int idx = 0;
            for (CurriculumInterface.AcademicClassificationInterface clasf : academicClassifications) {
                classifications.put(clasf.getId(), idx++);
            }
            Session hibSession = CurriculumDAO.getInstance().getSession();
            boolean hasSnapshotData = this.hasSnapshotData(hibSession, this.getAcademicSessionId());
            try {
                AcademicArea acadArea = (AcademicArea)AcademicAreaDAO.getInstance().get(acadAreaId, hibSession);
                ArrayList posMajors = new ArrayList();
                for (Long majorId : majors) {
                    posMajors.add(PosMajorDAO.getInstance().get(majorId, hibSession));
                }
                CurriculumInterface curriculumIfc = new CurriculumInterface();
                CurriculumInterface.AcademicAreaInterface areaIfc = new CurriculumInterface.AcademicAreaInterface();
                areaIfc.setId(acadArea.getUniqueId());
                areaIfc.setAbbv(acadArea.getAcademicAreaAbbreviation());
                areaIfc.setName(Constants.curriculaToInitialCase(acadArea.getTitle()));
                curriculumIfc.setAcademicArea(areaIfc);
                curriculumIfc.setEditable(true);
                for (Long majorId : majors) {
                    PosMajor major = (PosMajor)PosMajorDAO.getInstance().get(majorId, hibSession);
                    CurriculumInterface.MajorInterface majorIfc = new CurriculumInterface.MajorInterface();
                    majorIfc.setId(major.getUniqueId());
                    majorIfc.setCode(major.getCode());
                    majorIfc.setName(Constants.curriculaToInitialCase(major.getName()));
                    curriculumIfc.addMajor(majorIfc);
                }
                for (CurriculumInterface.AcademicClassificationInterface clasf : academicClassifications) {
                    CurriculumInterface.CurriculumClassificationInterface clasfIfc = new CurriculumInterface.CurriculumClassificationInterface();
                    clasfIfc.setName(clasf.getCode());
                    clasfIfc.setSessionHasSnapshotData(hasSnapshotData);
                    CurriculumInterface.AcademicClassificationInterface acadClasfIfc = new CurriculumInterface.AcademicClassificationInterface();
                    acadClasfIfc.setId(clasf.getId());
                    acadClasfIfc.setName(clasf.getName());
                    acadClasfIfc.setCode(clasf.getCode());
                    clasfIfc.setAcademicClassification(acadClasfIfc);
                    curriculumIfc.addClassification(clasfIfc);
                }
                Hashtable<Long, CurriculumInterface.CurriculumCourseGroupInterface> groups = new Hashtable<Long, CurriculumInterface.CurriculumCourseGroupInterface>();
                ArrayList curricula = new ArrayList();
                curricula.addAll(hibSession.createQuery("select distinct x from Curriculum x where x.academicArea.uniqueId = :acadAreaId and x.majors is empty").setLong("acadAreaId", acadAreaId.longValue()).setCacheable(true).list());
                if (!majors.isEmpty()) {
                    curricula.addAll(hibSession.createQuery("select distinct x from Curriculum x inner join x.majors m where x.academicArea.uniqueId = :acadAreaId and m.uniqueId in :majorIds").setLong("acadAreaId", acadAreaId.longValue()).setParameterList("majorIds", majors).setCacheable(true).list());
                }
                for (Curriculum x : curricula) {
                    if (x.getMajors().size() > 1) continue;
                    String template = x.getAcademicArea().getAcademicAreaAbbreviation();
                    String groupPrefix = x.getAcademicArea().getAcademicAreaAbbreviation() + " ";
                    for (PosMajor major : x.getMajors()) {
                        groupPrefix = major.getCode() + " ";
                        template = major.getCode();
                    }
                    for (CurriculumClassification clasf : x.getClassifications()) {
                        CurriculumInterface.CurriculumClassificationInterface clasfIfc = curriculumIfc.getClassification(clasf.getAcademicClassification().getUniqueId());
                        clasfIfc.setExpected(0);
                        if (hasSnapshotData) {
                            clasfIfc.setSnapshotExpected(0);
                        } else {
                            clasfIfc.setSnapshotExpected(null);
                        }
                        idx = (Integer)classifications.get(clasf.getAcademicClassification().getUniqueId());
                        for (CurriculumCourse course : clasf.getCourses()) {
                            CurriculumInterface.CurriculumCourseInterface curCourseIfc;
                            CurriculumInterface.CourseInterface courseIfc = curriculumIfc.getCourse(course.getCourse().getUniqueId());
                            if (courseIfc == null) {
                                courseIfc = new CurriculumInterface.CourseInterface();
                                courseIfc.setId(course.getCourse().getUniqueId());
                                courseIfc.setCourseName(course.getCourse().getCourseName());
                                curriculumIfc.addCourse(courseIfc);
                            }
                            if ((curCourseIfc = courseIfc.getCurriculumCourse(idx)) == null) {
                                curCourseIfc = new CurriculumInterface.CurriculumCourseInterface();
                                curCourseIfc.setCourseOfferingId(course.getCourse().getUniqueId());
                                curCourseIfc.setCourseName(course.getCourse().getCourseName());
                                curCourseIfc.setDefaultShare(course.getPercShare());
                                curCourseIfc.setSessionHasSnapshotData(hasSnapshotData);
                                if (hasSnapshotData) {
                                    curCourseIfc.setDefaultSnapshotShare(course.getSnapshotPercShare());
                                }
                                courseIfc.setCurriculumCourse(idx, curCourseIfc);
                                curCourseIfc.addTemplate(template);
                            } else {
                                if (course.getPercShare().floatValue() >= curCourseIfc.getDefaultShare().floatValue()) {
                                    curCourseIfc.setDefaultShare(course.getPercShare());
                                    curCourseIfc.addTemplate(template);
                                }
                                if (hasSnapshotData && course.getSnapshotPercShare().floatValue() >= curCourseIfc.getDefaultSnapshotShare().floatValue()) {
                                    curCourseIfc.setDefaultSnapshotShare(course.getSnapshotPercShare());
                                    curCourseIfc.addTemplate(template);
                                }
                            }
                            for (CurriculumCourseGroup group : course.getGroups()) {
                                CurriculumInterface.CurriculumCourseGroupInterface g = (CurriculumInterface.CurriculumCourseGroupInterface)groups.get(group.getUniqueId());
                                if (g == null) {
                                    g = new CurriculumInterface.CurriculumCourseGroupInterface();
                                    g.setName(groupPrefix + group.getName());
                                    g.setType(group.getType());
                                    g.setColor(group.getColor());
                                    g.setEditable(false);
                                    groups.put(group.getUniqueId(), g);
                                }
                                courseIfc.addGroup(g);
                            }
                        }
                    }
                }
                sLog.debug((Object)("Computed 1 template (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
                curriculumInterface = curriculumIfc;
                Object var30_33 = null;
            }
            catch (Throwable throwable) {
                Object var30_34 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return curriculumInterface;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="(#curriculum.id != null and checkPermission(#curriculum.id, 'Curriculum', 'CurriculumEdit')) or (#curriculum.id == null and checkPermission(#curriculum.department.id, 'Department', 'CurriculumAdd'))")
    public Long saveCurriculum(CurriculumInterface curriculum) throws CurriculaException, PageAccessException {
        try {
            Long l;
            sLog.debug((Object)("saveCurriculum(curriculum=" + curriculum.getId() + ")"));
            Long s0 = System.currentTimeMillis();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            Transaction tx = null;
            try {
                Long ret;
                CurriculumClassification cl;
                tx = hibSession.beginTransaction();
                Hashtable<String, CourseOffering> courses = new Hashtable<String, CourseOffering>();
                if (curriculum.hasCourses()) {
                    for (CurriculumInterface.CourseInterface courseInterface : curriculum.getCourses()) {
                        CourseOffering courseOffering = this.getCourse(hibSession, courseInterface.getCourseName());
                        if (courseOffering == null) {
                            throw new CurriculaException(MESSAGES.errorCourseDoesNotExist(courseInterface.getCourseName()));
                        }
                        courses.put(courseInterface.getCourseName(), courseOffering);
                    }
                }
                Curriculum c = null;
                if (curriculum.getId() != null) {
                    c = (Curriculum)CurriculumDAO.getInstance().get(curriculum.getId(), hibSession);
                    if (c == null) {
                        throw new CurriculaException(MESSAGES.errorCurriculumDoesNotExist(curriculum.getId().toString()));
                    }
                } else {
                    c = new Curriculum();
                }
                c.setAbbv(curriculum.getAbbv());
                c.setName(curriculum.getName());
                c.setMultipleMajors(curriculum.isMultipleMajors());
                c.setAcademicArea((AcademicArea)AcademicAreaDAO.getInstance().get(curriculum.getAcademicArea().getId(), hibSession));
                c.setDepartment((Department)DepartmentDAO.getInstance().get(curriculum.getDepartment().getId(), hibSession));
                if (c.getMajors() == null) {
                    c.setMajors(new HashSet<PosMajor>());
                    if (curriculum.hasMajors()) {
                        for (CurriculumInterface.MajorInterface majorInterface : curriculum.getMajors()) {
                            c.getMajors().add((PosMajor)PosMajorDAO.getInstance().get(majorInterface.getId(), hibSession));
                        }
                    }
                } else {
                    HashSet<PosMajor> hashSet = new HashSet<PosMajor>(c.getMajors());
                    if (curriculum.hasMajors()) {
                        block11: for (CurriculumInterface.MajorInterface m : curriculum.getMajors()) {
                            for (PosMajor major : c.getMajors()) {
                                if (!major.getUniqueId().equals(m.getId())) continue;
                                hashSet.remove(major);
                                continue block11;
                            }
                            c.getMajors().add((PosMajor)PosMajorDAO.getInstance().get(m.getId(), hibSession));
                        }
                    }
                    if (!hashSet.isEmpty()) {
                        c.getMajors().removeAll(hashSet);
                    }
                }
                hibSession.saveOrUpdate((Object)c);
                Hashtable<Long, CurriculumClassification> hashtable = new Hashtable<Long, CurriculumClassification>();
                Hashtable<String, CurriculumCourseGroup> hashtable2 = new Hashtable<String, CurriculumCourseGroup>();
                HashSet<CurriculumCourse> remaining = new HashSet<CurriculumCourse>();
                HashSet<CurriculumCourseGroup> remainingGroups = new HashSet<CurriculumCourseGroup>();
                int ord = 0;
                if (c.getClassifications() == null) {
                    c.setClassifications(new HashSet<CurriculumClassification>());
                    for (CurriculumInterface.CurriculumClassificationInterface curriculumClassificationInterface : curriculum.getClassifications()) {
                        cl = new CurriculumClassification();
                        cl.setAcademicClassification((AcademicClassification)AcademicClassificationDAO.getInstance().get(curriculumClassificationInterface.getAcademicClassification().getId()));
                        cl.setName(curriculumClassificationInterface.getName().isEmpty() ? curriculumClassificationInterface.getAcademicClassification().getCode() : curriculumClassificationInterface.getName());
                        cl.setNrStudents(curriculumClassificationInterface.getExpected());
                        cl.setCurriculum(c);
                        cl.setOrd(ord++);
                        c.getClassifications().add(cl);
                        hashtable.put(cl.getAcademicClassification().getUniqueId(), cl);
                        hibSession.saveOrUpdate((Object)cl);
                    }
                } else {
                    Iterator remove = new HashSet<CurriculumClassification>(c.getClassifications());
                    block14: for (CurriculumInterface.CurriculumClassificationInterface clasf : curriculum.getClassifications()) {
                        for (CurriculumClassification curriculumClassification : c.getClassifications()) {
                            if (!curriculumClassification.getAcademicClassification().getUniqueId().equals(clasf.getAcademicClassification().getId())) continue;
                            curriculumClassification.setName(clasf.getName().isEmpty() ? clasf.getAcademicClassification().getCode() : clasf.getName());
                            curriculumClassification.setNrStudents(clasf.getExpected());
                            ((HashSet)((Object)remove)).remove(curriculumClassification);
                            hashtable.put(curriculumClassification.getAcademicClassification().getUniqueId(), curriculumClassification);
                            for (CurriculumCourse cc : curriculumClassification.getCourses()) {
                                for (CurriculumCourseGroup g : cc.getGroups()) {
                                    hashtable2.put(g.getName(), g);
                                    remainingGroups.add(g);
                                }
                                remaining.add(cc);
                            }
                            hibSession.saveOrUpdate((Object)curriculumClassification);
                            continue block14;
                        }
                        CurriculumClassification cl2 = new CurriculumClassification();
                        cl2.setAcademicClassification((AcademicClassification)AcademicClassificationDAO.getInstance().get(clasf.getAcademicClassification().getId()));
                        cl2.setName(clasf.getName().isEmpty() ? clasf.getAcademicClassification().getCode() : clasf.getName());
                        cl2.setNrStudents(clasf.getExpected());
                        cl2.setOrd(ord++);
                        cl2.setCurriculum(c);
                        c.getClassifications().add(cl2);
                        hashtable.put(cl2.getAcademicClassification().getUniqueId(), cl2);
                        hibSession.saveOrUpdate((Object)cl2);
                    }
                    if (!((HashSet)((Object)remove)).isEmpty()) {
                        Iterator<CurriculumClassification> iterator = ((HashSet)((Object)remove)).iterator();
                        while (iterator.hasNext()) {
                            cl = iterator.next();
                            for (CurriculumCourse curriculumCourse : cl.getCourses()) {
                                for (CurriculumCourseGroup g : curriculumCourse.getGroups()) {
                                    hashtable2.put(g.getName(), g);
                                    remainingGroups.add(g);
                                }
                                remaining.add(curriculumCourse);
                            }
                            c.getClassifications().remove(cl);
                            cl.setCurriculum(null);
                            hibSession.delete((Object)cl);
                        }
                    }
                }
                if (curriculum.hasCourses()) {
                    for (CurriculumInterface.CourseInterface courseInterface : curriculum.getCourses()) {
                        CourseOffering courseOffering = (CourseOffering)courses.get(courseInterface.getCourseName());
                        for (CurriculumInterface.CurriculumCourseInterface curriculumCourseInterface : courseInterface.getCurriculumCourses()) {
                            CurriculumClassification clasf;
                            if (curriculumCourseInterface == null || (clasf = (CurriculumClassification)hashtable.get(curriculumCourseInterface.getCurriculumClassificationId())) == null) continue;
                            CurriculumCourse cx = null;
                            if (clasf.getCourses() == null) {
                                clasf.setCourses(new HashSet<CurriculumCourse>());
                            } else {
                                for (CurriculumCourse x : clasf.getCourses()) {
                                    if (!x.getCourse().equals(courseOffering)) continue;
                                    x.setPercShare(Float.valueOf(curriculumCourseInterface.getShare()));
                                    remaining.remove(x);
                                    cx = x;
                                    break;
                                }
                            }
                            if (cx == null) {
                                cx = new CurriculumCourse();
                                clasf.getCourses().add(cx);
                                cx.setClassification(clasf);
                                cx.setCourse(courseOffering);
                                cx.setPercShare(Float.valueOf(curriculumCourseInterface.getShare()));
                                cx.setOrd(ord++);
                            }
                            if (courseInterface.hasGroups()) {
                                if (cx.getGroups() == null) {
                                    cx.setGroups(new HashSet<CurriculumCourseGroup>());
                                }
                                HashSet<CurriculumCourseGroup> delete = new HashSet<CurriculumCourseGroup>(cx.getGroups());
                                for (CurriculumInterface.CurriculumCourseGroupInterface gr : courseInterface.getGroups()) {
                                    CurriculumCourseGroup g = (CurriculumCourseGroup)hashtable2.get(gr.getName());
                                    if (g == null) {
                                        g = new CurriculumCourseGroup();
                                        g.setName(gr.getName());
                                        g.setColor(gr.getColor());
                                        g.setType(gr.getType());
                                        g.setCurriculum(c);
                                        hashtable2.put(g.getName(), g);
                                        hibSession.saveOrUpdate((Object)g);
                                    } else {
                                        g.setName(gr.getName());
                                        g.setColor(gr.getColor());
                                        g.setType(gr.getType());
                                        hibSession.saveOrUpdate((Object)g);
                                        remainingGroups.remove(g);
                                    }
                                    if (delete.remove(g)) continue;
                                    cx.getGroups().add(g);
                                }
                                if (!delete.isEmpty()) {
                                    cx.getGroups().removeAll(delete);
                                }
                            } else if (cx.getGroups() != null && !cx.getGroups().isEmpty()) {
                                cx.getGroups().clear();
                            }
                            hibSession.saveOrUpdate((Object)cx);
                        }
                    }
                }
                if (!remaining.isEmpty()) {
                    for (CurriculumCourse curriculumCourse : remaining) {
                        curriculumCourse.getClassification().getCourses().remove(curriculumCourse);
                        curriculumCourse.setClassification(null);
                        curriculumCourse.getGroups().clear();
                        hibSession.delete((Object)curriculumCourse);
                    }
                }
                if (!remainingGroups.isEmpty()) {
                    for (CurriculumCourseGroup curriculumCourseGroup : remainingGroups) {
                        hibSession.delete((Object)curriculumCourseGroup);
                    }
                }
                if ((ret = c.getUniqueId()) == null) {
                    ret = (Long)hibSession.save((Object)c);
                } else {
                    hibSession.update((Object)c);
                }
                ChangeLog.addChange(hibSession, this.getSessionContext(), c, c.getAbbv(), ChangeLog.Source.CURRICULUM_EDIT, curriculum.getId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, c.getDepartment());
                hibSession.flush();
                tx.commit();
                tx = null;
                sLog.debug((Object)("Saved 1 curriculum (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
                l = ret;
                Object var24_51 = null;
            }
            catch (Throwable throwable) {
                Object var24_52 = null;
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                hibSession.close();
                throw throwable;
            }
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            hibSession.close();
            return l;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission(#curricula, 'Curriculum', 'CurriculumEdit')")
    public Boolean saveClassifications(List<CurriculumInterface> curricula) throws CurriculaException, PageAccessException {
        try {
            Session hibSession;
            Long s0;
            block15: {
                sLog.debug((Object)"saveClassifications()");
                s0 = System.currentTimeMillis();
                hibSession = CurriculumDAO.getInstance().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    int ord = 0;
                    for (CurriculumInterface curriculum : curricula) {
                        Curriculum c = (Curriculum)CurriculumDAO.getInstance().get(curriculum.getId(), hibSession);
                        if (c == null) continue;
                        HashSet<CurriculumClassification> remove = new HashSet<CurriculumClassification>(c.getClassifications());
                        block10: for (CurriculumInterface.CurriculumClassificationInterface clasf : curriculum.getClassifications()) {
                            if (clasf.getExpected() == null) continue;
                            for (CurriculumClassification cl : c.getClassifications()) {
                                if (!cl.getAcademicClassification().getUniqueId().equals(clasf.getAcademicClassification().getId())) continue;
                                cl.setNrStudents(clasf.getExpected());
                                remove.remove(cl);
                                hibSession.saveOrUpdate((Object)cl);
                                continue block10;
                            }
                            CurriculumClassification cl = new CurriculumClassification();
                            cl.setAcademicClassification((AcademicClassification)AcademicClassificationDAO.getInstance().get(clasf.getAcademicClassification().getId()));
                            cl.setName(clasf.getAcademicClassification().getCode());
                            cl.setNrStudents(clasf.getExpected());
                            cl.setOrd(ord++);
                            cl.setCurriculum(c);
                            c.getClassifications().add(cl);
                            hibSession.saveOrUpdate((Object)cl);
                        }
                        for (CurriculumClassification cl : remove) {
                            c.getClassifications().remove(cl);
                            cl.setCurriculum(null);
                            hibSession.delete((Object)cl);
                        }
                        ChangeLog.addChange(hibSession, this.getSessionContext(), c, c.getAbbv(), ChangeLog.Source.CUR_CLASF_EDIT, ChangeLog.Operation.UPDATE, null, c.getDepartment());
                        hibSession.saveOrUpdate((Object)c);
                    }
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Object var15_17 = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hibSession.close();
                    throw throwable;
                }
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    break block15;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                }
            }
            hibSession.close();
            sLog.debug((Object)("Saved classifications for " + curricula.size() + " curricula (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return null;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission(#curriculumId, 'Curriculum', 'CurriculumDelete')")
    public Boolean deleteCurriculum(Long curriculumId) throws CurriculaException, PageAccessException {
        try {
            Session hibSession;
            Long s0;
            block13: {
                sLog.debug((Object)("deleteCurriculum(curriculumId=" + curriculumId + ")"));
                s0 = System.currentTimeMillis();
                hibSession = CurriculumDAO.getInstance().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    if (curriculumId == null) {
                        throw new CurriculaException(MESSAGES.errorCannotDeleteUnsavedCurriculum());
                    }
                    Curriculum c = (Curriculum)CurriculumDAO.getInstance().get(curriculumId, hibSession);
                    if (c == null) {
                        throw new CurriculaException(MESSAGES.errorCurriculumDoesNotExist(curriculumId.toString()));
                    }
                    ChangeLog.addChange(hibSession, this.getSessionContext(), c, c.getAbbv(), ChangeLog.Source.CURRICULUM_EDIT, ChangeLog.Operation.DELETE, null, c.getDepartment());
                    hibSession.delete((Object)c);
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hibSession.close();
                    throw throwable;
                }
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    break block13;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                }
            }
            hibSession.close();
            sLog.debug((Object)("Deleted 1 curriculum (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return null;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission(#curriculumIds, 'Curriculum', 'CurriculumDelete')")
    public Boolean deleteCurricula(Set<Long> curriculumIds) throws CurriculaException, PageAccessException {
        try {
            Session hibSession;
            Long s0;
            block14: {
                sLog.debug((Object)("deleteCurricula(curriculumIds=" + curriculumIds + ")"));
                s0 = System.currentTimeMillis();
                hibSession = CurriculumDAO.getInstance().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    for (Long curriculumId : curriculumIds) {
                        if (curriculumId == null) {
                            throw new CurriculaException(MESSAGES.errorCannotDeleteUnsavedCurriculum());
                        }
                        Curriculum c = (Curriculum)CurriculumDAO.getInstance().get(curriculumId, hibSession);
                        if (c == null) {
                            throw new CurriculaException(MESSAGES.errorCurriculumDoesNotExist(curriculumId.toString()));
                        }
                        ChangeLog.addChange(hibSession, this.getSessionContext(), c, c.getAbbv(), ChangeLog.Source.CURRICULUM_EDIT, ChangeLog.Operation.DELETE, null, c.getDepartment());
                        hibSession.delete((Object)c);
                    }
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Object var9_11 = null;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hibSession.close();
                    throw throwable;
                }
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    break block14;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                }
            }
            hibSession.close();
            sLog.debug((Object)("Deleted " + curriculumIds.size() + " curricula (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return null;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission(#curriculumIds, 'Curriculum', 'CurriculumMerge')")
    public Boolean mergeCurricula(Set<Long> curriculumIds) throws CurriculaException, PageAccessException {
        try {
            Session hibSession;
            Long s0;
            block41: {
                sLog.debug((Object)("mergeCurricula(curriculumIds=" + curriculumIds + ")"));
                s0 = System.currentTimeMillis();
                hibSession = CurriculumDAO.getInstance().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    Curriculum mergedCurriculum = new Curriculum();
                    mergedCurriculum.setMajors(new HashSet<PosMajor>());
                    mergedCurriculum.setClassifications(new HashSet<CurriculumClassification>());
                    int clasfOrd = 0;
                    int courseOrd = 0;
                    int cidx = 0;
                    Hashtable<Long, CurriculumCourseGroup> groups = new Hashtable<Long, CurriculumCourseGroup>();
                    ArrayList<Curriculum> merged = new ArrayList<Curriculum>();
                    Boolean multipleMajors = null;
                    boolean hasSnapshotData = this.hasSnapshotData(hibSession, this.getAcademicSessionId());
                    for (Long curriculumId : curriculumIds) {
                        if (curriculumId == null) {
                            throw new CurriculaException(MESSAGES.errorCannotMergeUnsavedCurriculum());
                        }
                        Curriculum curriculum = (Curriculum)CurriculumDAO.getInstance().get(curriculumId, hibSession);
                        if (curriculum == null) {
                            throw new CurriculaException(MESSAGES.errorCurriculumDoesNotExist(curriculumId.toString()));
                        }
                        if (multipleMajors == null) {
                            multipleMajors = curriculum.isMultipleMajors();
                        }
                        ++cidx;
                        if (mergedCurriculum.getAcademicArea() == null) {
                            mergedCurriculum.setAcademicArea(curriculum.getAcademicArea());
                        } else if (!mergedCurriculum.getAcademicArea().equals(curriculum.getAcademicArea())) {
                            throw new CurriculaException(MESSAGES.errorCannotMergeDifferentAcademicAreas());
                        }
                        if (mergedCurriculum.getDepartment() == null) {
                            mergedCurriculum.setDepartment(curriculum.getDepartment());
                        } else if (!mergedCurriculum.getDepartment().equals(curriculum.getDepartment())) {
                            throw new CurriculaException(MESSAGES.errorCannotMergeDifferentDepartments());
                        }
                        mergedCurriculum.getMajors().addAll(curriculum.getMajors());
                        for (CurriculumClassification clasf : curriculum.getClassifications()) {
                            BaseCurriculumClassification mergedClasf = null;
                            for (CurriculumClassification x : mergedCurriculum.getClassifications()) {
                                if (!x.getAcademicClassification().equals(clasf.getAcademicClassification())) continue;
                                mergedClasf = x;
                                break;
                            }
                            if (mergedClasf == null) {
                                mergedClasf = new CurriculumClassification();
                                mergedClasf.setCurriculum(mergedCurriculum);
                                mergedClasf.setAcademicClassification(clasf.getAcademicClassification());
                                mergedClasf.setCourses(new HashSet<CurriculumCourse>());
                                mergedClasf.setName(clasf.getName());
                                mergedClasf.setOrd(clasfOrd++);
                                mergedClasf.setNrStudents(0);
                                mergedCurriculum.getClassifications().add((CurriculumClassification)mergedClasf);
                            } else if (!mergedClasf.getName().equals(clasf.getName())) {
                                mergedClasf.setName(clasf.getAcademicClassification().getCode());
                            }
                            ArrayList<CurriculumCourse> remainingMergedCourses = new ArrayList<CurriculumCourse>(mergedClasf.getCourses());
                            for (CurriculumCourse course : clasf.getCourses()) {
                                BaseCurriculumCourse mergedCourse = null;
                                Iterator<Object> k = remainingMergedCourses.iterator();
                                while (k.hasNext()) {
                                    CurriculumCourse x = (CurriculumCourse)k.next();
                                    if (!x.getCourse().equals(course.getCourse())) continue;
                                    mergedCourse = x;
                                    k.remove();
                                    break;
                                }
                                if (mergedCourse == null) {
                                    mergedCourse = new CurriculumCourse();
                                    mergedCourse.setClassification((CurriculumClassification)mergedClasf);
                                    mergedCourse.setCourse(course.getCourse());
                                    mergedCourse.setPercShare(Float.valueOf(0.0f));
                                    mergedCourse.setOrd(courseOrd++);
                                    mergedCourse.setGroups(new HashSet<CurriculumCourseGroup>());
                                    mergedClasf.getCourses().add((CurriculumCourse)mergedCourse);
                                }
                                mergedCourse.setPercShare(Float.valueOf((mergedCourse.getPercShare().floatValue() * (float)mergedClasf.getNrStudents().intValue() + (course.getPercShare() == null || clasf.getNrStudents() == null ? 0.0f : course.getPercShare().floatValue() * (float)clasf.getNrStudents().intValue())) / (float)(mergedClasf.getNrStudents() + (clasf.getNrStudents() == null ? 0 : clasf.getNrStudents()))));
                                if (hasSnapshotData) {
                                    mergedCourse.setSnapshotPercShare(Float.valueOf((mergedCourse.getSnapshotPercShare().floatValue() * (float)mergedClasf.getSnapshotNrStudents().intValue() + (course.getSnapshotPercShare() == null || clasf.getSnapshotNrStudents() == null ? 0.0f : course.getSnapshotPercShare().floatValue() * (float)clasf.getSnapshotNrStudents().intValue())) / (float)(mergedClasf.getSnapshotNrStudents() + (clasf.getSnapshotNrStudents() == null ? 0 : clasf.getSnapshotNrStudents()))));
                                }
                                for (CurriculumCourseGroup group : course.getGroups()) {
                                    CurriculumCourseGroup mergedGroup = (CurriculumCourseGroup)groups.get(group.getUniqueId());
                                    if (mergedGroup == null) {
                                        mergedGroup = new CurriculumCourseGroup();
                                        mergedGroup.setColor(null);
                                        mergedGroup.setType(group.getType());
                                        mergedGroup.setName(group.getName() + " " + cidx);
                                        mergedGroup.setCurriculum(mergedCurriculum);
                                        groups.put(group.getUniqueId(), mergedGroup);
                                    }
                                    mergedCourse.getGroups().add(mergedGroup);
                                }
                            }
                            for (CurriculumCourse mergedCourse : remainingMergedCourses) {
                                if (clasf.getNrStudents() == null || clasf.getNrStudents() <= 0) continue;
                                mergedCourse.setPercShare(Float.valueOf(mergedCourse.getPercShare().floatValue() * (float)mergedClasf.getNrStudents().intValue() / (float)(mergedClasf.getNrStudents() + clasf.getNrStudents())));
                                if (!hasSnapshotData) continue;
                                mergedCourse.setSnapshotPercShare(Float.valueOf(mergedCourse.getSnapshotPercShare().floatValue() * (float)mergedClasf.getSnapshotNrStudents().intValue() / (float)(mergedClasf.getSnapshotNrStudents() + clasf.getSnapshotNrStudents())));
                            }
                            mergedClasf.setNrStudents(mergedClasf.getNrStudents() + (clasf.getNrStudents() == null ? 0 : clasf.getNrStudents()));
                        }
                        merged.add(curriculum);
                    }
                    if (mergedCurriculum.getAcademicArea() != null) {
                        String abbv = mergedCurriculum.getAcademicArea().getAcademicAreaAbbreviation();
                        String name = Constants.curriculaToInitialCase(mergedCurriculum.getAcademicArea().getTitle());
                        TreeSet<PosMajor> majors = new TreeSet<PosMajor>(new Comparator<PosMajor>(){

                            @Override
                            public int compare(PosMajor m1, PosMajor m2) {
                                return m1.getCode().compareToIgnoreCase(m2.getCode());
                            }
                        });
                        majors.addAll(mergedCurriculum.getMajors());
                        for (PosMajor m : majors) {
                            if (abbv.indexOf(47) < 0) {
                                abbv = abbv + "/";
                                name = name + " / ";
                            } else {
                                abbv = abbv + ",";
                                name = name + ", ";
                            }
                            abbv = abbv + m.getCode();
                            name = name + Constants.curriculaToInitialCase(m.getName());
                        }
                        if (abbv.length() > 20) {
                            abbv = abbv.substring(0, 20);
                        }
                        mergedCurriculum.setAbbv(abbv);
                        if (name.length() > 60) {
                            name = name.substring(0, 60);
                        }
                        mergedCurriculum.setName(name);
                        mergedCurriculum.setMultipleMajors(multipleMajors);
                        hibSession.saveOrUpdate((Object)mergedCurriculum);
                        for (CurriculumCourseGroup g : groups.values()) {
                            hibSession.saveOrUpdate((Object)g);
                        }
                    }
                    for (Curriculum curriculum : merged) {
                        ChangeLog.addChange(hibSession, this.getSessionContext(), curriculum, curriculum.getAbbv() + " &rarr; " + mergedCurriculum.getAbbv(), ChangeLog.Source.CURRICULA, ChangeLog.Operation.MERGE, null, curriculum.getDepartment());
                        hibSession.delete((Object)curriculum);
                    }
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Object var27_29 = null;
                }
                catch (Throwable throwable) {
                    Object var27_30 = null;
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hibSession.close();
                    throw throwable;
                }
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    break block41;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                }
            }
            hibSession.close();
            sLog.debug((Object)("Merged " + curriculumIds.size() + " curricula (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return null;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public TreeSet<CurriculumInterface.AcademicClassificationInterface> loadAcademicClassifications() throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)"loadAcademicClassifications()");
            Long s0 = System.currentTimeMillis();
            TreeSet<CurriculumInterface.AcademicClassificationInterface> results = new TreeSet<CurriculumInterface.AcademicClassificationInterface>();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            try {
                Long sessionId = this.getAcademicSessionId();
                for (AcademicClassification clasf : hibSession.createQuery("select c from AcademicClassification c where c.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                    CurriculumInterface.AcademicClassificationInterface aci = new CurriculumInterface.AcademicClassificationInterface();
                    aci.setId(clasf.getUniqueId());
                    aci.setName(clasf.getName());
                    aci.setCode(clasf.getCode());
                    results.add(aci);
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Loaded " + results.size() + " academic classifications (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public HashMap<String, CurriculumInterface.CurriculumStudentsInterface[]> computeEnrollmentsAndLastLikes(Long acadAreaId, List<Long> majors, boolean multipleMajors) throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)("computeEnrollmentsAndLastLikes(acadAreaId=" + acadAreaId + ", majors=" + majors + ")"));
            Long s0 = System.currentTimeMillis();
            if (acadAreaId == null) {
                return new HashMap<String, CurriculumInterface.CurriculumStudentsInterface[]>();
            }
            Hashtable<Long, Integer> classificationIndex = new Hashtable<Long, Integer>();
            int idx = 0;
            boolean hasSnapshotData = this.hasSnapshotData(CurriculumDAO.getInstance().getSession(), this.getAcademicSessionId());
            TreeSet<CurriculumInterface.AcademicClassificationInterface> classifications = this.loadAcademicClassifications();
            for (CurriculumInterface.AcademicClassificationInterface clasf : classifications) {
                classificationIndex.put(clasf.getId(), idx++);
            }
            Session hibSession = CurriculumDAO.getInstance().getSession();
            HashMap<String, CurriculumInterface.CurriculumStudentsInterface[]> results = new HashMap<String, CurriculumInterface.CurriculumStudentsInterface[]>();
            try {
                Hashtable<String, HashMap<String, Float>> rules = this.getRules(hibSession, acadAreaId);
                Hashtable<String, HashMap<String, Float>> snapshotRules = this.getSnapshotRules(hibSession, acadAreaId);
                AcademicArea acadArea = (AcademicArea)AcademicAreaDAO.getInstance().get(acadAreaId, hibSession);
                ArrayList<PosMajor> posMajors = new ArrayList<PosMajor>();
                for (Long majorId : majors) {
                    posMajors.add((PosMajor)PosMajorDAO.getInstance().get(majorId, hibSession));
                }
                Hashtable<Long, Set<Long>> clasf2enrl = this.loadClasf2enrl(hibSession, acadAreaId, majors, multipleMajors);
                Hashtable<Long, Set<Long>> clasf2req = this.loadClasf2req(hibSession, acadAreaId, majors, multipleMajors);
                Hashtable<Long, Hashtable<CurriculumInterface.CourseInterface, Set<Long>>> clasf2course2enrl = this.loadClasfCourse2enrl(hibSession, acadAreaId, majors, multipleMajors);
                Hashtable<Long, Hashtable<CurriculumInterface.CourseInterface, Set<Long>>> clasf2course2req = this.loadClasfCourse2req(hibSession, acadAreaId, majors, multipleMajors);
                Hashtable<String, HashMap<String, Set<Long>>> clasf2ll = this.loadClasfMajor2ll(hibSession, acadArea.getAcademicAreaAbbreviation(), posMajors, multipleMajors);
                Hashtable<String, Hashtable<CurriculumInterface.CourseInterface, HashMap<String, Set<Long>>>> clasf2course2ll = this.loadClasfCourseMajor2ll(hibSession, acadArea.getAcademicAreaAbbreviation(), posMajors, multipleMajors);
                for (CurriculumInterface.AcademicClassificationInterface clasf : classifications) {
                    CurriculumInterface.CurriculumStudentsInterface[] x = (CurriculumInterface.CurriculumStudentsInterface[])results.get("");
                    if (x == null) {
                        x = new CurriculumInterface.CurriculumStudentsInterface[classificationIndex.size()];
                        results.put("", x);
                    }
                    int col = (Integer)classificationIndex.get(clasf.getId());
                    x[col] = new CurriculumInterface.CurriculumStudentsInterface();
                    x[col].setProjection(rules.get(clasf.getCode()));
                    x[col].setEnrolledStudents(clasf2enrl.get(clasf.getId()));
                    x[col].setLastLikeStudents(clasf2ll.get(clasf.getCode()));
                    x[col].setRequestedStudents(clasf2req.get(clasf.getId()));
                    x[col].setSnapshotProjection(snapshotRules.get(clasf.getCode()));
                    x[col].setSessionHasSnapshotData(hasSnapshotData);
                    Hashtable<CurriculumInterface.CourseInterface, HashMap<String, Set<Long>>> lastLike = clasf2course2ll.get(clasf.getCode());
                    Hashtable<CurriculumInterface.CourseInterface, Set<Long>> enrollment = clasf2course2enrl.get(clasf.getId());
                    Hashtable<CurriculumInterface.CourseInterface, Set<Long>> requested = clasf2course2req.get(clasf.getId());
                    TreeSet<CurriculumInterface.CourseInterface> courses = new TreeSet<CurriculumInterface.CourseInterface>(new Comparator<CurriculumInterface.CourseInterface>(){

                        @Override
                        public int compare(CurriculumInterface.CourseInterface c1, CurriculumInterface.CourseInterface c2) {
                            int cmp = c1.getCourseName().compareTo(c2.getCourseName());
                            if (cmp != 0) {
                                return cmp;
                            }
                            return c1.getId().compareTo(c2.getId());
                        }
                    });
                    if (lastLike != null) {
                        courses.addAll(lastLike.keySet());
                    }
                    if (enrollment != null) {
                        courses.addAll(enrollment.keySet());
                    }
                    if (requested != null) {
                        courses.addAll(requested.keySet());
                    }
                    for (CurriculumInterface.CourseInterface co : courses) {
                        CurriculumInterface.CurriculumStudentsInterface[] c = results.get(co.getCourseName());
                        if (c == null) {
                            c = new CurriculumInterface.CurriculumStudentsInterface[classificationIndex.size()];
                            results.put(co.getCourseName(), c);
                        }
                        c[col] = new CurriculumInterface.CurriculumStudentsInterface();
                        c[col].setProjection(rules == null ? null : rules.get(clasf.getCode()));
                        c[col].setEnrolledStudents(enrollment == null ? null : enrollment.get(co));
                        c[col].setLastLikeStudents(lastLike == null ? null : lastLike.get(co));
                        c[col].setRequestedStudents(requested == null ? null : requested.get(co));
                        c[col].setSnapshotProjection(snapshotRules == null ? null : snapshotRules.get(clasf.getCode()));
                        c[col].setSessionHasSnapshotData(hasSnapshotData);
                    }
                }
                Object var33_35 = null;
            }
            catch (Throwable throwable) {
                Object var33_36 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Found " + results.size() + " courses with enrollments/last-like data (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    @PreAuthorize(value="checkPermission('CurriculumView')")
    private TreeSet<CurriculumInterface> loadCurriculaForACourse(Session hibSession, TreeSet<CurriculumInterface.AcademicClassificationInterface> academicClassifications, TreeSet<CurriculumInterface.AcademicAreaInterface> academicAreas, CourseOffering courseOffering) throws CurriculaException, PageAccessException {
        Set<Long> e;
        ArrayList<CurriculumInterface> results = new ArrayList<CurriculumInterface>();
        Hashtable<Long, Integer> classifications = new Hashtable<Long, Integer>();
        int idx = 0;
        for (CurriculumInterface.AcademicClassificationInterface clasf : academicClassifications) {
            classifications.put(clasf.getId(), idx++);
        }
        Map<Long, Map<Long, Map<Long, Set<Long>>>> area2major2clasf2enrl = this.loadAreaMajorClasf2enrl(hibSession, courseOffering.getUniqueId());
        Map<String, Map<String, Map<String, Set<Long>>>> area2major2clasf2ll = this.loadAreaMajorClasf2ll(hibSession, courseOffering.getUniqueId());
        Map<Long, Map<Long, Map<Long, Set<Long>>>> area2major2clasf2req = this.loadAreaMajorClasf2req(hibSession, courseOffering.getUniqueId());
        Hashtable<Long, CurriculumInterface> curricula = new Hashtable<Long, CurriculumInterface>();
        Hashtable<Long, Hashtable<Long, Integer>> cur2clasf2enrl = new Hashtable<Long, Hashtable<Long, Integer>>();
        Hashtable<Long, Hashtable<String, Integer>> cur2clasf2ll = new Hashtable<Long, Hashtable<String, Integer>>();
        boolean hasSnapshotData = this.hasSnapshotData(CurriculumDAO.getInstance().getSession(), this.getAcademicSessionId());
        for (CurriculumCourse course : hibSession.createQuery("select c from CurriculumCourse c where c.course.uniqueId = :courseId").setLong("courseId", courseOffering.getUniqueId().longValue()).setCacheable(true).list()) {
            CurriculumInterface curriculumIfc;
            CurriculumClassification clasf = course.getClassification();
            Curriculum curriculum = clasf.getCurriculum();
            Object children = null;
            if (curriculum.getMajors().isEmpty()) {
                children = hibSession.createQuery("select c from Curriculum c where c.academicArea.uniqueId = :areaId and c.multipleMajors = true and (select count(x) from CurriculumCourse x where x.course.uniqueId = :courseId and x.classification.curriculum.uniqueId = c.uniqueId) = 0").setLong("areaId", curriculum.getAcademicArea().getUniqueId().longValue()).setLong("courseId", course.getCourse().getUniqueId().longValue()).setCacheable(true).list();
            } else if (curriculum.getMajors().size() == 1) {
                children = hibSession.createQuery("select c from Curriculum c inner join c.majors m where c.academicArea.uniqueId = :areaId and m.uniqueId = :majorId and c.multipleMajors = true and (select count(x) from CurriculumCourse x where x.course.uniqueId = :courseId and x.classification.curriculum.uniqueId = c.uniqueId) = 0").setLong("areaId", curriculum.getAcademicArea().getUniqueId().longValue()).setLong("majorId", curriculum.getMajors().iterator().next().getUniqueId().longValue()).setLong("courseId", course.getCourse().getUniqueId().longValue()).setCacheable(true).list();
            }
            if (children != null && !children.isEmpty()) {
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    Curriculum child = (Curriculum)iterator.next();
                    CurriculumClassification childClasf = null;
                    for (CurriculumClassification x : child.getClassifications()) {
                        if (!x.getAcademicClassification().equals(clasf.getAcademicClassification()) || x.getNrStudents() <= 0) continue;
                        childClasf = x;
                    }
                    if (childClasf == null) continue;
                    CurriculumInterface curriculumIfc2 = (CurriculumInterface)curricula.get(child.getUniqueId());
                    if (curriculumIfc2 == null) {
                        curriculumIfc2 = new CurriculumInterface();
                        curriculumIfc2.setId(child.getUniqueId());
                        curriculumIfc2.setAbbv(child.getAbbv());
                        curriculumIfc2.setName(child.getName());
                        curriculumIfc2.setMultipleMajors(child.isMultipleMajors());
                        curriculumIfc2.setSessionHasSnapshotData(hasSnapshotData);
                        CurriculumInterface.AcademicAreaInterface areaIfc = new CurriculumInterface.AcademicAreaInterface();
                        areaIfc.setId(child.getAcademicArea().getUniqueId());
                        areaIfc.setAbbv(child.getAcademicArea().getAcademicAreaAbbreviation());
                        areaIfc.setName(Constants.curriculaToInitialCase(child.getAcademicArea().getTitle()));
                        curriculumIfc2.setAcademicArea(areaIfc);
                        CurriculumInterface.DepartmentInterface deptIfc = new CurriculumInterface.DepartmentInterface();
                        deptIfc.setId(child.getDepartment().getUniqueId());
                        deptIfc.setAbbv(child.getDepartment().getAbbreviation());
                        deptIfc.setCode(child.getDepartment().getDeptCode());
                        deptIfc.setName(child.getDepartment().getName());
                        curriculumIfc2.setDepartment(deptIfc);
                        for (PosMajor major : child.getMajors()) {
                            CurriculumInterface.MajorInterface mi = new CurriculumInterface.MajorInterface();
                            mi.setId(major.getUniqueId());
                            mi.setCode(major.getCode());
                            mi.setName(Constants.curriculaToInitialCase(major.getName()));
                            curriculumIfc2.addMajor(mi);
                        }
                        curricula.put(child.getUniqueId(), curriculumIfc2);
                        results.add(curriculumIfc2);
                        cur2clasf2enrl.put(child.getUniqueId(), this.loadClasf2enrl(hibSession, child));
                        cur2clasf2ll.put(child.getUniqueId(), this.loadClasf2ll(hibSession, child));
                    }
                    CurriculumInterface.CurriculumClassificationInterface curClasfIfc = new CurriculumInterface.CurriculumClassificationInterface();
                    curClasfIfc.setId(childClasf.getUniqueId());
                    curClasfIfc.setName(childClasf.getName());
                    curClasfIfc.setCurriculumId(child.getUniqueId());
                    curClasfIfc.setLastLike((Integer)((Hashtable)cur2clasf2ll.get(child.getUniqueId())).get(childClasf.getAcademicClassification().getCode()));
                    curClasfIfc.setExpected(childClasf.getNrStudents());
                    curClasfIfc.setSessionHasSnapshotData(hasSnapshotData);
                    if (hasSnapshotData) {
                        curClasfIfc.setSnapshotExpected(childClasf.getSnapshotNrStudents());
                    } else {
                        curClasfIfc.setSnapshotExpected(null);
                    }
                    curClasfIfc.setEnrollment((Integer)((Hashtable)cur2clasf2enrl.get(child.getUniqueId())).get(childClasf.getAcademicClassification().getUniqueId()));
                    CurriculumInterface.AcademicClassificationInterface acadClasfIfc = new CurriculumInterface.AcademicClassificationInterface();
                    acadClasfIfc.setId(childClasf.getAcademicClassification().getUniqueId());
                    acadClasfIfc.setName(childClasf.getAcademicClassification().getName());
                    acadClasfIfc.setCode(childClasf.getAcademicClassification().getCode());
                    curClasfIfc.setAcademicClassification(acadClasfIfc);
                    curriculumIfc2.addClassification(curClasfIfc);
                    CurriculumInterface.CourseInterface courseIfc = null;
                    if (curriculumIfc2.hasCourses()) {
                        courseIfc = curriculumIfc2.getCourses().first();
                    } else {
                        courseIfc = new CurriculumInterface.CourseInterface();
                        courseIfc.setId(course.getCourse().getUniqueId());
                        courseIfc.setCourseName(course.getCourse().getCourseName());
                        curriculumIfc2.addCourse(courseIfc);
                    }
                    CurriculumInterface.CurriculumCourseInterface curCourseIfc = courseIfc.getCurriculumCourse((Integer)classifications.get(childClasf.getAcademicClassification().getUniqueId()));
                    if (curCourseIfc == null) {
                        curCourseIfc = new CurriculumInterface.CurriculumCourseInterface();
                        curCourseIfc.setCourseOfferingId(course.getCourse().getUniqueId());
                        curCourseIfc.setCurriculumClassificationId(childClasf.getUniqueId());
                        curCourseIfc.setDefaultShare(course.getPercShare());
                        curCourseIfc.setCourseName(course.getCourse().getCourseName());
                        curCourseIfc.setSessionHasSnapshotData(hasSnapshotData);
                        if (hasSnapshotData) {
                            curCourseIfc.setDefaultSnapshotShare(course.getSnapshotPercShare());
                        }
                    } else {
                        if (curCourseIfc.getDefaultShare().floatValue() < course.getPercShare().floatValue()) {
                            curCourseIfc.setDefaultShare(course.getPercShare());
                        }
                        if (curCourseIfc.getDefaultSnapshotShare().floatValue() < course.getSnapshotPercShare().floatValue()) {
                            curCourseIfc.setDefaultSnapshotShare(course.getSnapshotPercShare());
                        }
                    }
                    courseIfc.setCurriculumCourse((Integer)classifications.get(childClasf.getAcademicClassification().getUniqueId()), curCourseIfc);
                }
            }
            if ((curriculumIfc = (CurriculumInterface)curricula.get(curriculum.getUniqueId())) == null) {
                curriculumIfc = new CurriculumInterface();
                curriculumIfc.setId(curriculum.getUniqueId());
                curriculumIfc.setAbbv(curriculum.getAbbv());
                curriculumIfc.setName(curriculum.getName());
                curriculumIfc.setMultipleMajors(curriculum.isMultipleMajors());
                curriculumIfc.setSessionHasSnapshotData(hasSnapshotData);
                CurriculumInterface.AcademicAreaInterface areaIfc = new CurriculumInterface.AcademicAreaInterface();
                areaIfc.setId(curriculum.getAcademicArea().getUniqueId());
                areaIfc.setAbbv(curriculum.getAcademicArea().getAcademicAreaAbbreviation());
                areaIfc.setName(Constants.curriculaToInitialCase(curriculum.getAcademicArea().getTitle()));
                curriculumIfc.setAcademicArea(areaIfc);
                CurriculumInterface.DepartmentInterface deptIfc = new CurriculumInterface.DepartmentInterface();
                deptIfc.setId(curriculum.getDepartment().getUniqueId());
                deptIfc.setAbbv(curriculum.getDepartment().getAbbreviation());
                deptIfc.setCode(curriculum.getDepartment().getDeptCode());
                deptIfc.setName(curriculum.getDepartment().getName());
                curriculumIfc.setDepartment(deptIfc);
                for (PosMajor major : curriculum.getMajors()) {
                    CurriculumInterface.MajorInterface mi = new CurriculumInterface.MajorInterface();
                    mi.setId(major.getUniqueId());
                    mi.setCode(major.getCode());
                    mi.setName(Constants.curriculaToInitialCase(major.getName()));
                    curriculumIfc.addMajor(mi);
                }
                curricula.put(curriculum.getUniqueId(), curriculumIfc);
                results.add(curriculumIfc);
                cur2clasf2enrl.put(curriculum.getUniqueId(), this.loadClasf2enrl(hibSession, curriculum));
                cur2clasf2ll.put(curriculum.getUniqueId(), this.loadClasf2ll(hibSession, curriculum));
            }
            CurriculumInterface.CurriculumClassificationInterface curClasfIfc = new CurriculumInterface.CurriculumClassificationInterface();
            curClasfIfc.setId(clasf.getUniqueId());
            curClasfIfc.setName(clasf.getName());
            curClasfIfc.setCurriculumId(curriculum.getUniqueId());
            curClasfIfc.setLastLike((Integer)((Hashtable)cur2clasf2ll.get(curriculum.getUniqueId())).get(clasf.getAcademicClassification().getCode()));
            curClasfIfc.setExpected(clasf.getNrStudents());
            curClasfIfc.setSessionHasSnapshotData(hasSnapshotData);
            if (hasSnapshotData) {
                curClasfIfc.setSnapshotExpected(clasf.getSnapshotNrStudents());
            } else {
                curClasfIfc.setSnapshotExpected(null);
            }
            curClasfIfc.setEnrollment((Integer)((Hashtable)cur2clasf2enrl.get(curriculum.getUniqueId())).get(clasf.getAcademicClassification().getUniqueId()));
            CurriculumInterface.AcademicClassificationInterface acadClasfIfc = new CurriculumInterface.AcademicClassificationInterface();
            acadClasfIfc.setId(clasf.getAcademicClassification().getUniqueId());
            acadClasfIfc.setName(clasf.getAcademicClassification().getName());
            acadClasfIfc.setCode(clasf.getAcademicClassification().getCode());
            curClasfIfc.setAcademicClassification(acadClasfIfc);
            curriculumIfc.addClassification(curClasfIfc);
            CurriculumInterface.CourseInterface courseIfc = null;
            if (curriculumIfc.hasCourses()) {
                courseIfc = curriculumIfc.getCourses().first();
            } else {
                courseIfc = new CurriculumInterface.CourseInterface();
                courseIfc.setId(course.getCourse().getUniqueId());
                courseIfc.setCourseName(course.getCourse().getCourseName());
                curriculumIfc.addCourse(courseIfc);
            }
            CurriculumInterface.CurriculumCourseInterface curCourseIfc = new CurriculumInterface.CurriculumCourseInterface();
            curCourseIfc.setId(course.getUniqueId());
            curCourseIfc.setCourseOfferingId(course.getCourse().getUniqueId());
            curCourseIfc.setCurriculumClassificationId(clasf.getUniqueId());
            curCourseIfc.setShare(course.getPercShare());
            curCourseIfc.setSessionHasSnapshotData(hasSnapshotData);
            if (hasSnapshotData) {
                curCourseIfc.setSnapshotShare(course.getSnapshotPercShare());
            }
            curCourseIfc.setCourseName(course.getCourse().getCourseName());
            courseIfc.setCurriculumCourse((Integer)classifications.get(clasf.getAcademicClassification().getUniqueId()), curCourseIfc);
        }
        Collections.sort(results, new Comparator<CurriculumInterface>(){

            @Override
            public int compare(CurriculumInterface c1, CurriculumInterface c2) {
                if (c1.isMultipleMajors() != c2.isMultipleMajors()) {
                    return c1.isMultipleMajors() ? -1 : 1;
                }
                if ((c1.hasMajors() ? c1.getMajors().size() : 0) != (c2.hasMajors() ? c2.getMajors().size() : 0)) {
                    return (c1.hasMajors() ? c1.getMajors().size() : 0) > (c2.hasMajors() ? c2.getMajors().size() : 0) ? -1 : 1;
                }
                return c1.compareTo(c2);
            }
        });
        for (CurriculumInterface curriculumIfc : results) {
            Hashtable<String, HashMap<String, Float>> rules = this.getRules(hibSession, curriculumIfc.getAcademicArea().getId());
            Hashtable<String, HashMap<String, Float>> snapshotRules = null;
            if (hasSnapshotData) {
                snapshotRules = this.getSnapshotRules(hibSession, curriculumIfc.getAcademicArea().getId());
            }
            for (CurriculumInterface.AcademicClassificationInterface clasf : academicClassifications) {
                Set<Long> e2;
                int enrl = 0;
                Map<Long, Map<Long, Set<Long>>> major2clasf2enrl = area2major2clasf2enrl.get(curriculumIfc.getAcademicArea().getId());
                if (major2clasf2enrl != null) {
                    Map<Long, Set<Long>> clasf2enrl;
                    if (!curriculumIfc.hasMajors()) {
                        if (curriculumIfc.isMultipleMajors()) {
                            Set<Long> e3;
                            Map<Long, Set<Long>> clasf2enrl2 = major2clasf2enrl.get(-1L);
                            Set<Long> set = e3 = clasf2enrl2 == null ? null : clasf2enrl2.get(clasf.getId());
                            if (e3 != null) {
                                enrl += e3.size();
                                clasf2enrl2.remove(-1L);
                            }
                        } else {
                            HashSet<Long> s = new HashSet<Long>();
                            for (Map<Long, Set<Long>> clasf2enrl3 : major2clasf2enrl.values()) {
                                Set<Long> e4 = clasf2enrl3 == null ? null : clasf2enrl3.get(clasf.getId());
                                if (e4 == null) continue;
                                s.addAll(e4);
                                clasf2enrl3.remove(clasf.getId());
                            }
                            enrl += s.size();
                        }
                    } else if (curriculumIfc.isMultipleMajors()) {
                        HashSet<Object> s = null;
                        for (CurriculumInterface.MajorInterface m : curriculumIfc.getMajors()) {
                            Set<Long> e5;
                            clasf2enrl = major2clasf2enrl.get(m.getId());
                            Set<Long> set = e5 = clasf2enrl == null ? null : clasf2enrl.get(clasf.getId());
                            if (e5 == null) {
                                if (s == null) {
                                    s = new HashSet();
                                    continue;
                                }
                                s.clear();
                                continue;
                            }
                            if (s == null) {
                                s = new HashSet<Long>(e5);
                                continue;
                            }
                            s.retainAll(e5);
                        }
                        if (s != null && !s.isEmpty()) {
                            enrl += s.size();
                            for (CurriculumInterface.MajorInterface m : curriculumIfc.getMajors()) {
                                clasf2enrl = major2clasf2enrl.get(m.getId());
                                Set<Long> e6 = clasf2enrl == null ? null : clasf2enrl.get(clasf.getId());
                                if (e6 == null) continue;
                                e6.removeAll(s);
                                if (!e6.isEmpty()) continue;
                                clasf2enrl.remove(clasf.getId());
                            }
                        }
                    } else {
                        HashSet<Long> s = new HashSet<Long>();
                        for (CurriculumInterface.MajorInterface m : curriculumIfc.getMajors()) {
                            clasf2enrl = major2clasf2enrl.get(m.getId());
                            Set<Long> e7 = clasf2enrl == null ? null : clasf2enrl.get(clasf.getId());
                            if (e7 == null) continue;
                            s.addAll(e7);
                            clasf2enrl.remove(clasf.getId());
                        }
                        enrl += s.size();
                    }
                }
                int lastLike = 0;
                float proj = 0.0f;
                float snapshotProj = 0.0f;
                Map<String, Map<String, Set<Long>>> major2clasf2ll = area2major2clasf2ll.get(curriculumIfc.getAcademicArea().getAbbv());
                if (major2clasf2ll != null) {
                    Map<String, Set<Long>> clasf2ll;
                    if (!curriculumIfc.hasMajors()) {
                        Iterator<Map.Entry<String, Map<String, Set<Long>>>> e8;
                        if (curriculumIfc.isMultipleMajors()) {
                            Map<String, Set<Long>> clasf2ll2 = major2clasf2ll.get("");
                            Iterator<Map.Entry<String, Map<String, Set<Long>>>> iterator = e8 = clasf2ll2 == null ? null : clasf2ll2.get(clasf.getCode());
                            if (e8 != null) {
                                lastLike += e8.size();
                                clasf2ll2.remove(-1L);
                            }
                        } else {
                            HashSet<Long> s = new HashSet<Long>();
                            e8 = major2clasf2ll.entrySet().iterator();
                            while (e8.hasNext()) {
                                Map.Entry<String, Map<String, Set<Long>>> entry = e8.next();
                                clasf2ll = entry.getValue();
                                e = clasf2ll == null ? null : clasf2ll.get(clasf.getCode());
                                if (e == null) continue;
                                int add = 0;
                                for (Long id : e) {
                                    if (!s.add(id)) continue;
                                    ++add;
                                }
                                proj += this.getProjection(rules, entry.getKey(), clasf.getCode()) * (float)add;
                                if (hasSnapshotData) {
                                    snapshotProj += this.getSnapshotProjection(snapshotRules, entry.getKey(), clasf.getCode()) * (float)add;
                                }
                                clasf2ll.remove(clasf.getId());
                            }
                            lastLike += s.size();
                        }
                    } else if (curriculumIfc.isMultipleMajors()) {
                        Map<String, Set<Long>> clasf2ll3;
                        HashSet s = null;
                        float p = 1.0f;
                        float ssp = 1.0f;
                        for (CurriculumInterface.MajorInterface m : curriculumIfc.getMajors()) {
                            clasf2ll3 = major2clasf2ll.get(m.getCode());
                            Set<Long> set = e2 = clasf2ll3 == null ? null : clasf2ll3.get(clasf.getCode());
                            if (e2 == null) {
                                if (s == null) {
                                    s = new HashSet();
                                } else {
                                    s.clear();
                                }
                            } else if (s == null) {
                                s = new HashSet(e2);
                            } else {
                                s.retainAll(e2);
                            }
                            p *= this.getProjection(rules, m.getCode(), clasf.getCode());
                            if (!hasSnapshotData) continue;
                            ssp *= this.getSnapshotProjection(snapshotRules, m.getCode(), clasf.getCode());
                        }
                        if (s != null && !s.isEmpty()) {
                            lastLike += s.size();
                            proj = (float)((double)proj + Math.pow(p, 1.0 / (double)curriculumIfc.getMajors().size()) * (double)s.size());
                            if (hasSnapshotData) {
                                snapshotProj = (float)((double)snapshotProj + Math.pow(ssp, 1.0 / (double)curriculumIfc.getMajors().size()) * (double)s.size());
                            }
                            for (CurriculumInterface.MajorInterface m : curriculumIfc.getMajors()) {
                                clasf2ll3 = major2clasf2ll.get(m.getCode());
                                e2 = clasf2ll3 == null ? null : clasf2ll3.get(clasf.getCode());
                                if (e2 == null) continue;
                                e2.removeAll(s);
                                if (!e2.isEmpty()) continue;
                                clasf2ll3.remove(clasf.getCode());
                            }
                        }
                    } else {
                        HashSet<Long> s = new HashSet<Long>();
                        for (CurriculumInterface.MajorInterface m : curriculumIfc.getMajors()) {
                            clasf2ll = major2clasf2ll.get(m.getCode());
                            e = clasf2ll == null ? null : clasf2ll.get(clasf.getCode());
                            if (e == null) continue;
                            int add = 0;
                            e2 = e.iterator();
                            while (e2.hasNext()) {
                                Long id;
                                id = (Long)e2.next();
                                if (!s.add(id)) continue;
                                ++add;
                            }
                            proj += this.getProjection(rules, m.getCode(), clasf.getCode()) * (float)add;
                            if (hasSnapshotData) {
                                snapshotProj += this.getSnapshotProjection(snapshotRules, m.getCode(), clasf.getCode()) * (float)add;
                            }
                            s.addAll(e);
                            clasf2ll.remove(clasf.getCode());
                        }
                        lastLike += s.size();
                    }
                }
                int req = 0;
                Map<Long, Map<Long, Set<Long>>> major2clasf2req = area2major2clasf2req.get(curriculumIfc.getAcademicArea().getId());
                if (major2clasf2req != null) {
                    Iterator<Object> e9;
                    CurriculumInterface.MajorInterface m;
                    if (!curriculumIfc.hasMajors()) {
                        if (curriculumIfc.isMultipleMajors()) {
                            Map<Long, Set<Long>> clasf2req = major2clasf2req.get(-1L);
                            Iterator<Object> iterator = e9 = clasf2req == null ? null : clasf2req.get(clasf.getId());
                            if (e9 != null) {
                                req += e9.size();
                                clasf2req.remove(-1L);
                            }
                        } else {
                            HashSet s = new HashSet();
                            e9 = major2clasf2req.values().iterator();
                            while (e9.hasNext()) {
                                Map clasf2req = (Map)e9.next();
                                Set e10 = clasf2req == null ? null : (Set)clasf2req.get(clasf.getId());
                                if (e10 == null) continue;
                                s.addAll(e10);
                                clasf2req.remove(clasf.getId());
                            }
                            req += s.size();
                        }
                    } else if (curriculumIfc.isMultipleMajors()) {
                        HashSet s = null;
                        e9 = curriculumIfc.getMajors().iterator();
                        while (e9.hasNext()) {
                            m = (CurriculumInterface.MajorInterface)e9.next();
                            Map<Long, Set<Long>> clasf2req = major2clasf2req.get(m.getId());
                            Set<Long> set = e2 = clasf2req == null ? null : clasf2req.get(clasf.getId());
                            if (e2 == null) {
                                if (s == null) {
                                    s = new HashSet();
                                    continue;
                                }
                                s.clear();
                                continue;
                            }
                            if (s == null) {
                                s = new HashSet(e2);
                                continue;
                            }
                            s.retainAll(e2);
                        }
                        if (s != null && !s.isEmpty()) {
                            req += s.size();
                            e9 = curriculumIfc.getMajors().iterator();
                            while (e9.hasNext()) {
                                m = (CurriculumInterface.MajorInterface)e9.next();
                                Map<Long, Set<Long>> clasf2req = major2clasf2req.get(m.getId());
                                e2 = clasf2req == null ? null : clasf2req.get(clasf.getId());
                                if (e2 == null) continue;
                                e2.removeAll(s);
                                if (!e2.isEmpty()) continue;
                                clasf2req.remove(clasf.getId());
                            }
                        }
                    } else {
                        HashSet<Map.Entry<String, Map<String, Set<Long>>>> s = new HashSet<Map.Entry<String, Map<String, Set<Long>>>>();
                        e9 = curriculumIfc.getMajors().iterator();
                        while (e9.hasNext()) {
                            m = (CurriculumInterface.MajorInterface)e9.next();
                            Map<Long, Set<Long>> clasf2req = major2clasf2req.get(m.getId());
                            e2 = clasf2req == null ? null : clasf2req.get(clasf.getId());
                            if (e2 == null) continue;
                            s.addAll(e2);
                            clasf2req.remove(clasf.getId());
                        }
                        req += s.size();
                    }
                }
                if (enrl <= 0 && lastLike <= 0 && Math.round(proj) <= 0 && req <= 0) continue;
                CurriculumInterface.CourseInterface courseIfc = null;
                if (curriculumIfc.hasCourses()) {
                    courseIfc = curriculumIfc.getCourses().first();
                } else {
                    courseIfc = new CurriculumInterface.CourseInterface();
                    courseIfc.setId(courseOffering.getUniqueId());
                    courseIfc.setCourseName(courseOffering.getCourseName());
                    curriculumIfc.addCourse(courseIfc);
                }
                CurriculumInterface.CurriculumCourseInterface curCourseIfc = courseIfc.getCurriculumCourse((Integer)classifications.get(clasf.getId()));
                if (curCourseIfc == null) {
                    curCourseIfc = new CurriculumInterface.CurriculumCourseInterface();
                    curCourseIfc.setCourseOfferingId(courseOffering.getUniqueId());
                    curCourseIfc.setShare(Float.valueOf(0.0f));
                    curCourseIfc.setCourseName(courseOffering.getCourseName());
                    courseIfc.setCurriculumCourse((Integer)classifications.get(clasf.getId()), curCourseIfc);
                }
                if (enrl > 0) {
                    curCourseIfc.setEnrollment(enrl);
                }
                if (lastLike > 0) {
                    curCourseIfc.setLastLike(lastLike);
                }
                if (Math.round(proj) > 0) {
                    curCourseIfc.setProjection(Math.round(proj));
                }
                curCourseIfc.setSessionHasSnapshotData(hasSnapshotData);
                if (hasSnapshotData) {
                    if (Math.round(snapshotProj) > 0) {
                        curCourseIfc.setSnapshotProjection(Math.round(snapshotProj));
                    }
                } else {
                    curCourseIfc.setSnapshotProjection(null);
                }
                if (req <= 0) continue;
                curCourseIfc.setRequested(req);
            }
        }
        HashSet<Long> areas = new HashSet<Long>();
        areas.addAll(area2major2clasf2enrl.keySet());
        areas.addAll(area2major2clasf2req.keySet());
        Hashtable<Long, String> areasId2Abbv = new Hashtable<Long, String>();
        for (CurriculumInterface.AcademicAreaInterface area : academicAreas) {
            areasId2Abbv.put(area.getId(), area.getAbbv());
            if (!area2major2clasf2ll.containsKey(area.getAbbv())) continue;
            areas.add(area.getId());
        }
        for (Long areaId : areas) {
            Hashtable<String, HashMap<String, Float>> rules = this.getRules(hibSession, areaId);
            Hashtable<String, HashMap<String, Float>> snapshotRules = null;
            if (hasSnapshotData) {
                snapshotRules = this.getSnapshotRules(hibSession, areaId);
            }
            boolean empty = true;
            CurriculumInterface otherCurriculumIfc = new CurriculumInterface();
            CurriculumInterface.CourseInterface otherCourseIfc = new CurriculumInterface.CourseInterface();
            otherCourseIfc.setId(courseOffering.getUniqueId());
            otherCourseIfc.setCourseName(courseOffering.getCourseName());
            otherCurriculumIfc.addCourse(otherCourseIfc);
            for (CurriculumInterface.AcademicClassificationInterface clasf : academicClassifications) {
                int enrl = 0;
                Map<Long, Map<Long, Set<Long>>> major2clasf2enrl = area2major2clasf2enrl.get(areaId);
                if (major2clasf2enrl != null) {
                    HashSet<Long> s = new HashSet<Long>();
                    for (Map<Long, Set<Long>> clasf2enrl : major2clasf2enrl.values()) {
                        e = clasf2enrl.get(clasf.getId());
                        if (e == null) continue;
                        s.addAll(e);
                    }
                    enrl += s.size();
                }
                int lastLike = 0;
                int proj = 0;
                int snapshotProj = 0;
                Map<String, Map<String, Set<Long>>> major2clasf2ll = area2major2clasf2ll.get(areasId2Abbv.get(areaId));
                if (major2clasf2ll != null) {
                    HashSet<Long> s = new HashSet<Long>();
                    for (Map.Entry<String, Map<String, Set<Long>>> entry : major2clasf2ll.entrySet()) {
                        Map<String, Set<Long>> clasf2ll = entry.getValue();
                        Set<Long> e11 = clasf2ll.get(clasf.getCode());
                        if (e11 == null) continue;
                        int add = 0;
                        for (Long id : e11) {
                            if (!s.add(id)) continue;
                            ++add;
                        }
                        proj += Math.round(this.getProjection(rules, entry.getKey(), clasf.getCode()) * (float)add);
                        if (!hasSnapshotData) continue;
                        snapshotProj += Math.round(this.getSnapshotProjection(snapshotRules, entry.getKey(), clasf.getCode()) * (float)add);
                    }
                    lastLike += s.size();
                }
                int req = 0;
                Map<Long, Map<Long, Set<Long>>> major2clasf2req = area2major2clasf2req.get(areaId);
                if (major2clasf2req != null) {
                    HashSet<Long> s = new HashSet<Long>();
                    for (Map<Long, Set<Long>> clasf2req : major2clasf2req.values()) {
                        Set<Long> e12 = clasf2req.get(clasf.getId());
                        if (e12 == null) continue;
                        s.addAll(e12);
                    }
                    req += s.size();
                }
                if (enrl <= 0 && lastLike <= 0 && proj <= 0 && req <= 0 && snapshotProj <= 0) continue;
                CurriculumInterface.CurriculumCourseInterface otherCurCourseIfc = new CurriculumInterface.CurriculumCourseInterface();
                otherCurCourseIfc.setCourseOfferingId(courseOffering.getUniqueId());
                otherCurCourseIfc.setCourseName(courseOffering.getCourseName());
                if (enrl > 0) {
                    otherCurCourseIfc.setEnrollment(enrl);
                }
                if (lastLike > 0) {
                    otherCurCourseIfc.setLastLike(lastLike);
                }
                if (proj > 0) {
                    otherCurCourseIfc.setProjection(proj);
                }
                if (req > 0) {
                    otherCurCourseIfc.setRequested(req);
                }
                otherCurCourseIfc.setSessionHasSnapshotData(hasSnapshotData);
                if (hasSnapshotData) {
                    if (snapshotProj > 0) {
                        otherCurCourseIfc.setSnapshotProjection(snapshotProj);
                    }
                } else {
                    otherCurCourseIfc.setSnapshotProjection(null);
                }
                otherCourseIfc.setCurriculumCourse((Integer)classifications.get(clasf.getId()), otherCurCourseIfc);
                empty = false;
            }
            if (empty) continue;
            AcademicArea a = (AcademicArea)AcademicAreaDAO.getInstance().get(areaId, hibSession);
            CurriculumInterface.AcademicAreaInterface areaIfc = new CurriculumInterface.AcademicAreaInterface();
            areaIfc.setId(a.getUniqueId());
            areaIfc.setAbbv(a.getAcademicAreaAbbreviation());
            areaIfc.setName(Constants.curriculaToInitialCase(a.getTitle()));
            otherCurriculumIfc.setAcademicArea(areaIfc);
            otherCurriculumIfc.setAbbv(areaIfc.getAbbv());
            otherCurriculumIfc.setName(areaIfc.getName());
            results.add(otherCurriculumIfc);
        }
        return new TreeSet<CurriculumInterface>(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView') or checkPermission('Reservations')")
    public TreeSet<CurriculumInterface> findCurriculaForACourse(String courseName) throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)("getCurriculaForACourse(courseName='" + courseName + "')"));
            Long s0 = System.currentTimeMillis();
            TreeSet<CurriculumInterface.AcademicClassificationInterface> academicClassifications = this.loadAcademicClassifications();
            TreeSet<CurriculumInterface.AcademicAreaInterface> academicAreas = this.loadAcademicAreas();
            TreeSet<CurriculumInterface> results = null;
            Session hibSession = CurriculumDAO.getInstance().getSession();
            try {
                CourseOffering courseOffering = this.getCourse(hibSession, courseName);
                if (courseOffering == null) {
                    throw new CurriculaException(MESSAGES.errorCourseDoesNotExist(courseName));
                }
                results = this.loadCurriculaForACourse(hibSession, academicClassifications, academicAreas, courseOffering);
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Found " + (results == null ? 0 : results.size()) + " curricula (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public TreeSet<CurriculumInterface> findCurriculaForAnInstructionalOffering(Long offeringId) throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)("findCurriculaForAnOffering(offeringId='" + offeringId + "')"));
            Long s0 = System.currentTimeMillis();
            TreeSet<CurriculumInterface.AcademicClassificationInterface> academicClassifications = this.loadAcademicClassifications();
            TreeSet<CurriculumInterface.AcademicAreaInterface> academicAreas = this.loadAcademicAreas();
            TreeSet<CurriculumInterface> results = null;
            Session hibSession = CurriculumDAO.getInstance().getSession();
            try {
                InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId, hibSession);
                if (offering == null) {
                    throw new CurriculaException(MESSAGES.errorOfferingDoesNotExist(offeringId == null ? "null" : offeringId.toString()));
                }
                for (CourseOffering courseOffering : offering.getCourseOfferings()) {
                    if (results == null) {
                        results = this.loadCurriculaForACourse(hibSession, academicClassifications, academicAreas, courseOffering);
                        continue;
                    }
                    TreeSet<CurriculumInterface> curricula = this.loadCurriculaForACourse(hibSession, academicClassifications, academicAreas, courseOffering);
                    block7: for (CurriculumInterface curriculum : curricula) {
                        for (CurriculumInterface result : results) {
                            if (!ToolBox.equals((Object)curriculum.getId(), (Object)result.getId()) || !ToolBox.equals((Object)curriculum.getAcademicArea().getId(), (Object)result.getAcademicArea().getId())) continue;
                            if (curriculum.hasClassifications()) {
                                for (CurriculumInterface.CurriculumClassificationInterface cc : curriculum.getClassifications()) {
                                    result.addClassification(cc);
                                }
                            }
                            result.addCourse(curriculum.getCourses().first());
                            continue block7;
                        }
                        results.add(curriculum);
                    }
                }
                Object var18_20 = null;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Found " + results.size() + " curricula (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public TreeSet<CurriculumInterface.AcademicAreaInterface> loadAcademicAreas() throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)"loadAcademicAreas()");
            Long s0 = System.currentTimeMillis();
            TreeSet<CurriculumInterface.AcademicAreaInterface> results = new TreeSet<CurriculumInterface.AcademicAreaInterface>();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            Long sessionId = this.getAcademicSessionId();
            try {
                List areas = hibSession.createQuery("select a from AcademicArea a where a.session.uniqueId = :sessionId order by a.academicAreaAbbreviation, a.title").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
                for (AcademicArea a : areas) {
                    CurriculumInterface.AcademicAreaInterface ai = new CurriculumInterface.AcademicAreaInterface();
                    ai.setId(a.getUniqueId());
                    ai.setAbbv(a.getAcademicAreaAbbreviation());
                    ai.setName(Constants.curriculaToInitialCase(a.getTitle()));
                    results.add(ai);
                }
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Loaded " + results.size() + " academic areas (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public TreeSet<CurriculumInterface.MajorInterface> loadMajors(Long curriculumId, Long academicAreaId, boolean multipleMajors) throws CurriculaException, PageAccessException {
        try {
            Session hibSession;
            TreeSet<CurriculumInterface.MajorInterface> results;
            Long s0;
            block12: {
                TreeSet<CurriculumInterface.MajorInterface> treeSet;
                block11: {
                    TreeSet<CurriculumInterface.MajorInterface> treeSet2;
                    block10: {
                        sLog.debug((Object)("loadMajors(academicAreaId=" + academicAreaId + ")"));
                        s0 = System.currentTimeMillis();
                        results = new TreeSet<CurriculumInterface.MajorInterface>();
                        hibSession = CurriculumDAO.getInstance().getSession();
                        try {
                            AcademicArea area = (AcademicArea)AcademicAreaDAO.getInstance().get(academicAreaId, hibSession);
                            if (area == null) {
                                treeSet2 = results;
                                Object var13_13 = null;
                                break block10;
                            }
                            TreeSet<PosMajor> majors = new TreeSet<PosMajor>(new Comparator<PosMajor>(){

                                @Override
                                public int compare(PosMajor m1, PosMajor m2) {
                                    int cmp = m1.getName().compareToIgnoreCase(m2.getName());
                                    if (cmp != 0) {
                                        return cmp;
                                    }
                                    cmp = m1.getCode().compareTo(m2.getCode());
                                    if (cmp != 0) {
                                        return cmp;
                                    }
                                    return m1.getUniqueId().compareTo(m2.getUniqueId());
                                }
                            });
                            majors.addAll(area.getPosMajors());
                            if (majors.isEmpty()) {
                                treeSet = null;
                                break block11;
                            }
                            if (!multipleMajors) {
                                majors.removeAll(hibSession.createQuery("select m from Curriculum c inner join c.majors m where c.academicArea = :academicAreaId and c.uniqueId != :curriculumId and c.multipleMajors = false").setLong("academicAreaId", academicAreaId.longValue()).setLong("curriculumId", curriculumId == null ? -1L : curriculumId).setCacheable(true).list());
                            }
                            for (PosMajor m : majors) {
                                CurriculumInterface.MajorInterface mi = new CurriculumInterface.MajorInterface();
                                mi.setId(m.getUniqueId());
                                mi.setCode(m.getCode());
                                mi.setName(Constants.curriculaToInitialCase(m.getName()));
                                results.add(mi);
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var13_16 = null;
                            hibSession.close();
                            throw throwable;
                        }
                    }
                    hibSession.close();
                    return treeSet2;
                }
                Object var13_14 = null;
                hibSession.close();
                return treeSet;
            }
            Object var13_15 = null;
            hibSession.close();
            sLog.debug((Object)("Loaded " + results.size() + " majors (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public TreeSet<CurriculumInterface.DepartmentInterface> loadDepartments() throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)"loadDepartments()");
            Long s0 = System.currentTimeMillis();
            TreeSet<CurriculumInterface.DepartmentInterface> results = new TreeSet<CurriculumInterface.DepartmentInterface>();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            try {
                for (Department d : Department.getUserDepartments(this.getSessionContext().getUser())) {
                    CurriculumInterface.DepartmentInterface di = new CurriculumInterface.DepartmentInterface();
                    di.setId(d.getUniqueId());
                    di.setCode(d.getDeptCode());
                    di.setAbbv(d.getAbbreviation());
                    di.setName(d.getName());
                    results.add(di);
                }
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Loaded " + results.size() + " departments (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('CurriculumView')")
    public String lastCurriculaFilter() throws CurriculaException, PageAccessException {
        sLog.debug((Object)"lastCurriculaFilter()");
        Long s0 = System.currentTimeMillis();
        String filter = (String)this.getSessionContext().getAttribute("Curricula.LastFilter");
        if (filter == null) {
            filter = "department:Managed";
        }
        sLog.debug((Object)("Last filter is '" + filter + "'  (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView') or checkPermission('Reservations')")
    public Collection<ClassAssignmentInterface.CourseAssignment> listCourseOfferings(String query, Integer limit, boolean includeNotOffered, boolean checkDepartment) throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)("listCourseOfferings(query='" + query + "', limit=" + limit + ")"));
            Long s0 = System.currentTimeMillis();
            ArrayList<ClassAssignmentInterface.CourseAssignment> results = new ArrayList<ClassAssignmentInterface.CourseAssignment>();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            Long sessionId = this.getAcademicSessionId();
            try {
                for (CourseOffering c : hibSession.createQuery("select c from CourseOffering c where " + (includeNotOffered ? "" : "c.instructionalOffering.notOffered = false and ") + "c.subjectArea.session.uniqueId = :sessionId and (lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' or lower(c.courseNbr) like :q || '%' " + (query.length() > 2 ? "or lower(c.title) like '%' || :q || '%'" : "") + ") order by case when lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) like :q || '%' then 0 else 1 end,c.subjectArea.subjectAreaAbbreviation, c.courseNbr").setString("q", query.toLowerCase()).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(limit == null || limit < 0 || checkDepartment ? Integer.MAX_VALUE : limit).list()) {
                    if (checkDepartment && !this.permissionDepartment.check(this.getSessionContext().getUser(), c.getDepartment(), DepartmentStatusType.Status.OwnerLimitedEdit, DepartmentStatusType.Status.ManagerLimitedEdit)) continue;
                    ClassAssignmentInterface.CourseAssignment course = new ClassAssignmentInterface.CourseAssignment();
                    course.setCourseId(c.getUniqueId());
                    course.setSubject(c.getSubjectAreaAbbv());
                    course.setCourseNbr(c.getCourseNbr());
                    course.setNote(c.getScheduleBookNote());
                    course.setTitle(c.getTitle());
                    if (c.getCredit() != null) {
                        course.setCreditText(c.getCredit().creditText());
                        course.setCreditAbbv(c.getCredit().creditAbbv());
                    }
                    course.setHasUniqueName(true);
                    course.setHasCrossList(c.getInstructionalOffering().hasCrossList());
                    boolean unlimited = false;
                    int courseLimit = 0;
                    for (InstrOfferingConfig cfg : c.getInstructionalOffering().getInstrOfferingConfigs()) {
                        if (cfg.isUnlimitedEnrollment().booleanValue()) {
                            unlimited = true;
                        }
                        if (cfg.getLimit() == null) continue;
                        courseLimit += cfg.getLimit().intValue();
                    }
                    if (c.getReservation() != null) {
                        courseLimit = c.getReservation();
                    }
                    if (courseLimit >= 9999) {
                        unlimited = true;
                    }
                    course.setLimit(unlimited ? -1 : courseLimit);
                    course.setProjected(c.getProjectedDemand());
                    course.setEnrollment(c.getEnrollment());
                    course.setLastLike(c.getDemand());
                    results.add(course);
                }
                Object var17_19 = null;
            }
            catch (Throwable throwable) {
                Object var17_20 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Found " + results.size() + " course offerings  (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView') or checkPermission('Reservations')")
    public String retrieveCourseDetails(String course) throws CurriculaException, PageAccessException {
        try {
            String string;
            sLog.debug((Object)("retrieveCourseDetails(course='" + course + "')"));
            Long s0 = System.currentTimeMillis();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            try {
                CourseOffering courseOffering = this.getCourse(hibSession, course);
                if (courseOffering == null) {
                    throw new CurriculaException(MESSAGES.errorCourseDoesNotExist(course));
                }
                String details = this.getCourseDetailsProvider().getDetails(new AcademicSessionInfo(courseOffering.getSubjectArea().getSession()), courseOffering.getSubjectAreaAbbv(), courseOffering.getCourseNbr());
                sLog.debug((Object)("Details of length " + details.length() + " retrieved (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
                string = details;
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return string;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumView') or checkPermission('Reservations')")
    public Collection<ClassAssignmentInterface.ClassAssignment> listClasses(String course) throws CurriculaException, PageAccessException {
        try {
            sLog.debug((Object)("listClasses(course='" + course + "')"));
            Long s0 = System.currentTimeMillis();
            ArrayList<ClassAssignmentInterface.ClassAssignment> results = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            Session hibSession = CurriculumDAO.getInstance().getSession();
            Long sessionId = this.getAcademicSessionId();
            NameFormat nameFormat = NameFormat.fromReference(UserProperty.NameFormat.get(this.getSessionContext().getUser()));
            try {
                CourseOffering courseOffering = null;
                Iterator iterator = hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course").setString("course", course.toLowerCase()).setLong("sessionId", sessionId.longValue()).setCacheable(true).setMaxResults(1).list().iterator();
                if (iterator.hasNext()) {
                    CourseOffering c;
                    courseOffering = c = (CourseOffering)iterator.next();
                }
                if (courseOffering == null) {
                    throw new CurriculaException(MESSAGES.errorCourseDoesNotExist(course));
                }
                ArrayList<Class_> classes = new ArrayList<Class_>();
                for (InstrOfferingConfig config : courseOffering.getInstructionalOffering().getInstrOfferingConfigs()) {
                    for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                        classes.addAll(subpart.getClasses());
                    }
                }
                Collections.sort(classes, new ClassComparator(5));
                for (Class_ clazz : classes) {
                    int maxLimit;
                    ClassAssignmentInterface.ClassAssignment a = new ClassAssignmentInterface.ClassAssignment();
                    a.setClassId(clazz.getUniqueId());
                    a.setSubpart(clazz.getSchedulingSubpart().getItypeDesc().trim());
                    a.setSection(clazz.getClassSuffix(courseOffering));
                    a.setClassNumber(clazz.getSectionNumberString(hibSession));
                    if (a.getSection() == null) {
                        a.setSection(a.getClassNumber());
                    }
                    a.addNote(clazz.getSchedulePrintNote());
                    Assignment ass = clazz.getCommittedAssignment();
                    Placement p = ass == null ? null : ass.getPlacement();
                    int minLimit = clazz.getExpectedCapacity();
                    int limit = maxLimit = clazz.getMaxExpectedCapacity().intValue();
                    if (minLimit < maxLimit && p != null) {
                        int roomLimit = (int)Math.floor((float)p.getRoomSize() / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                        limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                    }
                    if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                        limit = -1;
                    }
                    a.setCancelled(clazz.isCancelled());
                    a.setLimit(new int[]{clazz.getEnrollment(), limit});
                    if (p != null && p.getTimeLocation() != null) {
                        for (DayCode d : DayCode.toDayCodes(p.getTimeLocation().getDayCode())) {
                            a.addDay(d.getIndex());
                        }
                        a.setStart(p.getTimeLocation().getStartSlot());
                        a.setLength(p.getTimeLocation().getLength());
                        a.setBreakTime(p.getTimeLocation().getBreakTime());
                        a.setDatePattern(p.getTimeLocation().getDatePatternName());
                    }
                    if (p != null && p.getRoomLocations() != null) {
                        for (RoomLocation rm : p.getRoomLocations()) {
                            a.addRoom(rm.getId(), rm.getName());
                        }
                    }
                    if (p != null && p.getRoomLocation() != null) {
                        a.addRoom(p.getRoomLocation().getId(), p.getRoomLocation().getName());
                    }
                    if (!clazz.getClassInstructors().isEmpty()) {
                        for (ClassInstructor instr : clazz.getClassInstructors()) {
                            a.addInstructor(nameFormat.format(instr.getInstructor()));
                            a.addInstructoEmail(instr.getInstructor().getEmail());
                        }
                    }
                    if (clazz.getParentClass() != null) {
                        a.setParentSection(clazz.getParentClass().getClassSuffix(courseOffering));
                    }
                    a.setSubpartId(clazz.getSchedulingSubpart().getUniqueId());
                    if (a.getParentSection() == null) {
                        a.setParentSection(courseOffering.getConsentType() == null ? null : courseOffering.getConsentType().getLabel());
                    }
                    results.add(a);
                }
                Object var20_25 = null;
            }
            catch (Throwable throwable) {
                Object var20_26 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Found " + results.size() + " classes (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    @Override
    public String[] getApplicationProperty(String[] name) throws CurriculaException, PageAccessException {
        String[] ret = new String[name.length];
        for (int i = 0; i < name.length; ++i) {
            ret[i] = ApplicationProperties.getProperty(name[i]);
        }
        return ret;
    }

    @Override
    @PreAuthorize(value="checkPermission('CurriculumAdd') and checkPermission('CurriculumView')")
    public Boolean canAddCurriculum() throws CurriculaException, PageAccessException {
        return true;
    }

    @Override
    @PreAuthorize(value="checkPermission('CurriculumAdmin') and checkPermission('CurriculumView')")
    public Boolean isAdmin() throws CurriculaException, PageAccessException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumProjectionRulesDetail')")
    public HashMap<CurriculumInterface.AcademicAreaInterface, HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>>> loadProjectionRules() throws CurriculaException, PageAccessException {
        sLog.debug((Object)"loadProjectionRules()");
        Long s0 = System.currentTimeMillis();
        try {
            UserContext user = this.getSessionContext().getUser();
            if (user == null) {
                throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? MESSAGES.authenticationExpired() : MESSAGES.authenticationRequired());
            }
            HashMap<CurriculumInterface.AcademicAreaInterface, HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>>> rules = new HashMap<CurriculumInterface.AcademicAreaInterface, HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>>>();
            TreeSet<CurriculumInterface.AcademicAreaInterface> areas = this.loadAcademicAreas();
            TreeSet<CurriculumInterface.AcademicClassificationInterface> classifications = this.loadAcademicClassifications();
            Long sessionId = this.getAcademicSessionId();
            CurriculumInterface.MajorInterface dummyMajor = new CurriculumInterface.MajorInterface();
            dummyMajor.setId(-1L);
            dummyMajor.setCode("");
            Session hibSession = CurriculumDAO.getInstance().getSession();
            try {
                Hashtable<String, Hashtable<String, Hashtable<String, Integer>>> areaMajorClasf2ll = this.loadAreaMajorClasf2ll(hibSession);
                Hashtable<Long, CurriculumInterface.MajorInterface> majorLookup = new Hashtable<Long, CurriculumInterface.MajorInterface>();
                Hashtable<Long, ArrayList<CurriculumInterface.MajorInterface>> majors = new Hashtable<Long, ArrayList<CurriculumInterface.MajorInterface>>();
                for (Object major : hibSession.createQuery("select m from PosMajor m where m.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                    CurriculumInterface.MajorInterface mi = new CurriculumInterface.MajorInterface();
                    mi.setId(((BasePosMajor)major).getUniqueId());
                    mi.setCode(((BasePosMajor)major).getCode());
                    mi.setName(Constants.curriculaToInitialCase(((BasePosMajor)major).getName()));
                    majorLookup.put(mi.getId(), mi);
                    for (AcademicArea a : ((BasePosMajor)major).getAcademicAreas()) {
                        ArrayList<CurriculumInterface.MajorInterface> majorsOfArea = (ArrayList<CurriculumInterface.MajorInterface>)majors.get(a.getUniqueId());
                        if (majorsOfArea == null) {
                            majorsOfArea = new ArrayList<CurriculumInterface.MajorInterface>();
                            majors.put(a.getUniqueId(), majorsOfArea);
                        }
                        majorsOfArea.add(mi);
                    }
                }
                Hashtable<Long, CurriculumInterface.AcademicClassificationInterface> clasfLookup = new Hashtable<Long, CurriculumInterface.AcademicClassificationInterface>();
                for (CurriculumInterface.AcademicClassificationInterface clasf : classifications) {
                    clasfLookup.put(clasf.getId(), clasf);
                }
                Hashtable<Long, CurriculumInterface.AcademicAreaInterface> areaLookup = new Hashtable<Long, CurriculumInterface.AcademicAreaInterface>();
                for (CurriculumInterface.AcademicAreaInterface area : areas) {
                    areaLookup.put(area.getId(), area);
                    HashMap rules4area = (HashMap)rules.get(area);
                    if (rules4area == null) {
                        rules4area = new HashMap();
                        rules.put(area, rules4area);
                    }
                    Hashtable<String, Hashtable<String, Integer>> majorClasf2ll = areaMajorClasf2ll.get(area.getAbbv());
                    HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]> rules4default = new HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>();
                    rules4area.put(dummyMajor, rules4default);
                    for (CurriculumInterface.AcademicClassificationInterface clasf : classifications) {
                        int ll = 0;
                        if (majorClasf2ll != null) {
                            for (Hashtable<String, Integer> clasf2ll : majorClasf2ll.values()) {
                                Integer lastLike = clasf2ll.get(clasf.getCode());
                                if (lastLike == null) continue;
                                ll += lastLike.intValue();
                            }
                        }
                        rules4default.put(clasf, new Number[]{null, new Integer(ll)});
                    }
                    List majorsOfArea = (List)majors.get(area.getId());
                    if (majorsOfArea == null) continue;
                    for (CurriculumInterface.MajorInterface major : majorsOfArea) {
                        Hashtable<String, Integer> clasf2ll = majorClasf2ll == null ? null : majorClasf2ll.get(major.getCode());
                        HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]> rules4major = new HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>();
                        rules4area.put(major, rules4major);
                        for (CurriculumInterface.AcademicClassificationInterface clasf : classifications) {
                            Integer lastLike = clasf2ll == null ? null : clasf2ll.get(clasf.getCode());
                            rules4major.put(clasf, new Number[]{null, new Integer(lastLike == null ? 0 : lastLike)});
                        }
                    }
                }
                for (CurriculumProjectionRule rule : hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                    try {
                        ((Number[])((HashMap)((HashMap)rules.get(areaLookup.get((Object)rule.getAcademicArea().getUniqueId()))).get((Object)(rule.getMajor() == null ? dummyMajor : (CurriculumInterface.MajorInterface)majorLookup.get((Object)rule.getMajor().getUniqueId())))).get(clasfLookup.get((Object)rule.getAcademicClassification().getUniqueId())))[0] = rule.getProjection();
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                Object var28_32 = null;
            }
            catch (Throwable throwable) {
                Object var28_33 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            sLog.debug((Object)("Curriculum projection rules loaded (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return rules;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumProjectionRulesEdit')")
    public Boolean saveProjectionRules(HashMap<CurriculumInterface.AcademicAreaInterface, HashMap<CurriculumInterface.MajorInterface, HashMap<CurriculumInterface.AcademicClassificationInterface, Number[]>>> rules) throws CurriculaException, PageAccessException {
        sLog.debug((Object)"saveProjectionRules()");
        long s0 = System.currentTimeMillis();
        try {
            Session hibSession;
            block18: {
                if (!this.canEditProjectionRules().booleanValue()) {
                    throw new CurriculaException(MESSAGES.authenticationInsufficient());
                }
                hibSession = CurriculumDAO.getInstance().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    Long sessionId = this.getAcademicSessionId();
                    for (CurriculumProjectionRule curriculumProjectionRule : hibSession.createQuery("select r from CurriculumProjectionRule r where academicArea.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                        ChangeLog.addChange(hibSession, this.getSessionContext(), curriculumProjectionRule, curriculumProjectionRule.getAcademicArea().getAcademicAreaAbbreviation() + (curriculumProjectionRule.getMajor() == null ? "" : "/" + curriculumProjectionRule.getMajor().getCode()) + " " + curriculumProjectionRule.getAcademicClassification().getCode() + ": " + sDF.format(100.0 * (double)curriculumProjectionRule.getProjection().floatValue()) + "%", ChangeLog.Source.CUR_PROJ_RULES, ChangeLog.Operation.DELETE, null, null);
                        hibSession.delete((Object)curriculumProjectionRule);
                    }
                    for (Map.Entry entry : rules.entrySet()) {
                        AcademicArea area = null;
                        for (Map.Entry b : ((HashMap)entry.getValue()).entrySet()) {
                            PosMajor major = null;
                            for (Map.Entry c : ((HashMap)b.getValue()).entrySet()) {
                                if (((Number[])c.getValue())[1].intValue() <= 0 || ((Number[])c.getValue())[0] == null) continue;
                                if (area == null) {
                                    area = (AcademicArea)AcademicAreaDAO.getInstance().get(((CurriculumInterface.AcademicAreaInterface)entry.getKey()).getId(), hibSession);
                                }
                                if (((CurriculumInterface.MajorInterface)b.getKey()).getId() >= 0L && major == null) {
                                    major = (PosMajor)PosMajorDAO.getInstance().get(((CurriculumInterface.MajorInterface)b.getKey()).getId());
                                }
                                AcademicClassification clasf = (AcademicClassification)AcademicClassificationDAO.getInstance().get(((CurriculumInterface.AcademicClassificationInterface)c.getKey()).getId());
                                CurriculumProjectionRule r = new CurriculumProjectionRule();
                                r.setAcademicArea(area);
                                r.setMajor(major);
                                r.setAcademicClassification(clasf);
                                r.setProjection(Float.valueOf(((Number[])c.getValue())[0].floatValue()));
                                hibSession.saveOrUpdate((Object)r);
                                ChangeLog.addChange(hibSession, this.getSessionContext(), r, area.getAcademicAreaAbbreviation() + (major == null ? "" : "/" + major.getCode()) + " " + clasf.getCode() + ": " + sDF.format(100.0 * (double)r.getProjection().floatValue()) + "%", ChangeLog.Source.CUR_PROJ_RULES, ChangeLog.Operation.CREATE, null, null);
                            }
                        }
                    }
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Object var18_21 = null;
                }
                catch (Throwable throwable) {
                    Object var18_22 = null;
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hibSession.close();
                    throw throwable;
                }
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    break block18;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                }
            }
            hibSession.close();
            sLog.debug((Object)("Curriculum projection rules saved (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return null;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('CurriculumProjectionRulesEdit')")
    public Boolean canEditProjectionRules() throws CurriculaException, PageAccessException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumAdmin')")
    public Boolean makeupCurriculaFromLastLikeDemands(boolean lastLike) throws CurriculaException, PageAccessException {
        sLog.debug((Object)("makeupCurriculaFromLastLikeDemands(lastLike=" + lastLike + ")"));
        long s0 = System.currentTimeMillis();
        try {
            Session hibSession;
            block14: {
                if (!this.isAdmin().booleanValue()) {
                    throw new CurriculaException(MESSAGES.authenticationInsufficient());
                }
                hibSession = CurriculumDAO.getInstance().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    Long sessionId = this.getAcademicSessionId();
                    for (Curriculum c : hibSession.createQuery("from Curriculum where department.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).list()) {
                        ChangeLog.addChange(hibSession, this.getSessionContext(), c, c.getAbbv(), ChangeLog.Source.CURRICULA, ChangeLog.Operation.DELETE, null, c.getDepartment());
                    }
                    MakeCurriculaFromLastlikeDemands m = new MakeCurriculaFromLastlikeDemands(sessionId);
                    m.update(hibSession, lastLike);
                    for (Curriculum c : hibSession.createQuery("from Curriculum where department.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).list()) {
                        ChangeLog.addChange(hibSession, this.getSessionContext(), c, c.getAbbv(), ChangeLog.Source.CURRICULA, ChangeLog.Operation.CREATE, null, c.getDepartment());
                    }
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hibSession.close();
                    throw throwable;
                }
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    break block14;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                }
            }
            hibSession.close();
            sLog.debug((Object)("Curricula recreated (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return null;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean updateCurriculaByProjections(Set<Long> curriculumIds, boolean updateCurriculumCourses) throws CurriculaException, PageAccessException {
        sLog.debug((Object)("updateCurriculaByProjections(curricula=" + curriculumIds + ", updateCurriculumCourses=" + updateCurriculumCourses + ")"));
        long s0 = System.currentTimeMillis();
        try {
            Session hibSession;
            block48: {
                hibSession = CurriculumDAO.getInstance().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    Long sessionId = this.getAcademicSessionId();
                    List<Curriculum> curricula = null;
                    if (curriculumIds == null) {
                        curricula = this.findAllCurricula(hibSession);
                    } else {
                        curricula = new ArrayList<Curriculum>();
                        for (Long id : curriculumIds) {
                            curricula.add((Curriculum)CurriculumDAO.getInstance().get(id, hibSession));
                        }
                    }
                    for (Curriculum c : curricula) {
                        if (c == null || !this.getSessionContext().hasPermission(c, Right.CurriculumEdit)) continue;
                        List classifications = hibSession.createQuery("select c from AcademicClassification c where c.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
                        Hashtable<String, HashMap<String, Float>> rules = this.getRules(hibSession, c.getAcademicArea().getUniqueId());
                        Hashtable<String, Hashtable<String, Integer>> clasfMajor2ll = this.loadClasfMajor2ll(hibSession, c);
                        int totalProjection = 0;
                        for (AcademicClassification acadClasf : classifications) {
                            float proj = 0.0f;
                            Hashtable<String, Integer> major2ll = clasfMajor2ll.get(acadClasf.getCode());
                            if (major2ll != null) {
                                if (c.isMultipleMajors().booleanValue() && c.getMajors().size() > 1) {
                                    double rule = 1.0;
                                    for (PosMajor m : c.getMajors()) {
                                        rule *= (double)this.getProjection(rules, m.getCode(), acadClasf.getCode());
                                    }
                                    for (Integer ll : major2ll.values()) {
                                        proj += (float)Math.pow(rule, 1.0 / (double)c.getMajors().size()) * (float)ll.intValue();
                                    }
                                } else {
                                    for (Map.Entry<String, Integer> entry : major2ll.entrySet()) {
                                        proj += this.getProjection(rules, entry.getKey(), acadClasf.getCode()) * (float)entry.getValue().intValue();
                                    }
                                }
                            }
                            CurriculumClassification clasf = null;
                            for (CurriculumClassification curriculumClassification : c.getClassifications()) {
                                if (!curriculumClassification.getAcademicClassification().equals(acadClasf)) continue;
                                clasf = curriculumClassification;
                                break;
                            }
                            if (clasf == null && Math.round(proj) <= 0) continue;
                            if (clasf == null) {
                                clasf = new CurriculumClassification();
                                clasf.setAcademicClassification(acadClasf);
                                clasf.setCourses(new HashSet<CurriculumCourse>());
                                clasf.setCurriculum(c);
                                c.getClassifications().add(clasf);
                                clasf.setName(acadClasf.getCode());
                                clasf.setOrd(c.getClassifications().size());
                            }
                            clasf.setNrStudents(Math.round(proj));
                            totalProjection += Math.round(proj);
                            hibSession.saveOrUpdate((Object)clasf);
                        }
                        if (updateCurriculumCourses) {
                            float totalShareLimit = ApplicationProperty.CurriculumLastLikeDemandsTotalShareLimit.floatValue().floatValue();
                            float shareLimit = ApplicationProperty.CurriculumLastLikeDemandsShareLimit.floatValue().floatValue();
                            int enrollmentLimit = ApplicationProperty.CurriculumLastLikeDemandsEnrollmentLimit.intValue();
                            Hashtable<String, Hashtable<String, Hashtable<Long, Integer>>> clasfMajorCourse2ll = this.loadClasfMajorCourse2ll(hibSession, c);
                            Hashtable courseTotals = new Hashtable();
                            for (Map.Entry entry : clasfMajorCourse2ll.entrySet()) {
                                if (c.isMultipleMajors().booleanValue() && c.getMajors().size() > 1) {
                                    double rule = 1.0;
                                    for (PosMajor posMajor : c.getMajors()) {
                                        rule *= (double)this.getProjection(rules, posMajor.getCode(), (String)entry.getKey());
                                    }
                                    rule = Math.pow(rule, 1.0 / (double)c.getMajors().size());
                                    for (Hashtable hashtable : ((Hashtable)entry.getValue()).values()) {
                                        for (Map.Entry course : hashtable.entrySet()) {
                                            Float total = (Float)courseTotals.get(course.getKey());
                                            courseTotals.put(course.getKey(), Float.valueOf((float)(rule * (double)((Integer)course.getValue()).intValue()) + (total == null ? 0.0f : total.floatValue())));
                                        }
                                    }
                                    continue;
                                }
                                for (Map.Entry entry2 : ((Hashtable)entry.getValue()).entrySet()) {
                                    for (Map.Entry entry3 : ((Hashtable)entry2.getValue()).entrySet()) {
                                        Float total = (Float)courseTotals.get(entry3.getKey());
                                        courseTotals.put(entry3.getKey(), Float.valueOf(this.getProjection(rules, (String)entry2.getKey(), (String)entry.getKey()) * (float)((Integer)entry3.getValue()).intValue() + (total == null ? 0.0f : total.floatValue())));
                                    }
                                }
                            }
                            for (CurriculumClassification curriculumClassification : c.getClassifications()) {
                                Object lastLike;
                                Hashtable<String, Hashtable<Long, Integer>> majorCourse2ll = clasfMajorCourse2ll.get(curriculumClassification.getAcademicClassification().getCode());
                                if (majorCourse2ll == null || curriculumClassification.getNrStudents() == 0) {
                                    for (CurriculumCourse course : curriculumClassification.getCourses()) {
                                        course.setPercShare(Float.valueOf(0.0f));
                                        hibSession.saveOrUpdate((Object)course);
                                    }
                                    continue;
                                }
                                HashSet hashSet = new HashSet();
                                for (Hashtable hashtable : majorCourse2ll.values()) {
                                    hashSet.addAll(hashtable.keySet());
                                }
                                for (CurriculumCourse curriculumCourse : curriculumClassification.getCourses()) {
                                    float proj = 0.0f;
                                    if (c.isMultipleMajors().booleanValue() && c.getMajors().size() > 1) {
                                        double rule = 1.0;
                                        for (PosMajor m : c.getMajors()) {
                                            rule *= (double)this.getProjection(rules, m.getCode(), curriculumClassification.getAcademicClassification().getCode());
                                        }
                                        rule = Math.pow(rule, 1.0 / (double)c.getMajors().size());
                                        for (Map.Entry<String, Hashtable<Long, Integer>> entry : majorCourse2ll.entrySet()) {
                                            lastLike = entry.getValue().get(curriculumCourse.getCourse().getUniqueId());
                                            if (lastLike == null) continue;
                                            proj = (float)((double)proj + rule * (double)((Integer)lastLike).intValue());
                                        }
                                    } else {
                                        for (Map.Entry<String, Hashtable<Long, Integer>> entry : majorCourse2ll.entrySet()) {
                                            Integer lastLike2 = entry.getValue().get(curriculumCourse.getCourse().getUniqueId());
                                            proj += this.getProjection(rules, entry.getKey(), curriculumClassification.getAcademicClassification().getCode()) * (float)(lastLike2 == null ? 0 : lastLike2);
                                        }
                                    }
                                    curriculumCourse.setPercShare(Float.valueOf(proj / (float)curriculumClassification.getNrStudents().intValue()));
                                    hashSet.remove(curriculumCourse.getCourse().getUniqueId());
                                    hibSession.saveOrUpdate((Object)curriculumCourse);
                                }
                                for (Long l : hashSet) {
                                    float share;
                                    Float courseTotal = (Float)courseTotals.get(l);
                                    float totalShare = (courseTotal == null ? 0.0f : courseTotal.floatValue()) / (float)totalProjection;
                                    if (totalShare < totalShareLimit) continue;
                                    float proj = 0.0f;
                                    if (c.isMultipleMajors().booleanValue() && c.getMajors().size() > 1) {
                                        double rule = 1.0;
                                        for (PosMajor m : c.getMajors()) {
                                            rule *= (double)this.getProjection(rules, m.getCode(), curriculumClassification.getAcademicClassification().getCode());
                                        }
                                        rule = Math.pow(rule, 1.0 / (double)c.getMajors().size());
                                        for (Map.Entry<String, Hashtable<Long, Integer>> entry : majorCourse2ll.entrySet()) {
                                            Integer lastLike3 = entry.getValue().get(l);
                                            if (lastLike3 == null) continue;
                                            proj = (float)((double)proj + rule * (double)lastLike3.intValue());
                                        }
                                    } else {
                                        for (Map.Entry<String, Hashtable<Long, Integer>> entry : majorCourse2ll.entrySet()) {
                                            lastLike = entry.getValue().get(l);
                                            proj += this.getProjection(rules, entry.getKey(), curriculumClassification.getAcademicClassification().getCode()) * (float)(lastLike == null ? 0 : (Integer)lastLike);
                                        }
                                    }
                                    if ((share = proj / (float)curriculumClassification.getNrStudents().intValue()) <= 0.0f || Math.round(proj) < enrollmentLimit || share < shareLimit) continue;
                                    CurriculumCourse course = new CurriculumCourse();
                                    course.setClassification(curriculumClassification);
                                    curriculumClassification.getCourses().add(course);
                                    course.setOrd(curriculumClassification.getCourses().size());
                                    course.setCourse((CourseOffering)CourseOfferingDAO.getInstance().get(l, hibSession));
                                    course.setPercShare(Float.valueOf(share));
                                    hibSession.saveOrUpdate((Object)course);
                                }
                            }
                        }
                        ChangeLog.addChange(hibSession, this.getSessionContext(), c, c.getAbbv(), ChangeLog.Source.CURRICULA, ChangeLog.Operation.UPDATE, null, c.getDepartment());
                    }
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Object var35_67 = null;
                }
                catch (Throwable throwable) {
                    Object var35_68 = null;
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hibSession.close();
                    throw throwable;
                }
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    break block48;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                }
            }
            hibSession.close();
            sLog.debug((Object)("Curricula update (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return null;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    protected boolean isTemplateFor(Curriculum template, Curriculum curriculum) {
        if (!curriculum.isMultipleMajors().booleanValue()) {
            return false;
        }
        if (!curriculum.getAcademicArea().equals(curriculum.getAcademicArea())) {
            return false;
        }
        if (curriculum.getMajors().size() <= template.getMajors().size() || template.getMajors().size() > 1) {
            return false;
        }
        return template.getMajors().isEmpty() || curriculum.getMajors().containsAll(template.getMajors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('CurriculumAdmin')")
    public Boolean populateCourseProjectedDemands(boolean includeOtherStudents) throws CurriculaException, PageAccessException {
        sLog.debug((Object)("populateCourseProjectedDemands(includeOtherStudents=" + includeOtherStudents + ")"));
        long s0 = System.currentTimeMillis();
        try {
            Session hibSession;
            block43: {
                if (!this.isAdmin().booleanValue()) {
                    throw new CurriculaException(MESSAGES.authenticationInsufficient());
                }
                hibSession = CurriculumDAO.getInstance().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    Long sessionId = this.getAcademicSessionId();
                    Map<Long, Map<String, Map<String, Map<String, Set<Long>>>>> course2area2major2clasf2ll = null;
                    if (includeOtherStudents) {
                        course2area2major2clasf2ll = this.loadCourseAreaMajorClasf2ll(hibSession);
                    }
                    Hashtable<String, Hashtable<String, HashMap<String, Float>>> rules = includeOtherStudents ? this.getRules(hibSession) : null;
                    List classifications = hibSession.createQuery("select c from AcademicClassification c where c.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
                    List curricula = hibSession.createQuery("from Curriculum c where c.academicArea.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).list();
                    HashMap<Long, ArrayList<Curriculum>> curriculum2children = new HashMap<Long, ArrayList<Curriculum>>();
                    for (Curriculum c1 : curricula) {
                        for (Curriculum c2 : curricula) {
                            if (!c1.isTemplateFor(c2)) continue;
                            ArrayList<Curriculum> children = (ArrayList<Curriculum>)curriculum2children.get(c1.getUniqueId());
                            if (children == null) {
                                children = new ArrayList<Curriculum>();
                                curriculum2children.put(c1.getUniqueId(), children);
                            }
                            children.add(c2);
                        }
                    }
                    Hashtable<Long, ArrayList<CurriculumCourse>> course2curriculum = new Hashtable<Long, ArrayList<CurriculumCourse>>();
                    for (CurriculumCourse cc : hibSession.createQuery("select cc from CurriculumCourse cc where cc.classification.curriculum.academicArea.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                        ArrayList<CurriculumCourse> courses = (ArrayList<CurriculumCourse>)course2curriculum.get(cc.getCourse().getUniqueId());
                        if (courses == null) {
                            courses = new ArrayList<CurriculumCourse>();
                            course2curriculum.put(cc.getCourse().getUniqueId(), courses);
                        }
                        courses.add(cc);
                    }
                    for (CourseOffering courseOffering : hibSession.createQuery("select co from CourseOffering co where co.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                        Integer oldDemand = courseOffering.getDemand();
                        Map<String, Map<String, Map<String, Set<Long>>>> area2major2clasf2ll = course2area2major2clasf2ll == null ? null : course2area2major2clasf2ll.get(courseOffering.getUniqueId());
                        List courses = (List)course2curriculum.get(courseOffering.getUniqueId());
                        int demand = 0;
                        HashMap<Long, Integer> demands = new HashMap<Long, Integer>();
                        HashMap<Long, Integer> defaultDemands = new HashMap<Long, Integer>();
                        TreeSet<Curriculum> related = new TreeSet<Curriculum>(new Comparator<Curriculum>(){

                            @Override
                            public int compare(Curriculum c1, Curriculum c2) {
                                if (c1.isMultipleMajors() != c2.isMultipleMajors()) {
                                    return c1.isMultipleMajors() != false ? -1 : 1;
                                }
                                if (c1.getMajors().size() != c2.getMajors().size()) {
                                    return c1.getMajors().size() > c2.getMajors().size() ? -1 : 1;
                                }
                                return c1.compareTo(c2);
                            }
                        });
                        if (courses != null) {
                            for (CurriculumCourse curriculumCourse : courses) {
                                CurriculumClassification clasf = curriculumCourse.getClassification();
                                Curriculum curriculum = clasf.getCurriculum();
                                demands.put(clasf.getUniqueId(), (int)Math.round((double)clasf.getNrStudents().intValue() * (double)curriculumCourse.getPercShare().floatValue()));
                                List children = (List)curriculum2children.get(curriculum.getUniqueId());
                                if (children != null && !children.isEmpty()) {
                                    Iterator iterator = children.iterator();
                                    while (iterator.hasNext()) {
                                        Curriculum child = (Curriculum)iterator.next();
                                        BaseCurriculumClassification childClasf = null;
                                        for (CurriculumClassification x : child.getClassifications()) {
                                            if (!x.getAcademicClassification().equals(clasf.getAcademicClassification()) || x.getNrStudents() <= 0) continue;
                                            childClasf = x;
                                        }
                                        if (childClasf == null) continue;
                                        Integer previous = (Integer)defaultDemands.get(childClasf.getUniqueId());
                                        int current = (int)Math.round((double)childClasf.getNrStudents().intValue() * (double)curriculumCourse.getPercShare().floatValue());
                                        if (previous != null && current <= previous) continue;
                                        defaultDemands.put(childClasf.getUniqueId(), current);
                                    }
                                }
                                related.add(curriculum);
                            }
                        }
                        for (Integer n : demands.values()) {
                            demand += n.intValue();
                        }
                        for (Map.Entry entry : defaultDemands.entrySet()) {
                            if (demands.containsKey(entry.getKey())) continue;
                            demand += ((Integer)entry.getValue()).intValue();
                        }
                        if (area2major2clasf2ll != null) {
                            for (Curriculum curriculum : related) {
                                Map<String, Map<String, Set<Long>>> major2clasf2ll = area2major2clasf2ll.get(curriculum.getAcademicArea().getAcademicAreaAbbreviation());
                                if (major2clasf2ll == null) continue;
                                if (curriculum.getMajors().isEmpty()) {
                                    if (curriculum.isMultipleMajors().booleanValue()) {
                                        Map<String, Set<Long>> clasf2ll = major2clasf2ll.get("");
                                        if (clasf2ll == null) continue;
                                        for (AcademicClassification cc : classifications) {
                                            clasf2ll.remove(cc.getCode());
                                        }
                                        continue;
                                    }
                                    major2clasf2ll.clear();
                                    continue;
                                }
                                if (curriculum.isMultipleMajors().booleanValue()) {
                                    for (AcademicClassification cc : classifications) {
                                        Set<Long> e;
                                        Map<String, Set<Long>> clasf2ll;
                                        HashSet<Object> s = null;
                                        for (PosMajor m : curriculum.getMajors()) {
                                            clasf2ll = major2clasf2ll.get(m.getCode());
                                            Set<Long> set = e = clasf2ll == null ? null : clasf2ll.get(cc.getCode());
                                            if (e == null) {
                                                if (s == null) {
                                                    s = new HashSet();
                                                    continue;
                                                }
                                                s.clear();
                                                continue;
                                            }
                                            if (s == null) {
                                                s = new HashSet<Long>(e);
                                                continue;
                                            }
                                            s.retainAll(e);
                                        }
                                        if (s == null || s.isEmpty()) continue;
                                        for (PosMajor m : curriculum.getMajors()) {
                                            clasf2ll = major2clasf2ll.get(m.getCode());
                                            e = clasf2ll == null ? null : clasf2ll.get(cc.getCode());
                                            if (e == null) continue;
                                            e.removeAll(s);
                                            if (!e.isEmpty()) continue;
                                            clasf2ll.remove(cc.getCode());
                                        }
                                    }
                                    continue;
                                }
                                for (PosMajor m : curriculum.getMajors()) {
                                    major2clasf2ll.remove(m.getCode());
                                }
                            }
                            for (Map.Entry entry : area2major2clasf2ll.entrySet()) {
                                for (Map.Entry majorEclasf2ll : ((Map)entry.getValue()).entrySet()) {
                                    for (Map.Entry clasfEll : ((Map)majorEclasf2ll.getValue()).entrySet()) {
                                        demand += Math.round(this.getProjection(rules == null ? null : rules.get(entry.getKey()), (String)majorEclasf2ll.getKey(), (String)clasfEll.getKey()) * (float)((Set)clasfEll.getValue()).size());
                                    }
                                }
                            }
                        }
                        courseOffering.setProjectedDemand(demand);
                        if (oldDemand == null || demand != oldDemand) {
                            ChangeLog.addChange(hibSession, this.getSessionContext(), courseOffering, courseOffering.getCourseName() + " projection: " + oldDemand + " &rarr; " + demand, ChangeLog.Source.CURRICULA, ChangeLog.Operation.UPDATE, courseOffering.getSubjectArea(), courseOffering.getSubjectArea().getDepartment());
                        }
                        hibSession.saveOrUpdate((Object)courseOffering);
                    }
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Object var33_41 = null;
                }
                catch (Throwable throwable) {
                    Object var33_42 = null;
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hibSession.close();
                    throw throwable;
                }
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    break block43;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                }
            }
            hibSession.close();
            sLog.debug((Object)("Course projected demands updated (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return null;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission(#offeringId, 'InstructionalOffering', 'InstructionalOfferingDetail') or checkPermission('CurriculumAdmin')")
    public Boolean populateCourseProjectedDemands(boolean includeOtherStudents, Long offeringId) throws CurriculaException, PageAccessException {
        sLog.debug((Object)("populateCourseProjectedDemands(includeOtherStudents=" + includeOtherStudents + ", offering=" + offeringId + ")"));
        long s0 = System.currentTimeMillis();
        try {
            Session hibSession;
            block40: {
                hibSession = CurriculumDAO.getInstance().getSession();
                Transaction tx = null;
                try {
                    tx = hibSession.beginTransaction();
                    InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId, hibSession);
                    if (offering == null) {
                        throw new CurriculaException(MESSAGES.errorOfferingDoesNotExist(offeringId == null ? "null" : offeringId.toString()));
                    }
                    for (CourseOffering courseOffering : offering.getCourseOfferings()) {
                        Iterator course22;
                        Integer oldDemand = courseOffering.getDemand();
                        Map<String, Map<String, Map<String, Set<Long>>>> area2major2clasf2ll = null;
                        if (includeOtherStudents) {
                            area2major2clasf2ll = this.loadAreaMajorClasf2ll(hibSession, courseOffering.getUniqueId());
                        }
                        Hashtable<String, Hashtable<String, HashMap<String, Float>>> rules = includeOtherStudents ? this.getRules(hibSession) : null;
                        HashMap<Long, Integer> demands = new HashMap<Long, Integer>();
                        HashMap<Long, Integer> defaultDemands = new HashMap<Long, Integer>();
                        TreeSet<Curriculum> curricula = new TreeSet<Curriculum>(new Comparator<Curriculum>(){

                            @Override
                            public int compare(Curriculum c1, Curriculum c2) {
                                if (c1.isMultipleMajors() != c2.isMultipleMajors()) {
                                    return c1.isMultipleMajors() != false ? -1 : 1;
                                }
                                if (c1.getMajors().size() != c2.getMajors().size()) {
                                    return c1.getMajors().size() > c2.getMajors().size() ? -1 : 1;
                                }
                                return c1.compareTo(c2);
                            }
                        });
                        for (Iterator course22 : hibSession.createQuery("select cc from CurriculumCourse cc where cc.course.uniqueId = :courseId").setLong("courseId", courseOffering.getUniqueId().longValue()).setCacheable(true).list()) {
                            CurriculumClassification clasf = ((BaseCurriculumCourse)((Object)course22)).getClassification();
                            Curriculum curriculum = clasf.getCurriculum();
                            demands.put(clasf.getUniqueId(), (int)Math.round((double)clasf.getNrStudents().intValue() * (double)((BaseCurriculumCourse)((Object)course22)).getPercShare().floatValue()));
                            List children = null;
                            if (curriculum.getMajors().isEmpty()) {
                                children = hibSession.createQuery("select c from Curriculum c where c.academicArea.uniqueId = :areaId and c.multipleMajors = true and (select count(x) from CurriculumCourse x where x.course.uniqueId = :courseId and x.classification.curriculum.uniqueId = c.uniqueId) = 0").setLong("areaId", curriculum.getAcademicArea().getUniqueId().longValue()).setLong("courseId", ((BaseCurriculumCourse)((Object)course22)).getCourse().getUniqueId().longValue()).setCacheable(true).list();
                            } else if (curriculum.getMajors().size() == 1) {
                                children = hibSession.createQuery("select c from Curriculum c inner join c.majors m where c.academicArea.uniqueId = :areaId and m.uniqueId = :majorId and c.multipleMajors = true and (select count(x) from CurriculumCourse x where x.course.uniqueId = :courseId and x.classification.curriculum.uniqueId = c.uniqueId) = 0").setLong("areaId", curriculum.getAcademicArea().getUniqueId().longValue()).setLong("majorId", curriculum.getMajors().iterator().next().getUniqueId().longValue()).setLong("courseId", ((BaseCurriculumCourse)((Object)course22)).getCourse().getUniqueId().longValue()).setCacheable(true).list();
                            }
                            if (children != null && !children.isEmpty()) {
                                for (Object child : children) {
                                    BaseCurriculumClassification childClasf = null;
                                    for (CurriculumClassification x : ((BaseCurriculum)child).getClassifications()) {
                                        if (!x.getAcademicClassification().equals(clasf.getAcademicClassification()) || x.getNrStudents() <= 0) continue;
                                        childClasf = x;
                                    }
                                    if (childClasf == null) continue;
                                    Integer previous = (Integer)defaultDemands.get(childClasf.getUniqueId());
                                    int current = (int)Math.round((double)childClasf.getNrStudents().intValue() * (double)((BaseCurriculumCourse)((Object)course22)).getPercShare().floatValue());
                                    if (previous != null && current <= previous) continue;
                                    defaultDemands.put(childClasf.getUniqueId(), current);
                                }
                            }
                            curricula.add(curriculum);
                        }
                        int demand = 0;
                        for (Integer d : demands.values()) {
                            demand += d.intValue();
                        }
                        course22 = defaultDemands.entrySet().iterator();
                        while (course22.hasNext()) {
                            Map.Entry entry = course22.next();
                            if (demands.containsKey(entry.getKey())) continue;
                            demand += ((Integer)entry.getValue()).intValue();
                        }
                        if (area2major2clasf2ll != null) {
                            List classifications = hibSession.createQuery("select c from AcademicClassification c where c.session.uniqueId = :sessionId").setLong("sessionId", offering.getSessionId().longValue()).setCacheable(true).list();
                            for (Curriculum curriculum : curricula) {
                                Map<String, Map<String, Set<Long>>> major2clasf2ll = area2major2clasf2ll.get(curriculum.getAcademicArea().getAcademicAreaAbbreviation());
                                if (major2clasf2ll == null) continue;
                                if (curriculum.getMajors().isEmpty()) {
                                    if (curriculum.isMultipleMajors().booleanValue()) {
                                        Object child;
                                        Map<String, Set<Long>> clasf2ll = major2clasf2ll.get("");
                                        if (clasf2ll == null) continue;
                                        child = classifications.iterator();
                                        while (child.hasNext()) {
                                            AcademicClassification cc = (AcademicClassification)child.next();
                                            clasf2ll.remove(cc.getCode());
                                        }
                                        continue;
                                    }
                                    major2clasf2ll.clear();
                                    continue;
                                }
                                if (curriculum.isMultipleMajors().booleanValue()) {
                                    for (AcademicClassification cc : classifications) {
                                        Set<Long> e;
                                        Map<String, Set<Long>> clasf2ll;
                                        HashSet<Object> s = null;
                                        for (PosMajor m : curriculum.getMajors()) {
                                            clasf2ll = major2clasf2ll.get(m.getCode());
                                            Set<Long> set = e = clasf2ll == null ? null : clasf2ll.get(cc.getCode());
                                            if (e == null) {
                                                if (s == null) {
                                                    s = new HashSet();
                                                    continue;
                                                }
                                                s.clear();
                                                continue;
                                            }
                                            if (s == null) {
                                                s = new HashSet<Long>(e);
                                                continue;
                                            }
                                            s.retainAll(e);
                                        }
                                        if (s == null || s.isEmpty()) continue;
                                        for (PosMajor m : curriculum.getMajors()) {
                                            clasf2ll = major2clasf2ll.get(m.getCode());
                                            e = clasf2ll == null ? null : clasf2ll.get(cc.getCode());
                                            if (e == null) continue;
                                            e.removeAll(s);
                                            if (!e.isEmpty()) continue;
                                            clasf2ll.remove(cc.getCode());
                                        }
                                    }
                                    continue;
                                }
                                for (PosMajor m : curriculum.getMajors()) {
                                    major2clasf2ll.remove(m.getCode());
                                }
                            }
                            for (Map.Entry entry : area2major2clasf2ll.entrySet()) {
                                for (Map.Entry majorEclasf2ll : ((Map)entry.getValue()).entrySet()) {
                                    for (Map.Entry clasfEll : ((Map)majorEclasf2ll.getValue()).entrySet()) {
                                        demand += Math.round(this.getProjection(rules == null ? null : rules.get(entry.getKey()), (String)majorEclasf2ll.getKey(), (String)clasfEll.getKey()) * (float)((Set)clasfEll.getValue()).size());
                                    }
                                }
                            }
                        }
                        courseOffering.setProjectedDemand(demand);
                        if (oldDemand == null || demand != oldDemand) {
                            ChangeLog.addChange(hibSession, this.getSessionContext(), courseOffering, courseOffering.getCourseName() + " projection: " + oldDemand + " &rarr; " + demand, ChangeLog.Source.CURRICULA, ChangeLog.Operation.UPDATE, courseOffering.getSubjectArea(), courseOffering.getSubjectArea().getDepartment());
                        }
                        hibSession.saveOrUpdate((Object)courseOffering);
                    }
                    hibSession.flush();
                    tx.commit();
                    tx = null;
                    Object var29_36 = null;
                }
                catch (Throwable throwable) {
                    Object var29_37 = null;
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    hibSession.close();
                    throw throwable;
                }
                try {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                    break block40;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                }
            }
            hibSession.close();
            sLog.debug((Object)("Course projected demands updated (took " + sDF.format(0.001 * (double)(System.currentTimeMillis() - s0)) + " s)."));
            return null;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (CurriculaException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new CurriculaException(e.getMessage());
        }
    }

    protected Long getAcademicSessionId() {
        return this.getSessionContext().getUser().getCurrentAcademicSessionId();
    }

    private List<Curriculum> findAllCurricula(Session hibSession) {
        return hibSession.createQuery("select distinct c from Curriculum c where c.department.session.uniqueId = :sessionId").setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list();
    }

    private Hashtable<Long, Integer> loadClasf2enrl(Session hibSession, Curriculum c) {
        List lines = null;
        String select = "a.academicClassification.uniqueId, count(distinct s)";
        String from = "StudentClassEnrollment e inner join e.student s inner join s.areaClasfMajors a";
        String where = "s.session.uniqueId = :sessionId and a.academicArea.uniqueId = :areaId";
        String group = "a.academicClassification.uniqueId";
        if (c.getMajors().isEmpty()) {
            if (!c.isMultipleMajors().booleanValue()) {
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue()).setCacheable(true).list();
            }
        } else if (!c.isMultipleMajors().booleanValue() || c.getMajors().size() == 1) {
            ArrayList<Long> majorIds = new ArrayList<Long>();
            for (PosMajor posMajor : c.getMajors()) {
                majorIds.add(posMajor.getUniqueId());
            }
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and a.major.uniqueId in :majorIds group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue()).setParameterList("majorIds", majorIds).setCacheable(true).list();
        } else {
            HashMap<String, Long> params = new HashMap<String, Long>();
            int idx = 0;
            for (PosMajor posMajor : c.getMajors()) {
                if (idx == 0) {
                    where = where + " and a.major.uniqueId = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.uniqueId = :areaId and a" + idx + ".major.uniqueId = :m" + idx;
                }
                params.put("m" + idx, posMajor.getUniqueId());
                ++idx;
            }
            org.hibernate.Query query = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue());
            for (Map.Entry entry : params.entrySet()) {
                query.setLong((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
            lines = query.setCacheable(true).list();
        }
        Hashtable<Long, Integer> clasf2enrl = new Hashtable<Long, Integer>();
        if (lines != null) {
            for (Object[] objectArray : lines) {
                Long l = (Long)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                if (l == null) continue;
                clasf2enrl.put(l, n);
            }
        }
        return clasf2enrl;
    }

    private Hashtable<Long, Set<Long>> loadClasf2enrl(Session hibSession, Long acadAreaId, Collection<Long> majors, boolean multipleMajors) {
        List lines = null;
        String select = "a.academicClassification.uniqueId, s.uniqueId";
        String from = "StudentClassEnrollment e inner join e.student s inner join s.areaClasfMajors a";
        String where = "s.session.uniqueId = :sessionId and a.academicArea.uniqueId = :areaId";
        if (majors.isEmpty()) {
            if (!multipleMajors) {
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue()).setCacheable(true).list();
            }
        } else if (!multipleMajors || majors.size() == 1) {
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and a.major.uniqueId in :majorIds").setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue()).setParameterList("majorIds", majors).setCacheable(true).list();
        } else {
            HashMap<String, Long> params = new HashMap<String, Long>();
            int idx = 0;
            for (Long l : majors) {
                if (idx == 0) {
                    where = where + " and a.major.uniqueId = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.uniqueId = :areaId and a" + idx + ".major.uniqueId = :m" + idx;
                }
                params.put("m" + idx, l);
                ++idx;
            }
            org.hibernate.Query q = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue());
            for (Map.Entry entry : params.entrySet()) {
                q.setLong((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
            lines = q.setCacheable(true).list();
        }
        Hashtable<Long, Set<Long>> clasf2enrl = new Hashtable<Long, Set<Long>>();
        if (lines != null) {
            for (Object[] o : lines) {
                Long l = (Long)o[0];
                Long l2 = (Long)o[1];
                Set<Long> students = clasf2enrl.get(l);
                if (students == null) {
                    students = new HashSet<Long>();
                    clasf2enrl.put(l, students);
                }
                students.add(l2);
            }
        }
        return clasf2enrl;
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable<String, Hashtable<String, Integer>> loadClasfMajor2ll(Session hibSession, Curriculum c) {
        List lines = null;
        String select = "f.code, m.code, count(distinct s)";
        String from = "LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors a inner join a.academicClassification f inner join a.major m";
        String where = "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv";
        String group = "f.code, m.code";
        if (c.getMajors().isEmpty()) {
            if (!c.isMultipleMajors().booleanValue()) {
                select = "f.code, '', count(distinct s)";
                group = "f.code";
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setString("acadAbbv", c.getAcademicArea().getAcademicAreaAbbreviation()).setCacheable(true).list();
            }
        } else if (!c.isMultipleMajors().booleanValue() || c.getMajors().size() == 1) {
            ArrayList<String> majorCodes = new ArrayList<String>();
            for (PosMajor posMajor : c.getMajors()) {
                majorCodes.add(posMajor.getCode());
            }
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.code in :majorCodes group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setString("acadAbbv", c.getAcademicArea().getAcademicAreaAbbreviation()).setParameterList("majorCodes", majorCodes).setCacheable(true).list();
        } else {
            select = "f.code, '', count(distinct s)";
            group = "f.code";
            HashMap<String, String> params = new HashMap<String, String>();
            int idx = 0;
            for (PosMajor posMajor : c.getMajors()) {
                if (idx == 0) {
                    where = where + " and m.code = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.academicAreaAbbreviation = :acadAbbv and a" + idx + ".major.code = :m" + idx;
                }
                params.put("m" + idx, posMajor.getCode());
                ++idx;
            }
            org.hibernate.Query query = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setString("acadAbbv", c.getAcademicArea().getAcademicAreaAbbreviation());
            for (Map.Entry entry : params.entrySet()) {
                query.setString((String)entry.getKey(), (String)entry.getValue());
            }
            lines = query.setCacheable(true).list();
        }
        Hashtable<String, Hashtable<String, Integer>> clasfMajor2ll = new Hashtable<String, Hashtable<String, Integer>>();
        if (lines != null) {
            for (Object[] objectArray : lines) {
                void var12_25;
                String string = (String)objectArray[0];
                if (string == null) continue;
                String string2 = (String)objectArray[1];
                if (string2 == null) {
                    String string3 = "";
                }
                int enrl = ((Number)objectArray[2]).intValue();
                Hashtable<String, Integer> major2ll = clasfMajor2ll.get(string);
                if (major2ll == null) {
                    major2ll = new Hashtable();
                    clasfMajor2ll.put(string, major2ll);
                }
                major2ll.put((String)var12_25, enrl);
            }
        }
        return clasfMajor2ll;
    }

    private Hashtable<String, Integer> loadClasf2ll(Session hibSession, Curriculum c) {
        List lines = null;
        String select = "f.code, count(distinct s)";
        String from = "LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors a inner join a.academicClassification f";
        String where = "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv";
        String group = "f.code";
        if (c.getMajors().isEmpty()) {
            if (!c.isMultipleMajors().booleanValue()) {
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setString("acadAbbv", c.getAcademicArea().getAcademicAreaAbbreviation()).setCacheable(true).list();
            }
        } else if (!c.isMultipleMajors().booleanValue() || c.getMajors().size() == 1) {
            ArrayList<String> majorCodes = new ArrayList<String>();
            for (PosMajor posMajor : c.getMajors()) {
                majorCodes.add(posMajor.getCode());
            }
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and a.major.code in :majorCodes group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setString("acadAbbv", c.getAcademicArea().getAcademicAreaAbbreviation()).setParameterList("majorCodes", majorCodes).setCacheable(true).list();
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            int idx = 0;
            for (PosMajor posMajor : c.getMajors()) {
                if (idx == 0) {
                    where = where + " and a.major.code = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.academicAreaAbbreviation = :acadAbbv and a" + idx + ".major.code = :m" + idx;
                }
                params.put("m" + idx, posMajor.getCode());
                ++idx;
            }
            org.hibernate.Query query = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setString("acadAbbv", c.getAcademicArea().getAcademicAreaAbbreviation());
            for (Map.Entry entry : params.entrySet()) {
                query.setString((String)entry.getKey(), (String)entry.getValue());
            }
            lines = query.setCacheable(true).list();
        }
        Hashtable<String, Integer> clasf2ll = new Hashtable<String, Integer>();
        if (lines != null) {
            for (Object[] objectArray : lines) {
                String string = (String)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                if (string == null) continue;
                clasf2ll.put(string, n);
            }
        }
        return clasf2ll;
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable<String, HashMap<String, Set<Long>>> loadClasfMajor2ll(Session hibSession, String acadAreaAbbv, Collection<PosMajor> majors, boolean multipleMajors) {
        List lines = null;
        String select = "f.code, m.code, s.uniqueId";
        String from = "LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors a inner join a.academicClassification f inner join a.major m";
        String where = "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv";
        if (majors.isEmpty()) {
            if (!multipleMajors) {
                select = "f.code, '', s.uniqueId";
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setString("acadAbbv", acadAreaAbbv).setCacheable(true).list();
            }
        } else if (!multipleMajors || majors.size() == 1) {
            ArrayList<String> codes = new ArrayList<String>();
            for (PosMajor posMajor : majors) {
                codes.add(posMajor.getCode());
            }
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.code in :majorCodes").setLong("sessionId", this.getAcademicSessionId().longValue()).setString("acadAbbv", acadAreaAbbv).setParameterList("majorCodes", codes).setCacheable(true).list();
        } else {
            select = "f.code, '', s.uniqueId";
            HashMap<String, String> params = new HashMap<String, String>();
            int idx = 0;
            for (PosMajor posMajor : majors) {
                if (idx == 0) {
                    where = where + " and m.code = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.academicAreaAbbreviation = :acadAbbv and a" + idx + ".major.code = :m" + idx;
                }
                params.put("m" + idx, posMajor.getCode());
                ++idx;
            }
            org.hibernate.Query query = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setString("acadAbbv", acadAreaAbbv);
            for (Map.Entry entry : params.entrySet()) {
                query.setString((String)entry.getKey(), (String)entry.getValue());
            }
            lines = query.setCacheable(true).list();
        }
        Hashtable<String, HashMap<String, Set<Long>>> clasf2ll = new Hashtable<String, HashMap<String, Set<Long>>>();
        if (lines != null) {
            for (Object[] objectArray : lines) {
                void var13_26;
                Set<Long> students;
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                if (string2 == null) {
                    String string3 = "";
                }
                Long studentId = (Long)objectArray[2];
                HashMap<String, Set<Long>> major2students = clasf2ll.get(string);
                if (major2students == null) {
                    major2students = new HashMap();
                    clasf2ll.put(string, major2students);
                }
                if ((students = major2students.get(var13_26)) == null) {
                    students = new HashSet<Long>();
                    major2students.put((String)var13_26, students);
                }
                students.add(studentId);
            }
        }
        return clasf2ll;
    }

    private Hashtable<Long, Hashtable<Long, Integer>> loadClasfCourse2enrl(Session hibSession, Curriculum c) {
        List lines = null;
        String select = "a.academicClassification.uniqueId, e.courseOffering.uniqueId, count(distinct s)";
        String from = "StudentClassEnrollment e inner join e.student s inner join s.areaClasfMajors a inner join a.major m";
        String where = "s.session.uniqueId = :sessionId and a.academicArea.uniqueId = :areaId";
        String group = "a.academicClassification.uniqueId, e.courseOffering.uniqueId";
        if (c.getMajors().isEmpty()) {
            if (!c.isMultipleMajors().booleanValue()) {
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue()).setCacheable(true).list();
            }
        } else if (!c.isMultipleMajors().booleanValue() || c.getMajors().size() == 1) {
            ArrayList<Long> majorIds = new ArrayList<Long>();
            for (PosMajor posMajor : c.getMajors()) {
                majorIds.add(posMajor.getUniqueId());
            }
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.uniqueId in :majorIds group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue()).setParameterList("majorIds", majorIds).setCacheable(true).list();
        } else {
            HashMap<String, Long> params = new HashMap<String, Long>();
            int idx = 0;
            for (PosMajor posMajor : c.getMajors()) {
                if (idx == 0) {
                    where = where + " and m.uniqueId = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.uniqueId = :areaId and a" + idx + ".major.uniqueId = :m" + idx;
                }
                params.put("m" + idx, posMajor.getUniqueId());
                ++idx;
            }
            org.hibernate.Query query = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue());
            for (Map.Entry entry : params.entrySet()) {
                query.setLong((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
            lines = query.setCacheable(true).list();
        }
        Hashtable<Long, Hashtable<Long, Integer>> clasf2course2enrl = new Hashtable<Long, Hashtable<Long, Integer>>();
        if (lines != null) {
            for (Object[] objectArray : lines) {
                Long l = (Long)objectArray[0];
                if (l == null) continue;
                Long l2 = (Long)objectArray[1];
                int enrl = ((Number)objectArray[2]).intValue();
                Hashtable<Long, Integer> course2enrl = clasf2course2enrl.get(l);
                if (course2enrl == null) {
                    course2enrl = new Hashtable();
                    clasf2course2enrl.put(l, course2enrl);
                }
                course2enrl.put(l2, enrl);
            }
        }
        return clasf2course2enrl;
    }

    private Hashtable<Long, Hashtable<CurriculumInterface.CourseInterface, Set<Long>>> loadClasfCourse2enrl(Session hibSession, Long acadAreaId, Collection<Long> majors, boolean multipleMajors) {
        List lines = null;
        String select = "a.academicClassification.uniqueId, e.courseOffering.uniqueId, e.courseOffering.subjectArea.subjectAreaAbbreviation || ' ' || e.courseOffering.courseNbr, s.uniqueId";
        String from = "StudentClassEnrollment e inner join e.student s inner join s.areaClasfMajors a inner join a.major m";
        String where = "s.session.uniqueId = :sessionId and a.academicArea.uniqueId = :areaId";
        if (majors.isEmpty()) {
            if (!multipleMajors) {
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue()).setCacheable(true).list();
            }
        } else if (!multipleMajors || majors.size() == 1) {
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.uniqueId in :majorIds").setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue()).setParameterList("majorIds", majors).setCacheable(true).list();
        } else {
            HashMap<String, Long> params = new HashMap<String, Long>();
            int idx = 0;
            for (Long l : majors) {
                if (idx == 0) {
                    where = where + " and m.uniqueId = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.uniqueId = :areaId and a" + idx + ".major.uniqueId = :m" + idx;
                }
                params.put("m" + idx, l);
                ++idx;
            }
            org.hibernate.Query q = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue());
            for (Map.Entry entry : params.entrySet()) {
                q.setLong((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
            lines = q.setCacheable(true).list();
        }
        Hashtable<Long, Hashtable<CurriculumInterface.CourseInterface, Set<Long>>> clasf2course2enrl = new Hashtable<Long, Hashtable<CurriculumInterface.CourseInterface, Set<Long>>>();
        if (lines != null) {
            for (Object[] o : lines) {
                Set<Long> students;
                Long l = (Long)o[0];
                Long l2 = (Long)o[1];
                String courseName = (String)o[2];
                Long studentId = (Long)o[3];
                CurriculumInterface.CourseInterface course = new CurriculumInterface.CourseInterface();
                course.setId(l2);
                course.setCourseName(courseName);
                Hashtable<CurriculumInterface.CourseInterface, Set<Long>> course2enrl = clasf2course2enrl.get(l);
                if (course2enrl == null) {
                    course2enrl = new Hashtable();
                    clasf2course2enrl.put(l, course2enrl);
                }
                if ((students = course2enrl.get(course)) == null) {
                    students = new HashSet<Long>();
                    course2enrl.put(course, students);
                }
                students.add(studentId);
            }
        }
        return clasf2course2enrl;
    }

    private Hashtable<String, Hashtable<String, Hashtable<Long, Integer>>> loadClasfMajorCourse2ll(Session hibSession, Curriculum c) {
        String select = "f.code, m.code, co.uniqueId, count(distinct s)";
        String from = "CourseOffering co, LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors a inner join a.academicClassification f inner join a.major m";
        String[] checks = new String[]{"x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.courseNbr=x.courseNbr", "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.demandOffering.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.demandOffering.courseNbr=x.courseNbr"};
        String group = "f.code, m.code, co.uniqueId";
        Hashtable<String, Hashtable<String, Hashtable<Long, Integer>>> clasfMajor2course2ll = new Hashtable<String, Hashtable<String, Hashtable<Long, Integer>>>();
        for (String where : checks) {
            List lines = null;
            if (c.getMajors().isEmpty()) {
                if (!c.isMultipleMajors().booleanValue()) {
                    select = "f.code, '', co.uniqueId, count(distinct s)";
                    group = "f.code, co.uniqueId";
                    lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setString("acadAbbv", c.getAcademicArea().getAcademicAreaAbbreviation()).setCacheable(true).list();
                }
            } else if (!c.isMultipleMajors().booleanValue() || c.getMajors().size() == 1) {
                ArrayList<String> majorCodes = new ArrayList<String>();
                for (PosMajor posMajor : c.getMajors()) {
                    majorCodes.add(posMajor.getCode());
                }
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.code in :majorCodes group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setString("acadAbbv", c.getAcademicArea().getAcademicAreaAbbreviation()).setParameterList("majorCodes", majorCodes).setCacheable(true).list();
            } else {
                Object major22;
                select = "f.code, '', co.uniqueId, count(distinct s)";
                group = "f.code, co.uniqueId";
                HashMap<String, String> params = new HashMap<String, String>();
                int idx = 0;
                for (Object major22 : c.getMajors()) {
                    if (idx == 0) {
                        where = where + " and m.code = :m" + idx;
                    } else {
                        from = from + " inner join s.areaClasfMajors a" + idx;
                        where = where + " and a" + idx + ".academicArea.academicAreaAbbreviation = :acadAbbv and a" + idx + ".major.code = :m" + idx;
                    }
                    params.put("m" + idx, ((BasePosMajor)major22).getCode());
                    ++idx;
                }
                org.hibernate.Query query = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setString("acadAbbv", c.getAcademicArea().getAcademicAreaAbbreviation());
                major22 = params.entrySet().iterator();
                while (major22.hasNext()) {
                    Map.Entry entry = (Map.Entry)major22.next();
                    query.setString((String)entry.getKey(), (String)entry.getValue());
                }
                lines = query.setCacheable(true).list();
            }
            if (lines == null) continue;
            for (Object[] o : lines) {
                Hashtable<Long, Integer> course2enrl;
                String string = (String)o[0];
                if (string == null) continue;
                String majorCode = (String)o[1];
                if (majorCode == null) {
                    majorCode = "";
                }
                Long l = (Long)o[2];
                int enrl = ((Number)o[3]).intValue();
                Hashtable<String, Hashtable<Long, Integer>> major2course2ll = clasfMajor2course2ll.get(string);
                if (major2course2ll == null) {
                    major2course2ll = new Hashtable();
                    clasfMajor2course2ll.put(string, major2course2ll);
                }
                if ((course2enrl = major2course2ll.get(majorCode)) == null) {
                    course2enrl = new Hashtable();
                    major2course2ll.put(majorCode, course2enrl);
                }
                course2enrl.put(l, enrl);
            }
        }
        return clasfMajor2course2ll;
    }

    private Hashtable<String, Hashtable<CurriculumInterface.CourseInterface, HashMap<String, Set<Long>>>> loadClasfCourseMajor2ll(Session hibSession, String acadAreaAbbv, Collection<PosMajor> majors, boolean multipleMajors) {
        String select = "f.code, co.uniqueId, co.subjectArea.subjectAreaAbbreviation || ' ' || co.courseNbr, m.code, s.uniqueId";
        String from = "CourseOffering co, LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors a inner join a.academicClassification f inner join a.major m";
        String[] checks = new String[]{"x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.courseNbr=x.courseNbr", "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.demandOffering.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.demandOffering.courseNbr=x.courseNbr"};
        Hashtable<String, Hashtable<CurriculumInterface.CourseInterface, HashMap<String, Set<Long>>>> clasf2course2ll = new Hashtable<String, Hashtable<CurriculumInterface.CourseInterface, HashMap<String, Set<Long>>>>();
        for (String where : checks) {
            List lines = new ArrayList();
            if (majors.isEmpty()) {
                if (!multipleMajors) {
                    select = "f.code, co.uniqueId, co.subjectArea.subjectAreaAbbreviation || ' ' || co.courseNbr, '', s.uniqueId";
                    lines = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setString("acadAbbv", acadAreaAbbv).setCacheable(true).list();
                }
            } else if (!multipleMajors || majors.size() == 1) {
                ArrayList<String> codes = new ArrayList<String>();
                for (PosMajor posMajor : majors) {
                    codes.add(posMajor.getCode());
                }
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.code in :majorCodes").setLong("sessionId", this.getAcademicSessionId().longValue()).setString("acadAbbv", acadAreaAbbv).setParameterList("majorCodes", codes).setCacheable(true).list();
            } else {
                Object major22;
                select = "f.code, co.uniqueId, co.subjectArea.subjectAreaAbbreviation || ' ' || co.courseNbr, '', s.uniqueId";
                HashMap<String, String> params = new HashMap<String, String>();
                int idx = 0;
                for (Object major22 : majors) {
                    if (idx == 0) {
                        where = where + " and m.code = :m" + idx;
                    } else {
                        from = from + " inner join s.areaClasfMajors a" + idx;
                        where = where + " and a" + idx + ".academicArea.academicAreaAbbreviation = :acadAbbv and a" + idx + ".major.code = :m" + idx;
                    }
                    params.put("m" + idx, ((BasePosMajor)major22).getCode());
                    ++idx;
                }
                org.hibernate.Query query = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setString("acadAbbv", acadAreaAbbv);
                major22 = params.entrySet().iterator();
                while (major22.hasNext()) {
                    Map.Entry entry = (Map.Entry)major22.next();
                    query.setString((String)entry.getKey(), (String)entry.getValue());
                }
                lines = query.setCacheable(true).list();
            }
            if (lines == null) continue;
            for (Object[] o : lines) {
                HashMap<String, Set<Long>> major2students;
                String string = (String)o[0];
                Long courseId = (Long)o[1];
                String string2 = (String)o[2];
                String majorCode = (String)o[3];
                if (majorCode == null) {
                    majorCode = "";
                }
                Long studentId = (Long)o[4];
                CurriculumInterface.CourseInterface course = new CurriculumInterface.CourseInterface();
                course.setId(courseId);
                course.setCourseName(string2);
                Hashtable<CurriculumInterface.CourseInterface, HashMap<String, Set<Long>>> course2ll = clasf2course2ll.get(string);
                if (course2ll == null) {
                    course2ll = new Hashtable();
                    clasf2course2ll.put(string, course2ll);
                }
                if ((major2students = course2ll.get(course)) == null) {
                    major2students = new HashMap();
                    course2ll.put(course, major2students);
                }
                if (multipleMajors && majors.size() > 1) {
                    for (PosMajor major : majors) {
                        Set<Long> students = major2students.get(major.getCode());
                        if (students == null) {
                            students = new HashSet<Long>();
                            major2students.put(major.getCode(), students);
                        }
                        students.add(studentId);
                    }
                    continue;
                }
                Set<Long> students = major2students.get(majorCode);
                if (students == null) {
                    students = new HashSet<Long>();
                    major2students.put(majorCode, students);
                }
                students.add(studentId);
            }
        }
        return clasf2course2ll;
    }

    private Map<Long, Map<Long, Map<Long, Set<Long>>>> loadAreaMajorClasf2enrl(Session hibSession, Long courseOfferingId) {
        HashMap<Long, Map<Long, Map<Long, Set<Long>>>> area2major2clasf2enrl = new HashMap<Long, Map<Long, Map<Long, Set<Long>>>>();
        for (Object[] o : hibSession.createQuery("select distinct a.academicArea.uniqueId, m.uniqueId, a.academicClassification.uniqueId, e.student.uniqueId from StudentClassEnrollment e inner join e.student.areaClasfMajors a left outer join a.major m where e.courseOffering.uniqueId = :courseId").setLong("courseId", courseOfferingId.longValue()).setCacheable(true).list()) {
            HashSet<Long> enrl;
            HashMap<Long, HashSet<Long>> clasf2enrl;
            Long areaId = (Long)o[0];
            Long majorId = (Long)o[1];
            if (majorId == null) {
                majorId = -1L;
            }
            Long clasfId = (Long)o[2];
            Long studentId = (Long)o[3];
            HashMap major2clasf2enrl = (HashMap)area2major2clasf2enrl.get(areaId);
            if (major2clasf2enrl == null) {
                major2clasf2enrl = new HashMap();
                area2major2clasf2enrl.put(areaId, major2clasf2enrl);
            }
            if ((clasf2enrl = (HashMap<Long, HashSet<Long>>)major2clasf2enrl.get(majorId)) == null) {
                clasf2enrl = new HashMap<Long, HashSet<Long>>();
                major2clasf2enrl.put(majorId, clasf2enrl);
            }
            if ((enrl = (HashSet<Long>)clasf2enrl.get(clasfId)) == null) {
                enrl = new HashSet<Long>();
                clasf2enrl.put(clasfId, enrl);
            }
            enrl.add(studentId);
        }
        return area2major2clasf2enrl;
    }

    private Map<String, Map<String, Map<String, Set<Long>>>> loadAreaMajorClasf2ll(Session hibSession, Long courseOfferingId) {
        String[] checks;
        HashMap<String, Map<String, Map<String, Set<Long>>>> area2major2clasf2ll = new HashMap<String, Map<String, Map<String, Set<Long>>>>();
        for (String where : checks = new String[]{"x.subjectArea.session.uniqueId = :sessionId and co.uniqueId = :courseId and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and co.uniqueId = :courseId and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.courseNbr=x.courseNbr", "x.subjectArea.session.uniqueId = :sessionId and co.uniqueId = :courseId and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.demandOffering.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and co.uniqueId = :courseId and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.demandOffering.courseNbr=x.courseNbr"}) {
            for (Object[] o : hibSession.createQuery("select distinct r.academicAreaAbbreviation, m.code, f.code, s.uniqueId from LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors a left outer join a.major m inner join a.academicClassification f inner join a.academicArea r, CourseOffering co where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("courseId", courseOfferingId.longValue()).setCacheable(true).list()) {
                HashSet<Long> ll;
                HashMap<String, HashSet<Long>> clasf2ll;
                String areaAbbv = (String)o[0];
                String majorCode = (String)o[1];
                if (majorCode == null) {
                    majorCode = "";
                }
                String clasfCode = (String)o[2];
                Long studentId = (Long)o[3];
                HashMap major2clasf2ll = (HashMap)area2major2clasf2ll.get(areaAbbv);
                if (major2clasf2ll == null) {
                    major2clasf2ll = new HashMap();
                    area2major2clasf2ll.put(areaAbbv, major2clasf2ll);
                }
                if ((clasf2ll = (HashMap<String, HashSet<Long>>)major2clasf2ll.get(majorCode)) == null) {
                    clasf2ll = new HashMap<String, HashSet<Long>>();
                    major2clasf2ll.put(majorCode, clasf2ll);
                }
                if ((ll = (HashSet<Long>)clasf2ll.get(clasfCode)) == null) {
                    ll = new HashSet<Long>();
                    clasf2ll.put(clasfCode, ll);
                }
                ll.add(studentId);
            }
        }
        return area2major2clasf2ll;
    }

    private Hashtable<String, Hashtable<String, Hashtable<String, Integer>>> loadAreaMajorClasf2ll(Session hibSession) {
        Hashtable<String, Hashtable<String, Hashtable<String, Integer>>> area2major2clasf2ll = new Hashtable<String, Hashtable<String, Hashtable<String, Integer>>>();
        for (Object[] o : hibSession.createQuery("select a.academicAreaAbbreviation, m.code, f.code, count(distinct s) from LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors ac inner join ac.academicClassification f inner join ac.academicArea a inner join ac.major m where x.subjectArea.session.uniqueId = :sessionId group by a.academicAreaAbbreviation, m.code, f.code").setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list()) {
            Hashtable<String, Integer> clasf2ll;
            String area = (String)o[0];
            String major = (String)o[1];
            String clasf = (String)o[2];
            int students = ((Number)o[3]).intValue();
            Hashtable<String, Hashtable<String, Integer>> majorClasf2ll = area2major2clasf2ll.get(area);
            if (majorClasf2ll == null) {
                majorClasf2ll = new Hashtable();
                area2major2clasf2ll.put(area, majorClasf2ll);
            }
            if ((clasf2ll = majorClasf2ll.get(major)) == null) {
                clasf2ll = new Hashtable();
                majorClasf2ll.put(major, clasf2ll);
            }
            clasf2ll.put(clasf, students);
        }
        return area2major2clasf2ll;
    }

    private Map<Long, Map<String, Map<String, Map<String, Set<Long>>>>> loadCourseAreaMajorClasf2ll(Session hibSession) {
        String[] checks;
        HashMap<Long, Map<String, Map<String, Map<String, Set<Long>>>>> course2area2major2clasf2ll = new HashMap<Long, Map<String, Map<String, Map<String, Set<Long>>>>>();
        for (String where : checks = new String[]{"x.subjectArea.session.uniqueId = :sessionId and co.subjectArea.session.uniqueId = :sessionId and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and co.subjectArea.session.uniqueId = :sessionId and co.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.courseNbr=x.courseNbr", "x.subjectArea.session.uniqueId = :sessionId and co.subjectArea.session.uniqueId = :sessionId and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is not null and co.demandOffering.permId=x.coursePermId", "x.subjectArea.session.uniqueId = :sessionId and co.subjectArea.session.uniqueId = :sessionId and co.demandOffering.subjectArea.uniqueId = x.subjectArea.uniqueId and x.coursePermId is null and co.demandOffering.courseNbr=x.courseNbr"}) {
            for (Object[] o : hibSession.createQuery("select distinct co.uniqueId, r.academicAreaAbbreviation, m.code, f.code, s.uniqueId from LastLikeCourseDemand x inner join x.student s inner join s.areaClasfMajors a inner join a.major m inner join a.academicClassification f inner join a.academicArea r, CourseOffering co where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list()) {
                HashSet<Long> ll;
                HashMap<String, HashSet<Long>> clasf2ll;
                HashMap major2clasf2ll;
                Long courseId = (Long)o[0];
                String areaAbbv = (String)o[1];
                String majorCode = (String)o[2];
                if (majorCode == null) {
                    majorCode = "";
                }
                String clasfCode = (String)o[3];
                Long studentId = (Long)o[4];
                HashMap area2major2clasf2ll = (HashMap)course2area2major2clasf2ll.get(courseId);
                if (area2major2clasf2ll == null) {
                    area2major2clasf2ll = new HashMap();
                    course2area2major2clasf2ll.put(courseId, area2major2clasf2ll);
                }
                if ((major2clasf2ll = (HashMap)area2major2clasf2ll.get(areaAbbv)) == null) {
                    major2clasf2ll = new HashMap();
                    area2major2clasf2ll.put(areaAbbv, major2clasf2ll);
                }
                if ((clasf2ll = (HashMap<String, HashSet<Long>>)major2clasf2ll.get(majorCode)) == null) {
                    clasf2ll = new HashMap<String, HashSet<Long>>();
                    major2clasf2ll.put(majorCode, clasf2ll);
                }
                if ((ll = (HashSet<Long>)clasf2ll.get(clasfCode)) == null) {
                    ll = new HashSet<Long>();
                    clasf2ll.put(clasfCode, ll);
                }
                ll.add(studentId);
            }
        }
        return course2area2major2clasf2ll;
    }

    private Hashtable<Long, Integer> loadClasf2req(Session hibSession, Curriculum c) {
        List lines = null;
        String select = "a.academicClassification.uniqueId, count(distinct s)";
        String from = "CourseRequest r inner join r.courseDemand.student s inner join s.areaClasfMajors a inner join a.major m";
        String where = "s.session.uniqueId = :sessionId and a.academicArea.uniqueId = :areaId";
        String group = "a.academicClassification.uniqueId";
        if (c.getMajors().isEmpty()) {
            if (!c.isMultipleMajors().booleanValue()) {
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue()).setCacheable(true).list();
            }
        } else if (!c.isMultipleMajors().booleanValue() || c.getMajors().size() == 1) {
            ArrayList<Long> majorIds = new ArrayList<Long>();
            for (PosMajor posMajor : c.getMajors()) {
                majorIds.add(posMajor.getUniqueId());
            }
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.uniqueId in :majorIds  group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue()).setParameterList("majorIds", majorIds).setCacheable(true).list();
        } else {
            HashMap<String, Long> params = new HashMap<String, Long>();
            int idx = 0;
            for (PosMajor posMajor : c.getMajors()) {
                if (idx == 0) {
                    where = where + " and m.uniqueId = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.uniqueId = :areaId and a" + idx + ".major.uniqueId = :m" + idx;
                }
                params.put("m" + idx, posMajor.getUniqueId());
                ++idx;
            }
            org.hibernate.Query query = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue());
            for (Map.Entry entry : params.entrySet()) {
                query.setLong((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
            lines = query.setCacheable(true).list();
        }
        Hashtable<Long, Integer> clasf2enrl = new Hashtable<Long, Integer>();
        if (lines != null) {
            for (Object[] objectArray : lines) {
                Long l = (Long)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                if (l == null) continue;
                clasf2enrl.put(l, n);
            }
        }
        return clasf2enrl;
    }

    private Hashtable<Long, Set<Long>> loadClasf2req(Session hibSession, Long acadAreaId, Collection<Long> majors, boolean multipleMajors) {
        List lines = null;
        String select = "a.academicClassification.uniqueId, s.uniqueId";
        String from = "CourseRequest r inner join r.courseDemand.student s inner join s.areaClasfMajors a inner join a.major m";
        String where = "s.session.uniqueId = :sessionId and a.academicArea.uniqueId = :areaId";
        if (majors.isEmpty()) {
            if (!multipleMajors) {
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue()).setCacheable(true).list();
            }
        } else if (!multipleMajors || majors.size() == 1) {
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.uniqueId in :majorIds").setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue()).setParameterList("majorIds", majors).setCacheable(true).list();
        } else {
            HashMap<String, Long> params = new HashMap<String, Long>();
            int idx = 0;
            for (Long l : majors) {
                if (idx == 0) {
                    where = where + " and m.uniqueId = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.uniqueId = :areaId and a" + idx + ".major.uniqueId = :m" + idx;
                }
                params.put("m" + idx, l);
                ++idx;
            }
            org.hibernate.Query q = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue());
            for (Map.Entry entry : params.entrySet()) {
                q.setLong((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
            lines = q.setCacheable(true).list();
        }
        Hashtable<Long, Set<Long>> clasf2enrl = new Hashtable<Long, Set<Long>>();
        if (lines != null) {
            for (Object[] o : lines) {
                Long l = (Long)o[0];
                Long l2 = (Long)o[1];
                Set<Long> students = clasf2enrl.get(l);
                if (students == null) {
                    students = new HashSet<Long>();
                    clasf2enrl.put(l, students);
                }
                students.add(l2);
            }
        }
        return clasf2enrl;
    }

    private Hashtable<Long, Hashtable<Long, Integer>> loadClasfCourse2req(Session hibSession, Curriculum c) {
        List lines = null;
        String select = "a.academicClassification.uniqueId, r.courseOffering.uniqueId, count(distinct s)";
        String from = "CourseRequest r inner join r.courseDemand.student s inner join s.areaClasfMajors a inner join a.major m";
        String where = "s.session.uniqueId = :sessionId and a.academicArea.uniqueId = :areaId";
        String group = "a.academicClassification.uniqueId, r.courseOffering.uniqueId";
        if (c.getMajors().isEmpty()) {
            if (!c.isMultipleMajors().booleanValue()) {
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue()).setCacheable(true).list();
            }
        } else if (!c.isMultipleMajors().booleanValue() || c.getMajors().size() == 1) {
            ArrayList<Long> majorIds = new ArrayList<Long>();
            for (PosMajor posMajor : c.getMajors()) {
                majorIds.add(posMajor.getUniqueId());
            }
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.uniqueId in :majorIds group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue()).setParameterList("majorIds", majorIds).setCacheable(true).list();
        } else {
            HashMap<String, Long> params = new HashMap<String, Long>();
            int idx = 0;
            for (PosMajor posMajor : c.getMajors()) {
                if (idx == 0) {
                    where = where + " and m.uniqueId = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a" + idx + ".academicArea.uniqueId = :areaId and a" + idx + ".major.uniqueId = :m" + idx;
                }
                params.put("m" + idx, posMajor.getUniqueId());
                ++idx;
            }
            org.hibernate.Query query = hibSession.createQuery("select " + select + " from " + from + " where " + where + " group by " + group).setLong("sessionId", c.getAcademicArea().getSessionId().longValue()).setLong("areaId", c.getAcademicArea().getUniqueId().longValue());
            for (Map.Entry entry : params.entrySet()) {
                query.setLong((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
            lines = query.setCacheable(true).list();
        }
        Hashtable<Long, Hashtable<Long, Integer>> clasf2course2enrl = new Hashtable<Long, Hashtable<Long, Integer>>();
        if (lines != null) {
            for (Object[] objectArray : lines) {
                Long l = (Long)objectArray[0];
                if (l == null) continue;
                Long l2 = (Long)objectArray[1];
                int enrl = ((Number)objectArray[2]).intValue();
                Hashtable<Long, Integer> course2enrl = clasf2course2enrl.get(l);
                if (course2enrl == null) {
                    course2enrl = new Hashtable();
                    clasf2course2enrl.put(l, course2enrl);
                }
                course2enrl.put(l2, enrl);
            }
        }
        return clasf2course2enrl;
    }

    private Hashtable<Long, Hashtable<CurriculumInterface.CourseInterface, Set<Long>>> loadClasfCourse2req(Session hibSession, Long acadAreaId, Collection<Long> majors, boolean multipleMajors) {
        List lines = null;
        String select = "a.academicClassification.uniqueId, r.courseOffering.uniqueId, r.courseOffering.subjectArea.subjectAreaAbbreviation || ' ' || r.courseOffering.courseNbr, s.uniqueId";
        String from = "CourseRequest r inner join r.courseDemand.student s inner join s.areaClasfMajors a inner join a.major m";
        String where = "s.session.uniqueId = :sessionId and a.academicArea.uniqueId = :areaId";
        if (majors.isEmpty()) {
            if (!multipleMajors) {
                lines = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue()).setCacheable(true).list();
            }
        } else if (!multipleMajors || majors.size() == 1) {
            lines = hibSession.createQuery("select " + select + " from " + from + " where " + where + " and m.uniqueId in :majorIds").setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue()).setParameterList("majorIds", majors).setCacheable(true).list();
        } else {
            HashMap<String, Long> params = new HashMap<String, Long>();
            int idx = 0;
            for (Long l : majors) {
                if (idx == 0) {
                    where = where + " and m.uniqueId = :m" + idx;
                } else {
                    from = from + " inner join s.areaClasfMajors a" + idx;
                    where = where + " and a.academicArea.uniqueId = :areaId and a" + idx + ".major.uniqueId = :m" + idx;
                }
                params.put("m" + idx, l);
                ++idx;
            }
            org.hibernate.Query q = hibSession.createQuery("select " + select + " from " + from + " where " + where).setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("areaId", acadAreaId.longValue());
            for (Map.Entry entry : params.entrySet()) {
                q.setLong((String)entry.getKey(), ((Long)entry.getValue()).longValue());
            }
            lines = q.setCacheable(true).list();
        }
        Hashtable<Long, Hashtable<CurriculumInterface.CourseInterface, Set<Long>>> clasf2course2enrl = new Hashtable<Long, Hashtable<CurriculumInterface.CourseInterface, Set<Long>>>();
        if (lines != null) {
            for (Object[] o : lines) {
                Set<Long> students;
                Long l = (Long)o[0];
                Long l2 = (Long)o[1];
                String courseName = (String)o[2];
                Long studentId = (Long)o[3];
                CurriculumInterface.CourseInterface course = new CurriculumInterface.CourseInterface();
                course.setId(l2);
                course.setCourseName(courseName);
                Hashtable<CurriculumInterface.CourseInterface, Set<Long>> course2enrl = clasf2course2enrl.get(l);
                if (course2enrl == null) {
                    course2enrl = new Hashtable();
                    clasf2course2enrl.put(l, course2enrl);
                }
                if ((students = course2enrl.get(course)) == null) {
                    students = new HashSet<Long>();
                    course2enrl.put(course, students);
                }
                students.add(studentId);
            }
        }
        return clasf2course2enrl;
    }

    private Map<Long, Map<Long, Map<Long, Set<Long>>>> loadAreaMajorClasf2req(Session hibSession, Long courseOfferingId) {
        HashMap<Long, Map<Long, Map<Long, Set<Long>>>> area2major2clasf2enrl = new HashMap<Long, Map<Long, Map<Long, Set<Long>>>>();
        for (Object[] o : hibSession.createQuery("select distinct a.academicArea.uniqueId, m.uniqueId, a.academicClassification.uniqueId, s.uniqueId from CourseRequest r inner join r.courseDemand.student s inner join s.areaClasfMajors a inner join a.major m where r.courseOffering.uniqueId = :courseId").setLong("courseId", courseOfferingId.longValue()).setCacheable(true).list()) {
            HashSet<Long> enrl;
            HashMap<Long, HashSet<Long>> clasf2enrl;
            Long areaId = (Long)o[0];
            Long majorId = (Long)o[1];
            if (majorId == null) {
                majorId = -1L;
            }
            Long clasfId = (Long)o[2];
            Long studentId = (Long)o[3];
            HashMap major2clasf2enrl = (HashMap)area2major2clasf2enrl.get(areaId);
            if (major2clasf2enrl == null) {
                major2clasf2enrl = new HashMap();
                area2major2clasf2enrl.put(areaId, major2clasf2enrl);
            }
            if ((clasf2enrl = (HashMap<Long, HashSet<Long>>)major2clasf2enrl.get(majorId)) == null) {
                clasf2enrl = new HashMap<Long, HashSet<Long>>();
                major2clasf2enrl.put(majorId, clasf2enrl);
            }
            if ((enrl = (HashSet<Long>)clasf2enrl.get(clasfId)) == null) {
                enrl = new HashSet<Long>();
                clasf2enrl.put(clasfId, enrl);
            }
            enrl.add(studentId);
        }
        return area2major2clasf2enrl;
    }

    private CourseOffering getCourse(Session hibSession, String courseName) {
        Iterator iterator = hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course").setString("course", courseName.toLowerCase()).setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).setMaxResults(1).list().iterator();
        if (iterator.hasNext()) {
            CourseOffering co = (CourseOffering)iterator.next();
            return co;
        }
        return null;
    }

    private boolean hasSnapshotData(Session hibSession, Long sessionId) {
        Long cnt = (Long)hibSession.createQuery("select count(1) from InstructionalOffering io where io.snapshotLimitDate is not null and io.session.uniqueId = :sessId").setLong("sessId", sessionId.longValue()).setCacheable(true).uniqueResult();
        return cnt > 0L;
    }

    private Hashtable<String, HashMap<String, Float>> getRules(Session hibSession, Long acadAreaId) {
        Hashtable<String, HashMap<String, Float>> clasf2major2proj = new Hashtable<String, HashMap<String, Float>>();
        for (CurriculumProjectionRule rule : hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.uniqueId=:acadAreaId").setLong("acadAreaId", acadAreaId.longValue()).setCacheable(true).list()) {
            String majorCode = rule.getMajor() == null ? "" : rule.getMajor().getCode();
            String clasfCode = rule.getAcademicClassification().getCode();
            Float projection = rule.getProjection();
            HashMap<String, Float> major2proj = clasf2major2proj.get(clasfCode);
            if (major2proj == null) {
                major2proj = new HashMap();
                clasf2major2proj.put(clasfCode, major2proj);
            }
            major2proj.put(majorCode, projection);
        }
        return clasf2major2proj;
    }

    private Hashtable<String, Hashtable<String, HashMap<String, Float>>> getRules(Session hibSession) {
        Hashtable<String, Hashtable<String, HashMap<String, Float>>> area2clasf2major2proj = new Hashtable<String, Hashtable<String, HashMap<String, Float>>>();
        for (CurriculumProjectionRule rule : hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.session.uniqueId = :sessionId").setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list()) {
            HashMap<String, Float> major2proj;
            String areaAbbv = rule.getAcademicArea().getAcademicAreaAbbreviation();
            String majorCode = rule.getMajor() == null ? "" : rule.getMajor().getCode();
            String clasfCode = rule.getAcademicClassification().getCode();
            Float projection = rule.getProjection();
            Hashtable<String, HashMap<String, Float>> clasf2major2proj = area2clasf2major2proj.get(areaAbbv);
            if (clasf2major2proj == null) {
                clasf2major2proj = new Hashtable();
                area2clasf2major2proj.put(areaAbbv, clasf2major2proj);
            }
            if ((major2proj = clasf2major2proj.get(clasfCode)) == null) {
                major2proj = new HashMap();
                clasf2major2proj.put(clasfCode, major2proj);
            }
            major2proj.put(majorCode, projection);
        }
        return area2clasf2major2proj;
    }

    private Hashtable<String, HashMap<String, Float>> getSnapshotRules(Session hibSession, Long acadAreaId) {
        Hashtable<String, HashMap<String, Float>> clasf2major2ssproj = new Hashtable<String, HashMap<String, Float>>();
        if (this.hasSnapshotData(hibSession, this.getAcademicSessionId())) {
            for (CurriculumProjectionRule rule : hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.uniqueId=:acadAreaId").setLong("acadAreaId", acadAreaId.longValue()).setCacheable(true).list()) {
                String majorCode = rule.getMajor() == null ? "" : rule.getMajor().getCode();
                String clasfCode = rule.getAcademicClassification().getCode();
                Float snapshotProjection = rule.getSnapshotProjection();
                HashMap<String, Float> major2ssproj = clasf2major2ssproj.get(clasfCode);
                if (major2ssproj == null) {
                    major2ssproj = new HashMap();
                    clasf2major2ssproj.put(clasfCode, major2ssproj);
                }
                major2ssproj.put(majorCode, snapshotProjection);
            }
        }
        return clasf2major2ssproj;
    }

    public float getProjection(Hashtable<String, HashMap<String, Float>> clasf2major2proj, String majorCode, String clasfCode) {
        if (clasf2major2proj == null || clasf2major2proj.isEmpty()) {
            return 1.0f;
        }
        HashMap<String, Float> major2proj = clasf2major2proj.get(clasfCode);
        if (major2proj == null) {
            return 1.0f;
        }
        Float projection = major2proj.get(majorCode);
        if (projection == null) {
            projection = major2proj.get("");
        }
        return projection == null ? 1.0f : projection.floatValue();
    }

    public float getSnapshotProjection(Hashtable<String, HashMap<String, Float>> clasf2major2ssproj, String majorCode, String clasfCode) {
        if (clasf2major2ssproj == null || clasf2major2ssproj.isEmpty()) {
            return 1.0f;
        }
        HashMap<String, Float> major2ssproj = clasf2major2ssproj.get(clasfCode);
        if (major2ssproj == null) {
            return 1.0f;
        }
        Float snapshotProjection = major2ssproj.get(majorCode);
        if (snapshotProjection == null) {
            snapshotProjection = major2ssproj.get("");
        }
        return snapshotProjection == null ? 1.0f : snapshotProjection.floatValue();
    }
}

