/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFactory;
import org.unitime.timetable.gwt.client.widgets.CourseSelection;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.FreeTimeParser;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.Validator;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequestBox
extends P
implements CourseSelection {
    protected static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private CourseRequestFilterBox iFilter;
    private HTML iError;
    private Map<String, ClassAssignmentInterface.CourseAssignment> iValidCourseNames = new HashMap<String, ClassAssignmentInterface.CourseAssignment>();
    private DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> iDataProvider;
    private DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>> iSectionProvider;
    private FreeTimeParser iFreeTimeParser = null;
    private CourseFinder iCourseFinder = null;
    private CourseFinderFactory iCourseFinderFactory = null;
    private List<Validator<CourseSelection>> iValidators = new ArrayList<Validator<CourseSelection>>();
    private boolean iShowCourses = false;
    private CourseRequestInterface.RequestedCourse iLastCourse = null;
    private SpecialRegistrationInterface.SpecialRegistrationContext iSpecReg;
    private boolean iCanDelete = true;

    public CourseRequestBox() {
        this(false, null);
    }

    public CourseRequestBox(boolean showCourses) {
        this(showCourses, null);
    }

    public CourseRequestBox(boolean showCourses, SpecialRegistrationInterface.SpecialRegistrationContext specreg) {
        super("unitime-CourseRequestBox");
        this.iShowCourses = showCourses;
        this.iSpecReg = specreg;
        this.iFilter = new CourseRequestFilterBox(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CourseRequestBox.this.openDialogAsync();
            }
        }){

            protected void applySuggestion(FilterBox.Suggestion suggestion) {
                if (suggestion instanceof CourseSuggestion) {
                    CourseRequestBox.this.setValue(((CourseSuggestion)suggestion).getRequestedCourse());
                } else {
                    super.applySuggestion(suggestion);
                }
            }
        };
        this.add((Widget)this.iFilter);
        this.iFilter.addFilter(new FilterBox.StaticSimpleFilter("method", MESSAGES.tagInstructionalMethod(), new String[0]));
        this.iFilter.addFilter(new FilterBox.StaticSimpleFilter("section", MESSAGES.tagSection(), new String[0]));
        this.iFilter.setSuggestionsProvider(new FilterBox.SuggestionsProvider(){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, final String text, final AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.equals(CourseRequestBox.this.getHint())) {
                    return;
                }
                if (CourseRequestBox.this.iLastCourse != null && CourseRequestBox.this.iLastCourse.isCourse() && text.startsWith(CourseRequestBox.this.iLastCourse.getCourseName() + " ") && CourseRequestBox.this.iValidCourseNames.containsKey(CourseRequestBox.this.iLastCourse.getCourseName().toLowerCase())) {
                    final ClassAssignmentInterface.CourseAssignment course = (ClassAssignmentInterface.CourseAssignment)CourseRequestBox.this.iValidCourseNames.get(CourseRequestBox.this.iLastCourse.getCourseName().toLowerCase());
                    final String query = text.substring(CourseRequestBox.this.iLastCourse.getCourseName().length() + 1).trim();
                    CourseRequestBox.this.iSectionProvider.getData(course, new AsyncCallback<Collection<ClassAssignmentInterface.ClassAssignment>>(){

                        public void onFailure(Throwable caught) {
                            callback.onFailure(caught);
                        }

                        public void onSuccess(Collection<ClassAssignmentInterface.ClassAssignment> result) {
                            ArrayList<CourseSuggestion> suggestions = new ArrayList<CourseSuggestion>();
                            if (course.hasInstructionalMethods()) {
                                for (ClassAssignmentInterface.IdValue im : course.getInstructionalMethods()) {
                                    if (!im.getValue().toLowerCase().startsWith(query.toLowerCase())) continue;
                                    suggestions.add(new CourseSuggestion(course, im));
                                }
                            }
                            block1: for (ClassAssignmentInterface.ClassAssignment clazz : result) {
                                if (clazz.isCancelled() || !clazz.isSaved() && !clazz.isAvailable() && !CourseRequestBox.this.isSpecialRegistration()) continue;
                                if (clazz.getSection().toLowerCase().startsWith(query.toLowerCase()) || clazz.getSelection().toLowerCase().startsWith(query.toLowerCase())) {
                                    suggestions.add(new CourseSuggestion(course, clazz));
                                    continue;
                                }
                                if (clazz.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.arrangeHours()).toLowerCase().startsWith(query.toLowerCase())) {
                                    suggestions.add(new CourseSuggestion(course, clazz));
                                    continue;
                                }
                                if (!clazz.hasInstructors()) continue;
                                for (String instructor : clazz.getInstructors()) {
                                    if (!instructor.toLowerCase().startsWith(query.toLowerCase())) continue;
                                    suggestions.add(new CourseSuggestion(course, clazz));
                                    continue block1;
                                }
                            }
                            callback.onSuccess(suggestions);
                        }
                    });
                    return;
                }
                CourseRequestBox.this.iDataProvider.getData(text, new AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>>(){

                    public void onFailure(Throwable caught) {
                        CourseRequestBox.this.iValidCourseNames.clear();
                        if (CourseRequestBox.this.iFreeTimeParser != null) {
                            CourseRequestBox.this.iFreeTimeParser.getData(text, new AsyncCallback<List<CourseRequestInterface.FreeTime>>(){

                                public void onFailure(Throwable e) {
                                    callback.onFailure(e);
                                }

                                public void onSuccess(List<CourseRequestInterface.FreeTime> freeTimes) {
                                    String ft = CourseRequestBox.this.iFreeTimeParser.freeTimesToString(freeTimes);
                                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                                    FilterBox.Suggestion suggestion = new FilterBox.Suggestion(ft, ft, MESSAGES.hintFreeTimeRequest());
                                    suggestions.add(suggestion);
                                    callback.onSuccess(suggestions);
                                }
                            });
                        } else {
                            callback.onFailure(caught);
                        }
                    }

                    public void onSuccess(Collection<ClassAssignmentInterface.CourseAssignment> result) {
                        CourseRequestBox.this.iValidCourseNames.clear();
                        ArrayList<CourseSuggestion> suggestions = new ArrayList<CourseSuggestion>();
                        if (result != null) {
                            for (ClassAssignmentInterface.CourseAssignment course : result) {
                                CourseSuggestion suggestion = new CourseSuggestion(course);
                                suggestions.add(suggestion);
                                CourseRequestBox.this.iValidCourseNames.put(suggestion.getReplacementString().toLowerCase(), course);
                                if (course.getClassAssignments() != null) {
                                    for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                                        suggestions.add(new CourseSuggestion(course, clazz));
                                    }
                                }
                                if (result.size() > 5 || !course.hasInstructionalMethodSelection()) continue;
                                for (ClassAssignmentInterface.IdValue im : course.getInstructionalMethods()) {
                                    suggestions.add(new CourseSuggestion(course, im));
                                }
                            }
                        }
                        callback.onSuccess(suggestions);
                    }
                });
            }
        });
        this.iError = new HTML();
        this.iError.setStyleName("unitime-ErrorHint");
        this.iError.setVisible(false);
        Roles.getPresentationRole().setAriaHiddenState((Element)this.iError.getElement(), true);
        this.add((Widget)this.iError);
        this.iFilter.getValueBox().addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (CourseRequestBox.this.getText().isEmpty() && CourseRequestBox.this.iError.isVisible()) {
                    CourseRequestBox.this.iError.setVisible(false);
                }
            }
        });
        this.iFilter.getValueBox().addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (CourseRequestBox.this.iError.isVisible() && !CourseRequestBox.this.iError.getText().isEmpty()) {
                    AriaStatus.getInstance().setText(CourseRequestBox.this.iError.getText());
                }
            }
        });
        this.iFilter.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String value = CourseRequestBox.this.iFilter.getText();
                if (CourseRequestBox.this.iLastCourse == null || !CourseRequestBox.this.iLastCourse.isCourse() || !value.startsWith(CourseRequestBox.this.iLastCourse.getCourseName())) {
                    CourseRequestBox.this.iFilter.removeAllChips();
                } else if (!value.equals(CourseRequestBox.this.iLastCourse.getCourseName())) {
                    CourseRequestBox.this.iFilter.setText(CourseRequestBox.this.iLastCourse.getCourseName());
                }
                CourseRequestBox.this.iFilter.resizeFilterIfNeeded();
                CourseSelectionEvent.fire((HasHandlers)CourseRequestBox.this, CourseRequestBox.this.getValue());
            }
        });
        this.iFilter.addSelectionHandler(new SelectionHandler<FilterBox.Suggestion>(){

            public void onSelection(SelectionEvent<FilterBox.Suggestion> event) {
                CourseRequestBox.this.iLastCourse = CourseRequestBox.this.getValue();
            }
        });
    }

    protected boolean isSpecialRegistration() {
        return this.iSpecReg != null && this.iSpecReg.isSpecRegMode();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public CourseRequestInterface.RequestedCourse getValue() {
        String courseName = this.iFilter.getText().trim();
        if (courseName.isEmpty()) {
            return new CourseRequestInterface.RequestedCourse();
        }
        if (this.iLastCourse != null && this.iLastCourse.isCourse() && courseName.startsWith(this.iLastCourse.getCourseName() + " ")) {
            courseName = this.iLastCourse.getCourseName();
        }
        ClassAssignmentInterface.CourseAssignment course = this.iValidCourseNames.get(courseName.toLowerCase());
        CourseRequestInterface.RequestedCourse ret = new CourseRequestInterface.RequestedCourse();
        if (course != null) {
            ret.setCourseId(course.getCourseId());
            ret.setCourseName(course.getCourseName());
            ret.setCourseTitle(course.getTitle());
            ret.setCredit(course.guessCreditRange());
            if (this.iLastCourse != null && this.iLastCourse.isCourse() && this.iLastCourse.hasCourseId() && courseName.equalsIgnoreCase(this.iLastCourse.getCourseName())) {
                ret.setStatus(this.iLastCourse.getStatus());
                ret.setStatusNote(this.iLastCourse.getStatusNote());
                ret.setOverrideExternalId(this.iLastCourse.getOverrideExternalId());
                ret.setOverrideTimeStamp(this.iLastCourse.getOverrideTimeStamp());
            } else {
                ret.setStatus(CourseRequestInterface.RequestedCourseStatus.NEW_REQUEST);
            }
        } else if (this.iLastCourse != null && this.iLastCourse.isCourse() && this.iLastCourse.hasCourseId() && courseName.equalsIgnoreCase(this.iLastCourse.getCourseName())) {
            ret.setCourseId(this.iLastCourse.getCourseId());
            ret.setCourseName(courseName);
            ret.setCourseTitle(this.iLastCourse.getCourseTitle());
            ret.setCredit(this.iLastCourse.getCredit());
            ret.setStatus(this.iLastCourse.getStatus());
            ret.setOverrideExternalId(this.iLastCourse.getOverrideExternalId());
            ret.setOverrideTimeStamp(this.iLastCourse.getOverrideTimeStamp());
            ret.setStatusNote(this.iLastCourse.getStatusNote());
        } else if (this.iFreeTimeParser != null) {
            try {
                ret.setFreeTime(this.iFreeTimeParser.parseFreeTime(courseName));
            }
            catch (IllegalArgumentException e) {
                ret.setCourseName(courseName);
            }
        } else {
            ret.setCourseName(courseName);
        }
        for (FilterBox.Chip chip : this.iFilter.getChips("section")) {
            ret.setSelectedClass(chip.getValue(), true);
        }
        for (FilterBox.Chip chip : this.iFilter.getChips("method")) {
            ret.setSelectedIntructionalMethod(chip.getValue(), true);
        }
        if (!this.iFilter.isEnabled() && ret.isCourse()) {
            ret.setReadOnly(true);
        }
        ret.setCanDelete(this.iCanDelete);
        return ret;
    }

    public void setValue(CourseRequestInterface.RequestedCourse value) {
        this.iLastCourse = value;
        this.iFilter.removeAllChips();
        if (value == null || value.isEmpty()) {
            this.iFilter.setText("");
            this.setError(null);
            this.setEnabled(true);
            this.iCanDelete = true;
        } else {
            if (value.isCourse()) {
                this.iFilter.setText(value.getCourseName());
                if (value.hasSelectedIntructionalMethods()) {
                    for (String im : value.getSelectedIntructionalMethods()) {
                        this.iFilter.addChip(new FilterBox.Chip("method", im).withTranslatedCommand(MESSAGES.tagInstructionalMethod()), false);
                    }
                }
                if (value.hasSelectedClasses()) {
                    for (String clazz : value.getSelectedClasses()) {
                        this.iFilter.addChip(new FilterBox.Chip("section", clazz).withTranslatedCommand(MESSAGES.tagSection()), false);
                    }
                }
            } else if (value.isFreeTime() && this.iFreeTimeParser != null) {
                this.iFilter.setText(this.iFreeTimeParser.freeTimesToString(value.getFreeTime()));
            } else {
                this.iFilter.setText("");
            }
            this.setEnabled(!value.isReadOnly());
            this.iCanDelete = value.isCanDelete();
        }
        this.iFilter.resizeFilterIfNeeded();
    }

    public boolean hasValue() {
        CourseRequestInterface.RequestedCourse value = this.getValue();
        return value != null && !value.isEmpty();
    }

    public boolean isCanDelete() {
        return this.iCanDelete;
    }

    public void setValue(CourseRequestInterface.RequestedCourse value, boolean fireEvents) {
        this.setValue(value);
        if (fireEvents) {
            CourseSelectionEvent.fire((HasHandlers)this, value);
        }
    }

    @Override
    public void setHint(String hint) {
        this.iFilter.setHint(hint);
    }

    @Override
    public String getHint() {
        return this.iFilter.getHint();
    }

    public boolean isEnabled() {
        return this.iFilter.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.iFilter.setEnabled(true);
            this.iFilter.setFilterFinderFace(null);
            this.iFilter.getFilterFinderButton().setTitle(this.iFilter.getFilterFinderButton().getAltText());
        } else {
            this.iFilter.setEnabled(false);
            if (!this.getText().isEmpty()) {
                this.iFilter.setFilterFinderFace(RESOURCES.finderAssigned());
                this.iFilter.getFilterFinderButton().setTitle(MESSAGES.saved(this.getText()));
            } else {
                this.iFilter.setFilterFinderFace(null);
                this.iFilter.getFilterFinderButton().setTitle(this.iFilter.getFilterFinderButton().getAltText());
            }
        }
    }

    @Override
    public void setSuggestions(DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> provider) {
        this.iDataProvider = provider;
    }

    public void setSectionsProvider(DataProvider<ClassAssignmentInterface.CourseAssignment, Collection<ClassAssignmentInterface.ClassAssignment>> provider) {
        this.iSectionProvider = provider;
    }

    @Override
    public void setFreeTimes(FreeTimeParser parser) {
        this.iFreeTimeParser = parser;
        this.iFreeTimeParser.setValidCourseNames(this.iValidCourseNames);
    }

    @Override
    public FreeTimeParser getFreeTimes() {
        return this.iFreeTimeParser;
    }

    public boolean isAllowFreeTime() {
        return this.iFreeTimeParser != null;
    }

    @Override
    public void setCourseFinderFactory(CourseFinderFactory factory) {
        this.iCourseFinderFactory = factory;
    }

    @Override
    public CourseFinder getCourseFinder() {
        if (this.iCourseFinder == null) {
            this.iCourseFinder = this.iCourseFinderFactory.createCourseFinder();
            this.iCourseFinder.addSelectionHandler((SelectionHandler)new SelectionHandler<CourseRequestInterface.RequestedCourse>(){

                public void onSelection(SelectionEvent<CourseRequestInterface.RequestedCourse> event) {
                    if (CourseRequestBox.this.isEnabled()) {
                        CourseRequestBox.this.setValue((CourseRequestInterface.RequestedCourse)event.getSelectedItem(), true);
                    }
                }
            });
            if (this.iCourseFinder instanceof HasCloseHandlers) {
                ((HasCloseHandlers)this.iCourseFinder).addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                    public void onClose(CloseEvent<PopupPanel> event) {
                        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                            public void execute() {
                                CourseRequestBox.this.iFilter.setFocus(true);
                            }
                        });
                    }
                });
            }
        }
        return this.iCourseFinder;
    }

    @Override
    public void setLabel(String title, String finderTitle) {
        this.iFilter.setAriaLabel(title);
        this.iFilter.getFilterFinderButton().setAltText(finderTitle);
    }

    @Override
    public void hideSuggestionList() {
        this.iFilter.hideSuggestions();
    }

    @Override
    public void showSuggestionList() {
        this.iFilter.showSuggestions();
    }

    @Override
    public void setWidth(String width) {
        this.iFilter.setWidth(width);
    }

    @Override
    public void setError(String error) {
        this.iError.setStyleName("unitime-ErrorHint");
        if (error == null || error.isEmpty()) {
            this.iError.setHTML("");
            this.iError.setVisible(false);
        } else {
            this.iError.setHTML(error);
            this.iError.setVisible(true);
            this.iFilter.setStatus(error);
        }
    }

    public void setWarning(String error) {
        this.iError.setStyleName("unitime-WarningHint");
        if (error == null || error.isEmpty()) {
            this.iError.setHTML("");
            this.iError.setVisible(false);
        } else {
            this.iError.setHTML(error);
            this.iError.setVisible(true);
            this.iFilter.setStatus(error);
        }
    }

    @Override
    public String getError() {
        return this.iError.isVisible() ? this.iError.getText() : null;
    }

    public void setAccessKey(char a) {
        this.iFilter.setAccessKey(a);
    }

    public int getTabIndex() {
        return this.iFilter.getTabIndex();
    }

    public void setFocus(boolean focused) {
        this.iFilter.setFocus(focused);
        if (focused) {
            this.iFilter.getValueBox().selectAll();
        }
    }

    public void setTabIndex(int index) {
        this.iFilter.setTabIndex(index);
    }

    private void openDialogAsync() {
        GWT.runAsync((RunAsyncCallback)new RunAsyncCallback(){

            public void onSuccess() {
                CourseRequestBox.this.openDialog();
            }

            public void onFailure(Throwable reason) {
                UniTimeNotifications.error(MESSAGES.failedToLoadTheApp(reason.getMessage()));
            }
        });
    }

    private void openDialog() {
        this.getCourseFinder().setValue(this.getValue(), true);
        this.getCourseFinder().setEnabled(this.isEnabled());
        this.getCourseFinder().findCourse();
    }

    @Override
    public void addValidator(Validator<CourseSelection> validator) {
        this.iValidators.add(validator);
    }

    @Override
    public String validate() {
        block5: {
            if (this.getValue().isEmpty()) {
                this.setError(null);
                return null;
            }
            if (this.iFreeTimeParser != null) {
                try {
                    this.iFreeTimeParser.parseFreeTime(this.iFilter.getText());
                    this.setError(null);
                    return null;
                }
                catch (IllegalArgumentException e) {
                    if (!this.iFilter.getText().toLowerCase().startsWith(CONSTANTS.freePrefix().toLowerCase())) break block5;
                    this.setError(MESSAGES.invalidFreeTime());
                    return e.getMessage();
                }
            }
        }
        for (Validator<CourseSelection> validator : this.iValidators) {
            String message = validator.validate(this);
            if (message == null) continue;
            this.setError(message);
            return message;
        }
        this.setError(null);
        return null;
    }

    @Override
    public HandlerRegistration addCourseSelectionHandler(CourseSelectionHandler handler) {
        return this.addHandler(handler, CourseSelectionEvent.getType());
    }

    @Override
    public String getText() {
        return this.iFilter.getText();
    }

    @Override
    public void setText(String text) {
        this.iFilter.setValue(text);
    }

    public void addOperation(FilterOperation operation, boolean beforeFinder) {
        operation.addStyleName("button-image");
        if (beforeFinder) {
            this.iFilter.add((Widget)operation);
        } else {
            this.iFilter.insert((Widget)operation, this.iFilter.getWidgetIndex((Widget)this.iFilter.iFilterFinder));
        }
        Roles.getDocumentRole().setAriaHiddenState((Element)operation.getElement(), true);
    }

    public void addStatus(FilterOperation operation) {
        operation.addStyleName("status-image");
        this.iFilter.insert((Widget)operation, 0);
    }

    public void removeOperation(FilterOperation operation) {
        this.iFilter.remove((Widget)operation);
    }

    public void removeClearOperation() {
        this.iFilter.remove((Widget)this.iFilter.iFilterClear);
    }

    public void resizeFilterIfNeeded() {
        this.iFilter.resizeFilterIfNeeded();
    }

    public static class FilterStatus
    extends FilterOperation
    implements HasAriaLabel {
        public FilterStatus(ImageResource resource, Character accessKey) {
            super(resource, accessKey);
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    UniTimeConfirmationDialog.info(FilterStatus.this.getAltText());
                }
            });
        }

        public FilterStatus(ImageResource resource) {
            this(resource, null);
        }

        public void setStatus(ImageResource icon, String message) {
            this.setVisible(true);
            this.setResource(icon);
            this.setTitle(message);
            this.setAriaLabel(message);
        }

        public void clearStatus() {
            this.setVisible(false);
        }

        public String getAriaLabel() {
            return this.getAltText();
        }

        public void setAriaLabel(String text) {
            this.setAltText(text);
        }
    }

    public static class FilterOperation
    extends Image {
        private Character iAccessKey;

        public FilterOperation(ImageResource resource, Character accessKey) {
            super(resource);
            this.iAccessKey = accessKey;
            Roles.getDocumentRole().setAriaHiddenState((Element)this.getElement(), true);
        }

        public FilterOperation(ImageResource resource) {
            this(resource, null);
        }

        public void onBeforeResize(CourseRequestFilterBox filter) {
        }

        public Character getAccessKey() {
            return this.iAccessKey;
        }
    }

    public static class CourseRequestFilterBox
    extends FilterBox {
        private Image iFilterFinder = new Image(RESOURCES.finder());
        private String iHint = "";

        public CourseRequestFilterBox(ClickHandler finderClickHandler) {
            this.iFilterFinder.setAltText(MESSAGES.altOpenFilter());
            this.iFilterFinder.setTitle(MESSAGES.altOpenFilter());
            this.iFilterFinder.addStyleName("button-image");
            this.insert((Widget)this.iFilterFinder, this.getWidgetIndex((Widget)this.iFilterOpen));
            Roles.getDocumentRole().setAriaHiddenState((Element)this.iFilterFinder.getElement(), true);
            this.iFilterFinder.addClickHandler(finderClickHandler);
            this.iFilterClear.setAltText(MESSAGES.altClearCourseRequest());
            this.iFilterClear.setTitle(MESSAGES.altClearCourseRequest());
            this.remove((Widget)this.iFilterOpen);
            this.remove((Widget)this.iFilterClose);
            this.getValueBox().addKeyDownHandler(new KeyDownHandler(){

                public void onKeyDown(KeyDownEvent event) {
                    if (!CourseRequestFilterBox.this.isEnabled()) {
                        return;
                    }
                    if ((event.getNativeEvent().getKeyCode() == 70 || event.getNativeEvent().getKeyCode() == 102) && (event.isControlKeyDown() || event.isAltKeyDown())) {
                        CourseRequestFilterBox.this.hideSuggestions();
                        CourseRequestFilterBox.this.iFilterFinder.getElement().dispatchEvent(Document.get().createClickEvent(1, 0, 0, 0, 0, false, false, false, false));
                    } else if (event.isControlKeyDown() || event.isAltKeyDown()) {
                        for (int i = 0; i < CourseRequestFilterBox.this.getWidgetCount(); ++i) {
                            Widget w = CourseRequestFilterBox.this.getWidget(i);
                            if (!(w instanceof FilterOperation) || !w.isVisible() || ((FilterOperation)w).getAccessKey() == null || event.getNativeEvent().getKeyCode() != ((FilterOperation)w).getAccessKey().charValue()) continue;
                            w.getElement().dispatchEvent(Document.get().createClickEvent(1, 0, 0, 0, 0, false, false, false, false));
                        }
                    }
                }
            });
            this.getValueBox().addBlurHandler(new BlurHandler(){

                public void onBlur(BlurEvent event) {
                    if (CourseRequestFilterBox.this.getText().isEmpty() && !CourseRequestFilterBox.this.iHint.isEmpty()) {
                        CourseRequestFilterBox.this.iFilter.setText(CourseRequestFilterBox.this.iHint);
                        CourseRequestFilterBox.this.getValueBox().addStyleName("hint");
                    }
                }
            });
            this.getValueBox().addFocusHandler(new FocusHandler(){

                public void onFocus(FocusEvent event) {
                    if (!CourseRequestFilterBox.this.iHint.isEmpty() && CourseRequestFilterBox.this.iFilter.getText().equals(CourseRequestFilterBox.this.iHint)) {
                        CourseRequestFilterBox.this.getValueBox().removeStyleName("hint");
                        CourseRequestFilterBox.this.iFilter.setText("");
                    }
                }
            });
            this.addSelectionHandler(new SelectionHandler<FilterBox.Suggestion>(){

                public void onSelection(SelectionEvent<FilterBox.Suggestion> event) {
                    CourseRequestFilterBox.this.getValueBox().removeStyleName("hint");
                }
            });
        }

        protected void setFilterFinderFace(ImageResource face) {
            if (face == null) {
                this.iFilterFinder.setResource(RESOURCES.finder());
            } else {
                this.iFilterFinder.setResource(face);
            }
        }

        protected Image getFilterFinderButton() {
            return this.iFilterFinder;
        }

        protected void resizeFilterIfNeeded() {
            if (!this.isAttached()) {
                return;
            }
            FilterBox.ChipPanel last = this.getLastChipPanel();
            if (this.iFilterClear.isAttached()) {
                this.iFilterClear.setVisible(this.isEnabled() && (!this.getText().isEmpty() || last != null));
            }
            this.iFilterFinder.setVisible(this.isEnabled() || !this.getText().isEmpty());
            int buttonWidth = 0;
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                Widget w = this.getWidget(i);
                if (w instanceof FilterOperation) {
                    ((FilterOperation)w).onBeforeResize(this);
                }
                if (!(w instanceof Image) || !w.isAttached() || !w.isVisible()) continue;
                buttonWidth += w.getElement().getOffsetWidth() + 2;
            }
            int w = 0;
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                if (this.getWidget(i) instanceof TextBox) continue;
                w += 2 + this.getWidget(i).getOffsetWidth();
            }
            int width = this.getElement().getClientWidth() - w;
            if (width < 100) {
                width = this.getElement().getClientWidth() - buttonWidth;
            }
            this.iFilter.getElement().getStyle().setWidth((double)width, Style.Unit.PX);
            if (this.isSuggestionsShowing()) {
                this.iSuggestionsPopup.moveRelativeTo((UIObject)this);
            }
            if (this.isFilterPopupShowing()) {
                this.iFilterPopup.moveRelativeTo((UIObject)this);
            }
        }

        public void addChip(FilterBox.Chip chip, boolean fireEvents) {
            final FilterBox.ChipPanel panel = new FilterBox.ChipPanel(chip, this.getChipColor(chip));
            panel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    CourseRequestFilterBox.this.remove((Widget)panel);
                    CourseRequestFilterBox.this.resizeFilterIfNeeded();
                    CourseRequestFilterBox.this.setAriaLabel(CourseRequestFilterBox.this.toAriaString());
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestFilterBox.this, (Object)CourseRequestFilterBox.this.getValue());
                }
            });
            this.insert((Widget)panel, this.getWidgetIndex((Widget)this.iFilterFinder));
            this.resizeFilterIfNeeded();
            this.setAriaLabel(this.toAriaString());
            if (fireEvents) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
            }
        }

        public String getText() {
            return this.iFilter.getText().equals(this.iHint) ? "" : this.iFilter.getText();
        }

        public void setText(String text) {
            this.iFilter.setText(text);
            if (!this.iFocus && text.isEmpty() && !this.iHint.isEmpty()) {
                this.iFilter.setText(this.iHint);
                this.getValueBox().addStyleName("hint");
            } else {
                this.getValueBox().removeStyleName("hint");
            }
        }

        public void setHint(String hint) {
            if (this.iFilter.getText().equals(this.iHint)) {
                if (!this.iFocus) {
                    this.iFilter.setText(hint);
                    if (!hint.isEmpty()) {
                        this.getValueBox().addStyleName("hint");
                    }
                } else {
                    this.iFilter.setText("");
                    this.getValueBox().removeStyleName("hint");
                }
            }
            this.iHint = hint;
        }

        public String getHint() {
            return this.iHint;
        }
    }

    public class CourseSuggestion
    extends FilterBox.Suggestion {
        CourseRequestInterface.RequestedCourse iCourse;

        public CourseSuggestion(ClassAssignmentInterface.CourseAssignment course) {
            super(course.getCourseName(), !course.hasUniqueName() || CourseRequestBox.this.iShowCourses ? course.getCourseNameWithTitle() : course.getCourseName(), course.hasTitle() ? course.getTitle() : MESSAGES.hintCourseWithNoTitle());
            this.iCourse = null;
            this.iCourse = new CourseRequestInterface.RequestedCourse();
            this.iCourse.setCourseId(course.getCourseId());
            this.iCourse.setCourseName(!course.hasUniqueName() || CourseRequestBox.this.iShowCourses ? course.getCourseNameWithTitle() : course.getCourseName());
            this.iCourse.setCourseTitle(course.getTitle());
            this.iCourse.setCredit(course.guessCreditRange());
            if (CourseRequestBox.this.getText().equals(course.getCourseName()) || CourseRequestBox.this.getText().startsWith(course.getCourseName() + " ") || CourseRequestBox.this.getText().equals(course.getCourseNameWithTitle()) || CourseRequestBox.this.getText().startsWith(course.getCourseNameWithTitle() + " ")) {
                for (FilterBox.Chip chip : CourseRequestBox.this.iFilter.getChips("section")) {
                    this.iCourse.setSelectedClass(chip.getValue(), true);
                }
                for (FilterBox.Chip chip : CourseRequestBox.this.iFilter.getChips("method")) {
                    this.iCourse.setSelectedIntructionalMethod(chip.getValue(), true);
                }
            }
        }

        public CourseSuggestion(ClassAssignmentInterface.CourseAssignment course, ClassAssignmentInterface.IdValue im) {
            this(course);
            this.setDisplayString(course.getCourseName() + " " + im.getValue());
            this.setHint("<span class='item-hint'>" + MESSAGES.hintInstructionalMethod() + "</span>");
            if (this.iCourse.hasSelectedIntructionalMethods()) {
                this.iCourse.getSelectedIntructionalMethods().clear();
            }
            this.iCourse.setSelectedIntructionalMethod(im.getValue(), true);
        }

        public CourseSuggestion(ClassAssignmentInterface.CourseAssignment course, ClassAssignmentInterface.ClassAssignment clazz) {
            this(course);
            this.setDisplayString(course.getCourseName() + " " + clazz.getSelection());
            this.setHint("<span class='item-hint'>" + (clazz.getSelection().startsWith(clazz.getSubpart()) ? "" : clazz.getSubpart() + " ") + clazz.getTimeString(CONSTANTS.shortDays(), CONSTANTS.useAmPm(), MESSAGES.emailArrangeHours()) + (clazz.hasNote() ? " " + clazz.getNote() : "") + "</span>");
            this.iCourse.setSelectedClass(clazz.getSelection(), !this.iCourse.isSelectedClass(clazz.getSelection()));
        }

        public CourseRequestInterface.RequestedCourse getRequestedCourse() {
            return this.iCourse;
        }
    }
}

