/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTabPanel;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseFinderDialog
extends UniTimeDialogBox
implements CourseFinder {
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private AriaTextBox iFilter = null;
    private AriaButton iFilterSelect;
    private P iFilterPanel;
    private boolean iEnabled = true;
    private CourseFinder.CourseFinderTab[] iTabs = null;
    private UniTimeTabPanel iTabPanel = null;
    private VerticalPanel iDialogPanel = null;
    private Map<Character, Integer> iTabAccessKeys = new HashMap<Character, Integer>();

    public CourseFinderDialog() {
        super(true, false);
        this.addStyleName("unitime-CourseFinderDialog");
        this.setText(MESSAGES.courseSelectionDialog());
        this.iFilter = new AriaTextBox();
        this.iFilter.setStyleName("gwt-SuggestBox");
        this.iFilterSelect = new AriaButton(MESSAGES.buttonSelect());
        this.iFilterSelect.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                CourseFinder.CourseFinderTab tab = CourseFinderDialog.this.getSelectedTab();
                CourseRequestInterface.RequestedCourse rc = (CourseRequestInterface.RequestedCourse)(tab == null ? null : tab.getValue());
                if (rc != null) {
                    CourseFinderDialog.this.iFilter.setValue(rc.toString(CONSTANTS));
                }
                CourseFinderDialog.this.hide();
                SelectionEvent.fire((HasSelectionHandlers)CourseFinderDialog.this, (Object)CourseFinderDialog.this.getValue());
            }
        });
        this.iFilterPanel = new P("filter");
        P filterText = new P("text");
        P filterButton = new P("button");
        this.iFilterPanel.add((Widget)filterButton);
        this.iFilterPanel.add((Widget)filterText);
        filterText.add((Widget)this.iFilter);
        filterButton.add((Widget)this.iFilterSelect);
        this.iDialogPanel = new VerticalPanel();
        this.iDialogPanel.setSpacing(5);
        this.iDialogPanel.add((Widget)this.iFilterPanel);
        this.iDialogPanel.setCellHorizontalAlignment((Widget)this.iFilterPanel, HasHorizontalAlignment.ALIGN_CENTER);
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
            }
        });
        final Timer finderTimer = new Timer(){

            public void run() {
                if (CourseFinderDialog.this.iTabs != null) {
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.setCourseName(CourseFinderDialog.this.iFilter.getValue());
                    for (CourseFinder.CourseFinderTab tab : CourseFinderDialog.this.iTabs) {
                        tab.setValue(rc, false);
                    }
                }
            }
        };
        this.iFilter.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                finderTimer.schedule(250);
                if (event.getNativeKeyCode() == 13) {
                    CourseFinder.CourseFinderTab tab = CourseFinderDialog.this.getSelectedTab();
                    CourseRequestInterface.RequestedCourse requestedCourse = (CourseRequestInterface.RequestedCourse)(tab == null ? null : tab.getValue());
                    if (requestedCourse != null) {
                        CourseFinderDialog.this.iFilter.setValue(requestedCourse.toString(CONSTANTS));
                    }
                    CourseFinderDialog.this.hide();
                    SelectionEvent.fire((HasSelectionHandlers)CourseFinderDialog.this, (Object)CourseFinderDialog.this.getValue());
                    return;
                }
                if (event.getNativeKeyCode() == 27) {
                    CourseFinderDialog.this.hide();
                    return;
                }
                if (event.isControlKeyDown() || event.isAltKeyDown()) {
                    for (Map.Entry entry : CourseFinderDialog.this.iTabAccessKeys.entrySet()) {
                        if (event.getNativeKeyCode() != Character.toLowerCase(((Character)entry.getKey()).charValue()) && event.getNativeKeyCode() != Character.toUpperCase(((Character)entry.getKey()).charValue())) continue;
                        CourseFinderDialog.this.iTabPanel.selectTab((Integer)entry.getValue());
                        event.preventDefault();
                        event.stopPropagation();
                    }
                }
                if (CourseFinderDialog.this.iTabs != null) {
                    for (CourseFinder.CourseFinderTab tab : CourseFinderDialog.this.iTabs) {
                        tab.onKeyUp(event);
                    }
                }
            }
        });
        this.iFilter.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                CourseRequestInterface.RequestedCourse value = new CourseRequestInterface.RequestedCourse();
                value.setCourseName((String)event.getValue());
                if (CourseFinderDialog.this.iTabs != null) {
                    for (CourseFinder.CourseFinderTab tab : CourseFinderDialog.this.iTabs) {
                        tab.setValue(value, true);
                    }
                }
            }
        });
        this.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.RequestedCourse>(){

            public void onValueChange(ValueChangeEvent<CourseRequestInterface.RequestedCourse> event) {
                if (CourseFinderDialog.this.iTabs != null) {
                    for (CourseFinder.CourseFinderTab tab : CourseFinderDialog.this.iTabs) {
                        tab.setValue(event.getValue(), true);
                    }
                }
            }
        });
        this.iFilter.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (CourseFinderDialog.this.isShowing()) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            CourseFinderDialog.this.iFilter.setFocus(true);
                        }
                    });
                }
            }
        });
        this.setWidget((Widget)this.iDialogPanel);
    }

    public void setValue(CourseRequestInterface.RequestedCourse value) {
        this.setValue(value, false);
    }

    public CourseRequestInterface.RequestedCourse getValue() {
        CourseRequestInterface.RequestedCourse ret = (CourseRequestInterface.RequestedCourse)this.getSelectedTab().getValue();
        if (ret != null) {
            return ret;
        }
        CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
        rc.setCourseName(this.iFilter.getValue());
        return rc;
    }

    @Override
    public void findCourse() {
        this.iFilter.setAriaLabel(this.isAllowFreeTime() ? ARIA.courseFinderFilterAllowsFreeTime() : ARIA.courseFinderFilter());
        AriaStatus.getInstance().setText(ARIA.courseFinderDialogOpened());
        if (this.iTabs != null) {
            for (CourseFinder.CourseFinderTab tab : this.iTabs) {
                tab.changeTip();
            }
        }
        this.center();
        RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                CourseFinderDialog.this.iFilter.setFocus(true);
            }
        });
    }

    protected boolean isAllowFreeTime() {
        if (this.iTabs == null) {
            return false;
        }
        for (CourseFinder.CourseFinderTab tab : this.iTabs) {
            if (tab.isCourseSelection()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTabs(CourseFinder.CourseFinderTab ... tabs) {
        this.iTabs = tabs;
        if (this.iTabs.length == 1) {
            if (this.iTabs[0].asWidget() instanceof VerticalPanel) {
                VerticalPanel vp = (VerticalPanel)this.iTabs[0].asWidget();
                while (vp.getWidgetCount() > 0) {
                    Widget w = vp.getWidget(0);
                    vp.remove(w);
                    this.iDialogPanel.add(w);
                }
            } else {
                this.iDialogPanel.add(this.iTabs[0].asWidget());
            }
        } else {
            this.iTabPanel = new UniTimeTabPanel();
            int tabIndex = 0;
            CourseFinder.CourseFinderTab[] courseFinderTabArray = this.iTabs;
            int n = courseFinderTabArray.length;
            for (int i = 0; i < n; ++i) {
                CourseFinder.CourseFinderTab tab = courseFinderTabArray[i];
                this.iTabPanel.add(tab.asWidget(), tab.getName(), true);
                Character ch = UniTimeHeaderPanel.guessAccessKey(tab.getName());
                if (ch != null) {
                    this.iTabAccessKeys.put(ch, tabIndex);
                }
                ++tabIndex;
            }
            this.iTabPanel.selectTab(0);
            this.iDialogPanel.add((Widget)this.iTabPanel);
        }
        for (final CourseFinder.CourseFinderTab tab : this.iTabs) {
            tab.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<CourseRequestInterface.RequestedCourse>(){

                public void onValueChange(ValueChangeEvent<CourseRequestInterface.RequestedCourse> event) {
                    if (event.getSource().equals(tab)) {
                        CourseFinderDialog.this.selectTab(tab);
                    } else {
                        tab.setValue(event.getValue());
                    }
                    CourseFinderDialog.this.iFilter.setValue(event.getValue() == null ? "" : ((CourseRequestInterface.RequestedCourse)event.getValue()).toString(CONSTANTS));
                }
            });
            tab.addSelectionHandler((SelectionHandler)new SelectionHandler<CourseRequestInterface.RequestedCourse>(){

                public void onSelection(SelectionEvent<CourseRequestInterface.RequestedCourse> event) {
                    CourseFinderDialog.this.iFilter.setValue(event.getSelectedItem() == null ? "" : ((CourseRequestInterface.RequestedCourse)event.getSelectedItem()).toString(CONSTANTS));
                    CourseFinderDialog.this.hide();
                    SelectionEvent.fire((HasSelectionHandlers)CourseFinderDialog.this, (Object)CourseFinderDialog.this.getValue());
                }
            });
            tab.addResponseHandler(new CourseFinder.ResponseHandler(){

                public void onResponse(CourseFinder.ResponseEvent event) {
                    if (event.isValid()) {
                        CourseFinder.CourseFinderTab selected = CourseFinderDialog.this.getSelectedTab();
                        if (selected != null && selected.isCourseSelection() && selected.getValue() != null) {
                            return;
                        }
                        CourseFinderDialog.this.selectTab(tab);
                    }
                }
            });
        }
    }

    protected void selectTab(CourseFinder.CourseFinderTab tab) {
        if (this.iTabs != null && this.iTabs.length > 1) {
            for (int i = 0; i < this.iTabs.length; ++i) {
                if (!tab.equals(this.iTabs[i])) continue;
                this.iTabPanel.selectTab(i);
                break;
            }
        }
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    protected CourseFinder.CourseFinderTab getSelectedTab() {
        if (this.iTabs == null) {
            return null;
        }
        if (this.iTabs.length == 1) {
            return this.iTabs[0];
        }
        return this.iTabs[this.iTabPanel.getSelectedTab()];
    }

    public void setValue(CourseRequestInterface.RequestedCourse value, boolean fireEvents) {
        this.iFilter.setValue(value == null ? "" : value.toString(CONSTANTS), false);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
        this.iFilter.setReadOnly(!this.iEnabled);
        this.iFilterSelect.setVisible(this.iEnabled);
        if (this.iTabPanel != null) {
            for (int i = 0; i < this.iTabs.length; ++i) {
                this.iTabs[i].setEnabled(enabled);
                this.iTabPanel.getTabBar().setTabEnabled(i, this.iEnabled || this.iTabPanel.getSelectedTab() == i);
            }
        }
        if (this.iEnabled) {
            this.setText(MESSAGES.courseSelectionDialog());
        } else {
            this.setText(MESSAGES.courseSelectionDialogDisabled());
        }
    }
}

