/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.client.events.UniTimeFilterBox;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.TimeSelector;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsFilter
extends UniTimeFilterBox<SuggestionsInterface.SuggestionsFilterRpcRequest> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private Long iClassId = null;
    private TextBox iMin;
    private TextBox iMax;
    private FilterBox.Chip iLastSize = null;

    public SuggestionsFilter() {
        super(null);
        this.setShowSuggestionsOnFocus(false);
        this.setDefaultValueProvider(new TakesValue<String>(){

            public void setValue(String value) {
                SolverCookie.getInstance().setSuggestionsFilter(value == null ? "" : value);
            }

            public String getValue() {
                return SolverCookie.getInstance().getSuggestionsFilter();
            }
        });
        ArrayList<FilterBox.Chip> modes = new ArrayList<FilterBox.Chip>();
        modes.add(new FilterBox.Chip("mode", "Suggestions").withTranslatedCommand(MESSAGES.tagMode()).withTranslatedValue(MESSAGES.suggestionsSuggestions()));
        modes.add(new FilterBox.Chip("mode", "Placements").withTranslatedCommand(MESSAGES.tagMode()).withTranslatedValue(MESSAGES.suggestionsPlacements()));
        FilterBox.StaticSimpleFilter modeFilter = new FilterBox.StaticSimpleFilter("mode", MESSAGES.tagMode(), modes);
        modeFilter.setMultipleSelection(false);
        this.addFilter(modeFilter);
        ArrayList<FilterBox.Chip> flags = new ArrayList<FilterBox.Chip>();
        flags.add(new FilterBox.Chip("flag", "Same Room").withTranslatedCommand(MESSAGES.tagFlag()).withTranslatedValue(MESSAGES.suggestionsSameRoom()));
        flags.add(new FilterBox.Chip("flag", "Same Time").withTranslatedCommand(MESSAGES.tagFlag()).withTranslatedValue(MESSAGES.suggestionsSameTime()));
        flags.add(new FilterBox.Chip("flag", "Allow Break Hard").withTranslatedCommand(MESSAGES.tagFlag()).withTranslatedValue(MESSAGES.suggestionsAllowBreakHard()));
        this.addFilter(new FilterBox.StaticSimpleFilter("flag", MESSAGES.tagFlag(), flags){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                try {
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    if (text.startsWith("D") || text.startsWith("d")) {
                        Integer value = Integer.valueOf(text.substring(1));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("depth", "D" + value).withTranslatedCommand(MESSAGES.tagSuggestionsDepth()).withLabel(value.toString()), SuggestionsFilter.this.getChip("depth")));
                    } else if (text.startsWith("R") || text.startsWith("r")) {
                        Integer value = Integer.valueOf(text.substring(1));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("results", "R" + value).withTranslatedCommand(MESSAGES.tagSuggestionsResults()).withLabel(value.toString()), SuggestionsFilter.this.getChip("results")));
                    } else if (text.startsWith("T") || text.startsWith("t")) {
                        Integer value = Integer.valueOf(text.substring(1));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("timeout", "T" + value).withTranslatedCommand(MESSAGES.tagSuggestionsTimeLimit()).withLabel(value.toString()), SuggestionsFilter.this.getChip("timeout")));
                    } else {
                        Integer value = Integer.valueOf(text);
                        if (value > 0) {
                            if (value < 10) {
                                suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("depth", "D" + value).withTranslatedCommand(MESSAGES.tagSuggestionsDepth()).withLabel(value.toString()), SuggestionsFilter.this.getChip("depth")));
                            }
                            suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("timeout", "T" + value).withTranslatedCommand(MESSAGES.tagSuggestionsTimeLimit()).withLabel(value.toString()), SuggestionsFilter.this.getChip("timeout")));
                            suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("results", "R" + value).withTranslatedCommand(MESSAGES.tagSuggestionsResults()).withLabel(value.toString()), SuggestionsFilter.this.getChip("results")));
                        }
                    }
                    callback.onSuccess(suggestions);
                }
                catch (Exception e) {
                    super.getSuggestions(chips, text, callback);
                }
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("date", MESSAGES.tagDate(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("time", MESSAGES.tagTime(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("room", MESSAGES.tagRoom(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("depth", MESSAGES.tagSuggestionsDepth(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("timeout", MESSAGES.tagSuggestionsTimeLimit(), new String[0]));
        this.addFilter(new FilterBox.StaticSimpleFilter("results", MESSAGES.tagSuggestionsResults(), new String[0]));
        ArrayList<FilterBox.Chip> days = new ArrayList<FilterBox.Chip>();
        days.add(new FilterBox.Chip("day", "Monday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[0]));
        days.add(new FilterBox.Chip("day", "Tuesday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[1]));
        days.add(new FilterBox.Chip("day", "Wednesday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[2]));
        days.add(new FilterBox.Chip("day", "Thursday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[3]));
        days.add(new FilterBox.Chip("day", "Friday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[4]));
        days.add(new FilterBox.Chip("day", "Saturday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[5]));
        days.add(new FilterBox.Chip("day", "Sunday").withTranslatedCommand(MESSAGES.tagDayOfWeek()).withTranslatedValue(CONSTANTS.longDays()[6]));
        this.addFilter(new FilterBox.StaticSimpleFilter("day", MESSAGES.tagDayOfWeek(), days));
        final TimeSelector st = new TimeSelector(null);
        final TimeSelector et = new TimeSelector(st);
        st.setStyleName("unitime-TextArea");
        st.addStyleName("unitime-TimeSelector");
        et.setStyleName("unitime-TextArea");
        et.addStyleName("unitime-TimeSelector");
        this.addFilter(new FilterBox.CustomFilter("time", MESSAGES.tagTime(), new Widget[]{new Label(MESSAGES.propAfter()), st, new Label(" " + MESSAGES.propBefore()), et}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                FilterBox.Chip chStart = null;
                FilterBox.Chip chStop = null;
                for (FilterBox.Chip c : chips) {
                    if (c.getCommand().equals("after")) {
                        chStart = c;
                    }
                    if (!c.getCommand().equals("before")) continue;
                    chStop = c;
                }
                Integer start = TimeSelector.TimeUtils.parseTime(CONSTANTS, text, null);
                Integer stop = TimeSelector.TimeUtils.parseTime(CONSTANTS, text, chStart == null ? null : TimeSelector.TimeUtils.parseMilitary(chStart.getValue()));
                if (chStart == null) {
                    if (start != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 3)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 3)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 6)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 6)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 9)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 9)), chStart));
                    }
                    if (stop != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 3)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 3)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 6)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 6)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 9)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 9)), chStop));
                    }
                } else {
                    if (stop != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 3)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 3)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 6)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 6)), chStop));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop + 9)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop + 9)), chStop));
                    }
                    if (start != null) {
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 3)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 3)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 6)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 6)), chStart));
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start + 9)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start + 9)), chStart));
                    }
                }
                callback.onSuccess(suggestions);
            }
        });
        st.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                FilterBox.Chip ch = SuggestionsFilter.this.getChip("after");
                Integer start = (Integer)event.getValue();
                if (start == null) {
                    if (ch != null) {
                        SuggestionsFilter.this.removeChip(ch, true);
                    }
                } else {
                    if (ch != null) {
                        if (ch.getCommand().equals(TimeSelector.TimeUtils.slot2military(start))) {
                            return;
                        }
                        SuggestionsFilter.this.removeChip(ch, false);
                    }
                    SuggestionsFilter.this.addChip(new FilterBox.Chip("after", TimeSelector.TimeUtils.slot2military(start)).withTranslatedCommand(MESSAGES.tagTimeAfter()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(start)), true);
                }
                FilterBox.Chip ch2 = SuggestionsFilter.this.getChip("before");
                Integer stop = et.getValue();
                if (stop == null) {
                    if (ch2 != null) {
                        SuggestionsFilter.this.removeChip(ch2, true);
                    }
                } else {
                    if (ch2 != null) {
                        if (ch2.getCommand().equals(TimeSelector.TimeUtils.slot2military(stop))) {
                            return;
                        }
                        SuggestionsFilter.this.removeChip(ch2, false);
                    }
                    SuggestionsFilter.this.addChip(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop)), true);
                }
            }
        });
        et.addValueChangeHandler(new ValueChangeHandler<Integer>(){

            public void onValueChange(ValueChangeEvent<Integer> event) {
                FilterBox.Chip ch = SuggestionsFilter.this.getChip("before");
                Integer stop = (Integer)event.getValue();
                if (stop == null) {
                    if (ch != null) {
                        SuggestionsFilter.this.removeChip(ch, true);
                    }
                } else {
                    if (ch != null) {
                        if (ch.getCommand().equals(TimeSelector.TimeUtils.slot2military(stop))) {
                            return;
                        }
                        SuggestionsFilter.this.removeChip(ch, false);
                    }
                    SuggestionsFilter.this.addChip(new FilterBox.Chip("before", TimeSelector.TimeUtils.slot2military(stop)).withTranslatedCommand(MESSAGES.tagTimeBefore()).withTranslatedValue(TimeSelector.TimeUtils.slot2time(stop)), true);
                }
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("after", MESSAGES.tagTimeAfter(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                Integer slot = TimeSelector.TimeUtils.parseTime2(CONSTANTS, text, null);
                if (slot != null) {
                    translatedValue = TimeSelector.TimeUtils.slot2time(slot);
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        this.addFilter(new FilterBox.StaticSimpleFilter("before", MESSAGES.tagTimeBefore(), new String[0]){

            @Override
            public void validate(String text, AsyncCallback<FilterBox.Chip> callback) {
                String translatedValue = null;
                Integer slot = TimeSelector.TimeUtils.parseTime2(CONSTANTS, text, null);
                if (slot != null) {
                    translatedValue = TimeSelector.TimeUtils.slot2time(slot);
                }
                callback.onSuccess((Object)new FilterBox.Chip(this.getCommand(), text).withTranslatedCommand(this.getLabel()).withTranslatedValue(translatedValue));
            }
        });
        Label l1 = new Label(MESSAGES.propMin());
        this.iMin = new TextBox();
        this.iMin.setStyleName("unitime-TextArea");
        this.iMin.setMaxLength(10);
        this.iMin.getElement().getStyle().setWidth(50.0, Style.Unit.PX);
        Label l2 = new Label(MESSAGES.propMax());
        l2.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
        this.iMax = new TextBox();
        this.iMax.setMaxLength(10);
        this.iMax.getElement().getStyle().setWidth(50.0, Style.Unit.PX);
        this.iMax.setStyleName("unitime-TextArea");
        this.addFilter(new FilterBox.CustomFilter("size", MESSAGES.tagRoomSize(), new Widget[]{l1, this.iMin, l2, this.iMax}){

            @Override
            public void getSuggestions(List<FilterBox.Chip> chips, String text, AsyncCallback<Collection<FilterBox.Suggestion>> callback) {
                if (text.isEmpty()) {
                    callback.onSuccess(null);
                } else {
                    ArrayList<FilterBox.Suggestion> suggestions = new ArrayList<FilterBox.Suggestion>();
                    FilterBox.Chip old = null;
                    for (FilterBox.Chip c : chips) {
                        if (!c.getCommand().equals("size")) continue;
                        old = c;
                        break;
                    }
                    try {
                        String number = text;
                        String prefix = "";
                        if (text.startsWith("<=") || text.startsWith(">=")) {
                            number = number.substring(2);
                            prefix = text.substring(0, 2);
                        } else if (text.startsWith("<") || text.startsWith(">")) {
                            number = number.substring(1);
                            prefix = text.substring(0, 1);
                        }
                        Integer.parseInt(number);
                        suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("size", text).withTranslatedCommand(MESSAGES.tagRoomSize()), old));
                        if (prefix.isEmpty()) {
                            suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("size", "<=" + text).withTranslatedCommand(MESSAGES.tagRoomSize()), old));
                            suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("size", ">=" + text).withTranslatedCommand(MESSAGES.tagRoomSize()), old));
                        }
                    }
                    catch (Exception number) {
                        // empty catch block
                    }
                    if (text.contains("..")) {
                        try {
                            String first = text.substring(0, text.indexOf(46));
                            String second = text.substring(text.indexOf("..") + 2);
                            Integer.parseInt(first);
                            Integer.parseInt(second);
                            suggestions.add(new FilterBox.Suggestion(new FilterBox.Chip("size", text).withTranslatedCommand(MESSAGES.tagRoomSize()), old));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    callback.onSuccess(suggestions);
                }
            }
        });
        this.iMin.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SuggestionsFilter.this.sizeChanged(true);
            }
        });
        this.iMax.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SuggestionsFilter.this.sizeChanged(true);
            }
        });
        this.iMin.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        SuggestionsFilter.this.sizeChanged(false);
                    }
                });
            }
        });
        this.iMax.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        SuggestionsFilter.this.sizeChanged(false);
                    }
                });
            }
        });
        this.iMin.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SuggestionsFilter.this.sizeChanged(false);
                        }
                    });
                }
            }
        });
        this.iMax.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 8) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SuggestionsFilter.this.sizeChanged(false);
                        }
                    });
                }
            }
        });
        this.iMin.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                SuggestionsFilter.this.sizeChanged(true);
            }
        });
        this.iMax.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                SuggestionsFilter.this.sizeChanged(true);
            }
        });
        this.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                SuggestionsFilter.this.iLastSize = SuggestionsFilter.this.getChip("size");
                if (!SuggestionsFilter.this.isFilterPopupShowing()) {
                    FilterBox.Chip size = SuggestionsFilter.this.getChip("size");
                    if (size != null) {
                        if (size.getValue().startsWith("<=")) {
                            SuggestionsFilter.this.iMin.setText("");
                            SuggestionsFilter.this.iMax.setText(size.getValue().substring(2));
                        } else if (size.getValue().startsWith("<")) {
                            try {
                                SuggestionsFilter.this.iMax.setText(String.valueOf(Integer.parseInt(size.getValue().substring(1)) - 1));
                                SuggestionsFilter.this.iMin.setText("");
                            }
                            catch (Exception exception) {}
                        } else if (size.getValue().startsWith(">=")) {
                            SuggestionsFilter.this.iMin.setText(size.getValue().substring(2));
                            SuggestionsFilter.this.iMax.setText("");
                        } else if (size.getValue().startsWith(">")) {
                            try {
                                SuggestionsFilter.this.iMin.setText(String.valueOf(Integer.parseInt(size.getValue().substring(1)) + 1));
                                SuggestionsFilter.this.iMax.setText("");
                            }
                            catch (Exception exception) {}
                        } else if (size.getValue().contains("..")) {
                            SuggestionsFilter.this.iMin.setText(size.getValue().substring(0, size.getValue().indexOf("..")));
                            SuggestionsFilter.this.iMax.setText(size.getValue().substring(size.getValue().indexOf("..") + 2));
                        } else {
                            SuggestionsFilter.this.iMin.setText(size.getValue());
                            SuggestionsFilter.this.iMax.setText(size.getValue());
                        }
                    } else {
                        SuggestionsFilter.this.iMin.setText("");
                        SuggestionsFilter.this.iMax.setText("");
                    }
                    FilterBox.Chip chStart = SuggestionsFilter.this.getChip("after");
                    if (chStart != null) {
                        st.setValue(TimeSelector.TimeUtils.parseMilitary(chStart.getValue()));
                    } else {
                        st.setValue(null);
                    }
                    FilterBox.Chip chStop = SuggestionsFilter.this.getChip("before");
                    if (chStop != null) {
                        et.setValue(TimeSelector.TimeUtils.parseMilitary(chStop.getValue()));
                    } else {
                        et.setValue(null);
                    }
                }
            }
        });
    }

    private void sizeChanged(boolean fireChange) {
        FilterBox.Chip oldChip = this.getChip("size");
        if (this.iMin.getText().isEmpty() && this.iMax.getText().isEmpty()) {
            if (oldChip != null) {
                this.removeChip(oldChip, fireChange);
            }
        } else {
            FilterBox.Chip newChip = new FilterBox.Chip("size", this.iMin.getText().isEmpty() ? "<=" + this.iMax.getText() : (this.iMax.getText().isEmpty() ? ">=" + this.iMin.getText() : this.iMin.getText() + ".." + this.iMax.getText())).withTranslatedCommand(MESSAGES.tagRoomSize());
            if (newChip.equals(oldChip)) {
                if (fireChange && !newChip.equals(this.iLastSize)) {
                    this.fireValueChangeEvent();
                }
                return;
            }
            if (oldChip != null) {
                this.removeChip(oldChip, false);
            }
            this.addChip(newChip, fireChange);
        }
    }

    public void setClassId(Long classId) {
        if (this.iClassId == null || !this.iClassId.equals(classId)) {
            this.iClassId = classId;
            this.init(false, this.getAcademicSessionId(), new Command(){

                public void execute() {
                    if (SuggestionsFilter.this.isFilterPopupShowing()) {
                        SuggestionsFilter.this.showFilterPopup();
                    }
                }
            });
        }
    }

    @Override
    protected SuggestionsInterface.SuggestionsFilterRpcRequest createRpcRequest() {
        SuggestionsInterface.SuggestionsFilterRpcRequest request = new SuggestionsInterface.SuggestionsFilterRpcRequest();
        request.setClassId(this.iClassId);
        return request;
    }
}

