/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusCookie;
import org.unitime.timetable.gwt.client.sectioning.TimeGrid;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTabPanel;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentSchedule
extends Composite
implements TakesValue<ClassAssignmentInterface> {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.requestDateFormat());
    private ClassAssignmentInterface iAssignment;
    private UniTimeTabPanel iTabs;
    private TimeGrid iGrid;
    private WebTable iAssignments;
    private WebTable iRequests;
    private boolean iOnline = false;
    private float iTotalCredit = 0.0f;
    private Map<Character, Integer> iTabAccessKeys = new HashMap<Character, Integer>();
    private SelectionHandler<Integer> iHandler;

    public StudentSchedule(boolean online) {
        this.iOnline = online;
        this.iTabs = new UniTimeTabPanel();
        this.iTabs.setDeckStyleName("unitime-TabPanel");
        this.iRequests = new WebTable();
        this.iRequests.setEmptyMessage(MESSAGES.emptyRequests());
        this.iRequests.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colPriority(), 1, "25px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "75px"), new WebTable.Cell(MESSAGES.colTitle(), 1, "200px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "20px"), new WebTable.Cell(MESSAGES.colPreferences(), 1, "100px"), new WebTable.Cell(MESSAGES.colWarnings(), 1, "200px"), new WebTable.Cell(MESSAGES.colStatus(), 1, "20px"), new WebTable.Cell(MESSAGES.colWaitList(), 1, "20px"), new WebTable.Cell(MESSAGES.colRequestTimeStamp(), 1, "50px")));
        this.iTabs.add((Widget)this.iRequests, MESSAGES.tabRequests(), true);
        Character ch0 = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabRequests());
        if (ch0 != null) {
            this.iTabAccessKeys.put(ch0, 0);
        }
        this.iAssignments = new WebTable();
        this.iAssignments.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colSubject(), 1, "75px"), new WebTable.Cell(MESSAGES.colCourse(), 1, "75px"), new WebTable.Cell(MESSAGES.colSubpart(), 1, "50px"), new WebTable.Cell(MESSAGES.colClass(), 1, "75px"), new WebTable.Cell(MESSAGES.colLimit(), 1, "60px"), new WebTable.Cell(MESSAGES.colDays(), 1, "50px"), new WebTable.Cell(MESSAGES.colStart(), 1, "75px"), new WebTable.Cell(MESSAGES.colEnd(), 1, "75px"), new WebTable.Cell(MESSAGES.colDate(), 1, "75px"), new WebTable.Cell(MESSAGES.colRoom(), 1, "100px"), new WebTable.Cell(MESSAGES.colInstructor(), 1, "100px"), new WebTable.Cell(MESSAGES.colParent(), 1, "75px"), new WebTable.Cell(MESSAGES.colNoteIcon(), 1, "10px"), new WebTable.Cell(MESSAGES.colCredit(), 1, "75px"), new WebTable.Cell(MESSAGES.colEnrollmentTimeStamp(), 1, "75px")));
        this.iAssignments.setEmptyMessage(MESSAGES.emptySchedule());
        this.iTabs.add((Widget)this.iAssignments, MESSAGES.tabClasses(), true);
        Character ch1 = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabClasses());
        if (ch1 != null) {
            this.iTabAccessKeys.put(ch1, 1);
        }
        this.iGrid = new TimeGrid();
        this.iTabs.add((Widget)this.iGrid, MESSAGES.tabTimetable(), true);
        Character ch2 = UniTimeHeaderPanel.guessAccessKey(MESSAGES.tabTimetable());
        if (ch2 != null) {
            this.iTabAccessKeys.put(ch2, 2);
        }
        this.iTabs.selectTab(SectioningStatusCookie.getInstance().getStudentTab());
        this.iTabs.addSelectionHandler(new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                SectioningStatusCookie.getInstance().setStudentTab((Integer)event.getSelectedItem());
                if (StudentSchedule.this.iHandler != null) {
                    StudentSchedule.this.iHandler.onSelection(event);
                }
            }
        });
        this.initWidget((Widget)this.iTabs);
    }

    public ClassAssignmentInterface getValue() {
        return this.iAssignment;
    }

    public void setValue(ClassAssignmentInterface result) {
        this.iAssignment = result;
        this.fillInRequests();
        this.fillInAssignments();
        this.fillInTimeGrid();
    }

    protected void fillInRequests() {
        ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
        boolean hasPref = false;
        boolean hasWarn = false;
        boolean hasWait = false;
        boolean hasStat = false;
        NumberFormat df = NumberFormat.getFormat((String)"0.#");
        if (this.iAssignment.hasRequest()) {
            WebTable.Row row;
            String free;
            String noteTitle;
            String note;
            WebTable.Cell credit;
            Object iconText;
            ImageResource icon;
            boolean first;
            CourseRequestInterface.CheckCoursesResponse check = new CourseRequestInterface.CheckCoursesResponse(this.iAssignment.getRequest().getConfirmations());
            hasWarn = this.iAssignment.getRequest().hasConfirmations();
            int priority = 1;
            for (CourseRequestInterface.Request request : this.iAssignment.getRequest().getCourses()) {
                if (!request.hasRequestedCourse()) continue;
                first = true;
                if (request.isWaitList()) {
                    hasWait = true;
                }
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (rc.isCourse()) {
                        icon = null;
                        iconText = null;
                        String string = check.getMessage(rc.getCourseName(), "\n", new String[0]);
                        if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                            icon = RESOURCES.requestError();
                            iconText = string;
                        } else if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    icon = RESOURCES.requestEnrolled();
                                    iconText = MESSAGES.enrolled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NEEDED: {
                                    icon = RESOURCES.requestNeeded();
                                    iconText = MESSAGES.overrideNeeded(string);
                                    break;
                                }
                                case SAVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.requested(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    icon = RESOURCES.requestRejected();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.overrideRejected(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    icon = RESOURCES.requestPending();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.overridePending(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    icon = RESOURCES.requestCancelled();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.overrideCancelled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.overrideApproved(rc.getCourseName());
                                    break;
                                }
                                default: {
                                    if (check.isError(rc.getCourseName())) {
                                        icon = RESOURCES.requestError();
                                    }
                                    iconText = string;
                                }
                            }
                        }
                        if (rc.hasStatusNote()) {
                            iconText = (String)iconText + "\n" + MESSAGES.overrideNote(rc.getStatusNote());
                        }
                        AbstractCollection prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<String>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<String>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<String>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<String>(rc.getSelectedClasses());
                        }
                        String status = "";
                        if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    status = MESSAGES.reqStatusEnrolled();
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    status = MESSAGES.reqStatusApproved();
                                    hasStat = true;
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    status = MESSAGES.reqStatusCancelled();
                                    hasStat = true;
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    status = MESSAGES.reqStatusPending();
                                    hasStat = true;
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    status = MESSAGES.reqStatusRejected();
                                    hasStat = true;
                                }
                            }
                        }
                        if (status.isEmpty()) {
                            status = MESSAGES.reqStatusRegistered();
                        }
                        if (prefs != null) {
                            hasPref = true;
                        }
                        credit = new WebTable.Cell(rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format((Number)rc.getCreditMin()) : df.format((Number)rc.getCreditMin()) + " - " + df.format((Number)rc.getCreditMax())) : "");
                        credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                        note = null;
                        noteTitle = null;
                        if (check != null) {
                            note = check.getMessageWithColor(rc.getCourseName(), "<br>", "CREDIT");
                            noteTitle = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                        }
                        if (rc.hasStatusNote()) {
                            note = (note == null ? "" : note + "<br>") + rc.getStatusNote();
                            noteTitle = (noteTitle == null ? "" : noteTitle + "\n") + rc.getStatusNote();
                        }
                        WebTable.Row row2 = new WebTable.Row(new WebTable.Cell(first ? MESSAGES.courseRequestsPriority(priority) : ""), new WebTable.Cell(rc.getCourseName()), new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : ""), credit, new WebTable.Cell(ToolBox.toString(prefs)), new WebTable.NoteCell(note, noteTitle), icon == null ? new WebTable.Cell(status) : new WebTable.IconCell(icon, (String)iconText, status), first && request.isWaitList() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed(), "") : new WebTable.Cell(""), new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : ""));
                        if (priority > 1 && first) {
                            for (WebTable.Cell cell : row2.getCells()) {
                                cell.setStyleName("top-border-dashed");
                            }
                        }
                        rows.add(row2);
                    } else if (rc.isFreeTime()) {
                        free = "";
                        for (CourseRequestInterface.FreeTime freeTime : rc.getFreeTime()) {
                            if (!free.isEmpty()) {
                                free = free + ", ";
                            }
                            free = free + freeTime.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                        }
                        row = new WebTable.Row(new WebTable.Cell(first ? MESSAGES.courseRequestsPriority(priority) : ""), new WebTable.Cell(CONSTANTS.freePrefix() + free, 3, null), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.IconCell(RESOURCES.requestSaved(), MESSAGES.requested(free), MESSAGES.reqStatusRegistered()), new WebTable.Cell(""), new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : ""));
                        if (priority > 1 && first) {
                            for (WebTable.Cell cell : row.getCells()) {
                                cell.setStyleName("top-border-dashed");
                            }
                        }
                        rows.add(row);
                    }
                    first = false;
                }
                ++priority;
            }
            priority = 1;
            for (CourseRequestInterface.Request request : this.iAssignment.getRequest().getAlternatives()) {
                if (!request.hasRequestedCourse()) continue;
                first = true;
                if (request.isWaitList()) {
                    hasWait = true;
                }
                for (CourseRequestInterface.RequestedCourse rc : request.getRequestedCourse()) {
                    if (rc.isCourse()) {
                        icon = null;
                        iconText = null;
                        String string = check.getMessage(rc.getCourseName(), "\n", new String[0]);
                        if (check.isError(rc.getCourseName()) && (rc.getStatus() == null || rc.getStatus() != CourseRequestInterface.RequestedCourseStatus.OVERRIDE_REJECTED)) {
                            icon = RESOURCES.requestError();
                            iconText = string;
                        } else if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    icon = RESOURCES.requestEnrolled();
                                    iconText = MESSAGES.enrolled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_NEEDED: {
                                    icon = RESOURCES.requestNeeded();
                                    iconText = MESSAGES.overrideNeeded(string);
                                    break;
                                }
                                case SAVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.requested(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    icon = RESOURCES.requestRejected();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.overrideRejected(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    icon = RESOURCES.requestPending();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.overridePending(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    icon = RESOURCES.requestCancelled();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.overrideCancelled(rc.getCourseName());
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    icon = RESOURCES.requestSaved();
                                    iconText = (string == null ? "" : MESSAGES.requestWarnings(string) + "\n\n") + MESSAGES.overrideApproved(rc.getCourseName());
                                    break;
                                }
                                default: {
                                    if (check.isError(rc.getCourseName())) {
                                        icon = RESOURCES.requestError();
                                    }
                                    iconText = string;
                                }
                            }
                        }
                        if (rc.hasStatusNote()) {
                            iconText = (String)iconText + "\n" + MESSAGES.overrideNote(rc.getStatusNote());
                        }
                        AbstractCollection prefs = null;
                        if (rc.hasSelectedIntructionalMethods()) {
                            if (rc.hasSelectedClasses()) {
                                prefs = new ArrayList(rc.getSelectedIntructionalMethods().size() + rc.getSelectedClasses().size());
                                prefs.addAll(new TreeSet<String>(rc.getSelectedIntructionalMethods()));
                                prefs.addAll(new TreeSet<String>(rc.getSelectedClasses()));
                            } else {
                                prefs = new TreeSet<String>(rc.getSelectedIntructionalMethods());
                            }
                        } else if (rc.hasSelectedClasses()) {
                            prefs = new TreeSet<String>(rc.getSelectedClasses());
                        }
                        if (prefs != null) {
                            hasPref = true;
                        }
                        String status = "";
                        if (rc.getStatus() != null) {
                            switch (rc.getStatus()) {
                                case ENROLLED: {
                                    status = MESSAGES.reqStatusEnrolled();
                                    break;
                                }
                                case OVERRIDE_APPROVED: {
                                    status = MESSAGES.reqStatusApproved();
                                    hasStat = true;
                                    break;
                                }
                                case OVERRIDE_CANCELLED: {
                                    status = MESSAGES.reqStatusCancelled();
                                    hasStat = true;
                                    break;
                                }
                                case OVERRIDE_PENDING: {
                                    status = MESSAGES.reqStatusPending();
                                    hasStat = true;
                                    break;
                                }
                                case OVERRIDE_REJECTED: {
                                    status = MESSAGES.reqStatusRejected();
                                    hasStat = true;
                                }
                            }
                        }
                        if (status.isEmpty()) {
                            status = MESSAGES.reqStatusRegistered();
                        }
                        credit = new WebTable.Cell(rc.hasCredit() ? (rc.getCreditMin().equals(rc.getCreditMax()) ? df.format((Number)rc.getCreditMin()) : df.format((Number)rc.getCreditMin()) + " - " + df.format((Number)rc.getCreditMax())) : "");
                        credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                        note = null;
                        noteTitle = null;
                        if (check != null) {
                            note = check.getMessageWithColor(rc.getCourseName(), "<br>", "CREDIT");
                            noteTitle = check.getMessage(rc.getCourseName(), "\n", "CREDIT");
                        }
                        if (rc.hasStatusNote()) {
                            note = (note == null ? "" : note + "<br>") + rc.getStatusNote();
                            noteTitle = (noteTitle == null ? "" : noteTitle + "\n") + rc.getStatusNote();
                        }
                        WebTable.Row row2 = new WebTable.Row(new WebTable.Cell(first ? MESSAGES.courseRequestsAlternative(priority) : ""), new WebTable.Cell(rc.getCourseName()), new WebTable.Cell(rc.hasCourseTitle() ? rc.getCourseTitle() : ""), credit, new WebTable.Cell(ToolBox.toString(prefs)), new WebTable.NoteCell(note, noteTitle), icon == null ? new WebTable.Cell(status) : new WebTable.IconCell(icon, (String)iconText, status), first && request.isWaitList() ? new WebTable.IconCell(RESOURCES.requestsWaitList(), MESSAGES.descriptionRequestWaitListed(), "") : new WebTable.Cell(""), new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : ""));
                        if (first) {
                            for (WebTable.Cell cell : row2.getCells()) {
                                cell.setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
                            }
                        }
                        rows.add(row2);
                    } else if (rc.isFreeTime()) {
                        free = "";
                        for (CourseRequestInterface.FreeTime freeTime : rc.getFreeTime()) {
                            if (!free.isEmpty()) {
                                free = free + ", ";
                            }
                            free = free + freeTime.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                        }
                        row = new WebTable.Row(new WebTable.Cell(first ? MESSAGES.courseRequestsPriority(priority) : ""), new WebTable.Cell(CONSTANTS.freePrefix() + free, 3, null), new WebTable.Cell(""), new WebTable.Cell(""), new WebTable.IconCell(RESOURCES.requestSaved(), MESSAGES.requested(free), MESSAGES.reqStatusRegistered()), new WebTable.Cell(""), new WebTable.Cell(first && request.hasTimeStamp() ? sDF.format(request.getTimeStamp()) : ""));
                        if (first) {
                            for (WebTable.Cell cell : row.getCells()) {
                                cell.setStyleName(priority == 1 ? "top-border-solid" : "top-border-dashed");
                            }
                        }
                        rows.add(row);
                    }
                    first = false;
                }
                ++priority;
            }
        }
        if (this.iAssignment.getRequest().getMaxCreditOverrideStatus() != null) {
            float[] range;
            ImageResource icon = null;
            String status = "";
            String note = null;
            String noteTitle = null;
            String iconText = null;
            if (this.iAssignment.getRequest().hasCreditWarning()) {
                note = this.iAssignment.getRequest().getCreditWarning().replace("\n", "<br>");
                noteTitle = this.iAssignment.getRequest().getCreditWarning();
                iconText = this.iAssignment.getRequest().getCreditWarning();
                hasWarn = true;
            }
            switch (this.iAssignment.getRequest().getMaxCreditOverrideStatus()) {
                case CREDIT_HIGH: {
                    icon = RESOURCES.requestError();
                    status = MESSAGES.reqStatusRejected();
                    note = "<span class='text-red'>" + note + "</span>";
                    iconText = iconText + "\n" + MESSAGES.creditStatusTooHigh();
                    break;
                }
                case OVERRIDE_REJECTED: {
                    icon = RESOURCES.requestError();
                    status = MESSAGES.reqStatusRejected();
                    note = "<span class='text-red'>" + note + "</span>";
                    iconText = iconText + "\n" + MESSAGES.creditStatusDenied();
                    break;
                }
                case OVERRIDE_NEEDED: 
                case CREDIT_LOW: {
                    icon = RESOURCES.requestNeeded();
                    status = MESSAGES.reqStatusWarning();
                    note = "<span class='text-orange'>" + note + "</span>";
                    break;
                }
                case OVERRIDE_CANCELLED: {
                    icon = RESOURCES.requestNeeded();
                    status = MESSAGES.reqStatusCancelled();
                    iconText = iconText + "\n" + MESSAGES.creditStatusCancelled();
                    note = "<span class='text-orange'>" + note + "</span>";
                    break;
                }
                case OVERRIDE_PENDING: {
                    icon = RESOURCES.requestPending();
                    status = MESSAGES.reqStatusPending();
                    iconText = iconText + "\n" + MESSAGES.creditStatusPending();
                    note = "<span class='text-orange'>" + note + "</span>";
                    break;
                }
                case OVERRIDE_APPROVED: {
                    icon = RESOURCES.requestSaved();
                    status = MESSAGES.reqStatusApproved();
                    iconText = iconText + (iconText == null ? "" : iconText + "\n") + MESSAGES.creditStatusApproved();
                    break;
                }
                case SAVED: {
                    icon = RESOURCES.requestSaved();
                    status = MESSAGES.reqStatusRegistered();
                }
            }
            if (!status.isEmpty()) {
                hasStat = true;
            }
            if (this.iAssignment.getRequest().hasCreditNote()) {
                note = (note == null ? "" : note + "<br>") + this.iAssignment.getRequest().getCreditNote().replace("\n", "<br>");
                noteTitle = (noteTitle == null ? "" : noteTitle + "\n") + MESSAGES.overrideNote(this.iAssignment.getRequest().getCreditNote());
                iconText = (iconText == null ? "" : iconText + "\n") + this.iAssignment.getRequest().getCreditNote();
                hasWarn = true;
            }
            WebTable.Cell credit = new WebTable.Cell((range = this.iAssignment.getRequest().getCreditRange()) != null ? (range[0] < range[1] ? df.format((double)range[0]) + " - " + df.format((double)range[1]) : df.format((double)range[0])) : "");
            credit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            WebTable.Row row = new WebTable.Row(new WebTable.Cell(MESSAGES.rowRequestedCredit(), 2, null), new WebTable.Cell(""), credit, new WebTable.Cell(""), new WebTable.NoteCell(note, noteTitle), icon == null ? new WebTable.Cell(status) : new WebTable.IconCell(icon, iconText, status), new WebTable.Cell(""), new WebTable.Cell(""));
            for (WebTable.Cell cell : row.getCells()) {
                cell.setStyleName("top-border-solid");
            }
            row.getCell(0).setStyleName("top-border-solid text-bold");
            rows.add(row);
        }
        WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
        int idx = 0;
        for (WebTable.Row row : rows) {
            rowArray[idx++] = row;
        }
        this.iRequests.setData(rowArray);
        this.iRequests.setColumnVisible(4, hasPref);
        this.iRequests.setColumnVisible(5, hasWarn);
        this.iRequests.setColumnVisible(6, hasStat);
        this.iRequests.setColumnVisible(7, hasWait);
    }

    protected void fillInAssignments() {
        ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
        this.iTotalCredit = 0.0f;
        for (ClassAssignmentInterface.CourseAssignment course : this.iAssignment.getCourseAssignments()) {
            if (course.isAssigned()) {
                boolean firstClazz = true;
                for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                    String style;
                    String string = style = firstClazz && !rows.isEmpty() ? "top-border-dashed" : "";
                    if (clazz.isTeachingAssignment()) {
                        style = style + (clazz.isInstructing() ? " text-steelblue" : " text-steelblue-italic");
                    }
                    WebTable.Cell[] cellArray = new WebTable.Cell[15];
                    cellArray[0] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()) : "");
                    cellArray[1] = new WebTable.Cell(firstClazz ? (course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()) : "");
                    cellArray[2] = new WebTable.Cell(clazz.getSubpart());
                    cellArray[3] = new WebTable.Cell(clazz.getSection());
                    cellArray[4] = new WebTable.Cell(clazz.getLimitString());
                    cellArray[5] = new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays()));
                    cellArray[6] = new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm()));
                    cellArray[7] = new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm()));
                    cellArray[8] = new WebTable.Cell(clazz.getDatePattern());
                    cellArray[9] = clazz.hasDistanceConflict() ? new WebTable.RoomCell(RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(), ", ") : new WebTable.RoomCell((List<ClassAssignmentInterface.IdValue>)clazz.getRooms(), ", ");
                    cellArray[10] = new WebTable.InstructorCell(clazz.getInstructors(), clazz.getInstructorEmails(), ", ");
                    cellArray[11] = new WebTable.Cell(clazz.getParentSection());
                    cellArray[12] = clazz.hasNote() ? new WebTable.IconCell(RESOURCES.note(), clazz.getNote(), "") : new WebTable.Cell("");
                    cellArray[13] = new WebTable.AbbvTextCell(clazz.getCredit());
                    cellArray[14] = new WebTable.Cell(clazz.getEnrolledDate() == null ? "" : sDF.format(clazz.getEnrolledDate()));
                    WebTable.Row row = new WebTable.Row(cellArray);
                    if (clazz.isTeachingAssignment()) {
                        row.setStyleName("teaching-assignment");
                    }
                    rows.add(row);
                    for (WebTable.Cell cell : row.getCells()) {
                        cell.setStyleName(style);
                    }
                    firstClazz = false;
                    if (clazz.isTeachingAssignment()) continue;
                    this.iTotalCredit += clazz.guessCreditCount();
                }
                continue;
            }
            String style = "text-red" + (!rows.isEmpty() ? " top-border-dashed" : "");
            WebTable.Row row = null;
            String unassignedMessage = MESSAGES.courseNotAssigned();
            if (course.hasEnrollmentMessage()) {
                unassignedMessage = course.getEnrollmentMessage();
            } else if (course.getOverlaps() != null && !course.getOverlaps().isEmpty()) {
                unassignedMessage = "";
                Iterator<String> i = course.getOverlaps().iterator();
                while (i.hasNext()) {
                    String x = i.next();
                    unassignedMessage = unassignedMessage.isEmpty() ? unassignedMessage + MESSAGES.conflictWithFirst(x) : (!i.hasNext() ? unassignedMessage + MESSAGES.conflictWithLast(x) : unassignedMessage + MESSAGES.conflictWithMiddle(x));
                    if (!i.hasNext()) continue;
                    unassignedMessage = unassignedMessage + ", ";
                }
                if (course.getInstead() != null) {
                    unassignedMessage = unassignedMessage + MESSAGES.conflictAssignedAlternative(course.getInstead());
                }
                unassignedMessage = unassignedMessage + ".";
            } else if (course.isNotAvailable()) {
                unassignedMessage = course.isFull() ? MESSAGES.courseIsFull() : MESSAGES.classNotAvailable();
            } else if (course.isLocked()) {
                unassignedMessage = MESSAGES.courseLocked(course.getSubject() + " " + course.getCourseNbr());
            }
            WebTable.Cell[] cellArray = course.getClassAssignments().iterator();
            if (cellArray.hasNext()) {
                ClassAssignmentInterface.ClassAssignment clazz = cellArray.next();
                row = new WebTable.Row(new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeSubject() : course.getSubject()), new WebTable.Cell(course.isFreeTime() ? MESSAGES.freeTimeCourse() : course.getCourseNbr()), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getLimitString()), new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())), new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getDatePattern()), new WebTable.Cell(unassignedMessage, 3, null), clazz.getNote() == null ? new WebTable.Cell("") : new WebTable.IconCell(RESOURCES.note(), clazz.getNote(), ""), new WebTable.AbbvTextCell(clazz.getCredit()), new WebTable.Cell(clazz.getEnrolledDate() != null ? sDF.format(clazz.getEnrolledDate()) : (course.getRequestedDate() == null ? "" : sDF.format(course.getRequestedDate()))));
            }
            if (row == null) {
                row = new WebTable.Row(new WebTable.Cell(course.getSubject()), new WebTable.Cell(course.getCourseNbr()), new WebTable.Cell(unassignedMessage, 12, null), new WebTable.Cell(course.getRequestedDate() == null ? "" : sDF.format(course.getRequestedDate())));
            }
            for (WebTable.Cell cell : row.getCells()) {
                cell.setStyleName(style);
            }
            row.getCell(row.getNrCells() - 2).setStyleName("text-gray" + (!rows.isEmpty() ? " top-border-dashed" : ""));
            rows.add(row);
        }
        WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
        int idx = 0;
        for (WebTable.Row row : rows) {
            rowArray[idx++] = row;
        }
        this.iAssignments.setData(rowArray);
        if (!this.iOnline) {
            for (int row = 0; row < this.iAssignments.getTable().getRowCount(); ++row) {
                if (this.iAssignments.getTable().getCellCount(row) <= 2) continue;
                this.iAssignments.getTable().getFlexCellFormatter().setVisible(row, this.iAssignments.getTable().getCellCount(row) - 2, false);
            }
        }
    }

    protected void fillInTimeGrid() {
        this.iGrid.clear(true);
        int index = 0;
        for (ClassAssignmentInterface.CourseAssignment course : this.iAssignment.getCourseAssignments()) {
            for (ClassAssignmentInterface.ClassAssignment clazz : course.getClassAssignments()) {
                if (clazz.isFreeTime()) {
                    CourseRequestInterface.FreeTime ft = new CourseRequestInterface.FreeTime();
                    ft.setLength(clazz.getLength());
                    ft.setStart(clazz.getStart());
                    for (int d : clazz.getDays()) {
                        ft.addDay(d);
                    }
                    this.iGrid.addFreeTime(ft);
                    continue;
                }
                if (!clazz.isAssigned()) continue;
                this.iGrid.addClass(clazz, index++);
            }
        }
        this.iGrid.shrink();
    }

    public float getTotalCredit() {
        return this.iTotalCredit;
    }

    public float[] getCreditRange() {
        return this.iAssignment == null || !this.iAssignment.hasRequest() ? null : this.iAssignment.getRequest().getCreditRange();
    }

    public String getCreditMessage() {
        if (this.iTabs.getSelectedTab() == 0) {
            float[] range = this.getCreditRange();
            if (range != null && range[1] > 0.0f) {
                if (range[0] == range[1]) {
                    return MESSAGES.requestedCredit(range[0]);
                }
                return MESSAGES.requestedCreditRange(range[0], range[1]);
            }
            return "";
        }
        if (this.iTotalCredit > 0.0f) {
            return MESSAGES.totalCredit(this.iTotalCredit);
        }
        return "";
    }

    public void checkAccessKeys(Event.NativePreviewEvent event) {
        if (event.getTypeInt() == 512 && (event.getNativeEvent().getAltKey() || event.getNativeEvent().getCtrlKey())) {
            for (Map.Entry<Character, Integer> entry : this.iTabAccessKeys.entrySet()) {
                if (event.getNativeEvent().getKeyCode() != Character.toLowerCase(entry.getKey().charValue()) && event.getNativeEvent().getKeyCode() != Character.toUpperCase(entry.getKey().charValue())) continue;
                this.iTabs.selectTab(entry.getValue());
            }
        }
    }

    public void setSelectionHandler(SelectionHandler<Integer> handler) {
        this.iHandler = handler;
    }
}

