/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialRegistrationSelectionDialog
extends UniTimeDialogBox {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static DateTimeFormat sModifiedDateFormat = ServerDateTimeFormat.getFormat(CONSTANTS.timeStampFormat());
    private SimpleForm iForm;
    private UniTimeTable<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> iTable;
    private UniTimeHeaderPanel iFooter;
    private SpecialRegistrationInterface.SpecialRegistrationContext iSpecReg;

    public SpecialRegistrationSelectionDialog(SpecialRegistrationInterface.SpecialRegistrationContext specReg) {
        super(true, true);
        this.iSpecReg = specReg;
        this.setEscapeToHide(true);
        this.setEnterToSubmit(new Command(){

            public void execute() {
                if (SpecialRegistrationSelectionDialog.this.iTable.getSelectedRow() > 0) {
                    SpecialRegistrationSelectionDialog.this.doSubmit((SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse)SpecialRegistrationSelectionDialog.this.iTable.getData(SpecialRegistrationSelectionDialog.this.iTable.getSelectedRow()));
                }
            }
        });
        this.setText(MESSAGES.dialogSpecialRegistrations());
        this.iForm = new SimpleForm();
        this.iForm.addStyleName("unitime-SpecialRegistrations");
        this.iTable = new UniTimeTable();
        this.iTable.addStyleName("plans-table");
        this.iTable.setAllowSelection(true);
        this.iTable.setAllowMultiSelect(false);
        this.iForm.addRow((Widget)this.iTable);
        this.iFooter = new UniTimeHeaderPanel();
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.setWidget((Widget)this.iForm);
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(""));
        header.add(new UniTimeTableHeader(MESSAGES.colSpecRegSubmitted()));
        header.add(new UniTimeTableHeader(MESSAGES.colSpecRegName()));
        header.add(new UniTimeTableHeader(MESSAGES.colSpecRegNote()));
        this.iTable.addRow(null, header);
        this.iFooter.addButton("create", MESSAGES.buttonSpecRegCreateNew(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SpecialRegistrationSelectionDialog.this.doSubmit(null);
            }
        });
        this.iFooter.addButton("select", MESSAGES.buttonSpecRegSelect(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SpecialRegistrationSelectionDialog.this.iTable.getSelectedRow() > 0) {
                    SpecialRegistrationSelectionDialog.this.doSubmit((SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse)SpecialRegistrationSelectionDialog.this.iTable.getData(SpecialRegistrationSelectionDialog.this.iTable.getSelectedRow()));
                }
            }
        });
        this.iFooter.addButton("cancel", MESSAGES.buttonSpecRegCancel(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SpecialRegistrationSelectionDialog.this.hide();
            }
        });
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> event) {
                if (event.getData() != null) {
                    SpecialRegistrationSelectionDialog.this.doSubmit(event.getData());
                }
            }
        });
    }

    public void open(List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> registrations) {
        this.iFooter.setEnabled("create", this.iSpecReg.isSpecRegMode() && this.iSpecReg.hasRequestKey() && this.iSpecReg.isSpecRegRequestKeyValid());
        this.iTable.clearTable(1);
        int select = -1;
        Collections.sort(registrations);
        for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse reg : registrations) {
            ArrayList<P> row = new ArrayList<P>();
            P p = new P("icons");
            if (reg.getStatus() != null) {
                switch (reg.getStatus()) {
                    case Approved: {
                        Image approved = new Image(RESOURCES.specRegApproved());
                        approved.setTitle(MESSAGES.hintSpecRegApproved());
                        p.add((Widget)approved);
                        break;
                    }
                    case Cancelled: {
                        Image cancelled = new Image(RESOURCES.specRegCancelled());
                        cancelled.setTitle(MESSAGES.hintSpecRegCancelled());
                        p.add((Widget)cancelled);
                        break;
                    }
                    case Pending: {
                        Image pending = new Image(RESOURCES.specRegPending());
                        pending.setTitle(MESSAGES.hintSpecRegPending());
                        p.add((Widget)pending);
                        break;
                    }
                    case Rejected: {
                        Image denied = new Image(RESOURCES.specRegRejected());
                        denied.setTitle(MESSAGES.hintSpecRegRejected());
                        p.add((Widget)denied);
                        break;
                    }
                    case Draft: {
                        Image draft = new Image(RESOURCES.specRegDraft());
                        draft.setTitle(MESSAGES.hintSpecRegDraft());
                        p.add((Widget)draft);
                    }
                }
            } else if (reg.isCanEnroll()) {
                Image canEnroll = new Image(RESOURCES.specRegCanEnroll());
                canEnroll.setTitle(MESSAGES.hintSpecRegCanEnroll());
                p.add((Widget)canEnroll);
            } else if (!reg.isCanSubmit()) {
                Image canNotSubmit = new Image(RESOURCES.specRegCanNotSubmit());
                canNotSubmit.setTitle(MESSAGES.hintSpecRegCanNotSubmit());
                p.add((Widget)canNotSubmit);
            }
            row.add(p);
            row.add((P)new Label(reg.getSubmitDate() == null ? "" : sModifiedDateFormat.format(reg.getSubmitDate())));
            row.add((P)new Label(reg.getDescription() == null ? "" : reg.getDescription()));
            row.add((P)new HTML(reg.getNote() == null ? "" : reg.getNote()));
            if (reg.getRequestId().equals(this.iSpecReg.getRequestId())) {
                select = this.iTable.getRowCount();
            }
            this.iTable.addRow(reg, row);
        }
        this.iTable.setSelected(select < 0 ? 1 : select, true);
        this.center();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                SpecialRegistrationSelectionDialog.this.iFooter.setFocus("select", true);
            }
        });
        this.updateAriaStatus(true);
    }

    @Override
    public void show() {
        super.show();
        this.updateAriaStatus(true);
    }

    public void doSubmit(SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse reg) {
        if (reg != null) {
            AriaStatus.getInstance().setText(ARIA.selectedSpecReg(reg.getDescription()));
        }
        this.hide();
    }

    @Override
    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        if (event.getTypeInt() == 128) {
            if (event.getNativeEvent().getKeyCode() == 38) {
                int row = this.iTable.getSelectedRow();
                if (row >= 0) {
                    this.iTable.setSelected(row, false);
                }
                if (--row <= 0) {
                    row = this.iTable.getRowCount() - 1;
                }
                this.iTable.setSelected(row, true);
                this.iTable.getRowFormatter().getElement(row).scrollIntoView();
                this.updateAriaStatus(false);
            } else if (event.getNativeEvent().getKeyCode() == 40) {
                int row = this.iTable.getSelectedRow();
                if (row >= 0) {
                    this.iTable.setSelected(row, false);
                }
                if (++row >= this.iTable.getRowCount()) {
                    row = 1;
                }
                this.iTable.setSelected(row, true);
                this.iTable.getRowFormatter().getElement(row).scrollIntoView();
                this.updateAriaStatus(false);
            }
        }
    }

    protected void updateAriaStatus(boolean justOpened) {
        String text = "";
        if (justOpened) {
            text = ARIA.showingSpecRegs(this.iTable.getRowCount() - 1);
        }
        int row = this.iTable.getSelectedRow();
        SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse reg = this.iTable.getData(row);
        if (row >= 0 && reg != null) {
            text = text + (text.isEmpty() ? "" : " ") + ARIA.showingSpecReg(row, this.iTable.getRowCount() - 1, reg.getDescription(), reg.getSubmitDate());
        }
        AriaStatus.getInstance().setText(text);
    }
}

