/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.sectioning.EnrollmentTable;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusCookie;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.client.sectioning.StudentStatusDialog;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTabPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SectioningStatusPage
extends Composite {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    public static final GwtConstants GWT_CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    public static final GwtMessages GWT_MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static DateTimeFormat sDF = DateTimeFormat.getFormat((String)CONSTANTS.requestDateFormat());
    private static DateTimeFormat sTSF = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private static NumberFormat sNF = NumberFormat.getFormat((String)CONSTANTS.executionTimeFormat());
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private SectioningStatusFilterBox iFilter;
    private Button iSearch = null;
    private Button iExport = null;
    private Button iMore = null;
    private Image iLoadingImage = null;
    private VerticalPanel iSectioningPanel = null;
    private VerticalPanel iPanel = null;
    private HorizontalPanel iFilterPanel = null;
    private UniTimeTable<ClassAssignmentInterface.EnrollmentInfo> iCourseTable = null;
    private UniTimeTable<ClassAssignmentInterface.StudentInfo> iStudentTable = null;
    private UniTimeTable<ClassAssignmentInterface.SectioningAction> iLogTable = null;
    private UniTimeDialogBox iEnrollmentDialog = null;
    private EnrollmentTable iEnrollmentTable = null;
    private ScrollPanel iEnrollmentScroll = null;
    private UniTimeTabPanel iTabPanel = null;
    private int iTabIndex = 0;
    private FocusPanel iTabPanelWithFocus = null;
    private OnlineSectioningInterface.SectioningProperties iProperties = null;
    private HTML iError = null;
    private HTML iCourseTableHint;
    private HTML iStudentTableHint;
    private String iLastFilterOnEnter = null;
    private String iCourseFilter = null;
    private SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iCourseFilterRequest = null;
    private Set<OnlineSectioningInterface.StudentStatusInfo> iStates = null;
    private StudentStatusDialog iStudentStatusDialog = null;
    private int iStatusColumn = 0;
    private int iNoteColumn = 0;
    private int iGroupColumn = 0;
    private Set<Long> iSelectedStudentIds = new HashSet<Long>();
    private Set<Long> iSelectedCourseIds = new HashSet<Long>();
    private boolean iOnline;
    private List<UniTimeTableHeader.Operation> iSortOperations = new ArrayList<UniTimeTableHeader.Operation>();

    public SectioningStatusPage(boolean online) {
        this.iOnline = online;
        this.iPanel = new VerticalPanel();
        this.iSectioningPanel = new VerticalPanel();
        this.iFilterPanel = new HorizontalPanel();
        this.iFilterPanel.setSpacing(3);
        Label filterLabel = new Label(MESSAGES.filter());
        this.iFilterPanel.add((Widget)filterLabel);
        this.iFilterPanel.setCellVerticalAlignment((Widget)filterLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iFilter = new SectioningStatusFilterBox(online);
        this.iFilterPanel.add((Widget)this.iFilter);
        this.iSearch = new Button(MESSAGES.buttonSearch());
        Character searchAccessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonSearch());
        if (searchAccessKey != null) {
            this.iSearch.setAccessKey(searchAccessKey.charValue());
        }
        this.iSearch.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iSearch);
        this.iFilterPanel.setCellVerticalAlignment((Widget)this.iSearch, HasVerticalAlignment.ALIGN_TOP);
        this.iExport = new Button(MESSAGES.buttonExport());
        Character exportAccessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonExport());
        if (exportAccessKey != null) {
            this.iExport.setAccessKey(exportAccessKey.charValue());
        }
        this.iExport.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iExport);
        this.iFilterPanel.setCellVerticalAlignment((Widget)this.iExport, HasVerticalAlignment.ALIGN_TOP);
        this.iMore = new Button(MESSAGES.buttonMoreOperations());
        Character moreAccessKey = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonMoreOperations());
        if (moreAccessKey != null) {
            this.iMore.setAccessKey(moreAccessKey.charValue());
        }
        this.iMore.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iMore);
        this.iFilterPanel.setCellVerticalAlignment((Widget)this.iMore, HasVerticalAlignment.ALIGN_TOP);
        this.iMore.setVisible(false);
        this.iMore.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final PopupPanel popup = new PopupPanel(true);
                UniTimeTableHeader.MenuBarWithAccessKeys menu = new UniTimeTableHeader.MenuBarWithAccessKeys();
                boolean first = true;
                if (SectioningStatusPage.this.iOnline && SectioningStatusPage.this.iTabPanel.getSelectedTab() == 1 && SectioningStatusPage.this.iStudentTable.getHeader(0) != null) {
                    for (final UniTimeTableHeader.Operation operation : SectioningStatusPage.this.iStudentTable.getHeader(0).getOperations()) {
                        if (!operation.isApplicable()) continue;
                        if (operation.hasSeparator() && !first) {
                            menu.addSeparator();
                        }
                        first = false;
                        if (operation instanceof UniTimeTableHeader.MenuOperation) {
                            MenuBar submenu = new MenuBar(true);
                            ((UniTimeTableHeader.MenuOperation)operation).generate(popup, submenu);
                            operation.execute();
                            MenuItem item = new MenuItem(operation.getName(), true, submenu);
                            if (operation instanceof UniTimeTableHeader.AriaOperation) {
                                Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), ((UniTimeTableHeader.AriaOperation)operation).getAriaLabel());
                            } else {
                                Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(operation.getName()));
                            }
                            item.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                            menu.addItem(item);
                            continue;
                        }
                        MenuItem item = new MenuItem(operation.getName(), true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                operation.execute();
                            }
                        });
                        if (operation instanceof UniTimeTableHeader.AriaOperation) {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), ((UniTimeTableHeader.AriaOperation)operation).getAriaLabel());
                        } else {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(operation.getName()));
                        }
                        menu.addItem(item);
                    }
                    if (!SectioningStatusPage.this.iSortOperations.isEmpty()) {
                        if (!first) {
                            menu.addSeparator();
                        }
                        MenuBar submenu = new MenuBar(true);
                        for (final UniTimeTableHeader.Operation op : SectioningStatusPage.this.iSortOperations) {
                            String name = op.getName();
                            if (op instanceof UniTimeTableHeader.HasColumnName) {
                                name = ((UniTimeTableHeader.HasColumnName)((Object)op)).getColumnName();
                            }
                            MenuItem item = new MenuItem(name, true, (Scheduler.ScheduledCommand)new Command(){

                                public void execute() {
                                    popup.hide();
                                    op.execute();
                                }
                            });
                            if (op instanceof UniTimeTableHeader.AriaOperation) {
                                Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), ((UniTimeTableHeader.AriaOperation)op).getAriaLabel());
                            } else {
                                Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(op.getName()));
                            }
                            submenu.addItem(item);
                        }
                        MenuItem menuItem = new MenuItem(MESSAGES.opSort(), submenu);
                        menuItem.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                        menu.addItem(menuItem);
                    }
                } else if (!SectioningStatusPage.this.iSortOperations.isEmpty()) {
                    for (final UniTimeTableHeader.Operation operation : SectioningStatusPage.this.iSortOperations) {
                        String name = operation.getName();
                        MenuItem item = new MenuItem(name, true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                operation.execute();
                            }
                        });
                        if (operation instanceof UniTimeTableHeader.AriaOperation) {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), ((UniTimeTableHeader.AriaOperation)operation).getAriaLabel());
                        } else {
                            Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(operation.getName()));
                        }
                        menu.addItem(item);
                    }
                }
                popup.add((Widget)menu);
                popup.showRelativeTo((UIObject)event.getSource());
                menu.focus();
            }
        });
        this.iLoadingImage = new Image(RESOURCES.loading_small());
        this.iLoadingImage.setVisible(false);
        this.iFilterPanel.add((Widget)this.iLoadingImage);
        this.iFilterPanel.setCellVerticalAlignment((Widget)this.iLoadingImage, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iSectioningPanel.add((Widget)this.iFilterPanel);
        this.iSectioningPanel.setCellHorizontalAlignment((Widget)this.iFilterPanel, HasHorizontalAlignment.ALIGN_CENTER);
        this.iCourseTable = new UniTimeTable();
        this.iCourseTable.addStyleName("unitime-EnrollmentsTable");
        this.iStudentTable = new UniTimeTable();
        this.iStudentTable.addStyleName("unitime-StudentsTable");
        this.iLogTable = new UniTimeTable();
        this.iLogTable.addStyleName("unitime-LogsTable");
        VerticalPanel courseTableWithHint = new VerticalPanel();
        courseTableWithHint.add(this.iCourseTable);
        this.iCourseTableHint = new HTML(MESSAGES.sectioningStatusReservationHint());
        this.iCourseTableHint.setStyleName("unitime-Hint");
        courseTableWithHint.add((Widget)this.iCourseTableHint);
        courseTableWithHint.setCellHorizontalAlignment((Widget)this.iCourseTableHint, HasHorizontalAlignment.ALIGN_RIGHT);
        VerticalPanel studentTableWithHint = new VerticalPanel();
        studentTableWithHint.add(this.iStudentTable);
        this.iStudentTableHint = new HTML(MESSAGES.sectioningStatusPriorityHint());
        this.iStudentTableHint.setStyleName("unitime-Hint");
        studentTableWithHint.add((Widget)this.iStudentTableHint);
        studentTableWithHint.setCellHorizontalAlignment((Widget)this.iStudentTableHint, HasHorizontalAlignment.ALIGN_RIGHT);
        this.iTabPanel = new UniTimeTabPanel();
        this.iTabPanel.add((Widget)courseTableWithHint, MESSAGES.tabEnrollments(), true);
        this.iTabPanel.selectTab(0);
        this.iTabPanel.add((Widget)studentTableWithHint, MESSAGES.tabStudents(), true);
        this.iTabPanel.setVisible(false);
        this.iTabPanel.addSelectionHandler(new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                SectioningStatusPage.this.iTabIndex = (Integer)event.getSelectedItem();
                SectioningStatusPage.this.iMore.setVisible(SectioningStatusPage.this.iTabIndex == 0 && SectioningStatusPage.this.iCourseTable.getRowCount() > 2 || SectioningStatusPage.this.iTabIndex == 1 && SectioningStatusPage.this.iStudentTable.getRowCount() > 2 || SectioningStatusPage.this.iTabIndex == 2 && SectioningStatusPage.this.iLogTable.getRowCount() > 1);
                SectioningStatusPage.this.loadDataIfNeeded();
            }
        });
        this.iTabPanelWithFocus = new FocusPanel((Widget)this.iTabPanel);
        this.iTabPanelWithFocus.setStyleName("unitime-FocusPanel");
        this.iSectioningPanel.add((Widget)this.iTabPanelWithFocus);
        this.iTabPanelWithFocus.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == 101 || event.getNativeKeyCode() == 69)) {
                    SectioningStatusPage.this.iTabPanel.selectTab(0);
                    event.preventDefault();
                }
                if (event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == 115 || event.getNativeKeyCode() == 83)) {
                    SectioningStatusPage.this.iTabPanel.selectTab(1);
                    event.preventDefault();
                }
                if (event.getNativeEvent().getCtrlKey() && (event.getNativeKeyCode() == 108 || event.getNativeKeyCode() == 76) && SectioningStatusPage.this.iTabPanel.getTabCount() >= 3) {
                    SectioningStatusPage.this.iTabPanel.selectTab(2);
                    event.preventDefault();
                }
            }
        });
        this.iSectioningPanel.setWidth("100%");
        this.iPanel.add((Widget)this.iSectioningPanel);
        this.iError = new HTML();
        this.iError.setStyleName("unitime-ErrorMessage");
        this.iError.setVisible(false);
        this.iPanel.add((Widget)this.iError);
        this.iPanel.setCellHorizontalAlignment((Widget)this.iError, HasHorizontalAlignment.ALIGN_CENTER);
        this.initWidget((Widget)this.iPanel);
        this.iSearch.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningStatusPage.this.loadData();
            }
        });
        this.iExport.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningStatusPage.this.exportData();
            }
        });
        this.iFilter.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    if (SectioningStatusPage.this.iFilter.getValue().equals(SectioningStatusPage.this.iLastFilterOnEnter) && !SectioningStatusPage.this.iFilter.getValue().equals(SectioningStatusPage.this.iCourseFilter)) {
                        SectioningStatusPage.this.loadData();
                    } else {
                        SectioningStatusPage.this.iLastFilterOnEnter = SectioningStatusPage.this.iFilter.getValue();
                    }
                }
            }
        });
        this.iCourseTable.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.EnrollmentInfo>(){

            @Override
            public void onMouseClick(final UniTimeTable.TableEvent<ClassAssignmentInterface.EnrollmentInfo> event) {
                if (event.getData() == null || event.getData().getCourseId() == null) {
                    return;
                }
                SectioningStatusPage.this.iCourseTable.clearHover();
                SectioningStatusPage.this.setLoading(true);
                final Long id = event.getData().getConfigId() == null ? event.getData().getOfferingId() : -event.getData().getClazzId().longValue();
                SectioningStatusPage.this.iError.setVisible(false);
                if (event.getData().getConfigId() == null) {
                    LoadingWidget.getInstance().show(MESSAGES.loadingEnrollments(MESSAGES.course(event.getData().getSubject(), event.getData().getCourseNbr())));
                } else {
                    LoadingWidget.getInstance().show(MESSAGES.loadingEnrollments(MESSAGES.clazz(event.getData().getSubject(), event.getData().getCourseNbr(), event.getData().getSubpart(), event.getData().getClazz())));
                }
                if (SectioningStatusPage.this.iOnline) {
                    SectioningStatusPage.this.iSectioningService.canApprove(id, new AsyncCallback<List<Long>>(){

                        public void onSuccess(final List<Long> courseIdsCanApprove) {
                            SectioningStatusPage.this.iSectioningService.findEnrollments(SectioningStatusPage.this.iOnline, SectioningStatusPage.this.iCourseFilter, SectioningStatusPage.this.iCourseFilterRequest, ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseId(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getClazzId(), new AsyncCallback<List<ClassAssignmentInterface.Enrollment>>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                    SectioningStatusPage.this.setLoading(false);
                                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                                    SectioningStatusPage.this.iError.setVisible(true);
                                    ToolBox.checkAccess(caught);
                                }

                                public void onSuccess(List<ClassAssignmentInterface.Enrollment> result) {
                                    LoadingWidget.getInstance().hide();
                                    SectioningStatusPage.this.setLoading(false);
                                    SectioningStatusPage.this.iEnrollmentTable.clear();
                                    SectioningStatusPage.this.iEnrollmentTable.setId(id);
                                    SectioningStatusPage.this.iEnrollmentTable.populate(result, courseIdsCanApprove);
                                    if (((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getConfigId() == null) {
                                        SectioningStatusPage.this.iEnrollmentDialog.setText(MESSAGES.titleEnrollments(MESSAGES.course(((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubject(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseNbr())));
                                    } else {
                                        SectioningStatusPage.this.iEnrollmentDialog.setText(MESSAGES.titleEnrollments(MESSAGES.clazz(((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubject(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseNbr(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubpart(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getClazz())));
                                    }
                                    SectioningStatusPage.this.iEnrollmentDialog.center();
                                }
                            });
                        }

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                            SectioningStatusPage.this.setLoading(false);
                            SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                            SectioningStatusPage.this.iError.setVisible(true);
                            ToolBox.checkAccess(caught);
                        }
                    });
                } else {
                    SectioningStatusPage.this.iSectioningService.findEnrollments(SectioningStatusPage.this.iOnline, SectioningStatusPage.this.iCourseFilter, SectioningStatusPage.this.iCourseFilterRequest, event.getData().getCourseId(), event.getData().getClazzId(), new AsyncCallback<List<ClassAssignmentInterface.Enrollment>>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                            SectioningStatusPage.this.setLoading(false);
                            SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                            SectioningStatusPage.this.iError.setVisible(true);
                            ToolBox.checkAccess(caught);
                        }

                        public void onSuccess(List<ClassAssignmentInterface.Enrollment> result) {
                            LoadingWidget.getInstance().hide();
                            SectioningStatusPage.this.setLoading(false);
                            SectioningStatusPage.this.iEnrollmentTable.clear();
                            SectioningStatusPage.this.iEnrollmentTable.setId(id);
                            SectioningStatusPage.this.iEnrollmentTable.populate(result, null);
                            if (((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getConfigId() == null) {
                                SectioningStatusPage.this.iEnrollmentDialog.setText(MESSAGES.titleEnrollments(MESSAGES.course(((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubject(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseNbr())));
                            } else {
                                SectioningStatusPage.this.iEnrollmentDialog.setText(MESSAGES.titleEnrollments(MESSAGES.clazz(((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubject(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getCourseNbr(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getSubpart(), ((ClassAssignmentInterface.EnrollmentInfo)event.getData()).getClazz())));
                            }
                            SectioningStatusPage.this.iEnrollmentDialog.center();
                        }
                    });
                }
            }
        });
        this.iStudentTable.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.StudentInfo>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.StudentInfo> event) {
                if (event.getData() == null || event.getData().getStudent() == null) {
                    return;
                }
                SectioningStatusPage.this.iStudentTable.clearHover();
                LoadingWidget.getInstance().show(MESSAGES.loadingEnrollment(event.getData().getStudent().getName()));
                SectioningStatusPage.this.iError.setVisible(false);
                SectioningStatusPage.this.iEnrollmentTable.showStudentSchedule(event.getData().getStudent(), new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                        SectioningStatusPage.this.iError.setVisible(true);
                    }

                    public void onSuccess(Boolean result) {
                        LoadingWidget.getInstance().hide();
                    }
                });
            }
        });
        this.iLogTable.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.SectioningAction>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.SectioningAction> event) {
                if (event.getData() != null && event.getData().getProto() != null) {
                    final HTML widget = new HTML(event.getData().getProto());
                    final ScrollPanel scroll = new ScrollPanel((Widget)widget);
                    scroll.setHeight((int)(0.8 * (double)Window.getClientHeight()) + "px");
                    scroll.setStyleName("unitime-ScrollPanel");
                    final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                    dialog.setWidget((Widget)scroll);
                    dialog.setText(MESSAGES.dialogChangeMessage(event.getData().getStudent().getName()));
                    dialog.setEscapeToHide(true);
                    dialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

                        public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                            RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                            scroll.setHeight(Math.min(widget.getElement().getScrollHeight(), Window.getClientHeight() * 80 / 100) + "px");
                            dialog.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - dialog.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - dialog.getOffsetHeight()) / 2, 0));
                        }
                    });
                    dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                        public void onClose(CloseEvent<PopupPanel> event) {
                            SectioningStatusPage.this.iLogTable.clearHover();
                            RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
                        }
                    });
                    dialog.center();
                }
            }
        });
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                SectioningStatusPage.this.iCourseTable.clearTable();
                SectioningStatusPage.this.iStudentTable.clearTable();
                SectioningStatusPage.this.iLogTable.clearTable();
                if (((String)event.getValue()).endsWith("@")) {
                    SectioningStatusPage.this.iFilter.setValue(((String)event.getValue()).substring(0, ((String)event.getValue()).length() - 1), true);
                    SectioningStatusPage.this.iTabPanel.selectTab(1);
                } else if (((String)event.getValue()).endsWith("$")) {
                    SectioningStatusPage.this.iFilter.setValue(((String)event.getValue()).substring(0, ((String)event.getValue()).length() - 1), true);
                    SectioningStatusPage.this.iTabPanel.selectTab(2);
                } else {
                    SectioningStatusPage.this.iFilter.setValue((String)event.getValue(), true);
                    if (SectioningStatusPage.this.iTabIndex != 0) {
                        SectioningStatusPage.this.iTabPanel.selectTab(0);
                    } else {
                        SectioningStatusPage.this.loadData();
                    }
                }
            }
        });
        this.iEnrollmentTable = new EnrollmentTable(false, this.iOnline);
        this.iEnrollmentScroll = new ScrollPanel((Widget)this.iEnrollmentTable);
        this.iEnrollmentScroll.setHeight((int)(0.8 * (double)Window.getClientHeight()) + "px");
        this.iEnrollmentScroll.setStyleName("unitime-ScrollPanel");
        this.iEnrollmentDialog = new UniTimeDialogBox(true, false);
        this.iEnrollmentDialog.setEscapeToHide(true);
        this.iEnrollmentDialog.setWidget((Widget)this.iEnrollmentScroll);
        this.iEnrollmentDialog.addOpenHandler(new OpenHandler<UniTimeDialogBox>(){

            public void onOpen(OpenEvent<UniTimeDialogBox> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                SectioningStatusPage.this.iEnrollmentScroll.setHeight(Math.min(SectioningStatusPage.this.iEnrollmentTable.getElement().getScrollHeight(), Window.getClientHeight() * 80 / 100) + "px");
                SectioningStatusPage.this.iEnrollmentDialog.setPopupPosition(Math.max(Window.getScrollLeft() + (Window.getClientWidth() - SectioningStatusPage.this.iEnrollmentDialog.getOffsetWidth()) / 2, 0), Math.max(Window.getScrollTop() + (Window.getClientHeight() - SectioningStatusPage.this.iEnrollmentDialog.getOffsetHeight()) / 2, 0));
            }
        });
        this.iEnrollmentTable.getHeader().addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningStatusPage.this.iEnrollmentDialog.hide();
            }
        });
        this.iEnrollmentDialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
            }
        });
        this.iSectioningService.getProperties(null, new AsyncCallback<OnlineSectioningInterface.SectioningProperties>(){

            public void onSuccess(OnlineSectioningInterface.SectioningProperties result) {
                SectioningStatusPage.this.iProperties = result;
                if (SectioningStatusPage.this.iProperties.isChangeLog() && SectioningStatusPage.this.iOnline) {
                    SectioningStatusPage.this.iTabPanel.add((Widget)SectioningStatusPage.this.iLogTable, MESSAGES.tabChangeLog(), true);
                }
                SectioningStatusPage.this.checkLastQuery();
            }

            public void onFailure(Throwable caught) {
                SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                SectioningStatusPage.this.iError.setVisible(true);
            }
        });
        this.iSectioningService.lookupStudentSectioningStates(new AsyncCallback<List<OnlineSectioningInterface.StudentStatusInfo>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(List<OnlineSectioningInterface.StudentStatusInfo> result) {
                SectioningStatusPage.this.iStates = new TreeSet<OnlineSectioningInterface.StudentStatusInfo>(result);
                SectioningStatusPage.this.iStudentStatusDialog = new StudentStatusDialog(SectioningStatusPage.this.iStates);
            }
        });
    }

    private void checkLastQuery() {
        if (Window.Location.getParameter((String)"q") != null) {
            this.iFilter.setValue(Window.Location.getParameter((String)"q"), true);
            if (Window.Location.getParameter((String)"t") != null) {
                if ("2".equals(Window.Location.getParameter((String)"t"))) {
                    this.iTabPanel.selectTab(1);
                } else {
                    this.iTabPanel.selectTab(0);
                }
            } else {
                this.loadData();
            }
        } else if (Window.Location.getHash() != null && !Window.Location.getHash().isEmpty()) {
            String hash = URL.decode((String)Window.Location.getHash().substring(1));
            if (!hash.matches("^[0-9]+\\:?[0-9]*@?$")) {
                if (hash.endsWith("@")) {
                    this.iFilter.setValue(hash.substring(0, hash.length() - 1), true);
                    this.iTabPanel.selectTab(1);
                } else if (hash.endsWith("$")) {
                    this.iFilter.setValue(hash.substring(0, hash.length() - 1), true);
                    this.iTabPanel.selectTab(2);
                } else {
                    this.iFilter.setValue(hash, true);
                    this.loadData();
                }
            }
        } else {
            int t;
            String q = SectioningStatusCookie.getInstance().getQuery(this.iOnline);
            if (q != null) {
                this.iFilter.setValue(q, true);
            }
            if ((t = SectioningStatusCookie.getInstance().getTab(this.iOnline)) >= 0 && t < this.iTabPanel.getTabCount()) {
                this.iTabPanel.selectTab(t, false);
                this.iTabIndex = -1;
            }
            if (GWT_CONSTANTS.searchWhenPageIsLoaded() && q != null && !q.isEmpty()) {
                this.loadData();
            }
        }
    }

    private void setLoading(boolean loading) {
        this.iLoadingImage.setVisible(loading);
        this.iSearch.setVisible(!loading);
        this.iExport.setVisible(!loading);
        if (loading) {
            this.iMore.setVisible(false);
        } else {
            this.iMore.setVisible(this.iTabIndex == 0 && this.iCourseTable.getRowCount() > 2 || this.iTabIndex == 1 && this.iStudentTable.getRowCount() > 2 || this.iTabIndex == 2 && this.iLogTable.getRowCount() > 1);
        }
    }

    private void loadData() {
        this.iCourseTable.clearTable();
        this.iStudentTable.clearTable();
        this.iLogTable.clearTable();
        this.loadDataIfNeeded();
    }

    private void loadDataIfNeeded() {
        if (this.iTabIndex < 0) {
            this.iTabPanel.selectTab(SectioningStatusCookie.getInstance().getTab(this.iOnline));
            return;
        }
        this.iCourseFilter = this.iFilter.getValue();
        this.iCourseFilterRequest = (SectioningStatusFilterBox.SectioningStatusFilterRpcRequest)this.iFilter.getElementsRequest();
        History.newItem((String)(this.iCourseFilter + (this.iTabIndex == 1 ? "@" : (this.iTabIndex == 2 ? "$" : ""))), (boolean)false);
        SectioningStatusCookie.getInstance().setQueryTab(this.iOnline, this.iFilter.getValue(), this.iTabIndex);
        if (this.iFilter.isFilterPopupShowing()) {
            this.iFilter.hideFilterPopup();
        }
        if (this.iTabIndex == 0 && this.iCourseTable.getRowCount() > 0) {
            return;
        }
        if (this.iTabIndex == 1 && this.iStudentTable.getRowCount() > 0) {
            return;
        }
        if (this.iTabIndex == 2 && this.iLogTable.getRowCount() > 0) {
            return;
        }
        LoadingWidget.getInstance().show(MESSAGES.loadingData());
        this.setLoading(true);
        this.iError.setVisible(false);
        if (this.iTabIndex == 0) {
            this.iSectioningService.findEnrollmentInfos(this.iOnline, this.iCourseFilter, this.iCourseFilterRequest, null, new AsyncCallback<List<ClassAssignmentInterface.EnrollmentInfo>>(){

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    SectioningStatusPage.this.setLoading(false);
                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                    SectioningStatusPage.this.iError.setVisible(true);
                    SectioningStatusPage.this.iTabPanel.setVisible(false);
                    ToolBox.checkAccess(caught);
                }

                public void onSuccess(List<ClassAssignmentInterface.EnrollmentInfo> result) {
                    if (result.isEmpty()) {
                        SectioningStatusPage.this.iError.setHTML(MESSAGES.exceptionNoMatchingResultsFound(SectioningStatusPage.this.iCourseFilter));
                        SectioningStatusPage.this.iError.setVisible(true);
                        SectioningStatusPage.this.iTabPanel.setVisible(false);
                    } else {
                        SectioningStatusPage.this.populateCourseTable(result);
                        SectioningStatusPage.this.iTabPanel.setVisible(true);
                    }
                    SectioningStatusPage.this.setLoading(false);
                    LoadingWidget.getInstance().hide();
                }
            });
        } else if (this.iTabIndex == 1) {
            if (this.iOnline) {
                this.iSectioningService.findStudentInfos(this.iOnline, this.iCourseFilter, this.iCourseFilterRequest, new AsyncCallback<List<ClassAssignmentInterface.StudentInfo>>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        SectioningStatusPage.this.setLoading(false);
                        SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                        SectioningStatusPage.this.iError.setVisible(true);
                        SectioningStatusPage.this.iTabPanel.setVisible(false);
                        ToolBox.checkAccess(caught);
                    }

                    public void onSuccess(List<ClassAssignmentInterface.StudentInfo> result) {
                        if (result.isEmpty()) {
                            SectioningStatusPage.this.iError.setHTML(MESSAGES.exceptionNoMatchingResultsFound(SectioningStatusPage.this.iCourseFilter));
                            SectioningStatusPage.this.iError.setVisible(true);
                            SectioningStatusPage.this.iTabPanel.setVisible(false);
                        } else {
                            SectioningStatusPage.this.populateStudentTable(result);
                            SectioningStatusPage.this.iTabPanel.setVisible(true);
                        }
                        SectioningStatusPage.this.setLoading(false);
                        LoadingWidget.getInstance().hide();
                    }
                });
            } else {
                this.iSectioningService.findStudentInfos(this.iOnline, this.iCourseFilter, this.iCourseFilterRequest, new AsyncCallback<List<ClassAssignmentInterface.StudentInfo>>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        SectioningStatusPage.this.setLoading(false);
                        SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                        SectioningStatusPage.this.iError.setVisible(true);
                        SectioningStatusPage.this.iTabPanel.setVisible(false);
                        ToolBox.checkAccess(caught);
                    }

                    public void onSuccess(List<ClassAssignmentInterface.StudentInfo> result) {
                        if (result.isEmpty()) {
                            SectioningStatusPage.this.iError.setHTML(MESSAGES.exceptionNoMatchingResultsFound(SectioningStatusPage.this.iCourseFilter));
                            SectioningStatusPage.this.iError.setVisible(true);
                            SectioningStatusPage.this.iTabPanel.setVisible(false);
                        } else {
                            SectioningStatusPage.this.populateStudentTable(result);
                            SectioningStatusPage.this.iTabPanel.setVisible(true);
                        }
                        SectioningStatusPage.this.setLoading(false);
                        LoadingWidget.getInstance().hide();
                    }
                });
            }
        } else if (this.iOnline) {
            this.iSectioningService.changeLog(this.iCourseFilter, new AsyncCallback<List<ClassAssignmentInterface.SectioningAction>>(){

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    SectioningStatusPage.this.setLoading(false);
                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                    SectioningStatusPage.this.iError.setVisible(true);
                    SectioningStatusPage.this.iTabPanel.setVisible(false);
                    ToolBox.checkAccess(caught);
                }

                public void onSuccess(List<ClassAssignmentInterface.SectioningAction> result) {
                    SectioningStatusPage.this.populateChangeLog(result);
                    SectioningStatusPage.this.iTabPanel.setVisible(true);
                    SectioningStatusPage.this.setLoading(false);
                    LoadingWidget.getInstance().hide();
                }
            });
        }
    }

    private void exportData() {
        int tab = this.iTabIndex;
        if (tab < 0) {
            tab = SectioningStatusCookie.getInstance().getTab(this.iOnline);
        }
        String query = "output=student-dashboard.csv&online=" + (this.iOnline ? 1 : 0) + "&tab=" + tab + "&sort=" + SectioningStatusCookie.getInstance().getSortBy(this.iOnline, tab);
        if (tab == 0) {
            for (Long courseId : this.iSelectedCourseIds) {
                query = query + "&c=" + courseId;
            }
        }
        query = query + "&query=" + URL.encodeQueryString((String)this.iFilter.getValue());
        Object req = this.iFilter.getElementsRequest();
        if (((EventInterface.FilterRpcRequest)req).hasOptions()) {
            for (Map.Entry<String, Set<String>> option : ((EventInterface.FilterRpcRequest)req).getOptions().entrySet()) {
                for (String value : option.getValue()) {
                    query = query + "&f:" + option.getKey() + "=" + URL.encodeQueryString((String)value);
                }
            }
        }
        if (((EventInterface.FilterRpcRequest)req).getText() != null && !((EventInterface.FilterRpcRequest)req).getText().isEmpty()) {
            query = query + "&f:text=" + URL.encodeQueryString((String)((EventInterface.FilterRpcRequest)req).getText());
        }
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(query), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }

    private List<Widget> line(final ClassAssignmentInterface.EnrollmentInfo e) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        if (e.getConfigId() == null) {
            if (e.getCourseId() != null) {
                final Image showDetails = new Image(RESOURCES.treeClosed());
                showDetails.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        final int row = SectioningStatusPage.this.iCourseTable.getCellForEvent(event).getRowIndex();
                        if (row + 1 == SectioningStatusPage.this.iCourseTable.getRowCount() || ((ClassAssignmentInterface.EnrollmentInfo)SectioningStatusPage.this.iCourseTable.getData(row + 1)).getConfigId() == null) {
                            SectioningStatusPage.this.setLoading(true);
                            SectioningStatusPage.this.iError.setVisible(false);
                            showDetails.setResource(RESOURCES.treeOpen());
                            SectioningStatusPage.this.iSectioningService.findEnrollmentInfos(SectioningStatusPage.this.iOnline, SectioningStatusPage.this.iCourseFilter, SectioningStatusPage.this.iCourseFilterRequest, e.getCourseId(), new AsyncCallback<List<ClassAssignmentInterface.EnrollmentInfo>>(){

                                public void onFailure(Throwable caught) {
                                    SectioningStatusPage.this.setLoading(false);
                                    SectioningStatusPage.this.iError.setHTML(caught.getMessage());
                                    SectioningStatusPage.this.iError.setVisible(true);
                                    ToolBox.checkAccess(caught);
                                }

                                public void onSuccess(List<ClassAssignmentInterface.EnrollmentInfo> result) {
                                    SectioningStatusPage.this.iSelectedCourseIds.add(e.getCourseId());
                                    SectioningStatusPage.this.setLoading(false);
                                    int r = row + 1;
                                    for (ClassAssignmentInterface.EnrollmentInfo e : result) {
                                        SectioningStatusPage.this.iCourseTable.insertRow(r);
                                        SectioningStatusPage.this.iCourseTable.setRow(r, e, SectioningStatusPage.this.line(e));
                                        ++r;
                                    }
                                }
                            });
                        } else {
                            for (int r = row + 1; r < SectioningStatusPage.this.iCourseTable.getRowCount() && ((ClassAssignmentInterface.EnrollmentInfo)SectioningStatusPage.this.iCourseTable.getData(r)).getConfigId() != null; ++r) {
                                SectioningStatusPage.this.iCourseTable.getRowFormatter().setVisible(r, !SectioningStatusPage.this.iCourseTable.getRowFormatter().isVisible(r));
                            }
                            if (SectioningStatusPage.this.iSelectedCourseIds.remove(e.getCourseId())) {
                                showDetails.setResource(RESOURCES.treeClosed());
                            } else {
                                SectioningStatusPage.this.iSelectedCourseIds.add(e.getCourseId());
                                showDetails.setResource(RESOURCES.treeOpen());
                            }
                        }
                        event.getNativeEvent().stopPropagation();
                        event.getNativeEvent().preventDefault();
                    }
                });
                line.add((Widget)showDetails);
            } else {
                line.add((Widget)new Label());
            }
            line.add((Widget)new Label(e.getSubject(), false));
            line.add((Widget)new Label(e.getCourseNbr(), false));
            line.add((Widget)new TitleCell(e.getTitle() == null ? "" : e.getTitle()));
            line.add((Widget)new Label(e.getConsent() == null ? "" : e.getConsent(), false));
        } else {
            line.add((Widget)new Label());
            line.add((Widget)new HTML("&nbsp;&nbsp;" + (e.getSubpart() == null ? "" : e.getIndent() + e.getSubpart()), false));
            line.add((Widget)new HTML(e.getClazz() == null ? "" : e.getIndent() + e.getClazz(), false));
            line.add((Widget)new Label(e.getAssignment().getDays().isEmpty() ? "" : e.getAssignment().getDaysString(CONSTANTS.shortDays()) + " " + e.getAssignment().getStartString(CONSTANTS.useAmPm()) + " - " + e.getAssignment().getEndString(CONSTANTS.useAmPm()), false));
            line.add((Widget)new Label(!e.getAssignment().hasDatePattern() ? "" : e.getAssignment().getDatePattern(), false));
            line.add((Widget)new RoomsCell(e.getAssignment().getRooms(), ","));
        }
        if (e.getCourseId() == null) {
            line.add((Widget)new NumberCell(e.getAvailable(), e.getLimit()));
        } else {
            line.add((Widget)new AvailableCell(e));
        }
        line.add((Widget)new NumberCell(null, e.getProjection()));
        line.add((Widget)new NumberCell(e.getEnrollment(), e.getTotalEnrollment()));
        line.add((Widget)new WaitListCell(e));
        line.add((Widget)new NumberCell(e.getUnassignedAlternative(), e.getTotalUnassignedAlternative()));
        line.add((Widget)new NumberCell(e.getReservation(), e.getTotalReservation()));
        line.add((Widget)new NumberCell(e.getConsentNeeded(), e.getTotalConsentNeeded()));
        line.add((Widget)new NumberCell(e.getOverrideNeeded(), e.getTotalOverrideNeeded()));
        return line;
    }

    public void populateCourseTable(List<ClassAssignmentInterface.EnrollmentInfo> result) {
        this.iSelectedCourseIds.clear();
        this.iSortOperations.clear();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        UniTimeTableHeader hOperations = new UniTimeTableHeader("");
        header.add(hOperations);
        UniTimeTableHeader hSubject = new UniTimeTableHeader(MESSAGES.colSubject() + "<br>&nbsp;&nbsp;" + MESSAGES.colSubpart());
        header.add(hSubject);
        this.addSortOperation(hSubject, EnrollmentComparator.SortBy.SUBJECT, MESSAGES.colSubject());
        UniTimeTableHeader hCourse = new UniTimeTableHeader(MESSAGES.colCourse() + "<br>" + MESSAGES.colClass());
        header.add(hCourse);
        this.addSortOperation(hCourse, EnrollmentComparator.SortBy.COURSE, MESSAGES.colCourse());
        UniTimeTableHeader hTitleSubpart = new UniTimeTableHeader(MESSAGES.colTitle() + "<br>" + MESSAGES.colTime());
        header.add(hTitleSubpart);
        this.addSortOperation(hTitleSubpart, EnrollmentComparator.SortBy.TITLE, MESSAGES.colTitle());
        UniTimeTableHeader hStart = new UniTimeTableHeader("<br>" + MESSAGES.colDate());
        header.add(hStart);
        UniTimeTableHeader hRoom = new UniTimeTableHeader(MESSAGES.colConsent() + "<br>" + MESSAGES.colRoom());
        header.add(hRoom);
        this.addSortOperation(hRoom, EnrollmentComparator.SortBy.CONSENT, MESSAGES.colConsent());
        UniTimeTableHeader hLimit = new UniTimeTableHeader(MESSAGES.colAvailable());
        hLimit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hLimit);
        this.addSortOperation(hLimit, EnrollmentComparator.SortBy.LIMIT, MESSAGES.colAvailable());
        UniTimeTableHeader hProjection = new UniTimeTableHeader(MESSAGES.colProjection());
        hProjection.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hProjection);
        this.addSortOperation(hProjection, EnrollmentComparator.SortBy.PROJECTION, MESSAGES.colProjection());
        UniTimeTableHeader hEnrollment = new UniTimeTableHeader(MESSAGES.colEnrollment());
        hEnrollment.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hEnrollment);
        this.addSortOperation(hEnrollment, EnrollmentComparator.SortBy.ENROLLMENT, MESSAGES.colEnrollment());
        UniTimeTableHeader hWaitListed = new UniTimeTableHeader(MESSAGES.colWaitListed());
        hWaitListed.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hWaitListed);
        this.addSortOperation(hWaitListed, EnrollmentComparator.SortBy.WAITLIST, MESSAGES.colWaitListed());
        UniTimeTableHeader hAlternative = new UniTimeTableHeader(MESSAGES.colUnassignedAlternative());
        hAlternative.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hAlternative);
        this.addSortOperation(hAlternative, EnrollmentComparator.SortBy.ALTERNATIVES, MESSAGES.colUnassignedAlternative().replace("<br>", " "));
        UniTimeTableHeader hReserved = new UniTimeTableHeader(MESSAGES.colReserved());
        hReserved.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hReserved);
        this.addSortOperation(hReserved, EnrollmentComparator.SortBy.RESERVATION, MESSAGES.colReserved());
        UniTimeTableHeader hConsent = new UniTimeTableHeader(MESSAGES.colNeedConsent());
        hConsent.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hConsent);
        this.addSortOperation(hConsent, EnrollmentComparator.SortBy.NEED_CONSENT, MESSAGES.colNeedConsent().replace("<br>", " "));
        UniTimeTableHeader hOverride = new UniTimeTableHeader(MESSAGES.colNeedOverride());
        hOverride.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        header.add(hOverride);
        this.addSortOperation(hOverride, EnrollmentComparator.SortBy.NEED_OVERRIDE, MESSAGES.colNeedOverride().replace("<br>", " "));
        this.iCourseTable.addRow(null, header);
        boolean hasReservation = false;
        for (ClassAssignmentInterface.EnrollmentInfo e : result) {
            this.iCourseTable.addRow(e, this.line(e));
            if (!hasReservation && AvailableCell.hasReservedSpace(e)) {
                hasReservation = true;
            }
            this.iCourseTable.getRowFormatter().getElement(this.iCourseTable.getRowCount() - 1).addClassName("course-line");
        }
        if (this.iCourseTable.getRowCount() >= 2) {
            for (int c = 0; c < this.iCourseTable.getCellCount(this.iCourseTable.getRowCount() - 1); ++c) {
                this.iCourseTable.getCellFormatter().setStyleName(this.iCourseTable.getRowCount() - 1, c, "unitime-TotalRow");
            }
            this.iCourseTable.getRowFormatter().getElement(this.iCourseTable.getRowCount() - 1).getStyle().clearBackgroundColor();
        }
        this.iCourseTableHint.setVisible(hasReservation);
        if (SectioningStatusCookie.getInstance().getSortBy(this.iOnline, 0) != 0) {
            boolean asc = SectioningStatusCookie.getInstance().getSortBy(this.iOnline, 0) > 0;
            EnrollmentComparator.SortBy sort = EnrollmentComparator.SortBy.values()[Math.abs(SectioningStatusCookie.getInstance().getSortBy(this.iOnline, 0)) - 1];
            switch (sort) {
                case COURSE: {
                    this.iCourseTable.sort(hCourse, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case SUBJECT: {
                    this.iCourseTable.sort(hSubject, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case TITLE: {
                    this.iCourseTable.sort(hTitleSubpart, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case CONSENT: {
                    this.iCourseTable.sort(hRoom, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case LIMIT: {
                    this.iCourseTable.sort(hLimit, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case PROJECTION: {
                    this.iCourseTable.sort(hProjection, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case ENROLLMENT: {
                    this.iCourseTable.sort(hEnrollment, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case NEED_CONSENT: {
                    this.iCourseTable.sort(hConsent, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case RESERVATION: {
                    this.iCourseTable.sort(hReserved, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case WAITLIST: {
                    this.iCourseTable.sort(hWaitListed, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case ALTERNATIVES: {
                    this.iCourseTable.sort(hAlternative, new EnrollmentComparator(sort, asc), asc);
                    break;
                }
                case NEED_OVERRIDE: {
                    this.iCourseTable.sort(hOverride, new EnrollmentComparator(sort, asc), asc);
                }
            }
        }
    }

    public void populateStudentTable(List<ClassAssignmentInterface.StudentInfo> result) {
        this.iSortOperations.clear();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        if (this.iOnline && this.iProperties != null && this.iProperties.isCanSelectStudent()) {
            UniTimeTableHeader hSelect = new UniTimeTableHeader("&otimes;", HasHorizontalAlignment.ALIGN_CENTER);
            header.add(hSelect);
            hSelect.setWidth("10px");
            hSelect.addAdditionalStyleName("unitime-NoPrint");
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.selectAll();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() != SectioningStatusPage.this.iStudentTable.getRowCount() + 2;
                }

                public void execute() {
                    SectioningStatusPage.this.iSelectedStudentIds.clear();
                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                        Widget w;
                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                        if (i == null || i.getStudent() == null || !((w = SectioningStatusPage.this.iStudentTable.getWidget(row, 0)) instanceof CheckBox)) continue;
                        ((CheckBox)w).setValue(Boolean.valueOf(true));
                        SectioningStatusPage.this.iSelectedStudentIds.add(i.getStudent().getId());
                    }
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.clearAll();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0;
                }

                public void execute() {
                    SectioningStatusPage.this.iSelectedStudentIds.clear();
                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                        Widget w;
                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                        if (i == null || i.getStudent() == null || !((w = SectioningStatusPage.this.iStudentTable.getWidget(row, 0)) instanceof CheckBox)) continue;
                        ((CheckBox)w).setValue(Boolean.valueOf(false));
                    }
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.sendStudentEmail();
                }

                public boolean hasSeparator() {
                    return true;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isEmail() && SectioningStatusPage.this.iStudentStatusDialog != null;
                }

                public void execute() {
                    SectioningStatusPage.this.iStudentStatusDialog.sendStudentEmail(new Command(){

                        public void execute() {
                            ArrayList<Long> studentIds = new ArrayList<Long>();
                            for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                if (i == null || i.getStudent() == null || !SectioningStatusPage.this.iSelectedStudentIds.contains(i.getStudent().getId())) continue;
                                studentIds.add(i.getStudent().getId());
                                SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)new Image(RESOURCES.loading_small()));
                            }
                            SectioningStatusPage.this.sendEmail(studentIds.iterator(), SectioningStatusPage.this.iStudentStatusDialog.getSubject(), SectioningStatusPage.this.iStudentStatusDialog.getMessage(), SectioningStatusPage.this.iStudentStatusDialog.getCC(), 0);
                        }
                    });
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.massCancel();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isMassCancel() && SectioningStatusPage.this.iStudentStatusDialog != null;
                }

                public void execute() {
                    SectioningStatusPage.this.iStudentStatusDialog.massCancel(new Command(){

                        public void execute() {
                            if (!Window.confirm((String)MESSAGES.massCancelConfirmation())) {
                                return;
                            }
                            final ArrayList<Long> studentIds = new ArrayList<Long>();
                            for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                if (i == null || i.getStudent() == null || !SectioningStatusPage.this.iSelectedStudentIds.contains(i.getStudent().getId())) continue;
                                studentIds.add(i.getStudent().getId());
                                SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)new Image(RESOURCES.loading_small()));
                            }
                            LoadingWidget.getInstance().show(MESSAGES.massCanceling());
                            SectioningStatusPage.this.iSectioningService.massCancel(studentIds, SectioningStatusPage.this.iStudentStatusDialog.getStatus(), SectioningStatusPage.this.iStudentStatusDialog.getSubject(), SectioningStatusPage.this.iStudentStatusDialog.getMessage(), SectioningStatusPage.this.iStudentStatusDialog.getCC(), new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                        if (i == null || i.getStudent() == null || !studentIds.contains(i.getStudent().getId())) continue;
                                        HTML error = new HTML(caught.getMessage());
                                        error.setStyleName("unitime-ErrorMessage");
                                        SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)error);
                                        i.setEmailDate(null);
                                    }
                                }

                                public void onSuccess(Boolean result) {
                                    LoadingWidget.getInstance().hide();
                                    SectioningStatusPage.this.loadData();
                                }
                            });
                        }
                    });
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.requestStudentUpdate();
                }

                public boolean hasSeparator() {
                    return true;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isRequestUpdate();
                }

                public void execute() {
                    ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                    LoadingWidget.getInstance().show(MESSAGES.requestingStudentUpdate());
                    SectioningStatusPage.this.iSectioningService.requestStudentUpdate(studentIds, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.info(MESSAGES.requestStudentUpdateSuccess());
                        }
                    });
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.checkOverrideStatus();
                }

                public boolean hasSeparator() {
                    return !SectioningStatusPage.this.iProperties.isRequestUpdate();
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isCheckStudentOverrides();
                }

                public void execute() {
                    ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                    LoadingWidget.getInstance().show(MESSAGES.checkingOverrideStatus());
                    SectioningStatusPage.this.iSectioningService.checkStudentOverrides(studentIds, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.info(MESSAGES.checkStudentOverridesSuccess());
                            SectioningStatusPage.this.loadData();
                        }
                    });
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.validateStudentOverrides();
                }

                public boolean hasSeparator() {
                    return !SectioningStatusPage.this.iProperties.isRequestUpdate() && !SectioningStatusPage.this.iProperties.isChangeStatus();
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isValidateStudentOverrides();
                }

                public void execute() {
                    ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                    LoadingWidget.getInstance().show(MESSAGES.validatingStudentOverrides());
                    SectioningStatusPage.this.iSectioningService.validateStudentOverrides(studentIds, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.error(caught);
                        }

                        public void onSuccess(Boolean result) {
                            LoadingWidget.getInstance().hide();
                            UniTimeNotifications.info(MESSAGES.validateStudentOverridesSuccess());
                            SectioningStatusPage.this.loadData();
                        }
                    });
                }
            });
            if (this.iStates != null) {
                boolean first = true;
                for (final OnlineSectioningInterface.StudentStatusInfo info : this.iStates) {
                    final boolean separator = first;
                    first = false;
                    hSelect.addOperation(new UniTimeTableHeader.Operation(){

                        public String getName() {
                            return MESSAGES.changeStatusTo(info.getLabel());
                        }

                        public boolean hasSeparator() {
                            return separator;
                        }

                        public boolean isApplicable() {
                            return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isChangeStatus();
                        }

                        public void execute() {
                            ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                            LoadingWidget.getInstance().show(MESSAGES.changingStatusTo(info.getLabel()));
                            SectioningStatusPage.this.iSectioningService.changeStatus(studentIds, null, info.getReference(), new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                }

                                public void onSuccess(Boolean result) {
                                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                        Widget w;
                                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                        if (i == null || i.getStudent() == null || !((w = SectioningStatusPage.this.iStudentTable.getWidget(row, 0)) instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                                        i.setStatus(info.getReference());
                                        ((HTML)SectioningStatusPage.this.iStudentTable.getWidget(row, SectioningStatusPage.this.iStatusColumn)).setHTML(info.getReference());
                                    }
                                    LoadingWidget.getInstance().hide();
                                }
                            });
                        }
                    });
                }
            }
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.setStudentStatus();
                }

                public boolean hasSeparator() {
                    return true;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isChangeStatus() && SectioningStatusPage.this.iStudentStatusDialog != null;
                }

                public void execute() {
                    SectioningStatusPage.this.iStudentStatusDialog.setStatus(new Command(){

                        public void execute() {
                            final String statusRef = SectioningStatusPage.this.iStudentStatusDialog.getStatus();
                            if ("-".equals(statusRef)) {
                                return;
                            }
                            ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                            LoadingWidget.getInstance().show(MESSAGES.changingStatusTo(statusRef));
                            SectioningStatusPage.this.iSectioningService.changeStatus(studentIds, null, statusRef, new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                }

                                public void onSuccess(Boolean result) {
                                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                        Widget w;
                                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                        if (i == null || i.getStudent() == null || !((w = SectioningStatusPage.this.iStudentTable.getWidget(row, 0)) instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                                        i.setStatus(statusRef);
                                        ((HTML)SectioningStatusPage.this.iStudentTable.getWidget(row, SectioningStatusPage.this.iStatusColumn)).setHTML(statusRef);
                                    }
                                    LoadingWidget.getInstance().hide();
                                }
                            });
                        }
                    });
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.Operation(){

                public String getName() {
                    return MESSAGES.setStudentNote();
                }

                public boolean hasSeparator() {
                    return false;
                }

                public boolean isApplicable() {
                    return SectioningStatusPage.this.iOnline && SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.isChangeStatus() && SectioningStatusPage.this.iStudentStatusDialog != null;
                }

                public void execute() {
                    SectioningStatusPage.this.iStudentStatusDialog.setStudentNote(new Command(){

                        public void execute() {
                            LoadingWidget.getInstance().show(MESSAGES.changingStudentNote());
                            ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                            final String statusRef = SectioningStatusPage.this.iStudentStatusDialog.getStatus();
                            final String note = SectioningStatusPage.this.iStudentStatusDialog.getNote();
                            SectioningStatusPage.this.iSectioningService.changeStatus(studentIds, note, statusRef, new AsyncCallback<Boolean>(){

                                public void onFailure(Throwable caught) {
                                    LoadingWidget.getInstance().hide();
                                    UniTimeNotifications.error(caught);
                                }

                                public void onSuccess(Boolean result) {
                                    for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                        Widget w;
                                        ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                        if (i == null || i.getStudent() == null || !((w = SectioningStatusPage.this.iStudentTable.getWidget(row, 0)) instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                                        if (!"-".equals(statusRef)) {
                                            i.setStatus(statusRef);
                                            ((HTML)SectioningStatusPage.this.iStudentTable.getWidget(row, SectioningStatusPage.this.iStatusColumn)).setHTML(statusRef);
                                        }
                                        i.setNote(note);
                                        if (SectioningStatusPage.this.iNoteColumn < 0) continue;
                                        HTML n = (HTML)SectioningStatusPage.this.iStudentTable.getWidget(row, SectioningStatusPage.this.iNoteColumn);
                                        n.setHTML(note);
                                        n.setTitle(n.getText());
                                    }
                                    LoadingWidget.getInstance().hide();
                                }
                            });
                        }
                    });
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.MenuOperation(){

                public String getName() {
                    return MESSAGES.opAddToGroup();
                }

                public boolean hasSeparator() {
                    return true;
                }

                public boolean isApplicable() {
                    if (SectioningStatusPage.this.iOnline && SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.hasEditableGroups()) {
                        for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                            ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                            if (i == null || i.getStudent() == null || !SectioningStatusPage.this.iSelectedStudentIds.contains(i.getStudent().getId())) continue;
                            for (OnlineSectioningInterface.StudentGroupInfo g : SectioningStatusPage.this.iProperties.getEditableGroups()) {
                                if (i.getStudent().hasGroup(g.getReference())) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                }

                public void execute() {
                }

                public void generate(final PopupPanel popup, MenuBar menu) {
                    for (final OnlineSectioningInterface.StudentGroupInfo g : SectioningStatusPage.this.iProperties.getEditableGroups()) {
                        boolean canAdd = false;
                        for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                            ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                            if (i == null || i.getStudent() == null || !SectioningStatusPage.this.iSelectedStudentIds.contains(i.getStudent().getId()) || i.getStudent().hasGroup(g.getReference())) continue;
                            canAdd = true;
                            break;
                        }
                        if (!canAdd) continue;
                        MenuItem item = new MenuItem(g.getReference() + " - " + g.getLabel(), true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                                LoadingWidget.getInstance().show(MESSAGES.pleaseWait());
                                SectioningStatusPage.this.iSectioningService.changeStudentGroup(studentIds, g.getUniqueId(), false, new AsyncCallback<Boolean>(){

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.getInstance().hide();
                                        UniTimeNotifications.error(caught);
                                    }

                                    public void onSuccess(Boolean result) {
                                        for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                            Widget w;
                                            ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                            if (i == null || i.getStudent() == null || !((w = SectioningStatusPage.this.iStudentTable.getWidget(row, 0)) instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                                            i.getStudent().addGroup(g.getReference());
                                            if (SectioningStatusPage.this.iGroupColumn < 0) continue;
                                            ((HTML)SectioningStatusPage.this.iStudentTable.getWidget(row, SectioningStatusPage.this.iGroupColumn)).setHTML(i.getStudent().getGroup("<br>"));
                                        }
                                        LoadingWidget.getInstance().hide();
                                    }
                                });
                            }
                        });
                        menu.addItem(item);
                    }
                }
            });
            hSelect.addOperation(new UniTimeTableHeader.MenuOperation(){

                public String getName() {
                    return MESSAGES.opRemoveFromGroup();
                }

                public boolean hasSeparator() {
                    if (SectioningStatusPage.this.iOnline && SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.hasEditableGroups()) {
                        for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                            ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                            if (i == null || i.getStudent() == null || !SectioningStatusPage.this.iSelectedStudentIds.contains(i.getStudent().getId())) continue;
                            for (OnlineSectioningInterface.StudentGroupInfo g : SectioningStatusPage.this.iProperties.getEditableGroups()) {
                                if (i.getStudent().hasGroup(g.getReference())) continue;
                                return false;
                            }
                        }
                    }
                    return true;
                }

                public boolean isApplicable() {
                    if (SectioningStatusPage.this.iOnline && SectioningStatusPage.this.iSelectedStudentIds.size() > 0 && SectioningStatusPage.this.iProperties != null && SectioningStatusPage.this.iProperties.hasEditableGroups()) {
                        for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                            ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                            if (i == null || i.getStudent() == null || !SectioningStatusPage.this.iSelectedStudentIds.contains(i.getStudent().getId())) continue;
                            for (OnlineSectioningInterface.StudentGroupInfo g : SectioningStatusPage.this.iProperties.getEditableGroups()) {
                                if (!i.getStudent().hasGroup(g.getReference())) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                }

                public void execute() {
                }

                public void generate(final PopupPanel popup, MenuBar menu) {
                    for (final OnlineSectioningInterface.StudentGroupInfo g : SectioningStatusPage.this.iProperties.getEditableGroups()) {
                        boolean canDrop = false;
                        for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                            ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                            if (i == null || i.getStudent() == null || !SectioningStatusPage.this.iSelectedStudentIds.contains(i.getStudent().getId()) || !i.getStudent().hasGroup(g.getReference())) continue;
                            canDrop = true;
                            break;
                        }
                        if (!canDrop) continue;
                        MenuItem item = new MenuItem(g.getReference() + " - " + g.getLabel(), true, (Scheduler.ScheduledCommand)new Command(){

                            public void execute() {
                                popup.hide();
                                ArrayList<Long> studentIds = new ArrayList<Long>(SectioningStatusPage.this.iSelectedStudentIds);
                                LoadingWidget.getInstance().show(MESSAGES.pleaseWait());
                                SectioningStatusPage.this.iSectioningService.changeStudentGroup(studentIds, g.getUniqueId(), true, new AsyncCallback<Boolean>(){

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.getInstance().hide();
                                        UniTimeNotifications.error(caught);
                                    }

                                    public void onSuccess(Boolean result) {
                                        for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                                            Widget w;
                                            ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                                            if (i == null || i.getStudent() == null || !((w = SectioningStatusPage.this.iStudentTable.getWidget(row, 0)) instanceof CheckBox) || !((CheckBox)w).getValue().booleanValue()) continue;
                                            i.getStudent().removeGroup(g.getReference());
                                            if (SectioningStatusPage.this.iGroupColumn < 0) continue;
                                            ((HTML)SectioningStatusPage.this.iStudentTable.getWidget(row, SectioningStatusPage.this.iGroupColumn)).setHTML(i.getStudent().getGroup("<br>"));
                                        }
                                        LoadingWidget.getInstance().hide();
                                    }
                                });
                            }
                        });
                        menu.addItem(item);
                    }
                }
            });
        }
        boolean hasExtId = false;
        for (ClassAssignmentInterface.StudentInfo e : result) {
            if (e.getStudent() == null || !e.getStudent().isCanShowExternalId()) continue;
            hasExtId = true;
            break;
        }
        UniTimeTableHeader hExtId = null;
        if (hasExtId) {
            hExtId = new UniTimeTableHeader(MESSAGES.colStudentExternalId());
            header.add(hExtId);
            this.addSortOperation(hExtId, StudentComparator.SortBy.EXTERNAL_ID, MESSAGES.colStudentExternalId());
        }
        UniTimeTableHeader hStudent = new UniTimeTableHeader(MESSAGES.colStudent());
        header.add(hStudent);
        this.addSortOperation(hStudent, StudentComparator.SortBy.STUDENT, MESSAGES.colStudent());
        UniTimeTableHeader hTotal = new UniTimeTableHeader("&nbsp;");
        header.add(hTotal);
        boolean hasEnrollment = false;
        boolean hasWaitList = false;
        boolean hasArea = false;
        boolean hasMajor = false;
        boolean hasGroup = false;
        boolean hasAcmd = false;
        boolean hasReservation = false;
        boolean hasRequestedDate = false;
        boolean hasEnrolledDate = false;
        boolean hasConsent = false;
        boolean hasCredit = false;
        boolean hasReqCred = false;
        boolean hasDistances = false;
        boolean hasOverlaps = false;
        boolean hasFreeTimeOverlaps = false;
        boolean hasPrefIMConfs = false;
        boolean hasPrefSecConfs = false;
        boolean hasNote = false;
        boolean hasEmailed = false;
        boolean hasOverride = false;
        for (ClassAssignmentInterface.StudentInfo e : result) {
            if (e.getStudent() == null) continue;
            if (e.getTotalEnrollment() != null && e.getTotalEnrollment() > 0) {
                hasEnrollment = true;
            }
            if (e.getTotalUnassigned() != null && e.getTotalUnassigned() > 0) {
                hasWaitList = true;
            }
            if (e.getStudent().hasArea()) {
                hasArea = true;
            }
            if (e.getStudent().hasMajor()) {
                hasMajor = true;
            }
            if (e.getStudent().hasGroup()) {
                hasGroup = true;
            }
            if (e.getStudent().hasAccommodation()) {
                hasAcmd = true;
            }
            if (e.getTotalReservation() != null && e.getTotalReservation() > 0) {
                hasReservation = true;
            }
            if (e.getRequestedDate() != null) {
                hasRequestedDate = true;
            }
            if (e.getEnrolledDate() != null) {
                hasEnrolledDate = true;
            }
            if (e.getTotalConsentNeeded() != null && e.getTotalConsentNeeded() > 0) {
                hasConsent = true;
            }
            if (e.getTotalOverrideNeeded() != null && e.getTotalOverrideNeeded() > 0) {
                hasOverride = true;
            }
            if (e.hasTotalCredit()) {
                hasCredit = true;
            }
            if (e.hasTotalRequestCredit()) {
                hasReqCred = true;
            }
            if (e.hasTotalDistanceConflicts()) {
                hasDistances = true;
            }
            if (e.hasOverlappingMinutes()) {
                hasOverlaps = true;
            }
            if (e.hasFreeTimeOverlappingMins()) {
                hasFreeTimeOverlaps = true;
            }
            if (e.hasTotalPrefInstrMethConflict()) {
                hasPrefIMConfs = true;
            }
            if (e.hasTotalPrefSectionConflict()) {
                hasPrefSecConfs = true;
            }
            if (e.hasNote()) {
                hasNote = true;
            }
            if (e.getEmailDate() == null) continue;
            hasEmailed = true;
        }
        if (this.iProperties != null && this.iProperties.isChangeStatus()) {
            hasNote = true;
        }
        if (this.iProperties != null && this.iProperties.hasEditableGroups()) {
            hasGroup = true;
        }
        UniTimeTableHeader hArea = null;
        UniTimeTableHeader hClasf = null;
        if (hasArea) {
            hArea = new UniTimeTableHeader(MESSAGES.colArea());
            header.add(hArea);
            this.addSortOperation(hArea, StudentComparator.SortBy.AREA, MESSAGES.colArea());
            hClasf = new UniTimeTableHeader(MESSAGES.colClassification());
            header.add(hClasf);
            this.addSortOperation(hClasf, StudentComparator.SortBy.CLASSIFICATION, MESSAGES.colClassification());
        }
        UniTimeTableHeader hMajor = null;
        if (hasMajor) {
            hMajor = new UniTimeTableHeader(MESSAGES.colMajor());
            header.add(hMajor);
            this.addSortOperation(hMajor, StudentComparator.SortBy.MAJOR, MESSAGES.colMajor());
        }
        UniTimeTableHeader hGroup = null;
        if (hasGroup) {
            this.iGroupColumn = header.size() - 1;
            hGroup = new UniTimeTableHeader(MESSAGES.colGroup());
            header.add(hGroup);
            this.addSortOperation(hGroup, StudentComparator.SortBy.GROUP, MESSAGES.colGroup());
        } else {
            this.iGroupColumn = -1;
        }
        UniTimeTableHeader hAcmd = null;
        if (hasAcmd) {
            hAcmd = new UniTimeTableHeader(MESSAGES.colAccommodation());
            header.add(hAcmd);
            this.addSortOperation(hAcmd, StudentComparator.SortBy.ACCOMODATION, MESSAGES.colAccommodation());
        }
        this.iStatusColumn = header.size() - 1;
        UniTimeTableHeader hStatus = new UniTimeTableHeader(MESSAGES.colStatus());
        header.add(hStatus);
        this.addSortOperation(hStatus, StudentComparator.SortBy.STATUS, MESSAGES.colStatus());
        UniTimeTableHeader hEnrollment = null;
        if (hasEnrollment) {
            hEnrollment = new UniTimeTableHeader(MESSAGES.colEnrollment());
            hEnrollment.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hEnrollment);
            this.addSortOperation(hEnrollment, StudentComparator.SortBy.ENROLLMENT, MESSAGES.colEnrollment());
        }
        UniTimeTableHeader hWaitlist = null;
        if (hasWaitList) {
            hWaitlist = new UniTimeTableHeader(MESSAGES.colWaitListed());
            hWaitlist.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hWaitlist);
            this.addSortOperation(hWaitlist, StudentComparator.SortBy.WAITLIST, MESSAGES.colWaitListed());
        }
        UniTimeTableHeader hReservation = null;
        if (hasReservation) {
            hReservation = new UniTimeTableHeader(MESSAGES.colReservation());
            hReservation.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hReservation);
            this.addSortOperation(hReservation, StudentComparator.SortBy.RESERVATION, MESSAGES.colReservation());
        }
        UniTimeTableHeader hConsent = null;
        if (hasConsent) {
            hConsent = new UniTimeTableHeader(MESSAGES.colConsent());
            hConsent.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hConsent);
            this.addSortOperation(hConsent, StudentComparator.SortBy.CONSENT, MESSAGES.colConsent());
        }
        UniTimeTableHeader hOverride = null;
        if (hasOverride) {
            hOverride = new UniTimeTableHeader(MESSAGES.colPendingOverrides());
            hOverride.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hOverride);
            this.addSortOperation(hOverride, StudentComparator.SortBy.OVERRIDE, MESSAGES.colPendingOverrides().replace("<br>", " "));
        }
        UniTimeTableHeader hCredit = null;
        if (hasCredit) {
            hCredit = new UniTimeTableHeader(MESSAGES.colEnrollCredit());
            hCredit.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hCredit);
            this.addSortOperation(hCredit, StudentComparator.SortBy.CREDIT, MESSAGES.colEnrollCredit().replace("<br>", " "));
        }
        UniTimeTableHeader hReqCred = null;
        if (hasReqCred) {
            hReqCred = new UniTimeTableHeader(MESSAGES.colRequestCredit());
            hReqCred.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hReqCred);
            this.addSortOperation(hReqCred, StudentComparator.SortBy.REQ_CREDIT, MESSAGES.colRequestCredit().replace("<br>", " "));
        }
        UniTimeTableHeader hDistConf = null;
        if (hasDistances) {
            hDistConf = new UniTimeTableHeader(MESSAGES.colDistanceConflicts());
            hDistConf.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
            header.add(hDistConf);
            this.addSortOperation(hDistConf, StudentComparator.SortBy.DIST_CONF, MESSAGES.colDistanceConflicts().replace("<br>", " "));
        }
        UniTimeTableHeader hShare = null;
        if (hasOverlaps) {
            hShare = new UniTimeTableHeader(MESSAGES.colOverlapMins());
            hShare.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hShare);
            this.addSortOperation(hShare, StudentComparator.SortBy.OVERLAPS, MESSAGES.colOverlapMins());
        }
        UniTimeTableHeader hFTShare = null;
        if (hasFreeTimeOverlaps) {
            hFTShare = new UniTimeTableHeader(MESSAGES.colFreeTimeOverlapMins());
            hFTShare.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hFTShare);
            this.addSortOperation(hFTShare, StudentComparator.SortBy.FT_OVERLAPS, MESSAGES.colFreeTimeOverlapMins());
        }
        UniTimeTableHeader hPrefIMConfs = null;
        if (hasPrefIMConfs) {
            hPrefIMConfs = new UniTimeTableHeader(MESSAGES.colPrefInstrMethConfs());
            hPrefIMConfs.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hPrefIMConfs);
            this.addSortOperation(hPrefIMConfs, StudentComparator.SortBy.PREF_IM, MESSAGES.colPrefInstrMethConfs().replace("<br>", " "));
        }
        UniTimeTableHeader hPrefSecConfs = null;
        if (hasPrefSecConfs) {
            hPrefSecConfs = new UniTimeTableHeader(MESSAGES.colPrefSectionConfs());
            hPrefSecConfs.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
            header.add(hPrefSecConfs);
            this.addSortOperation(hPrefSecConfs, StudentComparator.SortBy.PREF_SEC, MESSAGES.colPrefSectionConfs().replace("<br>", " "));
        }
        UniTimeTableHeader hRequestTS = null;
        if (hasRequestedDate) {
            hRequestTS = new UniTimeTableHeader(MESSAGES.colRequestTimeStamp());
            header.add(hRequestTS);
            this.addSortOperation(hRequestTS, StudentComparator.SortBy.REQUEST_TS, MESSAGES.colRequestTimeStamp());
        }
        UniTimeTableHeader hEnrolledTS = null;
        if (hasEnrolledDate) {
            hEnrolledTS = new UniTimeTableHeader(MESSAGES.colEnrollmentTimeStamp());
            header.add(hEnrolledTS);
            this.addSortOperation(hEnrolledTS, StudentComparator.SortBy.ENROLLMENT_TS, MESSAGES.colEnrollmentTimeStamp());
        }
        UniTimeTableHeader hNote = null;
        if (this.iOnline && hasNote) {
            this.iNoteColumn = header.size() - 1;
            hNote = new UniTimeTableHeader(MESSAGES.colStudentNote());
            header.add(hNote);
            this.addSortOperation(hNote, StudentComparator.SortBy.NOTE, MESSAGES.colStudentNote());
        } else {
            this.iNoteColumn = -1;
        }
        UniTimeTableHeader hEmailTS = null;
        if (this.iOnline && hasEmailed) {
            hEmailTS = new UniTimeTableHeader(MESSAGES.colEmailTimeStamp());
            header.add(hEmailTS);
            this.addSortOperation(hEmailTS, StudentComparator.SortBy.EMAIL_TS, MESSAGES.colEmailTimeStamp());
        }
        this.iStudentTable.addRow(null, header);
        HashSet<Long> newlySelected = new HashSet<Long>();
        for (ClassAssignmentInterface.StudentInfo info : result) {
            ArrayList<Object> line = new ArrayList<Object>();
            if (info.getStudent() != null) {
                if (this.iOnline && this.iProperties != null && this.iProperties.isCanSelectStudent()) {
                    if (info.getStudent().isCanSelect()) {
                        CheckBox ch = new CheckBox();
                        ch.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                event.stopPropagation();
                            }
                        });
                        final Long sid = info.getStudent().getId();
                        if (this.iSelectedStudentIds.contains(sid)) {
                            ch.setValue(Boolean.valueOf(true));
                            newlySelected.add(sid);
                        }
                        ch.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                event.stopPropagation();
                            }
                        });
                        ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                            public void onValueChange(ValueChangeEvent<Boolean> event) {
                                if (((Boolean)event.getValue()).booleanValue()) {
                                    SectioningStatusPage.this.iSelectedStudentIds.add(sid);
                                } else {
                                    SectioningStatusPage.this.iSelectedStudentIds.remove(sid);
                                }
                            }
                        });
                        line.add(ch);
                    } else {
                        line.add(new Label(""));
                    }
                }
                if (hasExtId) {
                    line.add(new Label(info.getStudent().isCanShowExternalId() ? info.getStudent().getExternalId() : "", false));
                }
                line.add(new TitleCell(info.getStudent().getName()));
                if (hasArea) {
                    line.add(new HTML(info.getStudent().getArea("<br>"), false));
                    line.add(new HTML(info.getStudent().getClassification("<br>"), false));
                }
                if (hasMajor) {
                    line.add(new HTML(info.getStudent().getMajor("<br>"), false));
                }
                if (hasGroup) {
                    line.add(new HTML(info.getStudent().getGroup("<br>"), false));
                }
                if (hasAcmd) {
                    line.add(new HTML(info.getStudent().getAccommodation("<br>"), false));
                }
                line.add(new HTML(info.getStatus(), false));
            } else {
                if (this.iOnline && this.iProperties != null && this.iProperties.isCanSelectStudent()) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasExtId) {
                    line.add(new TitleCell(MESSAGES.total()));
                } else {
                    line.add(new Label(MESSAGES.total()));
                }
                line.add(new NumberCell(null, result.size() - 1));
                if (hasArea) {
                    line.add(new HTML("&nbsp;", false));
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasMajor) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasGroup) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasAcmd) {
                    line.add(new HTML("&nbsp;", false));
                }
                line.add(new HTML("&nbsp;", false));
            }
            if (hasEnrollment) {
                line.add(new NumberCell(info.getEnrollment(), info.getTotalEnrollment()));
            }
            if (hasWaitList) {
                line.add(new WaitListCell(info));
            }
            if (hasReservation) {
                line.add(new NumberCell(info.getReservation(), info.getTotalReservation()));
            }
            if (hasConsent) {
                line.add(new NumberCell(info.getConsentNeeded(), info.getTotalConsentNeeded()));
            }
            if (hasOverride) {
                line.add(new NumberCell(info.getOverrideNeeded(), info.getTotalOverrideNeeded()));
            }
            if (hasCredit) {
                line.add(new CreditCell(info));
            }
            if (hasReqCred) {
                line.add(new RequestCreditCell(info.getRequestCreditMin(), info.getRequestCreditMax(), info.getTotalRequestCreditMin(), info.getTotalRequestCreditMax()));
            }
            if (hasDistances) {
                line.add(new DistanceCell(info.getNrDistanceConflicts(), info.getTotalNrDistanceConflicts(), info.getLongestDistanceMinutes(), info.getTotalLongestDistanceMinutes()));
            }
            if (hasOverlaps) {
                line.add(new NumberCell(info.getOverlappingMinutes(), info.getTotalOverlappingMinutes()));
            }
            if (hasFreeTimeOverlaps) {
                line.add(new NumberCell(info.getFreeTimeOverlappingMins(), info.getTotalFreeTimeOverlappingMins()));
            }
            if (hasPrefIMConfs) {
                line.add(new NumberCell(info.getPrefInstrMethConflict(), info.getTotalPrefInstrMethConflict()));
            }
            if (hasPrefSecConfs) {
                line.add(new NumberCell(info.getPrefSectionConflict(), info.getTotalPrefSectionConflict()));
            }
            if (info.getStudent() != null) {
                if (hasRequestedDate) {
                    line.add(new HTML(info.getRequestedDate() == null ? "&nbsp;" : sDF.format(info.getRequestedDate()), false));
                }
                if (hasEnrolledDate) {
                    line.add(new HTML(info.getEnrolledDate() == null ? "&nbsp;" : sDF.format(info.getEnrolledDate()), false));
                }
                if (this.iOnline && hasNote) {
                    HTML note = new HTML(info.hasNote() ? info.getNote() : "");
                    note.addStyleName("student-note");
                    if (info.hasNote()) {
                        note.setTitle(note.getText());
                    }
                    line.add(note);
                }
                if (this.iOnline && hasEmailed) {
                    line.add(new HTML(info.getEmailDate() == null ? "&nbsp;" : sDF.format(info.getEmailDate()), false));
                }
            } else {
                if (hasRequestedDate) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (hasEnrolledDate) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (this.iOnline && hasNote) {
                    line.add(new HTML("&nbsp;", false));
                }
                if (this.iOnline && hasEmailed) {
                    line.add(new HTML("&nbsp;", false));
                }
            }
            this.iStudentTable.addRow(info, line);
        }
        this.iSelectedStudentIds.clear();
        this.iSelectedStudentIds.addAll(newlySelected);
        if (this.iStudentTable.getRowCount() >= 2) {
            for (int c = 0; c < this.iStudentTable.getCellCount(this.iStudentTable.getRowCount() - 1); ++c) {
                this.iStudentTable.getCellFormatter().setStyleName(this.iStudentTable.getRowCount() - 1, c, "unitime-TotalRow");
            }
        }
        this.iStudentTableHint.setVisible(hasWaitList);
        if (SectioningStatusCookie.getInstance().getSortBy(this.iOnline, 1) != 0) {
            boolean asc = SectioningStatusCookie.getInstance().getSortBy(this.iOnline, 1) > 0;
            StudentComparator.SortBy sort = StudentComparator.SortBy.values()[Math.abs(SectioningStatusCookie.getInstance().getSortBy(this.iOnline, 1)) - 1];
            UniTimeTableHeader h = null;
            switch (sort) {
                case ACCOMODATION: {
                    h = hAcmd;
                    break;
                }
                case AREA: {
                    h = hArea;
                    break;
                }
                case CLASSIFICATION: {
                    h = hClasf;
                    break;
                }
                case CONSENT: {
                    h = hConsent;
                    break;
                }
                case CREDIT: {
                    h = hCredit;
                    break;
                }
                case EMAIL_TS: {
                    h = hEmailTS;
                    break;
                }
                case ENROLLMENT: {
                    h = hEnrollment;
                    break;
                }
                case ENROLLMENT_TS: {
                    h = hEnrolledTS;
                    break;
                }
                case EXTERNAL_ID: {
                    h = hExtId;
                    break;
                }
                case GROUP: {
                    h = hGroup;
                    break;
                }
                case MAJOR: {
                    h = hMajor;
                    break;
                }
                case REQUEST_TS: {
                    h = hRequestTS;
                    break;
                }
                case RESERVATION: {
                    h = hReservation;
                    break;
                }
                case STATUS: {
                    h = hStatus;
                    break;
                }
                case STUDENT: {
                    h = hStudent;
                    break;
                }
                case WAITLIST: {
                    h = hWaitlist;
                    break;
                }
                case NOTE: {
                    h = hNote;
                    break;
                }
                case DIST_CONF: {
                    h = hDistConf;
                    break;
                }
                case OVERLAPS: {
                    h = hShare;
                    break;
                }
                case FT_OVERLAPS: {
                    h = hFTShare;
                    break;
                }
                case PREF_IM: {
                    h = hPrefIMConfs;
                    break;
                }
                case PREF_SEC: {
                    h = hPrefSecConfs;
                    break;
                }
                case OVERRIDE: {
                    h = hOverride;
                    break;
                }
                case REQ_CREDIT: {
                    h = hReqCred;
                }
            }
            if (h != null) {
                this.iStudentTable.sort(h, new StudentComparator(sort, asc), asc);
            }
        }
    }

    public void populateChangeLog(List<ClassAssignmentInterface.SectioningAction> result) {
        this.iSortOperations.clear();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        UniTimeTableHeader hStudent = new UniTimeTableHeader(MESSAGES.colStudent());
        header.add(hStudent);
        this.addSortOperation(hStudent, ChangeLogComparator.SortBy.STUDENT, MESSAGES.colStudent());
        UniTimeTableHeader hOp = new UniTimeTableHeader(MESSAGES.colOperation());
        header.add(hOp);
        this.addSortOperation(hOp, ChangeLogComparator.SortBy.OPERATION, MESSAGES.colOperation());
        UniTimeTableHeader hTimeStamp = new UniTimeTableHeader(MESSAGES.colTimeStamp());
        header.add(hTimeStamp);
        this.addSortOperation(hTimeStamp, ChangeLogComparator.SortBy.TIME_STAMP, MESSAGES.colTimeStamp());
        UniTimeTableHeader hExecTime = new UniTimeTableHeader(MESSAGES.colExecutionTime());
        header.add(hExecTime);
        this.addSortOperation(hExecTime, ChangeLogComparator.SortBy.EXEC_TIME, MESSAGES.colExecutionTime());
        UniTimeTableHeader hResult = new UniTimeTableHeader(MESSAGES.colResult());
        header.add(hResult);
        this.addSortOperation(hResult, ChangeLogComparator.SortBy.RESULT, MESSAGES.colResult());
        UniTimeTableHeader hUser = new UniTimeTableHeader(MESSAGES.colUser());
        header.add(hUser);
        this.addSortOperation(hUser, ChangeLogComparator.SortBy.USER, MESSAGES.colUser());
        UniTimeTableHeader hMessage = new UniTimeTableHeader(MESSAGES.colMessage());
        header.add(hMessage);
        this.addSortOperation(hMessage, ChangeLogComparator.SortBy.MESSAGE, MESSAGES.colMessage());
        this.iLogTable.addRow(null, header);
        for (ClassAssignmentInterface.SectioningAction log : result) {
            this.iLogTable.addRow(log, new Widget[]{new EnrollmentTable.TopCell(log.getStudent().getName()), new EnrollmentTable.TopCell(log.getOperation()), new EnrollmentTable.TopCell(sTSF.format(log.getTimeStamp())), new EnrollmentTable.TopCell(log.getWallTime() == null ? "" : sNF.format(0.001 * (double)log.getWallTime().longValue())), new EnrollmentTable.TopCell(log.getResult()), new EnrollmentTable.TopCell(log.getUser() == null ? "" : log.getUser()), new HTML(log.getMessage() == null ? "" : log.getMessage())});
        }
        if (SectioningStatusCookie.getInstance().getSortBy(this.iOnline, 2) != 0) {
            boolean asc = SectioningStatusCookie.getInstance().getSortBy(this.iOnline, 2) > 0;
            ChangeLogComparator.SortBy sort = ChangeLogComparator.SortBy.values()[Math.abs(SectioningStatusCookie.getInstance().getSortBy(this.iOnline, 2)) - 1];
            UniTimeTableHeader h = null;
            switch (sort) {
                case MESSAGE: {
                    h = hMessage;
                    break;
                }
                case OPERATION: {
                    h = hOp;
                    break;
                }
                case RESULT: {
                    h = hResult;
                    break;
                }
                case STUDENT: {
                    h = hStudent;
                    break;
                }
                case TIME_STAMP: {
                    h = hTimeStamp;
                    break;
                }
                case USER: {
                    h = hUser;
                }
            }
            if (h != null) {
                this.iLogTable.sort(h, new ChangeLogComparator(sort), asc);
            }
        }
    }

    protected void addSortOperation(final UniTimeTableHeader header, final EnrollmentComparator.SortBy sort, final String column) {
        SortOperation op = new SortOperation(){

            public void execute() {
                boolean asc = header.getOrder() == null ? true : header.getOrder() == false;
                SectioningStatusPage.this.iCourseTable.sort(header, new EnrollmentComparator(sort, asc));
                SectioningStatusCookie.getInstance().setSortBy(SectioningStatusPage.this.iOnline, 0, header.getOrder() != false ? 1 + sort.ordinal() : -1 - sort.ordinal());
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(column);
            }

            public String getColumnName() {
                return column;
            }
        };
        header.addOperation(op);
        this.iSortOperations.add(op);
    }

    protected void addSortOperation(final UniTimeTableHeader header, final StudentComparator.SortBy sort, final String column) {
        SortOperation op = new SortOperation(){

            public void execute() {
                boolean asc = header.getOrder() == null ? true : header.getOrder() == false;
                SectioningStatusPage.this.iStudentTable.sort(header, new StudentComparator(sort, asc));
                SectioningStatusCookie.getInstance().setSortBy(SectioningStatusPage.this.iOnline, 1, header.getOrder() != false ? 1 + sort.ordinal() : -1 - sort.ordinal());
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(column);
            }

            public String getColumnName() {
                return column;
            }
        };
        header.addOperation(op);
        this.iSortOperations.add(op);
    }

    protected void addSortOperation(final UniTimeTableHeader header, final ChangeLogComparator.SortBy sort, final String column) {
        SortOperation op = new SortOperation(){

            public void execute() {
                SectioningStatusPage.this.iLogTable.sort(header, new ChangeLogComparator(sort));
                SectioningStatusCookie.getInstance().setSortBy(SectioningStatusPage.this.iOnline, 2, header.getOrder() != false ? 1 + sort.ordinal() : -1 - sort.ordinal());
            }

            public boolean isApplicable() {
                return true;
            }

            public boolean hasSeparator() {
                return false;
            }

            public String getName() {
                return MESSAGES.sortBy(column);
            }

            public String getColumnName() {
                return column;
            }
        };
        header.addOperation(op);
        this.iSortOperations.add(op);
    }

    private void sendEmail(final Iterator<Long> studentIds, final String subject, final String message, final String cc, final int fails) {
        if (!studentIds.hasNext()) {
            return;
        }
        final Long studentId = studentIds.next();
        this.iSectioningService.sendEmail(studentId, subject, message, cc, new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                    ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                    if (i == null || i.getStudent() == null || !studentId.equals(i.getStudent().getId())) continue;
                    HTML error = new HTML(caught.getMessage());
                    error.setStyleName("unitime-ErrorMessage");
                    SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)error);
                    i.setEmailDate(null);
                }
                if (fails >= 4) {
                    while (studentIds.hasNext()) {
                        Long sid = (Long)studentIds.next();
                        for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                            ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                            if (i == null || i.getStudent() == null || !sid.equals(i.getStudent().getId())) continue;
                            HTML error = new HTML(MESSAGES.exceptionCancelled(caught.getMessage()));
                            error.setStyleName("unitime-ErrorMessage");
                            SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)error);
                            i.setEmailDate(null);
                        }
                    }
                }
                SectioningStatusPage.this.sendEmail(studentIds, subject, message, cc, fails + 1);
            }

            public void onSuccess(Boolean result) {
                for (int row = 0; row < SectioningStatusPage.this.iStudentTable.getRowCount(); ++row) {
                    ClassAssignmentInterface.StudentInfo i = (ClassAssignmentInterface.StudentInfo)SectioningStatusPage.this.iStudentTable.getData(row);
                    if (i != null && i.getStudent() != null && studentId.equals(i.getStudent().getId())) {
                        if (result.booleanValue()) {
                            i.setEmailDate(new Date());
                            SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)new HTML(sDF.format(i.getEmailDate()), false));
                        } else {
                            HTML error = new HTML(MESSAGES.exceptionNoEmail());
                            error.setStyleName("unitime-ErrorMessage");
                            SectioningStatusPage.this.iStudentTable.setWidget(row, SectioningStatusPage.this.iStudentTable.getCellCount(row) - 1, (Widget)error);
                            i.setEmailDate(null);
                        }
                    }
                    SectioningStatusPage.this.sendEmail(studentIds, subject, message, cc, fails);
                }
            }
        });
    }

    public static class DistanceCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public DistanceCell(Integer nrDist, Integer totalNrDist, Integer distMin, Integer totalDistMin) {
            if (nrDist == null) {
                if (totalNrDist != null) {
                    this.setHTML(totalNrDist == 0 ? "-" : totalNrDist + " " + MESSAGES.distanceConflict(totalDistMin));
                }
            } else if (nrDist.equals(totalNrDist)) {
                this.setHTML(totalNrDist == 0 ? "-" : totalNrDist + " " + MESSAGES.distanceConflict(totalDistMin));
            } else {
                this.setHTML(nrDist + " / " + totalNrDist + " " + (nrDist == 0 ? MESSAGES.distanceConflict(totalDistMin) : MESSAGES.distanceConflict(distMin)));
            }
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_CENTER;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RoomsCell
    extends P {
        public RoomsCell(List<ClassAssignmentInterface.IdValue> list, String delimiter) {
            super("itemize");
            if (list != null) {
                Iterator<ClassAssignmentInterface.IdValue> i = list.iterator();
                while (i.hasNext()) {
                    final P p = new P((Element)DOM.createSpan(), "item");
                    final ClassAssignmentInterface.IdValue room = i.next();
                    p.setText(room.getValue() + (i.hasNext() ? delimiter : ""));
                    if (room.getId() != null) {
                        p.addMouseOverHandler(new MouseOverHandler(){

                            public void onMouseOver(MouseOverEvent event) {
                                RoomHint.showHint((Element)p.getElement(), room.getId(), null, null, true);
                            }
                        });
                        p.addMouseOutHandler(new MouseOutHandler(){

                            public void onMouseOut(MouseOutEvent event) {
                                RoomHint.hideHint();
                            }
                        });
                    }
                    this.add((Widget)p);
                }
            }
        }
    }

    public static class RequestCreditCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        private static NumberFormat df = NumberFormat.getFormat((String)"0.#");

        public RequestCreditCell(float min, float max, float totalMin, float totalMax) {
            if (totalMax > 0.0f) {
                if (min == totalMin && max == totalMax) {
                    this.setHTML(totalMin == totalMax ? df.format((double)totalMax) : df.format((double)totalMin) + " - " + df.format((double)totalMax));
                } else {
                    this.setHTML((min == max ? df.format((double)min) : df.format((double)min) + " - " + df.format((double)max)) + " / " + (totalMin == totalMax ? df.format((double)totalMin) : df.format((double)totalMin) + " - " + df.format((double)totalMax)));
                }
            } else {
                this.setHTML("&nbsp;");
            }
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    public static class CreditCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        private static NumberFormat df = NumberFormat.getFormat((String)"0.#");

        public CreditCell(ClassAssignmentInterface.StudentInfo info) {
            Float value = info.getCredit();
            Float total = info.getTotalCredit();
            if (total != null && total.floatValue() > 0.0f) {
                if (total.equals(value)) {
                    String html = df.format((Number)total);
                    if (info.hasIMTotalCredit()) {
                        html = html + " (";
                        Iterator<String> i = info.getTotalCreditIMs().iterator();
                        while (i.hasNext()) {
                            String im = i.next();
                            html = html + im + ": " + df.format((double)info.getIMTotalCredit(im));
                            if (!i.hasNext()) continue;
                            html = html + ", ";
                        }
                        html = html + ")";
                    }
                    this.setHTML(html);
                } else {
                    String html = df.format((Number)value) + " / " + df.format((Number)total);
                    if (info.hasIMCredit()) {
                        html = html + " (";
                        Iterator<String> i = info.getCreditIMs().iterator();
                        while (i.hasNext()) {
                            String im = i.next();
                            html = html + im + ": " + df.format((double)info.getIMCredit(im));
                            if (!i.hasNext()) continue;
                            html = html + ", ";
                        }
                        html = html + ")";
                    }
                    this.setHTML(html);
                }
            } else {
                this.setHTML("&nbsp;");
            }
            this.setWordWrap(false);
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLogComparator
    implements Comparator<ClassAssignmentInterface.SectioningAction> {
        private SortBy iSortBy;

        public ChangeLogComparator(SortBy sortBy) {
            this.iSortBy = sortBy;
        }

        public int doCompare(ClassAssignmentInterface.SectioningAction e1, ClassAssignmentInterface.SectioningAction e2) {
            switch (this.iSortBy) {
                case STUDENT: {
                    return e1.getStudent().getName().compareTo(e2.getStudent().getName());
                }
                case OPERATION: {
                    return e1.getOperation().compareTo(e2.getOperation());
                }
                case TIME_STAMP: {
                    return -e1.getTimeStamp().compareTo(e2.getTimeStamp());
                }
                case EXEC_TIME: {
                    return -(e1.getWallTime() == null ? new Long(0L) : e1.getWallTime()).compareTo(e2.getWallTime() == null ? 0L : e2.getWallTime());
                }
                case RESULT: {
                    return (e1.getResult() == null ? "" : e1.getResult()).compareTo(e2.getResult() == null ? "" : e2.getResult());
                }
                case MESSAGE: {
                    return (e1.getMessage() == null ? "" : e1.getMessage()).compareTo(e2.getMessage() == null ? "" : e2.getMessage());
                }
            }
            return 0;
        }

        @Override
        public int compare(ClassAssignmentInterface.SectioningAction e1, ClassAssignmentInterface.SectioningAction e2) {
            int cmp = this.doCompare(e1, e2);
            if (cmp != 0) {
                return cmp;
            }
            return -e1.getTimeStamp().compareTo(e2.getTimeStamp());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SortBy {
            STUDENT,
            OPERATION,
            TIME_STAMP,
            RESULT,
            USER,
            MESSAGE,
            EXEC_TIME;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StudentComparator
    implements Comparator<ClassAssignmentInterface.StudentInfo> {
        private SortBy iSortBy;
        private boolean iAsc;

        public StudentComparator(SortBy sortBy, boolean asc) {
            this.iSortBy = sortBy;
            this.iAsc = asc;
        }

        protected int doCompare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
            switch (this.iSortBy) {
                case EXTERNAL_ID: {
                    return (e1.getStudent().isCanShowExternalId() ? e1.getStudent().getExternalId() : "").compareTo(e2.getStudent().isCanShowExternalId() ? e2.getStudent().getExternalId() : "");
                }
                case STUDENT: {
                    return e1.getStudent().getName().compareTo(e2.getStudent().getName());
                }
                case AREA: {
                    int cmp = e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                }
                case CLASSIFICATION: {
                    int cmp = e1.getStudent().getClassification("|").compareTo(e2.getStudent().getClassification("|"));
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = e1.getStudent().getArea("|").compareTo(e2.getStudent().getArea("|"));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                }
                case MAJOR: {
                    int cmp = e1.getStudent().getMajor("|").compareTo(e2.getStudent().getMajor("|"));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                }
                case GROUP: {
                    int cmp = e1.getStudent().getGroup("|").compareTo(e2.getStudent().getGroup("|"));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                }
                case ACCOMODATION: {
                    int cmp = e1.getStudent().getAccommodation("|").compareTo(e2.getStudent().getAccommodation("|"));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return e1.getStudent().getAreaClasf("|").compareTo(e2.getStudent().getAreaClasf("|"));
                }
                case STATUS: {
                    return (e1.getStatus() == null ? "" : e1.getStatus()).compareToIgnoreCase(e2.getStatus() == null ? "" : e2.getStatus());
                }
                case ENROLLMENT: {
                    int cmp = (e1.getEnrollment() == null ? new Integer(0) : e1.getEnrollment()).compareTo(e2.getEnrollment() == null ? 0 : e2.getEnrollment());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return (e1.getTotalEnrollment() == null ? new Integer(0) : e1.getTotalEnrollment()).compareTo(e2.getTotalEnrollment() == null ? 0 : e2.getTotalEnrollment());
                }
                case WAITLIST: {
                    int cmp = (e1.getUnassigned() == null ? new Integer(0) : e1.getUnassigned()).compareTo(e2.getUnassigned() == null ? 0 : e2.getUnassigned());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getWaitlist() == null ? new Integer(0) : e1.getWaitlist()).compareTo(e2.getWaitlist() == null ? 0 : e2.getWaitlist());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalUnassigned() == null ? new Integer(0) : e1.getTotalUnassigned()).compareTo(e2.getTotalUnassigned() == null ? 0 : e2.getTotalUnassigned());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalWaitlist() == null ? new Integer(0) : e1.getTotalWaitlist()).compareTo(e2.getTotalWaitlist() == null ? 0 : e2.getTotalWaitlist());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return (e1.getTopWaitingPriority() == null ? new Integer(Integer.MAX_VALUE) : e1.getTopWaitingPriority()).compareTo(e2.getTopWaitingPriority() == null ? Integer.MAX_VALUE : e2.getTopWaitingPriority());
                }
                case RESERVATION: {
                    int cmp = (e1.getReservation() == null ? new Integer(0) : e1.getReservation()).compareTo(e2.getReservation() == null ? 0 : e2.getReservation());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return (e1.getTotalReservation() == null ? new Integer(0) : e1.getTotalReservation()).compareTo(e2.getTotalReservation() == null ? 0 : e2.getTotalReservation());
                }
                case CONSENT: {
                    int cmp = (e1.getConsentNeeded() == null ? new Integer(0) : e1.getConsentNeeded()).compareTo(e2.getConsentNeeded() == null ? 0 : e2.getConsentNeeded());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return (e1.getTotalConsentNeeded() == null ? new Integer(0) : e1.getTotalConsentNeeded()).compareTo(e2.getTotalConsentNeeded() == null ? 0 : e2.getTotalConsentNeeded());
                }
                case CREDIT: {
                    int cmp = (e1.hasCredit() ? e1.getCredit() : new Float(0.0f)).compareTo(e2.hasCredit() ? e2.getCredit() : new Float(0.0f));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return (e1.hasTotalCredit() ? e1.getTotalCredit() : new Float(0.0f)).compareTo(e2.hasTotalCredit() ? e2.getTotalCredit() : new Float(0.0f));
                }
                case REQ_CREDIT: {
                    int cmp = (e1.hasRequestCredit() ? new Float(e1.getRequestCreditMin()) : new Float(0.0f)).compareTo(Float.valueOf(e2.hasRequestCredit() ? e2.getRequestCreditMin() : 0.0f));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.hasRequestCredit() ? new Float(e1.getRequestCreditMax()) : new Float(0.0f)).compareTo(Float.valueOf(e2.hasRequestCredit() ? e2.getRequestCreditMax() : 0.0f));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.hasTotalRequestCredit() ? new Float(e1.getTotalRequestCreditMin()) : new Float(0.0f)).compareTo(Float.valueOf(e2.hasTotalRequestCredit() ? e2.getTotalRequestCreditMin() : 0.0f));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return (e1.hasTotalRequestCredit() ? new Float(e1.getTotalRequestCreditMax()) : new Float(0.0f)).compareTo(Float.valueOf(e2.hasTotalRequestCredit() ? e2.getTotalRequestCreditMax() : 0.0f));
                }
                case REQUEST_TS: {
                    return (e1.getRequestedDate() == null ? new Date(0L) : e1.getRequestedDate()).compareTo(e2.getRequestedDate() == null ? new Date(0L) : e2.getRequestedDate());
                }
                case ENROLLMENT_TS: {
                    return (e1.getEnrolledDate() == null ? new Date(0L) : e1.getEnrolledDate()).compareTo(e2.getEnrolledDate() == null ? new Date(0L) : e2.getEnrolledDate());
                }
                case EMAIL_TS: {
                    return (e1.getEmailDate() == null ? new Date(0L) : e1.getEmailDate()).compareTo(e2.getEmailDate() == null ? new Date(0L) : e2.getEmailDate());
                }
                case NOTE: {
                    return e1.hasNote() ? e1.getNote().compareTo(e2.hasNote() ? e2.getNote() : "") : "".compareTo(e2.hasNote() ? e2.getNote() : "");
                }
                case DIST_CONF: {
                    int cmp = (e1.hasDistanceConflicts() ? e1.getNrDistanceConflicts() : new Integer(0)).compareTo(e2.hasDistanceConflicts() ? e2.getNrDistanceConflicts() : new Integer(0));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.hasTotalDistanceConflicts() ? e1.getTotalNrDistanceConflicts() : new Integer(0)).compareTo(e2.hasTotalDistanceConflicts() ? e2.getTotalNrDistanceConflicts() : new Integer(0));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return -(e1.hasDistanceConflicts() ? e1.getLongestDistanceMinutes() : (e1.hasTotalDistanceConflicts() ? e1.getTotalLongestDistanceMinutes() : new Integer(0))).compareTo(e2.hasDistanceConflicts() ? e2.getLongestDistanceMinutes() : (e2.hasTotalDistanceConflicts() ? e2.getTotalLongestDistanceMinutes() : new Integer(0)));
                }
                case OVERLAPS: {
                    int cmp = (e1.hasOverlappingMinutes() ? e1.getOverlappingMinutes() : new Integer(0)).compareTo(e2.hasOverlappingMinutes() ? e2.getOverlappingMinutes() : new Integer(0));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return (e1.hasTotalOverlappingMinutes() ? e1.getTotalOverlappingMinutes() : new Integer(0)).compareTo(e2.hasTotalOverlappingMinutes() ? e2.getTotalOverlappingMinutes() : new Integer(0));
                }
                case FT_OVERLAPS: {
                    int cmp = (e1.hasFreeTimeOverlappingMins() ? e1.getFreeTimeOverlappingMins() : new Integer(0)).compareTo(e2.hasFreeTimeOverlappingMins() ? e2.getFreeTimeOverlappingMins() : new Integer(0));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return (e1.hasTotalFreeTimeOverlappingMins() ? e1.getTotalFreeTimeOverlappingMins() : new Integer(0)).compareTo(e2.hasTotalFreeTimeOverlappingMins() ? e2.getTotalFreeTimeOverlappingMins() : new Integer(0));
                }
                case PREF_IM: {
                    int cmp = (e1.hasTotalPrefInstrMethConflict() ? new Integer(e1.getTotalPrefInstrMethConflict() - e1.getPrefInstrMethConflict()) : new Integer(0)).compareTo(e2.hasTotalPrefInstrMethConflict() ? new Integer(e2.getTotalPrefInstrMethConflict() - e2.getPrefInstrMethConflict()) : new Integer(0));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return -(e1.hasTotalPrefInstrMethConflict() ? e1.getTotalPrefInstrMethConflict() : new Integer(0)).compareTo(e2.hasTotalPrefInstrMethConflict() ? e2.getTotalPrefInstrMethConflict() : new Integer(0));
                }
                case PREF_SEC: {
                    int cmp = (e1.hasTotalPrefSectionConflict() ? new Integer(e1.getTotalPrefSectionConflict() - e1.getPrefSectionConflict()) : new Integer(0)).compareTo(e2.hasTotalPrefSectionConflict() ? new Integer(e2.getTotalPrefSectionConflict() - e2.getPrefSectionConflict()) : new Integer(0));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return -(e1.hasTotalPrefSectionConflict() ? e1.getTotalPrefSectionConflict() : new Integer(0)).compareTo(e2.hasTotalPrefSectionConflict() ? e2.getTotalPrefSectionConflict() : new Integer(0));
                }
                case OVERRIDE: {
                    int cmp = (e1.getOverrideNeeded() == null ? new Integer(0) : e1.getOverrideNeeded()).compareTo(e2.getOverrideNeeded() == null ? 0 : e2.getOverrideNeeded());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return (e1.getTotalOverrideNeeded() == null ? new Integer(0) : e1.getTotalOverrideNeeded()).compareTo(e2.getTotalOverrideNeeded() == null ? 0 : e2.getTotalOverrideNeeded());
                }
            }
            return 0;
        }

        @Override
        public int compare(ClassAssignmentInterface.StudentInfo e1, ClassAssignmentInterface.StudentInfo e2) {
            if (e1.getStudent() == null) {
                return this.iAsc ? 1 : -1;
            }
            if (e2.getStudent() == null) {
                return this.iAsc ? -1 : 1;
            }
            int cmp = this.doCompare(e1, e2);
            if (cmp != 0) {
                return cmp;
            }
            cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
            if (cmp != 0) {
                return cmp;
            }
            return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SortBy {
            EXTERNAL_ID,
            STUDENT,
            AREA,
            CLASSIFICATION,
            MAJOR,
            GROUP,
            ACCOMODATION,
            STATUS,
            ENROLLMENT,
            WAITLIST,
            RESERVATION,
            CONSENT,
            CREDIT,
            REQUEST_TS,
            ENROLLMENT_TS,
            EMAIL_TS,
            NOTE,
            DIST_CONF,
            OVERLAPS,
            FT_OVERLAPS,
            PREF_IM,
            PREF_SEC,
            OVERRIDE,
            REQ_CREDIT;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnrollmentComparator
    implements Comparator<ClassAssignmentInterface.EnrollmentInfo> {
        private SortBy iSortBy;
        private boolean iAsc;

        public EnrollmentComparator(SortBy sortBy, boolean asc) {
            this.iSortBy = sortBy;
            this.iAsc = asc;
        }

        @Override
        public int compare(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
            if (e1.getCourseId() == null) {
                return this.iAsc ? 1 : -1;
            }
            if (e2.getCourseId() == null) {
                return this.iAsc ? -1 : 1;
            }
            if (e1.getCourseId().equals(e2.getCourseId())) {
                if (e1.getConfigId() == null) {
                    return this.iAsc ? -1 : 1;
                }
                if (e2.getConfigId() == null) {
                    return this.iAsc ? 1 : -1;
                }
                return this.compareClasses(e1, e2);
            }
            return this.compareCourses(e1, e2);
        }

        private int compareClasses(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
            return 0;
        }

        private int compareCourses(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
            int cmp;
            switch (this.iSortBy) {
                case SUBJECT: {
                    break;
                }
                case COURSE: {
                    cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
                    if (cmp == 0) break;
                    return cmp;
                }
                case TITLE: {
                    cmp = (e1.getTitle() == null ? "" : e1.getTitle()).compareTo(e2.getTitle() == null ? "" : e2.getTitle());
                    if (cmp == 0) break;
                    return cmp;
                }
                case CONSENT: {
                    cmp = (e1.getConsent() == null ? "" : e1.getConsent()).compareTo(e2.getConsent() == null ? "" : e2.getConsent());
                    if (cmp == 0) break;
                    return cmp;
                }
                case LIMIT: {
                    cmp = (e1.getAvailable() == null ? new Integer(0) : (e1.getAvailable() < 0 ? new Integer(Integer.MAX_VALUE) : e1.getAvailable())).compareTo(e2.getAvailable() == null ? 0 : (e2.getAvailable() < 0 ? Integer.MAX_VALUE : e2.getAvailable()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = (e1.getLimit() == null ? new Integer(0) : e1.getLimit()).compareTo(e2.getLimit() == null ? 0 : e2.getLimit());
                    if (cmp == 0) break;
                    return cmp;
                }
                case PROJECTION: {
                    cmp = (e1.getProjection() == null ? new Integer(0) : e1.getProjection()).compareTo(e2.getProjection() == null ? 0 : e2.getProjection());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case ENROLLMENT: {
                    cmp = (e1.getEnrollment() == null ? new Integer(0) : e1.getEnrollment()).compareTo(e2.getEnrollment() == null ? 0 : e2.getEnrollment());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalEnrollment() == null ? new Integer(0) : e1.getTotalEnrollment()).compareTo(e2.getTotalEnrollment() == null ? 0 : e2.getTotalEnrollment());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case WAITLIST: {
                    cmp = (e1.getWaitlist() == null ? new Integer(0) : e1.getWaitlist()).compareTo(e2.getWaitlist() == null ? 0 : e2.getWaitlist());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getUnassignedPrimary() == null ? new Integer(0) : e1.getUnassignedPrimary()).compareTo(e2.getUnassignedPrimary() == null ? 0 : e2.getUnassignedPrimary());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalWaitlist() == null ? new Integer(0) : e1.getTotalWaitlist()).compareTo(e2.getTotalWaitlist() == null ? 0 : e2.getTotalWaitlist());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalUnassignedPrimary() == null ? new Integer(0) : e1.getTotalUnassignedPrimary()).compareTo(e2.getTotalUnassignedPrimary() == null ? 0 : e2.getTotalUnassignedPrimary());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case RESERVATION: {
                    cmp = (e1.getReservation() == null ? new Integer(0) : e1.getReservation()).compareTo(e2.getReservation() == null ? 0 : e2.getReservation());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalReservation() == null ? new Integer(0) : e1.getTotalReservation()).compareTo(e2.getTotalReservation() == null ? 0 : e2.getTotalReservation());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case NEED_CONSENT: {
                    cmp = (e1.getConsentNeeded() == null ? new Integer(0) : new Integer(e1.getConsentNeeded())).compareTo(e2.getConsentNeeded() == null ? 0 : e2.getConsentNeeded());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalConsentNeeded() == null ? new Integer(0) : new Integer(e1.getTotalConsentNeeded())).compareTo(e2.getTotalConsentNeeded() == null ? 0 : e2.getTotalConsentNeeded());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case ALTERNATIVES: {
                    cmp = (e1.getUnassignedAlternative() == null ? new Integer(0) : e1.getUnassignedAlternative()).compareTo(e2.getUnassignedAlternative() == null ? 0 : e2.getUnassignedAlternative());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalUnassignedAlternative() == null ? new Integer(0) : e1.getTotalUnassignedAlternative()).compareTo(e2.getTotalUnassignedAlternative() == null ? 0 : e2.getTotalUnassignedAlternative());
                    if (cmp == 0) break;
                    return -cmp;
                }
                case NEED_OVERRIDE: {
                    cmp = (e1.getOverrideNeeded() == null ? new Integer(0) : new Integer(e1.getOverrideNeeded())).compareTo(e2.getOverrideNeeded() == null ? 0 : e2.getOverrideNeeded());
                    if (cmp != 0) {
                        return -cmp;
                    }
                    cmp = (e1.getTotalOverrideNeeded() == null ? new Integer(0) : new Integer(e1.getTotalOverrideNeeded())).compareTo(e2.getTotalOverrideNeeded() == null ? 0 : e2.getTotalOverrideNeeded());
                    if (cmp == 0) break;
                    return -cmp;
                }
            }
            cmp = e1.getSubject().compareTo(e2.getSubject());
            if (cmp != 0) {
                return cmp;
            }
            cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
            if (cmp != 0) {
                return cmp;
            }
            return 0;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SortBy {
            SUBJECT,
            COURSE,
            TITLE,
            CONSENT,
            LIMIT,
            PROJECTION,
            ENROLLMENT,
            WAITLIST,
            RESERVATION,
            NEED_CONSENT,
            ALTERNATIVES,
            NEED_OVERRIDE;

        }
    }

    public static class WaitListCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public WaitListCell(int wait, int tWait, int unasg, int tUnasg, Integer topWaitingPriority) {
            if (tWait == 0 || tWait == tUnasg) {
                if (unasg == tUnasg) {
                    this.setHTML(unasg == 0 ? "-" : String.valueOf(unasg));
                } else {
                    this.setHTML(unasg + " / " + tUnasg);
                }
                if (tWait > 0) {
                    this.setHTML(this.getHTML() + MESSAGES.htmlWaitListSign());
                }
            } else if (wait == tWait && unasg == tUnasg) {
                this.setHTML(wait == 0 ? String.valueOf(unasg) : (wait == unasg ? wait + MESSAGES.htmlWaitListSign() : unasg - wait + " + " + wait + MESSAGES.htmlWaitListSign()));
            } else {
                this.setHTML((wait == 0 ? String.valueOf(unasg) : (wait == unasg ? wait + MESSAGES.htmlWaitListSign() : unasg - wait + " + " + wait + MESSAGES.htmlWaitListSign())) + " / " + tUnasg);
            }
            if (topWaitingPriority != null) {
                this.setHTML(this.getHTML() + " " + MESSAGES.firstWaitListedPrioritySign(topWaitingPriority));
            }
        }

        public WaitListCell(ClassAssignmentInterface.StudentInfo e) {
            this(e.hasWaitlist() ? e.getWaitlist() : 0, e.hasTotalWaitlist() ? e.getTotalWaitlist() : 0, e.hasUnassigned() ? e.getUnassigned() : 0, e.hasTotalUnassigned() ? e.getTotalUnassigned() : 0, e.getTopWaitingPriority());
        }

        public WaitListCell(ClassAssignmentInterface.EnrollmentInfo e) {
            this(e.hasWaitlist() ? e.getWaitlist() : 0, e.hasTotalWaitlist() ? e.getTotalWaitlist() : 0, e.hasUnassigned() ? e.getUnassignedPrimary() : 0, e.hasTotalUnassigned() ? e.getTotalUnassignedPrimary() : 0, null);
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    public static class AvailableCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public AvailableCell(ClassAssignmentInterface.EnrollmentInfo e) {
            int other;
            int n = other = e.getOther() == null ? 0 : e.getOther();
            if (e.getLimit() == null) {
                this.setHTML("-");
                this.setTitle(MESSAGES.availableNoLimit());
            } else if (e.getLimit() < 0) {
                if (e.getAvailable() != null && e.getAvailable() == 0) {
                    this.setHTML("&infin;" + MESSAGES.htmlReservationSign());
                    this.setTitle(MESSAGES.availableUnlimitedWithReservation());
                } else {
                    this.setHTML("&infin;");
                    this.setTitle(MESSAGES.availableUnlimited());
                }
            } else if (e.getAvailable() == e.getLimit() - e.getTotalEnrollment() - other) {
                this.setHTML(e.getAvailable() + " / " + e.getLimit());
                if (e.getAvailable() == 0) {
                    this.setTitle(MESSAGES.availableNot(e.getLimit()));
                } else {
                    this.setTitle(MESSAGES.available(e.getAvailable(), e.getLimit()));
                }
            } else if (e.getAvailable() == 0 && e.getLimit() > e.getTotalEnrollment() + other) {
                this.setHTML(e.getLimit() - e.getTotalEnrollment() - other + MESSAGES.htmlReservationSign() + " / " + e.getLimit());
                this.setTitle(MESSAGES.availableWithReservation(e.getLimit() - e.getTotalEnrollment() - other, e.getLimit()));
            } else {
                this.setHTML(e.getAvailable() + " + " + (e.getLimit() - e.getTotalEnrollment() - e.getAvailable() - other) + MESSAGES.htmlReservationSign() + " / " + e.getLimit());
                this.setTitle(MESSAGES.availableSomeReservation(e.getAvailable(), e.getLimit(), e.getLimit() - e.getTotalEnrollment() - e.getAvailable() - other));
            }
        }

        public static boolean hasReservedSpace(ClassAssignmentInterface.EnrollmentInfo e) {
            if (e.getLimit() < 0) {
                return false;
            }
            if (e.getLimit() < 0) {
                return e.getAvailable() == 0;
            }
            return e.getAvailable() != e.getLimit() - e.getTotalEnrollment() - (e.getOther() == null ? 0 : e.getOther());
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    public static class TitleCell
    extends HTML
    implements UniTimeTable.HasColSpan {
        public TitleCell(String title) {
            super(title);
        }

        public int getColSpan() {
            return 2;
        }
    }

    public static class NumberCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public NumberCell(Integer value, Integer total) {
            if (value == null) {
                if (total != null) {
                    this.setHTML(total == 0 ? "-" : (total < 0 ? "&infin;" : total.toString()));
                }
            } else if (value.equals(total)) {
                this.setHTML(total == 0 ? "-" : (total < 0 ? "&infin;" : total.toString()));
            } else {
                this.setHTML((value < 0 ? "&infin;" : value.toString()) + " / " + (total < 0 ? "&infin;" : total.toString()));
            }
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SuggestCallback
    implements AsyncCallback<List<String[]>> {
        private SuggestOracle.Request iRequest;
        private SuggestOracle.Callback iCallback;

        public SuggestCallback(SuggestOracle.Request request, SuggestOracle.Callback callback) {
            this.iRequest = request;
            this.iCallback = callback;
        }

        public void onFailure(Throwable caught) {
            ArrayList suggestions = new ArrayList();
            this.iCallback.onSuggestionsReady(this.iRequest, new SuggestOracle.Response(suggestions));
            ToolBox.checkAccess(caught);
        }

        public void onSuccess(List<String[]> result) {
            ArrayList<SimpleSuggestion> suggestions = new ArrayList<SimpleSuggestion>();
            for (String[] suggestion : result) {
                suggestions.add(new SimpleSuggestion(suggestion[1], suggestion[0]));
            }
            this.iCallback.onSuggestionsReady(this.iRequest, new SuggestOracle.Response(suggestions));
        }
    }

    private static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }

    public static class SimpleSuggestion
    implements SuggestOracle.Suggestion {
        private String iDisplay;
        private String iReplace;

        public SimpleSuggestion(String display, String replace) {
            this.iDisplay = display;
            this.iReplace = replace;
        }

        public SimpleSuggestion(String replace) {
            this(replace, replace);
        }

        public String getDisplayString() {
            return this.iDisplay;
        }

        public String getReplacementString() {
            return this.iReplace;
        }
    }
}

