/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.aria.AriaDialogBox;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;

public class PinDialog
extends AriaDialogBox {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private static final SectioningServiceAsync sSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private AriaTextBox iPin = null;
    private AriaButton iButton = null;
    private AriaButton iCancel = null;
    private PinCallback iCallback = null;
    private boolean iOnline;
    private boolean iSectioning;
    private Long iSessionId;
    private Long iStudentId;

    public PinDialog() {
        this.setText(MESSAGES.dialogPin());
        this.setAnimationEnabled(true);
        this.setAutoHideEnabled(false);
        this.setGlassEnabled(true);
        this.setModal(true);
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                PinDialog.this.iPin.setText("");
            }
        });
        HorizontalPanel panel = new HorizontalPanel();
        panel.setSpacing(5);
        panel.add((Widget)new Label(MESSAGES.pin()));
        this.iPin = new AriaTextBox();
        this.iPin.setStyleName("gwt-SuggestBox");
        this.iPin.setAriaLabel(ARIA.propPinNumber());
        panel.add((Widget)this.iPin);
        this.iButton = new AriaButton(MESSAGES.buttonSetPin());
        panel.add((Widget)this.iButton);
        this.iCancel = new AriaButton(MESSAGES.buttonCancelPin());
        panel.add((Widget)this.iCancel);
        this.setWidget((Widget)panel);
        this.iButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PinDialog.this.sendPin();
            }
        });
        this.iCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PinDialog.this.hide();
                PinDialog.this.iCallback.onFailure(new SectioningException(MESSAGES.exceptionAuthenticationPinNotProvided()));
            }
        });
        this.iPin.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == 13) {
                    PinDialog.this.sendPin();
                } else if (event.getNativeKeyCode() == 27) {
                    PinDialog.this.hide();
                    PinDialog.this.iCallback.onFailure(new SectioningException(MESSAGES.exceptionAuthenticationPinNotProvided()));
                }
            }
        });
    }

    protected void sendPin() {
        String pin = this.iPin.getText();
        this.hide();
        LoadingWidget.getInstance().show(MESSAGES.waitEligibilityCheck());
        sSectioningService.checkEligibility(this.iOnline, this.iSectioning, this.iSessionId, this.iStudentId, pin, new AsyncCallback<OnlineSectioningInterface.EligibilityCheck>(){

            public void onSuccess(OnlineSectioningInterface.EligibilityCheck result) {
                LoadingWidget.getInstance().hide();
                PinDialog.this.iCallback.onMessage(result);
                if (result.hasFlag(OnlineSectioningInterface.EligibilityCheck.EligibilityFlag.PIN_REQUIRED)) {
                    PinDialog.this.center();
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            PinDialog.this.iPin.selectAll();
                            PinDialog.this.iPin.setFocus(true);
                        }
                    });
                } else {
                    PinDialog.this.iCallback.onSuccess(result);
                }
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                PinDialog.this.iCallback.onFailure(caught);
            }
        });
    }

    public void checkEligibility(boolean online, boolean sectioning, Long sessionId, Long studentId, PinCallback callback) {
        this.iOnline = online;
        this.iSectioning = sectioning;
        this.iSessionId = sessionId;
        this.iStudentId = studentId;
        this.iCallback = callback;
        this.iPin.setText("");
        this.center();
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                PinDialog.this.iPin.setFocus(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PinCallback
    extends AsyncCallback<OnlineSectioningInterface.EligibilityCheck> {
        public void onMessage(OnlineSectioningInterface.EligibilityCheck var1);
    }
}

