/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.sectioning.DegreePlanDialog;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningPage;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.DegreePlanInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegreePlanTable
extends UniTimeTable<Object>
implements TakesValue<DegreePlanInterface> {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private StudentSectioningPage.Mode iMode;
    private DegreePlanInterface iPlan;
    private TakesValue<CourseRequestInterface> iRequests;
    private DegreePlanDialog.AssignmentProvider iAssignments;

    public DegreePlanTable(StudentSectioningPage.Mode mode, TakesValue<CourseRequestInterface> requests, DegreePlanDialog.AssignmentProvider assignments) {
        this.iMode = mode;
        this.iRequests = requests;
        this.iAssignments = assignments;
        this.addStyleName("unitine-DegreePlanTable");
        this.setAllowSelection(true);
        this.setAllowMultiSelect(false);
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        UniTimeTableHeader hIndent = new UniTimeTableHeader("");
        header.add(hIndent);
        UniTimeTableHeader hName = new UniTimeTableHeader(MESSAGES.colDegreeItemName(), 2);
        header.add(hName);
        UniTimeTableHeader hTitle = new UniTimeTableHeader(MESSAGES.colDegreeItemDescription());
        header.add(hTitle);
        UniTimeTableHeader hLimit = new UniTimeTableHeader(MESSAGES.colLimit());
        header.add(hLimit);
        UniTimeTableHeader hCredit = new UniTimeTableHeader(MESSAGES.colCredit());
        header.add(hCredit);
        UniTimeTableHeader hNote = new UniTimeTableHeader(MESSAGES.colNote());
        header.add(hNote);
        UniTimeTableHeader hReq = new UniTimeTableHeader(MESSAGES.colRequestPriority(), 2);
        header.add(hReq);
        this.addRow(null, header);
    }

    public DegreePlanInterface getValue() {
        return this.iPlan;
    }

    public void setValue(DegreePlanInterface plan) {
        this.iPlan = plan;
        this.clearTable(1);
        if (plan.getGroup() != null) {
            this.fixSelection((CourseRequestInterface)this.iRequests.getValue(), plan.getGroup(), null);
            this.addGroup(1, plan.getGroup().getMaxDepth(), (CourseRequestInterface)this.iRequests.getValue(), plan.getGroup(), null);
        }
        this.updateBackground();
    }

    private int toScore(CourseRequestInterface requests, CourseRequestInterface.RequestPriority priority) {
        if (priority == null) {
            return 0;
        }
        int size = requests.getCourses().size() + requests.getAlternatives().size();
        int index = priority.getPriority() - 1 + (priority.isAlternative() ? requests.getCourses().size() : 0);
        return 3 * (size + index) - priority.getChoice();
    }

    protected int getSelectionScore(CourseRequestInterface requests, DegreePlanInterface.DegreeCourseInterface course, ClassAssignmentInterface.CourseAssignment assignment) {
        int ret = 0;
        if (course.isSelected()) {
            ++ret;
        }
        if (assignment != null) {
            CourseRequestInterface.RequestPriority priority = requests.getRequestPriority(assignment);
            ret += this.toScore(requests, priority);
            if (this.isSaved(assignment)) {
                if (this.isLast(assignment)) {
                    ret += 1000;
                }
            } else if (this.isLast(assignment)) {
                ret += 100;
            }
        } else {
            CourseRequestInterface.RequestPriority priority = requests.getRequestPriority(course);
            ret += this.toScore(requests, priority);
        }
        return ret;
    }

    protected int getSelectionScore(CourseRequestInterface requests, DegreePlanInterface.DegreeGroupInterface unionGroup) {
        int ret = 0;
        if (unionGroup.isSelected()) {
            ++ret;
        }
        if (unionGroup.hasCourses()) {
            int sum = 0;
            for (DegreePlanInterface.DegreeCourseInterface course : unionGroup.getCourses()) {
                if (course.hasCourses()) {
                    double max = 0.0;
                    for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                        max = Math.max(max, (double)this.getSelectionScore(requests, course, ca));
                    }
                    sum = (int)((double)sum + max);
                    continue;
                }
                sum += this.getSelectionScore(requests, course, null);
            }
            ret = (int)((long)ret + Math.round(1.0 / (double)unionGroup.getCourses().size() * (double)sum));
        }
        return ret;
    }

    protected void fixSelection(CourseRequestInterface requests, DegreePlanInterface.DegreeGroupInterface group, DegreePlanInterface.DegreeGroupInterface parent) {
        ClassAssignmentInterface.CourseAssignment bestCA;
        if (group.isChoice()) {
            int bestSelection = 0;
            DegreePlanInterface.DegreeGroupInterface bestGroup = null;
            DegreePlanInterface.DegreeCourseInterface bestCourse = null;
            bestCA = null;
            if (group.hasCourses()) {
                for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                    if (course.hasCourses()) {
                        for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                            int selection = this.getSelectionScore(requests, course, ca);
                            if (selection <= bestSelection) continue;
                            bestSelection = selection;
                            bestGroup = null;
                            bestCourse = course;
                            bestCA = ca;
                        }
                    } else {
                        int selection = this.getSelectionScore(requests, course, null);
                        if (selection > bestSelection) {
                            bestSelection = selection;
                            bestGroup = null;
                            bestCourse = course;
                            bestCA = null;
                        }
                    }
                    course.setCourseId(null);
                    course.setSelected(false);
                }
            }
            if (group.hasGroups()) {
                for (DegreePlanInterface.DegreeGroupInterface ug : group.getGroups()) {
                    int selection = this.getSelectionScore(requests, ug);
                    if (selection <= bestSelection) continue;
                    bestSelection = selection;
                    bestGroup = ug;
                    bestCourse = null;
                    bestCA = null;
                }
            }
            if (bestGroup != null) {
                bestGroup.setSelected(true);
            } else if (bestCourse != null) {
                bestCourse.setSelected(true);
                bestCourse.setCourseId(bestCA == null ? null : bestCA.getCourseId());
            }
        } else if (parent != null && parent.isChoice()) {
            if (group.hasCourses()) {
                for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                    if (parent.isSelected()) {
                        int bestSelection = 0;
                        bestCA = null;
                        if (course.hasCourses()) {
                            for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                                int selection = this.getSelectionScore(requests, course, ca);
                                if (selection <= bestSelection) continue;
                                bestSelection = selection;
                                bestCA = ca;
                            }
                        }
                        course.setSelected(true);
                        course.setCourseId(bestCA == null ? null : bestCA.getCourseId());
                        continue;
                    }
                    course.setSelected(false);
                    course.setCourseId(null);
                }
            }
        } else if (group.hasCourses()) {
            for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                int bestSelection = -1;
                bestCA = null;
                if (course.hasCourses()) {
                    for (ClassAssignmentInterface.CourseAssignment ca : course.getCourses()) {
                        int selection = this.getSelectionScore(requests, course, ca);
                        if (selection <= bestSelection) continue;
                        bestSelection = selection;
                        bestCA = ca;
                    }
                }
                course.setSelected(true);
                course.setCourseId(bestCA == null ? null : bestCA.getCourseId());
            }
        }
        if (group.hasGroups()) {
            for (DegreePlanInterface.DegreeGroupInterface g : group.getGroups()) {
                this.fixSelection(requests, g, group);
            }
        }
    }

    protected void addGroup(int depth, int maxDepth, CourseRequestInterface requests, DegreePlanInterface.DegreeGroupInterface group, DegreePlanInterface.DegreeGroupInterface parent) {
        int d;
        P indent;
        if (depth > 1) {
            int d2;
            Iterator<DegreePlanInterface.DegreeItemInterface> row = new ArrayList();
            P indent2 = new P("indent");
            for (d2 = 1; d2 < depth - 1; ++d2) {
                indent2.add((Widget)new Image(RESOURCES.indentMiddleLine()));
            }
            indent2.add((Widget)new Image(RESOURCES.indentTopLine()));
            for (d2 = depth + 1; d2 <= maxDepth; ++d2) {
                indent2.add((Widget)new Image(RESOURCES.indentTopSpace()));
            }
            row.add((DegreePlanInterface.DegreeItemInterface)((Object)indent2));
            if (parent != null && parent.isChoice()) {
                row.add((DegreePlanInterface.DegreeItemInterface)((Object)new ChoiceButton(parent, group)));
                row.add((DegreePlanInterface.DegreeItemInterface)((Object)new GroupTitleCell(group.toString(MESSAGES), true)));
            } else {
                row.add((DegreePlanInterface.DegreeItemInterface)((Object)new GroupTitleCell(group.toString(MESSAGES), false)));
            }
            this.addRow(group, (List<? extends Widget>)((Object)row));
        }
        if (group.hasCourses()) {
            for (DegreePlanInterface.DegreeCourseInterface course : group.getCourses()) {
                if (!course.hasCourses()) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    indent = new P("indent");
                    for (d = 1; d < depth; ++d) {
                        indent.add((Widget)new Image(RESOURCES.indentMiddleLine()));
                    }
                    for (d = depth + 1; d <= maxDepth; ++d) {
                        indent.add((Widget)new Image(RESOURCES.indentBlankSpace()));
                    }
                    row.add((Object)indent);
                    if (group.isChoice()) {
                        row.add((Object)new ChoiceButton(group, course));
                        row.add(new CourseLabel(MESSAGES.course(course.getSubject(), course.getCourse()), true));
                    } else {
                        row.add(new CourseLabel(MESSAGES.course(course.getSubject(), course.getCourse()), false));
                    }
                    row.add((Object)new TitleLabel(course.getTitle() == null ? "" : course.getTitle()));
                    row.add(new CourseNotOfferedLabel(MESSAGES.plannedCourseNotOffered(MESSAGES.course(course.getSubject(), course.getCourse()))));
                    this.addRow(course, row);
                } else if (course.getCourses().size() > 1 && !group.isChoice()) {
                    ArrayList<Object> row = new ArrayList<Object>();
                    indent = new P("indent");
                    for (d = 1; d < depth; ++d) {
                        indent.add((Widget)new Image(RESOURCES.indentMiddleLine()));
                    }
                    indent.add((Widget)new Image(RESOURCES.indentTopLine()));
                    for (d = depth + 2; d <= maxDepth; ++d) {
                        indent.add((Widget)new Image(RESOURCES.indentTopSpace()));
                    }
                    row.add((Object)indent);
                    if (group.isChoice() && !course.hasCourses()) {
                        row.add((Object)new ChoiceButton(group, course));
                        row.add(new GroupTitleCell(course.hasTitle() ? MESSAGES.courseNameWithTitle(course.getSubject(), course.getCourse(), course.getTitle()) : MESSAGES.course(course.getSubject(), course.getCourse()), true));
                    } else {
                        row.add(new GroupTitleCell(course.hasTitle() ? MESSAGES.courseNameWithTitle(course.getSubject(), course.getCourse(), course.getTitle()) : MESSAGES.course(course.getSubject(), course.getCourse()), false));
                    }
                    this.addRow(course, row);
                }
                if (!course.hasCourses()) continue;
                Iterator<ClassAssignmentInterface.CourseAssignment> i = course.getCourses().iterator();
                while (i.hasNext()) {
                    int d3;
                    ClassAssignmentInterface.CourseAssignment ca = i.next();
                    ArrayList<Object> row = new ArrayList<Object>();
                    P indent3 = new P("indent");
                    for (d3 = 1; d3 < depth; ++d3) {
                        indent3.add((Widget)new Image(RESOURCES.indentMiddleLine()));
                    }
                    if (course.getCourses().size() == 1 || group.isChoice()) {
                        indent3.add((Widget)new Image(RESOURCES.indentBlankSpace()));
                    } else if (i.hasNext()) {
                        indent3.add((Widget)new Image(RESOURCES.indentMiddleLine()));
                    } else {
                        indent3.add((Widget)new Image(RESOURCES.indentLastLine()));
                    }
                    for (d3 = depth + 2; d3 <= maxDepth; ++d3) {
                        indent3.add((Widget)new Image(RESOURCES.indentBlankSpace()));
                    }
                    row.add((Object)indent3);
                    if (group.isChoice()) {
                        row.add((Object)new ChoiceButton(group, course, ca));
                        row.add(new CourseLabel(MESSAGES.course(ca.getSubject(), ca.getCourseNbr()), true));
                    } else if (course.hasMultipleCourses()) {
                        row.add((Object)new ChoiceButton(course, ca));
                        row.add(new CourseLabel(MESSAGES.course(ca.getSubject(), ca.getCourseNbr()), true));
                    } else {
                        row.add(new CourseLabel(MESSAGES.course(ca.getSubject(), ca.getCourseNbr()), false));
                    }
                    row.add((Object)new TitleLabel(ca.getTitle() == null ? "" : ca.getTitle()));
                    row.add(new HTML(ca.getLimit() == null || ca.getLimit() == 0 || ca.getEnrollment() == null ? "" : (ca.getLimit() < 0 ? "&infin;" : ca.getLimit() - ca.getEnrollment() + " / " + ca.getLimit()), false));
                    row.add(new Label(ca.hasCredit() ? ca.getCreditAbbv() : "", false));
                    row.add((Object)new NoteCell(ca.getNote()));
                    row.add((Object)new RequestPriorityCell(requests, ca));
                    Image icon = null;
                    if (this.isSaved(ca)) {
                        if (this.isLast(ca)) {
                            icon = new Image(RESOURCES.saved());
                            icon.setTitle(MESSAGES.saved(MESSAGES.course(ca.getSubject(), ca.getCourseNbr())));
                        } else {
                            icon = new Image(RESOURCES.unassignment());
                            icon.setTitle(MESSAGES.unassignment(MESSAGES.course(ca.getSubject(), ca.getCourseNbr())));
                        }
                    } else if (this.isLast(ca)) {
                        icon = new Image(RESOURCES.assignment());
                        icon.setTitle(MESSAGES.assignment(MESSAGES.course(ca.getSubject(), ca.getCourseNbr())));
                    }
                    if (icon != null) {
                        icon.addStyleName("icon");
                        row.add(icon);
                    } else {
                        row.add(new Label());
                    }
                    this.addRow(ca, row);
                }
            }
        }
        if (group.hasGroups()) {
            for (DegreePlanInterface.DegreeGroupInterface g : group.getGroups()) {
                this.addGroup(depth + 1, maxDepth, requests, g, group);
            }
        }
        if (group.hasPlaceHolders()) {
            for (DegreePlanInterface.DegreePlaceHolderInterface p : group.getPlaceHolders()) {
                ArrayList<Object> row = new ArrayList<Object>();
                indent = new P("indent");
                for (d = 1; d < depth; ++d) {
                    indent.add((Widget)new Image(RESOURCES.indentMiddleLine()));
                }
                for (d = depth + 1; d <= maxDepth; ++d) {
                    indent.add((Widget)new Image(RESOURCES.indentBlankSpace()));
                }
                row.add((Object)indent);
                row.add(new PlaceHolderCell(p.getName()));
                this.addRow(p, row);
            }
        }
        if (depth > 1 && this.getRowCount() > 1) {
            P indent4 = (P)this.getWidget(this.getRowCount() - 1, 0);
            indent4.remove(depth - 2);
            indent4.insert((Widget)new Image(RESOURCES.indentLastLine()), depth - 2);
        }
    }

    public boolean canChoose(int row) {
        if (row <= 1 || row >= this.getRowCount()) {
            return false;
        }
        Widget w = this.getWidget(row, 1);
        return w != null && w instanceof ChoiceButton;
    }

    public void chooseRow(int row, boolean value) {
        if (row <= 1 || row >= this.getRowCount()) {
            return;
        }
        Widget w = this.getWidget(row, 1);
        if (w != null && w instanceof ChoiceButton) {
            ((ChoiceButton)w).setValue(value, true);
        }
    }

    public boolean isLast(ClassAssignmentInterface.CourseAssignment course) {
        if (this.iAssignments.getLastAssignment() != null) {
            for (ClassAssignmentInterface.CourseAssignment c : this.iAssignments.getLastAssignment().getCourseAssignments()) {
                if (!course.getCourseId().equals(c.getCourseId()) || !c.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSaved(ClassAssignmentInterface.CourseAssignment course) {
        if (this.iAssignments.getSavedAssignment() != null) {
            for (ClassAssignmentInterface.CourseAssignment c : this.iAssignments.getSavedAssignment().getCourseAssignments()) {
                if (!course.getCourseId().equals(c.getCourseId()) || !c.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isLast(CourseRequestInterface.RequestedCourse course) {
        if (course == null || course.isEmpty()) {
            return false;
        }
        if (this.iAssignments.getLastAssignment() != null) {
            for (ClassAssignmentInterface.CourseAssignment c : this.iAssignments.getLastAssignment().getCourseAssignments()) {
                if (!course.equals(c) || !c.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSaved(CourseRequestInterface.RequestedCourse course) {
        if (course == null || course.isEmpty()) {
            return false;
        }
        if (this.iAssignments.getSavedAssignment() != null) {
            for (ClassAssignmentInterface.CourseAssignment c : this.iAssignments.getSavedAssignment().getCourseAssignments()) {
                if (!course.equals(c) || !c.isAssigned()) continue;
                return true;
            }
        }
        return false;
    }

    public CourseRequestInterface createRequests() {
        CourseRequestInterface.RequestedCourse course;
        Iterator<CourseRequestInterface.RequestedCourse> j;
        CourseRequestInterface.Request request;
        CourseRequestInterface requests = (CourseRequestInterface)this.iRequests.getValue();
        boolean includeAlternatives = this.iMode == StudentSectioningPage.Mode.REQUESTS;
        Iterator<CourseRequestInterface.Request> i = requests.getCourses().iterator();
        while (i.hasNext()) {
            request = i.next();
            if (!request.isCanDelete()) continue;
            if (request.hasRequestedCourse()) {
                j = request.getRequestedCourse().iterator();
                while (j.hasNext()) {
                    course = j.next();
                    if (this.isLast(course)) {
                        if (includeAlternatives || !this.iPlan.hasCourse(course) || this.iPlan.isCourseSelected(course)) continue;
                        j.remove();
                        continue;
                    }
                    j.remove();
                }
            }
            if (request.hasRequestedCourse()) continue;
            i.remove();
        }
        i = requests.getAlternatives().iterator();
        while (i.hasNext()) {
            request = i.next();
            if (!request.isCanDelete()) continue;
            if (request.hasRequestedCourse()) {
                j = request.getRequestedCourse().iterator();
                while (j.hasNext()) {
                    course = j.next();
                    if (this.isLast(course)) {
                        if (!this.iPlan.hasCourse(course) || this.iPlan.isCourseSelected(course)) continue;
                        j.remove();
                        continue;
                    }
                    j.remove();
                }
            }
            if (!request.isEmpty()) {
                requests.getCourses().add(request);
            }
            i.remove();
        }
        block4: for (DegreePlanInterface.DegreeCourseInterface course2 : this.iPlan.listSelected(includeAlternatives)) {
            CourseRequestInterface.RequestPriority p;
            ClassAssignmentInterface.CourseAssignment ca = course2.getSelectedCourse(includeAlternatives);
            if (ca == null || (p = requests.getRequestPriority(ca)) != null) continue;
            CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
            rc.setCourseId(ca.getCourseId());
            rc.setCourseName(CONSTANTS.showCourseTitle() ? MESSAGES.courseNameWithTitle(ca.getSubject(), ca.getCourseNbr(), ca.getTitle()) : MESSAGES.course(ca.getSubject(), ca.getCourseNbr()));
            rc.setCourseTitle(ca.getTitle());
            rc.setCredit(ca.guessCreditRange());
            if (includeAlternatives) {
                p = requests.getRequestPriority(course2);
                if (p != null) {
                    p.getRequest().getRequestedCourse().add(0, rc);
                    continue;
                }
                List<DegreePlanInterface.DegreeCourseInterface> alternatives = this.iPlan.listAlternatives(course2);
                for (DegreePlanInterface.DegreeCourseInterface alternative : alternatives) {
                    p = requests.getRequestPriority(alternative);
                    if (p == null) continue;
                    p.getRequest().getRequestedCourse().add(0, rc);
                    continue block4;
                }
                CourseRequestInterface.Request r = new CourseRequestInterface.Request();
                r.addRequestedCourse(rc);
                for (DegreePlanInterface.DegreeCourseInterface alternative : alternatives) {
                    ClassAssignmentInterface.CourseAssignment altCa = alternative.getSelectedCourse(includeAlternatives);
                    if (altCa == null) continue;
                    CourseRequestInterface.RequestedCourse altRc = new CourseRequestInterface.RequestedCourse();
                    altRc.setCourseId(altCa.getCourseId());
                    altRc.setCourseName(CONSTANTS.showCourseTitle() ? MESSAGES.courseNameWithTitle(altCa.getSubject(), altCa.getCourseNbr(), altCa.getTitle()) : MESSAGES.course(altCa.getSubject(), altCa.getCourseNbr()));
                    altRc.setCourseTitle(altCa.getTitle());
                    altRc.setCredit(altCa.guessCreditRange());
                    r.addRequestedCourse(altRc);
                }
                requests.getCourses().add(r);
                continue;
            }
            CourseRequestInterface.Request r = new CourseRequestInterface.Request();
            r.addRequestedCourse(rc);
            requests.getCourses().add(r);
        }
        return requests;
    }

    public void updateBackground() {
        boolean includeAlternatives = this.iMode == StudentSectioningPage.Mode.REQUESTS;
        CourseRequestInterface requests = (CourseRequestInterface)this.iRequests.getValue();
        HashSet<String> selectedCourses = new HashSet<String>();
        HashSet<Long> selectedCourseIds = new HashSet<Long>();
        for (DegreePlanInterface.DegreeCourseInterface course : this.iPlan.listSelected(false)) {
            if (course.getId() != null) {
                selectedCourses.add(course.getId());
            }
            if (course.getCourseId() == null) continue;
            selectedCourseIds.add(course.getCourseId());
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            String color;
            IsSerializable course;
            Object data = this.getData(row);
            if (data != null && data instanceof ClassAssignmentInterface.CourseAssignment) {
                course = (ClassAssignmentInterface.CourseAssignment)data;
                CourseRequestInterface.RequestPriority rp = requests.getRequestPriority((ClassAssignmentInterface.CourseAssignment)course);
                boolean requested = rp != null;
                boolean selected = selectedCourseIds.contains(course.getCourseId());
                String color2 = null;
                if (selected) {
                    if (!requested) {
                        color2 = "#D7FFD7";
                    }
                } else if (requested && !includeAlternatives) {
                    color2 = "#FFD7D7";
                }
                this.setBackGroundColor(row, color2);
                continue;
            }
            if (data != null && data instanceof DegreePlanInterface.DegreeGroupInterface) {
                DegreePlanInterface.DegreeGroupInterface group = (DegreePlanInterface.DegreeGroupInterface)data;
                if (!group.isChoice()) continue;
                color = null;
                if (!group.hasSelection()) {
                    color = "#FFF0AB";
                }
                this.setBackGroundColor(row, color);
                continue;
            }
            if (data == null || !(data instanceof DegreePlanInterface.DegreeCourseInterface)) continue;
            course = (DegreePlanInterface.DegreeCourseInterface)data;
            color = null;
            if (course.getId() != null && selectedCourses.contains(course.getId()) && course.getCourseId() == null) {
                color = "#FFF0AB";
            }
            this.setBackGroundColor(row, color);
        }
    }

    public static class RequestPriorityCell
    extends Label {
        public RequestPriorityCell(CourseRequestInterface requests, ClassAssignmentInterface.CourseAssignment assignment) {
            CourseRequestInterface.RequestPriority rp = requests.getRequestPriority(assignment);
            this.setText(rp == null ? "" : rp.toString(MESSAGES));
            this.setWordWrap(false);
            this.addStyleName("request");
        }
    }

    public static class NoteCell
    extends Label {
        public NoteCell(String label) {
            super(label == null ? "" : label, false);
            if (label != null && !label.isEmpty()) {
                this.setTitle(label);
            }
            this.addStyleName("note");
        }
    }

    public class ChoiceButton
    extends RadioButton {
        public ChoiceButton(final DegreePlanInterface.DegreeGroupInterface parent, final DegreePlanInterface.DegreeCourseInterface course) {
            super(parent.getId(), "");
            this.setValue(course.isSelected());
            this.setTitle(MESSAGES.hintChoiceGroupSelection(MESSAGES.course(course.getSubject(), course.getCourse())));
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (parent.hasCourses()) {
                        for (DegreePlanInterface.DegreeCourseInterface c : parent.getCourses()) {
                            c.setSelected(course.getId().equals(c.getId()) ? (Boolean)event.getValue() : false);
                        }
                    }
                    if (parent.hasGroups()) {
                        for (DegreePlanInterface.DegreeGroupInterface g : parent.getGroups()) {
                            g.setSelected(false);
                        }
                    }
                    DegreePlanTable.this.updateBackground();
                }
            });
        }

        public ChoiceButton(final DegreePlanInterface.DegreeGroupInterface parent, final DegreePlanInterface.DegreeGroupInterface group) {
            super(parent.getId(), "");
            this.setValue(group.isSelected());
            this.setTitle(MESSAGES.hintChoiceGroupSelection(group.toString(MESSAGES)));
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (parent.hasCourses()) {
                        for (DegreePlanInterface.DegreeCourseInterface c : parent.getCourses()) {
                            c.setSelected(false);
                        }
                    }
                    if (parent.hasGroups()) {
                        for (DegreePlanInterface.DegreeGroupInterface g : parent.getGroups()) {
                            g.setSelected(group.getId().equals(g.getId()) ? (Boolean)event.getValue() : false);
                        }
                    }
                    DegreePlanTable.this.updateBackground();
                }
            });
        }

        public ChoiceButton(final DegreePlanInterface.DegreeCourseInterface parent, final ClassAssignmentInterface.CourseAssignment course) {
            super(parent.getId(), "");
            this.setTitle(MESSAGES.hintChoiceGroupSelection(MESSAGES.course(course.getSubject(), course.getCourseNbr())));
            this.setValue(course.getCourseId().equals(parent.getCourseId()));
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        parent.setCourseId(course.getCourseId());
                    } else {
                        parent.setCourseId(null);
                    }
                    DegreePlanTable.this.updateBackground();
                }
            });
        }

        public ChoiceButton(final DegreePlanInterface.DegreeGroupInterface group, final DegreePlanInterface.DegreeCourseInterface parent, final ClassAssignmentInterface.CourseAssignment course) {
            super(group.getId(), "");
            this.setTitle(MESSAGES.hintChoiceGroupSelection(MESSAGES.course(course.getSubject(), course.getCourseNbr())));
            this.setValue(course.getCourseId().equals(parent.getCourseId()) && parent.isSelected());
            this.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                }
            });
            this.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    if (((Boolean)event.getValue()).booleanValue()) {
                        parent.setCourseId(course.getCourseId());
                    } else {
                        parent.setCourseId(null);
                    }
                    if (group.hasCourses()) {
                        for (DegreePlanInterface.DegreeCourseInterface c : group.getCourses()) {
                            c.setSelected(parent.getId().equals(c.getId()) ? (Boolean)event.getValue() : false);
                        }
                    }
                    if (group.hasGroups()) {
                        for (DegreePlanInterface.DegreeGroupInterface g : group.getGroups()) {
                            g.setSelected(false);
                        }
                    }
                    DegreePlanTable.this.updateBackground();
                }
            });
        }
    }

    public static class PlaceHolderCell
    extends Label
    implements UniTimeTable.HasColSpan {
        public PlaceHolderCell(String label) {
            super(label, false);
            this.addStyleName("placeholder");
            this.setTitle(label);
        }

        public int getColSpan() {
            return 8;
        }
    }

    public static class TitleLabel
    extends Label {
        public TitleLabel(String label) {
            super(label, false);
            this.addStyleName("title");
        }
    }

    public static class CourseNotOfferedLabel
    extends Label
    implements UniTimeTable.HasColSpan {
        public CourseNotOfferedLabel(String label) {
            super(label, false);
            this.addStyleName("error");
        }

        public int getColSpan() {
            return 5;
        }
    }

    public static class CourseLabel
    extends Label
    implements UniTimeTable.HasColSpan {
        private boolean iHasChoice;

        public CourseLabel(String label, boolean hasChoice) {
            super(label, false);
            this.addStyleName("course");
            this.iHasChoice = hasChoice;
        }

        public int getColSpan() {
            return this.iHasChoice ? 1 : 2;
        }
    }

    public static class GroupTitleCell
    extends Label
    implements UniTimeTable.HasColSpan {
        private boolean iHasChoice;

        public GroupTitleCell(String label, boolean hasChoice) {
            super(label, false);
            this.addStyleName("grouplabel");
            this.iHasChoice = hasChoice;
            this.setTitle(label);
        }

        public int getColSpan() {
            return this.iHasChoice ? 7 : 8;
        }
    }
}

