/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeFileUpload;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.RoomInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomPicturesPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private SimpleForm iForm = new SimpleForm();
    private UniTimeTable<RoomInterface.RoomPictureInterface> iTable;
    private UniTimeHeaderPanel iHeader = new UniTimeHeaderPanel();
    private UniTimeHeaderPanel iFooter;
    private List<RoomInterface.AttachmentTypeInterface> iPictureTypes;
    private UniTimeFileUpload iFileUpload;
    private ListBox iApply;
    private Long iLocationId = null;

    public RoomPicturesPage() {
        this.iHeader.addButton("update", MESSAGES.buttonUpdate(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomPicturesPage.this.iHeader.showLoading();
                RPC.execute(RoomInterface.RoomPictureRequest.save(RoomPicturesPage.this.iLocationId, RoomInterface.RoomPictureRequest.Apply.values()[RoomPicturesPage.this.iApply.getSelectedIndex()], RoomPicturesPage.this.iTable.getData()), new AsyncCallback<RoomInterface.RoomPictureResponse>(){

                    public void onFailure(Throwable caught) {
                        RoomPicturesPage.this.iHeader.setErrorMessage(MESSAGES.failedToSaveRoomPictures(caught.getMessage()));
                    }

                    public void onSuccess(RoomInterface.RoomPictureResponse result) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "roomDetail.do?id=" + RoomPicturesPage.this.iLocationId);
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "roomDetail.do?id=" + RoomPicturesPage.this.iLocationId);
            }
        });
        this.iHeader.setEnabled("update", false);
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iApply = new ListBox();
        for (RoomInterface.RoomPictureRequest.Apply apply : RoomInterface.RoomPictureRequest.Apply.values()) {
            String item = apply.name();
            switch (apply) {
                case THIS_SESSION_ONLY: {
                    item = MESSAGES.itemThisSessionOnly();
                    break;
                }
                case ALL_FUTURE_SESSIONS: {
                    item = MESSAGES.itemAllFutureSessions();
                    break;
                }
                case ALL_SESSIONS: {
                    item = MESSAGES.itemAllSessions();
                }
            }
            this.iApply.addItem(item, apply.name());
        }
        this.iForm.addRow(MESSAGES.propAppliesTo(), (Widget)this.iApply);
        this.iApply.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomPicturesPage.this.iHeader.setEnabled("update", true);
            }
        });
        this.iTable = new UniTimeTable();
        this.iTable.setStyleName("unitime-RoomPictures");
        this.iFileUpload = new UniTimeFileUpload();
        this.iForm.addRow(MESSAGES.propNewPicture(), (Widget)this.iFileUpload);
        this.iFileUpload.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                RPC.execute(RoomInterface.RoomPictureRequest.upload(RoomPicturesPage.this.iLocationId), new AsyncCallback<RoomInterface.RoomPictureResponse>(){

                    public void onFailure(Throwable caught) {
                        RoomPicturesPage.this.iHeader.setErrorMessage(MESSAGES.failedToUploadRoomPicture(caught.getMessage()));
                    }

                    public void onSuccess(RoomInterface.RoomPictureResponse result) {
                        if (result.hasPictures()) {
                            for (RoomInterface.RoomPictureInterface picture : result.getPictures()) {
                                for (int row = 1; row < RoomPicturesPage.this.iTable.getRowCount(); ++row) {
                                    if (!picture.getName().equals(((RoomInterface.RoomPictureInterface)RoomPicturesPage.this.iTable.getData(row)).getName())) continue;
                                    RoomPicturesPage.this.iTable.removeRow(row);
                                    break;
                                }
                                RoomPicturesPage.this.iTable.addRow(picture, RoomPicturesPage.this.line(picture));
                            }
                            RoomPicturesPage.this.iHeader.setEnabled("update", true);
                            RoomPicturesPage.this.iFileUpload.reset();
                        }
                    }
                });
            }
        });
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        header.add(new UniTimeTableHeader(MESSAGES.colPicture()));
        header.add(new UniTimeTableHeader(MESSAGES.colName()));
        header.add(new UniTimeTableHeader(MESSAGES.colContentType()));
        header.add(new UniTimeTableHeader(MESSAGES.colPictureType()));
        header.add(new UniTimeTableHeader("&nbsp;"));
        this.iTable.addRow(null, header);
        this.iForm.addRow((Widget)this.iTable);
        this.iFooter = this.iHeader.clonePanel("");
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.iFooter.setVisible(false);
        this.initWidget((Widget)this.iForm);
        try {
            this.iLocationId = Long.valueOf(Window.Location.getParameter((String)"id"));
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingRoomPictures());
            RPC.execute(RoomInterface.RoomPictureRequest.load(this.iLocationId), new AsyncCallback<RoomInterface.RoomPictureResponse>(){

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    RoomPicturesPage.this.iHeader.setErrorMessage(MESSAGES.failedToSaveRoomAvailability(caught.getMessage()));
                }

                public void onSuccess(RoomInterface.RoomPictureResponse result) {
                    LoadingWidget.getInstance().hide();
                    RoomPicturesPage.this.iPictureTypes = result.getPictureTypes();
                    if (result.hasPictures()) {
                        for (RoomInterface.RoomPictureInterface picture : result.getPictures()) {
                            RoomPicturesPage.this.iTable.addRow(picture, RoomPicturesPage.this.line(picture));
                        }
                    }
                    RoomPicturesPage.this.iApply.setSelectedIndex(result.getApply().ordinal());
                    RoomPicturesPage.this.iFooter.setVisible(true);
                    RoomPicturesPage.this.iHeader.setHeaderTitle(result.getName());
                    RoomPicturesPage.this.iFileUpload.reset();
                }
            });
        }
        catch (Exception e) {
            this.iHeader.setErrorMessage(MESSAGES.failedToLoadRoomPictures(e.getMessage()));
        }
    }

    private List<Widget> line(final RoomInterface.RoomPictureInterface picture) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        Image image = new Image(GWT.getHostPageBaseURL() + "picture?id=" + picture.getUniqueId());
        image.addStyleName("image");
        line.add((Widget)image);
        line.add((Widget)new Label(picture.getName()));
        line.add((Widget)new Label(picture.getType()));
        final ListBox type = new ListBox();
        type.setStyleName("unitime-TextBox");
        if (picture.getPictureType() == null) {
            type.addItem(MESSAGES.itemSelect(), "-1");
            if (this.iPictureTypes != null) {
                for (RoomInterface.AttachmentTypeInterface t : this.iPictureTypes) {
                    type.addItem(t.getLabel(), t.getId().toString());
                }
            }
            type.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    Long id = Long.valueOf(type.getValue(type.getSelectedIndex()));
                    picture.setPictureType(RoomPicturesPage.this.getPictureType(id));
                    RoomPicturesPage.this.iHeader.setEnabled("update", false);
                }
            });
        } else {
            final RoomInterface.AttachmentTypeInterface last = picture.getPictureType();
            if (this.iPictureTypes != null) {
                for (RoomInterface.AttachmentTypeInterface t : this.iPictureTypes) {
                    type.addItem(t.getLabel(), t.getId().toString());
                }
            }
            boolean found = false;
            for (int i = 0; i < type.getItemCount(); ++i) {
                if (!type.getValue(i).equals(picture.getPictureType().getId().toString())) continue;
                type.setSelectedIndex(i);
                found = true;
                break;
            }
            if (!found) {
                type.addItem(picture.getPictureType().getLabel(), picture.getPictureType().getId().toString());
                type.setSelectedIndex(type.getItemCount() - 1);
            }
            type.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    Long id = Long.valueOf(type.getValue(type.getSelectedIndex()));
                    if (last.getId().equals(id)) {
                        picture.setPictureType(last);
                    } else {
                        picture.setPictureType(RoomPicturesPage.this.getPictureType(id));
                    }
                    RoomPicturesPage.this.iHeader.setEnabled("update", false);
                }
            });
        }
        line.add((Widget)type);
        Image remove = new Image(RESOURCES.delete());
        remove.setTitle(MESSAGES.titleDeleteRow());
        remove.addStyleName("remove");
        remove.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                for (int row = 1; row < RoomPicturesPage.this.iTable.getRowCount(); ++row) {
                    if (!picture.getUniqueId().equals(((RoomInterface.RoomPictureInterface)RoomPicturesPage.this.iTable.getData(row)).getUniqueId())) continue;
                    RoomPicturesPage.this.iTable.removeRow(row);
                    break;
                }
                RoomPicturesPage.this.iHeader.setEnabled("update", true);
                event.stopPropagation();
            }
        });
        line.add((Widget)remove);
        return line;
    }

    protected RoomInterface.AttachmentTypeInterface getPictureType(Long id) {
        if (this.iPictureTypes == null) {
            return null;
        }
        for (RoomInterface.AttachmentTypeInterface type : this.iPictureTypes) {
            if (!type.getId().equals(id)) continue;
            return type;
        }
        return null;
    }
}

