/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomGroupEdit
extends Composite {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private SimpleForm iForm;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private RoomInterface.RoomPropertiesInterface iProperties;
    private RoomInterface.GroupInterface iGroup;
    private UniTimeWidget<TextBox> iName;
    private UniTimeWidget<TextBox> iAbbreviation;
    private UniTimeWidget<ListBox> iDepartment;
    private CheckBox iGlobal;
    private CheckBox iDefault;
    private int iDepartmentRow = -1;
    private int iDefaultRow = -1;
    private UniTimeWidget<TextArea> iDescription;
    private RoomsTable iRooms = null;
    private P iFutureSessions;
    private Map<Long, CheckBox> iFutureSessionsToggles = new HashMap<Long, CheckBox>();
    private int iFutureSessionsRow = -1;
    private Label iSessionLabel = null;
    private int iLastScrollTop;
    private int iLastScrollLeft;

    public RoomGroupEdit(RoomInterface.RoomsPageMode mode) {
        this.iForm = new SimpleForm();
        this.iForm.addStyleName("unitime-RoomGroupEdit");
        this.iHeader = new UniTimeHeaderPanel();
        ClickHandler createOrUpdateGroup = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (RoomGroupEdit.this.validate()) {
                    RoomInterface.UpdateRoomGroupRequest request = new RoomInterface.UpdateRoomGroupRequest();
                    request.setGroup(RoomGroupEdit.this.iGroup);
                    request.setSessionId(RoomGroupEdit.this.iGroup.getSessionId());
                    String future = RoomGroupEdit.this.generateAlsoUpdateMessage();
                    if (future != null) {
                        if (Window.confirm((String)(RoomGroupEdit.this.iGroup.getId() == null ? MESSAGES.confirmCreateRoomGroupInFutureSessions(future) : MESSAGES.confirmUpdateRoomGroupInFutureSessions(future)))) {
                            RoomGroupEdit.this.fillFutureFlags(request);
                        } else {
                            return;
                        }
                    }
                    for (int i = 1; i < RoomGroupEdit.this.iRooms.getRowCount(); ++i) {
                        RoomInterface.RoomDetailInterface room = (RoomInterface.RoomDetailInterface)RoomGroupEdit.this.iRooms.getData(i);
                        boolean wasSelected = room.hasGroup(RoomGroupEdit.this.iGroup.getId());
                        boolean selected = RoomGroupEdit.this.iRooms.isRoomSelected(i);
                        if (selected == wasSelected) continue;
                        if (selected) {
                            request.addLocation(room.getUniqueId());
                            continue;
                        }
                        request.dropLocation(room.getUniqueId());
                    }
                    LoadingWidget.getInstance().show(RoomGroupEdit.this.iGroup.getId() == null ? MESSAGES.waitSavingRoomGroup() : MESSAGES.waitUpdatingRoomGroup());
                    RPC.execute(request, new AsyncCallback<RoomInterface.GroupInterface>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            String message = RoomGroupEdit.this.iGroup.getId() == null ? MESSAGES.errorFailedToSaveRoomGroup(caught.getMessage()) : MESSAGES.errorFailedToUpdateRoomGroup(caught.getMessage());
                            RoomGroupEdit.this.iHeader.setErrorMessage(message);
                            UniTimeNotifications.error(message);
                        }

                        public void onSuccess(RoomInterface.GroupInterface result) {
                            LoadingWidget.getInstance().hide();
                            RoomGroupEdit.this.hide(true, result);
                        }
                    });
                } else {
                    RoomGroupEdit.this.iHeader.setErrorMessage(MESSAGES.failedValidationCheckForm());
                    UniTimeNotifications.error(MESSAGES.failedValidationCheckForm());
                }
            }
        };
        this.iHeader.addButton("create", MESSAGES.buttonCreateRoomGroup(), 100, createOrUpdateGroup);
        this.iHeader.addButton("update", MESSAGES.buttonUpdateRoomGroup(), 100, createOrUpdateGroup);
        this.iHeader.addButton("delete", MESSAGES.buttonDeleteRoomGroup(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                String future = RoomGroupEdit.this.generateAlsoUpdateMessage();
                RoomInterface.UpdateRoomGroupRequest request = new RoomInterface.UpdateRoomGroupRequest();
                if (Window.confirm((String)(future == null ? MESSAGES.confirmDeleteRoomGroup() : MESSAGES.confirmDeleteRoomGroupInFutureSessions(future)))) {
                    if (future != null) {
                        RoomGroupEdit.this.fillFutureFlags(request);
                    }
                } else {
                    return;
                }
                request.setDeleteGroupId(RoomGroupEdit.this.iGroup.getId());
                request.setSessionId(RoomGroupEdit.this.iGroup.getSessionId());
                LoadingWidget.getInstance().show(MESSAGES.waitDeletingRoomGroup());
                RPC.execute(request, new AsyncCallback<RoomInterface.GroupInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        String message = MESSAGES.errorFailedToDeleteRoomGroup(caught.getMessage());
                        RoomGroupEdit.this.iHeader.setErrorMessage(message);
                        UniTimeNotifications.error(message);
                    }

                    public void onSuccess(RoomInterface.GroupInterface result) {
                        LoadingWidget.getInstance().hide();
                        RoomGroupEdit.this.hide(true, result);
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomGroupEdit.this.hide(false, RoomGroupEdit.this.iGroup);
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        if (mode.hasSessionSelection()) {
            this.iSessionLabel = new Label();
            this.iForm.addRow(MESSAGES.propAcademicSession(), (Widget)this.iSessionLabel);
        }
        this.iName = new UniTimeWidget<TextBox>(new TextBox());
        this.iName.getWidget().setStyleName("unitime-TextBox");
        this.iName.getWidget().setMaxLength(60);
        this.iName.getWidget().setWidth("370px");
        this.iName.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomGroupEdit.this.iName.clearHint();
                RoomGroupEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propName(), (Widget)this.iName);
        this.iAbbreviation = new UniTimeWidget<TextBox>(new TextBox());
        this.iAbbreviation.getWidget().setStyleName("unitime-TextBox");
        this.iAbbreviation.getWidget().setMaxLength(60);
        this.iAbbreviation.getWidget().setWidth("370px");
        this.iAbbreviation.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomGroupEdit.this.iAbbreviation.clearHint();
                RoomGroupEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propAbbreviation(), (Widget)this.iAbbreviation);
        this.iGlobal = new CheckBox();
        this.iForm.addRow(MESSAGES.propGlobalGroup(), (Widget)this.iGlobal);
        this.iGlobal.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RoomGroupEdit.this.iForm.getRowFormatter().setVisible(RoomGroupEdit.this.iDefaultRow, ((Boolean)event.getValue()).booleanValue());
                RoomGroupEdit.this.iForm.getRowFormatter().setVisible(RoomGroupEdit.this.iDepartmentRow, (Boolean)event.getValue() == false);
            }
        });
        this.iDefault = new CheckBox();
        this.iDefaultRow = this.iForm.addRow(MESSAGES.propDefaultGroup(), (Widget)this.iDefault);
        this.iDepartment = new UniTimeWidget<ListBox>(new ListBox());
        this.iDepartment.getWidget().setStyleName("unitime-TextBox");
        this.iDepartmentRow = this.iForm.addRow(MESSAGES.propDepartment(), (Widget)this.iDepartment);
        this.iDescription = new UniTimeWidget<TextArea>(new TextArea());
        this.iDescription.getWidget().setStyleName("unitime-TextArea");
        this.iDescription.getWidget().setVisibleLines(3);
        this.iDescription.getWidget().setCharacterWidth(50);
        this.iForm.addRow(MESSAGES.propDescription(), (Widget)this.iDescription);
        this.iForm.addHeaderRow(MESSAGES.headerRooms());
        this.iRooms = new RoomsTable(mode, true);
        this.iForm.addRow((Widget)this.iRooms);
        this.iRooms.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.RoomDetailInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.RoomDetailInterface> event) {
                RoomGroupEdit.this.iHeader.clearMessage();
            }
        });
        this.iFutureSessions = new P("future-sessions");
        this.iFutureSessionsRow = this.iForm.addRow(MESSAGES.propApplyToFutureSessions(), (Widget)this.iFutureSessions);
        this.iForm.getCellFormatter().addStyleName(this.iFutureSessionsRow, 0, "future-sessions-header");
        this.iForm.getRowFormatter().setVisible(this.iFutureSessionsRow, false);
        this.iFooter = this.iHeader.clonePanel();
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.initWidget((Widget)this.iForm);
    }

    public void setProperties(RoomInterface.RoomPropertiesInterface properties) {
        this.iProperties = properties;
        this.iRooms.setProperties(properties);
        this.iFutureSessions.clear();
        this.iForm.getRowFormatter().setVisible(this.iFutureSessionsRow, this.iProperties.hasFutureSessions());
        if (this.iProperties.hasFutureSessions()) {
            CheckBox current = new CheckBox(this.iProperties.getAcademicSessionName());
            current.setValue(Boolean.valueOf(true));
            current.setEnabled(false);
            current.addStyleName("future-session");
            this.iFutureSessions.add((Widget)current);
            for (RoomInterface.AcademicSessionInterface session : this.iProperties.getFutureSessions()) {
                if (!session.isCanAddGlobalRoomGroup() && !session.isCanAddDepartmentalRoomGroup()) continue;
                CheckBox ch = new CheckBox(session.getLabel());
                this.iFutureSessionsToggles.put(session.getId(), ch);
                ch.addStyleName("future-session");
                this.iFutureSessions.add((Widget)ch);
            }
        }
    }

    private void hide(boolean refresh, RoomInterface.GroupInterface group) {
        this.setVisible(false);
        this.onHide(refresh, group);
        Window.scrollTo((int)this.iLastScrollLeft, (int)this.iLastScrollTop);
    }

    protected void onHide(boolean refresh, RoomInterface.GroupInterface group) {
    }

    protected void onShow() {
    }

    public void show() {
        UniTimePageLabel.getInstance().setPageName(this.iGroup.getId() == null ? MESSAGES.pageAddRoomGroup() : MESSAGES.pageEditRoomGroup());
        this.setVisible(true);
        this.iLastScrollLeft = Window.getScrollLeft();
        this.iLastScrollTop = Window.getScrollTop();
        this.onShow();
        Window.scrollTo((int)0, (int)0);
    }

    public void hide() {
        this.hide(true, this.iGroup);
    }

    public void setGroup(RoomInterface.GroupInterface group, String dept) {
        this.iHeader.clearMessage();
        this.iName.clearHint();
        this.iAbbreviation.clearHint();
        this.iDepartment.clearHint();
        this.iDescription.clearHint();
        if (group == null) {
            this.iGroup = new RoomInterface.GroupInterface();
            this.iGroup.setSessionId(this.iProperties.getAcademicSessionId());
            this.iGroup.setSessionName(this.iProperties.getAcademicSessionName());
            if (this.iSessionLabel != null) {
                this.iSessionLabel.setText(this.iProperties.getAcademicSessionName());
            }
            this.iHeader.setEnabled("create", true);
            this.iHeader.setEnabled("update", false);
            this.iHeader.setEnabled("delete", false);
            this.iName.getWidget().setText("");
            this.iAbbreviation.getWidget().setText("");
            this.iDescription.getWidget().setText("");
            this.iDepartment.getWidget().clear();
            this.iGlobal.setValue(Boolean.valueOf(true));
            this.iDefault.setValue(Boolean.valueOf(false));
            this.iGlobal.setEnabled(true);
            if (this.iProperties.isCanAddDepartmentalRoomGroup()) {
                this.iDepartment.getWidget().addItem(MESSAGES.itemSelect(), "-1");
                this.iDepartment.getWidget().setSelectedIndex(0);
                for (RoomInterface.DepartmentInterface department : this.iProperties.getDepartments()) {
                    this.iDepartment.getWidget().addItem(department.getExtAbbreviationOrCode() + " - " + department.getExtLabelWhenExist(), department.getId().toString());
                    if (dept == null || !dept.equals(department.getDeptCode())) continue;
                    this.iDepartment.getWidget().setSelectedIndex(this.iDepartment.getWidget().getItemCount() - 1);
                    this.iGlobal.setValue(Boolean.valueOf(false), true);
                }
            }
            if (!this.iProperties.isCanAddGlobalRoomGroup()) {
                this.iGlobal.setValue(Boolean.valueOf(false));
                this.iGlobal.setEnabled(false);
            } else if (!this.iProperties.isCanAddDepartmentalRoomGroup()) {
                this.iGlobal.setValue(Boolean.valueOf(true));
                this.iGlobal.setEnabled(false);
            }
        } else {
            this.iGroup = new RoomInterface.GroupInterface(group);
            if (this.iSessionLabel != null) {
                this.iSessionLabel.setText(group.getSessionName());
            }
            this.iHeader.setEnabled("create", false);
            this.iHeader.setEnabled("update", group.canEdit());
            this.iHeader.setEnabled("delete", group.canDelete());
            this.iName.getWidget().setText(group.getLabel() == null ? "" : group.getLabel());
            this.iAbbreviation.getWidget().setText(group.getAbbreviation() == null ? "" : group.getAbbreviation());
            this.iDescription.getWidget().setText(group.getDescription() == null ? "" : group.getDescription());
            this.iGlobal.setValue(Boolean.valueOf(!group.isDepartmental()));
            this.iGlobal.setEnabled(false);
            if (!group.isDepartmental()) {
                this.iDefault.setValue(Boolean.valueOf(group.isDefault()));
            }
            this.iDepartment.getWidget().clear();
            if (group.isDepartmental()) {
                for (RoomInterface.DepartmentInterface department : this.iProperties.getDepartments()) {
                    this.iDepartment.getWidget().addItem(department.getExtAbbreviationOrCode() + " - " + department.getExtLabelWhenExist(), department.getId().toString());
                }
                int index = this.iProperties.getDepartments().indexOf(group.getDepartment());
                if (index >= 0) {
                    this.iDepartment.getWidget().setSelectedIndex(index);
                } else {
                    this.iDepartment.getWidget().addItem(group.getDepartment().getExtAbbreviationOrCode() + " - " + group.getDepartment().getExtLabelWhenExist(), group.getDepartment().getId().toString());
                    this.iDepartment.getWidget().setSelectedIndex(this.iDepartment.getWidget().getItemCount() - 1);
                }
            }
        }
        this.iDefault.setEnabled(this.iProperties.isCanChangeDefaultGroup());
        if (this.iProperties.hasFutureSessions()) {
            for (RoomInterface.AcademicSessionInterface session : this.iProperties.getFutureSessions()) {
                CheckBox ch = this.iFutureSessionsToggles.get(session.getId());
                if (ch == null) continue;
                ch.setValue(Boolean.valueOf(RoomCookie.getInstance().getFutureFlags(session.getId()) != null));
            }
        }
        this.iForm.getRowFormatter().setVisible(this.iDefaultRow, this.iGlobal.getValue().booleanValue());
        this.iForm.getRowFormatter().setVisible(this.iDepartmentRow, this.iGlobal.getValue() == false);
    }

    public void setRooms(List<EventInterface.FilterRpcResponse.Entity> rooms) {
        this.iRooms.clearTable(1);
        this.iHeader.clearMessage();
        ValueChangeHandler<Boolean> clearErrorMessage = new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RoomGroupEdit.this.iHeader.clearMessage();
            }
        };
        for (EventInterface.FilterRpcResponse.Entity e : rooms) {
            RoomInterface.RoomDetailInterface room = (RoomInterface.RoomDetailInterface)e;
            int row = this.iRooms.addRoom(room);
            boolean selected = room.hasGroup(this.iGroup.getId());
            this.iRooms.selectRoom(row, selected);
            this.iRooms.setSelected(row, selected);
            this.iRooms.getRoomSelection(row).addValueChangeHandler((ValueChangeHandler)clearErrorMessage);
        }
        int sort = RoomCookie.getInstance().getRoomsSortBy();
        if (sort != 0) {
            this.iRooms.setSortBy(sort);
        }
    }

    public boolean validate() {
        boolean result = true;
        this.iGroup.setLabel(this.iName.getWidget().getText());
        if (this.iGroup.getLabel().isEmpty()) {
            this.iName.setErrorHint(MESSAGES.errorNameIsEmpty());
            result = false;
        }
        this.iGroup.setAbbreviation(this.iAbbreviation.getWidget().getText());
        if (this.iGroup.getAbbreviation().isEmpty()) {
            this.iAbbreviation.setErrorHint(MESSAGES.errorAbbreviationIsEmpty());
            result = false;
        }
        this.iGroup.setDefault(this.iDefault.getValue());
        this.iGroup.setDescription(this.iDescription.getWidget().getText());
        if (this.iGroup.getDescription().length() > 1000) {
            this.iDescription.setErrorHint(MESSAGES.errorDescriptionTooLong());
            result = false;
        }
        if (!this.iGlobal.getValue().booleanValue()) {
            this.iGroup.setDepartment(this.iProperties.getDepartment(Long.valueOf(this.iDepartment.getWidget().getValue(this.iDepartment.getWidget().getSelectedIndex()))));
            if (this.iGroup.getDepartment() == null) {
                this.iDepartment.setErrorHint(MESSAGES.errorNoDepartmentSelected());
                result = false;
            }
        } else {
            this.iGroup.setDepartment(null);
        }
        return result;
    }

    public RoomInterface.GroupInterface getGroup() {
        return this.iGroup;
    }

    protected String generateAlsoUpdateMessage() {
        if (!this.iProperties.hasFutureSessions()) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (RoomInterface.AcademicSessionInterface session : this.iProperties.getFutureSessions()) {
            CheckBox ch = this.iFutureSessionsToggles.get(session.getId());
            if (ch == null || !ch.getValue().booleanValue()) continue;
            ret.add(session.getLabel());
        }
        if (!ret.isEmpty()) {
            return ToolBox.toString(ret);
        }
        return null;
    }

    protected void fillFutureFlags(RoomInterface.UpdateRoomGroupRequest request) {
        if (this.iProperties.hasFutureSessions()) {
            for (RoomInterface.AcademicSessionInterface session : this.iProperties.getFutureSessions()) {
                CheckBox ch = this.iFutureSessionsToggles.get(session.getId());
                if (ch == null) continue;
                Integer flags = RoomCookie.getInstance().getFutureFlags(session.getId());
                if (ch.getValue().booleanValue()) {
                    request.addFutureSession(session.getId());
                    if (flags != null) continue;
                    RoomCookie.getInstance().setFutureFlags(session.getId(), RoomInterface.FutureOperation.getFlagDefaultsEnabled());
                    continue;
                }
                if (flags == null) continue;
                RoomCookie.getInstance().setFutureFlags(session.getId(), null);
            }
        }
    }
}

