/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.unitime.timetable.solver.interactive.SuggestionsModel;

public class SuggestionsForm
extends ActionForm {
    private static final long serialVersionUID = 3222409910704167703L;
    private String iOp = null;
    private String iFilter = null;
    private boolean iShowFilter = false;
    private boolean iCanAllowBreakHard = false;
    private boolean iAllowBreakHard = false;
    private boolean iDisplayCBS = false;
    private boolean iDisplayPlacements = false;
    private boolean iSimpleMode = false;
    private int iLimit = 100;
    private int iDepth = 2;
    private long iTimeout = 5L;
    private Long iId = null;
    private String iFilterText = null;
    private boolean iTimeoutReached = false;
    private long iNrCombinationsConsidered = 0L;
    private long iNrSolutions = 0L;
    private long iNrSuggestions = 0L;
    private int iMinRoomSize = -1;
    private int iMaxRoomSize = -1;
    private boolean iDisplaySuggestions = false;
    private boolean iDisplayConfTable = false;
    private boolean iCanUnassign = false;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iFilter = SuggestionsModel.sFilters[0];
        this.iAllowBreakHard = false;
        this.iDisplayCBS = false;
        this.iCanAllowBreakHard = false;
        this.iShowFilter = false;
        this.iId = null;
        this.iTimeoutReached = false;
        this.iNrCombinationsConsidered = 0L;
        this.iNrSolutions = 0L;
        this.iNrSuggestions = 0L;
        this.iLimit = 100;
        this.iDisplayPlacements = false;
        this.iSimpleMode = false;
        this.iFilterText = null;
        this.iMinRoomSize = -1;
        this.iMaxRoomSize = -1;
        this.iDisplaySuggestions = false;
        this.iDisplayConfTable = false;
        this.iCanUnassign = false;
    }

    public void load(SuggestionsModel model) {
        this.iShowFilter = model.canDisplayFilter();
        this.iFilter = SuggestionsModel.sFilters[model.getFilter()];
        this.iCanAllowBreakHard = model.getCanAllowBreakHard();
        this.iAllowBreakHard = model.getAllowBreakHard();
        this.iDisplayCBS = model.getDisplayCBS();
        this.iDepth = model.getDepth();
        this.iTimeout = model.getTimeout();
        this.iId = model.getClassId();
        this.iTimeoutReached = model.getTimeoutReached();
        this.iNrSolutions = model.getNrSolutions();
        this.iNrCombinationsConsidered = model.getNrCombinationsConsidered();
        this.iNrSuggestions = model.getSuggestions() == null ? 0 : model.getSuggestions().size();
        this.iDisplayPlacements = model.getDisplayPlacements();
        this.iSimpleMode = model.getSimpleMode();
        this.iLimit = model.getLimit();
        this.iFilterText = model.getFilterText();
        this.iMinRoomSize = model.getMinRoomSize();
        this.iMaxRoomSize = model.getMaxRoomSize();
        this.iDisplayConfTable = model.getDisplayConfTable();
        this.iDisplaySuggestions = model.getDisplaySuggestions();
    }

    public void save(SuggestionsModel model) {
        model.setFilter(this.getFilterInt());
        model.setAllowBreakHard(this.getAllowBreakHard());
        model.setDisplayCBS(this.getDisplayCBS());
        model.setLimit(this.getLimit());
        model.setDisplayPlacements(this.getDisplayPlacements());
        model.setSimpleMode(this.getSimpleMode());
        model.setFilterText(this.getFilterText());
        model.setMinRoomSize(this.getMinRoomSize());
        model.setMaxRoomSize(this.getMaxRoomSize());
        model.setDisplayConfTable(this.getDisplayConfTable());
        model.setDisplaySuggestions(this.getDisplaySuggestions());
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getFilter() {
        return this.iFilter;
    }

    public void setFilter(String filter) {
        this.iFilter = filter;
    }

    public String[] getFilters() {
        return SuggestionsModel.sFilters;
    }

    public int getFilterInt() {
        for (int i = 0; i < SuggestionsModel.sFilters.length; ++i) {
            if (!SuggestionsModel.sFilters[i].equals(this.iFilter)) continue;
            return i;
        }
        return 0;
    }

    public boolean getAllowBreakHard() {
        return this.iAllowBreakHard;
    }

    public void setAllowBreakHard(boolean allowBreakHard) {
        this.iAllowBreakHard = allowBreakHard;
    }

    public boolean getDisplayCBS() {
        return this.iDisplayCBS;
    }

    public void setDisplayCBS(boolean displayCBS) {
        this.iDisplayCBS = displayCBS;
    }

    public boolean getDisplayPlacements() {
        return this.iDisplayPlacements;
    }

    public void setDisplayPlacements(boolean displayPlacements) {
        this.iDisplayPlacements = displayPlacements;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public boolean getSimpleMode() {
        return this.iSimpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.iSimpleMode = simpleMode;
    }

    public String getFilterText() {
        return this.iFilterText;
    }

    public void setFilterText(String text) {
        this.iFilterText = text;
    }

    public int getDepth() {
        return this.iDepth;
    }

    public void setDepth(int depth) {
        this.iDepth = depth;
    }

    public long getTimeout() {
        return this.iTimeout / 1000L;
    }

    public void setTimeout(long timeout) {
        this.iTimeout = 1000L * timeout;
    }

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public boolean getShowFilter() {
        return this.iShowFilter;
    }

    public void setShowFilter(boolean showFilter) {
        this.iShowFilter = showFilter;
    }

    public boolean getCanAllowBreakHard() {
        return this.iCanAllowBreakHard;
    }

    public void setCanAllowBreakHard(boolean canAllowBreakHard) {
        this.iCanAllowBreakHard = canAllowBreakHard;
    }

    public boolean getTimeoutReached() {
        return this.iTimeoutReached;
    }

    public long getNrCombinationsConsidered() {
        return this.iNrCombinationsConsidered;
    }

    public long getNrSolutions() {
        return this.iNrSolutions;
    }

    public long getNrSuggestions() {
        return this.iNrSuggestions;
    }

    public int getMinRoomSize() {
        return this.iMinRoomSize;
    }

    public int getMaxRoomSize() {
        return this.iMaxRoomSize;
    }

    public void setMinRoomSize(int minRoomSize) {
        this.iMinRoomSize = minRoomSize;
    }

    public void setMaxRoomSize(int maxRoomSize) {
        this.iMaxRoomSize = maxRoomSize;
    }

    public boolean getDisplayConfTable() {
        return this.iDisplayConfTable;
    }

    public void setDisplayConfTable(boolean displayConfTable) {
        this.iDisplayConfTable = displayConfTable;
    }

    public boolean getDisplaySuggestions() {
        return this.iDisplaySuggestions;
    }

    public void setDisplaySuggestions(boolean displaySuggestions) {
        this.iDisplaySuggestions = displaySuggestions;
    }

    public String getMinRoomSizeText() {
        return this.iMinRoomSize < 0 ? "" : String.valueOf(this.iMinRoomSize);
    }

    public String getMaxRoomSizeText() {
        return this.iMaxRoomSize < 0 ? "" : String.valueOf(this.iMaxRoomSize);
    }

    public void setMinRoomSizeText(String minRoomSizeText) {
        try {
            this.iMinRoomSize = Integer.parseInt(minRoomSizeText);
        }
        catch (NumberFormatException e) {
            this.iMinRoomSize = -1;
        }
    }

    public void setMaxRoomSizeText(String maxRoomSizeText) {
        try {
            this.iMaxRoomSize = Integer.parseInt(maxRoomSizeText);
        }
        catch (NumberFormatException e) {
            this.iMaxRoomSize = -1;
        }
    }

    public boolean isCanUnassign() {
        return this.iCanUnassign;
    }

    public void setCanUnassign(boolean canUnassign) {
        this.iCanUnassign = canUnassign;
    }
}

