/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.webutil.WebTextValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonUnivLocationForm
extends ActionForm {
    private String doit;
    private String name;
    private String externalId;
    private String capacity;
    private boolean ignoreTooFar;
    private boolean ignoreRoomCheck;
    private String deptCode;
    private int deptSize;
    private Long type;
    private String coordX;
    private String coordY;
    private String area;
    private static final long serialVersionUID = 683878933677076553L;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.name == null || this.name.equalsIgnoreCase("")) {
            errors.add("Name", new ActionMessage("errors.required", (Object)"Name"));
        } else {
            String nonUniversityLocationRegex = ApplicationProperty.NonUniversityLocationPattern.value();
            String nonUniversityLocationInfo = ApplicationProperty.NonUniversityLocationPatternInfo.value();
            if (nonUniversityLocationRegex != null && nonUniversityLocationRegex.trim().length() > 0) {
                try {
                    Pattern pattern = Pattern.compile(nonUniversityLocationRegex);
                    Matcher matcher = pattern.matcher(this.name);
                    if (!matcher.find()) {
                        errors.add("nonUniversityLocation", new ActionMessage("errors.generic", (Object)nonUniversityLocationInfo));
                    }
                }
                catch (Exception e) {
                    errors.add("nonUniversityLocation", new ActionMessage("errors.generic", (Object)("Non University Location cannot be matched to regular expression: " + nonUniversityLocationRegex + ". Reason: " + e.getMessage())));
                }
            } else if (!WebTextValidation.isTextValid(this.name, true)) {
                errors.add("nonUniversityLocation", new ActionMessage("errors.invalidCharacters", (Object)"Name"));
            }
        }
        if (this.capacity == null || this.capacity.equalsIgnoreCase("")) {
            errors.add("Capacity", new ActionMessage("errors.required", (Object)"Capacity"));
        }
        if (this.deptSize != 1 && (this.deptCode == null || this.deptCode.equalsIgnoreCase(""))) {
            errors.add("Department", new ActionMessage("errors.required", (Object)"Department"));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.name = "";
        this.ignoreTooFar = false;
        this.ignoreRoomCheck = false;
        this.coordX = null;
        this.coordY = null;
        this.area = null;
        this.externalId = null;
    }

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public boolean isIgnoreTooFar() {
        return this.ignoreTooFar;
    }

    public void setIgnoreTooFar(boolean ignoreTooFar) {
        this.ignoreTooFar = ignoreTooFar;
    }

    public boolean isIgnoreRoomCheck() {
        return this.ignoreRoomCheck;
    }

    public void setIgnoreRoomCheck(boolean ignoreRoomCheck) {
        this.ignoreRoomCheck = ignoreRoomCheck;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public void setDeptCode(String deptCode) {
        this.deptCode = deptCode;
    }

    public String getDoit() {
        return this.doit;
    }

    public void setDoit(String doit) {
        this.doit = doit;
    }

    public int getDeptSize() {
        return this.deptSize;
    }

    public void setDeptSize(int deptSize) {
        this.deptSize = deptSize;
    }

    public Long getType() {
        return this.type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    public Set<RoomType> getRoomTypes() {
        return RoomType.findAll(false);
    }

    public String getCoordX() {
        return this.coordX;
    }

    public void setCoordX(String coordX) {
        this.coordX = coordX;
    }

    public String getCoordY() {
        return this.coordY;
    }

    public void setCoordY(String coordY) {
        this.coordY = coordY;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }
}

