/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.form.ClassListFormInterface;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;

public class ClassAssignmentsReportForm
extends ActionForm
implements ClassListFormInterface {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 3257854294022959921L;
    private Collection classes;
    private Collection subjectAreas;
    private String[] subjectAreaIds;
    private String buttonAction;
    private String subjectAreaAbbv;
    private String ctrlInstrOfferingId;
    private String sortBy;
    private String filterAssignedRoom;
    private String filterManager;
    private String filterIType;
    private boolean filterAssignedTimeMon;
    private boolean filterAssignedTimeTue;
    private boolean filterAssignedTimeWed;
    private boolean filterAssignedTimeThu;
    private boolean filterAssignedTimeFri;
    private boolean filterAssignedTimeSat;
    private boolean filterAssignedTimeSun;
    private String filterAssignedTimeHour;
    private String filterAssignedTimeMin;
    private String filterAssignedTimeAmPm;
    private String filterAssignedTimeLength;
    private boolean sortByKeepSubparts;
    private boolean showCrossListedClasses;
    private boolean returnAllControlClassesForSubjects;
    private String[] userDeptIds;

    public String getCtrlInstrOfferingId() {
        return this.ctrlInstrOfferingId;
    }

    public void setCtrlInstrOfferingId(String ctrlInstrOfferingId) {
        this.ctrlInstrOfferingId = ctrlInstrOfferingId;
    }

    public String getSubjectAreaAbbv() {
        return this.subjectAreaAbbv;
    }

    public void setSubjectAreaAbbv(String subjectAreaAbbv) {
        this.subjectAreaAbbv = subjectAreaAbbv;
    }

    public String getButtonAction() {
        return this.buttonAction;
    }

    public void setButtonAction(String buttonAction) {
        this.buttonAction = buttonAction;
    }

    public String[] getSubjectAreaIds() {
        return this.subjectAreaIds;
    }

    public void setSubjectAreaIds(String[] subjectAreaIds) {
        this.subjectAreaIds = subjectAreaIds;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.init();
        LookupTables.setupItypes(request, true);
    }

    public void init() {
        this.classes = new ArrayList();
        this.subjectAreas = new ArrayList();
        this.subjectAreaIds = new String[0];
        this.sortBy = ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME);
        this.filterManager = "";
        this.filterAssignedRoom = "";
        this.filterIType = "";
        this.sortByKeepSubparts = false;
        this.filterAssignedTimeMon = false;
        this.filterAssignedTimeTue = false;
        this.filterAssignedTimeWed = false;
        this.filterAssignedTimeThu = false;
        this.filterAssignedTimeFri = false;
        this.filterAssignedTimeSat = false;
        this.filterAssignedTimeSun = false;
        this.filterAssignedTimeHour = "";
        this.filterAssignedTimeMin = "";
        this.filterAssignedTimeAmPm = "";
        this.filterAssignedTimeLength = "";
        this.returnAllControlClassesForSubjects = true;
        this.userDeptIds = new String[0];
        this.showCrossListedClasses = false;
    }

    public Collection getClasses() {
        return this.classes;
    }

    public void setClasses(Collection classes) {
        this.classes = classes;
    }

    public Collection getSubjectAreas() {
        return this.subjectAreas;
    }

    public void setSubjectAreas(Collection subjectAreas) {
        this.subjectAreas = subjectAreas;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        return errors;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String[] getSortByOptions() {
        return ClassCourseComparator.getNames();
    }

    public String getFilterManager() {
        return this.filterManager;
    }

    public void setFilterManager(String filterManager) {
        this.filterManager = filterManager;
    }

    public String getFilterAssignedRoom() {
        return this.filterAssignedRoom;
    }

    public void setFilterAssignedRoom(String filterAssignedRoom) {
        this.filterAssignedRoom = filterAssignedRoom;
    }

    public String getFilterInstructor() {
        return "";
    }

    public String getFilterIType() {
        return this.filterIType;
    }

    public void setFilterIType(String filterIType) {
        this.filterIType = filterIType;
    }

    public boolean getFilterAssignedTimeMon() {
        return this.filterAssignedTimeMon;
    }

    public void setFilterAssignedTimeMon(boolean filterAssignedTimeMon) {
        this.filterAssignedTimeMon = filterAssignedTimeMon;
    }

    public boolean getFilterAssignedTimeTue() {
        return this.filterAssignedTimeTue;
    }

    public void setFilterAssignedTimeTue(boolean filterAssignedTimeTue) {
        this.filterAssignedTimeTue = filterAssignedTimeTue;
    }

    public boolean getFilterAssignedTimeWed() {
        return this.filterAssignedTimeWed;
    }

    public void setFilterAssignedTimeWed(boolean filterAssignedTimeWed) {
        this.filterAssignedTimeWed = filterAssignedTimeWed;
    }

    public boolean getFilterAssignedTimeThu() {
        return this.filterAssignedTimeThu;
    }

    public void setFilterAssignedTimeThu(boolean filterAssignedTimeThu) {
        this.filterAssignedTimeThu = filterAssignedTimeThu;
    }

    public boolean getFilterAssignedTimeFri() {
        return this.filterAssignedTimeFri;
    }

    public void setFilterAssignedTimeFri(boolean filterAssignedTimeFri) {
        this.filterAssignedTimeFri = filterAssignedTimeFri;
    }

    public boolean getFilterAssignedTimeSat() {
        return this.filterAssignedTimeSat;
    }

    public void setFilterAssignedTimeSat(boolean filterAssignedTimeSat) {
        this.filterAssignedTimeSat = filterAssignedTimeSat;
    }

    public boolean getFilterAssignedTimeSun() {
        return this.filterAssignedTimeSun;
    }

    public void setFilterAssignedTimeSun(boolean filterAssignedTimeSun) {
        this.filterAssignedTimeSun = filterAssignedTimeSun;
    }

    public String getFilterAssignedTimeHour() {
        return this.filterAssignedTimeHour;
    }

    public void setFilterAssignedTimeHour(String filterAssignedTimeHour) {
        this.filterAssignedTimeHour = filterAssignedTimeHour;
    }

    public String getFilterAssignedTimeMin() {
        return this.filterAssignedTimeMin;
    }

    public void setFilterAssignedTimeMin(String filterAssignedTimeMin) {
        this.filterAssignedTimeMin = filterAssignedTimeMin;
    }

    public String getFilterAssignedTimeAmPm() {
        return this.filterAssignedTimeAmPm;
    }

    public void setFilterAssignedTimeAmPm(String filterAssignedTimeAmPm) {
        this.filterAssignedTimeAmPm = filterAssignedTimeAmPm;
    }

    public String getFilterAssignedTimeLength() {
        return "0".equals(this.filterAssignedTimeLength) ? "" : this.filterAssignedTimeLength;
    }

    public void setFilterAssignedTimeLength(String filterAssignedTimeLength) {
        this.filterAssignedTimeLength = filterAssignedTimeLength;
    }

    public String[] getFilterAssignedTimeHours() {
        return new String[]{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    }

    public String[] getFilterAssignedTimeMins() {
        return new String[]{"", "00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
    }

    public String[] getFilterAssignedTimeAmPms() {
        return new String[]{"", MSG.timeAm(), MSG.timePm()};
    }

    public String[] getFilterAssignedTimeLengths() {
        String[] ret = new String[41];
        ret[0] = "";
        for (int i = 1; i < ret.length; ++i) {
            ret[i] = String.valueOf(5 * i);
        }
        return ret;
    }

    public int getFilterDayCode() {
        int dayCode = 0;
        if (this.filterAssignedTimeMon) {
            dayCode += Constants.DAY_CODES[0];
        }
        if (this.filterAssignedTimeTue) {
            dayCode += Constants.DAY_CODES[1];
        }
        if (this.filterAssignedTimeWed) {
            dayCode += Constants.DAY_CODES[2];
        }
        if (this.filterAssignedTimeThu) {
            dayCode += Constants.DAY_CODES[3];
        }
        if (this.filterAssignedTimeFri) {
            dayCode += Constants.DAY_CODES[4];
        }
        if (this.filterAssignedTimeSat) {
            dayCode += Constants.DAY_CODES[5];
        }
        if (this.filterAssignedTimeSun) {
            dayCode += Constants.DAY_CODES[6];
        }
        return dayCode;
    }

    public void setFilterDayCode(int dayCode) {
        if (dayCode >= 0) {
            this.filterAssignedTimeMon = (dayCode & Constants.DAY_CODES[0]) != 0;
            this.filterAssignedTimeTue = (dayCode & Constants.DAY_CODES[1]) != 0;
            this.filterAssignedTimeWed = (dayCode & Constants.DAY_CODES[2]) != 0;
            this.filterAssignedTimeThu = (dayCode & Constants.DAY_CODES[3]) != 0;
            this.filterAssignedTimeFri = (dayCode & Constants.DAY_CODES[4]) != 0;
            this.filterAssignedTimeSat = (dayCode & Constants.DAY_CODES[5]) != 0;
            this.filterAssignedTimeSun = (dayCode & Constants.DAY_CODES[6]) != 0;
        } else {
            this.filterAssignedTimeMon = false;
            this.filterAssignedTimeTue = false;
            this.filterAssignedTimeWed = false;
            this.filterAssignedTimeThu = false;
            this.filterAssignedTimeFri = false;
            this.filterAssignedTimeSat = false;
            this.filterAssignedTimeSun = false;
        }
    }

    public int getFilterStartSlot() {
        try {
            boolean morn;
            int hour = Integer.parseInt(this.filterAssignedTimeHour);
            int min = Integer.parseInt(this.filterAssignedTimeMin);
            boolean bl = morn = !MSG.timePm().equals(this.filterAssignedTimeAmPm);
            if (hour == 12) {
                hour = 0;
            }
            int startTime = (hour + (morn ? 0 : 12)) % 24 * 60 + min;
            return (startTime - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }

    public void setFilterStartSlot(int startSlot) {
        if (startSlot >= 0) {
            int startMin = startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            int min = startMin % 60;
            int startHour = startMin / 60;
            boolean morn = startHour < 12;
            int hour = startHour % 12;
            if (hour == 0) {
                hour = 12;
            }
            this.filterAssignedTimeHour = String.valueOf(hour);
            this.filterAssignedTimeMin = (min < 10 ? "0" : "") + min;
            this.filterAssignedTimeAmPm = morn ? MSG.timeAm() : MSG.timePm();
        } else {
            this.filterAssignedTimeHour = "";
            this.filterAssignedTimeMin = "";
            this.filterAssignedTimeAmPm = "";
        }
    }

    public int getFilterLength() {
        try {
            return Integer.parseInt(this.filterAssignedTimeLength);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public void setFilterLength(int length) {
        this.filterAssignedTimeLength = length >= 0 ? String.valueOf(length) : "";
    }

    public String getCourseNbr() {
        return null;
    }

    public boolean getSortByKeepSubparts() {
        return this.sortByKeepSubparts;
    }

    public void setSortByKeepSubparts(boolean sortByKeepSubparts) {
        this.sortByKeepSubparts = sortByKeepSubparts;
    }

    public boolean isReturnAllControlClassesForSubjects() {
        return this.returnAllControlClassesForSubjects;
    }

    public void setReturnAllControlClassesForSubjects(boolean returnAllControlClassesForSubjects) {
        this.returnAllControlClassesForSubjects = returnAllControlClassesForSubjects;
    }

    public String[] getUserDeptIds() {
        return this.userDeptIds;
    }

    public void setUserDeptIds(String[] userDeptIds) {
        this.userDeptIds = userDeptIds;
    }

    public Boolean getDivSec() {
        return new Boolean(true);
    }

    public Boolean getDemand() {
        return new Boolean(false);
    }

    public Boolean getProjectedDemand() {
        return new Boolean(false);
    }

    public Boolean getMinPerWk() {
        return new Boolean(false);
    }

    public Boolean getLimit() {
        return new Boolean(true);
    }

    public Boolean getSnapshotLimit() {
        return new Boolean(false);
    }

    public Boolean getRoomLimit() {
        return new Boolean(false);
    }

    public Boolean getManager() {
        return new Boolean(false);
    }

    public Boolean getDatePattern() {
        return new Boolean(true);
    }

    public Boolean getTimePattern() {
        return new Boolean(false);
    }

    public Boolean getPreferences() {
        return new Boolean(false);
    }

    public Boolean getInstructor() {
        return new Boolean(false);
    }

    public Boolean getTimetable() {
        return new Boolean(true);
    }

    public Boolean getCredit() {
        return new Boolean(false);
    }

    public Boolean getSubpartCredit() {
        return new Boolean(false);
    }

    public Boolean getSchedulePrintNote() {
        return new Boolean(true);
    }

    public Boolean getNote() {
        return new Boolean(false);
    }

    public Boolean getConsent() {
        return new Boolean(false);
    }

    public Boolean getTitle() {
        return new Boolean(false);
    }

    public Boolean getExams() {
        return Boolean.FALSE;
    }

    public Boolean getCanSeeExams() {
        return Boolean.FALSE;
    }

    public boolean getShowCrossListedClasses() {
        return this.showCrossListedClasses;
    }

    public void setShowCrossListedClasses(boolean showCrossListedClasses) {
        this.showCrossListedClasses = showCrossListedClasses;
    }

    public boolean getIncludeCancelledClasses() {
        return false;
    }

    public Boolean getInstructorAssignment() {
        return false;
    }

    public boolean getFilterNeedInstructor() {
        return false;
    }
}

