/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.rooms;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.XLSPrinter;
import org.unitime.timetable.export.rooms.RoomsExportPDF;
import org.unitime.timetable.export.rooms.RoomsExporter;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.security.rights.Right;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="org.unitime.timetable.export.Exporter:rooms.xls")
public class RoomsExportXLS
extends RoomsExportPDF {
    @Override
    public String reference() {
        return "rooms.xls";
    }

    @Override
    protected void print(ExportHelper helper, List<RoomInterface.RoomDetailInterface> rooms, RoomsExporter.ExportContext context) throws IOException {
        helper.getSessionContext().hasPermission(Right.RoomsExportCsv);
        ArrayList<RoomsExporter.Column> columns = new ArrayList<RoomsExporter.Column>();
        for (RoomInterface.RoomsColumn column : RoomInterface.RoomsColumn.values()) {
            int nrCells = this.getNbrCells(column, context);
            for (int idx = 0; idx < nrCells; ++idx) {
                RoomsExporter.Column c = new RoomsExporter.Column(column, idx);
                if (!this.isColumnVisible(c, context)) continue;
                columns.add(c);
            }
        }
        context.setGridAsText(true);
        XLSPrinter printer = new XLSPrinter(helper.getOutputStream(), false);
        helper.setup(printer.getContentType(), this.reference(), true);
        String[] header = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            header[i] = this.getColumnName((RoomsExporter.Column)columns.get(i), context).replace("<br>", "\n");
        }
        printer.printHeader(header);
        printer.flush();
        for (RoomInterface.RoomDetailInterface room : rooms) {
            PDFPrinter.A[] row = new PDFPrinter.A[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                row[i] = this.getCell(room, (RoomsExporter.Column)columns.get(i), context);
            }
            printer.printLine(row);
            printer.flush();
        }
        printer.close();
    }

    @Override
    protected PDFPrinter.A getCell(RoomInterface.RoomDetailInterface room, RoomsExporter.Column column, RoomsExporter.ExportContext context) {
        switch (column.getColumn()) {
            case MAP: {
                if (room.hasMiniMapUrl()) {
                    try {
                        return new PDFPrinter.A(ImageIO.read(new URL(room.getMiniMapUrl()).openStream()));
                    }
                    catch (Exception e) {
                        return new PDFPrinter.A();
                    }
                }
                return new PDFPrinter.A();
            }
            case PICTURES: {
                RoomInterface.AttachmentTypeInterface type;
                RoomInterface.AttachmentTypeInterface attachmentTypeInterface = type = column.getIndex() == 0 ? null : context.getPictureTypes().get(column.getIndex() - 1);
                if (room.hasPictures(type)) {
                    PDFPrinter.A a = new PDFPrinter.A();
                    for (RoomInterface.RoomPictureInterface picture : room.getPictures(type)) {
                        a.add(new PDFPrinter.A(picture.getName(), new PDFPrinter.F[0]));
                    }
                    return a;
                }
                return new PDFPrinter.A();
            }
        }
        return super.getCell(room, column, context);
    }
}

