/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Date;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.util.Formats;

public class StudentSchedulingStatusExport
extends BaseExport {
    protected static Formats.Format<Number> sTwoNumbersDF = Formats.getNumberFormat("00");
    protected static Formats.Format<Date> sDateFormat = Formats.getDateFormat("yyyy/M/d");
    protected static Formats.Format<Date> sTimeFormat = Formats.getDateFormat("HHmm");

    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            Element root = document.addElement("studentStatuses");
            root.addAttribute("created", new Date().toString());
            root.addAttribute("dateFormat", sDateFormat.toPattern());
            root.addAttribute("timeFormat", sTimeFormat.toPattern());
            root.addAttribute("incremental", "true");
            document.addDocType("studentStatuses", "-//UniTime//UniTime Student Scheduling Statuses DTD/EN", "http://www.unitime.org/interface/StudentStatuses.dtd");
            for (StudentSectioningStatus status : this.getHibSession().createQuery("from StudentSectioningStatus order by reference").list()) {
                int min;
                int hour;
                Element statusElement = root.addElement("status");
                statusElement.addAttribute("reference", status.getReference());
                statusElement.addAttribute("name", status.getLabel());
                Element permissionsEl = statusElement.addElement("permissions");
                for (StudentSectioningStatus.Option option : StudentSectioningStatus.Option.values()) {
                    permissionsEl.addAttribute(StudentSchedulingStatusExport.getAttribute(option), status.hasOption(option) ? "true" : "false");
                }
                Element datesEl = null;
                if (status.getEffectiveStartDate() != null) {
                    if (datesEl == null) {
                        datesEl = statusElement.addElement("effective-dates");
                    }
                    datesEl.addAttribute("startDate", sDateFormat.format(status.getEffectiveStartDate()));
                }
                if (status.getEffectiveStartPeriod() != null) {
                    if (datesEl == null) {
                        datesEl = statusElement.addElement("effective-dates");
                    }
                    hour = status.getEffectiveStartPeriod() / 12;
                    min = 5 * (status.getEffectiveStartPeriod() % 12);
                    datesEl.addAttribute("startPeriod", sTwoNumbersDF.format(hour) + sTwoNumbersDF.format(min));
                }
                if (status.getEffectiveStopDate() != null) {
                    if (datesEl == null) {
                        datesEl = statusElement.addElement("effective-dates");
                    }
                    datesEl.addAttribute("stopDate", sDateFormat.format(status.getEffectiveStopDate()));
                }
                if (status.getEffectiveStopPeriod() != null) {
                    if (datesEl == null) {
                        datesEl = statusElement.addElement("effective-dates");
                    }
                    hour = status.getEffectiveStopPeriod() / 12;
                    min = 5 * (status.getEffectiveStopPeriod() % 12);
                    datesEl.addAttribute("stopPeriod", sTwoNumbersDF.format(hour) + sTwoNumbersDF.format(min));
                }
                if (status.getMessage() != null) {
                    statusElement.addElement("message").setText(status.getMessage());
                }
                for (CourseType type : status.getTypes()) {
                    statusElement.addElement("course").addAttribute("type", type.getReference());
                }
                if (status.getFallBackStatus() == null) continue;
                statusElement.addElement("fallback").addAttribute("reference", status.getFallBackStatus().getReference());
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    protected static String getAttribute(StudentSectioningStatus.Option option) {
        switch (option) {
            case enabled: {
                return "assistantEnabled";
            }
            case admin: {
                return "assistantAdminEdit";
            }
            case advisor: {
                return "assistantAdvisorEdit";
            }
            case enrollment: {
                return "assistantStudentEdit";
            }
            case regenabled: {
                return "requestsEnabled";
            }
            case regadmin: {
                return "requestsAdminEdit";
            }
            case regadvisor: {
                return "requestsAdvisorEdit";
            }
            case registration: {
                return "requestsStudentEdit";
            }
            case email: {
                return "emaiNotifications";
            }
            case nobatch: {
                return "doNotScheduleInBatch";
            }
            case notype: {
                return "mustHaveCourseType";
            }
            case waitlist: {
                return "waitListing";
            }
            case advcanset: {
                return "advisorCanSetStatus";
            }
            case specreg: {
                return "specialRegistration";
            }
            case reqval: {
                return "requestValidation";
            }
        }
        return option.name();
    }
}

