/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.api.BinaryFileApiHelper;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.model.SavedHQL;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ScriptDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.script.GetQueueTableBackend;
import org.unitime.timetable.server.script.ScriptExecution;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.util.queue.QueueItem;
import org.unitime.timetable.util.queue.QueueMessage;

@Service(value="/api/script")
public class ScriptConnector
extends ApiConnector {
    @Autowired
    SolverServerService solverServerService;

    public void doGet(ApiHelper helper) throws IOException {
        helper.getSessionContext().checkPermission(Right.Scripts);
        if (helper.getParameter("output") != null) {
            DataSource ds = this.solverServerService.getQueueProcessor().getFile(helper.getParameter("output"));
            if (ds == null) {
                helper.sendError(204, "No output found for task " + helper.getParameter("output"));
            } else {
                helper.setResponse(new BinaryFileApiHelper.BinaryFile(IOUtils.toByteArray((InputStream)ds.getInputStream()), ds.getContentType(), ds.getName()));
            }
        } else if (helper.getParameter("log") != null) {
            this.solverServerService.getQueueProcessor().get(helper.getParameter("log"));
            QueueItem item = this.solverServerService.getQueueProcessor().get(helper.getParameter("log"));
            if (item == null) {
                helper.sendError(204, "No task found for " + helper.getParameter("output"));
            } else {
                String log = "";
                for (QueueMessage m : item.getLog()) {
                    log = log + m.toString() + "\n";
                }
                helper.setResponse(new BinaryFileApiHelper.BinaryFile(log.getBytes(), "plain/text", item.getId() + ".log"));
            }
        } else if (helper.getParameter("id") != null) {
            this.solverServerService.getQueueProcessor().get(helper.getParameter("id"));
            QueueItem item = this.solverServerService.getQueueProcessor().get(helper.getParameter("id"));
            if (item == null) {
                helper.sendError(204, "No task found for " + helper.getParameter("output"));
            }
            helper.setResponse(GetQueueTableBackend.convert(item, helper.getSessionContext()));
        } else if (helper.getParameter("finished") != null) {
            this.solverServerService.getQueueProcessor().get(helper.getParameter("finished"));
            QueueItem item = this.solverServerService.getQueueProcessor().get(helper.getParameter("finished"));
            if (item == null) {
                helper.sendError(204, "No task found for " + helper.getParameter("output"));
            } else {
                helper.setResponse(new Boolean(item.finished() != null));
            }
        } else if (helper.getParameter("delete") != null) {
            Boolean ret = this.solverServerService.getQueueProcessor().remove(helper.getParameter("delete"));
            helper.setResponse(ret);
        } else if (helper.getParameter("script") != null) {
            this.doPost(helper);
        } else {
            List<QueueItem> items = this.solverServerService.getQueueProcessor().getItems(null, null, "Script");
            ArrayList<ScriptInterface.QueueItemInterface> converted = new ArrayList<ScriptInterface.QueueItemInterface>();
            if (items != null) {
                for (QueueItem item : items) {
                    converted.add(GetQueueTableBackend.convert(item, helper.getSessionContext()));
                }
            }
            helper.setResponse(converted);
        }
    }

    public void doPost(ApiHelper helper) throws IOException {
        QueueItem item;
        helper.getSessionContext().checkPermissionAnyAuthority(Right.Scripts, new Qualifiable[0]);
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId, helper.getHibSession());
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        String scriptName = helper.getParameter("script");
        if (scriptName == null) {
            throw new IllegalArgumentException("SCRIPT parameter not provided.");
        }
        Script script = (Script)ScriptDAO.getInstance().getSession().createQuery("from Script where name = :name").setString("name", scriptName).uniqueResult();
        if (script == null) {
            throw new IllegalArgumentException("Script " + scriptName + " does not exist.");
        }
        ScriptInterface.ExecuteScriptRpcRequest request = new ScriptInterface.ExecuteScriptRpcRequest();
        request.setScriptId(script.getUniqueId());
        request.setScriptName(script.getName());
        request.setEmail(helper.getParameter("email"));
        for (ScriptParameter parameter : script.getParameters()) {
            if ("file".equals(parameter.getType())) {
                BinaryFileApiHelper.BinaryFile file = (BinaryFileApiHelper.BinaryFile)helper.getRequest((Type)((Object)BinaryFileApiHelper.BinaryFile.class));
                if (file == null) {
                    throw new IllegalArgumentException("Input file not provided.");
                }
                helper.getSessionContext().setAttribute("LAST_FILE", (Object)new BinaryFileItem(file));
                continue;
            }
            String[] values = helper.getParameterValues(parameter.getName());
            if (values == null || values.length == 0) continue;
            String value = "";
            for (String v : values) {
                value = value + (value.isEmpty() ? "" : ",") + this.convertParameter(v, parameter.getType(), helper);
            }
            if (value == null) continue;
            request.setParameter(parameter.getName(), value);
        }
        if (!helper.getOptinalParameterBoolean("queue", true).booleanValue()) {
            item = new ScriptExecution(request, helper.getSessionContext());
            item.setId(UUID.randomUUID().toString());
            ((ScriptExecution)item).executeItem();
            if (item.hasOutput()) {
                FileInputStream is = new FileInputStream(item.output());
                helper.setResponse(new BinaryFileApiHelper.BinaryFile(IOUtils.toByteArray((InputStream)is), FileTypeMap.getDefaultFileTypeMap().getContentType(item.output()), item.getOutputName()));
                is.close();
            } else {
                String log = "";
                for (QueueMessage m : item.getLog()) {
                    log = log + m.toString() + "\n";
                }
                helper.setResponse(new BinaryFileApiHelper.BinaryFile(log.getBytes(), "plain/text", item.getId() + ".log"));
            }
        } else {
            item = this.solverServerService.getQueueProcessor().add(new ScriptExecution(request, helper.getSessionContext()));
            helper.setResponse(GetQueueTableBackend.convert(item, helper.getSessionContext()));
        }
    }

    protected String convertParameter(String value, String type, ApiHelper helper) {
        for (SavedHQL.Option option : SavedHQL.Option.values()) {
            if (!type.equalsIgnoreCase(option.name())) continue;
            Long id = option.lookupValue(helper.getSessionContext().getUser(), value);
            if (id == null) {
                try {
                    id = Long.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (id != null) {
                return id.toString();
            }
            throw new IllegalArgumentException(option.text() + " " + value + " not found.");
        }
        return value;
    }

    protected ApiHelper createHelper(HttpServletRequest request, HttpServletResponse response) {
        return new BinaryFileApiHelper(request, response, this.sessionContext, this.getCacheMode());
    }

    protected String getName() {
        return "script";
    }

    public static class BinaryFileItem
    implements FileItem {
        private static final long serialVersionUID = 1L;
        BinaryFileApiHelper.BinaryFile iFile;

        public BinaryFileItem(BinaryFileApiHelper.BinaryFile file) {
            this.iFile = file;
        }

        public void setHeaders(FileItemHeaders headers) {
        }

        public FileItemHeaders getHeaders() {
            return null;
        }

        public void write(File file) throws Exception {
        }

        public void setFormField(boolean state) {
        }

        public void setFieldName(String name) {
        }

        public boolean isInMemory() {
            return true;
        }

        public boolean isFormField() {
            return false;
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            return new String(this.iFile.getBytes(), encoding);
        }

        public String getString() {
            return new String(this.iFile.getBytes());
        }

        public long getSize() {
            return this.iFile.getBytes().length;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getName() {
            return this.iFile.getFileName();
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.iFile.getBytes());
        }

        public String getFieldName() {
            return null;
        }

        public String getContentType() {
            return this.iFile.getContentType();
        }

        public byte[] get() {
            return this.iFile.getBytes();
        }

        public void delete() {
        }
    }
}

