/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.stereotype.Service;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.api.XmlApiHelper;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.queue.QueueMessage;

@Service(value="/api/exchange")
public class DataExchangeConnector
extends ApiConnector {
    protected ApiHelper createHelper(HttpServletRequest request, HttpServletResponse response) {
        return new XmlApiHelper(request, response, this.sessionContext, this.getCacheMode());
    }

    public void doGet(ApiHelper helper) throws IOException {
        helper.getSessionContext().checkPermissionAnyAuthority(Right.ApiDataExchangeConnector, new Qualifiable[0]);
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId, helper.getHibSession());
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        String type = helper.getParameter("type");
        if (type == null) {
            throw new IllegalArgumentException("Export TYPE parameter not provided.");
        }
        ApplicationProperties.setSessionId(sessionId);
        try {
            helper.setResponse(DataExchangeHelper.exportDocument(type, session, ApplicationProperties.getProperties(), null));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void doPost(ApiHelper helper) throws IOException {
        helper.getSessionContext().checkPermissionAnyAuthority(Right.ApiDataExchangeConnector, new Qualifiable[0]);
        Document document = (Document)helper.getRequest((Type)((Object)Document.class));
        Document output = DocumentHelper.createDocument();
        final Element messages = output.addElement("html");
        try {
            DataExchangeHelper.importDocument(document, helper.getSessionContext().isAuthenticated() ? helper.getSessionContext().getUser().getExternalUserId() : null, new Log(){

                protected void log(QueueMessage.Level level, Object message, Throwable t) {
                    messages.addElement("p").setText(new QueueMessage(level, messages, t).toHTML());
                }

                public void warn(Object message, Throwable t) {
                    this.log(QueueMessage.Level.WARN, message, t);
                }

                public void warn(Object message) {
                    this.log(QueueMessage.Level.WARN, message, null);
                }

                public void trace(Object message, Throwable t) {
                    this.log(QueueMessage.Level.TRACE, message, t);
                }

                public void trace(Object message) {
                    this.log(QueueMessage.Level.TRACE, message, null);
                }

                public boolean isWarnEnabled() {
                    return true;
                }

                public boolean isTraceEnabled() {
                    return false;
                }

                public boolean isInfoEnabled() {
                    return true;
                }

                public boolean isFatalEnabled() {
                    return true;
                }

                public boolean isErrorEnabled() {
                    return true;
                }

                public boolean isDebugEnabled() {
                    return false;
                }

                public void info(Object message, Throwable t) {
                    this.log(QueueMessage.Level.INFO, message, t);
                }

                public void info(Object message) {
                    this.log(QueueMessage.Level.INFO, message, null);
                }

                public void fatal(Object message, Throwable t) {
                    this.log(QueueMessage.Level.FATAL, message, t);
                }

                public void fatal(Object message) {
                    this.log(QueueMessage.Level.FATAL, message, null);
                }

                public void error(Object message, Throwable t) {
                    this.log(QueueMessage.Level.ERROR, message, t);
                }

                public void error(Object message) {
                    this.log(QueueMessage.Level.ERROR, message, null);
                }

                public void debug(Object message, Throwable t) {
                    this.log(QueueMessage.Level.DEBUG, message, t);
                }

                public void debug(Object message) {
                    this.log(QueueMessage.Level.DEBUG, message, null);
                }
            });
            helper.setResponse(output);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected String getName() {
        return "exchange";
    }
}

