/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.RoomGroupEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Service(value="/roomGroupAdd")
public class RoomGroupAddAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RoomGroupEditForm roomGroupEditForm = (RoomGroupEditForm)form;
        MessageResources rsc = this.getResources(request);
        String doit = roomGroupEditForm.getDoit();
        if (doit != null) {
            if (doit.equals(rsc.getMessage("button.addNew"))) {
                ActionMessages errors = new ActionMessages();
                errors = roomGroupEditForm.validate(mapping, request);
                if (errors.size() == 0) {
                    this.save(mapping, roomGroupEditForm, request, response);
                    return mapping.findForward("showRoomGroupList");
                }
                this.saveErrors(request, errors);
            }
            if (doit.equals(rsc.getMessage("button.returnToRoomGroupList"))) {
                return mapping.findForward("showRoomGroupList");
            }
        }
        LookupTables.setupDepartments(request, this.sessionContext, false);
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        if (departments.size() == 1) {
            roomGroupEditForm.setDeptCode(departments.first().getDeptCode());
        } else {
            String deptCode = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom);
            if (!(deptCode == null || deptCode.isEmpty() || deptCode.equals("All") || deptCode.matches("Exam[0-9]*"))) {
                roomGroupEditForm.setDeptCode(deptCode);
            }
        }
        if (roomGroupEditForm.getDeptCode() == null || roomGroupEditForm.getDeptCode().isEmpty() || roomGroupEditForm.getDeptCode().matches("Exam[0-9]*") || !this.sessionContext.hasPermission((Serializable)((Object)roomGroupEditForm.getDeptCode()), "Department", Right.DepartmentRoomGroupAdd)) {
            this.sessionContext.checkPermission(Right.GlobalRoomGroupAdd);
            roomGroupEditForm.setGlobal(true);
        } else {
            this.sessionContext.checkPermission((Serializable)((Object)roomGroupEditForm.getDeptCode()), "Department", Right.DepartmentRoomGroupAdd);
            roomGroupEditForm.setGlobal(false);
        }
        roomGroupEditForm.setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
        return mapping.findForward("showAdd");
    }

    private void save(ActionMapping mapping, RoomGroupEditForm roomGroupEditForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Department d;
        Department department = d = roomGroupEditForm.isGlobal() ? null : Department.findByDeptCode(roomGroupEditForm.getDeptCode(), this.sessionContext.getUser().getCurrentAcademicSessionId());
        if (d == null) {
            this.sessionContext.checkPermission(Right.GlobalRoomGroupAdd);
        } else {
            this.sessionContext.checkPermission(d, Right.DepartmentRoomFeatureAdd);
        }
        RoomGroupDAO rgdao = new RoomGroupDAO();
        RoomGroup rg = new RoomGroup();
        rg.setName(roomGroupEditForm.getName());
        rg.setAbbv(roomGroupEditForm.getAbbv());
        rg.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        rg.setDescription(roomGroupEditForm.getDesc().length() > 200 ? roomGroupEditForm.getDesc().substring(0, 200) : roomGroupEditForm.getDesc());
        rg.setGlobal(d == null);
        rg.setDepartment(d);
        rg.setDefaultGroup(roomGroupEditForm.isDeft());
        org.hibernate.Session hibSession = rgdao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            this.checkDefault(hibSession, rg);
            hibSession.saveOrUpdate((Object)rg);
            ChangeLog.addChange(hibSession, this.sessionContext, rg, ChangeLog.Source.ROOM_GROUP_EDIT, ChangeLog.Operation.CREATE, null, rg.getDepartment());
            tx.commit();
            hibSession.refresh((Object)rg);
            request.setAttribute("hash", (Object)("A" + rg.getUniqueId()));
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public void checkDefault(org.hibernate.Session hibSession, RoomGroup rg) {
        if (!rg.isDefaultGroup().booleanValue()) {
            return;
        }
        for (RoomGroup x : RoomGroup.getAllRoomGroupsForSession(rg.getSession())) {
            if (x.getUniqueId().equals(rg.getUniqueId()) || !x.isDefaultGroup().booleanValue()) continue;
            x.setDefaultGroup(Boolean.FALSE);
            hibSession.saveOrUpdate((Object)x);
        }
    }
}

