/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.InstructorAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.base.BaseDepartment;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.BackTracker;

@Service(value="/instructorInfoEdit")
public class InstructorInfoEditAction
extends InstructorAction {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.execute(mapping, form, request, response);
        InstructorEditForm frm = (InstructorEditForm)form;
        ActionMessages errors = new ActionMessages();
        String instructorId = request.getParameter("instructorId");
        String op = frm.getOp();
        if (instructorId == null || instructorId.trim() == "") {
            throw new Exception(MSG.exceptionInstructorInfoNotSupplied());
        }
        this.sessionContext.checkPermission((Serializable)((Object)instructorId), "DepartmentalInstructor", Right.InstructorEdit);
        frm.setInstructorId(instructorId);
        if (op.equals(MSG.actionBackToDetail()) && instructorId != null && instructorId.trim() != "") {
            response.sendRedirect(response.encodeURL("instructorDetail.do?instructorId=" + instructorId));
            return null;
        }
        if (op.equals(MSG.actionLookupInstructor())) {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0) {
                this.findMatchingInstructor(frm, request);
                if (frm.getMatchFound() == null || !frm.getMatchFound().booleanValue()) {
                    errors.add("lookup", new ActionMessage("errors.generic", (Object)MSG.errorNoMatchingRecordsFound()));
                }
            }
            this.saveErrors(request, errors);
            return mapping.findForward("showEdit");
        }
        if ((op.equals(MSG.actionUpdateInstructor()) || op.equals(MSG.actionNextInstructor()) || op.equals(MSG.actionPreviousInstructor())) && instructorId != null && instructorId.trim() != "") {
            errors = frm.validate(mapping, request);
            if (errors.size() == 0 && this.isDeptInstructorUnique(frm, request)) {
                this.doUpdate(frm, request);
                if (op.equals(MSG.actionNextInstructor())) {
                    response.sendRedirect(response.encodeURL("instructorInfoEdit.do?instructorId=" + frm.getNextId()));
                    return null;
                }
                if (op.equals(MSG.actionPreviousInstructor())) {
                    response.sendRedirect(response.encodeURL("instructorInfoEdit.do?instructorId=" + frm.getPreviousId()));
                    return null;
                }
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showDetail"));
                redirect.addParameter("instructorId", (Object)frm.getInstructorId());
                return redirect;
            }
            if (errors.size() == 0) {
                errors.add("uniqueId", new ActionMessage("errors.generic", (Object)MSG.errorInstructorIdAlreadyExistsInList()));
            }
            this.saveErrors(request, errors);
        }
        if (op.equals(MSG.actionDeleteInstructor())) {
            this.doDelete(request, frm);
            return mapping.findForward("showList");
        }
        if (op.equals(MSG.actionSelectInstructor())) {
            String select = frm.getSearchSelect();
            if (select != null && select.trim().length() > 0) {
                if (select.equalsIgnoreCase("i2a2")) {
                    this.fillI2A2Info(frm, request);
                } else {
                    this.fillStaffInfo(frm, request);
                }
            }
            return mapping.findForward("showEdit");
        }
        this.doLoad(request, frm);
        BackTracker.markForBack(request, "instructorDetail.do?instructorId=" + frm.getInstructorId(), MSG.backInstructor(frm.getName() == null ? "null" : frm.getName().trim()), true, false);
        return mapping.findForward("showEdit");
    }

    private void doDelete(HttpServletRequest request, InstructorEditForm frm) throws Exception {
        String instructorId = frm.getInstructorId();
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        this.sessionContext.checkPermission((Serializable)((Object)instructorId), "DepartmentalInstructor", Right.InstructorDelete);
        Session hibSession = idao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(new Long(instructorId));
            ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_EDIT, ChangeLog.Operation.DELETE, null, inst.getDepartment());
            HashSet<Class_> updatedClasses = new HashSet<Class_>();
            for (ClassInstructor ci : inst.getClasses()) {
                Class_ c = ci.getClassInstructing();
                updatedClasses.add(c);
                c.getClassInstructors().remove(ci);
                hibSession.saveOrUpdate((Object)ci);
                hibSession.delete((Object)ci);
            }
            for (Exam exam : inst.getExams()) {
                exam.getInstructors().remove(inst);
                hibSession.saveOrUpdate((Object)exam);
            }
            for (Assignment a : inst.getAssignments()) {
                a.getInstructors().remove(inst);
                hibSession.saveOrUpdate((Object)a);
            }
            BaseDepartment d = null;
            if (inst.getDepartment() != null) {
                d = inst.getDepartment();
            }
            d.getInstructors().remove(inst);
            hibSession.delete((Object)inst);
            tx.commit();
            String className = ApplicationProperty.ExternalActionClassEdit.value();
            if (className != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).newInstance();
                for (Class_ c : updatedClasses) {
                    editAction.performExternalClassEditAction(c, hibSession);
                }
            }
            hibSession.clear();
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private void doLoad(HttpServletRequest request, InstructorEditForm frm) {
        String instructorId = frm.getInstructorId();
        DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
        DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(new Long(instructorId));
        frm.setInstructorId(instructorId);
        frm.setName(Constants.toInitialCase(inst.getFirstName(), "-".toCharArray()) + " " + (inst.getMiddleName() == null ? "" : Constants.toInitialCase(inst.getMiddleName(), "-".toCharArray())) + " " + Constants.toInitialCase(inst.getLastName(), "-".toCharArray()));
        if (inst.getFirstName() != null) {
            frm.setFname(inst.getFirstName().trim());
        }
        if (inst.getMiddleName() != null) {
            frm.setMname(inst.getMiddleName().trim());
        }
        frm.setLname(inst.getLastName().trim());
        frm.setTitle(inst.getAcademicTitle());
        String puid = inst.getExternalUniqueId();
        if (puid != null) {
            frm.setPuId(puid);
        }
        frm.setEmail(inst.getEmail());
        frm.setDeptName(inst.getDepartment().getName().trim());
        if (inst.getPositionType() != null) {
            frm.setPosType(inst.getPositionType().getUniqueId().toString());
        }
        if (inst.getCareerAcct() != null && inst.getCareerAcct().length() > 0) {
            frm.setCareerAcct(inst.getCareerAcct().trim());
        } else if (puid != null && !puid.isEmpty() && DepartmentalInstructor.canLookupInstructor()) {
            try {
                ExternalUidLookup.UserInfo user = DepartmentalInstructor.lookupInstructor(puid);
                if (user != null && user.getUserName() != null) {
                    frm.setCareerAcct(user.getUserName());
                } else {
                    frm.setCareerAcct("");
                }
            }
            catch (Exception user) {
                // empty catch block
            }
        }
        if (inst.getNote() != null) {
            frm.setNote(inst.getNote().trim());
        }
        frm.setIgnoreDist(inst.isIgnoreToFar() == null ? false : inst.isIgnoreToFar());
        try {
            DepartmentalInstructor previous = inst.getPreviousDepartmentalInstructor(this.sessionContext, Right.InstructorEdit);
            frm.setPreviousId(previous == null ? null : previous.getUniqueId().toString());
            DepartmentalInstructor next = inst.getNextDepartmentalInstructor(this.sessionContext, Right.InstructorEdit);
            frm.setNextId(next == null ? null : next.getUniqueId().toString());
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }
}

