/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.AssignedClassesForm;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.interactive.SuggestionsModel;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.PdfWebTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="/assignedClasses")
public class AssignedClassesAction
extends Action {
    public static DecimalFormat sDF = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PdfWebTable table;
        String assignedTable;
        List<ClassAssignmentDetails> assignedClasses;
        SuggestionsModel model;
        String op;
        block32: {
            StringTokenizer s;
            Session hibSession;
            SolutionDAO dao;
            String instructorNameFormat;
            String prefix;
            block29: {
                block31: {
                    AssignedClassesForm myForm;
                    block28: {
                        block30: {
                            myForm = (AssignedClassesForm)form;
                            this.sessionContext.checkPermission(Right.AssignedClasses);
                            op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
                            model = (SuggestionsModel)request.getSession().getAttribute("Suggestions.model");
                            if (model == null) {
                                model = new SuggestionsModel();
                                model.load(this.sessionContext.getUser());
                                request.getSession().setAttribute("Suggestions.model", (Object)model);
                            }
                            if ("Apply".equals(op) || "Export PDF".equals(op) || "Export CSV".equals(op)) {
                                myForm.save(model);
                                model.save(this.sessionContext.getUser());
                            }
                            if ("Refresh".equals(op)) {
                                myForm.reset(mapping, request);
                            }
                            myForm.load(model);
                            try {
                                myForm.setSubjectAreas(new TreeSet(SubjectArea.getSubjectAreaList(this.sessionContext.getUser().getCurrentAcademicSessionId())));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!"Apply".equals(op) && !"Export PDF".equals(op) && !"Export CSV".equals(op)) break block30;
                            if (myForm.getSubjectArea() == null) {
                                this.sessionContext.removeAttribute(SessionAttribute.OfferingsSubjectArea);
                                break block28;
                            } else if (myForm.getSubjectArea() < 0L) {
                                this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)Constants.ALL_OPTION_VALUE);
                                break block28;
                            } else {
                                this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)myForm.getSubjectArea().toString());
                            }
                            break block28;
                        }
                        try {
                            String sa = (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
                            if (Constants.ALL_OPTION_VALUE.equals(sa)) {
                                myForm.setSubjectArea(-1L);
                                break block28;
                            }
                            if (sa != null) {
                                if (sa.indexOf(44) >= 0) {
                                    sa = sa.substring(0, sa.indexOf(44));
                                }
                                myForm.setSubjectArea(Long.valueOf(sa));
                            }
                        }
                        catch (Exception sa) {
                            // empty catch block
                        }
                    }
                    if (myForm.getSubjectArea() == null && myForm.getSubjectAreas().size() == 1) {
                        myForm.setSubjectArea(((SubjectArea)myForm.getSubjectAreas().iterator().next()).getUniqueId());
                    }
                    assignedClasses = null;
                    if (myForm.getSubjectArea() == null || myForm.getSubjectArea() == 0L) break block31;
                    prefix = myForm.getSubjectArea() > 0L ? myForm.getSubjectAreaAbbv() + " " : null;
                    SolverProxy solver = this.courseTimetablingSolverService.getSolver();
                    if (solver != null) {
                        assignedClasses = solver.getAssignedClasses(prefix);
                        break block32;
                    } else {
                        instructorNameFormat = UserProperty.NameFormat.get(this.sessionContext.getUser());
                        String solutionIdsStr = (String)request.getSession().getAttribute("Solver.selectedSolutionId");
                        assignedClasses = new ArrayList<ClassAssignmentDetails>();
                        if (solutionIdsStr != null && solutionIdsStr.length() > 0) {
                            dao = new SolutionDAO();
                            hibSession = dao.getSession();
                            s = new StringTokenizer(solutionIdsStr, ",");
                            break block29;
                        } else {
                            request.setAttribute("AssignedClasses.message", (Object)"Neither a solver is started nor solution is selected.");
                            return mapping.findForward("showAssignedClasses");
                        }
                    }
                }
                request.setAttribute("AssignedClasses.message", (Object)"No subject area is selected.");
                return mapping.findForward("showAssignedClasses");
            }
            while (s.hasMoreTokens()) {
                Long solutionId = Long.valueOf(s.nextToken());
                Solution solution = (Solution)dao.get(solutionId, hibSession);
                try {
                    for (Assignment a : solution.getAssignments()) {
                        if (prefix != null && !a.getClassName().startsWith(prefix)) continue;
                        assignedClasses.add(new ClassAssignmentDetails(solution, a, false, hibSession, instructorNameFormat));
                    }
                }
                catch (ObjectNotFoundException e) {
                    hibSession.refresh((Object)solution);
                    for (Assignment a : solution.getAssignments()) {
                        assignedClasses.add(new ClassAssignmentDetails(solution, a, false, hibSession, instructorNameFormat));
                    }
                }
            }
        }
        if ((assignedTable = this.getAssignmentTable(model.getSimpleMode(), request, "Assigned Classes", assignedClasses)) != null) {
            request.setAttribute("AssignedClasses.table", (Object)assignedTable);
            request.setAttribute("AssignedClasses.table.colspan", (Object)new Integer(model.getSimpleMode() ? 6 : 15));
        } else {
            request.setAttribute("AssignedClasses.message", (Object)"No assigned class.");
        }
        if ("Export PDF".equals(op) && (table = this.exportPdf(model.getSimpleMode(), request, "Assigned Classes", assignedClasses)) != null) {
            ExportUtils.exportPDF(table, WebTable.getOrder(this.sessionContext, "assignedClasses.ord"), response, "assigned");
            return null;
        }
        if ("Export CSV".equals(op) && (table = this.exportPdf(model.getSimpleMode(), request, "Assigned Classes", assignedClasses)) != null) {
            ExportUtils.exportCSV(table, WebTable.getOrder(this.sessionContext, "assignedClasses.ord"), response, "assigned");
            return null;
        }
        return mapping.findForward("showAssignedClasses");
    }

    private static String dispNumberPdf(int number) {
        return AssignedClassesAction.dispNumberPdf("", number);
    }

    private static String dispNumberPdf(String prefix, int number) {
        if (number > 0) {
            return "@@COLOR FF0000 " + prefix + "+" + number + " @@END_COLOR ";
        }
        if (number < 0) {
            return "@@COLOR 00FF00 " + prefix + number + " @@END_COLOR ";
        }
        return prefix + "0";
    }

    private static String dispNumberPdf(double number) {
        return AssignedClassesAction.dispNumberPdf("", number);
    }

    private static String dispNumberPdf(String prefix, double number) {
        if (number > 0.0) {
            return "@@COLOR FF0000 " + prefix + "+" + sDF.format(number) + " @@END_COLOR ";
        }
        if (number < 0.0) {
            return "@@COLOR 00FF00 " + prefix + sDF.format(number) + " @@END_COLOR ";
        }
        return prefix + sDF.format(0.0);
    }

    public PdfWebTable exportPdf(boolean simple, HttpServletRequest request, String name, List<ClassAssignmentDetails> assignedClasses) {
        if (assignedClasses == null || assignedClasses.isEmpty()) {
            return null;
        }
        PdfWebTable webTable = simple ? new PdfWebTable(6, name, null, new String[]{"Class", "Date", "Time", "Room", "Instructor", "Students"}, new String[]{"left", "left", "left", "left", "left", "left"}, null) : new PdfWebTable(15, name, null, new String[]{"Class", "Date", "Time", "Room", "Instructor", "Std", "Tm", "Rm", "Gr", "Ins", "Usl", "Big", "Dept", "Subp", "Pert"}, new String[]{"left", "left", "left", "left", "left", "right", "right", "right", "right", "right", "right", "right", "right", "right", "right"}, null);
        try {
            for (ClassAssignmentDetails ca : assignedClasses) {
                int i;
                AssignmentPreferenceInfo ci = ca.getInfo();
                StringBuffer sb = new StringBuffer();
                if (ci.getNrCommitedStudentConflicts() != 0) {
                    if (sb.length() == 0) {
                        sb.append(" (");
                    } else {
                        sb.append(",");
                    }
                    sb.append(AssignedClassesAction.dispNumberPdf("c", ci.getNrCommitedStudentConflicts()));
                }
                if (ci.getNrDistanceStudentConflicts() != 0) {
                    if (sb.length() == 0) {
                        sb.append(" (");
                    } else {
                        sb.append(",");
                    }
                    sb.append(AssignedClassesAction.dispNumberPdf("d", ci.getNrDistanceStudentConflicts()));
                }
                if (ci.getNrHardStudentConflicts() != 0) {
                    if (sb.length() == 0) {
                        sb.append(" (");
                    } else {
                        sb.append(",");
                    }
                    sb.append(AssignedClassesAction.dispNumberPdf("h", ci.getNrHardStudentConflicts()));
                }
                if (sb.length() > 0) {
                    sb.append(")");
                }
                String rooms = "";
                if (ca.getAssignedRoom() != null) {
                    for (i = 0; i < ca.getAssignedRoom().length; ++i) {
                        if (i > 0) {
                            rooms = rooms + "@@COLOR 000000 , ";
                        }
                        rooms = rooms + "@@COLOR " + PreferenceLevel.int2color(ca.getAssignedRoom()[i].getPref()) + " " + ca.getAssignedRoom()[i].getName();
                    }
                } else if (ca.getRoom() != null) {
                    for (i = 0; i < ca.getRoom().length; ++i) {
                        if (i > 0) {
                            rooms = rooms + "@@COLOR 000000 , ";
                        }
                        rooms = rooms + "@@COLOR " + PreferenceLevel.int2color(ca.getRoom()[i].getPref()) + " " + ca.getRoom()[i].getName();
                    }
                }
                if (simple) {
                    String[] stringArray = new String[6];
                    stringArray[0] = "@@COLOR " + PreferenceLevel.prolog2color(ca.getClazz().getPref()) + " " + ca.getClazz().getName();
                    String string = ca.getTime() == null ? (ca.getAssignedTime() == null ? "" : "@@COLOR " + PreferenceLevel.int2color(ca.getAssignedTime().getDatePatternPreference()) + " " + ca.getAssignedTime().getDatePatternName()) : (stringArray[1] = "@@COLOR " + PreferenceLevel.int2color(ca.getTime().getDatePatternPreference()) + " " + ca.getTime().getDatePatternName());
                    stringArray[2] = ca.getTime() == null ? (ca.getAssignedTime() == null ? "" : "@@COLOR " + PreferenceLevel.int2color(ca.getAssignedTime().getPref()) + " " + ca.getAssignedTime().getDaysName() + " " + ca.getTime().getStartTime() + " - " + ca.getTime().getEndTime()) : "@@COLOR " + PreferenceLevel.int2color(ca.getTime().getPref()) + " " + ca.getTime().getDaysName() + " " + ca.getTime().getStartTime() + " - " + ca.getTime().getEndTime();
                    stringArray[3] = rooms;
                    stringArray[4] = ca.getInstructorName();
                    stringArray[5] = AssignedClassesAction.dispNumberPdf(ci.getNrStudentConflicts()) + sb;
                    webTable.addLine(null, stringArray, new Comparable[]{ca, ca.getDaysName(), ca.getTimeName(), ca.getRoomName(), ca.getInstructorName(), new Long(ci.getNrStudentConflicts())});
                    continue;
                }
                String[] stringArray = new String[15];
                stringArray[0] = "@@COLOR " + PreferenceLevel.prolog2color(ca.getClazz().getPref()) + " " + ca.getClazz().getName();
                String string = ca.getTime() == null ? (ca.getAssignedTime() == null ? "" : "@@COLOR " + PreferenceLevel.int2color(ca.getAssignedTime().getDatePatternPreference()) + " " + ca.getAssignedTime().getDatePatternName()) : (stringArray[1] = "@@COLOR " + PreferenceLevel.int2color(ca.getTime().getDatePatternPreference()) + " " + ca.getTime().getDatePatternName());
                stringArray[2] = ca.getTime() == null ? (ca.getAssignedTime() == null ? "" : "@@COLOR " + PreferenceLevel.int2color(ca.getAssignedTime().getPref()) + " " + ca.getAssignedTime().getDaysName() + " " + ca.getTime().getStartTime() + " - " + ca.getTime().getEndTime()) : "@@COLOR " + PreferenceLevel.int2color(ca.getTime().getPref()) + " " + ca.getTime().getDaysName() + " " + ca.getTime().getStartTime() + " - " + ca.getTime().getEndTime();
                stringArray[3] = rooms;
                stringArray[4] = ca.getInstructorName();
                stringArray[5] = AssignedClassesAction.dispNumberPdf(ci.getNrStudentConflicts()) + sb;
                stringArray[6] = AssignedClassesAction.dispNumberPdf(ci.getTimePreference());
                stringArray[7] = AssignedClassesAction.dispNumberPdf(ci.sumRoomPreference());
                stringArray[8] = AssignedClassesAction.dispNumberPdf(ci.getGroupConstraintPref());
                stringArray[9] = AssignedClassesAction.dispNumberPdf(ci.getBtbInstructorPreference());
                stringArray[10] = AssignedClassesAction.dispNumberPdf(ci.getUselessHalfHours());
                stringArray[11] = AssignedClassesAction.dispNumberPdf(ci.getTooBigRoomPreference());
                stringArray[12] = AssignedClassesAction.dispNumberPdf(ci.getDeptBalancPenalty());
                stringArray[13] = AssignedClassesAction.dispNumberPdf(ci.getSpreadPenalty());
                stringArray[14] = AssignedClassesAction.dispNumberPdf(ci.getPerturbationPenalty());
                webTable.addLine("onClick=\"showGwtDialog('Suggestions', 'suggestions.do?id=" + ca.getClazz().getClassId() + "&op=Reset','900','90%');\"", stringArray, new Comparable[]{ca, ca.getDaysName(), ca.getTimeName(), ca.getRoomName(), ca.getInstructorName(), new Long(ci.getNrStudentConflicts()), new Double(ci.getTimePreference()), new Long(ci.sumRoomPreference()), new Long(ci.getGroupConstraintPref()), new Long(ci.getBtbInstructorPreference()), new Long(ci.getUselessHalfHours()), new Long(ci.getTooBigRoomPreference()), new Double(ci.getDeptBalancPenalty()), new Double(ci.getSpreadPenalty()), new Double(ci.getPerturbationPenalty())});
            }
            return webTable;
        }
        catch (Exception e) {
            Debug.error(e);
            return null;
        }
    }

    public String getAssignmentTable(boolean simple, HttpServletRequest request, String name, List<ClassAssignmentDetails> assignedClasses) {
        if (assignedClasses == null || assignedClasses.isEmpty()) {
            return null;
        }
        WebTable.setOrder(this.sessionContext, "assignedClasses.ord", request.getParameter("ord"), 1);
        WebTable webTable = simple ? new WebTable(6, name, "assignedClasses.do?ord=%%", new String[]{"Class", "Date", "Time", "Room", "Instructor", "Students"}, new String[]{"left", "left", "left", "left", "left", "left"}, null) : new WebTable(15, name, "assignedClasses.do?ord=%%", new String[]{"Class", "Date", "Time", "Room", "Instructor", "Std", "Tm", "Rm", "Gr", "Ins", "Usl", "Big", "Dept", "Subp", "Pert"}, new String[]{"left", "left", "left", "left", "left", "right", "right", "right", "right", "right", "right", "right", "right", "right", "right"}, null);
        webTable.setRowStyle("white-space:nowrap");
        try {
            for (ClassAssignmentDetails ca : assignedClasses) {
                int i;
                AssignmentPreferenceInfo ci = ca.getInfo();
                StringBuffer sb = new StringBuffer();
                if (ci.getNrCommitedStudentConflicts() != 0) {
                    if (sb.length() == 0) {
                        sb.append(" (");
                    } else {
                        sb.append(",");
                    }
                    sb.append(ClassAssignmentDetails.dispNumber("c", ci.getNrCommitedStudentConflicts()));
                }
                if (ci.getNrDistanceStudentConflicts() != 0) {
                    if (sb.length() == 0) {
                        sb.append(" (");
                    } else {
                        sb.append(",");
                    }
                    sb.append(ClassAssignmentDetails.dispNumber("d", ci.getNrDistanceStudentConflicts()));
                }
                if (ci.getNrHardStudentConflicts() != 0) {
                    if (sb.length() == 0) {
                        sb.append(" (");
                    } else {
                        sb.append(",");
                    }
                    sb.append(ClassAssignmentDetails.dispNumber("h", ci.getNrHardStudentConflicts()));
                }
                if (sb.length() > 0) {
                    sb.append(")");
                }
                String rooms = "";
                if (ca.getAssignedRoom() != null) {
                    for (i = 0; i < ca.getAssignedRoom().length; ++i) {
                        if (i > 0) {
                            rooms = rooms + ", ";
                        }
                        rooms = rooms + ca.getAssignedRoom()[i].toHtml(false, false, true);
                    }
                } else if (ca.getRoom() != null) {
                    for (i = 0; i < ca.getRoom().length; ++i) {
                        if (i > 0) {
                            rooms = rooms + ", ";
                        }
                        rooms = rooms + ca.getRoom()[i].toHtml(false, false, true);
                    }
                }
                if (simple) {
                    webTable.addLine("onClick=\"showGwtDialog('Suggestions', 'suggestions.do?id=" + ca.getClazz().getClassId() + "&op=Reset','900','90%');\"", new String[]{ca.getClazz().toHtml(true, true), ca.getDaysHtml(), ca.getTime().toHtml(false, false, true, true), rooms, ca.getInstructorName(), ClassAssignmentDetails.dispNumber(ci.getNrStudentConflicts()) + sb}, new Comparable[]{ca, ca.getDaysName(), ca.getTimeName(), ca.getRoomName(), ca.getInstructorName(), new Long(ci.getNrStudentConflicts())});
                    continue;
                }
                webTable.addLine("onClick=\"showGwtDialog('Suggestions', 'suggestions.do?id=" + ca.getClazz().getClassId() + "&op=Reset','900','90%');\"", new String[]{ca.getClazz().toHtml(true, true), ca.getDaysHtml(), ca.getTime().toHtml(false, false, true, true), rooms, ca.getInstructorName(), ClassAssignmentDetails.dispNumber(ci.getNrStudentConflicts()) + sb, ClassAssignmentDetails.dispNumber(ci.getTimePreference()), ClassAssignmentDetails.dispNumber(ci.sumRoomPreference()), ClassAssignmentDetails.dispNumber(ci.getGroupConstraintPref()), ClassAssignmentDetails.dispNumber(ci.getBtbInstructorPreference()), ClassAssignmentDetails.dispNumber(ci.getUselessHalfHours()), ClassAssignmentDetails.dispNumber(ci.getTooBigRoomPreference()), ClassAssignmentDetails.dispNumber(ci.getDeptBalancPenalty()), ClassAssignmentDetails.dispNumber(ci.getSpreadPenalty()), ClassAssignmentDetails.dispNumber(ci.getPerturbationPenalty())}, new Comparable[]{ca, ca.getDaysName(), ca.getTimeName(), ca.getRoomName(), ca.getInstructorName(), new Long(ci.getNrStudentConflicts()), new Double(ci.getTimePreference()), new Long(ci.sumRoomPreference()), new Long(ci.getGroupConstraintPref()), new Long(ci.getBtbInstructorPreference()), new Long(ci.getUselessHalfHours()), new Long(ci.getTooBigRoomPreference()), new Double(ci.getDeptBalancPenalty()), new Double(ci.getSpreadPenalty()), new Double(ci.getPerturbationPenalty())});
            }
        }
        catch (Exception e) {
            Debug.error(e);
            webTable.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return webTable.printTable(WebTable.getOrder(this.sessionContext, "assignedClasses.ord"));
    }
}

