/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.NonUnivLocationForm;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.NonUniversityLocationDAO;
import org.unitime.timetable.model.dao.RoomTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LocationPermIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="/addNonUnivLocation")
public class AddNonUnivLocationAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NonUnivLocationForm nonUnivLocationForm = (NonUnivLocationForm)form;
        MessageResources rsc = this.getResources(request);
        ActionMessages errors = new ActionMessages();
        this.sessionContext.checkPermission(Right.AddNonUnivLocation);
        TreeSet<Department> departments = Department.getUserDepartments(this.sessionContext.getUser());
        if (nonUnivLocationForm.getDoit() != null) {
            String doit = nonUnivLocationForm.getDoit();
            if (doit.equals(rsc.getMessage("button.returnToRoomList"))) {
                return mapping.findForward("showRoomList");
            }
            if (doit.equals(rsc.getMessage("button.addNew"))) {
                errors = nonUnivLocationForm.validate(mapping, request);
                if (errors.isEmpty() && !this.sessionContext.hasPermission((Serializable)((Object)nonUnivLocationForm.getDeptCode()), "Department", Right.AddNonUnivLocation)) {
                    errors.add("nonUniversityLocation", new ActionMessage("errors.generic", (Object)"Acess denied."));
                }
                if (errors.size() == 0) {
                    this.update(request, nonUnivLocationForm);
                    return mapping.findForward("showRoomList");
                }
                this.setDepts(request, departments);
                this.saveErrors(request, errors);
                return mapping.findForward("showAdd");
            }
        }
        this.setDepts(request, departments);
        nonUnivLocationForm.setDeptSize(departments.size());
        if (departments.size() == 1) {
            Department d = (Department)departments.iterator().next();
            nonUnivLocationForm.setDeptCode(d.getDeptCode());
        } else if (this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom) != null) {
            nonUnivLocationForm.setDeptCode((String)this.sessionContext.getAttribute(SessionAttribute.DepartmentCodeRoom));
        }
        return mapping.findForward("showAdd");
    }

    private void update(HttpServletRequest request, NonUnivLocationForm nonUnivLocationForm) throws Exception {
        org.hibernate.Session hibSession = new NonUniversityLocationDAO().getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            NonUniversityLocation nonUniv = new NonUniversityLocation();
            nonUniv.setSession((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            if (nonUnivLocationForm.getName() != null && !nonUnivLocationForm.getName().trim().equalsIgnoreCase("")) {
                nonUniv.setName(nonUnivLocationForm.getName());
            }
            if (nonUnivLocationForm.getCapacity() != null && !nonUnivLocationForm.getCapacity().trim().equalsIgnoreCase("")) {
                nonUniv.setCapacity(Integer.valueOf(nonUnivLocationForm.getCapacity()));
            }
            nonUniv.setIgnoreTooFar(nonUnivLocationForm.isIgnoreTooFar());
            nonUniv.setIgnoreRoomCheck(nonUnivLocationForm.isIgnoreRoomCheck());
            nonUniv.setCoordinateX(nonUnivLocationForm.getCoordX() == null || nonUnivLocationForm.getCoordX().length() == 0 ? null : Double.valueOf(nonUnivLocationForm.getCoordX()));
            nonUniv.setCoordinateY(nonUnivLocationForm.getCoordY() == null || nonUnivLocationForm.getCoordY().length() == 0 ? null : Double.valueOf(nonUnivLocationForm.getCoordY()));
            if (nonUnivLocationForm.getExternalId() != null && !nonUnivLocationForm.getExternalId().isEmpty()) {
                nonUniv.setExternalUniqueId(nonUnivLocationForm.getExternalId());
            }
            Double area = null;
            if (nonUnivLocationForm.getArea() != null && !nonUnivLocationForm.getArea().isEmpty()) {
                try {
                    area = new DecimalFormat(ApplicationProperty.RoomAreaUnitsFormat.value()).parse(nonUnivLocationForm.getArea()).doubleValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            nonUniv.setArea(area);
            nonUniv.setFeatures(new HashSet<RoomFeature>());
            nonUniv.setAssignments(new HashSet<Assignment>());
            nonUniv.setRoomGroups(new HashSet<RoomGroup>());
            nonUniv.setRoomDepts(new HashSet<RoomDept>());
            nonUniv.setExamCapacity(0);
            nonUniv.setRoomType((RoomType)RoomTypeDAO.getInstance().get(nonUnivLocationForm.getType()));
            LocationPermIdGenerator.setPermanentId(nonUniv);
            hibSession.saveOrUpdate((Object)nonUniv);
            RoomDept rd = new RoomDept();
            rd.setRoom(nonUniv);
            rd.setControl(Boolean.TRUE);
            Department d = Department.findByDeptCode(nonUnivLocationForm.getDeptCode(), this.sessionContext.getUser().getCurrentAcademicSessionId(), hibSession);
            rd.setDepartment(d);
            hibSession.saveOrUpdate((Object)rd);
            nonUniv.getRoomDepts().add(rd);
            hibSession.saveOrUpdate((Object)nonUniv);
            ChangeLog.addChange(hibSession, this.sessionContext, nonUniv, ChangeLog.Source.ROOM_EDIT, ChangeLog.Operation.CREATE, null, d);
            tx.commit();
            hibSession.refresh((Object)d);
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    private void setDepts(HttpServletRequest request, Set<Department> departments) throws Exception {
        ArrayList<LabelValueBean> list = new ArrayList<LabelValueBean>();
        for (Department d : departments) {
            String code = d.getDeptCode().trim();
            String abbv = d.getName().trim();
            list.add(new LabelValueBean(code + " - " + abbv, code));
        }
        request.setAttribute(Department.DEPT_ATTR_NAME, list);
    }
}

