/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;

public class Choice {
    private Long iSectionId = null;
    private Long iSubpartId = null;
    private Long iConfigId = null;
    private Offering iOffering = null;
    private String iInstructionalType = null;
    private TimeLocation iTime = null;
    private List<Instructor> iInstructors = null;
    private int iHashCode;

    public Choice(Offering offering, String instructionalType, TimeLocation time, List<Instructor> instructors) {
        this.iOffering = offering;
        this.iInstructionalType = instructionalType;
        this.iTime = time;
        this.iInstructors = instructors;
        this.iHashCode = this.getId().hashCode();
    }

    @Deprecated
    public Choice(Offering offering, String instructionalType, TimeLocation time, String instructorIds, String instructorNames) {
        this(offering, instructionalType, time, Instructor.toInstructors(instructorIds, instructorNames));
    }

    public Choice(Section section) {
        this(section.getSubpart().getConfig().getOffering(), section.getSubpart().getInstructionalType(), section.getTime(), section.getInstructors());
        this.iSectionId = section.getId();
        this.iSubpartId = section.getSubpart().getId();
    }

    public Choice(Config config) {
        this(config.getOffering(), "N/A", null, null);
        this.iConfigId = config.getId();
    }

    public Choice(Offering offering, String choiceId) {
        this.iOffering = offering;
        String[] choices = choiceId.split("\\|");
        this.iInstructionalType = choices[0];
        if (choices.length > 1 && !choices[1].isEmpty()) {
            String[] times = choices[1].split(":");
            int dayCode = Integer.parseInt(times[0]);
            int startSlot = Integer.parseInt(times[1]);
            int length = Integer.parseInt(times[2]);
            Long datePatternId = times.length > 3 ? Long.valueOf(times[3]) : null;
            this.iTime = new TimeLocation(dayCode, startSlot, length, 0, 0.0, datePatternId, "N/A", new BitSet(), 0);
        }
        if (choices.length > 2 && !choices[2].isEmpty()) {
            this.iInstructors = new ArrayList<Instructor>();
            for (String id : choices[2].split(":")) {
                this.iInstructors.add(new Instructor(Long.parseLong(id)));
            }
        }
        if (choices.length > 3 && !choices[3].isEmpty()) {
            String[] ids = choices[3].split(":");
            this.iSectionId = ids.length < 1 || ids[0].isEmpty() ? null : Long.valueOf(ids[0]);
            this.iSubpartId = ids.length < 2 || ids[1].isEmpty() ? null : Long.valueOf(ids[1]);
            this.iConfigId = ids.length < 3 || ids[2].isEmpty() ? null : Long.valueOf(ids[2]);
        }
        this.iHashCode = this.getId().hashCode();
    }

    public Offering getOffering() {
        return this.iOffering;
    }

    public String getInstructionalType() {
        return this.iInstructionalType;
    }

    public TimeLocation getTime() {
        return this.iTime;
    }

    public boolean sameTime(Choice choice) {
        return this.getInstructionalType().equals(choice.getInstructionalType()) && Choice.sameTime(this.getTime(), choice.getTime());
    }

    private static boolean sameTime(TimeLocation t1, TimeLocation t2) {
        if (t1 == null) {
            return t2 == null;
        }
        if (t2 == null) {
            return false;
        }
        if (t1.getStartSlot() != t2.getStartSlot()) {
            return false;
        }
        if (t1.getLength() != t2.getLength()) {
            return false;
        }
        if (t1.getDayCode() != t2.getDayCode()) {
            return false;
        }
        return ToolBox.equals(t1.getDatePatternId(), t2.getDatePatternId());
    }

    @Deprecated
    public String getInstructorIds() {
        if (this.hasInstructors()) {
            StringBuffer sb = new StringBuffer();
            Iterator<Instructor> i = this.getInstructors().iterator();
            while (i.hasNext()) {
                Instructor instructor = i.next();
                sb.append(instructor.getId());
                if (!i.hasNext()) continue;
                sb.append(":");
            }
            return sb.toString();
        }
        return null;
    }

    @Deprecated
    public String getInstructorNames() {
        if (this.hasInstructors()) {
            StringBuffer sb = new StringBuffer();
            Iterator<Instructor> i = this.getInstructors().iterator();
            while (i.hasNext()) {
                Instructor instructor = i.next();
                if (instructor.getName() != null) {
                    sb.append(instructor.getName());
                } else if (instructor.getExternalId() != null) {
                    sb.append(instructor.getExternalId());
                }
                if (!i.hasNext()) continue;
                sb.append(":");
            }
            return sb.toString();
        }
        return null;
    }

    public String getInstructorNames(String delim) {
        if (this.iInstructors == null || this.iInstructors.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<Instructor> i = this.iInstructors.iterator();
        while (i.hasNext()) {
            Instructor instructor = i.next();
            sb.append(instructor.getName() != null ? instructor.getName() : (instructor.getExternalId() != null ? instructor.getExternalId() : "I" + instructor.getId()));
            if (!i.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public String getId() {
        String ret = this.getInstructionalType() + "|";
        if (this.getTime() != null) {
            ret = ret + this.getTime().getDayCode() + ":" + this.getTime().getStartSlot() + ":" + this.getTime().getLength() + (this.getTime().getDatePatternId() == null ? "" : ":" + this.getTime().getDatePatternId());
        }
        ret = ret + "|" + (this.hasInstructors() ? this.getInstructorIds() : "");
        ret = ret + "|" + (this.iSectionId == null ? "" : this.iSectionId) + ":" + (this.iSubpartId == null ? "" : this.iSubpartId) + ":" + (this.iConfigId == null ? "" : this.iConfigId);
        return ret;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Choice)) {
            return false;
        }
        return ((Choice)o).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.iHashCode;
    }

    public Set<Section> getSections() {
        HashSet<Section> sections = new HashSet<Section>();
        for (Config config : this.getOffering().getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                if (!subpart.getInstructionalType().equals(this.getInstructionalType())) continue;
                for (Section section : subpart.getSections()) {
                    if (!this.sameChoice(section)) continue;
                    sections.add(section);
                }
            }
        }
        return sections;
    }

    public Set<Section> getParentSections() {
        HashSet<Section> parentSections = new HashSet<Section>();
        for (Config config : this.getOffering().getConfigs()) {
            for (Subpart subpart : config.getSubparts()) {
                if (!subpart.getInstructionalType().equals(this.getInstructionalType()) || subpart.getParent() == null) continue;
                for (Section section : subpart.getSections()) {
                    if (!this.sameChoice(section) || section.getParent() == null) continue;
                    parentSections.add(section.getParent());
                }
            }
        }
        return parentSections;
    }

    public String getName() {
        return this.getOffering().getSubparts(this.getInstructionalType()).iterator().next().getName() + " " + (this.getTime() == null ? "" : this.getTime().getLongName(true)) + (this.hasInstructors() ? " " + this.getInstructorNames(",") : "");
    }

    public boolean sameInstructionalType(Section section) {
        return this.getInstructionalType() != null && this.getInstructionalType().equals(section.getSubpart().getInstructionalType());
    }

    public boolean sameTime(Section section) {
        return Choice.sameTime(this.getTime(), section.getTime());
    }

    public boolean sameInstructors(Section section) {
        return !this.hasInstructors() || section.hasInstructors() && section.getInstructors().containsAll(this.getInstructors());
    }

    public boolean sameChoice(Section section) {
        return this.sameInstructionalType(section) && this.sameTime(section) && this.sameInstructors(section);
    }

    public boolean sameSection(Section section) {
        return this.iSectionId != null && this.iSectionId.equals(section.getId());
    }

    public boolean sameSubart(Section section) {
        return this.iSubpartId != null && this.iSubpartId.equals(section.getSubpart().getId());
    }

    public boolean sameConfiguration(Section section) {
        return this.iConfigId != null && this.iConfigId.equals(section.getSubpart().getConfig().getId());
    }

    public boolean sameConfiguration(Enrollment enrollment) {
        return this.iConfigId != null && enrollment.getConfig() != null && this.iConfigId.equals(enrollment.getConfig().getId());
    }

    public boolean sameSection(Enrollment enrollment) {
        if (this.iSectionId == null || !enrollment.isCourseRequest()) {
            return false;
        }
        for (Section section : enrollment.getSections()) {
            if (!this.iSectionId.equals(section.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isMatching(Section section) {
        if (this.iConfigId != null) {
            return true;
        }
        if (this.iSubpartId != null && this.iSubpartId.equals(section.getSubpart().getId())) {
            return true;
        }
        return this.iSubpartId == null && this.iInstructionalType != null && this.iInstructionalType.equals(section.getSubpart().getInstructionalType());
    }

    public Long getSectionId() {
        return this.iSectionId;
    }

    public Long getSubpartId() {
        return this.iSubpartId;
    }

    public Long getConfigId() {
        return this.iConfigId;
    }

    public String toString() {
        return this.getName();
    }

    public List<Instructor> getInstructors() {
        return this.iInstructors;
    }

    public boolean hasInstructors() {
        return this.iInstructors != null && !this.iInstructors.isEmpty();
    }

    public int nrInstructors() {
        return this.iInstructors == null ? 0 : this.iInstructors.size();
    }
}

